% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_power_mvn.R
\name{sim_power_mvn}
\alias{sim_power_mvn}
\title{sim_power_mvn.R}
\usage{
sim_power_mvn(
  n,
  muVec,
  sigMat,
  nullSigMat = NULL,
  bounds = NULL,
  test = NULL,
  alpha
)
}
\arguments{
\item{n}{Number of simulations.}

\item{muVec}{Mean vector of test statistics under the alternative (assuming it's MVN).}

\item{sigMat}{Covariance matrix of test statistics under the alternative (assuming it's MVN).}

\item{nullSigMat}{Assumed correlation matrix of MVN under the null. Only need to specify if specifying test.}

\item{bounds}{A J*1 vector of bounds on the magnitudes of the test statistics, where
the first element is the bound for |Z|_(1) and the last element is the bound for |Z|_(J).}

\item{test}{Either "GHC", "HC", "GBJ", or "BJ" or NULL. If provided, will calculate
the p-value using the specified test and calculate power this way.}

\item{alpha}{Level of the test.}
}
\value{
A list with the elements:
\item{boundsPower}{Power from using bounds approach.}
\item{testPower}{Power from using specific test p-value approach.}
}
\description{
Simulate power of detection boundary tests starting from multivariate normal test statistics.
}
\examples{
myCov <- matrix(data=0.3, nrow=5, ncol=5)
diag(myCov) <- 1
myBounds <- set_GBJ_bounds(alpha = 0.01, J=5, sig_vec = myCov[lower.tri(myCov)])
sim_power_mvn(n=1000, muVec = c(1, 0, 0, 0, 0), sigMat = myCov, alpha=0.01)

}
