% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAMisc_functions.R
\name{sumStats}
\alias{sumStats}
\alias{sumStats.data.frame}
\alias{sumStats.survey.design}
\title{Summary Statistics}
\usage{
sumStats(
  data,
  vars,
  byvar = NULL,
  convertFactors = TRUE,
  weight = NULL,
  digits = 3
)
}
\arguments{
\item{data}{A data frame from which variables will be extracted.}

\item{vars}{A character vector of variable names.}

\item{byvar}{A character string giving a variable name of a stratifying variable.  The summaries of the \code{vars} will be provided for each level of \code{byvar}.}

\item{convertFactors}{Logical indicating whether factors should be converted to numeric first and then summarised.}

\item{weight}{If using a data frame (rather than a survey design object), specifying the name of a weighting variable will for the function to create a survey design with probability weights equal to the weight variable and then use the survey design object to make the summary.}

\item{digits}{Number of digits to print in the output.}
}
\value{
a vector of summary statistics for each variable or variable-group combination.
}
\description{
Provides summary statistics (mean, sd, quartiles, IQR, missing n, valid n)
for the variables in a data frame.
}
