% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAISIE_loglik_CS_time.R
\name{island_area_vector}
\alias{island_area_vector}
\title{Computes island_area, but takes vector as argument (needed by )}
\usage{
island_area_vector(
  timeval,
  area_pars,
  island_ontogeny,
  sea_level,
  total_time,
  peak
)
}
\arguments{
\item{timeval}{current time of simulation}

\item{area_pars}{A vector similar to list produced by create_area_pars
\itemize{
  \item{[1]: maximum area}
  \item{[2]: value from 0 to 1 indicating where in the island's history the
  peak area is achieved}
  \item{[3]: total island age}
}}

\item{island_ontogeny}{a string describing the type of island ontogeny. Can be \code{NULL},
\code{"beta"} for a beta function describing area through time.}

\item{sea_level}{a numeric describing the type of sea level.}
}
\description{
Computes island_area, but takes vector as argument (needed by )
}
\references{
Valente, Luis M., Rampal S. Etienne, and Albert B. Phillimore.
"The effects of island ontogeny on species diversity and phylogeny."
Proceedings of the Royal Society of London B: Biological Sciences 281.1784 (2014): 20133227.
}
\seealso{
Other rate calculations: 
\code{\link{DAISIE_plot_area}()},
\code{\link{get_ana_rate}()},
\code{\link{get_ext_rate}()},
\code{\link{get_immig_rate}()},
\code{\link{island_area}()},
\code{\link{update_max_rates}()},
\code{\link{update_rates}()}
}
\author{
Pedro Neves
}
\concept{rate calculations}
\keyword{internal}
