% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAISIE_plot_comparison_stts.R
\name{DAISIE_plot_comparison_stts}
\alias{DAISIE_plot_comparison_stts}
\title{Plot STT and overlay additional STT curves.}
\usage{
DAISIE_plot_comparison_stts(
  time,
  plot_lists_simulations,
  plot_lists_simulations_MLE,
  type,
  kind_of_plot = "line"
)
}
\arguments{
\item{time}{Numeric defining the length of the simulation in time units.
For example, if an island is known to be 4 million years old, setting
time = 4 will simulate the entire life span of the island; setting time = 2
will stop the simulation at the mid-life of the island.}

\item{plot_lists_simulations}{List with simulation output after parsing by
\code{DAISIE_prepare_data_plotting}.}

\item{plot_lists_simulations_MLE}{List with simulation output after parsing
by \code{DAISIE_prepare_data_plotting}, but obtained by simulating MLE
output.}

\item{type}{String to indicate if stt of all species or all possible stt
should be plotted. Default is \code{"all_species"}, \code{"type1_species"}
or \code{"type2_species"} should be plotted.}

\item{kind_of_plot}{Character vector stating how STT plot resulting from MLE
based simulations should be plotted. Default is \code{"line"} for multiple
individual lines. Can also be \code{"shade"} for the 5\% quantile.}
}
\value{
Standard \code{\link{DAISIE_plot_stt}} with overlaid additional
  STT curves for comparison.
}
\description{
Plot STT and overlay additional STT curves.
}
\seealso{
\code{\link{DAISIE_plot_sims}}, \code{\link{DAISIE_plot_stt}},
  \code{\link{DAISIE_convert_to_classic_plot}}
}
\author{
Pedro Neves
}
\concept{plotting}
\keyword{internal}
