% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAISIE_sim_trait_dependent.R
\name{DAISIE_sim_trait_dependent}
\alias{DAISIE_sim_trait_dependent}
\title{Simulate islands with given parameters.}
\usage{
DAISIE_sim_trait_dependent(
  time,
  M,
  pars,
  replicates,
  divdepmodel = "CS",
  nonoceanic_pars = c(0, 0),
  num_guilds = NULL,
  sample_freq = 25,
  plot_sims = TRUE,
  island_ontogeny = "const",
  sea_level = "const",
  hyper_pars = create_hyper_pars(d = 0, x = 0),
  area_pars = DAISIE::create_area_pars(max_area = 1, current_area = 1,
    proportional_peak_t = 0, total_island_age = 0, sea_level_amplitude = 0,
    sea_level_frequency = 0, island_gradient_angle = 0),
  extcutoff = 1000,
  verbose = TRUE,
  trait_pars = NULL,
  ...
)
}
\arguments{
\item{time}{Numeric defining the length of the simulation in time units.
For example, if an island is known to be 4 million years old, setting
time = 4 will simulate the entire life span of the island; setting time = 2
will stop the simulation at the mid-life of the island.}

\item{M}{Numeric defining the size of mainland pool, i.e. the number of
species that can potentially colonize the island.}

\item{pars}{A numeric vector containing the model parameters:
\itemize{
  \item{\code{pars[1]}: lambda^c (cladogenesis rate)}
  \item{\code{pars[2]}: mu (extinction rate)}
  \item{\code{pars[3]}: K (carrying capacity), set K=Inf for diversity
  independence.}
  \item{\code{pars[4]}: gamma (immigration rate)}
  \item{\code{pars[5]}: lambda^a (anagenesis rate)}
  \item{\code{pars[6]}: lambda^c (cladogenesis rate) for either type 2 species
  or rate set 2 in rate shift model}
  \item{\code{pars[7]}: mu (extinction rate) for either type 2 species or rate
  set 2 in rate shift model}
  \item{\code{pars[8]}: K (carrying capacity) for either type 2 species or rate
  set 2 in rate shift model, set K=Inf for diversity independence.}
  \item{\code{pars[9]}: gamma (immigration rate) for either type 2 species
  or rate set 2 in rate shift model}
  \item{\code{pars[10]}: lambda^a (anagenesis rate) for either type 2
  species or rate set 2 in rate shift model}
}
Elements 6:10 are required only when type 2 species are included
or in the rate shift model. For \code{\link{DAISIE_sim_relaxed_rate}()}
\code{pars[6]} is the standard deviation of the gamma distribution for the
relaxed parameter and the parameter chosen by the \code{relaxed_par}
argument is the mean of the gamma distribution for the relaxed parameter.}

\item{replicates}{Integer specifying number of island replicates to be
simulated.}

\item{divdepmodel}{Option divdepmodel = 'CS' runs a model with clade-specific
carrying capacity, where diversity-dependence operates only within single
clades, i.e. only among species originating from the same mainland
colonist. Option divdepmodel = 'IW' runs a model with island-wide
carrying capacity, where diversity-dependence operates within and among
clades. Option divdepmodel = 'GW' runs a model with diversity-dependence
operates within a guild.}

\item{nonoceanic_pars}{A vector of length two with:
\itemize{
  \item{[1]: the probability of sampling a species from the mainland}
  \item{[2]: the probability of the species sampled from the mainland
  being nonendemic}
}}

\item{num_guilds}{The number of guilds on the mainland. The number of
mainland species is divided by the number of guilds when
\code{divdepmodel = "GW"}}

\item{sample_freq}{Numeric specifing the number of units times should be
divided by for plotting purposes. Larger values will lead to plots with
higher resolution, but will also run slower.}

\item{plot_sims}{\code{Default = TRUE} plots species-through-time (STT)
plots. It detects how many types of species are present. If only one type
of species is present, STT is plotted for all species. If two types are
present, three plots are produced: STT for all, STT for type 1 and STT for
type 2.}

\item{island_ontogeny}{In \code{\link{DAISIE_sim_time_dependent}()},
\code{\link{DAISIE_ML_CS}} and plotting a string describing the type of
island ontogeny. Can be \code{"const"}, \code{"beta"} for a beta function
describing area through time. String checked by
\code{\link{is_island_ontogeny_input}()}. \cr In all other functions a
numeric describing the type of island ontogeny. Can be \code{0} for
constant, \code{1} for a beta function describing area through time. In ML
functions \code{island_ontogeny = NA} assumes constant ontogeny.}

\item{sea_level}{In \code{\link{DAISIE_sim_time_dependent}()} and plotting a
string describing the type of sea level. Can be \code{"const"} or
\code{"sine"} for a sine function describing area through time. String
checked by \code{\link{is_sea_level_input}()}.
\cr In all other functions a numeric describing the type of sea level. Can
be \code{0} for constant, \code{1} for a sine function describing area
through time.}

\item{hyper_pars}{A named list of numeric hyperparameters for the rate
calculations as returned by \code{\link{create_hyper_pars}()}:
\itemize{
  \item{[1]: is d the scaling parameter for exponent for calculating
  cladogenesis rate}
  \item{[2]: is x the exponent for calculating extinction rate}
}}

\item{area_pars}{A named list containing area and sea level parameters as
created by \code{\link{create_area_pars}()}:
\itemize{
  \item{[1]: maximum area}
  \item{[2]: current area}
  \item{[3]: value from 0 to 1 indicating where in the island's history the
  peak area is achieved}
  \item{[4]: total island age}
  \item{[5]: amplitude of area fluctuation from sea level}
  \item{[6]: frequency of sine wave of area change from sea level}
  \item{[7]: angle of the slope of the island}
}}

\item{extcutoff}{A numeric with the cutoff for the the maximum extinction
rate preventing it from being too large and slowing down simulation.}

\item{verbose}{In simulation and dataprep functions a logical,
\code{Default = TRUE} gives intermediate output should be printed.
For ML functions a numeric determining if intermediate output should be
printed, \code{Default = 0} does not print, \code{verbose = 1} prints
intermediate output of the parameters and loglikelihood, \code{verbose = 2}
means also intermediate progress during loglikelihood computation is shown.}

\item{trait_pars}{A named list containing diversification rates considering
two trait states created by \code{\link{create_trait_pars}}:
\itemize{
  \item{[1]:A numeric with the per capita transition rate with state1}
  \item{[2]:A numeric with the per capita immigration rate with state2}
  \item{[3]:A numeric with the per capita extinction rate with state2}
  \item{[4]:A numeric with the per capita anagenesis rate with state2}
  \item{[5]:A numeric with the per capita cladogenesis rate with state2}
  \item{[6]:A numeric with the per capita transition rate with state2}
  \item{[7]:A numeric with the number of species with trait state 2 on
   mainland}
}}

\item{...}{Any arguments to pass on to plotting functions.}
}
\value{
Each simulated dataset is an element of the list, which can be
called using [[x]]. For example if the object is called island_replicates,
the last replicates is a list in itself. The first (e.g.
\code{island_replicates[[x]][[1]]}) element of that list has the following
components: \cr \code{$island_age} - the island age \cr Then, depending on
whether a distinction between types is made, we have:\cr \code{$not_present}
- the number of mainland lineages that are not present on the island \cr
or:\cr \code{$not_present_type1} - the number of mainland lineages of type 1
that are not present on the island \cr \code{$not_present_type2} - the
number of mainland lineages of type 2 that are not present on the island \cr
\code{$stt_all} - STT table for all species on the island (nI - number of
non-endemic species; nA - number of anagenetic species, nC - number of
cladogenetic species, present - number of independent colonisations present
)\cr \code{$stt_stt_type1} - STT table for type 1 species on the island -
only if 2 types of species were simulated (nI - number of non-endemic
species; nA - number of anagenetic species, nC - number of cladogenetic
species, present - number of independent colonisations present )\cr
\code{$stt_stt_type2} - STT table for type 2 species on the island - only if
2 types of species were simulated (nI - number of non-endemic species; nA -
number of anagenetic species, nC - number of cladogenetic species, present -
number of independent colonisations present )\cr \code{$brts_table} - Only
for simulations under 'IW'. Table containing information on order of events
in the data, for use in maximum likelihood optimization.)\cr

The subsequent elements of the list each contain information on a single
colonist lineage on the island and has 4 components:\cr
\code{$branching_times} - island age and stem age of the population/species
in the case of Non-endemic, Non-endemic_MaxAge and Endemic anagenetic
species. For cladogenetic species these should be island age and branching
times of the radiation including the stem age of the radiation.\cr
\code{$stac} - the status of the colonist \cr * Non_endemic_MaxAge: 1 \cr *
ndemic: 2 \cr * Endemic&Non_Endemic: 3 \cr * Non_endemic: 4 \cr
\code{$missing_species} - number of island species that were not sampled for
particular clade (only applicable for endemic clades) \cr \code{$type_1or2}
- whether the colonist belongs to type 1 or type 2 \cr
}
\description{
This function simulates islands with given cladogenesis,
extinction, Kprime, immigration and anagenesis parameters. If a single
parameter set is provided (5 parameters) it simulates islands where all
species have the same macro-evolutionary process. If two paramater sets
(10 parameters) are provided, it simulates islands where two different
macro-evolutionary processes operate, one applying to type 1 species and
other to type 2 species. If two parameter sets and a time shift (11
parameters) are provided, it simulates islands where at the given time
a shift between the parameter sets will occur.

Returns R list object that contains the simulated islands
}
\references{
Valente, L.M., A.B. Phillimore and R.S. Etienne (2015).
Equilibrium and non-equilibrium dynamics simultaneously operate in the
Galapagos islands. Ecology Letters 18: 844-852.
Hauffe, T., D. Delicado, R.S. Etienne and L. Valente (submitted).
Lake expansion increases equilibrium diversity via the target effect of
island biogeography.
}
\seealso{
\code{\link{DAISIE_format_CS}} \code{\link{DAISIE_plot_sims}}
}
\author{
Luis Valente and Albert Phillimore
}
\keyword{models}
