% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.heuristics.FisherTestHeuristic.R
\name{FisherTestHeuristic}
\alias{FisherTestHeuristic}
\title{Feature-clustering based on Fisher's Exact Test.}
\description{
Performs feature-clustering based on Fisher's exact test for
testing the null of independence of rows and columns in a contingency table
with fixed marginals.
}
\seealso{
\code{\link{Dataset}}, \code{\link[stats]{fisher.test}}
}
\keyword{cluster}
\keyword{manip}
\section{Super class}{
\code{\link[D2MCS:GenericHeuristic]{D2MCS::GenericHeuristic}} -> \code{FisherTestHeuristic}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{FisherTestHeuristic$new()}}
\item \href{#method-heuristic}{\code{FisherTestHeuristic$heuristic()}}
\item \href{#method-clone}{\code{FisherTestHeuristic$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Empty function used to initialize the object arguments in
runtime.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FisherTestHeuristic$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-heuristic"></a>}}
\if{latex}{\out{\hypertarget{method-heuristic}{}}}
\subsection{Method \code{heuristic()}}{
Performs the Fisher's exact test for testing the null of
independence between two columns (col1 and col2).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FisherTestHeuristic$heuristic(col1, col2, column.names = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{col1}}{A \link{numeric} vector or matrix required to perform the
clustering operation.}

\item{\code{col2}}{A \link{numeric} vector or matrix to perform the clustering
operation.}

\item{\code{column.names}}{An optional \link{character} vector with the names of
both columns.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \link{numeric} vector of length 1 or \link{NA} if an error
occurs.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FisherTestHeuristic$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
