% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsestats.R
\name{parsestats}
\alias{parsestats}
\title{Takes the results of a call to statistics.general and returns a matrix of raw medians with columns corresponding to fcs files and rows to molecules of interest in different cell types}
\usage{
parsestats(results, popsinterest, fcs, markersofinterest)
}
\arguments{
\item{results}{- The results of a call to statistics.general function}

\item{popsinterest}{- List of gateSetID numbers for populations of interest with descriptions as name}

\item{fcs}{- List of fcs file IDs of interest with description of FCS file names as names}

\item{markersofinterest}{- List of ID numbers for markers of interest with descriptions as name}
}
\value{
Returns a matrix of median signaling intensities with columns corresponding to fcs files and rows corresponding to markers of interest in cell types of interest
}
\description{
Takes the results of a call to statistics.general and returns a matrix of raw medians with columns corresponding to fcs files and rows to molecules of interest in different cell types
}
\examples{
\donttest{
library(CytobankAPI)

cyto_session <- authenticate(site="premium", username="myusername", password="mypassword")
exptno<-2
popsofinterest1<-c("CD4 T cells","NK cells")
popsinterest<-getpops(popsofinterest1,exptno,cyto_session)
fcs<-getfcsfiles(exptno,cyto_session)
markersofinterest1<-c("CD3","CD56")
markersofinterest<-getmarkers(markersofinterest1,exptno,cyto_session)
results<-statistics.general(UserSession=cyto_session, experiment_id=2, gate_version = -1, 
compensation_id=1,fcs_files=fcs, populations = popsinterest,
output = "default",timeout = UserSession@long_timeout)
parsestats(results,popsinterest,fcs,markersofinterest)}
}
