% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quaternary.R
\name{plotQuaternary}
\alias{plotQuaternary}
\alias{plotQuaternary.default}
\alias{plotQuaternary.Seurat}
\alias{plotQuaternary.SingleCellExperiment}
\alias{plotQuaternary.simMat}
\title{Create quaternary simplex plots}
\usage{
plotQuaternary(x, ...)

\method{plotQuaternary}{default}(
  x,
  clusterVar,
  vertices,
  features = NULL,
  veloGraph = NULL,
  byCluster = NULL,
  processed = FALSE,
  method = c("euclidean", "cosine", "pearson", "spearman"),
  force = FALSE,
  sigma = 0.05,
  scale = TRUE,
  dotColor = "grey60",
  returnData = FALSE,
  ...
)

\method{plotQuaternary}{Seurat}(
  x,
  layer = "counts",
  assay = NULL,
  clusterVar = NULL,
  processed = FALSE,
  ...
)

\method{plotQuaternary}{SingleCellExperiment}(
  x,
  assay.type = "counts",
  clusterVar = NULL,
  processed = FALSE,
  ...
)

\method{plotQuaternary}{simMat}(
  x,
  veloMat = NULL,
  nGrid = 10,
  radius = 0.2,
  dotSize = 0.6,
  dotColor = "grey60",
  labelColors = c("#3B4992FF", "#EE0000FF", "#008B45FF", "#631879FF"),
  arrowLinewidth = 0.6,
  arrowAngle = 20,
  arrowLen = 0.1,
  vertexLabelSize = 1,
  edgeLinewidth = 1,
  title = NULL,
  titleSize = 1,
  titleColor = "black",
  theta = 20,
  phi = 0,
  interactive = FALSE,
  ...
)
}
\arguments{
\item{x}{Input data. Can be a \code{matrix} or \code{dgCMatrix} object with
cells as columns, a \code{Seurat} or \code{SingleCellExperiment} object.
"simMat" method takes intermediate values.}

\item{...}{Arguments passed to other methods.}

\item{clusterVar}{A vector/factor assigning the cluster variable to each
column of the matrix object. For "Seurat" method, \code{NULL} (default) for
\code{Idents(x)}, or a variable name in \code{meta.data} slot. For
"SingleCellExperiment" method, \code{NULL} (default) for \code{colLabels(x)},
or a variable name in \code{colData} slot.}

\item{vertices}{Vector of three unique cluster names that will be used for
plotting. Or a named list that groups clusters as three terminal vertices.
There must not be any overlap between groups.}

\item{features}{Valid matrix row subsetting index to select features for
similarity calculation. Default \code{NULL} uses all available features.}

\item{veloGraph}{Cell x cell \code{dgCMatrix} object containing velocity
information. Shows velocity grid-arrow layer when specified. Default
\code{NULL} does not show velocity.}

\item{byCluster}{Default \code{NULL} to generate one plot with all cells.
Set \code{"all"} to split cells in plot by cluster and returns a list of
subplots for each cluster as well as the plot including all cells. Otherwise,
a vector of cluster names to generate a list of subplots for the specified
clusters.}

\item{processed}{Logical. Whether the input matrix is already processed.
\code{TRUE} will bypass internal preprocessing and input matrix will be
directly used for similarity calculation. Default \code{FALSE} and raw count
input is recommended. If missing in call, using \code{slot = "counts"} in
"Seurat" method or using \code{assay.type = "counts"} in
"SingleCellExperiment" method will force this argument to be \code{FALSE} and
others for \code{TRUE}.}

\item{method}{Similarity calculation method. Default \code{"euclidean"}.
Choose from \code{"euclidean"}, \code{"cosine"}, \code{"pearson"},
\code{"spearman"}.}

\item{force}{Whether to force calculate the similarity when more then 500
features are detected, which is generally not recommended. Default
\code{FALSE}.}

\item{sigma}{Gaussian kernel parameter that controls the effect of variance.
Only effective when using a distance metric (i.e. \code{method} is
\code{"euclidian"} or \code{"cosine"}). Larger values tighten the dot
spreading on figure. Default \code{0.05}.}

\item{scale}{Whether to min-max scale the distance matrix by clusters.
Default \code{TRUE}.}

\item{returnData}{Logical. Whether to return similarity and aggregated
velocity data if applicable instead of generating plot. Default \code{FALSE}.}

\item{layer}{For "Seurat" method, which layer of the assay to be used.
Default \code{"counts"}.}

\item{assay}{For "Seurat" method, the specific assay to get data from.
Default \code{NULL} to the default assay.}

\item{assay.type}{For "SingleCellExperiment" methods. Which assay to use for
calculating the similarity. Default \code{"counts"}.}

\item{veloMat}{Aggregated velocity matrix. Output of \code{aggrVeloGraph}.}

\item{nGrid}{Number of grids along the x-axis of the tetrahedron
triangle. Default \code{10}.}

\item{radius}{Arrow length of unit velocity. Lower this when arrows point
outside of the tetrahedron. Default \code{0.2}.}

\item{dotSize, dotColor}{Dot aesthetics. Default \code{0.6} and
\code{"grey60"}.}

\item{labelColors}{Colors of the vertex labels. Default
\code{c("#3B4992FF", "#EE0000FF", "#008B45FF", "#631879FF")} (blue, red,
green and purple).}

\item{arrowLinewidth}{Arrow aesthetics. Default \code{0.6}.}

\item{arrowAngle, arrowLen}{Arrow aesthetics passed to
\code{grid::\link[grid]{arrow}}. The length of the arrow will be internally
converted to unit onject in inches. Default \code{20} and \code{0.1}.}

\item{vertexLabelSize}{Numeric, size of vertex text label relative to default
size. Default \code{1}.}

\item{edgeLinewidth}{Controls the linewidth of the edges of the tetrahedron.
Default \code{1}.}

\item{title}{Title text of the plot. Default \code{NULL}.}

\item{titleSize, titleColor}{Setting on the main title text. Default \code{1},
and \code{"black"}.}

\item{theta, phi}{Numeric scalar. The angles defining the viewing direction.
\code{theta} gives the azimuthal direction and \code{phi} the colatitude.
Default \code{20} and \code{0}.}

\item{interactive}{Logical. Whether to use "rgl" library to create
interactive device. Default \code{FALSE}.}
}
\value{
For "simMat" method, a "plist" (plot3D package product) object. For
other methods, a "plist" object when \code{splitCluster = FALSE}, or a list
of "plist" objects when \code{splitCluster = TRUE}. A "plist" object can be
viewed with \code{print()}, \code{show()} or a direct run of the object
variable name in interactive console.
}
\description{
Create quaternary plots that show similarity between single cells and
selected four terminals in a baricentric coordinate.

See \code{\link{plotTernary}} for more details on methodologies.

A dynamic rotating view in a GIF image file can be created with
\code{\link{writeQuaternaryGIF}}. Package \code{magick} must be installed in
advance. Linux users may refer to this
\href{https://cran.r-project.org/package=magick/vignettes/intro.html#Build_from_source}{installation guide}.
}
\examples{
gene <- selectTopFeatures(rnaRaw, rnaCluster, c("RE", "OS", "CH", "ORT"))
plotQuaternary(rnaRaw, rnaCluster, c("RE", "OS", "CH", "ORT"), gene)
\donttest{
# Seurat example
library(Seurat)
srt <- CreateSeuratObject(rnaRaw)
Idents(srt) <- rnaCluster
gene <- selectTopFeatures(srt, vertices = c("OS", "RE", "CH", "ORT"))
plotQuaternary(srt, features = gene,
               vertices = c("OS", "RE", "CH", "ORT"))
}
\donttest{
# SingleCellExperiment example
library(SingleCellExperiment)
sce <- SingleCellExperiment(assays = list(counts = rnaRaw))
colLabels(sce) <- rnaCluster
gene <- selectTopFeatures(sce, vertices = c("OS", "RE", "CH", "ORT"))
plotQuaternary(sce, features = gene,
               vertices = c("OS", "RE", "CH", "ORT"))
}
}
