% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cyt_errbp.R
\name{cyt_errbp}
\alias{cyt_errbp}
\title{Error-bar Plot.}
\usage{
cyt_errbp(
  data,
  p_lab = TRUE,
  es_lab = TRUE,
  class_symbol = TRUE,
  x_lab = "",
  y_lab = "",
  main = ""
)
}
\arguments{
\item{data}{A data frame containing the following columns for each group:
\itemize{
\item \code{name}: Group names.
\item \code{center}: Mean or median values.
\item \code{spread}: Standard deviation, MAD, or standard error.
\item \code{p.value}: P-value for the comparison.
\item \code{effect.size}: Effect size based on SSMD.
}
Note: The first row of \code{data} must correspond to the baseline group.}

\item{p_lab}{Logical. Whether to label the p-values on the plot.
Default is \code{TRUE}.}

\item{es_lab}{Logical. Whether to label the effect sizes on the plot.
Default is \code{TRUE}.}

\item{class_symbol}{Logical. Whether to use symbolic notation for
significance and effect size.
Default is \code{TRUE}.}

\item{x_lab}{Character. Label for the x-axis.}

\item{y_lab}{Character. Label for the y-axis.}

\item{main}{Character. Title of the graph.}
}
\value{
An error-bar plot is produced.
}
\description{
This function draws an error-bar plot for comparing groups to a
baseline group. It creates a barplot of the central tendency
(mean or median) and overlays error bars representing the
spread (e.g., standard deviation, MAD, or standard error).
Optionally, p-value and effect size labels (based on SSMD) are added,
either as symbols or numeric values.
}
\examples{
# Load sample data
data_df <- ExampleData1[,-c(3)]
cyt_mat <- log2(data_df[, -c(1:2)])
data_df1 <- data.frame(data_df[, 1:2], cyt_mat)
cytokineNames <- colnames(cyt_mat)
nCytokine <- length(cytokineNames)
condt <- !is.na(cyt_mat) & (cyt_mat > 0)
Cutoff <- min(cyt_mat[condt], na.rm = TRUE) / 10
# Create matrices for ANOVA and Tukey results
p_aov_mat <- matrix(NA, nrow = nCytokine, ncol = 3)
dimnames(p_aov_mat) <- list(cytokineNames,
                         c("Group", "Treatment", "Interaction"))
p_groupComp_mat <- matrix(NA, nrow = nCytokine, ncol = 3)
dimnames(p_groupComp_mat) <- list(cytokineNames,
                                 c("2-1", "3-1", "3-2"))
ssmd_groupComp_stm_mat <- mD_groupComp_stm_mat <- p_groupComp_stm_mat <-
p_groupComp_mat

for (i in 1:nCytokine) {
Cytokine <- (cyt_mat[, i] + Cutoff)
cytokine_aov <- aov(Cytokine ~ Group * Treatment, data = data_df)
aov_table <- summary(cytokine_aov)[[1]]
p_aov_mat[i, ] <- aov_table[1:3, 5]
p_groupComp_mat[i, ] <- TukeyHSD(cytokine_aov)$Group[1:3, 4]
p_groupComp_stm_mat[i, ] <- TukeyHSD(cytokine_aov)$`Group:Treatment`[1:3, 4]
mD_groupComp_stm_mat[i, ] <- TukeyHSD(cytokine_aov)$`Group:Treatment`[1:3, 1]
ssmd_groupComp_stm_mat[i, ] <- mD_groupComp_stm_mat[i, ] / sqrt(2 *
aov_table["Residuals", "Mean Sq"])
}

results <- cyt_skku(ExampleData1[, -c(3)], print_res_log = TRUE,
                 group_cols = c("Group", "Treatment"))

oldpar <- par(no.readonly = TRUE)
par(mfrow = c(2,3), mar = c(8.1, 4.1, 4.1, 2.1))

for (k in 1:nCytokine) {
result_mat <- results[1:9, , k]
center_df <- data.frame(
 name = rownames(result_mat),
 result_mat[, c("center", "spread")],
 p.value = c(1, p_groupComp_stm_mat[k, 1:2]),
 effect.size = c(0, ssmd_groupComp_stm_mat[k, 1:2])
 )
cyt_errbp(center_df, p_lab = TRUE, es_lab = TRUE,
         class_symbol = TRUE,
         y_lab = "Concentration in log2 scale",
         main = cytokineNames[k])
}
par(oldpar)

}
