/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui.archive;

import java.io.File;
import java.util.List;
import java.util.Vector;
import org.mutoss.gui.Design;
import org.mutoss.gui.RControl;
import org.mutoss.gui.archive.SaveException;

public class DesignArchive {
    List<Design> designs = new Vector<Design>();
    File file = null;
    String description = "";

    public DesignArchive(String file) {
        this(new File(file));
    }

    public DesignArchive(File file) {
        String[] loadedDesigns;
        this.file = file;
        if (!file.exists()) {
            return;
        }
        for (String s : loadedDesigns = RControl.getR().eval("load(\"" + file.getAbsolutePath().replaceAll("\\\\", "\\\\\\\\") + "\")").asRChar().getData()) {
            String title = "Unknown";
            String reference = null;
            String rName = "design";
            try {
                rName = RControl.getR().eval("attr(" + s + ",\"rName\")").asRChar().getData()[0];
                if (rName == null) {
                    title = "design";
                }
                if ((title = RControl.getR().eval("attr(" + s + ",\"title\")").asRChar().getData()[0]) == null) {
                    title = "Unkown";
                }
                reference = RControl.getR().eval("attr(" + s + ",\"reference\")").asRChar().getData()[0];
            }
            catch (Exception e) {
                // empty catch block
            }
            RControl.getR().eval(rName + " <- " + s);
            this.addDesign(new Design(title, rName, reference));
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void addDesign(Design design) {
        this.designs.add(design);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void save() throws SaveException {
        if (this.file == null) {
            throw new SaveException("File is null!");
        }
        String cmd = "save(";
        for (Design design : this.designs) {
            cmd = cmd + design.saveDesign2R(false) + ",";
        }
        cmd = cmd + " file=\"" + this.file.getAbsolutePath().replaceAll("\\\\", "\\\\\\\\") + "\")";
        RControl.getR().eval(cmd);
    }
}

