% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate.sbtv.R
\name{calibrate.sbtv}
\alias{calibrate.sbtv}
\title{SBTV model calibration to market CDS data}
\usage{
calibrate.sbtv(V0, p, cdsrate, r, t, ...)
}
\arguments{
\item{V0}{firm value at time \code{t = 0}.}

\item{p}{vector of the probability of different scenario (sum of p must be 1).}

\item{cdsrate}{CDS rates from market.}

\item{r}{a vector of risk-free rate.}

\item{t}{a vector of debt maturity structure.}

\item{...}{additional parameters used in \code{cds} function.}
}
\value{
This function returns an object of class \code{list} with calculated parameters of
\code{sbtv} model and the error occurred in the minimization procedure.
}
\description{
Compares CDS rates quoted on the market with theoric CDS rates calculeted by the function
\code{cds} and looks for the parameters to be used into \code{sbtv}
for returning the default intensities corresponding to real market CDS rates performing the
minimization of the objective function.
}
\details{
Inside \code{calibrate.sbtv}, the function \code{objfn} takes the input a
vector of parameters and returns the mean error occurred estimating CDS rates with
\code{cds} function. The inputs used in \code{cds} are the default intensities calculated by
the \code{sbtv} function with the calibrated parameters. In particular the error is
calculated as:
\deqn{\frac{1}{n}\sum_{i=1}^n (c^{ds}-c^{ds}_{mkt})^2.} This quantity is a function of
the default intensities and it is the objective function to be minimized in order to take
optimal solutions for intensities.
}
\examples{
calibrate.sbtv(V0 = 1, p = c(0.95, 0.05), cdsrate = cdsdata$Par.spread,
r = cdsdata$ED.Zero.Curve, t = cdsdata$Maturity)

}
\references{
Damiano Brigo, Massimo Morini, Andrea Pallavicini (2013)
Counterparty Credit Risk, Collateral and Funding.
With Pricing Cases for All Asset Classes
}
