% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rc_sp_copula.R
\name{rc_spCox_copula}
\alias{rc_spCox_copula}
\title{Copula regression models with Cox semiparametric margins for bivariate right-censored data}
\source{
Tao Sun, Yi Liu, Richard J. Cook, Wei Chen and Ying Ding (2019).
Copula-based Score Test for Bivariate Time-to-event Data,
with Application to a Genetic Study of AMD Progression.
\emph{Lifetime Data Analysis} 25(3), 546-568. \cr
Tao Sun and Ying Ding (In Press).
Copula-based Semiparametric Regression Model for Bivariate Data
under General Interval Censoring.
\emph{Biostatistics}. DOI: 10.1093/biostatistics/kxz032.
}
\usage{
rc_spCox_copula(data, var_list, copula = "Clayton", method = "BFGS",
  iter = 500, stepsize = 1e-06, control = list(), B = 100,
  seed = 1)
}
\arguments{
\item{data}{a data frame; must have \code{id} (subject id), \code{ind} (1,2 for two margins),
\code{obs_time}, \code{status} (0 for right-censoring, 1 for event).}

\item{var_list}{the list of covariates to be fitted into the model.}

\item{copula}{specify the copula family.}

\item{method}{optimization method (see \code{?optim}); default is \code{"BFGS"};
also can be \code{"Newton"} (see \code{?nlm}).}

\item{iter}{number of iterations when \code{method = "Newton"};
default is 500.}

\item{stepsize}{size of optimization step when \code{method = "Newton"};
default is 1e-6.}

\item{control}{a list of control parameters for methods other than \code{"Newton"};
see \code{?optim}.}

\item{B}{number of bootstraps for estimating standard errors with default 100;}

\item{seed}{the bootstrap seed; default is 1}
}
\value{
a \code{CopulaCenR} object summarizing the model.
Can be used as an input to general \code{S3} methods including
\code{summary}, \code{print}, \code{plot}, \code{lines},
\code{coef}, \code{logLik}, \code{AIC},
\code{BIC}, \code{fitted}, \code{predict}.
}
\description{
Fits a copula model with Cox semiparametric margins for bivariate right-censored data.
}
\details{
The input data must be a data frame with columns \code{id} (subject id),
\code{ind} (1,2 for two margins; each id must have both \code{ind = 1 and 2}),
\code{obs_time}, \code{status} (0 for right-censoring, 1 for event)
and \code{covariates}. \cr


The supported copula models are \code{"Clayton"}, \code{"Gumbel"}, \code{"Frank"},
\code{"AMH"}, \code{"Joe"} and \code{"Copula2"}.
The \code{"Copula2"} model is a two-parameter copula model that incorporates
\code{Clayton} and \code{Gumbel} as special cases.
The parametric generator functions of copula functions are list below:

The Clayton copula has a generator \deqn{\phi_{\eta}(t) = (1+t)^{-1/\eta},}
with \eqn{\eta > 0} and Kendall's \eqn{\tau = \eta/(2+\eta)}.

The Gumbel copula has a generator \deqn{\phi_{\eta}(t) = \exp(-t^{1/\eta}),}
with \eqn{\eta \geq 1} and Kendall's \eqn{\tau = 1 - 1/\eta}.

The Frank copula has a generator \deqn{\phi_{\eta}(t) = -\eta^{-1}\log \{1+e^{-t}(e^{-\eta}-1)\},}
with \eqn{\eta \geq 0} and Kendall's \eqn{\tau = 1+4\{D_1(\eta)-1\}/\eta},
in which \eqn{D_1(\eta) = \frac{1}{\eta} \int_{0}^{\eta} \frac{t}{e^t-1}dt}.

The AMH copula has a generator \deqn{\phi_{\eta}(t) = (1-\eta)/(e^{t}-\eta),}
with \eqn{\eta \in [0,1)} and Kendall's \eqn{\tau =  1-2\{(1-\eta)^2 \log (1-\eta) + \eta\}/(3\eta^2)}.

The Joe copula has a generator \deqn{\phi_{\eta}(t) = 1-(1-e^{-t})^{1/\eta},}
with \eqn{\eta \geq 1} and Kendall's \eqn{\tau = 1 - 4 \sum_{k=1}^{\infty} \frac{1}{k(\eta k+2)\{\eta(k-1)+2\}}}.

The Two-parameter copula (Copula2) has a generator \deqn{\phi_{\eta}(t) = \{1/(1+t^{\alpha})\}^{\kappa},}
with \eqn{\alpha \in (0,1], \kappa > 0} and Kendall's \eqn{\tau = 1-2\alpha\kappa/(2\kappa+1)}. \cr


The marginal distribution is a Cox semiparametric proportional hazards model.
The copula parameter and coefficient standard errors are estimated from bootstrap. \cr

Optimization methods can be all methods (except \code{"Brent"}) from \code{optim},
such as \code{"Nelder-Mead"}, \code{"BFGS"}, \code{"CG"}, \code{"L-BFGS-B"}, \code{"SANN"}.
Users can also use \code{"Newton"} (from \code{nlm}).
}
\examples{
# fit a Clayton-Cox model
data(DRS)
clayton_cox <- rc_spCox_copula(data = DRS, var_list = "treat",
                            copula = "Clayton", B = 2)
summary(clayton_cox)
}
