% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClaytonFrank.Weibull.data.R
\name{ClaytonFrank.Weibull.data}
\alias{ClaytonFrank.Weibull.data}
\title{Generate data from the Clayton copula for serial dependence and the Frank copula for dependent censoring with the Weibull distribuions}
\usage{
ClaytonFrank.Weibull.data(r, nu_1, theta, lambda, nu_2, alpha, N, b, l)
}
\arguments{
\item{r}{scale parameter for Weib(r, nu_1), r > 0}

\item{nu_1}{shape parameter for Weib(r, nu_1), nu_1 > 0}

\item{theta}{copula parameter for C_theta, theta > 0}

\item{lambda}{scale parameter for Weib(lambda, nu_2), lambda > 0}

\item{nu_2}{shape parameter for Weib(lambda, nu_2), nu_2 > 0}

\item{alpha}{copula parameter for tilde(C)_alpha, alpha \eqn{\neq} 0}

\item{N}{sample size}

\item{b}{parameter of Unif(0, b) for controlling censoring percentage}

\item{l}{length for data generation (default = 300)}
}
\value{
A list with the following elements:
\item{Subject}{a vector for numbers of subject}
\item{T_ij}{a vector for event times}
\item{delta_ij}{a vector for event indivator (=1 if recurrent; =0 if censoring)}
\item{T_i_star}{a vector for death times}
\item{delta_i_star}{a vector for death indivator (=1 if death; =0 if censoring)}
}
\description{
The data generation process is based on the Clayton copula C_theta for serial dependence and the Frank copula tilde(C)_alpha for dependent censoring with the marginal disributions Weib(r, nu_1) and Weib(lambda, nu_2). Censoring percentage can be controled by constant c. This function is used when doing parametric bootstrap. The guide for using this function shall be explained by Huang (2019).
}
\examples{
Y = ClaytonFrank.Weibull.data(r = 1, nu_1 =0.5, theta = 2,
                              lambda = 0.45, nu_2 = 0.5, alpha = 2,
                              N = 100, b = 10, l = 300)

}
\author{
Xinwei Huang
}
