% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copernicus_product_details.r
\name{copernicus_product_details}
\alias{copernicus_product_details}
\title{Obtain details for a specific Copernicus marine product}
\usage{
copernicus_product_details(product, layer, variable)
}
\arguments{
\item{product}{An identifier (type \code{character}) of the desired Copernicus marine product.
Can be obtained with \code{\link{copernicus_products_list}}.}

\item{layer}{The name of a desired layer within a product (type \code{character}). Can be obtained with \code{\link{copernicus_product_details}}.}

\item{variable}{The name of a desired variable in a specific layer of a product (type \code{character}).
Can be obtained with \code{\link{copernicus_product_details}}.}
}
\value{
Returns a named \code{list} with properties of the requested product.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Obtain details for a specific Copernicus marine product. This can be
narrowed down to specific layers and/or variables within the product.
}
\examples{
\dontrun{
copernicus_product_details("GLOBAL_ANALYSISFORECAST_PHY_001_024")

copernicus_product_details(
  product  = "GLOBAL_ANALYSISFORECAST_PHY_001_024",
  layer    = "cmems_mod_glo_phy-thetao_anfc_0.083deg_P1D-m",
  variable = "thetao"
)
}
}
\seealso{
Other product-functions: 
\code{\link{cms_cite_product}()},
\code{\link{cms_product_details}()},
\code{\link{cms_product_metadata}()},
\code{\link{cms_product_services}()},
\code{\link{cms_products_list}()},
\code{\link{copernicus_cite_product}()},
\code{\link{copernicus_product_metadata}()},
\code{\link{copernicus_products_list}()}
}
\author{
Pepijn de Vries
}
\concept{product-functions}
