% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cc_cap.R
\name{cc_cap}
\alias{cc_cap}
\title{Identify Coordinates in Vicinity of Country Capitals.}
\usage{
cc_cap(x, lon = "decimallongitude", lat = "decimallatitude",
  species = "species", buffer = 10000, geod = TRUE, ref = NULL,
  verify = FALSE, value = "clean", verbose = TRUE)
}
\arguments{
\item{x}{data.frame. Containing geographical coordinates and species
names.}

\item{lon}{character string. The column with the longitude coordinates.
Default = \dQuote{decimallongitude}.}

\item{lat}{character string. The column with the latitude coordinates.
Default = \dQuote{decimallatitude}.}

\item{species}{character string. The column with the species identity. Only
required if verify = TRUE.}

\item{buffer}{The buffer around each capital coordinate (the centre of the
city), where records should be flagged as problematic. Units depend on geod.
Default = 10 kilometres.}

\item{geod}{logical. If TRUE the radius around each capital is calculated
based on a sphere, buffer is in meters and independent of latitude. If FALSE
the radius is calculated assuming planar coordinates and varies slightly with latitude,
in this case buffer is in degrees. Default = TRUE. See https://seethedatablog.wordpress.com/ 
for detail and credits.}

\item{ref}{SpatialPointsDataFrame. Providing the geographic gazetteer. Can
be any SpatialPointsDataFrame, but the structure must be identical to
\code{\link{countryref}}.  Default = \code{\link{countryref}}.}

\item{verify}{logical. If TRUE records are only flagged if they are the
only record in a given species flagged close to a given reference.
If FALSE, the distance is the only criterion}

\item{value}{character string.  Defining the output value. See value.}

\item{verbose}{logical. If TRUE reports the name of the test and the number
of records flagged.}
}
\value{
Depending on the \sQuote{value} argument, either a \code{data.frame}
containing the records considered correct by the test (\dQuote{clean}) or a
logical vector (\dQuote{flagged}), with TRUE = test passed and FALSE = test failed/potentially
problematic . Default = \dQuote{clean}.
}
\description{
Removes or flags records within a certain radius around country capitals. Poorly
geo-referenced occurrence records in biological databases are often
erroneously geo-referenced to capitals.
}
\note{
See \url{https://ropensci.github.io/CoordinateCleaner/} for more
details and tutorials.
}
\examples{

x <- data.frame(species = letters[1:10], 
                decimallongitude = runif(100, -180, 180), 
                decimallatitude = runif(100, -90,90))

cc_cap(x)
cc_cap(x, value = "flagged")

}
\seealso{
Other Coordinates: \code{\link{cc_cen}},
  \code{\link{cc_coun}}, \code{\link{cc_dupl}},
  \code{\link{cc_equ}}, \code{\link{cc_gbif}},
  \code{\link{cc_inst}}, \code{\link{cc_iucn}},
  \code{\link{cc_outl}}, \code{\link{cc_sea}},
  \code{\link{cc_urb}}, \code{\link{cc_val}},
  \code{\link{cc_zero}}
}
\concept{Coordinates}
\keyword{Coordinate}
\keyword{cleaning}
