% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_network.R
\name{generate_network}
\alias{generate_network}
\title{generate_network}
\usage{
generate_network(x, intent = c("users", "content", "objects"))
}
\arguments{
\item{x}{a data.table (result from \code{detect_coordinated_groups}) with the Columns: \code{object_id}, \code{id_user}, \code{id_user_y}, \code{content_id}, \code{content_id_y}, \code{timedelta}}

\item{intent}{the intended network. The option \code{"users"} generates a network of users who are connected over the same content that they share (default). Option "content" generates a network based on content ids. Option "objects" generates a network of the coordinated content (\code{object_id}) that is connected via the users.}
}
\value{
A weighted, undirected network (igraph object) where the vertices (nodes) are users (or \code{content_ids}) and edges (links) are the membership in coordinated groups (\code{object_id})
}
\description{
Take the results of coordinated content detection and generate a network from the data. This function generates a two-mode (bipartite) incidence matrix first, and then projects the matrix to a weighted adjacency matrix.
}
