% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.ranktree.R
\name{predict.ranktree}
\alias{predict.ranktree}
\title{Predict the median rankings for new observations}
\usage{
\method{predict}{ranktree}(object, newx, ...)
}
\arguments{
\item{object}{An object of the class "ranktree"}

\item{newx}{A dataframe of the same nature of the predictor dataframe with which the tree has been built}

\item{\dots}{System reserved (No specific usage)}
}
\value{
A list containing:
\tabular{lll}{
rankings \tab \tab the fit in terms of rankings\cr
orderings \tab  \tab the fit in terms of orderings\cr
info\tab \tab dataframe containing the terminal nodes in which the new x fall down, then the new x and the fit (in terms of rankings)
}
}
\description{
Predict the median rankings in a tree-based structure built with \code{ranktree} for new observations
}
\examples{
\donttest{
data(EVS)
EVS$rankings[is.na(EVS$rankings)] <- 3
set.seed(654)
training=sample(1911,1434)
tree <- ranktree(EVS$rankings[training,],EVS$predictors[training,],decrmin=0.001,num=50)
#use the function predict ro predict rankings for new predictors
rankfit <- predict(tree,newx=EVS$predictors[-training,])
#fit in terms of rankings
rankfit$rankings
#fit in terms of orderings
rankfit$orderings
# information about the fit (terminal node, predictor and fit (in terms of rankings))
rankfit$info
}



}
\seealso{
\code{\link{ranktree}}  \code{\link{validatetree}}
}
\author{
Antonio D'Ambrosio \email{antdambr@unina.it}
}
