% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simpA.kendallReg.R
\name{simpA.kendallReg}
\alias{simpA.kendallReg}
\title{Test of the simplifying assumption using the constancy
of conditional Kendall's tau}
\usage{
simpA.kendallReg(
  X1,
  X2,
  Z,
  vectorZToEstimate = NULL,
  listPhi = list(function(x) {
     return(x)
 }, function(x) {
     return(x^2)
 },
    function(x) {
     return(x^3)
 }),
  typeEstCKT = 4,
  h_kernel,
  Lambda = function(x) {
     return(x)
 },
  Lambda_deriv = function(x) {
     return(1)
 },
  lambda = NULL,
  h_lambda = h_kernel,
  Kfolds_lambda = 5,
  l_norm = 1
)
}
\arguments{
\item{X1}{vector of observations of the first conditioned variable}

\item{X2}{vector of observations of the second conditioned variable}

\item{Z}{vector of observations of the conditioning variable}

\item{vectorZToEstimate}{vector containing the points \eqn{Z'_i}
to be used at which the conditional Kendall's tau should be estimated.}

\item{listPhi}{the list of transformations \eqn{phi} to be used.}

\item{typeEstCKT}{the type of estimation of the kernel-based estimation
of conditional Kendall's tau.}

\item{h_kernel}{the bandwidth used for the kernel-based estimations.}

\item{Lambda}{the function to be applied on conditional Kendall's tau.
By default, the identity function is used.}

\item{Lambda_deriv}{the derivative of the function \code{Lambda}.}

\item{lambda}{the penalization parameter used for Kendall's regression.
By default, cross-validation is used to find the best value of \code{lambda}.}

\item{h_lambda}{bandwidth used for the smooth cross-validation
in order to get a value for \code{lambda}.}

\item{Kfolds_lambda}{the number of subsets used for the cross-validation
in order to get a value for \code{lambda}.}

\item{l_norm}{type of norm used for selection of the optimal lambda
by cross-validation. \code{l_norm=1} corresponds to the sum of
absolute values of differences between predicted and estimated
conditional Kendall's tau while \code{l_norm=2} corresponds to
the sum of squares of differences.}
}
\value{
a list containing
\itemize{
    \item \code{statWn}: the value of the test statistic.
    \item \code{p_val}: the p-value of the test.
}
}
\description{
This function computes Kendall's regression, a regression-like
model for conditional Kendall's tau. More precisely, it fits the model
\deqn{\Lambda(\tau_{X_1, X_2 | Z = z}) = \sum_{j=1}^{p'} \beta_j \psi_j(z),}
where \eqn{\tau_{X_1, X_2 | Z = z}} is the conditional Kendall's tau
between \eqn{X_1} and \eqn{X_2} conditionally to \eqn{Z=z},
\eqn{\Lambda} is a function from \eqn{]-1, 1]} to \eqn{R},
\eqn{(\beta_1, \dots, \beta_p)} are unknown coefficients to be estimated
and \eqn{\psi_1, \dots, \psi_{p'})} are a dictionary of functions.
Then, this function tests the assumption
\deqn{\beta_2 = \beta_3 = ... = \beta_{p'} = 0,}
where the coefficient corresponding to the intercept is removed.
}
\examples{

\donttest{
# We simulate from a conditional copula
set.seed(1)
N = 300
Z = runif(n = N, min = 0, max = 1)
conditionalTau = -0.9 + 1.8 * Z
simCopula = VineCopula::BiCopSim(N=N , family = 1,
    par = VineCopula::BiCopTau2Par(1 , conditionalTau ))
X1 = qnorm(simCopula[,1])
X2 = qnorm(simCopula[,2])

result = simpA.kendallReg(
   X1, X2, Z, h_kernel = 0.03,
   listPhi = list(
     function(x){return(x)}, function(x){return(x^2)},
     function(x){return(x^3)}, function(x){return(x^4)},
     function(x){return(x^5)},
     function(x){return(cos(x))}, function(x){return(sin(x))},
     function(x){return(as.numeric(x <= 0.4))},
     function(x){return(as.numeric(x <= 0.6))}) )
print(result$p_val)

# We simulate from a conditional copula
set.seed(1)
N = 300
Z = runif(n = N, min = 0, max = 1)
conditionalTau = -0.3
simCopula = VineCopula::BiCopSim(N=N , family = 1,
    par = VineCopula::BiCopTau2Par(1 , conditionalTau ))
X1 = qnorm(simCopula[,1])
X2 = qnorm(simCopula[,2])

result = simpA.kendallReg(
   X1, X2, Z, h_kernel = 0.03,
   listPhi = list(
     function(x){return(x)}, function(x){return(x^2)},
     function(x){return(x^3)}, function(x){return(x^4)},
     function(x){return(x^5)},
     function(x){return(cos(x))}, function(x){return(sin(x))},
     function(x){return(as.numeric(x <= 0.4))},
     function(x){return(as.numeric(x <= 0.6))}) )
print(result$p_val)
}

}
\references{
Derumigny, A., & Fermanian, J. D. (2020).
On Kendall’s regression.
Journal of Multivariate Analysis, 178, 104610.
(page 7)
\doi{10.1016/j.jmva.2020.104610}
}
\seealso{
The function to fit Kendall's regression:
\code{\link{CKT.kendallReg.fit}}.

Other tests of the simplifying assumption:
\itemize{
  \item \code{\link{simpA.NP}} in a nonparametric setting
  \item \code{\link{simpA.param}} in a (semi)parametric setting,
  where the conditional copula belongs to a parametric family,
  but the conditional margins are estimated arbitrarily through
  kernel smoothing

  \item the counterparts of these tests in the discrete conditioning setting:
  \code{\link{bCond.simpA.CKT}}
  (test based on conditional Kendall's tau)
  \code{\link{bCond.simpA.param}}
  (test assuming a parametric form for the conditional copula)
}
}
