% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{CT_Distribution_Sim}
\alias{CT_Distribution_Sim}
\title{Simulated Probability Distribution of Concordance Coefficient and Kruskal Wallis Statistic}
\usage{
CT_Distribution_Sim(Sample_Sizes, Num_Sim = 10000, H = 0)
}
\arguments{
\item{Sample_Sizes}{Numeric vector (\code{n1},...,\code{nk}) containing the number of repetitions of each element, i.e., the size of each sample in the experiment.}

\item{Num_Sim}{Number of simulations in order to obtain the probability distribution of the statistics. The default is 10000.}

\item{H}{0 by default. If set to 1, the probability distribution table of Kruskal-Wallis Statistic is also calculated and returned.}
}
\value{
The function returns a list with the following elements:
\enumerate{
 \item{ \code{C_freq}: Matrix with the probability distribution of Concordance Coefficient. Each row in the matrix contains the disorder, the value of the statistic, the frequency and its probability.}
 \item{ \code{H_freq}: Matrix with the probability distribution of Kruskal Wallis Statistic. Each row in the matrix contains the value of the statistic, the frequency and its probability (only if H = 1).}
}
}
\description{
This function computes by simulation the probability distribution tables of Concordance Coefficient and Kruskal Wallis Statistic.
}
\examples{
Sample_Sizes <- c(5,4)
CT_Distribution_Sim(Sample_Sizes, Num_Sim = 1000)
CT_Distribution_Sim(Sample_Sizes, Num_Sim = 1000, H = 1)
}
