% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{plot.cv.FuncompCGL}
\alias{plot.cv.FuncompCGL}
\title{Plot the cross-validation curve produced by \code{"cv.FuncompCGL"}.}
\usage{
\method{plot}{cv.FuncompCGL}(x, xlab = c("log", "-log", "lambda"), trim = FALSE, k, ...)
}
\arguments{
\item{x}{fitted \code{"cv.FuncompCGL"} model.}

\item{xlab}{what is on the X-axis,
\code{"log"} plots against \code{log(lambda)} (default),
\code{"-log"} against \code{-log(lambda)}, and \code{"lambda"} against \code{lambda}.}

\item{trim}{logical; whether to use the trimmed result.
Default is \code{FALSE}.}

\item{k}{a vector or character string
\itemize{
\item if character string, either \code{"lam.1se"} or
      \code{"lam.min"}.
\item if it is an integer vector, specify the set of degrees of freedom
      \code{k} to plot.
\item if it is missing (default), cross-validation curves for \code{k}
      that are associated with \code{lambda.min} (blue)
      and \code{lambda.1se} (red) are plotted.
}}

\item{...}{other graphical parameters.}
}
\value{
No return value. Side effect is a base R plot.
}
\description{
Plot the cross-validation curve with its upper and lower standard
deviation curves.
}
\details{
A cross-validation curve is produced.
}
\examples{
\donttest{
df_beta = 5
p = 30
beta_C_true = matrix(0, nrow = p, ncol = df_beta)
beta_C_true[1, ] <- c(-0.5, -0.5, -0.5 , -1, -1)
beta_C_true[2, ] <- c(0.8, 0.8,  0.7,  0.6,  0.6)
beta_C_true[3, ] <- c(-0.8, -0.8 , 0.4 , 1 , 1)
beta_C_true[4, ] <- c(0.5, 0.5, -0.6  ,-0.6, -0.6)
Data <- Fcomp_Model(n = 50, p = p, m = 0, intercept = TRUE,
                    SNR = 4, sigma = 3, rho_X = 0, rho_T = 0.6, df_beta = df_beta,
                    n_T = 20, obs_spar = 1, theta.add = FALSE,
                    beta_C = as.vector(t(beta_C_true)))
k_list <- 4:5
cv_m1 <-  cv.FuncompCGL(y = Data$data$y, X = Data$data$Comp,
                        Zc = Data$data$Zc, intercept = Data$data$intercept,
                        k = k_list, nfolds = 5, keep = TRUE)
plot(cv_m1)
plot(cv_m1, xlab = "-log", k = k_list)
}

}
\references{
Sun, Z., Xu, W., Cong, X., Li G. and Chen K. (2020) \emph{Log-contrast regression with
functional compositional predictors: linking preterm infant's gut microbiome trajectories
to neurobehavioral outcome}, \href{https://arxiv.org/abs/1808.02403}{https://arxiv.org/abs/1808.02403}
\emph{Annals of Applied Statistics}
}
\seealso{
\code{\link{cv.FuncompCGL}} and \code{\link{FuncompCGL}}, and
\code{\link[=predict.cv.FuncompCGL]{predict}} and
\code{\link[=coef.cv.FuncompCGL]{coef}} methods for \code{"cv.FuncompCGL"} object.
}
\author{
Zhe Sun and Kun Chen
}
