% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{coef.GIC.compCL}
\alias{coef.GIC.compCL}
\title{Extracts estimated coefficients from a \code{"GIC.compCL"} object.}
\usage{
\method{coef}{GIC.compCL}(object, s = "lam.min", ...)
}
\arguments{
\item{object}{fitted \code{"\link{GIC.compCL}"} object.}

\item{s}{value(s) of the penalty parameter \code{lam} at which coefficients are requested.
\itemize{
\item \code{s="lam.min"} (default) stored in the \code{GIC.compCL} object,
      which gives value of \code{lam} that achieves the minimum value of GIC.
\item If \code{s} is numeric, it is taken as the value(s) of \code{lam} to be used.
\item If \code{s = NULL}, the whole sequence of \code{lam} stored
      in the \code{GIC.compCGL} object is used.
}}

\item{\dots}{not used.}
}
\value{
The coefficients at the requested tuning parameter values in \code{s}.
}
\description{
This function gets coefficients from a \code{compCL} object, using
the stored \code{"compCL.fit"} object.
}
\details{
\code{s} is a vector of lambda values at which the coefficients are requested. If \code{s} is not in the
\code{lam} sequence used for fitting the model, the \code{coef} function will use linear
interpolation, so the function should be used with caution.
}
\examples{
p = 30
n = 50
beta = c(1, -0.8, 0.6, 0, 0, -1.5, -0.5, 1.2)
beta = c(beta, rep(0, times = p - length(beta)))
Comp_data = comp_Model(n = n, p = p, beta = beta, intercept = FALSE)
GICm1 <- GIC.compCL(y = Comp_data$y, Z = Comp_data$X.comp, Zc = Comp_data$Zc,
                    intercept = Comp_data$intercept)
coef(GICm1)
coef(GICm1, s = c(1, 0.5, 0.1))

}
\references{
Lin, W., Shi, P., Peng, R. and Li, H. (2014) \emph{Variable selection in
regression with compositional covariates},
\href{https://academic.oup.com/biomet/article/101/4/785/1775476}{https://academic.oup.com/biomet/article/101/4/785/1775476}.
\emph{Biometrika} \strong{101} 785-979.
}
\seealso{
\code{\link{GIC.compCL}} and \code{\link{compCL}}, and
\code{\link[=predict.GIC.compCL]{predict}}, and
\code{\link[=plot.GIC.compCL]{plot}} methods for \code{"GIC.compCL"} object.
}
\author{
Zhe Sun and Kun Chen
}
