/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel.internal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import net.infonode.gui.ComponentUtil;
import net.infonode.gui.GraphicsUtil;
import net.infonode.gui.UIManagerUtil;
import net.infonode.util.ColorUtil;
import net.infonode.util.Direction;

public class ShadowPainter {
    private Color panelBackgroundColor;
    private Color tabBackgroundColor;
    private Component component;
    private JComponent componentsPanel;
    private JComponent highlightedTab;
    private JComponent contentPanel;
    private JComponent tabAreaComponentsPanel;
    private JComponent tabAreaContainer;
    private JComponent tabBox;
    private Direction tabOrientation;
    private boolean paintTabAreaShadow;
    private int shadowSize;
    private int shadowBlendSize;
    private Color shadowColor;
    private float shadowStrength;
    private boolean highlightedTabIsLast;

    public ShadowPainter(Component component, JComponent jComponent, JComponent jComponent2, JComponent jComponent3, JComponent jComponent4, JComponent jComponent5, JComponent jComponent6, Direction direction, boolean bl, int n, int n2, Color color, float f, boolean bl2) {
        this.component = component;
        this.componentsPanel = jComponent;
        this.highlightedTab = jComponent2 == null ? null : (!jComponent2.isVisible() || !jComponent5.isVisible() ? null : jComponent2);
        this.contentPanel = jComponent3;
        this.tabAreaComponentsPanel = jComponent4;
        this.tabAreaContainer = jComponent5;
        this.tabBox = jComponent6;
        this.tabOrientation = direction;
        this.paintTabAreaShadow = bl && jComponent5.isVisible();
        this.shadowSize = n;
        this.shadowBlendSize = n2;
        this.shadowColor = color;
        this.shadowStrength = f;
        this.highlightedTabIsLast = bl2;
    }

    public void paint(Graphics graphics) {
        this.panelBackgroundColor = ComponentUtil.getBackgroundColor(this.component);
        Color color = this.panelBackgroundColor = this.panelBackgroundColor == null ? UIManagerUtil.getColor("Panel.background", "control") : this.panelBackgroundColor;
        if (this.paintTabAreaShadow) {
            Rectangle rectangle = SwingUtilities.calculateInnerArea(this.componentsPanel, new Rectangle());
            this.drawBottomRightEdgeShadow(graphics, rectangle.y, rectangle.x + rectangle.width, rectangle.height, true, this.panelBackgroundColor);
            this.drawBottomRightEdgeShadow(graphics, rectangle.x, rectangle.y + rectangle.height, rectangle.width, false, this.panelBackgroundColor);
            this.drawRightCornerShadow(graphics, rectangle.x + rectangle.width, rectangle.y + rectangle.height, false, this.panelBackgroundColor);
        } else {
            this.tabBackgroundColor = this.highlightedTab == null ? this.panelBackgroundColor : ComponentUtil.getBackgroundColor(this.highlightedTab.getParent());
            this.tabBackgroundColor = this.tabBackgroundColor == null ? this.panelBackgroundColor : this.tabBackgroundColor;
            Rectangle rectangle = this.contentPanel.getBounds();
            int n = 0;
            if (this.highlightedTab != null) {
                n = this.paintHighlightedTabShadow(graphics, this.tabOrientation, rectangle);
            }
            if (this.tabAreaComponentsPanel.isVisible()) {
                int n2 = this.tabOrientation.isHorizontal() ? (this.tabAreaContainer.getInsets().bottom == 0 ? this.tabAreaComponentsPanel.getWidth() : 0) : (n = this.tabAreaContainer.getInsets().right == 0 ? this.tabAreaComponentsPanel.getHeight() : 0);
            }
            if (!this.tabAreaContainer.isVisible()) {
                n = 0;
            }
            if (this.tabOrientation != Direction.RIGHT || this.highlightedTab == null) {
                this.drawBottomRightEdgeShadow(graphics, rectangle.y - (this.tabOrientation == Direction.UP ? n : 0), rectangle.x + rectangle.width, rectangle.height + (!this.tabOrientation.isHorizontal() ? n : 0), true, this.highlightedTab == null ? null : this.panelBackgroundColor);
            }
            if (this.tabOrientation != Direction.DOWN || this.highlightedTab == null) {
                this.drawBottomRightEdgeShadow(graphics, rectangle.x - (this.tabOrientation == Direction.LEFT ? n : 0), rectangle.y + rectangle.height, rectangle.width + (this.tabOrientation.isHorizontal() ? n : 0), false, this.highlightedTab == null ? null : this.panelBackgroundColor);
            }
            this.drawRightCornerShadow(graphics, rectangle.x + rectangle.width + (this.tabOrientation == Direction.RIGHT ? n : 0), rectangle.y + rectangle.height + (this.tabOrientation == Direction.DOWN ? n : 0), false, this.panelBackgroundColor);
        }
    }

    private int paintHighlightedTabShadow(Graphics graphics, Direction direction, Rectangle rectangle) {
        Point point = SwingUtilities.convertPoint(this.highlightedTab.getParent(), this.highlightedTab.getLocation(), this.component);
        Dimension dimension = this.tabBox.getSize();
        Rectangle rectangle2 = this.tabAreaComponentsPanel.isVisible() ? SwingUtilities.convertRectangle(this.tabAreaComponentsPanel.getParent(), this.tabAreaComponentsPanel.getBounds(), this.component) : new Rectangle(rectangle.x + rectangle.width, rectangle.y + rectangle.height, 0, 0);
        Point point2 = SwingUtilities.convertPoint(this.tabBox, 0, 0, this.component);
        int n = (direction.isHorizontal() ? 0 : point2.x) + dimension.width;
        int n2 = (direction.isHorizontal() ? point2.y : 0) + dimension.height;
        if (direction == Direction.DOWN) {
            this.drawBottomRightTabShadow(graphics, rectangle.x, rectangle.y + rectangle.height, rectangle.width, point.x, this.highlightedTab.getWidth(), this.highlightedTab.getHeight(), rectangle2.x, rectangle2.width, rectangle2.height, false, this.highlightedTabIsLast);
        } else if (direction == Direction.RIGHT) {
            this.drawBottomRightTabShadow(graphics, rectangle.y, rectangle.x + rectangle.width, rectangle.height, point.y, this.highlightedTab.getHeight(), this.highlightedTab.getWidth(), rectangle2.y, rectangle2.height, rectangle2.width, true, this.highlightedTabIsLast);
        } else if (direction == Direction.UP) {
            this.drawTopLeftTabShadow(graphics, point.x + this.highlightedTab.getWidth(), point.y, this.highlightedTab.getHeight(), rectangle2, rectangle.width, false, this.highlightedTabIsLast);
        } else {
            this.drawTopLeftTabShadow(graphics, point.y + this.highlightedTab.getHeight(), point.x, this.highlightedTab.getWidth(), ShadowPainter.flipRectangle(rectangle2), rectangle.height, true, this.highlightedTabIsLast);
        }
        if (this.highlightedTabIsLast) {
            return direction.isHorizontal() ? (point.y + this.highlightedTab.getHeight() >= rectangle.height && rectangle.height == n2 ? this.highlightedTab.getWidth() : 0) : (point.x + this.highlightedTab.getWidth() >= rectangle.width && rectangle.width == n ? this.highlightedTab.getHeight() : 0);
        }
        return 0;
    }

    private static Rectangle flipRectangle(Rectangle rectangle) {
        return new Rectangle(rectangle.y, rectangle.x, rectangle.height, rectangle.width);
    }

    private static Rectangle createRectangle(int n, int n2, int n3, int n4, boolean bl) {
        return bl ? new Rectangle(n2, n, n4, n3) : new Rectangle(n, n2, n3, n4);
    }

    private void drawTopLeftTabShadow(Graphics graphics, int n, int n2, int n3, Rectangle rectangle, int n4, boolean bl, boolean bl2) {
        int n5;
        boolean bl3;
        boolean bl4 = bl3 = n + this.shadowSize > rectangle.x;
        if (!bl3 || n2 + this.shadowSize + this.shadowBlendSize <= rectangle.y) {
            this.drawLeftCornerShadow(graphics, n2, Math.min(n, rectangle.x), !bl, bl2 ? this.tabBackgroundColor : null);
            this.drawEdgeShadow(graphics, n2, bl3 ? rectangle.y : n2 + n3, Math.min(n, rectangle.x), false, !bl, bl2 ? this.tabBackgroundColor : null);
        }
        if ((n5 = rectangle.x + rectangle.width) < n4) {
            this.drawLeftCornerShadow(graphics, rectangle.y, n5, !bl, this.tabBackgroundColor);
            this.drawEdgeShadow(graphics, rectangle.y, rectangle.y + rectangle.height, n5, false, !bl, this.tabBackgroundColor);
        }
    }

    private void drawBottomRightTabShadow(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl, boolean bl2) {
        Shape shape = graphics.getClip();
        Rectangle rectangle = ShadowPainter.createRectangle(n, n2, Math.min(n4, n7) - n, 1000000, bl);
        graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.drawLeftCornerShadow(graphics, n, n2, bl, null);
        this.drawEdgeShadow(graphics, n, n4, n2, false, bl, null);
        boolean bl3 = n4 < n7 && n4 + n5 >= n7;
        graphics.setClip(shape);
        if (!bl3) {
            Rectangle rectangle2 = ShadowPainter.createRectangle(n, n2, n7 - n, 1000000, bl);
            graphics.clipRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        }
        if (n4 < n7) {
            int n10;
            int n11 = n10 = bl3 && n6 == n9 ? n7 + n8 : Math.min(n7, n4 + n5);
            if (n4 + this.shadowSize < n10) {
                this.drawLeftCornerShadow(graphics, n4, n2 + n6, bl, this.panelBackgroundColor);
            }
            this.drawEdgeShadow(graphics, n4, n10, n2 + n6, false, bl, this.panelBackgroundColor);
            if (!(n10 >= n + n3 || bl3 && n9 >= n6)) {
                this.drawRightCornerShadow(graphics, n10, n2 + n6, bl, this.panelBackgroundColor);
                this.drawEdgeShadow(graphics, n2 + (bl3 ? n9 : 0), n2 + n6, n10, true, !bl, bl2 ? this.tabBackgroundColor : null);
            }
        }
        if (!bl3) {
            this.drawEdgeShadow(graphics, n4 + n5, n7, n2, true, bl, bl2 ? this.tabBackgroundColor : null);
            graphics.setClip(shape);
        }
        if (!(n9 <= 0 || bl3 && n6 == n9)) {
            if (!bl3 || n9 > n6) {
                this.drawLeftCornerShadow(graphics, n7, n2 + n9, bl, this.panelBackgroundColor);
                this.drawEdgeShadow(graphics, n7, n7 + n8, n2 + n9, false, bl, this.panelBackgroundColor);
            } else {
                this.drawEdgeShadow(graphics, n7, n7 + n8, n2 + n9, true, bl, this.panelBackgroundColor);
            }
        }
        if (n7 + n8 < n + n3) {
            this.drawRightCornerShadow(graphics, n7 + n8, n2 + n9, bl, this.panelBackgroundColor);
            this.drawEdgeShadow(graphics, n2, n2 + n9, n7 + n8, true, !bl, this.panelBackgroundColor);
            this.drawEdgeShadow(graphics, n7 + n8, n + n3, n2, true, bl, this.panelBackgroundColor);
        }
    }

    private void drawBottomRightEdgeShadow(Graphics graphics, int n, int n2, int n3, boolean bl, Color color) {
        this.drawLeftCornerShadow(graphics, n, n2, bl, color);
        this.drawEdgeShadow(graphics, n, n + n3, n2, false, bl, color);
    }

    private void drawLeftCornerShadow(Graphics graphics, int n, int n2, boolean bl, Color color) {
        for (int i = 0; i < this.shadowBlendSize; ++i) {
            graphics.setColor(this.getShadowBlendColor(i, color));
            int n3 = n + this.shadowSize + this.shadowBlendSize - 1 - i;
            int n4 = n2 + this.shadowSize - this.shadowBlendSize;
            if (n4 > n2) {
                ShadowPainter.drawLine(graphics, n3, n2, n3, n4 - 1, bl);
            }
            ShadowPainter.drawLine(graphics, n3, n4, n + this.shadowSize + this.shadowBlendSize - 1, n2 + this.shadowSize - this.shadowBlendSize + i, bl);
        }
    }

    private void drawRightCornerShadow(Graphics graphics, int n, int n2, boolean bl, Color color) {
        int n3;
        graphics.setColor(this.getShadowColor(color));
        for (n3 = 0; n3 < this.shadowSize - this.shadowBlendSize; ++n3) {
            ShadowPainter.drawLine(graphics, n + n3, n2, n + n3, n2 + this.shadowSize - this.shadowBlendSize, bl);
        }
        for (n3 = 0; n3 < this.shadowBlendSize; ++n3) {
            graphics.setColor(this.getShadowBlendColor(n3, color));
            int n4 = this.shadowSize - this.shadowBlendSize + n3;
            ShadowPainter.drawLine(graphics, n + n4, n2, n + n4, n2 + this.shadowSize - this.shadowBlendSize, bl);
            ShadowPainter.drawLine(graphics, n, n2 + n4, n + this.shadowSize - this.shadowBlendSize, n2 + n4, bl);
            ShadowPainter.drawLine(graphics, n + n4, n2 + this.shadowSize - this.shadowBlendSize, n + this.shadowSize - this.shadowBlendSize, n2 + n4, bl);
        }
    }

    private void drawEdgeShadow(Graphics graphics, int n, int n2, int n3, boolean bl, boolean bl2, Color color) {
        int n4;
        if (n + (bl ? 0 : this.shadowSize + this.shadowBlendSize) >= n2) {
            return;
        }
        graphics.setColor(this.getShadowColor(color));
        for (n4 = 0; n4 < this.shadowSize - this.shadowBlendSize; ++n4) {
            ShadowPainter.drawLine(graphics, n + (bl ? n4 + (bl2 ? 1 : 0) : this.shadowSize + this.shadowBlendSize), n3 + n4, n2 - 1, n3 + n4, bl2);
        }
        for (n4 = 0; n4 < this.shadowBlendSize; ++n4) {
            graphics.setColor(this.getShadowBlendColor(n4, color));
            int n5 = this.shadowSize - this.shadowBlendSize + n4;
            ShadowPainter.drawLine(graphics, n + (bl ? n5 + (bl2 ? 1 : 0) : this.shadowSize + this.shadowBlendSize), n3 + n5, n2 - 1, n3 + n5, bl2);
        }
    }

    private static void drawLine(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            GraphicsUtil.drawOptimizedLine(graphics, n2, n, n4, n3);
        } else {
            GraphicsUtil.drawOptimizedLine(graphics, n, n2, n3, n4);
        }
    }

    private Color getShadowBlendColor(int n, Color color) {
        return color == null ? new Color(this.shadowColor.getRed(), this.shadowColor.getGreen(), this.shadowColor.getBlue(), (int)(255.0f * this.shadowStrength * (float)(this.shadowBlendSize - n) / (float)(this.shadowBlendSize + 1))) : ColorUtil.blend(color, this.shadowColor, this.shadowStrength * (float)(this.shadowBlendSize - n) / (float)(this.shadowBlendSize + 1));
    }

    private Color getShadowColor(Color color) {
        return color == null ? new Color(this.shadowColor.getRed(), this.shadowColor.getGreen(), this.shadowColor.getBlue(), (int)(255.0f * this.shadowStrength)) : ColorUtil.blend(color, this.shadowColor, this.shadowStrength);
    }
}

