/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.shaped;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import net.infonode.gui.InsetsUtil;
import net.infonode.gui.RectangleUtil;
import net.infonode.gui.shaped.panel.ShapedPanel;
import net.infonode.util.Direction;

public class ShapedUtil {
    private ShapedUtil() {
    }

    public static Direction getDirection(Component component) {
        return component instanceof ShapedPanel ? ((ShapedPanel)component).getDirection() : Direction.RIGHT;
    }

    public static Insets transformInsets(Component component, Insets insets) {
        return InsetsUtil.rotate(ShapedUtil.getDirection(component), ShapedUtil.flipInsets(component, insets));
    }

    public static Insets flipInsets(Component component, Insets insets) {
        if (component instanceof ShapedPanel) {
            if (((ShapedPanel)component).isHorizontalFlip()) {
                insets = InsetsUtil.flipHorizontal(insets);
            }
            if (((ShapedPanel)component).isVerticalFlip()) {
                insets = InsetsUtil.flipVertical(insets);
            }
        }
        return insets;
    }

    public static void rotateCW(Polygon polygon, int n) {
        for (int i = 0; i < polygon.npoints; ++i) {
            int n2 = polygon.ypoints[i];
            polygon.ypoints[i] = polygon.xpoints[i];
            polygon.xpoints[i] = n - 1 - n2;
        }
    }

    public static void rotate(Polygon polygon, Direction direction, int n, int n2) {
        if (direction == Direction.UP) {
            ShapedUtil.rotateCW(polygon, n2);
            ShapedUtil.rotateCW(polygon, n);
            ShapedUtil.rotateCW(polygon, n2);
        } else if (direction == Direction.LEFT) {
            ShapedUtil.rotateCW(polygon, n2);
            ShapedUtil.rotateCW(polygon, n);
        } else if (direction == Direction.DOWN) {
            ShapedUtil.rotateCW(polygon, n2);
        }
    }

    public static Rectangle transform(Component component, Rectangle rectangle) {
        if (component instanceof ShapedPanel) {
            ShapedPanel shapedPanel = (ShapedPanel)component;
            return RectangleUtil.transform(rectangle, shapedPanel.getDirection(), shapedPanel.isHorizontalFlip(), shapedPanel.isVerticalFlip(), component.getWidth(), component.getHeight());
        }
        return rectangle;
    }

    public static Dimension transform(Component component, Dimension dimension) {
        return ShapedUtil.getDirection(component).isHorizontal() ? dimension : new Dimension(dimension.height, dimension.width);
    }

    public static int getWidth(Component component, int n, int n2) {
        return ShapedUtil.getDirection(component).isHorizontal() ? n : n2;
    }

    public static int getHeight(Component component, int n, int n2) {
        return ShapedUtil.getDirection(component).isHorizontal() ? n2 : n;
    }
}

