% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Schoenfeld_Calc}
\alias{Schoenfeld_Calc}
\title{Primary Cox PH schoenfeld residual function
\code{Schoenfeld_Calc} Performs the calls to calculation functions, Uses calculated risks and risk groups to calculate the residuals, With verbose option prints out time stamps and intermediate sums of terms and derivatives}
\usage{
Schoenfeld_Calc(
  ntime,
  totalnum,
  beta_0,
  df0,
  R,
  Lldd_inv,
  RiskFail,
  RiskGroup,
  dfc,
  verbose,
  debugging,
  KeepConstant,
  nthreads
)
}
\arguments{
\item{ntime}{number of risk groups}

\item{totalnum}{total number of parameters}

\item{beta_0}{parameter estimates}

\item{df0}{matrix of covariate values}

\item{R}{risk vector}

\item{Lldd_inv}{inverse of second derivative of Log-Likelihood matrix}

\item{RiskFail}{matrix of indexes for event rows in each risk group}

\item{RiskGroup}{list of string indices for every risk group}

\item{dfc}{vector matching subterm number to matrix column}

\item{verbose}{boolean for additional printing}

\item{debugging}{additional boolean for verbosity in testing}

\item{KeepConstant}{binary vector to identify constant parameters}

\item{nthreads}{number of threads available}
}
\value{
List of results: scaled schoenfeld residuals
}
\description{
Primary Cox PH schoenfeld residual function
\code{Schoenfeld_Calc} Performs the calls to calculation functions, Uses calculated risks and risk groups to calculate the residuals, With verbose option prints out time stamps and intermediate sums of terms and derivatives
}
