% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_rbedInfo.R
\docType{methods}
\name{readBed}
\alias{readBed}
\alias{readBed,RbedInfoC,ANY,logical,logical-method}
\alias{readBed,RbedInfoC,ANY,logical,missing-method}
\alias{readBed,RbedInfoC,ANY,missing,logical-method}
\alias{readBed,RbedInfoC,ANY,missing,missing-method}
\alias{readBed,RbedInfoC,missing,logical,logical-method}
\alias{readBed,RbedInfoC,missing,logical,missing-method}
\alias{readBed,RbedInfoC,missing,missing,logical-method}
\alias{readBed,RbedInfoC,missing,missing,missing-method}
\title{Read genotypes from PLINK bed file into R}
\usage{
readBed(rbed_info, snp_vec, fid_iid = TRUE, snp_names_as_colnames = TRUE)

\S4method{readBed}{RbedInfoC,ANY,logical,logical}(rbed_info, snp_vec,
  fid_iid = TRUE, snp_names_as_colnames = TRUE)

\S4method{readBed}{RbedInfoC,missing,missing,missing}(rbed_info, snp_vec,
  fid_iid = TRUE, snp_names_as_colnames = TRUE)

\S4method{readBed}{RbedInfoC,ANY,missing,missing}(rbed_info, snp_vec,
  fid_iid = TRUE, snp_names_as_colnames = TRUE)

\S4method{readBed}{RbedInfoC,missing,logical,missing}(rbed_info, snp_vec,
  fid_iid = TRUE, snp_names_as_colnames = TRUE)

\S4method{readBed}{RbedInfoC,ANY,logical,missing}(rbed_info, snp_vec,
  fid_iid = TRUE, snp_names_as_colnames = TRUE)

\S4method{readBed}{RbedInfoC,missing,missing,logical}(rbed_info, snp_vec,
  fid_iid = TRUE, snp_names_as_colnames = TRUE)

\S4method{readBed}{RbedInfoC,ANY,missing,logical}(rbed_info, snp_vec,
  fid_iid = TRUE, snp_names_as_colnames = TRUE)

\S4method{readBed}{RbedInfoC,missing,logical,logical}(rbed_info, snp_vec,
  fid_iid = TRUE, snp_names_as_colnames = TRUE)
}
\arguments{
\item{rbed_info}{RbedInfoC object}

\item{snp_vec}{numeric. Vector of SNP index. Either row numbers in the bim file or a vector of SNP names.}

\item{fid_iid}{logical. Whether the FID and IID columns should be included.}

\item{snp_names_as_colnames}{logical. Whether SNP names should be used as colnames in the returned data frame}
}
\value{
data.frame Genotype data from bed file.
}
\description{
Read genotypes from PLINK bed file into R
}
\author{
Kaiyin Zhong, Fan Liu
}

