% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/requireConceptIntersectFlag.R
\name{requireConceptIntersectFlag}
\alias{requireConceptIntersectFlag}
\title{Require cohort subjects to have events of a concept list}
\usage{
requireConceptIntersectFlag(
  cohort,
  conceptSet,
  window,
  cohortId = NULL,
  indexDate = "cohort_start_date",
  targetStartDate = "event_start_date",
  targetEndDate = "event_end_date",
  censorDate = NULL,
  negate = FALSE,
  name = tableName(cohort)
)
}
\arguments{
\item{cohort}{A cohort table in a cdm reference.}

\item{conceptSet}{Concept set list.}

\item{window}{Window to consider events over.}

\item{cohortId}{IDs of the cohorts to modify. If NULL, all cohorts will be
used; otherwise, only the specified cohorts will be modified, and the
rest will remain unchanged..}

\item{indexDate}{Variable in x that contains the date to compute the
intersection.}

\item{targetStartDate}{Date of reference in cohort table, either for start
(in overlap) or on its own (for incidence).}

\item{targetEndDate}{Date of reference in cohort table, either for end
(overlap) or NULL (if incidence).}

\item{censorDate}{Whether to censor overlap events at a specific date or a
column date of x.}

\item{negate}{If set as TRUE, criteria will be applied as exclusion
rather than inclusion (i.e. require absence in another cohort).}

\item{name}{Name of the new cohort with the future observation restriction.}
}
\value{
Cohort table with only those  with the events in the concept list
kept (or those without the event if negate = TRUE)
}
\description{
Require cohort subjects to have events of a concept list
}
\examples{
\donttest{
library(CohortConstructor)
cdm <- mockCohortConstructor(conditionOccurrence = TRUE)
cdm$cohort2 <-  requireConceptIntersectFlag(
  cohort = cdm$cohort1,
  conceptSet = list(a = 1),
  window = c(-Inf, 0),
  name = "cohort2")
  }
}
