% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableLargeScaleCharacteristics.R
\name{tableLargeScaleCharacteristics}
\alias{tableLargeScaleCharacteristics}
\title{Explore and compare the large scale characteristics of cohorts}
\usage{
tableLargeScaleCharacteristics(
  result,
  compareBy = NULL,
  hide = c("type"),
  smdReference = NULL,
  type = "reactable"
)
}
\arguments{
\item{result}{A summarised_result object.}

\item{compareBy}{A column to compare by it can be a choice between
"cdm_name", "cohort_name", strata columns, "variable_level" (window) and
"type". It can be left NULL for no comparison.}

\item{hide}{Columns to hide.}

\item{smdReference}{Level of reference for the Standardised Mean Differences
(SMD), it has to be one of the values of \code{compareBy} column. If NULL no SMDs
are displayed.}

\item{type}{Type of table to generate, it can be either \code{DT} or \code{reactable}.}
}
\value{
A visual table.
}
\description{
Explore and compare the large scale characteristics of cohorts
}
\examples{
\dontrun{
library(CohortCharacteristics)
library(omock)
library(CDMConnector)
library(dplyr, warn.conflicts = FALSE)

cdm <- mockCdmFromDataset(datasetName = "GiBleed", source = "duckdb")

cdm <- generateConceptCohortSet(
  cdm = cdm,
  conceptSet = list(viral_pharyngitis = 4112343),
  name = "my_cohort"
)

result <- summariseLargeScaleCharacteristics(
  cohort = cdm$my_cohort,
  window = list(c(-Inf, -1), c(0, 0), c(1, Inf)),
  episodeInWindow = "drug_exposure"
)

tableLargeScaleCharacteristics(result)

tableLargeScaleCharacteristics(result,
                               compareBy = "variable_level")

tableLargeScaleCharacteristics(result,
                               compareBy = "variable_level",
                               smdReference = "-inf to -1")

cdmDisconnect(cdm)
}

}
