% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gev.R
\name{GEV}
\alias{GEV}
\alias{dgev}
\alias{pgev}
\alias{qgev}
\alias{rgev}
\alias{mgev}
\title{Generalized extreme value distribution}
\usage{
dgev(x, loc, scale, shape, log = FALSE)

pgev(q, loc, scale, shape, lower.tail = TRUE, log.p = FALSE)

qgev(p, loc, scale, shape, lower.tail = TRUE, log.p = FALSE)

rgev(n, loc, scale, shape)

mgev(r, loc, scale, shape)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{loc, scale, shape}{location, scale and shape parameters.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to be the number required.}

\item{r}{raw moment order}
}
\description{
Provides density, distribution function, quantile function,
and random value generation, for the generalized extreme value distribution.
}
\examples{

## plot the density

ggplot(data.frame(x = c(0, 20)),
       aes(x)) +
  stat_function(fun = dgev,
                args = list(loc = 1,
                            scale = .5,
                            shape = .15),
                colour = 'royalblue4') +
  labs(x = '',
       y = 'Density') +
  theme_classic()
}
\concept{Continuous}
\concept{Univariate}
\keyword{distribution}
