% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPowerCont.R
\name{plotPowerCont}
\alias{plotPowerCont}
\title{Plotting of Power Curve versus Correlate of Risk Effect Size for Continuous Biomarkers}
\usage{
plotPowerCont(outComputePower, outDir = NULL, legendText,
  legendTitle = NULL, extendedLeg = TRUE, verboseLeg = TRUE,
  margin = c(11, 7, 3, 1))
}
\arguments{
\item{outComputePower}{either a list of lists containing output from \code{\link{computePower}} or a character vector specifying the \code{.RData} file(s) containing \code{\link{computePower}} output}

\item{outDir}{a character vector specifying path(s) to output \code{.RData} file(s), necessary if \cr
\code{outComputePower} is a character vector. Default is \code{NULL}.}

\item{legendText}{a character vector specifying the entirety of the legend text. The order of the elements (i.e., parameter values) must match that of the \code{\link{computePower}} input parameters in order for legend labels to be accurate.}

\item{legendTitle}{a character vector specifying the legend title if applicable (\code{NULL} by default)}

\item{extendedLeg}{a logical value specifying if the extended footnote legend with additional information about the control-to-case ratio, overall vaccine efficacy, number of cases, etc., is to be included. Default is \code{TRUE}.}

\item{verboseLeg}{a logical value specifying if the extended footnote legend shall use English words (\code{TRUE} by default) or mathematical notation used in Gilbert, Janes, and Huang (2016)}

\item{margin}{a numeric vector of the form \code{c(bottom, left, top, right)}, which specifies the margins of the plot. Default is \code{c(11, 7, 3, 1)}.}
}
\value{
None. The function is called solely for plot generation.
}
\description{
Plots power (on the y-axis) to detect a correlate of risk effect size (on the x-axis) in the active treatment group for a continuous biomarker.
The correlate of risk effect size is quantified as the odds ratio of the clinical endpoint comparing subgroups of active treatment recipients with a 1 standard deviation difference in a
noise-free biomarker response.
}
\details{
If multiple levels are specified for the biomarker measurement error input argument \code{rho}, only the first level is used to determine
the \eqn{RR_c} values shown as x-axis tickmark labels.

The function's plot can be interpreted in conjunction with the output of \code{\link{plotVElatCont}} by
matching the CoR relative risk in the two plots and examining power compared to treatment (vaccine) efficacy.
This sheds light on the importance of overall vaccine efficacy on power and allows correlates of risk results
to be interpreted in terms of potential correlates of efficacy/protection.
}
\examples{
# Example scenario with continuous biomarker, where values of rho are varied

# Set input parameters for computePower function
nCasesTx <- 10
nControlsTx <- 300
nCasesTxWithS <- 10
controlCaseRatio <- 5
VEoverall <- 0.75
risk0 <- 0.034
PlatVElowest <- 0.2
VElowest <- seq(0, VEoverall, len=5)
Plat0 <- P0 <- 0.2
Plat2 <- P2 <- 0.6
M <- 22
alpha <- 0.05
sigma2obs <- 1
rho <- c(1, 0.7, 0.4)
biomType <- "continuous"

# Output from computePower function is stored in an object as a list of lists
pwr <- computePower(nCasesTx=nCasesTx, nCasesTxWithS=nCasesTxWithS, nControlsTx=nControlsTx,
                    controlCaseRatio=controlCaseRatio, risk0=risk0, VEoverall=VEoverall,
                    PlatVElowest=PlatVElowest, VElowest=VElowest,
                    Plat0=Plat0, Plat2=Plat2, P0=P0, P2=P2, M=M, alpha=alpha,
                    sigma2obs=sigma2obs, rho=rho, biomType=biomType)

# Set parameters for plotPowerCont function
# outComputePower is a list of lists containing output from the computePower function
outComputePower <- pwr
legendText <- paste0("rho = ", c(1, 0.7, 0.4))
plotPowerCont(outComputePower=outComputePower, legendText=legendText)

\dontrun{
# Output from computePower function is saved in RData files
computePower(..., saveDir = "myDir", saveFile = "myFile.RData")
# outComputePower is a character string specifying the file containing the
# computePower output
# outDir is a character string specifying the outComputePower file directory
outComputePower <- paste0("myFile_rho_", c(1, 0.7, 0.4), ".RData")
outDir <- "~/myDir"
legendText <- paste0("rho = ", c(1, 0.7, 0.4))
plotPowerCont(outComputePower, outDir=outDir, legendText = legendText)
}

}
\references{
Gilbert P. B., Janes H., and Huang Y. (2016), Power/Sample Size Calculations for Assessing Correlates of Risk in Clinical Efficacy Trials. \emph{Stat Med} 35(21):3745-59.
}
\seealso{
\code{\link{computePower}}, \code{\link{plotVElatCont}}, \code{\link{plotPowerTri}}
}
