% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BPBM_Matrix.R
\name{BPBM_Matrix}
\alias{BPBM_Matrix}
\title{Obtains the matrix of covariates of the BPBM}
\usage{
BPBM_Matrix(rows.position, PB, Tt)
}
\arguments{
\item{rows.position}{Vector. Vector with the number of the rows where the SPBal are in the matrix PB. We write first the row in which the balance with higher variance is placed, then the row in which the balance with second higher variance is placed...}

\item{PB}{Matrix. Each line os the matrix PB contains the values of one principal balance at all time points.}

\item{Tt}{Number of time points available.}
}
\value{
Returns a matrix with the covariates of the model.
}
\description{
This function writes the matrix of covariates of the BPBM.
}
\details{
In an example with two SPBal and three time points, the covariates are written in the following  order:

 \tabular{rrr}{
 1 \tab  1  \tab  1\cr
 \eqn{SPBal_{1,t-1}} \tab  \eqn{SPBal_{1,t-2}} \tab   \eqn{SPBal_{1,t-3}} \cr
 \eqn{SPBal_{2,t-1}} \tab  \eqn{SPBal_{2,t-2}} \tab   \eqn{SPBal_{2,t-3}} }
}
\examples{

matt=matrix(c(1:12),3,4)
rows.position=c(2,3)
BPBM_Matrix(rows.position,matt,4)


}
\references{
Creus-Martí, I., Moya, A., Santonja, F. J. (2022). Bayesian hierarchical compositional models for analysing longitudinal abundance data from microbiome studies. Complexity, 2022.
}
