/* Output from p2c, the Pascal-to-C translator */
/* From input file "coco_d_p2c.p" */


/*@+"constants.p"*/

/*@-"foreign.h"*/
/*@-"p2c.H"*/
/*@-"p2clib.C"*/

/*@-"constants.h"*/

/*

  " Copyright (c) 1991, 1996, 2002, by Jens Henrik Badsberg "

  The source code in C for this version of CoCo is available free of
  charge for non-commercial use.

  The source code may only be read and edited for the purpose of
  compiling CoCo, and porting CoCo to machines not currently
  supported by the author.
  No new features may be added to CoCo and no parts of the program
  may be included in other systems or new interface-procedures (at
  the C-side) to R, Splus, XLISP-STAT or other programs made without
  the written permission from the author.

*/


/* Options to 'p2c': */






#ifndef CoCo_Cygwin
   #include "foreign.h"
#else /* CoCo_Cygwin */
   #include "foreign-cygwin.h"
#endif /* CoCo_Cygwin */
   #include "p2c/p2c.h"
   #include "p2c/p2clib.c"

   #ifndef HAS_NOT_VALUES
   #include <values.h>
   #else
   #ifndef MAXDOUBLE
   #define MAXDOUBLE 3.4028234e38
   #define MAXFLOAT  3.4028234e38
   #endif
   #endif

   #include <stdio.h>

#ifdef CoCo_Cygwin
   #ifndef CHAR_MAX
     #define CHAR_MAX        '~'
   #endif
#else /* CoCo_Cygwin */
   #define CHAR_MAX        '~'
#endif /* CoCo_Cygwin */
 


   #ifdef ANSIGCC
   extern double log(double x);
   extern double exp(double x);
   extern double floor(double x);
   extern double sqrt(double x);
   extern double fabs(double x);
   extern double pow(double x, double y);
   #endif

 

/* #  ifdef CC-Ansi-plus
   #  endif CC-Ansi-plus */

/* #  ifdef CC-minus     





     #  endif CC-minus */



/*$ifdef On-DOS
program complete_contingency_tables(input, output);
 $endif On-DOS*/




#define N_START         1
#define P_START         0
#define Q_START         0
#define FIRST_INDEX     0
#define MINUS_FIRST_INDEX  0
#define FIRST_LEVEL     0

#define Ended_CoCo      2147483647L
#define Fixed_CoCo      2147483646L

#define No_ifail        0
#define No_ifail_return  (-1)
#define CoCo_ended_ifail  1

#define PCH_START       1
#define PCH_END         255
#define EM_UNIFORM      1
#define EM_FIRST        2
#define EM_LAST         3
#define EM_MEAN         4
#define EM_RANDOM       5
#define EM_INPUT        6
#define SWITCH_OFFSET   99
#define VALUE_OFFSET    100
#define MAX_NUMBER_OF_TABLE_VALUES  32
#define NUMBER_OF_MENUS  43
#define VERSION_A       140
#define VERSION_B       1

#define VERSION         " 1.5.R2.139  Fredag 14 Marts 2003, 11:30:48 MET"
/* #  ifdef CC-minus     
#define COMP_TIME       "                                                  "
#define COMP_MACH       " Compiled with pc, a Sun Pascal compiler for Sun4 "
     #  endif CC-minus */

   #ifdef ANSIGCC
   #define COMP_TIME " Compile-time: " __DATE__ ", " __TIME__ ".             "
   #ifndef COMP_MACH
   #define COMP_MACH " Compiled with cc, a C compiler for ...           "
   #endif
   #else
   #define COMP_TIME "                                                  "
   #ifndef COMP_MACH
   #define COMP_MACH " Compiled with cc, a C compiler for ...           "
   #endif
   #endif
 
#define COPYRIGHT       " Copyright (c) 1991, by Jens Henrik Badsberg      "
#define LICENSE         " Licensed to ...                                  "
#define DEFAULT_SPECIFICATION  "COCO.DAT                                "
#define DEFAULT_OBSERVATION  "COCO.DAT                                "
#define DEFAULT_TMP     "CoCo.tmp.YYY.XXXXXXX                    "
#define DEFAULT_DIARY   "CoCo.diary.YYY.XXXXXXX                  "
#define DEFAULT_REPORT  "CoCo.report.YYY.XXXXXXX                 "
#define DEFAULT_LOG     "CoCo.log.YYY.XXXXXXX                    "
#define DEFAULT_DUMP    "CoCo.dump.YYY.XXXXXXX                   "
#define FILE_NAME_NEW_HELP  "HELP.NEW                                "
#define FILE_NAME_HLP   "COCO.HLP                                "
#define FILE_NAME_DOC   "COCO.DOC                                "
#define FILE_NAME_TABLE  "COCO.TAB                                "
#define FILE_NAME_INIT  "INIT.TAB                                "
#define FILE_NAME_START_UP_HOME  ".cocolibrc                              "
#define FILE_NAME_START_UP  ".cocorc                                 "

   #ifdef __Windows_95_names__
#define DEFAULT_TMP              "tmp.CoCo.YYY.XXXXXXX                    "
#define DEFAULT_DIARY            "tmp.dia.YYY.XXXXXXX                     "
#define DEFAULT_REPORT           "tmp.rpt.YYY.XXXXXXX                     "
#define DEFAULT_LOG              "tmp.log.YYY.XXXXXXX                     "
#define DEFAULT_DUMP             "tmp.dmp.YYY.XXXXXXX                     "
#define FILE_NAME_START_UP_HOME  "CoCoLib.src                             "
#define FILE_NAME_START_UP       "CoCo.src                                "
   #else
   #endif
 

#define TURBO_PC        false

#define MIN_VERTEX      0
#define MAX_VERTEX      126
#define MAX_DIMENSION   128
#define MAX_2_DIMENSION  256
#define MAX_OFFSET_DIM  10

#define MAX_COUNT_NUMBER  2147483647L
#define MAX_CELL_NUMBER_MAX  1048576L
#define MAX_CELL_NUMBER_INIT  65536L
#define MAX_OFFSET_MAX  2147483646L
#define MAX_OFFSET      65534L
#define MAX_P_CELL_NUMBER_MAX  1048576L
#define MAX_P_CELL_NUMBER_INIT  65536L
#define MAX_Q_CELL_NUMBER_MAX  1048576L

#define MAX_Q_CELL_NUMBER_INIT  1024
#define MAX_OFFSET_CELL_NUMBER  1024
#define MAX_LEVEL       255
#define MAX_PAGE_LENGTH  256
#define MAX_LINE_LENGTH  128

#define NULL_CHAR       '@'
#define MIN_NAME        '\0'
#define MAX_NAME        CHAR_MAX

#define FILE_NAME_LENGTH  255
#define COMMAND_LENGTH  4
#define MAX_NUMBER_OF_PRODUCTIONS  1024
#define MAX_NUMBER_OF_COMMANDS  255
#define MAX_N_OF_COMMAND_TESTS  3
#define MISSING_LEVEL   255
#define _UNDEF_LEVEL    254
#define _INVALID_LEVEL  253

#define _INVALID_REAL   (-MAXDOUBLE)
#define INFINITY_REAL   MAXDOUBLE
#define _INVALID_SHORT_REAL  (-MAXFLOAT)
#define INFINITY_SHORT_REAL  MAXFLOAT
#define ROUND_ERROR     1e-15

#define MAX_FIND_ALL    8
#define N_LIMIT         1000

#define N_LIMIT_T       0.5

#define MAX_CASES_IN_LIST  100000L
#define MAXIMAL_COUNT   2147483643L
#define MAXIMAL         2147483643L
#define STRUCT_ZERO_COUNT  2147483644L
#define STRUCT_ZERO     2147483644L
#define _INVALID_COUNT  2147483645L
#define _INVALID        2147483645L
#define _UNDEF_COUNT    2147483646L
#define _UNDEF          2147483646L
#define MISSING         2147483647L
#define INFINITY        2147483647L

#define MAX_FACT        1000
#define DELTA_INTERRUPT  500


/*$ifdef On-DOS
n_start = 1;
p_start = 0;
q_start = 0;
first_index = 0;
minus_first_index = 0;
first_level = 0;
ended_coco = 2147483647;
fixed_coco = 2147483646;
no_ifail = 0;
no_ifail_return = -1;
coco_ended_ifail = 1;
pch_start = 1;
pch_end = 255;
em_uniform = 1;
em_first = 2;
em_last = 3;
em_mean = 4;
em_random = 5;
em_input = 6;
switch_offset = 99;
value_offset = 100;
max_number_of_table_values = 32;
number_of_menus = 43;
version_a = 140;
version_b = 1;
version = ' 1.5.R2.139  Fredag 14 Marts 2003, 11:30:48 MET';
comp_time = '                                                  ';
comp_mach = ' Compiled with Borland Pascal 7.0 for PC          ';
copyright = ' Copyright (c) 1991, by Jens Henrik Badsberg      ';
license = ' Licensed to ...                                  ';
default_specification   = 'COCO.DAT                                ';
default_observation     = 'COCO.DAT                                ';
default_diary           = 'COCOYYY.DIA                             ';
default_log             = 'COCOYYY.LOG                             ';
default_report          = 'COCOYYY.RPT                             ';
default_tmp             = 'COCOYYY.TMP                             ';
default_dump            = 'COCOYYY.DMP                             ';
file_name_new_help      = 'HELP.NEW                                ';
file_name_hlp           = 'COCO.HLP                                ';
file_name_doc           = 'COCO.DOC                                ';
file_name_table         = 'COCO.TAB                                ';
file_name_init          = 'INIT.TAB                                ';
file_name_start_up_home = 'COCOLIB.SRC                             ';
file_name_start_up      = 'COCO.SRC                                ';
min_char = #00;
max_char = #127;
null_char = min_char;
minchar = min_char;
maxchar = max_char;
turbo_pc = true;
min_vertex = 0;
max_vertex = 63;
max_dimension = 64;
max_2_dimension = 128;
max_offset_dim = 9;
max_count_number = 65535;
max_cell_number_max = 1048576;
max_cell_number = 32766;
max_p_cell_number_max = 1048576;
max_p_cell_number = 10921;
max_offset_max = 2147482646;
max_offset = 65534;
max_offset_cell_number = 512;
max_level = 63;
max_page_length = 256;
max_line_length = 128;
min_name = minchar;
max_name = maxchar;
file_name_length = 255;
command_length = 4;
max_number_of_productions = 1024;
max_number_of_commands = 255;
max_n_of_command_tests = 3;
missing_level = 63;
_undef_level = 62;
_invalid_level = 61;
_invalid_real = -MAXDOUBLE;
infinity_real = MAXDOUBLE;
_invalid_short_real = -MAXFLOAT;
infinity_short_real = MAXFLOAT;
round_error = 1e-15;
max_find_all = 6;
n_limit = 1000;
n_limit_t = 5;
max_cases_in_list = 200;
maximal_count = 65532;
maximal = 65532;
struct_zero_count = 65532;
struct_zero = 65532;
_invalid_count = 65533;
_invalid = 65533;
_undef_count = 65534;
_undef = 65534;
missing = 65535;
infinity = 2147483647;
max_q_cell_number_max = 2147482646;
max_q_cell_number = 1024;
max_fact = 1000;
delta_interrupt = 500;
 $endif On-DOS*/

/*@+"types.p"*/
/*@-"types.h"*/

typedef Char pch10[10];
typedef Char pch20[20];
typedef Char pch30[30];
typedef Char pch40[40];
typedef Char pch50[50];
typedef Char pch_long[PCH_END - PCH_START + 1];
typedef pch_long t_arr_of_pch_long[2];

typedef float t_real;

typedef double t_long_real;


/*$ifdef On-DOS
t_real = real;
t_long_real = double;
 $endif On-DOS*/
typedef long t_integer;


typedef long t_long_integer;


/*$ifdef On-DOS
t_long_integer = longint;
 $endif On-DOS*/
typedef uchar t_0_max_dimension;

typedef uchar t_1_max_dimension;

typedef Char t_command_name[COMMAND_LENGTH];
typedef uchar t_command_level;

typedef pch_long t_line;

typedef struct t_command_des {
  t_command_level current_level, next_level, offset;
  t_command_name name;
} t_command_des;

typedef t_command_des t_command_array[MAX_NUMBER_OF_PRODUCTIONS];
typedef pch30 t_command_text[MAX_NUMBER_OF_COMMANDS + 1];
typedef enum {
  all, necessary, list_file, both
} t_datastructure;
typedef enum {
  normal_ips, arithmetic, geometric, harmonic
} t_mean_ips_in_use;
typedef enum {
  menu, command
} t_mode;
typedef char t_vertex;

typedef long t_vertex_set[MAX_VERTEX / 32 + 2];

typedef struct _REC_t_vertex_inf {
  uchar levels_total, levels_missing, levels;
  char name;
} _REC_t_vertex_inf;

typedef struct t_vertex_list {
  unsigned vertex : 7;
  struct t_vertex_list *pointer;
} t_vertex_list;

typedef struct t_edge_list {
  unsigned v : 7, w : 7;
  struct t_edge_list *pointer;
} t_edge_list;

typedef struct t_list_of_vertex_lists {
  t_vertex_list *vertex_list;
  struct t_list_of_vertex_lists *pointer;
} t_list_of_vertex_lists;

typedef struct t_set_list {
  t_vertex_set vertex_set;
  struct t_set_list *pointer;
} t_set_list;

typedef struct t_g_c_list {
  t_set_list *g_c;
  struct t_g_c_list *pointer;
} t_g_c_list;

typedef long t_level_arr_of_integer[MAX_LEVEL];
typedef long t_level_2_arr_of_integer[MAX_LEVEL][MAX_LEVEL];
typedef boolean t_u_v_arr_of_boolean[MAX_VERTEX - MIN_VERTEX + 1];
typedef uchar t_v_arr_of_boolean[(MAX_VERTEX - MIN_VERTEX + 8) / 8];
typedef t_vertex t_v_arr_of_vertex[MAX_VERTEX - MIN_VERTEX + 1];
typedef t_vertex_set t_v_arr_of_v_sets[MAX_VERTEX - MIN_VERTEX + 1];
typedef t_vertex_list *t_v_arr_of_v_lists[MAX_VERTEX - MIN_VERTEX + 1];
typedef short t_v_arr_of_order[MAX_VERTEX - MIN_VERTEX + 1];
typedef t_vertex t_o_arr_of_vertex[MAX_DIMENSION];
typedef t_long_integer t_v_arr_of_integer[MAX_VERTEX - MIN_VERTEX + 1];
typedef long t_cell_count;


typedef long t_cell_index;

typedef long t_e_cell_index;

typedef long t_p_cell_index;

typedef long t_e_p_cell_index;

typedef long t_q_cell_index;

typedef long t_e_q_cell_index;

typedef long t_array_index;

typedef t_cell_count t_n[MAX_CELL_NUMBER_MAX + 1];
typedef t_real t_p[MAX_P_CELL_NUMBER_MAX + 1];

/*$ifdef On-DOS
t_cell_index = 0..max_cell_number;
t_e_cell_index = minus_first_index..max_cell_number;
t_p_cell_index = 0..max_p_cell_number;
t_e_p_cell_index = minus_first_index..max_p_cell_number;
t_q_cell_index = 0..max_q_cell_number;
t_e_q_cell_index = minus_first_index..max_q_cell_number;
t_array_index = 0..1023;
t_n_array = packed array [t_cell_index] of t_cell_count;
t_n = ^ t_n_array;
t_p_array = array [t_p_cell_index] of t_real;
t_p = ^ t_p_array;
 $endif On-DOS*/
typedef Char t_char_array[MAX_P_CELL_NUMBER_MAX + 1];
typedef t_char_array t_string_array[1];
typedef boolean t_boolean_array[MAX_P_CELL_NUMBER_MAX + 1];

typedef t_integer t_int_array[MAX_P_CELL_NUMBER_MAX + 1];

/*$ifdef On-DOS
t_int_array = array [t_array_index] of t_long_integer;
 $endif On-DOS*/
typedef t_long_integer t_long_array[MAX_P_CELL_NUMBER_MAX + 1];
typedef t_real t_float_array[MAX_P_CELL_NUMBER_MAX + 1];
typedef t_long_real t_double_array[MAX_P_CELL_NUMBER_MAX + 1];
typedef t_long_integer t_q[MAX_Q_CELL_NUMBER_MAX + 1];
typedef uchar t_level;

typedef t_level t_cell[MAX_VERTEX - MIN_VERTEX + 1];

typedef struct t_cell_list {
  t_vertex_list *vertex_list;
  t_cell cell;
  struct t_cell_list *pointer;
} t_cell_list;

typedef struct t_case_list {
  t_cell cell;
  struct t_case_list *pointer;
} t_case_list;

typedef char t_vertex_name;

typedef pch_long t_long_vertex_name;
typedef long t_name_set[MAX_NAME / 32 + 2];

typedef _REC_t_vertex_inf t_vertex_inf[MAX_VERTEX - MIN_VERTEX + 1];
typedef t_vertex t_name_to_vertex[MAX_NAME - MIN_NAME + 1];

typedef struct t_vertex_name_list {
  t_vertex vertex;
  t_integer length;
  pch_long name;
  struct t_vertex_name_list *pointer;
} t_vertex_name_list;

typedef struct t_real_list {
  t_long_real x;
  struct t_real_list *pointer;
} t_real_list;

typedef struct t_integer_list {
  t_long_integer x;
  struct t_integer_list *pointer;
} t_integer_list;

typedef struct t_two_integers_list {
  t_long_integer a, b;
  struct t_two_integers_list *pointer;
} t_two_integers_list;

typedef long t_offset;


/*$ifdef On-DOS
t_offset = -1..max_offset;
 $endif On-DOS*/
typedef short t_offset_index;

typedef t_offset t_offset_array[MAX_OFFSET_CELL_NUMBER];

typedef struct t_offset_list {
  t_vertex_set vertex_set;
  t_offset offset;
  struct t_offset_list *pointer;
} t_offset_list;

typedef struct t_expression {
  t_vertex_set vertex_set;
  t_long_integer factor, card;
  t_offset offset;
  struct t_expression *pointer;
} t_expression;

typedef struct t_ips_set_list {
  t_vertex_set vertex_set;
  t_offset n_offset;
  struct t_ips_set_list *pointer;
} t_ips_set_list;

typedef struct t_ips_element {
  boolean radim_part;
  t_vertex_set a;
  t_offset p_offset, n_offset;
  t_offset_list *link_q_tables;
  t_ips_set_list *gen_class;
} t_ips_element;

typedef struct t_list_ips_elements {
  t_ips_element ips_element;
  struct t_list_ips_elements *pointer;
} t_list_ips_elements;

typedef struct t_radim_part {
  t_offset_list *generators, *upper, *lower, *from;
  struct t_radim_part *pointer;
} t_radim_part;

typedef struct t_radim_element {
  t_radim_part *radim_parts;
  t_vertex_set a;
  t_integer_list *lower_n_offsets;
  t_offset_list *link_q_tables;
  t_ips_set_list *gen_class;
} t_radim_element;

typedef struct t_list_radim_elements {
  t_radim_element radim_element;
  struct t_list_radim_elements *pointer;
} t_list_radim_elements;

typedef struct t_model {
  boolean graphical, decomposable, found_log_l, found_expression, found_ps;
  t_set_list *sets_h_g_c;
  t_vertex_set model_set;
  t_long_real constant;
  t_expression *expression;
  t_list_ips_elements *ips_list;
  t_list_radim_elements *radim_list;
  t_long_real log_l;
  t_long_integer dim, model_number;
} t_model;

typedef struct t_model_list {
  t_model model;
  struct t_model_list *pointer;
} t_model_list;

typedef struct t_test {
  t_set_list *g_c_1, *g_c_2;
  t_long_integer n_count, number_of_tables, df, adj, paritet;
  t_long_real df_real, gamma, s, s1, x_power, x_pearson, x_deviance,
	      mcep_gamma_1, mcep_gamma_2, mcep_power, mcep_pearson,
	      mcep_deviance;
  unsigned ok : 1;
} t_test;

typedef struct t_test_list {
  t_test test;
  struct t_test_list *pointer;
} t_test_list;

typedef struct t_part_list {
  t_test_list *link_test_list;
  struct t_part_list *pointer;
} t_part_list;

typedef struct t_sort_list {
  t_long_real x;
  t_vertex_set vertex_set;
  t_test_list *link_test_list;
  t_part_list *link_part_list, *link_sepa_list;
  struct t_sort_list *pointer;
} t_sort_list;

typedef struct t_file_list {
  FILE *com_file;
  pch_long name;
  struct t_file_list *pointer;
} t_file_list;

typedef t_real_list *t_cutpoints[MAX_VERTEX - MIN_VERTEX + 1];

typedef struct t_product_list {
  t_vertex_set c_in_a;
  t_long_integer product;
  t_v_arr_of_integer prod_1, prod_2;
  struct t_product_list *pointer;
} t_product_list;

typedef struct t_adj_set_list {
  t_v_arr_of_v_sets adj_set;
  struct t_adj_set_list *pointer;
} t_adj_set_list;

typedef struct t_eh_pack {
  boolean graphical_search, fix_in, fix_out;
  t_long_real search_time;
  t_long_integer search_strategy, search_opt;
  t_vertex_set g;
  t_model_list *link_base;
  t_set_list *fix_out_gc_x, *fix_in_gc_x, *fix_out_gc, *fix_in_gc;
  t_g_c_list *d_a, *d_r, *a, *r;
  t_v_arr_of_v_sets fix_out_adj_set, fix_in_adj_set;
} t_eh_pack;

typedef struct t_cell_element {
  t_long_integer n;
  t_long_real p;
  t_cell cell;
} t_cell_element;

typedef struct t_slice_pack {
  t_v_arr_of_integer levels, product_a_v, product_b_v, product_a_w,
		     product_b_w, product_a_vw, product_b_vw;
  t_cell_index p_vc_v, p_wc_w, p_vwc_v, p_vwc_w;
  t_long_integer marginal_dimension_c;
  t_vertex l;
} t_slice_pack;

typedef enum {
  first, not_first
} t_am_node_type;

typedef struct t_am_node {
  struct t_am_edge_list *link_edge;
  struct t_am_node *forward_link;
  t_am_node_type node_type;
  union {
    struct t_am_node *backward_link;
    t_vertex vertex;
  } UU;
} t_am_node;

typedef t_am_node *t_v_arr_of_am_nodes[MAX_VERTEX - MIN_VERTEX + 1];

typedef struct t_am_node_ref {
  t_am_node *node;
  struct t_am_node_ref *pointer;
} t_am_node_ref;

typedef struct t_am_edge_list {
  t_integer size, card, beta, gamma;
  struct t_hyper_set_node *hyper_set_node;
  t_vertex_set vertex_set;
  t_am_node_ref *nodes;
  struct t_am_edge_list *forward_link, *backward_link;
} t_am_edge_list;

typedef struct t_adjacency_matrix {
  t_v_arr_of_am_nodes vertex_list;
  t_am_edge_list *am_edge_list;
} t_adjacency_matrix;

typedef struct t_hyper_set_node {
  t_am_edge_list *link_edge;
  struct t_hyper_set_list *hyper_set;
  struct t_hyper_set_node *forward_link, *backward_link;
} t_hyper_set_node;

typedef struct t_hyper_set_list {
  t_hyper_set_node *node;
  struct t_hyper_set_list *forward_link, *backward_link;
} t_hyper_set_list;

typedef long t_2_3_key;

typedef enum {
  offset_tree, test_tree
} t_2_3_tree_type;

typedef struct t_2_3_element {
  t_2_3_key key;
  t_2_3_tree_type tree_type;
  union {
    t_offset_list *offset_element;
    t_test_list *test_element;
  } UU;
} t_2_3_element;

typedef struct t_2_3_leaf {
  t_2_3_key key;
  long count;
  t_2_3_tree_type tree_type;
  union {
    t_offset_list *offset_list;
    t_part_list *test_list;
  } UU;
} t_2_3_leaf;

typedef enum {
  leaf, interior
} t_2_3_node_type;

typedef struct t_2_3_node {
  long count;
  t_2_3_node_type node_type;
  union {
    t_2_3_leaf *leaf_;
    struct {
      struct t_2_3_node *firstchild, *secondchild, *thirdchild;
      t_2_3_key lowofsecond, lowofthird;
    } U1;
  } UU;
} t_2_3_node;

/*@+"variables.p"*/
/*@-"variables.c"*/


/* #  ifdef Multiple-Objects-minus */
/* #  endif Multiple-Objects-minus */

Static char command_test[MAX_NUMBER_OF_COMMANDS + 1][MAX_N_OF_COMMAND_TESTS];
Static t_mode mode;
Static t_command_array command_array;
Static t_long_integer number_of_productions, menu_number,
		      first_model_available, em_initial, em_max_it,
		      ips_max_it, number_of_tables, seed, max_fact_found, pid,
		      sigall, tmp_count, char_count, line_count, page_count,
		      page_length, page_pause_length, line_length, prob_width,
		      prob_dec, x_width, x_dec, print_width, print_dec, width,
		      decprob, decexpt, decdiff, init_n_of_tables,
		      observation_line_number, data_line_number,
		      data_line_position, last_interrupt_time_1,
		      last_interrupt_time_2, interrupt_count;
Static long command_char[9];
Static t_command_text command_text;
Static pch10 prompt;
Static t_integer prompt_length;
Static long begin_set[9], end_set[9], end_gc[9], end_gc_list[9], end_mark[9];

Static FILE *data_file, *spec_file;

/*$ifdef On-DOS
command_file, output, output, data_file, spec_file: text;
 $endif On-DOS*/
Static FILE *file_read, *file_excluded;
Static t_case_list *case_list_read, *case_list_excluded, *case_list;
Static boolean print_case_list, space_for_case_list;
Static pch_long file_name_read, file_name_excluded, command_name,
		results_name, response_name, data_name, spec_name;
Static boolean term, terminal, read_spec, read_obs;
Static t_offset_array offset;
Static t_offset_list *link_offset_list;
Static t_2_3_node *offset_2_3_tree;
Static t_cell_index fna;

Static long fpa;

/*$ifdef On-DOS
fpa: minus_first_index..max_p_cell_number;
 $endif On-DOS*/

/* #  ifdef Resize-post-minus   

Static t_n n;
Static t_p p;
Static t_q q_array;

   #  endif Resize-post-minus */


/* #  ifdef Resize-post-plus-x */

 Static long *n;
 Static float *p;
 Static long *q_array;

  /* #  endif Resize-post-plus-x */



Static long fqa;

/*$ifdef On-DOS
fqa: minus_first_index..max_q_cell_number;
 $endif On-DOS*/
Static t_offset_list *q_tables_offsets;
Static t_set_list *g_c_q_tables;
Static t_cell first_cell, last_cell, full_last_cell;
Static t_vertex first_vertex, last_vertex, full_last_vertex;
Static t_vertex_inf vertex_inf, full_vertex_inf;
Static t_name_to_vertex name_to_vertex, full_name_to_vertex;
Static t_vertex_set delta, full_delta;
Static t_name_set names, full_names;
Static uchar dimension, full_dimension;
Static t_vertex_name_list *name_list, *full_name_list;
Static t_cell_index number_of_cells;
Static t_datastructure datastructure;
Static boolean datastructure_selected, hash_overflow, permit_log_l, large,
	       sorted, read_subset, long_names;
Static t_vertex_set empty_set, subset, ordinal_factors;
Static t_cutpoints cutpoints;
Static boolean reject_missing, exclude_missing;
Static t_vertex_set delta_missing_excluded;
Static t_cell_list *link_select, *link_reject;
Static t_model_list *link_model_list, *link_current, *link_base, *link_full;
Static t_2_3_node *test_2_3_tree;
Static t_test_list *link_test_list;
Static t_part_list *link_part_list;
Static char ips_in_use;
Static t_mean_ips_in_use mean_ips_in_use;
Static char c_factorizes;
Static boolean in_fact_inter, in_test, in_search, partitioning_output,
	       c_partitioning, ordinal_tests, initial_values_for_ips,
	       exact_test_for_test_models, exact_test_for_partitioning,
	       exact_test_for_sum_up, exact_test, exact_log_l, fast, ic, bic,
	       just, reversed, sorted_list, short_report, alternative, direct,
	       coherent, follow, separators, brute, random_order,
	       short_test_output, global_write_models, graph_mode,
	       decomposable_mode, re_use_test, adj_df, decompose_incomplete,
	       incomplete_table, em, pause_output, timer, echo, echo_note,
	       trace, debug, note_warnings, permit_condensed, dummy_option,
	       std_input_set, file_read_set, file_excluded_set, spec_file_set,
	       data_file_set;
Static t_long_real alfa_, alfa_reject, asymptotic_limit, parts_limit,
		   separators_limit, exact_epsilon, ic_lambda, lambda,
		   ips_epsilon, em_epsilon, my_var_na_double;
Static char test_choice;
Static t_two_integers_list *link_n_of_tables;
Static t_long_real fact_array[MAX_FACT + 1];
Static t_set_list *fix_edges_gc_x, *fix_edges_gc;
Static t_v_arr_of_v_sets fix_edges_adj_set;
Static t_eh_pack *link_eh_pack;
/*$ifdef TRACE*/
Static boolean boolean_option[32];
/*$endif TRACE*/
Static t_real my_var_na_float;
Static pch_long last_data_line;

/* #  ifdef Multiple-Objects-minus */
/* #  endif Multiple-Objects-minus */

/* #  ifdef Multiple-Objects-plus
   #  endif Multiple-Objects-plus */

Static FILE *diary_file, *log_file, *dump_file, *report_file;
Static pch_long diary_name, log_name, dump_name, report_name;
Static boolean diary, log_on, log_data_on, dump, report, diary_set, log_set,
	       dump_set, report_set, default_dump_set, exit_after_start_up,
	       interrupt_x, interrupt_1, interrupt_2, interrupt_3;
Static Char *link_coco_tmp, *link_coco_lib, *link_coco_home;
/*$ifdef On-DOS
traceoverlay: boolean;
useroverlaysize: longint;
userretrysize: longint;
stdovrreadbuf: ovrreadfunc;
 $endif On-DOS*/
Static t_long_integer max_cases_in_list_var, max_cell_number,
		      max_p_cell_number, max_q_cell_number;


/*@+"io.p"*/

/* Read from Stdin: */

Static Void read_stdio_char(f, c)
FILE *f;
Char *c;
{
  *c = getc(f);
  if (*c == EOF)
    _EscIO(EndOfFile);
  if (*c == '\n')
    *c = ' ';
}  /* read_text_char */


Static Void read_stdin_ln()
{
  if (scanf("%*[^\n]") == EOF)
    _EscIO(EndOfFile);
  if (getchar() == EOF)
    _EscIO(EndOfFile);
}  /* readln_stdin */


Static boolean eoln_stdin()
{
  return P_eoln(stdin);
}  /* eoln_stdin */


Static boolean eolnnotf(f)
FILE *f;
{
  if (P_eof(f))
    return false;
  else
    return P_eoln(f);
}  /* eolnnotf */


Static boolean eolnorf(f)
FILE *f;
{
  if (P_eoln(f))
    return true;
  else
    return P_eof(f);
}  /* eolnorf */


Static boolean eoln_command(command_file)
FILE *command_file;
{
  return P_eoln(command_file);
}  /* eoln_command */


Static boolean eof_command(command_file)
FILE *command_file;
{
  return P_eof(command_file);
}  /* eof_command */


Static boolean eolnnotf_command(command_file)
FILE *command_file;
{
  if (eof_command(command_file))
    return false;
  else
    return (eoln_command(command_file));
}  /* eolnnotf_command */


Static boolean eolnorf_command(command_file)
FILE *command_file;
{
  if (eoln_command(command_file))
    return true;
  else
    return (eof_command(command_file));
}  /* eolnorf_command */


Static boolean eoln_data(data_file)
FILE *data_file;
{
  return P_eoln(data_file);
}  /* eoln_data */


Static boolean eof_data(data_file)
FILE *data_file;
{
  return P_eof(data_file);
}  /* eof_data */


Static boolean eolnnotf_data(data_file)
FILE *data_file;
{
  if (eof_data(data_file))
    return false;
  else
    return (eoln_data(data_file));
}  /* eolnnotf_data */


Static boolean eolnorf_data(data_file)
FILE *data_file;
{
  if (eoln_data(data_file))
    return true;
  else
    return (eof_data(data_file));
}  /* eolnorf_data */


/* Read from text-file: */

Static Void read_text_char(f, c)
FILE *f;
Char *c;
{
  *c = getc(f);
  if (*c == EOF)
    _EscIO(EndOfFile);
  if (*c == '\n')
    *c = ' ';
}  /* read_text_char */


Static Void read_text_ln(f)
FILE *f;
{
#ifndef CoCo_Cygwin
  if (fscanf(f, "%*[^\n]") == EOF)
#else /* CoCo_Cygwin */
  /* */
  char *buf;
  int n;

  buf = (char *)Malloc(128);
  if (buf == NULL)
    _OutMem();
#ifdef DEBUG_F
  /* F */ printf("read_text_ln [ ");
  /* F */ printf("read_text_ln [ ");
#endif /* F */
  n = 0 /* fscanf(f, "%*[^\n]") */ /* fgets(buf, 10, f) */ ;
#ifdef DEBUG_F
  /* F */ printf(" n: %*ld ; buf: `", 2, n);
  /* F */ printf(buf);
#endif /* F */
  if (n == EOF)
#endif /* CoCo_Cygwin */
    _EscIO(EndOfFile);
#ifndef CoCo_Cygwin
  if (getc(f) == EOF)
#else /* CoCo_Cygwin */
#ifdef DEBUG_F
  /* F */ printf("' ; ");
#endif /* F */
  n = getc(f);
#ifdef DEBUG_F
  /* F */ printf(" getc: %*ld ", 2, n);
#endif /* F */
  if (n == EOF)
#endif /* CoCo_Cygwin */
    _EscIO(EndOfFile);
#ifdef CoCo_Cygwin
#ifdef DEBUG_F
  /* F */ printf(" ] \n");
#endif /* F */
  Free(buf);
  /* */

  /*  if (fscanf(f, "%*[^\n]") == EOF)
    _EscIO(EndOfFile);
  if (getc(f) == EOF)
  _EscIO(EndOfFile); */
#endif /* CoCo_Cygwin */
}  /* read_text_ln */


Static Void read_text_integer(f, w, i)
FILE *f;
long w, *i;
{
#ifndef CoCo_Cygwin
  if (fscanf(f, "%ld", i) == EOF)
#else /* CoCo_Cygwin */
  /* */
  char *buf;

#ifdef DEBUG_F
  /* F */ printf("read_text_integer [ ");
#endif /* F */
  buf = (char *)Malloc(128);
#ifdef DEBUG_F
  /* F */ printf(" w: %*ld ; buf: `", 2, w);
#endif /* F */
  if (buf == NULL)
    _OutMem();
  buf = fgets(buf, w+1, f);
#ifdef DEBUG_F
  /* F */ printf(buf);
  /* F */ printf("' ; ");
#endif /* F */
  if (buf == NULL)
#endif /* CoCo_Cygwin */
    _EscIO(EndOfFile);
#ifdef CoCo_Cygwin
  else
    sscanf(buf, "%ld", i);
    Free(buf);
#ifdef DEBUG_F
  /* F */ printf(" i: %*ld ] \n", 4, *i);
#endif /* F */
  /* */

  /* if (fscanf(f, "%ld", i) == EOF)
     _EscIO(EndOfFile); */
#endif /* CoCo_Cygwin */
}  /* read_text_integer */



/* Read from Guide: */

Static Void read_guide_char(guide, c)
FILE *guide;
Char *c;
{
  *c = getc(guide);
  if (*c == EOF)
    _EscIO(EndOfFile);
  if (*c == '\n')
    *c = ' ';
}  /* read_guide_char */


Static Void read_guide_integer(guide, w, i)
FILE *guide;
long w, *i;
{
  read_text_integer(guide, w, i);
}  /* read_guide_integer */


Static Void read_guide_ln(guide)
FILE *guide;
{
  read_text_ln(guide);
}  /* read_guide_ln */


Static boolean eoln_guide(guide)
FILE *guide;
{
  return P_eoln(guide);
}  /* eoln_guide */


Static boolean eof_guide(guide)
FILE *guide;
{
  return P_eof(guide);
}  /* eof_guide */


Static boolean eolnnotf_guide(guide)
FILE *guide;
{
  if (eof_guide(guide))
    return false;
  else
    return (eoln_guide(guide));
}  /* eolnnotf_guide */


Static boolean eolnorf_guide(guide)
FILE *guide;
{
  if (eoln_guide(guide))
    return true;
  else
    return (eof_guide(guide));
}  /* eolnorf_guide */


/* Read from Parser: */

Static Void read_parser_char(parser, c)
FILE *parser;
Char *c;
{
  *c = getc(parser);
  if (*c == EOF)
    _EscIO(EndOfFile);
  if (*c == '\n')
    *c = ' ';
}  /* read_parser_char */


Static Void read_parser_integer(parser, w, i)
FILE *parser;
long w, *i;
{
  read_text_integer(parser, w, i);
}  /* read_parser_integer */


Static Void read_parser_level(parser, w, l)
FILE *parser;
long w;
t_command_level *l;
{
  t_long_integer i;

  read_text_integer(parser, w, &i);
  *l = i;
}  /* read_parser_level */


Static Void read_parser_ln(parser)
FILE *parser;
{
  read_text_ln(parser);
}  /* read_parser_ln */


Static boolean eoln_parser(parser)
FILE *parser;
{
  return P_eoln(parser);
}  /* eoln_parser */


Static boolean eof_parser(parser)
FILE *parser;
{
  return P_eof(parser);
}  /* eof_parser */


Static boolean eolnnotf_parser(parser)
FILE *parser;
{
  if (eof_parser(parser))
    return false;
  else
    return (eoln_parser(parser));
}  /* eolnnotf_parser */


Static boolean eolnorf_parser(parser)
FILE *parser;
{
  if (eoln_parser(parser))
    return true;
  else
    return (eof_parser(parser));
}  /* eolnorf_parser */


/* Reset / rewind */

Static Void reset_(f)
FILE *f;
{
#ifndef CoCo_Cygwin
  rewind(f);
#else /* CoCo_Cygwin */
  fseek(f, 0L, SEEK_SET);
#endif /* CoCo_Cygwin */
}


Static Void reset_level_file(f)
FILE *f;
{
#ifndef CoCo_Cygwin
  rewind(f);
#else /* CoCo_Cygwin */
  reset_(f);
#endif /* CoCo_Cygwin */
}  /* reset_level_file */


Static Void reset_integer_file(f)
FILE *f;
{
#ifndef CoCo_Cygwin
  rewind(f);
#else /* CoCo_Cygwin */
  reset_(f);
#endif /* CoCo_Cygwin */
}  /* reset_integer_file */


Static Void reset_real_file(f)
FILE *f;
{
#ifndef CoCo_Cygwin
  rewind(f);
#else /* CoCo_Cygwin */
  reset_(f);
#endif /* CoCo_Cygwin */
}  /* reset_real_file */


/* Write / putc - stdout */

#ifdef CoCo_Cygwin

Static Void print_my_c(c)
Char c;
{
  Char c_str[2];

  c_str[0] = c;
  c_str[1] = '\0';
  printf(c_str);
}  /* print_my_c */


#endif /* CoCo_Cygwin */
Static Void write_char_stdout(c)
Char c;
{
#ifndef CoCo_Cygwin
  putchar(c);
#else /* CoCo_Cygwin */

  print_my_c(c);
  /* putchar(c); */
#endif /* CoCo_Cygwin */
}  /* write_char_stdout */


Static Void write_line_stdout()
{
#ifndef CoCo_Cygwin
  putchar('\n');
#else /* CoCo_Cygwin */
#ifdef DEBUG_F
  /* F */ printf("write_line_stdout 1 \n");
#endif /* F */
  printf("\n");
  /* putchar('\n'); */
#endif /* CoCo_Cygwin */
}  /* write_line_stdout */


/* Write / putc */

Static Void write_char_text(f, c)
FILE *f;
Char c;
{
#ifdef CoCo_Cygwin
#ifdef DEBUG_F
  /* F */ printf("write_char_text [ c: `");
#endif /* F */
  if (f == stdout) {
    print_my_c(c);
  } else
#endif /* CoCo_Cygwin */
  putc(c, f);
#ifdef CoCo_Cygwin
#ifdef DEBUG_F
  /* F */ printf("' ] \n");
#endif /* F */
#endif /* CoCo_Cygwin */
}  /* write_char_text */


Static Void writeln_pch_50_text(f, c, str, w)
FILE *f;
Char c;
Char *str;
long w;
{
  t_long_integer i;

#ifdef CoCo_Cygwin
  if (f == stdout) {
    print_my_c(c);
    for (i = 0; i < w; i++)
      print_my_c(str[i]);
    print_my_c('\n');
  } else {
    putc(c, f);
    for (i = 0; i < w; i++)
      putc(str[i], f);
    putc('\n', f);
  }
#else /* CoCo_Cygwin */
  putc(c, f);
  for (i = 0; i < w; i++)
    putc(str[i], f);
  putc('\n', f);
#endif /* CoCo_Cygwin */
}  /* writeln_pch_50_text */


Static Void write_space_text(f, w)
FILE *f;
long w;
{
  t_long_integer i;

  for (i = 1; i <= w; i++)
#ifdef CoCo_Cygwin
    if (f == stdout)
      printf(" ");
    else
#endif /* CoCo_Cygwin */
    putc(' ', f);
}  /* write_space_text */


Static Void write_boolean_text(f, b, w)
FILE *f;
boolean b;
long w;
{
  fputs(b ? " TRUE" : "FALSE", f);
}  /* write_boolean_text */


Static Void write_char_n_text(f, c, w)
FILE *f;
Char c;
long w;
{
  t_long_integer i;

#ifdef CoCo_Cygwin
#ifdef DEBUG_F
  /* F */ printf("write_char_n_text [ c: `");
#endif /* F */
#endif /* CoCo_Cygwin */
  for (i = 1; i <= w; i++)
#ifdef CoCo_Cygwin
    if (f == stdout) {
      print_my_c(c);
    } else
#endif /* CoCo_Cygwin */
    putc(c, f);
#ifdef CoCo_Cygwin
#ifdef DEBUG_F
  /* F */ printf("` ]");
#endif /* F */
#endif /* CoCo_Cygwin */
}  /* write_char_n_text */


Static Void write_pch_10_text(f, c, w)
FILE *f;
Char *c;
long w;
{
  t_long_integer i;

#ifndef CoCo_Cygwin
  for (i = 0; i < w; i++)
    putc(c[i], f);
#else /* CoCo_Cygwin */
  if (f == stdout)
    printf("%.*s", (int)w, c);  
  else
  fprintf(f, "%.*s", (int)w, c);
#endif /* CoCo_Cygwin */
}  /* write_pch_10_text */


Static Void write_pch_20_text(f, c, w)
FILE *f;
Char *c;
long w;
{
  t_long_integer i;

#ifndef CoCo_Cygwin
  for (i = 0; i < w; i++)
    putc(c[i], f);
#else /* CoCo_Cygwin */
  if (f == stdout)
    printf("%.*s", (int)w, c);  
  else
  fprintf(f, "%.*s", (int)w, c);
#endif /* CoCo_Cygwin */
}  /* write_pch_20_text */


Static Void write_pch_30_text(f, c, w)
FILE *f;
Char *c;
long w;
{
  t_long_integer i;

#ifndef CoCo_Cygwin
  for (i = 0; i < w; i++)
    putc(c[i], f);
#else /* CoCo_Cygwin */
  if (f == stdout)
    printf("%.*s", (int)w, c);  
  else
  fprintf(f, "%.*s", (int)w, c);
#endif /* CoCo_Cygwin */
}  /* write_pch_30_text */


Static Void write_pch_40_text(f, c, w)
FILE *f;
Char *c;
long w;
{
  t_long_integer i;

#ifndef CoCo_Cygwin
  for (i = 0; i < w; i++)
    putc(c[i], f);
#else /* CoCo_Cygwin */
  if (f == stdout)
    printf("%.*s", (int)w, c);  
  else
  fprintf(f, "%.*s", (int)w, c);
#endif /* CoCo_Cygwin */
}  /* write_pch_40_text */


Static Void write_pch_50_text(f, c, w)
FILE *f;
Char *c;
long w;
{
  t_long_integer i;

#ifndef CoCo_Cygwin
  for (i = 0; i < w; i++)
    putc(c[i], f);
#else /* CoCo_Cygwin */
  if (f == stdout)
    printf("%.*s", (int)w, c);  
  else
  fprintf(f, "%.*s", (int)w, c);
#endif /* CoCo_Cygwin */
}  /* write_pch_50_text */


Static Void write_pch_text(f, c, w)
FILE *f;
Char *c;
long w;
{
  t_long_integer i;

#ifndef CoCo_Cygwin
  for (i = 0; i < w; i++)
    putc(c[i], f);
#else /* CoCo_Cygwin */
  if (f == stdout)
    printf("%.*s", (int)w, c);  
  else
  fprintf(f, "%.*s", (int)w, c);
#endif /* CoCo_Cygwin */
}  /* write_pch_text */


Static Void write_char_w_text(f, c, w)
FILE *f;
Char c;
long *w;
{
#ifdef CoCo_Cygwin
  if (f == stdout)
    printf("%*c", (int)(*w), c);
  else
#endif /* CoCo_Cygwin */
  fprintf(f, "%*c", (int)(*w), c);
}  /* write_char_w_text */


Static Void write_line_text(f)
FILE *f;
{
#ifdef CoCo_Cygwin
#ifdef DEBUG_E
  /* E */ printf("write_line_text 1 \n");
#endif /* E */
  if (f == stdout)
    printf("\n");
  else
#endif /* CoCo_Cygwin */
  putc('\n', f);
#ifdef CoCo_Cygwin
#ifdef DEBUG_E
  /* E */ printf("write_line_text 9 \n");
#endif /* E */
#endif /* CoCo_Cygwin */
}  /* write_line_text */


Static Void write_level_text(f, i, w)
FILE *f;
t_level *i;
long *w;
{
#ifdef CoCo_Cygwin
  t_long_integer j;
  Char str[255];

  sprintf(str, "%*ld", (int)(*w), *i);
  for (j = 0; j < *w; j++)
    write_char_text(f, str[j]);
#else /* CoCo_Cygwin */
  fprintf(f, "%*d", (int)(*w), *i);
#endif /* CoCo_Cygwin */
}  /* write_level_text */


Static Void write_integer_text(f, i, w)
FILE *f;
long i, *w;
{
#ifdef CoCo_Cygwin
  t_long_integer j;
  Char str[255];

  /*
  printf("write_integer_text 1 \n");
  printf("\n");
  */

  sprintf(str, "%*ld", (int)(*w), i);
  for (j = 0; j < *w; j++)
    write_char_text(f, str[j]);
#else /* CoCo_Cygwin */
  fprintf(f, "%*ld", (int)(*w), i);
#endif /* CoCo_Cygwin */
}  /* write_integer_text */


Static Void write_cell_count_text(f, i, w)
FILE *f;
t_cell_count *i;
long *w;
{
#ifdef CoCo_Cygwin
  t_long_integer j;
  Char str[255];

  /*
  printf("write_cell_count_text 1 \n");
  printf("\n");
  fprintf(f, "%*ld", (int)(*w), *i);
  */

  sprintf(str, "%*ld", (int)(*w), *i);
  for (j = 0; j < *w; j++)
    write_char_text(f, str[j]);
#else /* CoCo_Cygwin */
  fprintf(f, "%*ld", (int)(*w), *i);
#endif /* CoCo_Cygwin */
}  /* write_cell_count_text */


Static Void write_short_real_text(f, x, v, w)
FILE *f;
float *x;
long v, w;
{
#ifdef CoCo_Cygwin
  t_long_integer j;
  Char str[255];

  /*
  printf("write_short_text 1 \n");
  printf("\n");
  */

  if (w == 0)
    sprintf(str, "% .*E", P_max((int)v - 7, 1), *x);
  else
    sprintf(str, "%*.*f", (int)v, (int)w, *x);
  for (j = 0; j < v; j++)
    write_char_text(f, str[j]);
#else /* CoCo_Cygwin */
  if (w == 0)
    fprintf(f, "% .*E", P_max((int)v - 7, 1), *x);
  else
    fprintf(f, "%*.*f", (int)v, (int)w, *x);
#endif /* CoCo_Cygwin */
}  /* write_short_real_text */


Static Void write_real_text(f, x, v, w)
FILE *f;
double *x;
long v, w;
{
#ifdef CoCo_Cygwin
  t_long_integer j;
  Char str[255];

  /*
  printf("write_real_text 1 \n");
  printf("\n");
  */

  if (w == 0)
    sprintf(str, "% .*E", P_max((int)v - 7, 1), *x);
  else
    sprintf(str, "%*.*f", (int)v, (int)w, *x);
  for (j = 0; j < v; j++)
    write_char_text(f, str[j]);
#else /* CoCo_Cygwin */
  if (w == 0)
    fprintf(f, "% .*E", P_max((int)v - 7, 1), *x);
  else
    fprintf(f, "%*.*f", (int)v, (int)w, *x);
#endif /* CoCo_Cygwin */
}  /* write_real_text */


Static Void write_time_text(f, c, u, now_clock, start_clock, v, w)
FILE *f;
Char *c;
long u;
double now_clock, start_clock;
long v, w;
{
  double TEMP;

  write_pch_10_text(f, c, u);
  TEMP = (now_clock - start_clock) / 1000;
  write_real_text(f, &TEMP, v, w);
  write_pch_10_text(f, "s.", 2L);
}  /* write_time_text */


Static Void write_invalid(f, width)
FILE *f;
long width;
{
  write_space_text(f, labs(width) - 1);
  write_char_text(f, '-');
}  /* write_invalid */


Static Void write_valid_real_text(f, invalid, x, v, w)
FILE *f;
boolean invalid;
double *x;
long v, w;
{
  if (invalid)
    write_invalid(f, v);
  else
    write_real_text(f, x, v, w);
}  /* write_real_text */


/* Local variables for write_level_file: */
struct LOC_write_level_file {
  t_level l;
} ;


/* Write / fwrite */

Static Void write_level_file(f, l_)
FILE *f;
t_level l_;
{
  struct LOC_write_level_file Local_Var;

  Local_Var.l = l_;
#ifndef NO_LEVEL_FILE
  /* LEVEL_FILE is used for DATASTRUCTURE 'list_file' and 'both' */
  fwrite(&Local_Var.l, sizeof(t_level), 1, f);
#endif /* NO_LEVEL_FILE */
}  /* write_level_file */


Static Void write_integer_file(f, i)
FILE *f;
long i;
{
#ifdef CoCo_Cygwin
  printf("write_integer_file 1 \n");
  printf("\n");
#endif /* CoCo_Cygwin */
#ifndef NO_INT_FILE
  /* INTEGER_FILE is used for FIND_LOG_L_FILE from FIND_LOG_L_LARGE */
  fwrite(&i, sizeof(long), 1, f);
#endif /* NO_INT_FILE */
}  /* write_integer_file */


Static Void write_integer_list(f, p)
FILE *f;
t_integer_list *p;
{
#ifndef NO_INT_FILE
  while (p != NULL) {
    fwrite(&p->x, sizeof(long), 1, f);
    p = p->pointer;
  }
#endif /* NO_INT_FILE */
}  /* write_integer_list */


Static Void write_real_file(f, x)
FILE *f;
double x;
{
#ifdef CoCo_Cygwin
  printf("write_real_file 1 \n");
  printf("\n");
#endif /* CoCo_Cygwin */
#ifndef NO_REAL_FILE
  /* REAL_FILE is used for DESCRIBE */
  fwrite(&x, sizeof(double), 1, f);
#endif /* NO_REAL_FILE */
}  /* write_real_file */


/* Read / fread */

Static Void read_level_file(f, l)
FILE *f;
t_level *l;
{
#ifndef NO_LEVEL_FILE
  if (fread(l, sizeof(t_level), 1, f) != 1)
    _EscIO(EndOfFile);
#endif /*  NO_LEVEL_FILE */
}  /* read_level_file */


Static boolean eof_level_file(f)
FILE *f;
{
  return P_eof(f);
}  /* eof_level_file */


Static Void read_integer_file(f, i)
FILE *f;
long *i;
{
#ifndef NO_INT_FILE
  if (fread(i, sizeof(long), 1, f) != 1)
    _EscIO(EndOfFile);
#endif /* NO_INT_FILE */
}  /* read_integer_file */


Static boolean eof_integer_file(f)
FILE *f;
{
  return P_eof(f);
}  /* eof_integer_file */


Static Void read_integer_list(f, p)
FILE *f;
t_integer_list *p;
{
#ifndef NO_INT_FILE
  while (p != NULL) {
    if (fread(&p->x, sizeof(long), 1, f) != 1)
      _EscIO(EndOfFile);
    p = p->pointer;
  }
#endif /* NO_INT_FILE */
}  /* read_integer_list */


Static Void read_real_file(f, x)
FILE *f;
double *x;
{
#ifndef NO_REAL_FILE
  if (fread(x, sizeof(double), 1, f) != 1)
    _EscIO(EndOfFile);
#endif /* NO_REAL_FILE */
}  /* read_real_file */


Static boolean eof_real_file(f)
FILE *f;
{
  return P_eof(f);
}  /* eof_real_file */


/* Rewrite */

Static Void rewrite_(f)
FILE *f;
{
  if (f != NULL)
#ifndef CoCo_Cygwin
    rewind(f);
#else /* CoCo_Cygwin */
    fseek(f, 0L, SEEK_SET);
#endif /* CoCo_Cygwin */
  else
    f = tmpfile();
  if (f == NULL)
    _EscIO(FileNotFound);
}


Static Void rewrite_file(f)
FILE *f;
{
  rewrite_(f);
}


Static Void rewrite_cell_file(f)
FILE *f;
{
  if (f != NULL)
#ifndef CoCo_Cygwin
    rewind(f);
#else /* CoCo_Cygwin */
    rewrite_(f);
#endif /* CoCo_Cygwin */
  else
    f = tmpfile();
  if (f == NULL)
    _EscIO(FileNotFound);
}


Static Void rewrite_level_file(f)
FILE *f;
{
  if (f != NULL)
#ifndef CoCo_Cygwin
    rewind(f);
#else /* CoCo_Cygwin */
    rewrite_(f);
#endif /* CoCo_Cygwin */
  else
    f = tmpfile();
  if (f == NULL)
    _EscIO(FileNotFound);
}


Static Void rewrite_integer_file(f)
FILE *f;
{
  if (f != NULL)
#ifndef CoCo_Cygwin
    rewind(f);
#else /* CoCo_Cygwin */
    rewrite_(f);
#endif /* CoCo_Cygwin */
  else
    f = tmpfile();
  if (f == NULL)
    _EscIO(FileNotFound);
}


Static Void rewrite_real_file(f)
FILE *f;
{
  if (f != NULL)
#ifndef CoCo_Cygwin
    rewind(f);
#else /* CoCo_Cygwin */
    rewrite_(f);
#endif /* CoCo_Cygwin */
  else
    f = tmpfile();
  if (f == NULL)
    _EscIO(FileNotFound);
}


Static Void rewrite_text_file(f)
FILE *f;
{
  if (f != NULL)
#ifndef CoCo_Cygwin
    rewind(f);
#else /* CoCo_Cygwin */
    rewrite_(f);
#endif /* CoCo_Cygwin */
  else
    f = tmpfile();
  if (f == NULL)
    _EscIO(FileNotFound);
}


/*@+"assigndos.p"*/
/*@-"assigndos.p"*/

/*$ifdef On-DOS

procedure dos_assign;

function clock: t_long_integer;
var
   year, month, day, dayofweek, hour, minute, second, sec100: word;
begin
   getdate(year, month, day, dayofweek);
   gettime(hour, minute, second, sec100);
   clock := round((sec100 / 100 + second +
                  60 * (minute + 60 * (hour + 7 * dayofweek))) * 1000)
end;

function random_init: t_long_integer;
begin
   random_init := clock
end;

procedure monitor_note_exact(txt: pch20;
                             w, a, b, c: t_long_integer);
begin
   null
end;

function getprognamestr: string;
type
   txt_block = array [1..$7fff] of char;
var
   txt: ^ txt_block;
   enviseg: ^ integer;
   par: string;
   pp: integer;
begin
   enviseg := ptr(PrefixSeg, $002C);
   txt := ptr(enviseg^, 0);
   pp := 1;
   repeat
      while txt^[pp] <> min_char do
         pp := pp + 1;
      pp := pp + 1
   until txt^[pp] = min_char;
   pp := pp + 1;
   pp := pp + 2;
   par := '';
   while txt^[pp] <> min_char do begin
      par := par + txt^[pp];
      pp := pp + 1
   end;
   getprognamestr := par
end;

procedure get_cocolib(var name: pch_long;
                      var ok: boolean);
var
   pathcoco, dircoco, namecoco, extcoco: string;
   i, j: integer;
begin
   pathcoco := getprognamestr;
   FSplit(pathcoco, dircoco, namecoco, extcoco);
   for i := 1 to length(dircoco) do
      name[i] := dircoco[i];
   for i := length(dircoco) + 1 to file_name_length do
      name[i] := ' '
end;

procedure assign_read(var f: text;
                          name: pch_long;
                      var ok: boolean);
var
   dd: string;
   pp: integer;
begin
   dd := '';
   pp := 1;
   while name[pp] <> ' ' do begin
      dd := dd + name[pp];
      inc(pp)
   end;

   assign(f, dd);
   reset(f);

   ok := ioresult = 0
end;

procedure assign_read_cocolib(var f: text;
                              var name: pch_long;
                              var ok: boolean);
var
   pathcoco, dircoco, namecoco, extcoco, pathxxxx, dirxxxx, namexxxx,
   extxxxx, newname: string;
   i, j: integer;
begin
   pathcoco := getprognamestr;
   pathxxxx := name;
   FSplit(pathcoco, dircoco, namecoco, extcoco);
   FSplit(pathxxxx, dirxxxx, namexxxx, extxxxx);
   newname := dircoco + namecoco + extxxxx;
   for i := 1 to file_name_length do
      name[i] := ' ';
   for i := 1 to length(newname) do
      name[i] := newname[i];

   if boolean_option[31] then begin
      writeln('AssignCocolib:   ', name);
      writeln('PathCoCo         ', pathcoco);
      writeln('DirCoCo          ', dircoco);
      writeln('NameCoCo         ', namecoco);
      writeln('ExtCoCo          ', extcoco);
      writeln('Pathxxxx         ', pathxxxx);
      writeln('Dirxxxx          ', dirxxxx);
      writeln('Namexxxx         ', namexxxx);
      writeln('Extxxxx          ', extxxxx);
      writeln('AssignCocolib:   ', newname);
      writeln('AssignCocolib:   ', length(newname));
      writeln('AssignCocolib:   ', name)
   end;

   assign_read(f, name, ok)
end;

procedure assign_write(var f: text;
                           name: pch_long;
                       var ok: boolean);
var
   dd: string;
   pp: integer;
begin
   dd := '';
   pp := 1;
   while name[pp] <> ' ' do begin
      dd := dd + name[pp];
      inc(pp)
   end;
   assign(f, dd);
   ok := true;
   rewrite(f)
end;

procedure flush_file(var f: text);
begin
   flush(f)
end;

procedure close_file(var f: text);
begin
   close(f)
end;

procedure close_level_file(var f: t_level_file);
begin
   close(f)
end;

procedure mktemp(var cmd: pch_long);
begin
   null
end;

procedure unlink(cmd: pch_long);
begin
   null
end;

procedure get_tmp_name(var dummy_ok: boolean;
                       var name: pch_long;
                       var tmp_count: t_long_integer);
var
   i: integer;
begin
   tmp_count := tmp_count + 1;
   i := 1;
   while (name[i] <> chr(0)) and (name[i] <> ' ') and (name[i] <> 'Y')
      and (i < 38) do
      i := i + 1;
   name[i] := chr(ord('0') + abs(tmp_count) div 100);
   name[i + 1] := chr(ord('0') + abs(tmp_count) mod 100 div 10);
   name[i + 2] := chr(ord('0') + abs(tmp_count) mod 10);
   while (name[i] <> chr(0)) and (name[i] <> ' ') and (i < 39) do
      i := i + 1;
   name[i] := chr(0);
   mktemp(name)
end;

procedure assign_tmp_write(var f: text;
                           var name: pch_long;
                           var tmp_count: t_long_integer);
var
   dd: string;
   pp: integer;
   ok: boolean;
begin
   get_tmp_name(ok, name, tmp_count);
   dd := '';
   pp := 1;
   while name[pp] <> ' ' do begin
      dd := dd + name[pp];
      inc(pp)
   end;
   assign(f, dd);
   rewrite(f)
end;

procedure unlink_tmp_file(var f: text;
                          var name: pch_long;
                              file_set: boolean);
begin
   if not file_set then
      unlink(name)
end;

procedure assign_tmp_cell_write(var f: t_cell_file;
                                var name: pch_long;
                                var tmp_count: t_long_integer);
var
   dd: string;
   pp: integer;
   ok: boolean;
begin
   get_tmp_name(ok, name, tmp_count);
   dd := '';
   pp := 1;
   while name[pp] <> ' ' do begin
      dd := dd + name[pp];
      inc(pp)
   end;
   assign(f, dd);
   rewrite(f)
end;

procedure unlink_cell_file(var f: t_cell_file;
                           var name: pch_long);
begin
   unlink(name)
end;

procedure reassign_tmp_cell_write(var f: t_cell_file;
                                      name: pch_long);
begin
   rewrite(f)
end;

procedure assign_tmp_level_write(var f: t_level_file;
                                 var name: pch_long;
                                 var tmp_count: t_long_integer);
var
   dd: string;
   pp: integer;
   ok: boolean;
begin
   get_tmp_name(ok, name, tmp_count);
   dd := '';
   pp := 1;
   while name[pp] <> ' ' do begin
      dd := dd + name[pp];
      inc(pp)
   end;
   assign(f, dd);
   rewrite(f);
   unlink(name)
end;

procedure reassign_tmp_level_file_write(var f: t_level_file;
                                            name: pch_long);
begin
   rewrite(f)
end;

procedure assign_integer_file_write(var f: t_integer_file;
                                    var name: pch_long;
                                    var tmp_count: t_long_integer);
var
   dd: string;
   pp: integer;
   ok: boolean;
begin
   get_tmp_name(ok, name, tmp_count);
   dd := '';
   pp := 1;
   while name[pp] <> ' ' do begin
      dd := dd + name[pp];
      inc(pp)
   end;
   assign(f, dd);
   rewrite(f)
end;

procedure unlink_integer_file(var f: t_integer_file;
                              var name: pch_long);
begin
   unlink(name)
end;

procedure reassign_integer_file_write(var f: t_integer_file;
                                          name: pch_long);
begin
   rewrite(f)
end;

procedure assign_real_file_write(var f: t_real_file;
                                 var name: pch_long;
                                 var tmp_count: t_long_integer);
var
   dd: string;
   pp: integer;
   ok: boolean;
begin
   get_tmp_name(ok, name, tmp_count);
   dd := '';
   pp := 1;
   while name[pp] <> ' ' do begin
      dd := dd + name[pp];
      inc(pp)
   end;
   assign(f, dd);
   rewrite(f)
end;

procedure assign_tmp_real_write(var f: t_real_file;
                                var name: pch_long;
                                var tmp_count: t_long_integer);
var
   dd: string;
   pp: integer;
   ok: boolean;
begin
   get_tmp_name(ok, name, tmp_count);
   dd := '';
   pp := 1;
   while name[pp] <> ' ' do begin
      dd := dd + name[pp];
      inc(pp)
   end;
   assign(f, dd);
   rewrite(f);
   unlink(name)
end;

procedure unlink_real_file(var f: t_real_file;
                           var name: pch_long);
begin
   close(f);
   unlink(name)
end;

procedure reassign_real_file_write(var f: t_real_file;
                                       name: pch_long);
begin
   rewrite(f)
end;

procedure inter_02;
begin
   interrupt_x := true;
   interrupt_1 := true;
   if clock - last_interrupt_time_1 < delta_interrupt then
      interrupt_2 := true;
   interrupt_count := interrupt_count + 1;
   writeln('Interrupt (02):  ', interrupt_count: 2, clock -
           last_interrupt_time_1: 10);
   writeln(log_file, '# Interrupt (02):  ', interrupt_count: 2, clock -
           last_interrupt_time_1: 10);
   last_interrupt_time_1 := clock
end;

procedure inter_15;
begin
   interrupt_x := true;
   interrupt_1 := true;
   if clock - last_interrupt_time_1 < delta_interrupt then
      interrupt_2 := true;
   interrupt_count := interrupt_count + 1;
   writeln('Interrupt (15):  ', interrupt_count: 2, clock -
           last_interrupt_time_1: 10);
   writeln(log_file, '# Interrupt (15):  ', interrupt_count: 2, clock -
           last_interrupt_time_1: 10);
   last_interrupt_time_1 := clock
end;

procedure inter_22;
begin
   interrupt_x := true;
   interrupt_1 := true;
   if clock - last_interrupt_time_1 < delta_interrupt then
      interrupt_2 := true;
   interrupt_count := interrupt_count + 1;
   writeln('Interrupt (22):  ', interrupt_count: 2, clock -
           last_interrupt_time_1: 10);
   writeln(log_file, '# Interrupt (22):  ', interrupt_count: 2, clock -
           last_interrupt_time_1: 10);
   last_interrupt_time_1 := clock
end;

procedure inter_0;
begin
   interrupt_x := true;
   interrupt_1 := true;
   if clock - last_interrupt_time_1 < delta_interrupt then
      interrupt_2 := true;
   interrupt_count := interrupt_count + 1;
   writeln('Interrupt (0):  ', interrupt_count: 2, clock -
           last_interrupt_time_1: 10);
   writeln(log_file, '# Interrupt (0):  ', interrupt_count: 2, clock -
           last_interrupt_time_1: 10);
   last_interrupt_time_1 := clock
end;

function inter_1(i: integer): integer;
begin
   interrupt_x := true;
   interrupt_1 := true;
   if clock - last_interrupt_time_1 < delta_interrupt then
      interrupt_2 := true;
   interrupt_count := interrupt_count + 1;
   writeln('Interrupt (1):  ', interrupt_count: 2, i: 2, clock -
           last_interrupt_time_1: 10);
   writeln(log_file, '# Interrupt (1):  ', interrupt_count: 2, i: 2,
           clock - last_interrupt_time_1: 10);
   last_interrupt_time_1 := clock;
   inter_1 := 0
end;

function inter_2(i: integer): integer;
begin
   interrupt_x := true;
   interrupt_1 := true;
   interrupt_2 := true;
   if clock - last_interrupt_time_2 < delta_interrupt then
      interrupt_3 := true;
   interrupt_count := interrupt_count + 1;
   writeln('Interrupt (2):  ', interrupt_count: 2, i: 2, clock -
           last_interrupt_time_2: 10);
   writeln(log_file, '# Interrupt (2):  ', interrupt_count: 2, i: 2,
           clock - last_interrupt_time_2: 10);
   last_interrupt_time_2 := clock;
   inter_2 := 0
end;

procedure set_interrupt;
begin
   interrupt_count := 0;
   interrupt_x := false;
   interrupt_1 := false;
   interrupt_2 := false;
   interrupt_3 := false;
   last_interrupt_time_1 := clock;
   last_interrupt_time_2 := clock;
   SetIntVec($02, @inter_02)
end;

procedure set_interrupt_on_off(code: integer);
begin
   null
end;

procedure rewrite_file(var f: text);
begin
   rewrite(f)
end;

procedure rewrite_cell_file(var f: t_cell_file);
begin
   rewrite(f)
end;

procedure rewrite_level_file(var f: t_level_file);
begin
   rewrite(f)
end;

procedure rewrite_integer_file(var f: t_integer_file);
begin
   rewrite(f)
end;

procedure rewrite_real_file(var f: t_real_file);
begin
   rewrite(f)
end;

procedure dummy_dummy(var dummy_f: text);
begin
   null
end;

function resize_n(var n: t_n;
                      size: t_long_integer;
                  var max_cell_number: t_long_integer): boolean;
begin
   resize_n := size <= max_cell_number
end;

function resize_p(var p: t_p;
                      size: t_long_integer;
                  var max_cell_number: t_long_integer): boolean;
begin
   resize_p := size <= max_cell_number
end;

function resize_q(var q: t_q;
                      size: t_long_integer;
                  var max_cell_number: t_long_integer): boolean;
begin
   resize_q := size <= max_cell_number
end;

begin
   null
end;

 $endif On-DOS*/

/*@+"assign.p"*/
/*@-"assignunix.c"*/





   #include "assign.c"
 

/* #  ifdef CC-minus     



Static long random_init()
{
  return my_clock()/1;
}


Static Void monitor_note_exact(txt, w, a, b, c)
Char *txt;
long w, a, b, c;
{
}


extern Void getenv_cocolib PP((Const long lb, Const long ub, Char *dir));

extern Void getenv_tmp PP((Const long lb, Const long ub, Char *dir));

extern Void ok_to_reset_file PP((Const long lb, Const long ub, Char *name,
				 boolean *ok));


Static Void my_strchr(s, c, i, length)
Char *s;
Char c;
long *i, length;
{
  while (s[*i - PCH_START] != '\0' && s[*i - PCH_START] != c && *i < length)
    (*i)++;
  printf("My_strchr: ");
  printf("%.*s", (int)(PCH_END - PCH_START + 1), s);
  putchar('|');
  putchar(c);
  putchar('|');
  printf("%4ld", *i);
  printf("%4ld\n", length);
}


Static Void my_strdhr(s, c1, c2, i, length)
Char *s;
Char c1, c2;
long *i, length;
{
  while (s[*i - PCH_START] != '\0' && s[*i - PCH_START] != c1 &&
	 s[*i - PCH_START] != c2 && *i < length)
    (*i)++;
  printf("My_strdhr: ");
  printf("%.*s", (int)(PCH_END - PCH_START + 1), s);
  putchar('|');
  putchar(c1);
  putchar('|');
  putchar(c2);
  putchar('|');
  printf("%4ld", *i);
  printf("%4ld\n", length);
}


Static Void my_strcat(dst, src, c, i, j, length)
Char *dst, *src;
Char c;
long *i, *j, length;
{
  while (src[*j - PCH_START] != '\0' && src[*j - PCH_START] != c &&
	 *i + *j <= length) {
    dst[*i - PCH_START + *j - PCH_START] = src[*j - PCH_START];
    (*j)++;
  }
  dst[*i - PCH_START + *j - PCH_START] = '\0';
  printf("My_strcat: ");
  printf("%.*s", (int)(PCH_END - PCH_START + 1), dst);
  putchar('|');
  printf("%.*s", (int)(PCH_END - PCH_START + 1), src);
  putchar('|');
  printf("%4ld", *i);
  printf("%4ld", *j);
  printf("%4ld\n", length);
}


Static Void my_strncp(dst, src, c, i, j, n, length)
Char *dst, *src;
Char c;
long *i, *j, *n, length;
{
  long j_start;

  j_start = *j;
  while (src[*j - PCH_START] != '\0' && src[*j - PCH_START] != c &&
	 *j - j_start < *n && *j < length) {
    dst[*i - PCH_START] = src[*j - PCH_START];
    (*j)++;
    (*i)++;
  }
  dst[*j - PCH_START] = '\0';
  printf("My_strncp: ");
  printf("%.*s", (int)(PCH_END - PCH_START + 1), dst);
  putchar('|');
  printf("%.*s", (int)(PCH_END - PCH_START + 1), src);
  putchar('|');
  putchar(c);
  putchar('|');
  printf("%4ld", *i);
  printf("%4ld", *n);
  printf("%4ld\n", length);
}


Static Void my_strcct(dst, c, i, length)
Char *dst;
Char c;
long *i, length;
{
  dst[*i - PCH_START] = c;
  (*i)++;
  dst[*i - PCH_START] = '\0';
  printf("My_strcct: ");
  printf("%.*s", (int)(PCH_END - PCH_START + 1), dst);
  putchar('|');
  putchar(c);
  putchar('|');
  printf("%4ld", *i);
  printf("%4ld\n", length);
}


Static Void my_strclr(dst, c, i, length)
Char *dst;
Char c;
long i, length;
{
  while (i <= length) {
    dst[i - PCH_START] = c;
    i++;
  }
  if (false)
    dst[i - PCH_START - 1] = '\0';
  printf("My_strcct: ");
  printf("%.*s", (int)(PCH_END - PCH_START + 1), dst);
  putchar('|');
  putchar(c);
  putchar('|');
  printf("%4ld", i);
  printf("%4ld\n", length);
}


Static Void get_cocolib(name, ok)
Char *name;
boolean *ok;
{
  pch_long dir;
  long i;

  if (link_coco_lib != NULL)
    memcpy(dir, link_coco_lib, sizeof(pch_long));
  else {
    getenv_cocolib((long)PCH_START, (long)PCH_END, dir);
    link_coco_lib = (Char *)Malloc(sizeof(pch_long));
    if (link_coco_lib == NULL)
      _OutMem();
    memcpy(link_coco_lib, dir, sizeof(pch_long));
  }
  *ok = true;
  i = 1;
  my_strchr(dir, ' ', &i, (long)FILE_NAME_LENGTH);
  if (dir[i - PCH_START - 1] != '\\' && dir[i - PCH_START - 1] != '/' &&
      i < FILE_NAME_LENGTH)
    my_strcct(dir, '/', &i, (long)FILE_NAME_LENGTH);
  my_strclr(dir, ' ', i, (long)FILE_NAME_LENGTH);
  memcpy(name, dir, sizeof(pch_long));
}


Static Void get_cocotmp(name, ok)
Char *name;
boolean *ok;
{
  pch_long dir;
  long i;

  if (link_coco_tmp != NULL)
    memcpy(name, link_coco_tmp, sizeof(pch_long));
  else {
    getenv_tmp((long)PCH_START, (long)PCH_END, dir);
    link_coco_tmp = (Char *)Malloc(sizeof(pch_long));
    if (link_coco_tmp == NULL)
      _OutMem();
    memcpy(link_coco_tmp, dir, sizeof(pch_long));
  }
  *ok = true;
  i = 1;
  my_strchr(dir, ' ', &i, (long)FILE_NAME_LENGTH);
  if (dir[i - PCH_START - 1] != '\\' && dir[i - PCH_START - 1] != '/' &&
      i < FILE_NAME_LENGTH)
    my_strcct(dir, '/', &i, (long)FILE_NAME_LENGTH);
  my_strclr(dir, ' ', i, (long)FILE_NAME_LENGTH);
  memcpy(name, dir, sizeof(pch_long));
}


Static Void assign_read(f, name_, ok)
FILE **f;
Char *name_;
boolean *ok;
{
  pch_long name;
  Char STR1[256];

  memcpy(name, name_, sizeof(pch_long));
  *ok = true;
  ok_to_reset_file((long)PCH_START, (long)PCH_END, name, ok);
  if (!*ok)
    return;
  if (*f != NULL) {
    sprintf(STR1, "%.*s", PCH_END - PCH_START + 1, name);
    *f = freopen(STR1, "r", *f);
  } else {
    sprintf(STR1, "%.*s", PCH_END - PCH_START + 1, name);
    *f = fopen(STR1, "r");
  }
  if (*f == NULL)
    _EscIO(FileNotFound);
}


Static Void assign_read_cocolib(f, name, ok)
FILE **f;
Char *name;
boolean *ok;
{
  pch_long dir;
  long i, j;

  get_cocolib(dir, ok);
  if (!*ok)
    return;
  i = 1;
  my_strchr(dir, ' ', &i, (long)FILE_NAME_LENGTH);
  if (dir[i - PCH_START - 1] != '\\' && dir[i - PCH_START - 1] != '/' &&
      i < FILE_NAME_LENGTH)
    my_strcct(dir, '/', &i, (long)FILE_NAME_LENGTH);
  j = 1;
  my_strcat(dir, name, ' ', &i, &j, (long)FILE_NAME_LENGTH);
  my_strclr(dir, ' ', i + j, (long)FILE_NAME_LENGTH);
  memcpy(name, dir, sizeof(pch_long));
  assign_read(f, name, ok);
}


Static Void assign_write(f, name, ok)
FILE **f;
Char *name;
boolean *ok;
{
  Char STR1[256];

  *ok = true;
  if (*f != NULL) {
    sprintf(STR1, "%.*s", PCH_END - PCH_START + 1, name);
    *f = freopen(STR1, "w", *f);
  } else {
    sprintf(STR1, "%.*s", PCH_END - PCH_START + 1, name);
    *f = fopen(STR1, "w");
  }
  if (*f == NULL)
    _EscIO(FileNotFound);
}


Static Void flush_file(f)
FILE **f;
{
  fflush(*f);
  P_ioresult = 0;
}




Static Void close_file(dummy_f)
FILE *dummy_f;
{
}


Static Void close_level_file(dummy_f)
FILE *dummy_f;
{
}




extern Void mktemp PP((Const long lb, Const long ub, Char *cmd));

extern Void unlink PP((Const long lb, Const long ub, Char *cmd));


Static Void get_tmp_name(ok, name, tmp_count)
boolean *ok;
Char *name;
long *tmp_count;
{
  pch_long dir;
  long i, j;
  Char c;

  get_cocotmp(dir, ok);
  if (!*ok)
    return;
  i = 1;
  my_strchr(dir, ' ', &i, (long)FILE_NAME_LENGTH);
  if (dir[i - PCH_START - 1] != '\\' && dir[i - PCH_START - 1] != '/' &&
      i < FILE_NAME_LENGTH)
    my_strcct(dir, '/', &i, (long)FILE_NAME_LENGTH);
  j = 1;
  my_strcat(dir, name, ' ', &i, &j, (long)FILE_NAME_LENGTH);
  my_strclr(dir, ' ', i + j, (long)FILE_NAME_LENGTH);
  memcpy(name, dir, sizeof(pch_long));
  (*tmp_count)++;
  i = 1;
  my_strdhr(name, ' ', 'Y', &i, (long)FILE_NAME_LENGTH);
  c = (Char)(labs(*tmp_count) / 100 + '0');
  my_strcct(name, c, &i, (long)FILE_NAME_LENGTH);
  c = (Char)(labs(*tmp_count) % 100 / 10 + '0');
  my_strcct(name, c, &i, (long)FILE_NAME_LENGTH);
  c = (Char)(labs(*tmp_count) % 10 + '0');
  my_strcct(name, c, &i, (long)FILE_NAME_LENGTH);
  my_strchr(name, ' ', &i, (long)FILE_NAME_LENGTH);
  my_strcct(name, '\0', &i, (long)FILE_NAME_LENGTH);
  mktemp((long)PCH_START, (long)PCH_END, name);
}


Static Void assign_tmp_write(f, name, tmp_count, ok)
FILE **f;
Char *name;
long *tmp_count;
boolean *ok;
{
  Char STR1[256];

  get_tmp_name(ok, name, tmp_count);
  if (!*ok)
    return;
  if (*f != NULL) {
    sprintf(STR1, "%.*s", PCH_END - PCH_START + 1, name);
    *f = freopen(STR1, "w", *f);
  } else {
    sprintf(STR1, "%.*s", PCH_END - PCH_START + 1, name);
    *f = fopen(STR1, "w");
  }
  if (*f == NULL)
    _EscIO(FileNotFound);
}


Static Void unlink_tmp_file(f, name, file_set)
FILE **f;
Char *name;
boolean file_set;
{
  flush_file(f);
  if (!file_set)
    unlink((long)PCH_START, (long)PCH_END, name);
}


Static Void assign_tmp_cell_write(f, name, tmp_count)
FILE **f;
Char *name;
long *tmp_count;
{
  boolean ok;
  Char STR1[256];

  get_tmp_name(&ok, name, tmp_count);
  if (*f != NULL) {
    sprintf(STR1, "%.*s", PCH_END - PCH_START + 1, name);
    *f = freopen(STR1, "wb", *f);
  } else {
    sprintf(STR1, "%.*s", PCH_END - PCH_START + 1, name);
    *f = fopen(STR1, "wb");
  }
  if (*f == NULL)
    _EscIO(FileNotFound);
}


Static Void unlink_cell_file(f, name)
FILE **f;
Char *name;
{
  fflush(*f);
  P_ioresult = 0;
  unlink((long)PCH_START, (long)PCH_END, name);
}


Static Void reassign_tmp_cell_write(f, name)
FILE **f;
Char *name;
{
  Char STR1[256];

  if (*f != NULL) {
    sprintf(STR1, "%.*s", PCH_END - PCH_START + 1, name);
    *f = freopen(STR1, "wb", *f);
  } else {
    sprintf(STR1, "%.*s", PCH_END - PCH_START + 1, name);
    *f = fopen(STR1, "wb");
  }
  if (*f == NULL)
    _EscIO(FileNotFound);
}


Static Void assign_tmp_level_write(f, name, tmp_count)
FILE **f;
Char *name;
long *tmp_count;
{
  boolean ok;
  Char STR1[256];

  get_tmp_name(&ok, name, tmp_count);
  if (*f != NULL) {
    sprintf(STR1, "%.*s", PCH_END - PCH_START + 1, name);
    *f = freopen(STR1, "wb", *f);
  } else {
    sprintf(STR1, "%.*s", PCH_END - PCH_START + 1, name);
    *f = fopen(STR1, "wb");
  }
  if (*f == NULL)
    _EscIO(FileNotFound);
  unlink((long)PCH_START, (long)PCH_END, name);
}


Static Void reassign_tmp_level_file_write(f, name)
FILE **f;
Char *name;
{
  Char STR1[256];

  if (*f != NULL) {
    sprintf(STR1, "%.*s", PCH_END - PCH_START + 1, name);
    *f = freopen(STR1, "wb", *f);
  } else {
    sprintf(STR1, "%.*s", PCH_END - PCH_START + 1, name);
    *f = fopen(STR1, "wb");
  }
  if (*f == NULL)
    _EscIO(FileNotFound);
}


Static Void assign_integer_file_write(f, name, tmp_count)
FILE **f;
Char *name;
long *tmp_count;
{
  boolean ok;
  Char STR1[256];

  get_tmp_name(&ok, name, tmp_count);
  if (*f != NULL) {
    sprintf(STR1, "%.*s", PCH_END - PCH_START + 1, name);
    *f = freopen(STR1, "wb", *f);
  } else {
    sprintf(STR1, "%.*s", PCH_END - PCH_START + 1, name);
    *f = fopen(STR1, "wb");
  }
  if (*f == NULL)
    _EscIO(FileNotFound);
}


Static Void unlink_integer_file(f, name)
FILE **f;
Char *name;
{
  fflush(*f);
  P_ioresult = 0;
  unlink((long)PCH_START, (long)PCH_END, name);
}


Static Void reassign_integer_file_write(f, name)
FILE **f;
Char *name;
{
  Char STR1[256];

  if (*f != NULL) {
    sprintf(STR1, "%.*s", PCH_END - PCH_START + 1, name);
    *f = freopen(STR1, "wb", *f);
  } else {
    sprintf(STR1, "%.*s", PCH_END - PCH_START + 1, name);
    *f = fopen(STR1, "wb");
  }
  if (*f == NULL)
    _EscIO(FileNotFound);
}


Static Void assign_real_file_write(f, name, tmp_count)
FILE **f;
Char *name;
long *tmp_count;
{
  boolean ok;
  Char STR1[256];

  get_tmp_name(&ok, name, tmp_count);
  if (*f != NULL) {
    sprintf(STR1, "%.*s", PCH_END - PCH_START + 1, name);
    *f = freopen(STR1, "wb", *f);
  } else {
    sprintf(STR1, "%.*s", PCH_END - PCH_START + 1, name);
    *f = fopen(STR1, "wb");
  }
  if (*f == NULL)
    _EscIO(FileNotFound);
}


Static Void assign_tmp_real_write(f, name, tmp_count)
FILE **f;
Char *name;
long *tmp_count;
{
  boolean ok;
  Char STR1[256];

  get_tmp_name(&ok, name, tmp_count);
  if (*f != NULL) {
    sprintf(STR1, "%.*s", PCH_END - PCH_START + 1, name);
    *f = freopen(STR1, "wb", *f);
  } else {
    sprintf(STR1, "%.*s", PCH_END - PCH_START + 1, name);
    *f = fopen(STR1, "wb");
  }
  if (*f == NULL)
    _EscIO(FileNotFound);
  unlink((long)PCH_START, (long)PCH_END, name);
}


Static Void unlink_real_file(f, name)
FILE **f;
Char *name;
{
  fflush(*f);
  P_ioresult = 0;
  unlink((long)PCH_START, (long)PCH_END, name);
}


Static Void reassign_real_file_write(f, name)
FILE **f;
Char *name;
{
  Char STR1[256];

  if (*f != NULL) {
    sprintf(STR1, "%.*s", PCH_END - PCH_START + 1, name);
    *f = freopen(STR1, "wb", *f);
  } else {
    sprintf(STR1, "%.*s", PCH_END - PCH_START + 1, name);
    *f = fopen(STR1, "wb");
  }
  if (*f == NULL)
    _EscIO(FileNotFound);
}




Static long inter_1(i)
long i;
{
  interrupt_x = true;
  interrupt_1 = true;
  if (my_clock()/1 - last_interrupt_time_1 < DELTA_INTERRUPT)
    interrupt_2 = true;
  interrupt_count++;
  printf("Interrupt (1):  %2ld%2ld%10ld\n",
	 interrupt_count, i, my_clock()/1 - last_interrupt_time_1);
  fprintf(log_file, "# Interrupt (1):  %2ld%2ld%10ld\n",
	  interrupt_count, i, my_clock()/1 - last_interrupt_time_1);
  last_interrupt_time_1 = my_clock()/1;
  return 0;
}


Static long inter_2(i)
long i;
{
  interrupt_x = true;
  interrupt_1 = true;
  interrupt_2 = true;
  if (my_clock()/1 - last_interrupt_time_2 < DELTA_INTERRUPT)
    interrupt_3 = true;
  interrupt_count++;
  printf("Interrupt (2):  %2ld%2ld%10ld\n",
	 interrupt_count, i, my_clock()/1 - last_interrupt_time_2);
  fprintf(log_file, "# Interrupt (2):  %2ld%2ld%10ld\n",
	  interrupt_count, i, my_clock()/1 - last_interrupt_time_2);
  last_interrupt_time_2 = my_clock()/1;
  return 0;
}



extern Void signal PP((long sig, _PROCEDURE inter));


Static Void set_interrupt()
{
  _PROCEDURE TEMP;

  interrupt_count = 0;
  interrupt_x = false;
  interrupt_1 = false;
  interrupt_2 = false;
  interrupt_3 = false;
  last_interrupt_time_1 = my_clock()/1;
  last_interrupt_time_2 = my_clock()/1;
  TEMP.proc = (Anyptr)inter_1;
  TEMP.link = (Anyptr)NULL;
  signal(2L, TEMP);
  TEMP.proc = (Anyptr)inter_2;
  TEMP.link = (Anyptr)NULL;
  signal(3L, TEMP);
}


#define sigint          2
#define sigquit         3


Static Void set_interrupt_on_off(code)
long code;
{
}

#undef sigint
#undef sigquit



     #  endif CC-minus */

/* #  ifdef Multiple-Objects-plus


procedure coco;

 var

  #  endif Multiple-Objects-plus */





/*@-"assigntail.c"*/


Static Void dummy_dummy(dummy_f)
FILE **dummy_f;
{
}




Static boolean RESIZE_N(n, size, max_cell_number)
t_cell_count *n;
long size, *max_cell_number;
{

  /*$ifdef On-DOS
function resize_n(var n: t_n;
                        size: integer;
                    var max_cell_number: t_long_integer): boolean;
   $endif On-DOS*/
  return (size <= *max_cell_number);
}


Static boolean RESIZE_P(p, size, max_cell_number)
float *p;
long size, *max_cell_number;
{

  /*$ifdef On-DOS
function resize_p(var p: t_p;
                        size: integer;
                    var max_cell_number: t_long_integer): boolean;
   $endif On-DOS*/
  return (size <= *max_cell_number);
}


Static boolean RESIZE_Q(q, size, max_cell_number)
long *q;
long size, *max_cell_number;
{

  /*$ifdef On-DOS
function resize_q(var q: t_q;
                        size: integer;
                    var max_cell_number: t_long_integer): boolean;
   $endif On-DOS*/
  return (size <= *max_cell_number);
}


/*@-"write.c"*/
/*@+"write.p"*/

Static Void pause(f, page)
FILE *f;
boolean page;
{
  if (!pause_output)
    return;
  if (!(eoln_stdin() && line_count > 0 &&
	(page && line_count % page_pause_length > 5 ||
	 !page && line_count % page_pause_length == 0)))
    return;
  flush_file(&f);
  write_line_text(f);
  write_pch_30_text(f, "Press ``Return'' to continue", 28L);
  write_line_text(f);
  read_stdin_ln();
}  /* pause */


Static Void page(f)
FILE *f;
{
  pause(f, true);
  line_count = 0;
  if (page_length >= MAX_PAGE_LENGTH)
    return;
  write_char_text(f, '\f');
  if (diary)
    write_char_text(diary_file, '\f');
}  /* page */


Static Void write_line(f)
FILE *f;
{
  write_line_text(f);
  if (diary)
    write_line_text(diary_file);
  pause(f, false);
  if (line_count + 1 > page_length)
    page(f);
  line_count++;
  char_count = 0;
}  /* write_line */


Static Void note_command_end_line(f)
FILE *f;
{
  if (echo_note)
    write_line(f);
}  /* note_command_end_line */


Static Void write_line_diary()
{
  if (!diary)
    return;
  write_line_text(diary_file);
  if (line_count + 1 > page_length) {
    line_count = 0;
    if (page_length < MAX_PAGE_LENGTH)
      write_char_text(diary_file, '\f');
  }
  line_count++;
  char_count = 0;
}  /* write_line_diary */


Static Void write_new_line(f)
FILE *f;
{
  if (line_length >= MAX_LINE_LENGTH)
    return;
  write_line(f);
  write_char_text(f, '/');
  write_char_text(f, '/');
  write_char_text(f, ' ');
  /* write_pch_10_text(f, '// @@@@@@@', 7); */
  if (diary)
    write_pch_10_text(diary_file, "// ", 7L);
}  /* write_new_line */


Static Void write_char(f, c)
FILE *f;
Char c;
{
  if (char_count > line_length + 9)
    write_new_line(f);
  char_count++;
  write_char_text(f, c);
  if (diary)
    write_char_text(diary_file, c);
}  /* write_char */


Static Void write_space(f, w)
FILE *f;
long w;
{
  t_long_integer i;

  if (char_count + w > line_length)
    write_new_line(f);
  char_count += w;
  for (i = 1; i <= w; i++)
    write_char_text(f, ' ');
  if (diary) {
    for (i = 1; i <= w; i++)
      write_char_text(diary_file, ' ');
  }
}  /* write_space */


Static Void write_boolean(f, b)
FILE *f;
boolean b;
{
  if (char_count + 5 > line_length)
    write_new_line(f);
  char_count += 5;
  write_boolean_text(f, b, 5L);
  if (diary)
    write_boolean_text(diary_file, b, 5L);
}  /* write_boolean */


Static Void write_integer(f, c, w)
FILE *f;
long c, w;
{
#ifdef CoCo_Cygwin
#ifdef DEBUG_E
  /* E */ printf("write_integer 1 \n");
  /* E */ printf("\n");
#endif /* E */
#endif /* CoCo_Cygwin */
  if (w < 0)
    w = -w;
  if (char_count + w > line_length)
    write_new_line(f);
  char_count += w;
  if (c == INFINITY) {
    write_char_w_text(f, '?', &w);
    if (diary)
      write_char_w_text(diary_file, '?', &w);
    return;
  }
  if (c == _INVALID) {
    write_char_w_text(f, '-', &w);
    if (diary)
      write_char_w_text(diary_file, '-', &w);
    return;
  }
  write_integer_text(f, c, &w);
  if (diary)
    write_integer_text(diary_file, c, &w);
}  /* write_integer */


Static Void write_real_fix_float(f, c, w, d, flt)
FILE *f;
double c;
long w, d;
boolean flt;
{
  t_long_real log_c;
  t_long_integer ci;

#ifdef CoCo_Cygwin
#ifdef DEBUG_E
  /* E */ printf("write_real_fix_float 1 \n");
  /* E */ printf("\n");
#endif /* E */
#endif /* CoCo_Cygwin */
  if (fabs(c) > fabs(0.9 * _INVALID_REAL)) {
    write_space(f, w - 1);
    write_char(f, '-');
    return;
  }
  if (char_count + w > line_length)
    write_new_line(f);
  char_count += w;
  if (d > 0) {
    if (c == 0)
      log_c = 1.0;
    else
      log_c = log(fabs(c)) / log(10.0);
    if ((!TURBO_PC && w > 7 && log_c >= w - d - 2 ||
	 !TURBO_PC && w > 7 && log_c < 2 - d - ROUND_ERROR) && flt) {
      write_real_text(f, &c, w, 0L);
      if (diary)
	write_real_text(diary_file, &c, w, 0L);
      return;
    }
    write_real_text(f, &c, w, d);
    if (diary)
      write_real_text(diary_file, &c, w, d);
    return;
  }
  if (w > 10) {
    write_space(f, w - 10);
    w = 10;
  }
  if (c > LONG_MAX) {
    write_real_text(f, &c, w, 0L);
    if (diary)
      write_real_text(diary_file, &c, w, 0L);
    return;
  }
  ci = (long)floor(c + 0.5);
  write_integer_text(f, ci, &w);
  if (diary)
    write_integer_text(diary_file, ci, &w);
}  /* write_real_fix_float */


Static Void write_real(f, c, w, d)
FILE *f;
double c;
long w, d;
{
#ifdef CoCo_Cygwin
#ifdef DEBUG_E
  /* E */ printf("write_real 1 \n");
  /* E */ printf("\n");
#endif /* E */
#endif /* CoCo_Cygwin */
  if (w < 0)
    write_real_fix_float(f, c, -w, d, false);
  else
    write_real_fix_float(f, c, w, d, true);
}  /* write_real */


Static Void write_command_name(f, c, w)
FILE *f;
Char *c;
long w;
{
  t_long_integer i;

  for (i = 0; i < w; i++)
    write_char_text(f, c[i]);
  if (diary) {
    for (i = 0; i < w; i++)
      write_char_text(diary_file, c[i]);
  }
}  /* write_command_name */


Static Void write_pch(f, c, w)
FILE *f;
Char *c;
long w;
{
  t_long_integer i;

  if (char_count + w > line_length)
    write_new_line(f);
  char_count += w;
  for (i = 0; i < w; i++)
    write_char_text(f, c[i]);
  if (diary) {
    for (i = 0; i < w; i++)
      write_char_text(diary_file, c[i]);
  }
}


Static Void note_command_end_pch(f, c, w)
FILE *f;
Char *c;
long w;
{
  if (echo_note)
    write_pch(f, c, w);
}


Static Void write_pch_r(f, c, w, l)
FILE *f;
Char *c;
long w, l;
{
  write_space(f, l - w);
  write_pch(f, c, w);
  write_char(f, ':');
  write_space(f, 1L);
}


/* #  ifdef CC-minus     


Static Void write_pch(f, c, w)
FILE *f;
Char *c;
long w;
{
  t_long_integer i;

  if (char_count + w > line_length)
    write_new_line(f);
  char_count += w;
  for (i = 0; i < w; i++)
    write_char_text(f, c[i]);
  if (diary) {
    for (i = 0; i < w; i++)
      write_char_text(diary_file, c[i]);
  }
}


Static Void note_command_end_pch(f, c, w)
FILE *f;
Char *c;
long w;
{
  if (echo_note)
    write_pch(f, c, w);
}


Static Void write_pch(f, c, w)
FILE *f;
Char *c;
long w;
{
  t_long_integer i;

  if (char_count + w > line_length)
    write_new_line(f);
  char_count += w;
  for (i = 0; i < w; i++)
    write_char_text(f, c[i]);
  if (diary) {
    for (i = 0; i < w; i++)
      write_char_text(diary_file, c[i]);
  }
}


Static Void note_command_end_pch(f, c, w)
FILE *f;
Char *c;
long w;
{
  if (echo_note)
    write_pch(f, c, w);
}


Static Void write_pch(f, c, w)
FILE *f;
Char *c;
long w;
{
  t_long_integer i;

  if (char_count + w > line_length)
    write_new_line(f);
  char_count += w;
  for (i = 0; i < w; i++)
    write_char_text(f, c[i]);
  if (diary) {
    for (i = 0; i < w; i++)
      write_char_text(diary_file, c[i]);
  }
}


Static Void write_pch(f, c, w)
FILE *f;
Char *c;
long w;
{
  t_long_integer i;

  if (char_count + w > line_length)
    write_new_line(f);
  char_count += w;
  for (i = 0; i < w; i++)
    write_char_text(f, c[i]);
  if (diary) {
    for (i = 0; i < w; i++)
      write_char_text(diary_file, c[i]);
  }
}


Static Void write_pch_r(f, c, w, l)
FILE *f;
Char *c;
long w, l;
{
  write_space(f, l - w);
  write_pch(f, c, w);
  write_char(f, ':');
  write_space(f, 1L);
}


Static Void write_pch_r(f, c, w, l)
FILE *f;
Char *c;
long w, l;
{
  write_space(f, l - w);
  write_pch(f, c, w);
  write_char(f, ':');
  write_space(f, 1L);
}


Static Void write_pch_r(f, c, w, l)
FILE *f;
Char *c;
long w, l;
{
  write_space(f, l - w);
  write_pch(f, c, w);
  write_char(f, ':');
  write_space(f, 1L);
}


Static Void write_pch(f, c, w)
FILE *f;
Char *c;
long w;
{
  t_long_integer i;

  if (char_count + w > line_length)
    write_new_line(f);
  char_count += w;
  for (i = 1; i <= w; i++)
    write_char_text(f, c[i - PCH_START]);
  if (diary) {
    for (i = 1; i <= w; i++)
      write_char_text(diary_file, c[i - PCH_START]);
  }
}


     #  endif CC-minus */


Static Void write_pch_to_blank(f, c, w)
FILE *f;
Char *c;
long w;
{
  t_long_integer i;

  i = 1;
  while (c[i - PCH_START] != '\0' && c[i - PCH_START] != ' ' && i <= w)
    i++;
  i--;
  write_pch(f, c, i);
}  /* write_pch_to_blank */


/*@-"in.c"*/
/*@+"in.p"*/


Static Void read_char(f, c)
FILE *f;
Char *c;
{
  read_text_char(f, c);
  if (log_on)
    write_char_text(log_file, *c);
  if (diary && !echo)
    write_char_text(diary_file, *c);
  if (echo) {
    /*$ifdef TRACE*/
    write_char(stdout, *c);
  }
  if (!boolean_option[23])
    return;
  /*$endif TRACE*/
  write_char(stdout, '%');
  write_char(stdout, *c);
  write_char(stdout, '%');
  write_line(stdout);
}  /* read_char */


Static Void read_line(f)
FILE *f;
{
  read_text_ln(f);
  if (log_on)
    write_line_text(log_file);
  if (!echo)
    write_line_diary();
  if (echo) {
    write_line(stdout);
    write_char(stdout, ' ');
  }
}  /* read_line */


Static Void read_char_non_echo(f, c)
FILE *f;
Char *c;
{
  read_text_char(f, c);
  if (log_on)
    write_char_text(log_file, *c);
  if (diary && !echo)
    write_char_text(diary_file, *c);
}  /* read_char_non_echo */


Static Void read_line_non_echo(f)
FILE *f;
{
  read_text_ln(f);
  if (log_on)
    write_line_text(log_file);
  if (!echo)
    write_line_diary();
}  /* read_line_non_echo */


Static Void read_line_plus(f)
FILE *f;
{
  read_text_ln(f);
  if (log_on)
    write_line_text(log_file);
  write_line_diary();
  write_pch(stdout, " + ->", 5L);
}  /* read_line_plus */


Static Void read_char_data(f, c)
FILE *f;
Char *c;
{
  read_text_char(f, c);
  if (data_line_position < PCH_END) {
    data_line_position++;
    last_data_line[data_line_position - PCH_START] = *c;
  }
  if (log_on && log_data_on)
    write_char_text(log_file, *c);
  if (term && diary)
    write_char_text(diary_file, *c);
}  /* read_char_data */


Static Void read_line_data(f)
FILE *f;
{
  read_text_ln(f);
  data_line_position = 0;
  data_line_number++;
  if (log_on && log_data_on)
    write_line_text(log_file);
  if (!term) {
    if (log_on && log_data_on)
      write_pch_10_text(log_file, "#Data: ", 7L);
    return;
  }
  if (diary) {
    write_line_diary();
    write_char_text(diary_file, ' ');
  }
  write_pch(stdout, " DATA->", 7L);
}  /* read_line_data */


Static Void read_line_data_plus(f)
FILE *f;
{
  read_text_ln(f);
  data_line_position = 0;
  data_line_number++;
  if (log_on && log_data_on)
    write_line_text(log_file);
  if (!term) {
    if (log_on && log_data_on)
      write_pch_10_text(log_file, "#Data: ", 7L);
    return;
  }
  if (diary) {
    write_line_diary();
    write_char_text(diary_file, ' ');
  }
  write_pch(stdout, " + DATA-> ", 10L);
}  /* read_line_data_plus */


Static Void copy_string(a, b, count, ifail)
Char *a, *b;
long *count, *ifail;
{
  t_long_integer i;

  i = PCH_START;
  while (a[i - PCH_START] != '\0' && a[i - PCH_START] != ' ' && i < *count) {
    b[i - PCH_START] = a[i - PCH_START];
    i++;
  }
  b[i - PCH_START] = '\0';
  if (a[i - PCH_START] != '\0' && a[i - PCH_START] != ' ') {
    while (a[i - PCH_START] != '\0' && a[i - PCH_START] != ' ' && i < PCH_END)
      i++;
    *ifail = 70;
  }
  *count = i;
}  /* copy_string */


Static Void copy_pch_long(a, b)
Char *a, *b;
{
  t_long_integer i;

  i = PCH_START;
  while (a[i - PCH_START] != '\0' && a[i - PCH_START] != ' ' && i < PCH_END) {
    b[i - PCH_START] = a[i - PCH_START];
    i++;
  }
  b[i - PCH_START] = '\0';
}  /* copy_pch_long */


Static Void read_file_name(f, name)
FILE *f;
Char *name;
{
  t_long_integer i;
  Char c, d;

  for (i = PCH_START; i <= FILE_NAME_LENGTH; i++)
    name[i - PCH_START] = ' ';
  while (eolnnotf_command(f)) {
    read_line_non_echo(f);
    write_pch(stdout, " FILE->", 7L);
  }
  if (echo) {
    write_line_diary();
    write_pch(stdout, " FILE->", 7L);
  }
  if (eof_command(f))
    c = '@';
  else
    read_char(f, &c);
  while ((c == ' ') & (!eolnorf_command(f)))
    read_char(f, &c);
  i = PCH_START;
  d = '@';
  while (((c != ';' || c == ';' && d != '\\') && i <= FILE_NAME_LENGTH) &
	 (!eolnorf_command(f))) {
    name[i - PCH_START] = c;
    d = c;
    read_char(f, &c);
    i++;
  }
  if ((c != ';') & eoln_command(f)) {
    name[i - PCH_START] = c;
    name[i - PCH_START + 1] = '\0';
  } else
    name[i - PCH_START] = '\0';
  if (echo)
    write_line(stdout);
}  /* read_file_name */


Static Void default_to_file_name(default_name, file_name)
Char *default_name;
Char *file_name;
{
  long i;

  i = PCH_START;
  while (default_name[i - 1] != ' ' && i <= 40) {
    file_name[i - PCH_START] = default_name[i - 1];
    i++;
  }
  while (i <= FILE_NAME_LENGTH) {
    file_name[i - PCH_START] = ' ';
    i++;
  }
}  /* default_to_file_name */


Static Void read_character(fil, command_, keyboard, c)
FILE *fil;
boolean command_, keyboard;
Char *c;
{
  if (command_)
    read_char_non_echo(fil, c);
  else if (keyboard)
    read_text_char(fil, c);
  else {
    /*$ifdef TRACE*/
    read_char_data(fil, c);
  }
  if (!boolean_option[23])
    return;
  /*$endif TRACE*/
  write_char(stdout, '&');
  write_char(stdout, *c);
  write_char(stdout, '&');
  write_line(stdout);
}  /* read_character */


Static Void read_line_end(fil, command_, keyboard)
FILE *fil;
boolean command_, keyboard;
{
  if (command_) {
    read_line_plus(fil);
    return;
  }
  if (keyboard)
    read_text_ln(fil);
  else
    read_line_data_plus(fil);
}  /* read_line_end */


Static Void skip_word(data_file, c, skip_count, echo)
FILE *data_file;
Char c;
long *skip_count;
boolean echo;
{
  pch_long d;
  t_long_integer i;

  (*skip_count)++;
  if (echo) {
    write_pch(stdout, " Skipping:", 10L);
    write_space(stdout, 2L);
  }
  i = 1;
  d[i - PCH_START] = c;
  while (!(eolnnotf_data(data_file) || d[i - PCH_START] == ' ')) {
    i++;
    read_char_data(data_file, &d[i - PCH_START]);
  }
  if (echo) {
    write_pch(stdout, d, i);
    write_line(stdout);
  }
}  /* skip_word */


Static Void seek_non_blank(fil, command_, keyboard, promb, w, c)
FILE *fil;
boolean command_, keyboard;
Char *promb;
long w;
Char *c;
{
  *c = ' ';
  do {
    while (eolnnotf_command(fil)) {
      read_line_end(fil, command_ && !keyboard, keyboard);
      if (command_)
	write_pch(stdout, promb, w);
    }
    if (eof_command(fil))
      *c = '/';
    else {
      read_character(fil, command_, keyboard, c);
      while ((*c == ' ' || *c == '\t' || *c == ',') & (!eolnorf_command(fil)))
	read_character(fil, command_, keyboard, c);
    }
  } while (!(*c != ' ' && *c != '\t' && *c != ',' || command_ || keyboard));
      /* seek_non_blank */
}


Static Void seek_non_blank_data(fil, command_, keyboard, c)
FILE *fil;
boolean command_, keyboard;
Char *c;
{
  seek_non_blank(fil, command_, keyboard, "1234567890", 0L, c);
}  /* seek_non_blank_data */


Static boolean seek_word(data_file, command_, keyboard, word_to_find, i,
			 length, skip_count, echo)
FILE *data_file;
boolean command_, keyboard;
Char *word_to_find;
long i, length, skip_count;
boolean echo;
{
  Char c, d;
  boolean ok;

  ok = true;
  c = ' ';
  d = '@';
  while (ok && i <= length) {
    if (eolnorf_command(data_file)) {
      ok = false;
      break;
    }
    read_character(data_file, command_, keyboard, &c);
    if (isupper(c))
      d = c + 32;
    else
      d = c;
    if (d == word_to_find[i - 1])
      i++;
    else
      ok = false;
  }
  if (ok & (!eolnorf_command(data_file))) {
    read_character(data_file, command_, keyboard, &c);
    if (c != ' ' && c != ',' && c != ';')
      ok = false;
  }
  if (ok)
    return ok;
  write_pch(stdout, " Keyword `", 10L);
  write_pch(stdout, word_to_find, length);
  write_pch(stdout, "' expected and assumed", 22L);
  write_line(stdout);
  if (c == ' ' && (d == ' ' || d == '@')) {
    write_pch(stdout, " Unexpected EndOfLine/Keyword", 29L);
    write_line(stdout);
  } else
    skip_word(data_file, c, &skip_count, echo);
  return ok;
}  /* seek_word */


Static Void read_integer_separator(fil, command_, keyboard, one_digit, promb,
				   w, i, c)
FILE *fil;
boolean command_, keyboard, one_digit;
Char *promb;
long w, *i;
Char *c;
{
  seek_non_blank(fil, command_, keyboard, promb, w, c);
  if (*c == '-') {
    *i = STRUCT_ZERO;
    return;
  }
  if (*c == '/' || *c == ';') {
    *i = _UNDEF;
    return;
  }
  if (*c == '.' || *c == '*') {
    *i = MISSING;
    return;
  }
  if (*c == 'n' || *c == 'N') {
    if (seek_word(fil, command_, keyboard, "Null", 2L, 4L, *i,
		  true))
      *i = 0;
    else
      *i = 0;
    return;
  }
  if (*c == 'v' || *c == 'V') {
    if (seek_word(fil, command_, keyboard, "Variating", 2L, 9L, *i,
		  true))
      *i = 0;
    else
      *i = 0;
    return;
  }
  if (*c == 'r' || *c == 'R') {
    if (seek_word(fil, command_, keyboard, "Random", 2L, 6L, *i,
		  true))
      *i = MAXIMAL;
    else
      *i = MAXIMAL;
    return;
  }
  if (!isdigit(*c)) {
    *i = _INVALID;
    return;
  }
  *i = 0;
  while (isdigit(*c)) {
    *i = *i * 10 + *c - '0';
    if (eolnorf_command(fil) || one_digit)
      *c = ' ';
    else
      read_character(fil, command_, keyboard, c);
  }
}  /* read_integer_separator */


Static Void read_integer(f, promb, w, x)
FILE *f;
Char *promb;
long w, *x;
{
  Char c;

  do {
    read_integer_separator(f, true, true, false, promb, w, x, &c);
    if (*x == STRUCT_ZERO) {
      read_integer_separator(f, true, true, false, promb, w, x, &c);
      if (*x != _INVALID && *x != _UNDEF && *x != MISSING)
	*x = -*x;
    }
    if (echo || *x == _INVALID || *x == _UNDEF || *x == MISSING) {
      write_pch(stdout, promb, w);
      if (*x != _INVALID && *x != _UNDEF && *x != MISSING)
	write_integer(stdout, *x, 10L);
      else
	write_pch(stdout, " Invalid  ", 10L);
      write_line(stdout);
    }
  } while (!((*x != _INVALID && *x != _UNDEF && *x != MISSING) | eof_command(f)));
      /* read_integer */
}


Static Void read_integer_data(fil, command_, keyboard, i)
FILE *fil;
boolean command_, keyboard;
long *i;
{
  Char c;

  read_integer_separator(fil, command_, keyboard, false, "1234567890", 0L, i,
			 &c);
}  /* read_integer_data */


Static Void sub_read_list_level(f, one_digit, level, c)
FILE *f;
boolean one_digit;
t_level *level;
Char *c;
{
  t_long_integer i;

  read_integer_separator(f, false, false, one_digit, "1234567890", 0L, &i, c);
  if (i == MISSING) {
    *level = MISSING_LEVEL;
    return;
  }
  if (i == _UNDEF) {
    *level = _UNDEF_LEVEL;
    return;
  }
  if ((unsigned long)i <= MAX_LEVEL)
    *level = i;
  else
    *level = _INVALID_LEVEL;
}  /* sub_read_list_level */


Static Void read_list_level(f, one_digit, level, c)
FILE *f;
boolean one_digit;
t_level *level;
Char *c;
{
  sub_read_list_level(f, one_digit, level, c);
  if (*level != MISSING_LEVEL && *level != _UNDEF_LEVEL &&
      *level != _INVALID_LEVEL)
    *level += FIRST_LEVEL - 1;
}  /* read_list_level */


Static Void read_level(f, level, c)
FILE *f;
t_level *level;
Char *c;
{
  sub_read_list_level(f, false, level, c);
}  /* read_level */


Static Void write_level(f, level, w)
FILE *f;
t_level level;
long w;
{
  if (level == MISSING_LEVEL)
    write_pch(f, " *        ", w);
  else
    write_integer(f, (long)level, w);
}  /* write_level */


Static Void read_real_separator(fil, command_, keyboard, promb, w, x, c)
FILE *fil;
boolean command_, keyboard;
Char *promb;
long w;
double *x;
Char *c;
{
  boolean found_digit, minus;
  t_long_integer i, count;

  i = 0;
  seek_non_blank(fil, command_, keyboard, promb, w, c);
  found_digit = false;
  if (*c == '/') {
    *x = _UNDEF;
    return;
  }
  if (*c == '*') {
    *x = MISSING;
    return;
  }
  if (*c == 'n' || *c == 'N') {
    if (seek_word(fil, command_, keyboard, "Null", 2L, 4L, i,
		  true))
      *x = 0.0;
    else
      *x = 0.0;
    return;
  }
  if (!(*c == '.' || *c == '-' || *c == '+' || isdigit(*c))) {
    *x = _INVALID;
    return;
  }
  minus = false;
  if (*c == '-' || *c == '+') {
    minus = (*c == '-');
    if (!eolnnotf_command(fil))
      read_character(fil, command_, keyboard, c);
    else
      *c = ' ';
  }
  if (!(*c == '.' || isdigit(*c))) {
    *x = _INVALID;
    return;
  }
  i = 0;
  while (isdigit(*c)) {
    found_digit = true;
    i = i * 10 + *c - '0';
    if (eolnorf_command(fil))
      *c = ' ';
    else
      read_character(fil, command_, keyboard, c);
  }
  *x = i;
  if (*c == '.') {
    if (!eolnnotf_command(fil))
      read_character(fil, command_, keyboard, c);
    else
      *c = ' ';
    i = 0;
    count = 0;
    while (isdigit(*c)) {
      found_digit = true;
      i = i * 10 + *c - '0';
      count++;
      if (eolnorf_command(fil))
	*c = ' ';
      else
	read_character(fil, command_, keyboard, c);
    }
    if (found_digit)
      *x += i / exp(count * log(10.0));
    else
      *x = MISSING;
  }
  if (minus)
    *x = -*x;
  if (*c != 'e' && *c != 'E')
    return;
  if (!eolnnotf_command(fil))
    read_character(fil, command_, keyboard, c);
  else
    *c = ' ';
  minus = false;
  if (*c == '-' || *c == '+') {
    minus = (*c == '-');
    if (!eolnnotf_command(fil))
      read_character(fil, command_, keyboard, c);
    else
      *c = ' ';
  }
  i = 0;
  while (isdigit(*c)) {
    i = i * 10 + *c - '0';
    if (eolnorf_command(fil))
      *c = ' ';
    else
      read_character(fil, command_, keyboard, c);
  }
  if (minus)
    *x /= exp(i * log(10.0));
  else
    *x *= exp(i * log(10.0));
}  /* read_real_separator */


Static Void read_real(f, promb, w, x)
FILE *f;
Char *promb;
long w;
double *x;
{
  Char c;

  do {
    read_real_separator(f, true, true, promb, w, x, &c);
    if (echo || *x == _INVALID || *x == _UNDEF || *x == MISSING) {
      write_pch(stdout, promb, w);
      if (*x != _INVALID && *x != _UNDEF && *x != MISSING)
	write_real(stdout, *x, 10L, 5L);
      else
	write_pch(stdout, " Invalid  ", 10L);
      write_line(stdout);
    }
  } while (!((*x != _INVALID && *x != _UNDEF && *x != MISSING) | eof_command(f)));
      /* read_real */
}


Static Void read_real_data(fil, command_, keyboard, x)
FILE *fil;
boolean command_, keyboard;
double *x;
{
  Char c;

  read_real_separator(fil, command_, keyboard, "1234567890", 0L, x, &c);
}  /* read_real_data */


/*@-"mat.c"*/
/*@+"mat.p"*/


Static long floor_x(x)
double x;
{
  if (fabs(x - (long)x) < ROUND_ERROR)
    return ((long)x);
  else if (x < 0)
    return ((long)x - 1);
  else
    return ((long)x);
}  /* floor_x */


Static long ceil_x(x)
double x;
{
  if (fabs(x - (long)x) < ROUND_ERROR)
    return ((long)x);
  else if (x < 0)
    return ((long)x);
  else
    return ((long)x + 1);
}  /* ceil_x */


Static double exp10_(x)
double x;
{
  return exp(x * log(10.0));
}  /* exp10 */


Static double log_10(x)
double x;
{
  return (log(x) / log(10.0));
}  /* log_10 */


Static double delta_round(x, delta)
double x, delta;
{
  if (fabs(x) < ROUND_ERROR * delta)
    return 0.0;
  else
    return x;
}  /* delta_round */


Static Void scale(min, max, max_int, a, b, delta, n_int)
double min, max;
long max_int;
double *a, *b, *delta;
long *n_int;
{
  t_long_integer n_int_0, factor;
  t_long_real d;

  n_int_0 = max_int;
  if (min == max) {
    *delta = 0.0;
    return;
  }
  do {
    *delta = (max - min) / n_int_0;
    factor = floor_x(log_10(*delta));
    d = *delta / exp10_((double)factor);
    if (d <= 1.00)
      d = 1.00;
    else if (d <= 1.25)
      d = 1.25;
    else if (d <= 1.50)
      d = 1.50;
    else if (d <= 2.00)
      d = 2.00;
    else if (d <= 2.50)
      d = 2.50;
    else if (d <= 3.00)
      d = 3.00;
    else if (d <= 4.00)
      d = 4.00;
    else if (d <= 5.00)
      d = 5.00;
    else if (d <= 6.00)
      d = 6.00;
    else if (d <= 7.00)
      d = 7.00;
    else if (d <= 8.00)
      d = 8.00;
    else if (d <= 9.00)
      d = 9.00;
    else if (d <= 10.00)
      d = 10.00;
    *delta = d * exp10_((double)factor);
    *a = floor_x(min / *delta) * *delta;
    *b = ceil_x(max / *delta) * *delta;
    n_int_0--;
    *n_int = (long)floor((*b - *a) / *delta + 0.5);
  } while (*n_int > max_int);   /* scale */
}


Static boolean is_infinity_real(x)
double x;
{
  return (fabs(x) > 0.999 * INFINITY_REAL);
}  /* is_infinity_real */


Static boolean is_invalid_real(x)
double x;
{
  return (fabs(x) > fabs(0.999 * _INVALID_REAL));
}  /* is_invalid_real */


Static double log_fact(i)
long i;
{
  t_long_integer j;
  t_long_real x;

  if (i <= MAX_FACT) {
    if (i <= max_fact_found)
      return (fact_array[i]);
    if (max_fact_found == -1) {
      max_fact_found = 0;
      fact_array[0] = 0.0;
    }
    x = fact_array[max_fact_found];
    for (j = max_fact_found + 1; j <= i; j++) {
      x += log((double)j);
      fact_array[j] = x;
    }
    max_fact_found = i;
    return (fact_array[i]);
  } else
    return ((0.5 + i) * log((double)i) + 0.9189385335 - i + 1.0 / 12 / i);
}  /* log_fact */


Static double uniform(dummy)
long *dummy;
{
  *dummy = (*dummy * 7141 + 54773L) % 259200L;
  return ((*dummy + 0.5) / 259200L);
}  /* uniform */


#define c1_             0.3989422804014327

#define bigx            170


Static double tailnorm(x, upper)
double x;
boolean upper;
{
  t_long_real n, p1, p2, q1, q2, m, x2, y, s, t;
  long i;

  if (x == 0)
    return 0.5;
  else {
    if (x < 0)
      upper = !upper;
    x = fabs(x);
    x2 = x * x;
    if (x2 / 2 < bigx)
      y = c1_ * exp(-0.5 * x2);
    else
      y = 0.0;
    n = y / x;
    if (!upper && n == 0)
      return 1.0;
    else if (upper && n == 0)
      return 0.0;
    else {
      if (upper && x > 2.32 || !upper && x > 3.5) {
	q1 = x;
	p2 = y * x;
	i = 1;
	p1 = y;
	q2 = x2 + i;
	if (upper) {
	  s = p1 / q1;
	  m = s;
	  t = p2 / q2;
	} else {
	  s = i - p1 / q1;
	  m = s;
	  t = i - p2 / q2;
	}
	while (m != t && s != t) {
	  i++;
	  s = x * p2 + i * p1;
	  p1 = p2;
	  p2 = s;
	  s = x * q2 + i * q1;
	  q1 = q2;
	  q2 = s;
	  s = m;
	  m = t;
	  if (upper)
	    t = p2 / q2;
	  else
	    t = 1 - p2 / q2;
	}
	return t;
      } else {
	s = y * x;
	x = y * x;
	i = 1;
	t = 0.0;
	while (s != t) {
	  i += 2;
	  t = s;
	  x = x * x2 / i;
	  s += x;
	}
	if (upper)
	  return (0.5 - s);
	else
	  return (0.5 + s);
      }
    }
  }
}  /* tailnorm */

#undef c1_
#undef bigx


Static double pnormal(u)
double u;
{
  return (tailnorm(u, true));
}  /* pnormal */


#define a0_             0.57236494


Local double lngamma(w)
double w;
{
  t_long_real sum;

  sum = 0.0;
  w--;
  while (w > 0.0) {
    sum += log(w);
    w--;
  }
  if (w < 0.0)
    return (sum + a0_);
  else
    return sum;
}  /* lngamma */

#undef a0_


Static double chi_squared_prob(x, k)
double x;
long k;
{
  double Result;
  t_long_real factor, g, k1, sum, term, x1;

  x1 = 0.5 * x;
  k1 = 0.5 * k;
  g = lngamma(k1 + 1);
  if (k1 * log(x1) - g - x1 > -1000)
    factor = exp(k1 * log(x1) - g - x1);
  else
    factor = 0.0;
  sum = 0.0;
  if (factor > 0) {
    term = 1.0;
    sum = 1.0;
    while (term / sum > 1e-6) {
      k1++;
      term = term * x1 / k1;
      sum += term;
    }
  }
  Result = sum * factor;
  if (factor <= 0)
    return 1.0;
  return Result;
}  /* chi_squared_prob */


#define a1              0.196854
#define a2              0.115194
#define a3              0.000344
#define a4              0.019527


Local double normal_prob_approx(z)
double z;
{
  t_long_real w;

  w = fabs(z);
  w = 1 + w * (a1 + w * (a2 + w * (a3 + w * a4)));
  w *= w * w * w;
  w = 1 - 0.5 / w;
  if (z >= 0)
    return w;
  else
    return (1 - w);
}  /* normal_prob_approx */

#undef a1
#undef a2
#undef a3
#undef a4


Static double chi_squared_prob_approx(x, k)
double x;
long k;
{
  t_long_real a, w1, w2, f_third, z;

  a = 2.0 / (9.0 * k);
  f_third = exp(log(x / k) / 3.0);
  w1 = f_third + a - 1;
  w2 = a;
  z = w1 / sqrt(w2);
  return (normal_prob_approx(z));
}  /* chi_squared_prob_approx */


#define a1              2.30753
#define a2              0.27061
#define a3              0.99229
#define a4              0.04481


Static double normal_percent_point_approx(p)
double p;
{
  t_long_real w, p1, t;

  p1 = 0.5 + fabs(p - 0.5);
  t = sqrt(-2.0 * log(1 - p1));
  w = a1 + a2 * t;
  w /= 1.0 + t * (a3 + a4 * t);
  w = t - w;
  if (p >= 0.5)
    return w;
  else
    return (-w);
}  /* normal_percent_point_approx */

#undef a1
#undef a2
#undef a3
#undef a4


Static double khi(df, q)
long df;
double q;
{
  double Result;

  Result = _INVALID_REAL;
  if (is_invalid_real(q) || df == INFINITY)
    return Result;
  if (df > 0 && q > 0) {
    if (df < 5)
      return (1 - chi_squared_prob(q, df));
    else
      return (1 - chi_squared_prob_approx(q, df));
  }
  if (df > 0)
    return 1.0;
  if (df == 0 && q <= sqrt(ROUND_ERROR))
    return 1.0;
  return Result;
}  /* khi */


/* Local variables for sub_select_p_value: */
struct LOC_sub_select_p_value {
  t_test *test;
} ;

Local double compute_crit(df, q, LINK)
long df;
double q;
struct LOC_sub_select_p_value *LINK;
{
  if (ic) {
    if (df < INFINITY) {
      if (bic && exclude_missing) {
	if (LINK->test->n_count == _INVALID_COUNT)
	  return _INVALID_REAL;
	else
	  return (log((double)LINK->test->n_count) * df - q);
      } else
	return (ic_lambda * df - q);
    } else
      return (-q);
  } else
    return (khi(df, q));
}  /* compute_crit */

Local double compute_crit_real(df, q, LINK)
double df, q;
struct LOC_sub_select_p_value *LINK;
{
  if (ic) {
    if (bic && exclude_missing) {
      if (LINK->test->n_count == _INVALID_COUNT)
	return _INVALID_REAL;
      else
	return (log((double)LINK->test->n_count) * df - q);
    } else
      return (ic_lambda * df - q);
  } else
    return _INVALID_REAL;
}  /* compute_crit_real */


Static double sub_select_p_value(test_)
t_test *test_;
{
  struct LOC_sub_select_p_value Local_Var;
  double Result;
  t_long_real statistic;
  t_test *WITH;

  Local_Var.test = test_;
  WITH = Local_Var.test;
  if (((exact_test && ordinal_tests) & (!is_invalid_real(WITH->gamma))) &&
      WITH->mcep_gamma_1 > -1)
    return (WITH->mcep_gamma_2);
  else if ((ordinal_tests & (!is_invalid_real(WITH->gamma)) &
	    (!is_invalid_real(WITH->s))) && fabs(WITH->s) > 0)
    return (2 * pnormal(fabs(WITH->gamma / sqrt(WITH->s))));
  else if (exact_test && (WITH->mcep_deviance > -1 && test_choice == 1 ||
			  WITH->mcep_pearson > -1 && test_choice > 1)) {
    switch (test_choice) {

    case 1:
      Result = WITH->mcep_deviance;
      break;

    case 2:
      Result = WITH->mcep_pearson;
      break;

    case 3:
      Result = WITH->mcep_power;
      break;
    }
    return Result;
  } else {
    switch (test_choice) {

    case 1:
      statistic = WITH->x_deviance;
      break;

    case 2:
      statistic = WITH->x_pearson;
      break;

    case 3:
      statistic = WITH->x_power;
      break;
    }
    if (!is_invalid_real(statistic)) {
      if (WITH->df < INFINITY || ic && !bic && ic_lambda == 0) {
	if (adj_df && WITH->adj != INFINITY)
	  return (compute_crit(WITH->df - WITH->adj, statistic, &Local_Var));
	else
	  return (compute_crit(WITH->df, statistic, &Local_Var));
      } else
	return (compute_crit_real(WITH->df_real, statistic, &Local_Var));
    } else
      return _INVALID_REAL;
  }
  return Result;
}  /* sub_select_p_value */
/* p2c: coco_d_p2c.p, line 3956: 
 * Warning: Symbol 'Result' was already defined [220] */


Static double select_p_value(link_test_list)
t_test_list *link_test_list;
{
  return (sub_select_p_value(&link_test_list->test));
}  /* select_p_value */


Static double select_asymptotic_p_value(link_test_list)
t_test_list *link_test_list;
{
  t_long_real statistic;
  t_test *WITH;

  WITH = &link_test_list->test;
  switch (test_choice) {

  case 1:
    statistic = WITH->x_deviance;
    break;

  case 2:
    statistic = WITH->x_pearson;
    break;

  case 3:
    statistic = WITH->x_power;
    break;
  }
  if (!is_invalid_real(statistic)) {
    if (adj_df)
      return (khi(WITH->df - WITH->adj, statistic));
    else
      return (khi(WITH->df, statistic));
  } else
    return 1.0;
}  /* select_asymptotic_p_value */


/*@-"hash.c"*/
/*@+"marginal.p"*/


Static boolean return_first_vertex_in_set(v, a)
t_vertex *v;
long *a;
{
  *v = first_vertex;
  while (!P_inset(*v, a) && *v < last_vertex)
    (*v)++;
  return P_inset(*v, a);
}  /* return_first_vertex_in_set */


Static boolean return_next_vertex_in_set(v, a)
t_vertex *v;
long *a;
{
  if (*v < last_vertex) {
    (*v)++;
    while (!P_inset(*v, a) && *v < last_vertex)
      (*v)++;
    return P_inset(*v, a);
  } else
    return false;
}  /* return_next_vertex_in_set */


Static long cardinality(a)
long *a;
{
  t_vertex v;
  t_long_integer card;
  boolean ok;

  card = 0;
  ok = return_first_vertex_in_set(&v, a);
  while (ok) {
    card++;
    ok = return_next_vertex_in_set(&v, a);
  }
  return card;
}  /* cardinality */


Static Void next_cell(i)
t_level *i;
{
  t_vertex v;

  v = first_vertex;
  while (i[v - MIN_VERTEX] ==
	 FIRST_LEVEL + vertex_inf[v - MIN_VERTEX].levels - 1 &&
	 v < last_vertex) {
    i[v - MIN_VERTEX] = FIRST_LEVEL;
    v++;
  }
  if (v == last_vertex &&
      i[v - MIN_VERTEX] == FIRST_LEVEL + vertex_inf[v - MIN_VERTEX].levels - 1)
    i[v - MIN_VERTEX] = FIRST_LEVEL;
  else
    i[v - MIN_VERTEX]++;
}  /* next_cell */


Static long marginal_dimension_tf(a, total, full)
long *a;
boolean total, full;
{
  t_long_integer levels, product;
  boolean ok;
  t_vertex v, w;

  product = 1;
  ok = true;
  if (full)
    w = full_last_vertex;
  else
    w = last_vertex;
  for (v = first_vertex; v <= w; v++) {
    if (P_inset(v, a)) {
      if (full) {
	if (total)
	  levels = full_vertex_inf[v - MIN_VERTEX].levels_total;
	else
	  levels = full_vertex_inf[v - MIN_VERTEX].levels;
      } else if (total)
	levels = vertex_inf[v - MIN_VERTEX].levels_total;
      else
	levels = vertex_inf[v - MIN_VERTEX].levels;
      if (product > (double)INFINITY / levels)
	ok = false;
      else
	product *= levels;
    }
  }
  if (ok)
    return product;
  else
    return INFINITY;
}  /* marginal_dimension_tf */


Static long marginal_dimension(a)
long *a;
{
  t_long_integer product;
  boolean ok;
  t_vertex v, FORLIM;

  product = 1;
  ok = true;
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    if (P_inset(v, a)) {
      if (product > (double)INFINITY / vertex_inf[v - MIN_VERTEX].levels)
	ok = false;
      else
	product *= vertex_inf[v - MIN_VERTEX].levels;
    }
  }
  if (ok)
    return product;
  else
    return INFINITY;
}  /* marginal_dimension */


Static long last_index(a)
long *a;
{
  return (FIRST_INDEX + marginal_dimension(a) - 1);
}  /* last_index */


Static double marginal_dimension_real(a)
long *a;
{
  t_long_real product;
  t_vertex v, FORLIM;

  product = 1.0;
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    if (P_inset(v, a))
      product *= vertex_inf[v - MIN_VERTEX].levels;
  }
  return product;
}  /* marginal_dimension_real */


Static boolean ok_to_find_marginal_hash(a)
long *a;
{
  return (marginal_dimension(a) < INFINITY);
}  /* ok_to_find_marginal_hash */


Static t_cell_index marginal_hash(a, i)
long *a;
t_level *i;
{
  t_cell_index sum, product;
  t_vertex v, f, l;
  t_vertex_set b;

  if (P_setequal(a, empty_set)) {
    sum = FIRST_INDEX;
    return sum;
  }
  f = first_vertex;
  while (!P_inset(f, a))
    f++;
  sum = FIRST_INDEX + i[f - MIN_VERTEX] - FIRST_LEVEL;
  P_addset(P_expset(b, 0L), f);
  if (P_setequal(a, b))
    return sum;
  l = last_vertex;
  while (!P_inset(l, a))
    l--;
  product = vertex_inf[f - MIN_VERTEX].levels;
  for (v = f + 1; v < l; v++) {
    if (P_inset(v, a)) {
      sum += (i[v - MIN_VERTEX] - FIRST_LEVEL) * product;
      product *= vertex_inf[v - MIN_VERTEX].levels;
    }
  }
  sum += (i[l - MIN_VERTEX] - FIRST_LEVEL) * product;
  return sum;
}  /* marginal_hash */


Static Void next_marginal_cell(a, i)
long *a;
t_level *i;
{
  t_vertex v;
  t_vertex_set b;

  v = first_vertex;
  P_setdiff(b, delta, a);
  while (P_inset(v, b) && v < last_vertex)
    v++;
  while (((i[v - MIN_VERTEX] ==
	   FIRST_LEVEL + vertex_inf[v - MIN_VERTEX].levels - 1) | P_inset(v, b)) &&
	 v < last_vertex) {
    if (P_inset(v, a))
      i[v - MIN_VERTEX] = FIRST_LEVEL;
    v++;
  }
  if (!P_inset(v, a))
    return;
  if (v == last_vertex &&
      i[v - MIN_VERTEX] == FIRST_LEVEL + vertex_inf[v - MIN_VERTEX].levels - 1)
    i[v - MIN_VERTEX] = FIRST_LEVEL;
  else
    i[v - MIN_VERTEX]++;
}  /* next_marginal_cell */


Static boolean large_table(a, n)
long *a;
t_cell_count *n;
{
  t_long_integer size;
  long TEMP;
  double TEMP1;

  if (ok_to_find_marginal_hash(a)) {
    size = marginal_dimension(a);
    /*$ifdef TRACE*/
    if (!(boolean_option[3] || boolean_option[4]))
      return ((datastructure == list_file) &
	      (size > *n * log((double)(*n)) * (cardinality(a) + 1)));
    write_pch_10_text(stdout, " Size: ", 7L);
    TEMP = 20;
    write_integer_text(stdout, size, &TEMP);
    TEMP1 = *n * log((double)(*n)) * (cardinality(a) + 1);
    write_real_text(stdout, &TEMP1, 20L, 0L);
    write_line_text(stdout);
    /*$endif TRACE*/
    return ((datastructure == list_file) &
	    (size > *n * log((double)(*n)) * (cardinality(a) + 1)));
  } else
    return true;
}  /* large_table */


/*@-"odr.c"*/
/*@+"dispose.p"*/


Static Void dispose_integer_list(p)
t_integer_list **p;
{
  t_integer_list *q;

  while (*p != NULL) {
    q = (*p)->pointer;
    Free(*p);
    *p = q;
  }
}  /* dispose_integer_list */


Static Void dispose_real_list(p)
t_real_list **p;
{
  t_real_list *q;

  while (*p != NULL) {
    q = (*p)->pointer;
    Free(*p);
    *p = q;
  }
}  /* dispose_real_list */


Static Void revers_vertex_list(p)
t_vertex_list **p;
{
  t_vertex_list *hp1, *hp2;

  hp1 = NULL;
  while (*p != NULL) {
    hp2 = hp1;
    hp1 = *p;
    *p = (*p)->pointer;
    hp1->pointer = hp2;
  }
  *p = hp1;
}  /* revers_vertex_list */


Static Void dispose_offset_list(p)
t_offset_list **p;
{
  t_offset_list *q;

  while (*p != NULL) {
    q = (*p)->pointer;
    Free(*p);
    *p = q;
  }
}  /* dispose_offset_list */


Static Void dispose_vertex_list(p)
t_vertex_list **p;
{
  t_vertex_list *q;

  while (*p != NULL) {
    q = (*p)->pointer;
    Free(*p);
    *p = q;
  }
}  /* dispose_vertex_list */


Static Void dispose_list_of_vertex_lists(p)
t_list_of_vertex_lists **p;
{
  t_list_of_vertex_lists *q;

  while (*p != NULL) {
    dispose_vertex_list(&(*p)->vertex_list);
    q = (*p)->pointer;
    Free(*p);
    *p = q;
  }
}  /* dispose_list_of_vertex_lists */


Static Void dispose_set_list(p)
t_set_list **p;
{
  t_set_list *q;

  while (*p != NULL) {
    q = (*p)->pointer;
    Free(*p);
    *p = q;
  }
}  /* dispose_set_list */


Static Void dispose_g_c_list(p)
t_g_c_list **p;
{
  t_g_c_list *q;

  while (*p != NULL) {
    dispose_set_list(&(*p)->g_c);
    q = (*p)->pointer;
    Free(*p);
    *p = q;
  }
}  /* dispose_g_c_list */


Static Void dispose_edge_list(p)
t_edge_list **p;
{
  t_edge_list *q;

  while (*p != NULL) {
    q = (*p)->pointer;
    Free(*p);
    *p = q;
  }
}  /* dispose_edge_list */


Static Void dispose_cell_list(p)
t_cell_list **p;
{
  t_cell_list *q;

  while (*p != NULL) {
    q = (*p)->pointer;
    dispose_vertex_list(&(*p)->vertex_list);
    Free(*p);
    *p = q;
  }
}  /* dispose_cell_list */


Static Void dispose_expression(p)
t_expression **p;
{
  t_expression *q;

  while (*p != NULL) {
    q = (*p)->pointer;
    Free(*p);
    *p = q;
  }
}  /* dispose_expression */


Static Void dispose_ips_set_list(p)
t_ips_set_list **p;
{
  t_ips_set_list *q;

  while (*p != NULL) {
    q = (*p)->pointer;
    Free(*p);
    *p = q;
  }
}  /* dispose_ips_set_list */


Static Void dispose_ips_element(ips_element)
t_ips_element *ips_element;
{
  if (!ips_element->radim_part) {
    dispose_offset_list(&ips_element->link_q_tables);
    dispose_ips_set_list(&ips_element->gen_class);
  }
}  /* dispose_ips_element */


Static Void dispose_ips_list_blind(ips_list)
t_list_ips_elements **ips_list;
{
  t_list_ips_elements *q;

  while (*ips_list != NULL) {
    dispose_ips_element(&(*ips_list)->ips_element);
    q = (*ips_list)->pointer;
    Free(*ips_list);
    *ips_list = q;
  }
}  /* dispose_ips_list_blind */


Static Void dispose_radim_element(radim_element)
t_radim_element *radim_element;
{
  t_radim_part *p, *radim_part;

  dispose_ips_set_list(&radim_element->gen_class);
  dispose_offset_list(&radim_element->link_q_tables);
  dispose_integer_list(&radim_element->lower_n_offsets);
  radim_part = radim_element->radim_parts;
  while (radim_part != NULL) {
    dispose_offset_list(&radim_part->generators);
    dispose_offset_list(&radim_part->upper);
    dispose_offset_list(&radim_part->lower);
    dispose_offset_list(&radim_part->from);
    p = radim_part;
    radim_part = radim_part->pointer;
    Free(p);
  }
}  /* dispose_radim_element */


Static Void dispose_radim_list(radim_list)
t_list_radim_elements **radim_list;
{
  t_list_radim_elements *q;

  while (*radim_list != NULL) {
    dispose_radim_element(&(*radim_list)->radim_element);
    q = *radim_list;
    *radim_list = (*radim_list)->pointer;
    Free(q);
  }
}  /* dispose_radim_list */


Static Void dispose_radim_list_blind(radim_list)
t_list_radim_elements **radim_list;
{
  dispose_radim_list(radim_list);
}  /* dispose_radim_list_blind */


Static Void dispose_all_expressions()
{
  t_model_list *p_model;

  p_model = link_model_list;
  while (p_model != NULL) {
    p_model->model.found_expression = false;
    p_model->model.found_ps = false;
    dispose_expression(&p_model->model.expression);
    dispose_ips_list_blind(&p_model->model.ips_list);
    dispose_radim_list_blind(&p_model->model.radim_list);
    p_model = p_model->pointer;
  }
  fpa = P_START - FIRST_INDEX;
}  /* dispose_all_expressions */


Static Void dispose_ips_list(ips_list)
t_list_ips_elements **ips_list;
{
  t_list_ips_elements *q;
  t_e_p_cell_index min_p, max_p, index;
  t_model_list *p_model;
  t_e_p_cell_index FORLIM;

  if (em)
    write_pch(stdout, " Ups !!!!!", 10L);
  if (em) {
    dispose_all_expressions();
    return;
  }
  if (*ips_list == NULL)
    return;
  if ((*ips_list)->ips_element.p_offset != MAX_OFFSET) {
    min_p = (*ips_list)->ips_element.p_offset;
    max_p = min_p;
    while (*ips_list != NULL) {
      if (min_p > (*ips_list)->ips_element.p_offset)
	min_p = (*ips_list)->ips_element.p_offset;
      if (max_p < (*ips_list)->ips_element.p_offset +
		  marginal_dimension((*ips_list)->ips_element.a))
	max_p = (*ips_list)->ips_element.p_offset +
		marginal_dimension((*ips_list)->ips_element.a);
      dispose_ips_element(&(*ips_list)->ips_element);
      q = (*ips_list)->pointer;
      Free(*ips_list);
      *ips_list = q;
    }
    if (fpa > max_p) {
      FORLIM = fpa;
      for (index = max_p; index < FORLIM; index++)
	p[index - max_p + min_p] = p[index];
      p_model = link_model_list;
      while (p_model != NULL) {
	if (p_model->model.ips_list != NULL) {
	  if (p_model->model.ips_list->ips_element.p_offset > min_p &&
	      p_model->model.ips_list->ips_element.p_offset != MAX_OFFSET) {
	    q = p_model->model.ips_list;
	    while (q != NULL) {
	      q->ips_element.p_offset += min_p - max_p;
	      q = q->pointer;
	    }
	  }
	}
	p_model = p_model->pointer;
      }
    }
    fpa += min_p - max_p;
    return;
  }
  while (*ips_list != NULL) {
    dispose_ips_element(&(*ips_list)->ips_element);
    q = (*ips_list)->pointer;
    Free(*ips_list);
    *ips_list = q;
  }
}  /* dispose_ips_list */


Static Void dispose_em_expression_and_ips_list(expression, ips_list)
t_expression **expression;
t_list_ips_elements **ips_list;
{
  t_expression *p1;
  t_list_ips_elements *q;
  t_e_p_cell_index min_p, max_p, index;
  t_model_list *p_model;
  boolean do_it;
  t_e_p_cell_index FORLIM;

  do_it = false;
  if (*ips_list != NULL) {
    if ((*ips_list)->ips_element.p_offset != MAX_OFFSET)
      do_it = true;
  }
  if (*expression != NULL) {
    if ((*expression)->offset != MAX_OFFSET)
      do_it = true;
  }
  if (do_it) {
    if (*ips_list != NULL)
      min_p = (*ips_list)->ips_element.p_offset;
    else
      min_p = (*expression)->offset;
    max_p = min_p;
    while (*ips_list != NULL) {
      max_p = (*ips_list)->ips_element.p_offset +
	      marginal_dimension((*ips_list)->ips_element.a);
      dispose_ips_element(&(*ips_list)->ips_element);
      q = (*ips_list)->pointer;
      Free(*ips_list);
      *ips_list = q;
    }
    while (*expression != NULL) {
      max_p = (*expression)->offset + marginal_dimension((*expression)->vertex_set);
      p1 = (*expression)->pointer;
      Free(*expression);
      *expression = p1;
    }
    if (fpa > max_p) {
      FORLIM = fpa;
      for (index = max_p; index < FORLIM; index++)
	p[index - max_p + min_p] = p[index];
      p_model = link_model_list;
      while (p_model != NULL) {
	if (p_model->model.ips_list != NULL) {
	  if (p_model->model.ips_list->ips_element.p_offset > min_p &&
	      p_model->model.ips_list->ips_element.p_offset != MAX_OFFSET) {
	    q = p_model->model.ips_list;
	    while (q != NULL) {
	      q->ips_element.p_offset += min_p - max_p;
	      q = q->pointer;
	    }
	  }
	}
	if (p_model->model.expression != NULL) {
	  if (p_model->model.expression->offset > min_p &&
	      p_model->model.expression->offset != MAX_OFFSET) {
	    p1 = p_model->model.expression;
	    while (*expression != NULL) {
	      p1->offset += min_p - max_p;
	      p1 = p1->pointer;
	    }
	  }
	}
	p_model = p_model->pointer;
      }
    }
    fpa += min_p - max_p;
    return;
  }
  while (*ips_list != NULL) {
    dispose_ips_element(&(*ips_list)->ips_element);
    q = (*ips_list)->pointer;
    Free(*ips_list);
    *ips_list = q;
  }
  while (*expression != NULL) {
    p1 = (*expression)->pointer;
    Free(*expression);
    *expression = p1;
  }
}  /* dispose_em_expression_and_ips_list */


Static Void dispose_model(model)
t_model *model;
{
  dispose_set_list(&model->sets_h_g_c);
  if (em)
    dispose_em_expression_and_ips_list(&model->expression, &model->ips_list);
  else {
    dispose_expression(&model->expression);
    dispose_ips_list(&model->ips_list);
    dispose_radim_list(&model->radim_list);
  }
  /*$ifdef TRACE*/
  if (!boolean_option[29])
    return;
  /*$endif TRACE*/
  write_pch(stdout, " DisposeModel:", 14L);
  write_integer(stdout, fpa, 6L);
  write_line(stdout);
}  /* dispose_model */


Static Void dispose_all_models()
{
  t_model_list *link_model;

  while (link_model_list != NULL) {
    link_model = link_model_list;
    link_model_list = link_model_list->pointer;
    dispose_model(&link_model->model);
    Free(link_model);
  }
  link_base = NULL;
  link_current = NULL;
  link_model_list = NULL;
}  /* dispose_all_models */


Static Void dispose_ps()
{
  t_model_list *p_model;
  t_list_ips_elements *ips_list;

  p_model = link_model_list;
  while (p_model != NULL) {
    p_model->model.found_ps = false;
    if (p_model->model.ips_list != NULL) {
      if (p_model->model.ips_list->ips_element.p_offset != MAX_OFFSET) {
	ips_list = p_model->model.ips_list;
	while (ips_list != NULL) {
	  ips_list->ips_element.p_offset = MAX_OFFSET;
	  ips_list = ips_list->pointer;
	}
      }
    }
    p_model = p_model->pointer;
  }
  fpa = P_START - FIRST_INDEX;
}  /* dispose_ps */


Static Void dispose_part_list(link_part_list)
t_part_list **link_part_list;
{
  t_part_list *p;

  while (*link_part_list != NULL) {
    p = *link_part_list;
    *link_part_list = (*link_part_list)->pointer;
    Free(p);
  }
}  /* dispose_part_list */


Static Void dispose_sort_list(link_sort_list)
t_sort_list **link_sort_list;
{
  t_sort_list *p;

  while (*link_sort_list != NULL) {
    p = *link_sort_list;
    *link_sort_list = (*link_sort_list)->pointer;
    dispose_part_list(&p->link_sepa_list);
    dispose_part_list(&p->link_part_list);
    Free(p);
  }
}  /* dispose_sort_list */


Static Void dispose_test_list(link_test_list)
t_test_list **link_test_list;
{
  t_test_list *q;

  while (*link_test_list != NULL) {
    q = *link_test_list;
    *link_test_list = (*link_test_list)->pointer;
    dispose_set_list(&q->test.g_c_1);
    dispose_set_list(&q->test.g_c_2);
    Free(q);
  }
}  /* dispose_test_list */


Static Void dispose_2_3_tree(a)
t_2_3_node **a;
{
  if (*a != NULL) {
    if ((*a)->node_type == interior) {
      dispose_2_3_tree(&(*a)->UU.U1.firstchild);
      dispose_2_3_tree(&(*a)->UU.U1.secondchild);
      dispose_2_3_tree(&(*a)->UU.U1.thirdchild);
    } else {
      if ((*a)->UU.leaf_->tree_type == test_tree)
	dispose_part_list(&(*a)->UU.leaf_->UU.test_list);
      else
	dispose_offset_list(&(*a)->UU.leaf_->UU.offset_list);
      Free((*a)->UU.leaf_);
    }
    Free(*a);
  }
  *a = NULL;
}  /* dispose_2_3_tree */


Static Void dispose_tests()
{
  dispose_2_3_tree(&test_2_3_tree);
  dispose_test_list(&link_test_list);
}  /* dispose_tests */


Static Void dispose_offsets()
{
  dispose_2_3_tree(&offset_2_3_tree);
  dispose_offset_list(&link_offset_list);
}  /* dispose_offsets */


/*@+"out.p"*/


Static long long_name_set_width(a)
long *a;
{
  t_vertex_name_list *p_name_list;
  t_integer i;

  i = 0;
  p_name_list = name_list;
  while (p_name_list != NULL) {
    if (P_inset(p_name_list->vertex, a))
      i += p_name_list->length + 1;
    p_name_list = p_name_list->pointer;
  }
  return i;
}  /* long_name_set_width */


Static Void print_vertex_on_report(f, v)
FILE *f;
t_vertex v;
{
  t_vertex_name_list *p_name_list;

  if (!long_names) {
    write_char_text(f, vertex_inf[v - MIN_VERTEX].name);
    return;
  }
  p_name_list = name_list;
  if (p_name_list != NULL && p_name_list->vertex != v) {
    while (p_name_list->pointer != NULL && p_name_list->vertex != v)
      p_name_list = p_name_list->pointer;
  }
  write_char_text(f, ':');
  if (p_name_list->vertex == v)
    write_pch_text(f, p_name_list->name, p_name_list->length);
  else
    write_pch_10_text(f, " Invalid", 8L);
}  /* print_vertex_on_report */


Static Void print_vertex_on_file(f, v)
FILE *f;
t_vertex v;
{
  t_vertex_name_list *p_name_list;

  if (!long_names) {
    write_char(f, vertex_inf[v - MIN_VERTEX].name);
    return;
  }
  p_name_list = name_list;
  if (p_name_list != NULL && p_name_list->vertex != v) {
    while (p_name_list->pointer != NULL && p_name_list->vertex != v)
      p_name_list = p_name_list->pointer;
  }
  if (p_name_list->vertex == v) {
    write_char(f, ':');
    write_pch(f, p_name_list->name, p_name_list->length);
  } else
    write_pch(f, "<Invalid>", 9L);
}  /* print_vertex_on_file */


Static Void print_full_vertex_on_file(f, v)
FILE *f;
t_vertex v;
{
  t_vertex_name_list *p_name_list;

  if (!long_names) {
    write_char(f, full_vertex_inf[v - MIN_VERTEX].name);
    return;
  }
  p_name_list = full_name_list;
  if (p_name_list != NULL && p_name_list->vertex != v) {
    while (p_name_list->pointer != NULL && p_name_list->vertex != v)
      p_name_list = p_name_list->pointer;
  }
  write_char(f, ':');
  if (p_name_list->vertex == v) {
    write_char(f, ':');
    write_pch(f, p_name_list->name, p_name_list->length);
  } else
    write_pch(f, "<Invalid>", 9L);
}  /* print_full_vertex_on_file */


Static Void print_vertex(v)
t_vertex v;
{
  print_vertex_on_file(stdout, v);
}  /* print_vertex */


Static Void print_edge(f, short_test_output, write_models, v, w)
FILE *f;
boolean short_test_output, write_models;
t_vertex v, w;
{
  if (short_test_output) {
    if (write_models)
      write_space(f, 3L);
    write_char(f, '[');
    print_vertex_on_file(f, v);
    print_vertex_on_file(f, w);
    write_char(f, ']');
    return;
  }
  write_pch(f, " Edge: [", 8L);
  print_vertex_on_file(f, v);
  print_vertex_on_file(f, w);
  write_char(f, ']');
  write_line(f);
}  /* print_edge */


Local Void switch_var(val, hit, c, w)
boolean *val;
long *hit;
Char *c;
long w;
{
  if (*hit == 2) {
    if (*val)
      *hit = 1;
    else
      *hit = 0;
    return;
  }
  switch (*hit) {

  case -1:
    *val = false;
    break;

  case 0:
    *val = !*val;
    break;

  case 1:
    *val = true;
    break;
  }
  write_pch(stdout, c, w);
  write_pch(stdout, " set", 4L);
  if (*val)
    write_pch(stdout, " ON  TRUE ", 3L);
  else
    write_pch(stdout, " OFF FALSE", 4L);
}  /* switch_var */


Static Void switch_new(number, hit)
long *number, *hit;
{
  if (*number < 40) {
    switch (*number) {

    case 1:
      switch_var(&c_partitioning, hit, " Partitioning", 13L);
      break;

    case 2:
      switch_var(&terminal, hit, " Keyboard", 9L);
      break;

    case 3:
      switch_var(&echo, hit, " Echo", 5L);
      break;

    case 4:
      switch_var(&diary, hit, " Diary", 6L);
      break;

    case 5:
      switch_var(&timer, hit, " Timer", 6L);
      break;

    case 6:
      switch_var(&graph_mode, hit, " Graph mode", 11L);
      break;

    case 7:
      switch_var(&decomposable_mode, hit, " Decomposable mode", 18L);
      break;

    case 8:
      switch_var(&large, hit, " Large", 6L);
      break;

    case 9:
      switch_var(&short_test_output, hit, " Short test output", 18L);
      break;

    case 10:
      switch_var(&report, hit, " Report", 7L);
      break;

    case 11:
      switch_var(&re_use_test, hit, " Reuse tests", 12L);
      break;

    case 12:
      switch_var(&adj_df, hit, " Adjusted df", 12L);
      break;

    case 13:
      switch_var(&trace, hit, " Trace", 6L);
      break;

    case 14:
      switch_var(&exact_test, hit, " Exact test", 11L);
      break;

    case 15:
      switch_var(&exact_log_l, hit, " Only Exact Deviance", 20L);
      break;

    case 16:
      switch_var(&fast, hit, " Fast", 5L);
      break;

    case 17:
      switch_var(&exact_test_for_sum_up, hit, " Exact test total", 17L);
      break;

    case 18:
      switch_var(&exact_test_for_partitioning, hit, " Exact test parts",
		 17L);
      break;

    case 19:
      switch_var(&exact_test_for_test_models, hit, " Exact test unparted",
		 20L);
      break;

    case 20:
      switch_var(&link_eh_pack->graphical_search, hit, " Graphical search",
		 17L);
      break;

    case 21:
      switch_var(&echo_note, hit, " Note", 5L);
      break;

    case 22:
      switch_var(&debug, hit, " Debug", 6L);
      break;

    case 23:
      switch_var(&dummy_option, hit, " Option", 7L);
      break;

    case 24:
      switch_var(&log_on, hit, " Log", 4L);
      break;

    case 25:
      switch_var(&dump, hit, " Dump", 5L);
      break;

    case 26:
      switch_var(&sorted, hit, " Sorted", 7L);
      break;

    case 27:
      switch_var(&diary_set, hit, " Keep Diary", 11L);
      break;

    case 28:
      switch_var(&report_set, hit, " Keep Report", 12L);
      break;

    case 29:
      switch_var(&log_set, hit, " Keep Log", 9L);
      break;

    case 30:
      switch_var(&log_data_on, hit, " Log Data", 9L);
      break;

    case 31:
      switch_var(&dump_set, hit, " Keep Dump", 10L);
      break;

    case 32:
      switch_var(&pause_output, hit, " Pausing of output", 18L);
      break;

    case 33:
      switch_var(&permit_log_l, hit, " Huge", 5L);
      break;

    case 34:
      switch_var(&ic, hit, " IC", 3L);
      break;

    case 35:
      switch_var(&bic, hit, " BIC", 4L);
      break;

    case 36:
      switch_var(&em, hit, " EM", 3L);
      break;

    case 37:
      switch_var(&note_warnings, hit, " Warnings", 9L);
      break;

    case 38:
      switch_var(&permit_condensed, hit, " Permit condensed", 17L);
      break;

    case 39:
      switch_var(&decompose_incomplete, hit, " Decompose incomplet", 20L);
      break;
    }
    /*$ifdef TRACE*/
    return;
  }
  if (99 < *number && *number < 132) {
    /*$endif TRACE*/
    switch_var(&boolean_option[*number - 100], hit, " Debugging option",
	       17L);
  } else {
    write_pch(stdout, " Invalid switch: ", 17L);
    write_integer(stdout, *number, 3L);
  }
}  /* switch_new */


Static Void switch_(number, hit)
long number, hit;
{
  switch_new(&number, &hit);
}  /* switch */


Static Void print_table_type(table_type, log_trans)
long table_type;
boolean log_trans;
{
  if (log_trans)
    write_pch(stdout, "Log(", 4L);
  if (table_type < MAX_NUMBER_OF_TABLE_VALUES * 2 - 2)
    table_type &= MAX_NUMBER_OF_TABLE_VALUES - 1;
  switch (table_type) {

  case 0:
    write_pch(stdout, "Observed", 8L);
    break;

  case 1:
    write_pch(stdout, "Probabilities", 13L);
    break;

  case 2:
    write_pch(stdout, "Expected", 8L);
    break;

  case 3:
    write_pch(stdout, "Residuals: Abs", 14L);
    break;

  case 4:
    write_pch(stdout, "Residuals: F-res", 16L);
    break;

  case 5:
    write_pch(stdout, "Residuals: Res-F", 16L);
    break;

  case 6:
    write_pch(stdout, "Residuals: G-res", 16L);
    break;

  case 7:
    write_pch(stdout, "Residuals: Res-G", 16L);
    break;

  case 8:
    write_pch(stdout, "Adjusted", 8L);
    break;

  case 9:
    write_pch(stdout, "Standardized", 12L);
    break;

  case 10:
    write_pch(stdout, "Residuals: L-res", 16L);
    break;

  case 11:
    write_pch(stdout, "Freeman-Tukey dev. ", 19L);
    break;

  case 12:
    write_pch(stdout, "2(/n-/m)", 8L);
    break;

  case 13:
    write_pch(stdout, "Power-divergence ", 17L);
    break;

  case 14:
    write_pch(stdout, "Table index", 11L);
    break;

  case 15:
    write_pch(stdout, "Structural Zero", 15L);
    break;

  case 16:
    write_pch(stdout, "Leverage", 8L);
    break;

  case 63:
    write_pch(stdout, "Obs. for Struct.Zero", 20L);
    break;

  case 101:
    write_pch(stdout, "Uniform", 7L);
    break;

  case 102:
    write_pch(stdout, "Rankit", 6L);
    break;

  case 103:
    write_pch(stdout, "Normal", 6L);
    break;

  case 104:
    write_pch(stdout, "Base", 4L);
    break;

  case 105:
    write_pch(stdout, "Current", 7L);
    break;

  case 106:
    write_pch(stdout, "Complete", 8L);
    break;

  case 107:
    write_pch(stdout, "Log", 3L);
    break;
  }
  if (log_trans)
    write_char(stdout, ')');
}  /* print_table_type */


Static boolean current()
{
  if (link_current == NULL) {
    write_pch(stdout, " No CURRENT model", 17L);
    return false;
  } else
    return true;
}  /* current */


Static boolean base()
{
  if (link_base == NULL) {
    write_pch(stdout, " No BASE model", 14L);
    return false;
  } else
    return true;
}  /* base */


Static boolean current_and_base()
{
  boolean Result;

  Result = current();
  if (link_base != NULL)
    return Result;
  if (link_current == NULL)
    write_line(stdout);
  write_pch(stdout, " No BASE model", 14L);
  return false;
/* p2c: coco_d_p2c.p: Note: Deleting unreachable code [255] */
}  /* current_and_base */


Static boolean current_ifail(ifail)
long *ifail;
{
  if (link_current == NULL) {
    /* write_pch(output, ' No CURRENT model@@@', 17); */
    *ifail = 22;
    return false;
  } else
    return true;
}  /* current_ifail */


Static boolean base_ifail(ifail)
long *ifail;
{
  if (link_base == NULL) {
    /* write_pch(output, ' No BASE model@@@@@@', 14); */
    *ifail = 23;
    return false;
  } else
    return true;
}  /* base_ifail */


Static boolean current_and_base_ifail(ifail)
long *ifail;
{
  boolean Result;

  Result = current_ifail(ifail);
  if (link_base == NULL) {
    /* if link_current = nil then
       write_line(output);
    write_pch(output, ' No BASE model@@@@@@', 14); */
    *ifail = 23;
    return false;
  }
  return Result;
}  /* current_and_base_ifail */


Static Void print_vertex_set_on_report(f, a)
FILE *f;
long *a;
{
  t_vertex v, FORLIM;

  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    if (P_inset(v, a))
      print_vertex_on_report(f, v);
  }
  write_char_text(f, '.');
}  /* print_vertex_set_on_report */


Static Void print_vertex_set_x_on_report(f, a)
FILE *f;
long *a;
{
  t_vertex v, FORLIM;

  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    if (P_inset(v, a))
      print_vertex_on_report(f, v);
  }
}  /* print_vertex_set_x_on_report */


Local Void print_vertex_set_x(f, a)
FILE *f;
long *a;
{
  t_vertex v, FORLIM;

  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    if (P_inset(v, a))
      print_vertex_on_report(f, v);
  }
}  /* print_vertex_set_x */


Static Void print_set_list_on_report(f, p)
FILE *f;
t_set_list *p;
{
  t_integer line_count, set_width;

  line_count = 20;
  while (p != NULL) {
    if (long_names) {
      set_width = long_name_set_width(p->vertex_set);
      if (line_count + set_width > line_length &&
	  line_length < MAX_LINE_LENGTH) {
	write_line_text(f);
	line_count = 0;
      }
      line_count += set_width;
    }
    print_vertex_set_x(f, p->vertex_set);
    p = p->pointer;
    if (p != NULL)
      write_char_text(f, ',');
  }
  write_char_text(f, '.');
}  /* print_set_list_on_report */


Static Void print_vertex_set(a)
long *a;
{
  t_vertex v, FORLIM;

  write_char(stdout, '[');
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    if (P_inset(v, a))
      print_vertex(v);
  }
  write_char(stdout, ']');
}  /* print_vertex_set */


Static Void print_vertex_set_table(a)
long *a;
{
  t_vertex v, FORLIM;
  t_long_integer x, y;

  x = 0;
  write_char(stdout, '[');
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    if (P_inset(v, a))
      print_vertex(v);
    else
      x++;
  }
  write_char(stdout, ']');
  if (x > 12) {
    for (y = 1; y <= x % 10; y++)
      write_char(stdout, ' ');
  } else {
    for (y = 1; y <= x; y++)
      write_char(stdout, ' ');
  }
}  /* print_vertex_set_table */


Static Void print_vertex_set_table_full(a)
long *a;
{
  t_vertex v, FORLIM;
  t_long_integer x, y;

  x = 0;
  write_char(stdout, '[');
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    if (P_inset(v, a))
      print_vertex(v);
    else
      x++;
  }
  write_char(stdout, ']');
  for (y = 1; y <= x; y++)
    write_char(stdout, ' ');
}  /* print_vertex_set_table_full */


Static Void print_g_c_from_stop(p, from, start, line_length, stop)
t_set_list *p;
long from, start, line_length, *stop;
{
  t_integer set_width;

  write_char(stdout, '[');
  *stop = from;
  while (p != NULL) {
    if (long_names)
      set_width = long_name_set_width(p->vertex_set) + 2;
    else
      set_width = cardinality(p->vertex_set) + 2;
    if (*stop != start && *stop + set_width > line_length &&
	line_length < MAX_LINE_LENGTH) {
      write_line(stdout);
      if (long_names && start > 10)
	write_space(stdout, 10L);
      else
	write_space(stdout, start);
      *stop = start;
    }
    print_vertex_set(p->vertex_set);
    *stop += set_width;
    p = p->pointer;
  }
  write_char(stdout, ']');
}  /* print_g_c_from_stop */


Static Void print_g_c_from(p, from, start, line_length)
t_set_list *p;
long from, start, line_length;
{
  t_long_integer stop;

  print_g_c_from_stop(p, from, start, line_length, &stop);
}  /* print_g_c_from */


Static Void print_g_c(p, start, line_length)
t_set_list *p;
long start, line_length;
{
  t_long_integer stop;

  print_g_c_from_stop(p, start, start, line_length, &stop);
}  /* print_g_c */


Static Void print_g_c_stop(p, start, line_length, stop)
t_set_list *p;
long start, line_length, *stop;
{
  print_g_c_from_stop(p, start, start, line_length, stop);
}  /* print_g_c_stop */


Static Void print_g_c_list(a)
t_g_c_list *a;
{
  write_line(stdout);
  while (a != NULL) {
    write_space(stdout, 5L);
    print_g_c_from(a->g_c, 5L, 6L, line_length);
    write_line(stdout);
    a = a->pointer;
  }
  write_line(stdout);
}  /* print_g_c_list */


Static Void print_vertex_list(p)
t_vertex_list *p;
{
  write_char(stdout, '[');
  while (p != NULL) {
    print_vertex(p->vertex);
    p = p->pointer;
  }
  write_char(stdout, ']');
}  /* print_vertex_list */


Static Void print_edge_list(p, start, line_length)
t_edge_list *p;
long start, line_length;
{
  t_long_integer stop;

  stop = start;
  while (p != NULL) {
    if (stop + 4 > line_length && stop != start &&
	line_length < MAX_LINE_LENGTH) {
      write_line(stdout);
      write_space(stdout, start);
      stop = start;
    }
    write_char(stdout, '[');
    print_vertex(p->v);
    print_vertex(p->w);
    write_char(stdout, ']');
    stop += 4;
    p = p->pointer;
  }
}  /* print_edge_list */


/*@+"insert.p"*/


Static boolean space_in_n_array(increment, current)
long increment, current;
{
  boolean ok;

  ok = true;
  if (increment > max_cell_number - current &&
      increment < MAX_CELL_NUMBER_MAX - current)
    ok = resize_n(&n, current + increment, &max_cell_number);
  return ok;
}  /* space_in_n_array */


Static boolean space_in_p_array(increment, current)
long increment, current;
{
  boolean ok;

  ok = true;
  if (increment > max_p_cell_number - current &&
      increment < MAX_P_CELL_NUMBER_MAX - current)
    ok = resize_p(&p, current + increment, &max_p_cell_number);
  return ok;
}  /* space_in_p_array */


Static boolean space_in_q_array(increment, current)
long increment, current;
{
  boolean ok;

  ok = true;
  if (increment > max_q_cell_number - current &&
      increment < MAX_Q_CELL_NUMBER_MAX - current)
    ok = resize_q(&q_array, current + increment, &max_q_cell_number);
  return ok;
}  /* space_in_q_array */


Static Void insert_real_in_real_list(x, real_list)
double x;
t_real_list **real_list;
{
  t_real_list *p;

  p = (t_real_list *)Malloc(sizeof(t_real_list));
  if (p == NULL)
    _OutMem();
  p->x = x;
  p->pointer = *real_list;
  *real_list = p;
}  /* insert_real_in_real_list */


Static Void insert_integer_in_integer_list(i, integer_list)
long i;
t_integer_list **integer_list;
{
  t_integer_list *p;

  p = (t_integer_list *)Malloc(sizeof(t_integer_list));
  if (p == NULL)
    _OutMem();
  p->x = i;
  p->pointer = *integer_list;
  *integer_list = p;
}  /* insert_integer_in_integer_list */


Static Void insert_vertex_in_vertex_list(v, vertex_list)
t_vertex v;
t_vertex_list **vertex_list;
{
  t_vertex_list *p;

  p = (t_vertex_list *)Malloc(sizeof(t_vertex_list));
  if (p == NULL)
    _OutMem();
  p->vertex = v;
  p->pointer = *vertex_list;
  *vertex_list = p;
}  /* insert_vertex_in_vertex_list */


Static Void insert_set_in_set_list(a, set_list)
long *a;
t_set_list **set_list;
{
  t_set_list *p;

  p = (t_set_list *)Malloc(sizeof(t_set_list));
  if (p == NULL)
    _OutMem();
  P_setcpy(p->vertex_set, a);
  p->pointer = *set_list;
  *set_list = p;
}  /* insert_set_in_set_list */


Static Void insert_g_c_in_g_c_list(g_c, g_c_list)
t_set_list *g_c;
t_g_c_list **g_c_list;
{
  t_g_c_list *p;

  p = (t_g_c_list *)Malloc(sizeof(t_g_c_list));
  if (p == NULL)
    _OutMem();
  p->g_c = g_c;
  p->pointer = *g_c_list;
  *g_c_list = p;
}  /* insert_g_c_in_g_c_list */


Static Void insert_edge_in_edge_list(v, w, edge_list)
t_vertex v, w;
t_edge_list **edge_list;
{
  t_edge_list *p;

  p = (t_edge_list *)Malloc(sizeof(t_edge_list));
  if (p == NULL)
    _OutMem();
  p->v = v;
  p->w = w;
  p->pointer = *edge_list;
  *edge_list = p;
}  /* insert_edge_in_edge_list */


Static Void erase_model(model)
t_model *model;
{
  model->sets_h_g_c = NULL;
  model->graphical = false;
  model->decomposable = false;
  P_setcpy(model->model_set, empty_set);
  model->expression = NULL;
  model->ips_list = NULL;
  model->radim_list = NULL;
  model->constant = 1.0;
  model->dim = 0;
  model->log_l = _INVALID_REAL;
  model->model_number = -1;
  model->found_expression = false;
  model->found_log_l = false;
  model->found_ps = false;
}  /* erase_model */


Static Void new_model(link_model_list, model_number)
t_model_list **link_model_list;
long *model_number;
{
  t_model_list *p;

  p = (t_model_list *)Malloc(sizeof(t_model_list));
  if (p == NULL)
    _OutMem();
  p->pointer = *link_model_list;
  *link_model_list = p;
  (*model_number)++;
  erase_model(&(*link_model_list)->model);
  (*link_model_list)->model.model_number = *model_number;
}  /* new_model */


Static Void add_union_of_gc(p_g_c, model_set)
t_set_list *p_g_c;
long *model_set;
{
  while (p_g_c != NULL) {
    P_setunion(model_set, model_set, p_g_c->vertex_set);
    p_g_c = p_g_c->pointer;
  }
}  /* add_union_of_gc */


Static Void insert_set_list_in_new_model(g_c)
t_set_list **g_c;
{
  new_model(&link_model_list, &first_model_available);
  P_setcpy(link_model_list->model.model_set, empty_set);
  add_union_of_gc(*g_c, link_model_list->model.model_set);
  link_model_list->model.sets_h_g_c = *g_c;
}  /* insert_set_list_in_new_model */


Static Void dispose_case_list(p)
t_case_list **p;
{
  t_case_list *q;

  while (*p != NULL) {
    q = (*p)->pointer;
    Free(*p);
    *p = q;
  }
}  /* dispose_case_list */


Static Void make_case_list()
{
  t_cell i;
  t_vertex v;
  t_case_list *p_case_list;
  t_vertex FORLIM;

  dispose_case_list(&case_list_read);
  reset_level_file(file_read);
  while (!eof_level_file(file_read)) {
    FORLIM = last_vertex;
    for (v = first_vertex; v <= FORLIM; v++)
      read_level_file(file_read, &i[v - MIN_VERTEX]);
    p_case_list = (t_case_list *)Malloc(sizeof(t_case_list));
    if (p_case_list == NULL)
      _OutMem();
    p_case_list->pointer = case_list_read;
    memcpy(p_case_list->cell, i, sizeof(t_cell));
    case_list_read = p_case_list;
  }
  case_list = case_list_read;
}  /* make_case_list */


Static Void insert_factor_in_expression(a, factor, expression)
long *a;
long *factor;
t_expression **expression;
{
  t_expression *p;

  p = (t_expression *)Malloc(sizeof(t_expression));
  if (p == NULL)
    _OutMem();
  P_setcpy(p->vertex_set, a);
  p->factor = *factor;
  p->pointer = *expression;
  *expression = p;
}  /* insert_factor_in_expression */


Static Void put_factor(link_expression, a, factor)
t_expression **link_expression;
long *a;
long factor;
{
  t_expression *p, *q, *r;
  boolean b;
  t_long_integer card_a;

  card_a = cardinality(a);
  if (*link_expression == NULL) {
    insert_factor_in_expression(a, &factor, link_expression);
    (*link_expression)->card = card_a;
    return;
  }
  if (card_a < (*link_expression)->card) {
    insert_factor_in_expression(a, &factor, link_expression);
    (*link_expression)->card = card_a;
    return;
  }
  b = true;
  p = *link_expression;
  q = p;
  while (p != NULL && b) {
    if (P_setequal(a, p->vertex_set) || card_a < p->card)
      b = false;
    else {
      q = p;
      p = p->pointer;
    }
  }
  if (b) {
    insert_factor_in_expression(a, &factor, &p);
    p->card = card_a;
    q->pointer = p;
    return;
  }
  if (P_setequal(a, p->vertex_set)) {
    p->factor += factor;
    if (p->factor != 0)
      return;
    if (q == p) {
      *link_expression = p->pointer;
      Free(p);
    } else {
      q->pointer = p->pointer;
      Free(p);
    }
    return;
  }
  r = NULL;
  insert_factor_in_expression(a, &factor, &r);
  r->card = card_a;
  if (p == q)
    r->pointer = NULL;
  else
    r->pointer = p;
  q->pointer = r;
}  /* put_factor */


#define max_par         65536L


Local long local_offset_hash(a)
long *a;
{
  t_long_integer sum, product;
  t_vertex v, FORLIM;

  sum = 1;
  product = 1;
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    if (P_inset(v, a))
      sum = (sum + product) & (max_par - 1);
    product *= 2;
    if (product >= max_par)
      product = 1;
  }
  return sum;
}  /* local_offset_hash */


Static long return_paritet(g_c_1, g_c_2)
t_set_list *g_c_1, *g_c_2;
{
  t_long_integer sum;

  sum = 0;
  while (g_c_1 != NULL) {
    sum = (sum + local_offset_hash(g_c_1->vertex_set)) & (max_par - 1);
    g_c_1 = g_c_1->pointer;
  }
  while (g_c_2 != NULL) {
    sum = (sum + local_offset_hash(g_c_2->vertex_set)) & (max_par - 1);
    g_c_2 = g_c_2->pointer;
  }
  return sum;
}  /* return_paritet */

#undef max_par


Static Void clear_test(test)
t_test *test;
{
  test->g_c_1 = NULL;
  test->g_c_2 = NULL;
  test->x_deviance = _INVALID_REAL;
  test->x_pearson = _INVALID_REAL;
  test->x_power = _INVALID_REAL;
  test->gamma = _INVALID_REAL;
  test->s = _INVALID_REAL;
  test->s1 = _INVALID_REAL;
  test->mcep_deviance = -1.0;
  test->mcep_pearson = -1.0;
  test->mcep_power = -1.0;
  test->mcep_gamma_1 = -1.0;
  test->mcep_gamma_2 = -1.0;
  test->number_of_tables = -1;
  test->paritet = -1;
  test->df = INFINITY;
  test->df_real = INFINITY;
  test->adj = INFINITY;
  test->n_count = -1;
  test->ok = false;
}  /* clear_test */


Static Void new_test(link_test)
t_test_list **link_test;
{
  *link_test = (t_test_list *)Malloc(sizeof(t_test_list));
  if (*link_test == NULL)
    _OutMem();
  (*link_test)->pointer = NULL;
  clear_test(&(*link_test)->test);
}  /* new_test */


/*@+"readv.p"*/


Static Void list_of_vertices_to_set(p, a)
t_vertex_list *p;
long *a;
{

  P_setcpy(a, empty_set);
  while (p != NULL) {
    P_addset(a, p->vertex);
    p = p->pointer;
  }
}  /* list_of_vertices_to_set */


Static Void note_invalid_vertex_name(c)
Char *c;
{
  if ((P_inset(*c, begin_set) | P_inset(*c, end_mark)) || *c == '*' ||
      *c == '&' || *c == ' ' || *c == '\t' || *c == '\n')
    return;
  write_pch(stdout, " Invalid factor name: `", 23L);
  write_char(stdout, *c);
  write_char(stdout, '\'');
  write_line(stdout);
}  /* note_invalid_vertex_name */


Static Void skip_one_end_mark(input_file, command_, keyboard, full, c)
FILE *input_file;
boolean command_, keyboard, full;
Char *c;
{
  *c = '&';
  while (!(((P_inset(*c, begin_set) | P_inset(*c, end_mark)) || *c == ':' ||
	    *c == '*') | ((!full) & P_inset(*c, names)) |
	   (full & P_inset(*c, full_names)))) {
    if (eof_command(input_file)) {
      *c = ']';
      continue;
    }
    if (eoln_command(input_file)) {
      if (*c == '&')
	read_line_end(input_file, command_, keyboard);
      else
	*c = ';';
    } else {
      read_character(input_file, command_, keyboard, c);
      if (!(((!full) & P_inset(*c, names)) | (full & P_inset(*c, full_names))))
	note_invalid_vertex_name(c);
    }
  }
}  /* skip_one_end_mark */


Static boolean vertex_name_to_vertex(vertex_name, full, v)
Char *vertex_name;
boolean *full;
t_vertex *v;
{
  *v = MIN_VERTEX;
  if (*full) {
    if (P_inset(*vertex_name, full_names)) {
      *v = full_name_to_vertex[*vertex_name - MIN_NAME];
      return true;
    } else {
      note_invalid_vertex_name(vertex_name);
      return false;
    }
  } else if (P_inset(*vertex_name, names)) {
    *v = name_to_vertex[*vertex_name - MIN_NAME];
    return true;
  } else {
    note_invalid_vertex_name(vertex_name);
    return false;
  }
}  /* vertex_name_to_vertex */


Static Void read_long_vertex_name(input_file, command_, keyboard, vertex_name,
				  length, c)
FILE *input_file;
boolean *command_, *keyboard;
Char *vertex_name;
long *length;
Char *c;
{
  while ((*c == ' ' || *c == '\t' || *c == '\n' || *c == ':' || *c == '&') |
	 P_inset(*c, begin_set))
    seek_non_blank(input_file, *command_, *keyboard, "1234567890", 0L, c);
  *length = 0;
  while (!((*c == ' ' || *c == '\t' || *c == '\n' || *c == ':' || *c == '*') |
	   P_inset(*c, end_mark) | eolnorf_command(input_file))) {
    (*length)++;
    vertex_name[*length - PCH_START] = *c;
    read_character(input_file, *command_, *keyboard, c);
  }
  if ((!((*c == ' ' || *c == '\t' || *c == '\n' || *c == ':' || *c == '*') |
	 P_inset(*c, end_mark))) & eolnorf_command(input_file)) {
    (*length)++;
    vertex_name[*length - PCH_START] = *c;
    *c = ' ';
  }
  /*$ifdef TRACE*/
  if (!boolean_option[23])
    return;
  /*$endif TRACE*/
  write_pch(stdout, " READ_LONG_VERTEX_NAME: ", 24L);
  write_pch(stdout, vertex_name, *length);
  write_char(stdout, '/');
  write_char(stdout, *c);
  write_char(stdout, '/');
  write_line(stdout);
}  /* read_long_vertex_name */


Static boolean long_vertex_name_to_vertex(vertex_name, length, full, v)
Char *vertex_name;
long *length;
boolean *full;
t_vertex *v;
{
  t_vertex_name_list *p_name_list;
  t_integer i, count;
  boolean match_length;

  /*$ifdef TRACE*/
  if (boolean_option[23]) {
    write_pch(stdout, " LONG_VERTEX_NAME_TO_VERTEX: ", 29L);
    write_pch(stdout, vertex_name, *length);
    write_integer(stdout, *length, 3L);
    write_line(stdout);
  }
  /*$endif TRACE*/
  *v = MIN_VERTEX;
  match_length = false;
  count = 0;
  if (*length <= 0)
    return (count == 1 || match_length);
  if (*full)
    p_name_list = full_name_list;
  else
    p_name_list = name_list;
  while (p_name_list != NULL && !match_length) {
    i = 1;
    while (vertex_name[i - PCH_START] == p_name_list->name[i - PCH_START] &&
	   i < p_name_list->length && i < *length)
      i++;
    if (vertex_name[i - PCH_START] == p_name_list->name[i - PCH_START] &&
	i == *length) {
      count++;
      *v = p_name_list->vertex;
      if (i == p_name_list->length && i == *length)
	match_length = true;
    }
    p_name_list = p_name_list->pointer;
  }
  if (count == 0) {
    write_pch(stdout, " Invalid factor name: `", 23L);
    write_pch(stdout, vertex_name, *length);
    write_char(stdout, '\'');
    write_line(stdout);
    return (count == 1 || match_length);
  }
  if (count <= 1 || match_length)
    return (count == 1 || match_length);
  write_pch(stdout, " Not unique factor name: `", 26L);
  write_pch(stdout, vertex_name, *length);
  write_char(stdout, '\'');
  write_char(stdout, ':');
  write_integer(stdout, count, 3L);
  write_pch(stdout, " matching factors", 17L);
  write_line(stdout);
  return (count == 1 || match_length);
}  /* long_vertex_name_to_vertex */


Static Void read_sep_vertex(input_file, command_, keyboard, full, v, ok, c)
FILE *input_file;
boolean *command_, *keyboard, *full;
t_vertex *v;
boolean *ok;
Char *c;
{
  pch_long vertex_name;
  t_integer length;

  *ok = false;
  if (!long_names)
    *ok = vertex_name_to_vertex(c, full, v);
  else if (!((*c == ' ' || *c == '\t' || *c == '\n') & eoln_command(input_file))) {
    read_long_vertex_name(input_file, command_, keyboard, vertex_name,
			  &length, c);
    if (*c != '*' && *c != '.' || length != 0)
      *ok = long_vertex_name_to_vertex(vertex_name, &length, full, v);
  }
  while (!(((*ok) | P_inset(*c, end_mark)) || *c == '*' || *c == '@')) {
    /*$ifdef TRACE*/
    if (boolean_option[23]) {
      write_char(stdout, ':');
      write_char(stdout, *c);
      write_char(stdout, ':');
      write_line(stdout);
    }
    /*$endif TRACE*/
    if (eof_command(input_file)) {
      *c = '@';
      continue;
    }
    if (eoln_command(input_file)) {
      if (*c == '&')
	read_line_end(input_file, *command_, *keyboard);
      else
	*c = ';';
      continue;
    }
    if (!long_names) {
      read_character(input_file, *command_, *keyboard, c);
      *ok = vertex_name_to_vertex(c, full, v);
    } else {
      read_long_vertex_name(input_file, command_, keyboard, vertex_name,
			    &length, c);
      if (*c != '*' && *c != '.' || length != 0)
	*ok = long_vertex_name_to_vertex(vertex_name, &length, full, v);
    }
  }
}  /* read_sep_vertex */


Static Void read_vertex(input_file, arg_command, arg_keyboard, arg_full, v)
FILE *input_file;
boolean arg_command, arg_keyboard, arg_full;
t_vertex *v;
{
  boolean command_, keyboard, full, ok;
  Char c;

  c = '&';
  command_ = arg_command;
  keyboard = arg_keyboard;
  full = arg_full;
  read_sep_vertex(input_file, &command_, &keyboard, &full, v, &ok, &c);
}  /* read_vertex */


Static Void read_promb_vertex(input_file, command_, keyboard, full, promb, w,
			      v)
FILE *input_file;
boolean *command_, *keyboard, *full;
Char *promb;
long *w;
t_vertex *v;
{
  Char c;
  boolean ok;

  if (echo)
    write_pch(stdout, promb, *w);
  c = '&';
  read_sep_vertex(input_file, command_, keyboard, full, v, &ok, &c);
  /*$ifdef TRACE*/
  if (boolean_option[23]) {
    write_char(stdout, '$');
    write_char(stdout, c);
    write_char(stdout, '$');
    write_line(stdout);
  }
  /*$endif TRACE*/
  if ((ok && c != ';' && c != '/' && !(long_names && c == ' ')) &
      (!eolnorf_command(input_file)))
    read_char(input_file, &c);
  /*$ifdef TRACE*/
  if (boolean_option[23]) {
    write_char(stdout, '$');
    write_char(stdout, c);
    write_char(stdout, '$');
    write_line(stdout);
  }
  /*$endif TRACE*/
  if (echo)
    write_line(stdout);
}  /* read_promb_vertex */


Static Void read_sep_vertex_list(input_file, arg_command, arg_keyboard,
				 arg_full, p, c)
FILE *input_file;
boolean arg_command, arg_keyboard, arg_full;
t_vertex_list **p;
Char *c;
{
  t_vertex v, u;
  boolean command_, keyboard, full, ok;

  command_ = arg_command;
  keyboard = arg_keyboard;
  full = arg_full;
  *p = NULL;
  do {
    read_sep_vertex(input_file, &command_, &keyboard, &full, &v, &ok, c);
    if (*c == '*') {
      if (full)
	u = full_last_vertex;
      else
	u = last_vertex;
      for (v = first_vertex; v <= u; v++)
	insert_vertex_in_vertex_list(v, p);
      *c = '.';
    } else if (ok)
      insert_vertex_in_vertex_list(v, p);
    if (!P_inset(*c, end_mark))
      *c = ' ';
  } while (!P_inset(*c, end_mark));   /* read_sep_vertex_list */
}


Static Void read_vertex_list(input_file, command_, keyboard, full, p)
FILE *input_file;
boolean command_, keyboard, full;
t_vertex_list **p;
{
  Char c;

  c = ' ';
  read_sep_vertex_list(input_file, command_, keyboard, full, p, &c);
}  /* read_vertex_list */


Static Void read_promb_vertex_list_sep(input_file, arg_command, arg_keyboard,
				       arg_full, promb, w, c, p)
FILE *input_file;
boolean arg_command, arg_keyboard, arg_full;
Char *promb;
long *w;
Char *c;
t_vertex_list **p;
{
  boolean command_, keyboard, full;

  command_ = arg_command;
  keyboard = arg_keyboard;
  full = arg_full;
  if (echo)
    write_pch(stdout, promb, *w);
  *c = ' ';
  read_sep_vertex_list(input_file, command_, keyboard, full, p, c);
  if (((P_inset(*c, end_mark) || *c == '*') && *c != ';' && *c != '/') &
      (!eolnorf_command(input_file)))
    read_char(input_file, c);
  if (echo)
    write_line(stdout);
}  /* read_promb_vertex_list_sep */


Static Void read_promb_vertex_list(input_file, command_, keyboard, full,
				   promb_, w, p)
FILE *input_file;
boolean command_, keyboard, full;
Char *promb_;
long w;
t_vertex_list **p;
{
  pch10 promb;
  Char c;

  memcpy(promb, promb_, sizeof(pch10));
  read_promb_vertex_list_sep(input_file, command_, keyboard, full, promb, &w,
			     &c, p);
}  /* read_promb_vertex_list */


Local Void read_sep_list_of_vertex_lists(input_file, command_, keyboard, full,
					 p, c)
FILE *input_file;
boolean command_, keyboard, full;
t_list_of_vertex_lists **p;
Char *c;
{
  t_vertex v, u;
  t_list_of_vertex_lists *q;

  *p = NULL;
  do {
    q = (t_list_of_vertex_lists *)Malloc(sizeof(t_list_of_vertex_lists));
    if (q == NULL)
      _OutMem();
    q->vertex_list = NULL;
    q->pointer = *p;
    *p = q;
    read_sep_vertex_list(input_file, command_, keyboard, full,
			 &(*p)->vertex_list, c);
    if (P_inset(*c, end_set) & P_inset(*c, end_gc))
      skip_one_end_mark(input_file, command_, keyboard, full, c);
    else if (P_inset(*c, end_set))
      *c = ' ';
  } while (!P_inset(*c, end_mark));
  if (*c != '.' || (*p)->pointer != NULL || (*p)->vertex_list != NULL)
    return;
  insert_vertex_in_vertex_list(first_vertex, &(*p)->vertex_list);
  if (full)
    u = full_last_vertex;
  else
    u = last_vertex;
  for (v = first_vertex + 1; v <= u; v++) {
    q = (t_list_of_vertex_lists *)Malloc(sizeof(t_list_of_vertex_lists));
    if (q == NULL)
      _OutMem();
    q->vertex_list = NULL;
    q->pointer = *p;
    *p = q;
    insert_vertex_in_vertex_list(v, &(*p)->vertex_list);
  }
}  /* read_sep_list_of_vertex_lists */


Static Void read_list_of_vertex_lists(input_file, command_, keyboard, full, p)
FILE *input_file;
boolean command_, keyboard, full;
t_list_of_vertex_lists **p;
{
  Char c;

  c = ' ';
  read_sep_list_of_vertex_lists(input_file, command_, keyboard, full, p, &c);
  if (((P_inset(c, end_mark) || c == '*') && c != ';' && c != '/') &
      (!eolnorf_command(input_file)))
    read_character(input_file, command_, keyboard, &c);
}  /* read_list_of_vertex_lists */


Static Void read_sep_set_of_vertexes(input_file, command_, keyboard, full, a,
				     c)
FILE *input_file;
boolean command_, keyboard, full;
long *a;
Char *c;
{
  t_vertex_list *p, *q;

  read_sep_vertex_list(input_file, command_, keyboard, full, &q, c);
  P_setcpy(a, empty_set);
  p = q;
  while (q != NULL) {
    P_addset(a, q->vertex);
    q = q->pointer;
  }
  dispose_vertex_list(&p);
}  /* read_sep_set_of_vertexes */


Static Void read_set_of_vertexes(input_file, command_, keyboard, full, a)
FILE *input_file;
boolean command_, keyboard, full;
long *a;
{
  Char c;

  c = ' ';
  read_sep_set_of_vertexes(input_file, command_, keyboard, full, a, &c);
}  /* read_set_of_vertexes */


Static Void read_promb_set_of_vertexes(input_file, command_, keyboard, full,
				       promb, w, a)
FILE *input_file;
boolean *command_, *keyboard, *full;
Char *promb;
long *w;
long *a;
{
  Char c;

  if (echo)
    write_pch(stdout, promb, *w);
  c = ' ';
  read_sep_set_of_vertexes(input_file, *command_, *keyboard, *full, a, &c);
  if (((P_inset(c, end_mark) || c == '*') && c != ';' && c != '/') &
      (!eolnorf_command(input_file)))
    read_char(input_file, &c);
  if (echo)
    write_line(stdout);
}  /* read_promb_set_of_vertexes */


Static Void read_sep_set_list(input_file, command_, keyboard, full, p, c)
FILE *input_file;
boolean command_, keyboard, full;
t_set_list **p;
Char *c;
{
  t_vertex_set a;

  *p = NULL;
  do {
    read_sep_set_of_vertexes(input_file, command_, keyboard, full, a, c);
    insert_set_in_set_list(a, p);
    if (P_inset(*c, end_set) & P_inset(*c, end_gc))
      skip_one_end_mark(input_file, command_, keyboard, full, c);
    else if (P_inset(*c, end_set))
      *c = ' ';
  } while (!P_inset(*c, end_mark));   /* read_sep_set_list */
}


Static Void read_promb_set_list(input_file, command_, keyboard, full, promb,
				w, p)
FILE *input_file;
boolean *command_, *keyboard, *full;
Char *promb;
long *w;
t_set_list **p;
{
  Char c;

  if (echo)
    write_pch(stdout, promb, *w);
  c = ' ';
  read_sep_set_list(input_file, *command_, *keyboard, *full, p, &c);
  if (((P_inset(c, end_mark) || c == '*') && c != ';' && c != '/') &
      (!eolnorf_command(input_file)))
    read_char(input_file, &c);
  if (echo)
    write_line(stdout);
}  /* read_promb_set_list */


Static Void read_g_c_list(input_file, command_, keyboard, full, p)
FILE *input_file;
boolean *command_, *keyboard, *full;
t_g_c_list **p;
{
  t_set_list *set_list;
  Char c;

  c = ' ';
  *p = NULL;
  do {
    read_sep_set_list(input_file, *command_, *keyboard, *full, &set_list, &c);
    insert_g_c_in_g_c_list(set_list, p);
    if (eoln_command(input_file))
      read_line(input_file);
    if (P_inset(c, end_gc) & P_inset(c, end_gc_list))
      skip_one_end_mark(input_file, *command_, *keyboard, *full, &c);
    else if (P_inset(c, end_gc))
      c = ' ';
  } while (!P_inset(c, end_mark));   /* read_g_c_list */
}


/*@+"pchint.p"*/


Static Void int_vector_to_pch(int_vector, length, s)
long *int_vector;
long length;
Char *s;
{
  t_long_integer i;
  long TEMP;

  i = 1;
  while (int_vector[i - 1] != 0 && i <= length) {
    s[i - PCH_START] = (Char)int_vector[i - 1];
    /*$ifdef TRACE*/
    if (boolean_option[24]) {
      TEMP = 8;
      write_integer_text(stdout, int_vector[i - 1], &TEMP);
      write_char_text(stdout, ':');
      write_char_text(stdout, ' ');
      write_char_text(stdout, s[i - PCH_START]);
      write_line_stdout();
    }
    /*$endif TRACE*/
    i++;
  }
  s[i - PCH_START] = '\0';
}  /* int_vector_to_pch */


Static Void pch_to_int_vector(int_vector, length, s)
long *int_vector;
long length;
Char *s;
{
  t_long_integer i;

  i = 1;
  while (s[i - PCH_START] != '\0' && i <= length) {
    int_vector[i - 1] = s[i - PCH_START];
    i++;
  }
  int_vector[i - 1] = 0;
}  /* pch_to_int_vector */


Static Void vertex_to_long_vertex_name(v, full, vertex_name, length)
t_vertex *v;
boolean *full;
Char *vertex_name;
long *length;
{
  t_vertex_name_list *p_name_list;
  t_vertex u, FORLIM;

  if (*full)
    p_name_list = full_name_list;
  else
    p_name_list = name_list;
  FORLIM = *v;
  for (u = MIN_VERTEX + 1; u <= FORLIM; u++)
    p_name_list = p_name_list->pointer;
  memcpy(vertex_name, p_name_list->name, sizeof(pch_long));
  *length = p_name_list->length;
}  /* vertex_to_long_vertex_name */


Static Void insert_chr_in_pch(c, s, j, stop)
Char c;
Char *s;
long *j, *stop;
{
  if (*j <= *stop)
    s[*j - PCH_START] = c;
  (*j)++;
}  /* insert_chr_in_pch */


Static Void insert_long_vertex_name_in_pch(v, full, s, j, stop)
t_vertex *v;
boolean *full;
Char *s;
long *j, *stop;
{
  pch_long vertex_name;
  t_integer i, length;

  vertex_to_long_vertex_name(v, full, vertex_name, &length);
  if (*j + length <= *stop) {
    s[*j - PCH_START] = ':';
    for (i = 1; i <= length; i++)
      s[*j + i - PCH_START] = vertex_name[i - PCH_START];
  }
  *j += length + 1;
}  /* insert_long_vertex_name_in_pch */


Static Void return_vertex_set_in_pch(a, full, s, j, stop)
long *a;
boolean *full;
Char *s;
long *j, *stop;
{
  t_vertex u, v, w;

  insert_chr_in_pch('[', s, j, stop);
  if (*full)
    u = full_last_vertex;
  else
    u = last_vertex;
  for (v = first_vertex; v <= u; v++) {
    if (P_inset(v, a)) {
      if (long_names) {
	w = v;
	insert_long_vertex_name_in_pch(&w, full, s, j, stop);
      } else {
	if (*j <= *stop) {
	  if (*full)
	    s[*j - PCH_START] = full_vertex_inf[v - MIN_VERTEX].name;
	  else
	    s[*j - PCH_START] = vertex_inf[v - MIN_VERTEX].name;
	}
	(*j)++;
      }
    }
  }
  insert_chr_in_pch(']', s, j, stop);
}  /* return_vertex_set_in_pch */


Static Void return_vertex_list_in_pch(p, full, s, j, stop)
t_vertex_list *p;
boolean *full;
Char *s;
long *j, *stop;
{
  t_vertex v;

  insert_chr_in_pch('[', s, j, stop);
  while (p != NULL) {
    if (long_names) {
      v = p->vertex;
      insert_long_vertex_name_in_pch(&v, full, s, j, stop);
    } else {
      if (*j <= *stop) {
	if (*full)
	  s[*j - PCH_START] = full_vertex_inf[p->vertex - MIN_VERTEX].name;
	else
	  s[*j - PCH_START] = vertex_inf[p->vertex - MIN_VERTEX].name;
      }
      (*j)++;
    }
    p = p->pointer;
  }
  insert_chr_in_pch(']', s, j, stop);
}  /* return_vertex_list_in_pch */


Static Void return_g_c_in_pch(p, full, s, j, stop)
t_set_list *p;
boolean *full;
Char *s;
long *j, *stop;
{
  insert_chr_in_pch('[', s, j, stop);
  while (p != NULL) {
    if (*j > *stop && !long_names)
      *j += cardinality(p->vertex_set) + 2;
    else
      return_vertex_set_in_pch(p->vertex_set, full, s, j, stop);
    p = p->pointer;
  }
  insert_chr_in_pch(']', s, j, stop);
}  /* return_g_c_in_pch */


Static Void return_g_c_list_in_pch(p, full, s, j, stop)
t_g_c_list *p;
boolean *full;
Char *s;
long *j, *stop;
{
  insert_chr_in_pch('[', s, j, stop);
  while (p != NULL) {
    return_g_c_in_pch(p->g_c, full, s, j, stop);
    p = p->pointer;
  }
  insert_chr_in_pch(']', s, j, stop);
}  /* return_g_c_list_in_pch */


Static Void skip_one_end_mark_in_pch(s, full, i)
Char *s;
boolean *full;
long *i;
{
  (*i)++;
  while (!(((P_inset(s[*i - PCH_START], begin_set) | P_inset(s[*i - PCH_START],
	       end_mark)) || s[*i - PCH_START] == '\0') |
	   ((!*full) & P_inset(s[*i - PCH_START], names)) |
	   ((*full) & P_inset(s[*i - PCH_START], full_names)))) {
    if (!((((!*full) & P_inset(s[*i - PCH_START], names)) |
	   ((*full) & P_inset(s[*i - PCH_START], full_names))) ||
	  s[*i - PCH_START] == '\t' || s[*i - PCH_START] == '\n'))
      note_invalid_vertex_name(&s[*i - PCH_START]);
    (*i)++;
  }
}  /* skip_one_end_mark_in_pch */


Static Void get_long_vertex_name(s, vertex_name, length, i)
Char *s, *vertex_name;
long *length, *i;
{
  while ((s[*i - PCH_START] == ' ' || s[*i - PCH_START] == '\t' ||
	  s[*i - PCH_START] == '\n' ||
	  s[*i - PCH_START] == ':') | P_inset(s[*i - PCH_START], begin_set))
    (*i)++;
  *length = 0;
  while (!(((s[*i - PCH_START] == ' ' || s[*i - PCH_START] == '\t' ||
	     s[*i - PCH_START] == '\n' || s[*i - PCH_START] == ':' ||
	     s[*i - PCH_START] == '*') | P_inset(s[*i - PCH_START], end_mark)) ||
	   s[*i - PCH_START] == '\0')) {
    (*length)++;
    vertex_name[*length - PCH_START] = s[*i - PCH_START];
    (*i)++;
  }
  /*$ifdef TRACE*/
  if (!boolean_option[23])
    return;
  /*$endif TRACE*/
  write_pch(stdout, "  GET_LONG_VERTEX_NAME: ", 24L);
  write_pch(stdout, vertex_name, *length);
  write_integer(stdout, *i, 3L);
  write_line(stdout);
}  /* get_long_vertex_name */


Static Void pch_to_vertex(s, full, i, v, ok)
Char *s;
boolean *full;
long *i;
t_vertex *v;
boolean *ok;
{
  pch_long vertex_name;
  t_integer length;

  *ok = false;
  if (long_names) {
    get_long_vertex_name(s, vertex_name, &length, i);
    if (s[*i - PCH_START] != '*' && s[*i - PCH_START] != '.' || length != 0)
      *ok = long_vertex_name_to_vertex(vertex_name, &length, full, v);
  } else if (s[*i - PCH_START] != ' ' && s[*i - PCH_START] != '\t' &&
	     s[*i - PCH_START] != '\n')
    *ok = vertex_name_to_vertex(&s[*i - PCH_START], full, v);
  while (!(((*ok) | P_inset(s[*i - PCH_START], end_mark)) ||
	   s[*i - PCH_START] == '*' || s[*i - PCH_START] == '\\' ||
	   s[*i - PCH_START] == '\0')) {
    if (long_names) {
      get_long_vertex_name(s, vertex_name, &length, i);
      if (s[*i - PCH_START] != '*' && s[*i - PCH_START] != '.' || length != 0)
	*ok = long_vertex_name_to_vertex(vertex_name, &length, full, v);
    } else {
      (*i)++;
      if (s[*i - PCH_START] != ' ' && s[*i - PCH_START] != '\t' &&
	  s[*i - PCH_START] != '\n')
	*ok = vertex_name_to_vertex(&s[*i - PCH_START], full, v);
    }
  }
}  /* pch_to_vertex */


Static Void pch_to_vertex_list(s, full, i, p)
Char *s;
boolean *full;
long *i;
t_vertex_list **p;
{
  t_vertex v, u;
  boolean ok;

  *p = NULL;
  do {
    pch_to_vertex(s, full, i, &v, &ok);
    if (s[*i - PCH_START] == '*') {
      if (*full)
	u = full_last_vertex;
      else
	u = last_vertex;
      for (v = first_vertex; v <= u; v++)
	insert_vertex_in_vertex_list(v, p);
    } else if (ok)
      insert_vertex_in_vertex_list(v, p);
    if (!(P_inset(s[*i - PCH_START], end_mark) || s[*i - PCH_START] == '*' ||
	  s[*i - PCH_START] == '.' || s[*i - PCH_START] == ':' ||
	  s[*i - PCH_START] == '\\' || s[*i - PCH_START] == '\0'))
      (*i)++;
  } while (!(P_inset(s[*i - PCH_START], end_mark) ||
	     s[*i - PCH_START] == '*' || s[*i - PCH_START] == '.' ||
	     s[*i - PCH_START] == '\\' || s[*i - PCH_START] == '\0'));
      /* pch_to_vertex_list */
}


Static Void pch_to_vertex_set_sep(s, full, i, a)
Char *s;
boolean *full;
long *i;
long *a;
{
  t_vertex_list *p, *q;

  pch_to_vertex_list(s, full, i, &q);
  P_setcpy(a, empty_set);
  p = q;
  while (q != NULL) {
    P_addset(a, q->vertex);
    q = q->pointer;
  }
  dispose_vertex_list(&p);
}  /* pch_to_vertex_set_sep */


Static Void pch_to_vertex_set(s, full, a)
Char *s;
boolean *full;
long *a;
{
  t_long_integer i;

  i = 1;
  pch_to_vertex_set_sep(s, full, &i, a);
}  /* pch_to_vertex_set */


Static Void pch_to_set_list_sep(s, full, i, p)
Char *s;
boolean *full;
long *i;
t_set_list **p;
{
  t_vertex v, u;
  t_vertex_set a;

  *p = NULL;
  do {
    pch_to_vertex_set_sep(s, full, i, a);
    insert_set_in_set_list(a, p);
    if (P_inset(s[*i - PCH_START], end_set) & P_inset(s[*i - PCH_START], end_gc))
      skip_one_end_mark_in_pch(s, full, i);
    else if (P_inset(s[*i - PCH_START], end_set))
      (*i)++;
  } while (!(P_inset(s[*i - PCH_START], end_mark) ||
	     s[*i - PCH_START] == '*' || s[*i - PCH_START] == '\0'));
  if (s[*i - PCH_START] == '.' && (*p)->pointer == NULL &&
      P_setequal((*p)->vertex_set, empty_set)) {
    P_addset(P_expset((*p)->vertex_set, 0L), first_vertex);
    if (*full)
      u = full_last_vertex;
    else
      u = last_vertex;
    for (v = first_vertex + 1; v <= u; v++) {
      P_addset(P_expset(a, 0L), v);
      insert_set_in_set_list(a, p);
    }
  }
  if (s[*i - PCH_START] == '*')
    (*i)++;
}  /* pch_to_set_list_sep */


Static Void pch_to_set_list(s, full, p)
Char *s;
boolean *full;
t_set_list **p;
{
  t_long_integer i;

  i = 1;
  pch_to_set_list_sep(s, full, &i, p);
}  /* pch_to_set_list */


Static Void pch_to_gc_list(s, full, p)
Char *s;
boolean *full;
t_g_c_list **p;
{
  t_long_integer i;
  t_set_list *set_list;

  *p = NULL;
  i = 1;
  do {
    pch_to_set_list_sep(s, full, &i, &set_list);
    insert_g_c_in_g_c_list(set_list, p);
    if (P_inset(s[i - PCH_START], end_gc) & P_inset(s[i - PCH_START],
						    end_gc_list))
      skip_one_end_mark_in_pch(s, full, &i);
    else if (P_inset(s[i - PCH_START], end_gc))
      i++;
  } while (!(P_inset(s[i - PCH_START], end_mark) || s[i - PCH_START] == '\0'));
      /* pch_to_gc_list */
}


/*@+"get.p"*/


Static Void set_ifail(ifail, error)
long *ifail, error;
{
  *ifail = error;
}  /* set_ifail */


Static boolean ok_int_arg(ifail, arg_pos, count, nargs, arg_int)
long *ifail, arg_pos, count;
long **nargs, **arg_int;
{
  boolean ok;

  ok = false;
  if (*nargs == NULL || *arg_int == NULL) {
    set_ifail(ifail, 60L);
    return ok;
  }
  if ((*nargs)[arg_pos] < count)
    set_ifail(ifail, 70L);
  else
    ok = true;
  return ok;
}  /* ok_int_arg */


Static boolean ok_double_arg(ifail, arg_pos, count, nargs, arg_double)
long *ifail, arg_pos, count;
long **nargs;
double **arg_double;
{
  boolean ok;

  ok = false;
  if (*nargs == NULL || *arg_double == NULL) {
    set_ifail(ifail, 60L);
    return ok;
  }
  if ((*nargs)[arg_pos] < count)
    set_ifail(ifail, 70L);
  else
    ok = true;
  return ok;
}  /* ok_double_arg */


Static boolean ok_char_arg(ifail, arg_pos, count, nargs, arg_char)
long *ifail, arg_pos, count;
long **nargs;
Char **arg_char;
{
  boolean ok;

  ok = false;
  if (*nargs == NULL || *arg_char == NULL) {
    set_ifail(ifail, 60L);
    return ok;
  }
  if ((*nargs)[arg_pos] < count)
    set_ifail(ifail, 70L);
  else
    ok = true;
  return ok;
}  /* ok_char_arg */


Static Void get_option_list(command_file, as_argument, sep)
FILE *command_file;
boolean as_argument;
Char *sep;
{
  if (as_argument)
    return;
  *sep = '@';
  if (eoln_command(command_file)) {
    *sep = ' ';
    return;
  }
  read_char(command_file, sep);
  if (*sep != '-')
    return;
  while ((*sep != '/' && *sep != ';') & (!eoln_command(command_file)))
    read_char(command_file, sep);
  *sep = ' ';
}  /* get_option_list */


Static Void get_one_integer(command_file, as_argument, ifail, sub_code,
			    arg_pos, nargs, arg_int, promb, w, x)
FILE *command_file;
boolean as_argument;
long *ifail, *sub_code, arg_pos;
long **nargs, **arg_int;
Char *promb;
long w, *x;
{
  if (!as_argument) {
    read_integer(command_file, promb, w, x);
    return;
  }
  if (!ok_int_arg(ifail, arg_pos, 1L, nargs, arg_int))
    return;
  if (*sub_code == -1)
    (*arg_int)[0] = *x;
  else
    *x = (*arg_int)[0];
}  /* get_one_integer */


Static Void get_next_integer(command_file, as_argument, i, ifail, sub_code,
			     arg_pos, nargs, arg_int, promb, w, x)
FILE *command_file;
boolean as_argument;
long *i, *ifail, *sub_code, arg_pos;
long **nargs, **arg_int;
Char *promb;
long w, *x;
{
  if (as_argument) {
    if (ok_int_arg(ifail, arg_pos, *i + 1, nargs, arg_int)) {
      if (*sub_code == -1)
	(*arg_int)[*i] = *x;
      else
	*x = (*arg_int)[*i];
    } else if (*sub_code == -1)
      (*arg_int)[(*nargs)[arg_pos] - 1] = INFINITY;
  } else
    read_integer(command_file, promb, w, x);
  (*i)++;
}  /* get_next_integer */


Static Void get_next_level(command_file, f, command_, keyboard, full,
			   as_argument, i, ifail, sub_code, arg_pos, nargs,
			   arg_int, promb, w, x, sep, max_level, v)
FILE *command_file, *f;
boolean command_, keyboard, full, as_argument;
long *i, *ifail, *sub_code, arg_pos;
long **nargs, **arg_int;
Char *promb;
long w, *x;
Char *sep;
t_level max_level;
t_vertex v;
{
  boolean eod;

  eod = false;
  do {
    if (as_argument) {
      if (ok_int_arg(ifail, arg_pos, *i + 1, nargs, arg_int)) {
	if (*sub_code == -1)
	  (*arg_int)[*i] = *x;
	else
	  *x = (*arg_int)[*i];
      } else if (*sub_code == -1)
	(*arg_int)[(*nargs)[arg_pos]] = INFINITY;
    } else {
      read_integer_separator(command_file, command_, keyboard, false, promb,
			     w, x, sep);
      if (*x == MISSING)
	*x = MISSING_LEVEL;
      else if (*x == _UNDEF)
	*x = _UNDEF_LEVEL;
      else if ((unsigned long)(*x) > max_level)
	*x = _INVALID_LEVEL;
    }
    (*i)++;
    if (*x == _UNDEF_LEVEL || *x == _INVALID_LEVEL ||
	*x != MISSING_LEVEL && *x > max_level) {
      write_pch(f, promb, w - 2);
      write_char(f, '(');
      if (full)
	print_full_vertex_on_file(f, v);
      else
	print_vertex_on_file(f, v);
      write_pch(f, ")-> ", 4L);
      write_pch(f, " Invalid  ", 10L);
      write_line(f);
    }
    if (!as_argument)
      eod = eof_command(command_file);
  } while (!((*x != _UNDEF_LEVEL && *x != _INVALID_LEVEL &&
	      (*x == MISSING_LEVEL || *x <= max_level)) || eod ||
	     *ifail != 0));
      /* get_next_level */
}


Static Void get_one_long_real(command_file, as_argument, ifail, sub_code,
			      arg_pos, nargs, arg_double, promb, w, x)
FILE *command_file;
boolean as_argument;
long *ifail, *sub_code, arg_pos;
long **nargs;
double **arg_double;
Char *promb;
long w;
double *x;
{
  if (!as_argument) {
    read_real(command_file, promb, w, x);
    return;
  }
  if (!ok_double_arg(ifail, arg_pos, 1L, nargs, arg_double))
    return;
  if (*sub_code == -1)
    (*arg_double)[0] = *x;
  else
    *x = (*arg_double)[0];
}  /* get_one_long_real */


Static Void get_next_long_real(command_file, as_argument, i, ifail, sub_code,
			       arg_pos, nargs, arg_double, promb, w, x)
FILE *command_file;
boolean as_argument;
long *i, *ifail, *sub_code, arg_pos;
long **nargs;
double **arg_double;
Char *promb;
long w;
double *x;
{
  if (as_argument) {
    if (ok_double_arg(ifail, arg_pos, *i + 1, nargs, arg_double)) {
      if (*sub_code == -1)
	(*arg_double)[*i] = *x;
      else
	*x = (*arg_double)[*i];
    } else if (*sub_code == -1)
      (*arg_double)[(*nargs)[arg_pos] - 1] = _INVALID_REAL;
  } else
    read_real(command_file, promb, w, x);
  (*i)++;
}  /* get_next_long_real */


Static Void put_one_integer(arg_int, j, stop, x)
long **arg_int;
long *j, *stop, *x;
{
  if (*j < *stop - 1)
    (*arg_int)[*j] = *x;
  (*j)++;
}  /* put_one_integer */


Static Void put_one_long_real(arg_double, j, stop, x)
double **arg_double;
long *j, *stop;
double *x;
{
  if (*j < *stop - 1)
    (*arg_double)[*j] = *x;
  (*j)++;
}  /* put_one_long_real */


Static boolean get_file_name(command_file, as_argument, ifail, sub_code,
			     arg_pos, nargs, arg_char, old_name, new_name)
FILE *command_file;
boolean as_argument;
long *ifail, *sub_code, arg_pos;
long **nargs;
Char **arg_char, *old_name, *new_name;
{
  if (as_argument) {
    if (!ok_char_arg(ifail, arg_pos, 0L, nargs, arg_char))
      return (*sub_code != -1 && *ifail == 0);
    if (*sub_code == -1)
      copy_string(old_name, *arg_char, &(*nargs)[arg_pos], ifail);
    else
      copy_string(*arg_char, new_name, &(*nargs)[arg_pos], ifail);
    return (*sub_code != -1 && *ifail == 0);
  } else {
    read_file_name(command_file, new_name);
    return true;
  }
}  /* get_file_name */


Static Void set_string_end(i, ifail, arg_pos, nargs, arg_char)
long *i, *ifail, arg_pos;
long **nargs;
Char **arg_char;
{
  if (*i <= (*nargs)[arg_pos])
    (*arg_char)[*i - PCH_START] = '\0';
  else {
    set_ifail(ifail, 70L);
    (*arg_char)[(*nargs)[arg_pos] - PCH_START] = '\0';
  }
  (*nargs)[arg_pos] = *i;
}  /* set_string_end */


Static Void set_long_end(i, ifail, arg_pos, nargs, arg_int)
long *i, *ifail, arg_pos;
long **nargs, **arg_int;
{
  if (*i < (*nargs)[arg_pos])
    (*arg_int)[*i] = INFINITY;
  else {
    set_ifail(ifail, 70L);
    (*arg_int)[(*nargs)[arg_pos] - 1] = INFINITY;
  }
  (*nargs)[arg_pos] = *i + 1;
}  /* set_long_end */


Static Void set_real_end(i, ifail, arg_pos, nargs, arg_double)
long *i, *ifail, arg_pos;
long **nargs;
double **arg_double;
{
  if (*i < (*nargs)[arg_pos])
    (*arg_double)[*i] = _INVALID_REAL;
  else {
    set_ifail(ifail, 70L);
    (*arg_double)[(*nargs)[arg_pos] - 1] = _INVALID_REAL;
  }
  (*nargs)[arg_pos] = *i + 1;
}  /* set_real_end */


Static boolean get_vertex(command_file, arg_command, arg_keyboard, arg_full,
			  as_argument, i, ifail, sub_code, arg_pos, nargs,
			  arg_char, promb_, w, old_vertex, new_vertex)
FILE *command_file;
boolean arg_command, arg_keyboard, arg_full, as_argument;
long *i, *ifail, *sub_code, arg_pos;
long **nargs;
Char **arg_char;
Char *promb_;
long w;
t_vertex *old_vertex, *new_vertex;
{
  boolean Result;
  pch10 promb;
  boolean command_, keyboard, full, ok;

  memcpy(promb, promb_, sizeof(pch10));
  command_ = arg_command;
  keyboard = arg_keyboard;
  full = arg_full;
  if (as_argument) {
    if (ok_char_arg(ifail, arg_pos, 0L, nargs, arg_char)) {
      if (*sub_code == -1) {
	if (long_names) {
	  insert_long_vertex_name_in_pch(old_vertex, &full, *arg_char, i,
					 &(*nargs)[arg_pos]);
	  set_string_end(i, ifail, arg_pos, nargs, arg_char);
	} else {
	  if (*i <= (*nargs)[arg_pos])
	    (*arg_char)[*i - PCH_START] = vertex_inf[*old_vertex - MIN_VERTEX].name;
	  (*i)++;
	}
	(*nargs)[arg_pos] = *i - 1;
      } else
	pch_to_vertex(*arg_char, &full, i, new_vertex, &ok);
    }
    Result = (*sub_code != -1 && *ifail == 0);
  } else {
    read_promb_vertex(command_file, &command_, &keyboard, &full, promb, &w,
		      new_vertex);
    Result = true;
  }
  /*$ifdef TRACE*/
  if (!boolean_option[27])
    return Result;
  /*$endif TRACE*/
  write_char(stdout, '<');
  print_vertex(*new_vertex);
  if (*ifail != 0)
    write_integer(stdout, *ifail, 2L);
  write_char(stdout, '>');
  return Result;
}  /* get_vertex */


Static boolean get_vertex_list_sep(command_file, command_, keyboard, arg_full,
  as_argument, sep, i, ifail, sub_code, arg_pos, nargs, arg_char, promb, w,
  old_vertex_list, new_vertex_list)
FILE *command_file;
boolean command_, keyboard, arg_full, as_argument;
Char *sep;
long *i, *ifail, *sub_code, arg_pos;
long **nargs;
Char **arg_char;
Char *promb;
long w;
t_vertex_list **old_vertex_list, **new_vertex_list;
{
  boolean Result, full;

  full = arg_full;
  if (as_argument) {
    if (ok_char_arg(ifail, arg_pos, 0L, nargs, arg_char)) {
      if (*sub_code == -1) {
	return_vertex_list_in_pch(*old_vertex_list, &full, *arg_char, i,
				  &(*nargs)[arg_pos]);
	set_string_end(i, ifail, arg_pos, nargs, arg_char);
      } else
	pch_to_vertex_list(*arg_char, &full, i, new_vertex_list);
    }
    *sep = (*arg_char)[*i - PCH_START];
    Result = (*sub_code != -1 && *ifail == 0);
  } else {
    read_sep_vertex_list(command_file, command_, keyboard, full,
			 new_vertex_list, sep);
    Result = true;
  }
  /*$ifdef TRACE*/
  if (!boolean_option[27])
    return Result;
  /*$endif TRACE*/
  write_char(stdout, '<');
  print_vertex_list(*new_vertex_list);
  if (*ifail != 0)
    write_integer(stdout, *ifail, 2L);
  write_char(stdout, ':');
  write_char(stdout, *sep);
  write_char(stdout, '>');
  return Result;
}  /* get_vertex_list_sep */


Static boolean get_vertex_list(command_file, command_, keyboard, arg_full,
  as_argument, i, ifail, sub_code, arg_pos, nargs, arg_char, promb, w,
  old_vertex_list, new_vertex_list)
FILE *command_file;
boolean command_, keyboard, arg_full, as_argument;
long *i, *ifail, *sub_code, arg_pos;
long **nargs;
Char **arg_char;
Char *promb;
long w;
t_vertex_list **old_vertex_list, **new_vertex_list;
{
  boolean Result, full;

  full = arg_full;
  if (as_argument) {
    if (ok_char_arg(ifail, arg_pos, 0L, nargs, arg_char)) {
      if (*sub_code == -1) {
	return_vertex_list_in_pch(*old_vertex_list, &full, *arg_char, i,
				  &(*nargs)[arg_pos]);
	set_string_end(i, ifail, arg_pos, nargs, arg_char);
      } else
	pch_to_vertex_list(*arg_char, &full, i, new_vertex_list);
    }
    Result = (*sub_code != -1 && *ifail == 0);
  } else {
    read_promb_vertex_list(command_file, command_, keyboard, full, promb, w,
			   new_vertex_list);
    Result = true;
  }
  /*$ifdef TRACE*/
  if (!boolean_option[27])
    return Result;
  /*$endif TRACE*/
  write_char(stdout, '<');
  print_vertex_list(*new_vertex_list);
  if (*ifail != 0)
    write_integer(stdout, *ifail, 2L);
  write_char(stdout, '>');
  return Result;
}  /* get_vertex_list */


Static boolean get_vertex_set(command_file, arg_command, arg_keyboard,
  arg_full, as_argument, i, ifail, sub_code, arg_pos, nargs, arg_char, promb_,
  w, old_set, new_set)
FILE *command_file;
boolean arg_command, arg_keyboard, arg_full, as_argument;
long *i, *ifail, *sub_code, arg_pos;
long **nargs;
Char **arg_char;
Char *promb_;
long w;
long *old_set, *new_set;
{
  boolean Result;
  pch10 promb;
  boolean command_, keyboard, full;

  memcpy(promb, promb_, sizeof(pch10));
  command_ = arg_command;
  keyboard = arg_keyboard;
  full = arg_full;
  if (as_argument) {
    if (ok_char_arg(ifail, arg_pos, 0L, nargs, arg_char)) {
      if (*sub_code == -1) {
	return_vertex_set_in_pch(old_set, &full, *arg_char, i,
				 &(*nargs)[arg_pos]);
	set_string_end(i, ifail, arg_pos, nargs, arg_char);
      } else
	pch_to_vertex_set(*arg_char, &full, new_set);
    }
    Result = (*sub_code != -1 && *ifail == 0);
  } else {
    read_promb_set_of_vertexes(command_file, &command_, &keyboard, &full,
			       promb, &w, new_set);
    Result = true;
  }
  /*$ifdef TRACE*/
  if (!boolean_option[27])
    return Result;
  /*$endif TRACE*/
  write_char(stdout, '<');
  print_vertex_set(new_set);
  if (*ifail != 0)
    write_integer(stdout, *ifail, 2L);
  write_char(stdout, '>');
  return Result;
}  /* get_vertex_set */


Static boolean get_vertex_set_list(command_file, arg_command, arg_keyboard,
  arg_full, as_argument, i, ifail, sub_code, arg_pos, nargs, arg_char, promb_,
  w, old_set_list, new_set_list)
FILE *command_file;
boolean arg_command, arg_keyboard, arg_full, as_argument;
long *i, *ifail, *sub_code, arg_pos;
long **nargs;
Char **arg_char;
Char *promb_;
long w;
t_set_list **old_set_list, **new_set_list;
{
  boolean Result;
  pch10 promb;
  boolean command_, keyboard, full;

  memcpy(promb, promb_, sizeof(pch10));
  command_ = arg_command;
  keyboard = arg_keyboard;
  full = arg_full;
  if (as_argument) {
    if (ok_char_arg(ifail, arg_pos, 0L, nargs, arg_char)) {
      if (*sub_code == -1) {
	return_g_c_in_pch(*old_set_list, &full, *arg_char, i,
			  &(*nargs)[arg_pos]);
	set_string_end(i, ifail, arg_pos, nargs, arg_char);
      } else
	pch_to_set_list_sep(*arg_char, &full, i, new_set_list);
    }
    Result = (*sub_code != -1 && *ifail == 0);
  } else {
    read_promb_set_list(command_file, &command_, &keyboard, &full, promb, &w,
			new_set_list);
    Result = true;
  }
  /*$ifdef TRACE*/
  if (!boolean_option[27])
    return Result;
  /*$endif TRACE*/
  write_char(stdout, '<');
  print_g_c(*new_set_list, 0L, line_length);
  if (*ifail != 0)
    write_integer(stdout, *ifail, 2L);
  write_char(stdout, '>');
  return Result;
}  /* get_vertex_set_list */


Static boolean test_hierarchical(p)
t_set_list *p;
{
  t_set_list *q;
  boolean ok;

  ok = true;
  while (p != NULL && ok) {
    q = p->pointer;
    while (q != NULL && ok) {
      if (P_subset(p->vertex_set, q->vertex_set) ||
	  P_subset(q->vertex_set, p->vertex_set))
	ok = false;
      else
	q = q->pointer;
    }
    p = p->pointer;
  }
  return ok;
}  /* test_hierarchical */


Static Void list_of_lists_to_list_of_sets(link_list_of_lists, link_set_list)
t_list_of_vertex_lists *link_list_of_lists;
t_set_list **link_set_list;
{
  t_vertex_list *p_vertex;

  *link_set_list = NULL;
  while (link_list_of_lists != NULL) {
    insert_set_in_set_list(empty_set, link_set_list);
    p_vertex = link_list_of_lists->vertex_list;
    while (p_vertex != NULL) {
      P_addset((*link_set_list)->vertex_set, p_vertex->vertex);
      p_vertex = p_vertex->pointer;
    }
    link_list_of_lists = link_list_of_lists->pointer;
  }
}  /* list_of_lists_to_list_of_sets */


Static boolean get_gc(command_file, command_, keyboard, arg_full, as_argument,
		      i, ifail, sub_code, arg_pos, nargs, arg_char, promb, w,
		      old_set_list, new_set_list)
FILE *command_file;
boolean command_, keyboard, arg_full, as_argument;
long *i, *ifail, *sub_code, arg_pos;
long **nargs;
Char **arg_char;
Char *promb;
long w;
t_set_list **old_set_list, **new_set_list;
{
  boolean Result, ok, full;
  t_list_of_vertex_lists *lists_h_g_c;

  full = arg_full;
  if (as_argument) {
    if (ok_char_arg(ifail, arg_pos, 0L, nargs, arg_char)) {
      if (*sub_code == -1) {
	return_g_c_in_pch(*old_set_list, &full, *arg_char, i,
			  &(*nargs)[arg_pos]);
	set_string_end(i, ifail, arg_pos, nargs, arg_char);
      } else
	pch_to_set_list(*arg_char, &full, new_set_list);
    }
    ok = (*sub_code != -1 && *ifail == 0);
  } else {
    read_list_of_vertex_lists(command_file, command_, keyboard, full,
			      &lists_h_g_c);
    list_of_lists_to_list_of_sets(lists_h_g_c, new_set_list);
    dispose_list_of_vertex_lists(&lists_h_g_c);
    ok = true;
  }
  if (ok) {
    if (echo)
      write_line(stdout);
    if (!test_hierarchical(*new_set_list)) {
      write_pch(stdout, " READ: ", 7L);
      print_g_c(*new_set_list, 1L, line_length);
      dispose_set_list(new_set_list);
      write_line(stdout);
      write_pch(stdout, " SET OF SETS IS NOT A GENERATING CLASS  ", 40L);
      write_line(stdout);
      Result = false;
    } else
      Result = true;
  } else
    Result = false;
  /*$ifdef TRACE*/
  if (!boolean_option[27])
    return Result;
  /*$endif TRACE*/
  write_char(stdout, '<');
  print_g_c(*new_set_list, 0L, line_length);
  if (*ifail != 0)
    write_integer(stdout, *ifail, 2L);
  write_char(stdout, '>');
  return Result;
}  /* get_gc */


Static boolean get_gc_list(command_file, arg_command, arg_keyboard, arg_full,
			   as_argument, i, ifail, sub_code, arg_pos, nargs,
			   arg_char, promb, w, old_gc, new_gc)
FILE *command_file;
boolean arg_command, arg_keyboard, arg_full, as_argument;
long *i, *ifail, *sub_code, arg_pos;
long **nargs;
Char **arg_char;
Char *promb;
long w;
t_g_c_list **old_gc, **new_gc;
{
  boolean command_, keyboard, full;

  command_ = arg_command;
  keyboard = arg_keyboard;
  full = arg_full;
  if (as_argument) {
    if (!ok_char_arg(ifail, arg_pos, 0L, nargs, arg_char))
      return (*sub_code != -1 && *ifail == 0);
    if (*sub_code == -1) {
      return_g_c_list_in_pch(*old_gc, &full, *arg_char, i, &(*nargs)[arg_pos]);
      set_string_end(i, ifail, arg_pos, nargs, arg_char);
    } else
      pch_to_gc_list(*arg_char, &full, new_gc);
    return (*sub_code != -1 && *ifail == 0);
  } else {
    read_g_c_list(command_file, &command_, &keyboard, &full, new_gc);
    return true;
  }
}  /* get_gc_list */


Static Void get_two_vertices_and_set_list(command_file, as_argument,
  separated, ifail, sub_code, arg_pos_char, nargs, arg_char, v, w, gc)
FILE *command_file;
boolean as_argument, separated;
long *ifail, *sub_code, arg_pos_char;
long **nargs;
Char **arg_char;
t_vertex *v, *w;
t_set_list **gc;
{
  t_long_integer i;
  boolean ok;
  Char sep;
  t_vertex_list *p, *q;

  i = PCH_START;
  get_option_list(command_file, as_argument, &sep);
  q = NULL;
  i = PCH_START;
  ok = get_vertex_list_sep(command_file, true, true, false, as_argument, &sep,
			   &i, ifail, sub_code, arg_pos_char, nargs, arg_char,
			   " Vertex->", 9L, &q, &q);
  revers_vertex_list(&q);
  if (q == NULL || *ifail != 0) {
    set_ifail(ifail, 71L);
    return;
  }
  p = q;
  q = q->pointer;
  *v = p->vertex;
  Free(p);
  if (q == NULL) {
    i++;
    sep = ' ';
    ok = get_vertex_list_sep(command_file, true, true, false, as_argument,
			     &sep, &i, ifail, sub_code, arg_pos_char, nargs,
			     arg_char, " Vertex->", 9L, &q, &q);
    revers_vertex_list(&q);
  }
  if (q == NULL || *ifail != 0) {
    set_ifail(ifail, 71L);
    return;
  }
  p = q;
  q = q->pointer;
  *w = p->vertex;
  Free(p);
  if (separated)
    dispose_vertex_list(&q);
  if (q == NULL) {
    *gc = NULL;
    i++;
    sep = ' ';
    ok = get_vertex_set_list(command_file, true, true, false, as_argument, &i,
			     ifail, sub_code, arg_pos_char, nargs, arg_char,
			     " GC->", 5L, gc, gc);
    return;
  }
  *gc = (t_set_list *)Malloc(sizeof(t_set_list));
  if (*gc == NULL)
    _OutMem();
  (*gc)->pointer = NULL;
  list_of_vertices_to_set(q, (*gc)->vertex_set);
}  /* get_two_vertices_and_set_list */


Static Void sub_code_to_model(ifail, sub_code, p)
long *ifail, *sub_code;
t_model_list **p;
{
  *p = NULL;
  switch (*sub_code) {

  case -1:
    if (base_ifail(ifail))
      *p = link_base;
    break;

  case -2:
    if (current_ifail(ifail))
      *p = link_current;
    break;

  case -3:
    if (link_model_list != NULL)
      *p = link_model_list;
    break;
  }
}  /* sub_code_to_model */


/*@+"messages.p"*/


Static Void sub_write_test_head(f, write_models)
FILE *f;
boolean write_models;
{
  if (exclude_missing && partitioning_output) {
    if (write_models) {
      write_space(f, 2L);
      if (dimension > 5) {
	write_pch(f, "Test on", 7L);
	write_space(f, dimension - 5L);
      } else
	write_pch(f, "On        ", dimension + 2L);
    }
    write_char(f, ' ');
    write_pch(f, "    N[]", 7L);
    if (long_names && write_models) {
      write_line(stdout);
      if (short_report)
	write_space(stdout, 3L);
      write_space(stdout, 7L);
    }
  }
  write_char(f, ' ');
  if (true)
    write_space(f, labs(x_width) - 4);
  write_pch(f, "  DF", 4L);
  write_char(f, ' ');
  if (adj_df) {
    write_pch(f, "  #0", 4L);
    write_char(f, ' ');
  }
  write_space(f, labs(x_width) - 8);
  write_pch(f, "-2log(Q)", 8L);
  write_char(f, ' ');
  write_space(f, labs(prob_width) - 1);
  write_pch(f, "P", 1L);
  write_char(f, ' ');
  if (lambda != 1) {
    write_space(f, labs(x_width) - 8);
    write_pch(f, "PowerDiv", 8L);
    write_char(f, ' ');
    write_space(f, labs(prob_width) - 1);
    write_pch(f, "P", 1L);
    write_char(f, ' ');
  }
  write_space(f, labs(x_width) - 3);
  write_pch(f, "X^2", 3L);
  write_char(f, ' ');
  write_space(f, labs(prob_width) - 1);
  write_pch(f, "P", 1L);
  write_char(f, ' ');
  if (ordinal_tests) {
    write_space(f, labs(x_width) - 5);
    write_pch(f, "Gamma", 5L);
    write_char(f, ' ');
    write_space(f, labs(prob_width) - 1);
    write_pch(f, "P", 1L);
    write_char(f, ' ');
  }
  if (ic) {
    write_space(f, labs(x_width) - 9);
    write_pch(f, "Delta(IC)", 9L);
    write_char(f, ' ');
  }
  write_space(f, labs(x_width) - 6);
}  /* sub_write_test_head */


Static Void write_test_head(f, c1, w1, s, c2, w2, write_models)
FILE *f;
Char *c1;
long w1, s;
Char *c2;
long w2;
boolean write_models;
{
  write_line(f);
  if (s >= 0)
    write_char(f, ' ');
  write_pch(f, c1, w1);
  write_space(f, s);
  sub_write_test_head(f, write_models);
  write_pch(f, c2, w2);
  if (em) {
    write_line(f);
    if (s >= 0)
      write_char(f, ' ');
    write_space(f, w1 + s + 8);
    write_pch(f, "(Warning: ", 10L);
    write_pch(f, "DF. not correct for latent variables!)", 38L);
  }
  write_line(f);
  write_line(f);
}  /* write_test_head */


Static Void write_test_head_stepwise(f, c, offset, short_test_output,
				     write_models, short_report, just)
FILE *f;
Char *c;
long offset;
boolean short_test_output, write_models, short_report, just;
{
  if (!short_test_output)
    return;
  if (write_models) {
    if (short_report)
      write_test_head(stdout, c, 9L, offset, "Models", 6L, write_models);
    else if (!just)
      write_test_head(stdout, "  Edge    ", 6L, offset, "Models", 6L,
		      write_models);
    return;
  }
  if (short_report)
    write_test_head(stdout, "", 0L, offset - 1, c, 9L, write_models);
  else if (!just)
    write_test_head(stdout, "", 0L, offset - 1, "Edge", 4L,
		    write_models);
}  /* write_test_head_stepwise */


Static Void write_file_not_found(f, name)
FILE *f;
Char *name;
{
  if (!echo)
    write_line_diary();
  write_pch(f, " *** WARNING ***  File '", 24L);
  write_pch_to_blank(f, name, (long)PCH_END);
  write_pch(f, "' not found.  *** WARNING *** ", 30L);
  write_line(f);
}  /* write_file_not_found */


Static Void write_file_not_opened(f, name)
FILE *f;
Char *name;
{
  if (!echo)
    write_line_diary();
  write_pch(f, " *** WARNING ***  Unable to REWRITE '", 37L);
  write_pch_to_blank(f, name, (long)PCH_END);
  write_pch(f, "'.  *** WARNING *** ", 20L);
  write_line(f);
}  /* write_file_not_opened */


Static Void write_warning(f, c, w)
FILE *f;
Char *c;
long w;
{
  write_line(f);
  write_pch(f, " *** WARNING ***", 16L);
  write_line(f);
  write_pch(f, c, w);
  write_line(f);
  write_pch(f, " *** WARNING ***", 16L);
  write_line(f);
}  /* write_warning */


Static Void note_error(error)
long error;
{
  write_line(stdout);
  write_line(stdout);
  write_pch(stdout, " Please ignore: ", 16L);
  write_pch(stdout, " Error number: ", 15L);
  write_integer(stdout, error, 5L);
  write_line(stdout);
  write_line(stdout);
}  /* note_error */


Static Void no_ips_convergence(link_clique, cycle_number, d)
t_ips_set_list *link_clique;
long *cycle_number;
double *d;
{
  t_long_integer cc;

  if (!note_warnings)
    return;
  cc = char_count;
  write_pch(stdout, "/*", 2L);
  if (cc > 30)
    write_line(stdout);
  else
    write_space(stdout, 2L);
  write_pch(stdout, " *** WARNING *** ", 17L);
  if (interrupt_1) {
    write_pch(stdout, " Interrupt in IPS:  ", 20L);
    interrupt_1 = false;
  } else
    write_pch(stdout, " Max Cycles in IPS: ", 20L);
  while (link_clique != NULL) {
    print_vertex_set(link_clique->vertex_set);
    link_clique = link_clique->pointer;
  }
  write_space(stdout, 2L);
  write_pch(stdout, " It Nr.:", 8L);
  write_integer(stdout, *cycle_number, 5L);
  write_space(stdout, 2L);
  write_pch(stdout, " Delta:", 7L);
  write_real(stdout, *d, print_width, print_dec);
  write_space(stdout, 2L);
  write_pch(stdout, " *** WARNING *** ", 17L);
  if (cc > 2) {
    write_line(stdout);
    write_space(stdout, cc - 2);
    write_pch(stdout, "*/", 2L);
    return;
  }
  write_space(stdout, 2L);
  write_pch(stdout, "*/", 2L);
  write_line(stdout);
}  /* no_ips_convergence */


Static Void warning_ips(link_clique)
t_ips_set_list *link_clique;
{
  if (short_test_output)
    write_line(stdout);
  write_line(stdout);
  write_pch(stdout, " *** WARNING ***    ", 20L);
  write_line(stdout);
  write_pch(stdout, " No Cycles in IPS:  ", 20L);
  while (link_clique != NULL) {
    print_vertex_set(link_clique->vertex_set);
    link_clique = link_clique->pointer;
  }
  write_line(stdout);
  write_pch(stdout, " *** WARNING ***    ", 20L);
  write_line(stdout);
  write_line(stdout);
  if (short_test_output)
    write_space(stdout, 7L);
}  /* warning_ips */


Static Void write_out_of_space(g_c_1, g_c_2, c, short_test_output, off, dept)
t_set_list *g_c_1, *g_c_2;
Char *c;
boolean short_test_output;
long off, dept;
{
  if (short_test_output) {
    write_pch(stdout, " Out of space in test of ", 25L);
    print_g_c_from(g_c_1, off + 33, off + 8, line_length);
    write_line(stdout);
    write_space(stdout, 7L);
    write_pch(stdout, " against ", 9L);
    if (g_c_2 == NULL)
      write_pch(stdout, c, 10L);
    else
      print_g_c_from(g_c_2, off + 17, off + 8, line_length);
    write_line(stdout);
    return;
  }
  write_space(stdout, dept + 1);
  write_pch(stdout, "Out of space", 12L);
  write_line(stdout);
  write_space(stdout, dept + 1);
  write_pch(stdout, "in test of ", 11L);
  print_g_c_from(g_c_1, dept + 12, dept + 1, line_length);
  write_line(stdout);
  write_space(stdout, dept + 1);
  write_pch(stdout, "against ", 8L);
  if (g_c_2 == NULL)
    write_pch(stdout, c, 10L);
  else
    print_g_c_from(g_c_2, dept + 9, dept + 1, line_length);
  write_line(stdout);
}  /* write_out_of_space */


Static Void write_used_time(f, start_clock)
FILE *f;
double start_clock;
{
  write_pch(f, " Time:       ", 13L);
  write_real(f, (my_clock()/1 - start_clock) / 1000, 14L, 3L);
  write_pch(f, "secs.", 5L);
  write_line(f);
}  /* write_used_time */


Static Void sub_print_invers_order(invers_order, c, complete)
t_vertex *invers_order;
t_vertex_set *c;
uchar *complete;
{
  t_long_integer i;
  t_vertex v;
  long FORLIM;

  write_space(stdout, 2L);
  write_char(stdout, 'V');
  write_pch(stdout, "  ", 2L);
  write_pch(stdout, " Order(V) ", 10L);
  write_space(stdout, 2L);
  write_pch(stdout, "C(V)", 4L);
  write_space(stdout, dimension - 2L);
  write_pch(stdout, "Complete(V)  ", 13L);
  write_line(stdout);
  FORLIM = dimension;
  for (i = 1; i <= FORLIM; i++) {
    v = invers_order[i - 1];
    write_space(stdout, 2L);
    print_vertex_on_file(stdout, v);
    write_pch(stdout, ": ", 2L);
    write_integer(stdout, i, 10L);
    write_space(stdout, 3L);
    print_vertex_set_table_full(c[v - MIN_VERTEX]);
    write_boolean(stdout, P_getbits_UB(complete, v - MIN_VERTEX, 0, 3));
    write_line(stdout);
  }
}  /* sub_print_invers_order */


/*@-"marginal.c"*/
/*@+"next.p"*/


Static Void next_c_offset_in_a(c_in_a, offset, prod_1, prod_2, levels,
			       l_a_vertex, i)
long *c_in_a;
t_cell_index *offset;
long *prod_1, *prod_2, *levels;
t_vertex *l_a_vertex;
t_level *i;
{
  t_vertex v;

  v = first_vertex;
  while (i[v - MIN_VERTEX] == levels[v - MIN_VERTEX]) {
    if (P_inset(v, c_in_a))
      *offset -= prod_2[v - MIN_VERTEX];
    i[v - MIN_VERTEX] = FIRST_LEVEL;
    v++;
  }
  if (v > *l_a_vertex)
    return;
  if (P_inset(v, c_in_a))
    *offset += prod_1[v - MIN_VERTEX];
  i[v - MIN_VERTEX]++;
}  /* next_c_offset_in_a */


Static Void find_products(a, c, c_in_a, prod_1, prod_2, levels, l)
long *a, *c, *c_in_a;
long *prod_1, *prod_2, *levels;
t_vertex *l;
{
  t_cell_index product;
  t_vertex v, w, FORLIM;

  product = 1;
  w = first_vertex;
  P_setcpy(c_in_a, empty_set);
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    if (P_inset(v, a)) {
      if (P_inset(v, c)) {
	P_addset(c_in_a, w);
	prod_1[w - MIN_VERTEX] = product;
	product *= vertex_inf[v - MIN_VERTEX].levels;
	prod_2[w - MIN_VERTEX] = product - prod_1[w - MIN_VERTEX];
      }
      levels[w - MIN_VERTEX] = FIRST_LEVEL + vertex_inf[v - MIN_VERTEX].levels - 1;
      w++;
    }
  }
  levels[w - MIN_VERTEX] = _INVALID_LEVEL;
  *l = w - 1;
}  /* find_products */


Static Void add_to_offsets(model, x)
t_model *model;
long x;
{
  t_expression *link_expression;
  t_list_ips_elements *link_ips_list;

  if (x == 0)
    return;
  link_expression = model->expression;
  while (link_expression != NULL) {
    link_expression->offset += x;
    link_expression = link_expression->pointer;
  }
  link_ips_list = model->ips_list;
  while (link_ips_list != NULL) {
    link_ips_list->ips_element.p_offset += x;
    link_ips_list = link_ips_list->pointer;
  }
}  /* add_to_offsets */


Static Void dispose_product_list(p)
t_product_list **p;
{
  t_product_list *q;

  while (*p != NULL) {
    q = (*p)->pointer;
    Free(*p);
    *p = q;
  }
}  /* dispose_product_list */


Static t_cell_index find_product(a, l)
long *a;
t_vertex *l;
{
  t_cell_index product;
  t_vertex v, FORLIM;

  product = 1;
  if (*l <= first_vertex)
    return product;
  FORLIM = *l;
  for (v = first_vertex; v < FORLIM; v++) {
    if (P_inset(v, a))
      product *= vertex_inf[v - MIN_VERTEX].levels;
  }
  return product;
}  /* find_product */


Static Void find_slice_products(c, vc, wc, vwc, v, w, slice_pack)
long *c, *vc, *wc, *vwc;
t_vertex *v, *w;
t_slice_pack *slice_pack;
{
  t_cell_index product_v, product_w, product_vw;
  t_vertex a, b, FORLIM;

  product_v = 1;
  product_w = 1;
  product_vw = 1;
  b = first_vertex;
  slice_pack->marginal_dimension_c = marginal_dimension(c);
  slice_pack->p_vc_v = find_product(vc, v);
  slice_pack->p_wc_w = find_product(wc, w);
  slice_pack->p_vwc_v = find_product(vwc, v);
  slice_pack->p_vwc_w = find_product(vwc, w);
  FORLIM = last_vertex;
  for (a = first_vertex; a <= FORLIM; a++) {
    if (P_inset(a, vwc)) {
      if (a != *w) {
	slice_pack->product_a_v[b - MIN_VERTEX] = product_v;
	product_v *= vertex_inf[a - MIN_VERTEX].levels;
	slice_pack->product_b_v[b - MIN_VERTEX] =
	  product_v - slice_pack->product_a_v[b - MIN_VERTEX];
      }
      if (a != *v) {
	slice_pack->product_a_w[b - MIN_VERTEX] = product_w;
	product_w *= vertex_inf[a - MIN_VERTEX].levels;
	slice_pack->product_b_w[b - MIN_VERTEX] =
	  product_w - slice_pack->product_a_w[b - MIN_VERTEX];
      }
      slice_pack->product_a_vw[b - MIN_VERTEX] = product_vw;
      product_vw *= vertex_inf[a - MIN_VERTEX].levels;
      slice_pack->product_b_vw[b - MIN_VERTEX] =
	product_vw - slice_pack->product_a_vw[b - MIN_VERTEX];
      if (a != *v && a != *w) {
	slice_pack->levels[b - MIN_VERTEX] =
	  FIRST_LEVEL + vertex_inf[a - MIN_VERTEX].levels - 1;
	b++;
      }
    }
  }
  slice_pack->levels[b - MIN_VERTEX] = _INVALID_LEVEL;
  slice_pack->l = b;
}  /* find_slice_products */


Static Void next_offset_in_slice(slice_pack, offset_v, offset_w, offset_vw, i)
t_slice_pack *slice_pack;
t_cell_index *offset_v, *offset_w, *offset_vw;
t_level *i;
{
  t_vertex v;

  v = first_vertex;
  while (i[v - MIN_VERTEX] == slice_pack->levels[v - MIN_VERTEX]) {
    *offset_v -= slice_pack->product_b_v[v - MIN_VERTEX];
    *offset_w -= slice_pack->product_b_w[v - MIN_VERTEX];
    *offset_vw -= slice_pack->product_b_vw[v - MIN_VERTEX];
    i[v - MIN_VERTEX] = FIRST_LEVEL;
    v++;
  }
  if (v >= slice_pack->l)
    return;
  *offset_v += slice_pack->product_a_v[v - MIN_VERTEX];
  *offset_w += slice_pack->product_a_w[v - MIN_VERTEX];
  *offset_vw += slice_pack->product_a_vw[v - MIN_VERTEX];
  i[v - MIN_VERTEX]++;
}  /* next_offset_in_slice */


/*@+"next1.p"*/


Static Void offset_down_in_expression_list(v, link_expression, p)
t_vertex *v;
t_expression *link_expression;
t_product_list **p;
{
  while (link_expression != NULL) {
    if (P_inset(*v, (*p)->c_in_a))
      link_expression->offset -= (*p)->prod_2[*v - MIN_VERTEX];
    *p = (*p)->pointer;
    link_expression = link_expression->pointer;
  }
}  /* offset_down_in_expression_list */


Static Void offset_down_in_ips_list(v, link_ips_list, p)
t_vertex *v;
t_list_ips_elements *link_ips_list;
t_product_list **p;
{
  while (link_ips_list != NULL) {
    if (P_inset(*v, (*p)->c_in_a))
      link_ips_list->ips_element.p_offset -= (*p)->prod_2[*v - MIN_VERTEX];
    *p = (*p)->pointer;
    link_ips_list = link_ips_list->pointer;
  }
}  /* offset_down_in_ips_list */


Static Void offset_up_in_expression_list(v, link_expression, p)
t_vertex *v;
t_expression *link_expression;
t_product_list **p;
{
  while (link_expression != NULL) {
    if (P_inset(*v, (*p)->c_in_a))
      link_expression->offset += (*p)->prod_1[*v - MIN_VERTEX];
    *p = (*p)->pointer;
    link_expression = link_expression->pointer;
  }
}  /* offset_up_in_expression_list */


Static Void offset_up_in_ips_list(v, link_ips_list, p)
t_vertex *v;
t_list_ips_elements *link_ips_list;
t_product_list **p;
{
  while (link_ips_list != NULL) {
    if (P_inset(*v, (*p)->c_in_a))
      link_ips_list->ips_element.p_offset += (*p)->prod_1[*v - MIN_VERTEX];
    *p = (*p)->pointer;
    link_ips_list = link_ips_list->pointer;
  }
}  /* offset_up_in_ips_list */


Static Void next_offset_in_exp_list(model, link_prod_list, levels, l_a_vertex,
				    i)
t_model *model;
t_product_list **link_prod_list;
long *levels;
t_vertex *l_a_vertex;
t_level *i;
{
  t_vertex v;
  t_product_list *p;

  v = first_vertex;
  while (i[v - MIN_VERTEX] == levels[v - MIN_VERTEX]) {
    p = *link_prod_list;
    offset_down_in_expression_list(&v, model->expression, &p);
    offset_down_in_ips_list(&v, model->ips_list, &p);
    i[v - MIN_VERTEX] = FIRST_LEVEL;
    v++;
  }
  if (v > *l_a_vertex)
    return;
  p = *link_prod_list;
  offset_up_in_expression_list(&v, model->expression, &p);
  offset_up_in_ips_list(&v, model->ips_list, &p);
  i[v - MIN_VERTEX]++;
}  /* next_offset_in_exp_list */


Static Void next_offset_in_exp_list_2(model_1, model_2, link_prod_list,
				      levels, l_a_vertex, i)
t_model *model_1, *model_2;
t_product_list **link_prod_list;
long *levels;
t_vertex *l_a_vertex;
t_level *i;
{
  t_vertex v;
  t_product_list *p;

  v = first_vertex;
  while (i[v - MIN_VERTEX] == levels[v - MIN_VERTEX]) {
    p = *link_prod_list;
    offset_down_in_expression_list(&v, model_1->expression, &p);
    offset_down_in_ips_list(&v, model_1->ips_list, &p);
    offset_down_in_expression_list(&v, model_2->expression, &p);
    offset_down_in_ips_list(&v, model_2->ips_list, &p);
    i[v - MIN_VERTEX] = FIRST_LEVEL;
    v++;
  }
  if (v > *l_a_vertex)
    return;
  p = *link_prod_list;
  offset_up_in_expression_list(&v, model_1->expression, &p);
  offset_up_in_ips_list(&v, model_1->ips_list, &p);
  offset_up_in_expression_list(&v, model_2->expression, &p);
  offset_up_in_ips_list(&v, model_2->ips_list, &p);
  i[v - MIN_VERTEX]++;
}  /* next_offset_in_exp_list_2 */


Static Void insert_empty_product_element(link_prod_list)
t_product_list **link_prod_list;
{
  t_product_list *p;

  p = (t_product_list *)Malloc(sizeof(t_product_list));
  if (p == NULL)
    _OutMem();
  P_setcpy(p->c_in_a, empty_set);
  p->product = 1;
  p->pointer = *link_prod_list;
  *link_prod_list = p;
}  /* insert_empty_product_element */


Static Void insert_empty_expression_product_element(link_expression,
						    link_prod_list)
t_expression *link_expression;
t_product_list **link_prod_list;
{
  while (link_expression != NULL) {
    insert_empty_product_element(link_prod_list);
    link_expression = link_expression->pointer;
  }
}  /* insert_empty_expression_product_element */


Static Void insert_empty_ips_product_element(link_ips_list, link_prod_list)
t_list_ips_elements *link_ips_list;
t_product_list **link_prod_list;
{
  while (link_ips_list != NULL) {
    insert_empty_product_element(link_prod_list);
    link_ips_list = link_ips_list->pointer;
  }
}  /* insert_empty_ips_product_element */


Static Void find_products_for_expression_list(v, w, link_expression,
					      link_prod_list)
t_vertex v, w;
t_expression *link_expression;
t_product_list **link_prod_list;
{
  t_product_list *WITH;

  while (link_expression != NULL) {
    if (P_inset(v, link_expression->vertex_set)) {
      WITH = *link_prod_list;
      P_addset(WITH->c_in_a, w);
      WITH->prod_1[w - MIN_VERTEX] = WITH->product;
      WITH->product *= vertex_inf[v - MIN_VERTEX].levels;
      WITH->prod_2[w - MIN_VERTEX] = WITH->product - WITH->prod_1[w - MIN_VERTEX];
    }
    *link_prod_list = (*link_prod_list)->pointer;
    link_expression = link_expression->pointer;
  }
}  /* find_products_for_expression_list */


Static Void find_products_for_ips_list(v, w, link_ips_list, link_prod_list)
t_vertex v, w;
t_list_ips_elements *link_ips_list;
t_product_list **link_prod_list;
{
  t_product_list *WITH;

  while (link_ips_list != NULL) {
    if (P_inset(v, link_ips_list->ips_element.a)) {
      WITH = *link_prod_list;
      P_addset(WITH->c_in_a, w);
      WITH->prod_1[w - MIN_VERTEX] = WITH->product;
      WITH->product *= vertex_inf[v - MIN_VERTEX].levels;
      WITH->prod_2[w - MIN_VERTEX] = WITH->product - WITH->prod_1[w - MIN_VERTEX];
    }
    *link_prod_list = (*link_prod_list)->pointer;
    link_ips_list = link_ips_list->pointer;
  }
}  /* find_products_for_ips_list */


Static Void find_product_list(a, model, link_prod_list, levels, l)
long *a;
t_model *model;
t_product_list **link_prod_list;
long *levels;
t_vertex *l;
{
  t_vertex v, w;
  t_product_list *p;
  t_vertex FORLIM;

  *link_prod_list = NULL;
  insert_empty_expression_product_element(model->expression, link_prod_list);
  insert_empty_ips_product_element(model->ips_list, link_prod_list);
  w = first_vertex;
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    if (P_inset(v, a)) {
      p = *link_prod_list;
      find_products_for_expression_list(v, w, model->expression, &p);
      find_products_for_ips_list(v, w, model->ips_list, &p);
      levels[w - MIN_VERTEX] = FIRST_LEVEL + vertex_inf[v - MIN_VERTEX].levels - 1;
      w++;
    }
  }
  levels[w - MIN_VERTEX] = _INVALID_LEVEL;
  *l = w - 1;
}  /* find_product_list */


Static Void find_product_list_2(a, model_1, model_2, link_prod_list, levels, l)
long *a;
t_model *model_1, *model_2;
t_product_list **link_prod_list;
long *levels;
t_vertex *l;
{
  t_vertex v, w;
  t_product_list *p;
  t_vertex FORLIM;

  *link_prod_list = NULL;
  insert_empty_expression_product_element(model_1->expression, link_prod_list);
  insert_empty_ips_product_element(model_1->ips_list, link_prod_list);
  insert_empty_expression_product_element(model_2->expression, link_prod_list);
  insert_empty_ips_product_element(model_2->ips_list, link_prod_list);
  w = first_vertex;
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    if (P_inset(v, a)) {
      p = *link_prod_list;
      find_products_for_expression_list(v, w, model_1->expression, &p);
      find_products_for_ips_list(v, w, model_1->ips_list, &p);
      find_products_for_expression_list(v, w, model_2->expression, &p);
      find_products_for_ips_list(v, w, model_2->ips_list, &p);
      levels[w - MIN_VERTEX] = FIRST_LEVEL + vertex_inf[v - MIN_VERTEX].levels - 1;
      w++;
    }
  }
  levels[w - MIN_VERTEX] = _INVALID_LEVEL;
  *l = w - 1;
}  /* find_product_list_2 */


/*@+"tree23.p"*/


Static Void find_in_2_3_tree(node, x_key, result)
t_2_3_node **node;
long x_key;
t_2_3_leaf **result;
{
  if ((*node)->node_type == leaf) {
    if ((*node)->UU.leaf_->key == x_key)
      *result = (*node)->UU.leaf_;
    else
      *result = NULL;
    return;
  }
  if (x_key < (*node)->UU.U1.lowofsecond) {
    find_in_2_3_tree(&(*node)->UU.U1.firstchild, x_key, result);
    return;
  }
  if ((*node)->UU.U1.thirdchild == NULL || x_key < (*node)->UU.U1.lowofthird)
    find_in_2_3_tree(&(*node)->UU.U1.secondchild, x_key, result);
  else
    find_in_2_3_tree(&(*node)->UU.U1.thirdchild, x_key, result);
}  /* find_in_2_3_tree */


Static Void insert_leaf_in_2_3_tree(x, a)
t_2_3_element *x;
t_2_3_leaf **a;
{
  t_part_list *p;

  (*a)->count++;
  if (x->tree_type != test_tree) {
    x->UU.offset_element->pointer = (*a)->UU.offset_list;
    (*a)->UU.offset_list = x->UU.offset_element;
    return;
  }
  p = (t_part_list *)Malloc(sizeof(t_part_list));
  if (p == NULL)
    _OutMem();
  p->pointer = (*a)->UU.test_list;
  (*a)->UU.test_list = p;
  (*a)->UU.test_list->link_test_list = x->UU.test_element;
}  /* insert_leaf_in_2_3_tree */


Static Void sub_insert_in_2_3_tree(node, x_element, min, pnew, low)
t_2_3_node **node;
t_2_3_element *x_element;
boolean *min;
t_2_3_node **pnew;
long *low;
{
  t_2_3_node *pback, *w;
  char child;

  *pnew = NULL;
  if ((*node)->node_type == leaf) {
    if ((*node)->UU.leaf_->key == x_element->key) {
      (*node)->count--;
      insert_leaf_in_2_3_tree(x_element, &(*node)->UU.leaf_);
      return;
    }
    *pnew = (t_2_3_node *)Malloc(sizeof(t_2_3_node));
    if (*pnew == NULL)
      _OutMem();
    (*pnew)->node_type = leaf;
    (*pnew)->count = -10;
    (*pnew)->UU.leaf_ = (t_2_3_leaf *)Malloc(sizeof(t_2_3_leaf));
    if ((*pnew)->UU.leaf_ == NULL)
      _OutMem();
    (*pnew)->UU.leaf_->count = 0;
    (*pnew)->UU.leaf_->tree_type = x_element->tree_type;
    if (x_element->tree_type == test_tree)
      (*pnew)->UU.leaf_->UU.test_list = NULL;
    else
      (*pnew)->UU.leaf_->UU.offset_list = NULL;
    (*pnew)->UU.leaf_->key = x_element->key;
    insert_leaf_in_2_3_tree(x_element, &(*pnew)->UU.leaf_);
    *low = x_element->key;
    return;
  }
  if (x_element->key < (*node)->UU.U1.lowofsecond) {
    child = 1;
    w = (*node)->UU.U1.firstchild;
  } else if ((*node)->UU.U1.thirdchild == NULL ||
	     x_element->key < (*node)->UU.U1.lowofthird) {
    *min = false;
    child = 2;
    w = (*node)->UU.U1.secondchild;
  } else {
    *min = false;
    child = 3;
    w = (*node)->UU.U1.thirdchild;
  }
  sub_insert_in_2_3_tree(&w, x_element, min, &pback, low);
  if (pback == NULL)
    return;
  if ((*node)->UU.U1.thirdchild == NULL) {
    if (child == 2) {
      (*node)->UU.U1.thirdchild = pback;
      (*node)->UU.U1.lowofthird = *low;
      return;
    }
    (*node)->UU.U1.thirdchild = (*node)->UU.U1.secondchild;
    (*node)->UU.U1.lowofthird = (*node)->UU.U1.lowofsecond;
    if (*min)
      *min = (pback->UU.leaf_->key < (*node)->UU.U1.firstchild->UU.leaf_->key);
    if (!*min) {
      (*node)->UU.U1.secondchild = pback;
      (*node)->UU.U1.lowofsecond = *low;
      return;
    }
    (*node)->UU.U1.secondchild = (*node)->UU.U1.firstchild;
    (*node)->UU.U1.lowofsecond = (*node)->UU.U1.firstchild->UU.leaf_->key;
    (*node)->UU.U1.firstchild = pback;
    *min = false;
    return;
  }
  *pnew = (t_2_3_node *)Malloc(sizeof(t_2_3_node));
  if (*pnew == NULL)
    _OutMem();
  (*pnew)->UU.U1.lowofsecond = -99;
  (*pnew)->UU.U1.lowofthird = -99;
  (*pnew)->node_type = interior;
  (*pnew)->count = -3;
  if (child == 3) {
    (*pnew)->UU.U1.firstchild = (*node)->UU.U1.thirdchild;
    (*pnew)->UU.U1.secondchild = pback;
    (*pnew)->UU.U1.thirdchild = NULL;
    (*pnew)->UU.U1.lowofsecond = *low;
    *low = (*node)->UU.U1.lowofthird;
    (*node)->UU.U1.thirdchild = NULL;
    return;
  }
  (*pnew)->UU.U1.secondchild = (*node)->UU.U1.thirdchild;
  (*pnew)->UU.U1.lowofsecond = (*node)->UU.U1.lowofthird;
  (*pnew)->UU.U1.thirdchild = NULL;
  (*node)->UU.U1.thirdchild = NULL;
  if (child == 2) {
    (*pnew)->UU.U1.firstchild = pback;
    return;
  }
  (*pnew)->UU.U1.firstchild = (*node)->UU.U1.secondchild;
  (*node)->UU.U1.lowofthird = *low;
  *low = (*node)->UU.U1.lowofsecond;
  if (*min)
    *min = (pback->UU.leaf_->key < (*node)->UU.U1.firstchild->UU.leaf_->key);
  if (!*min) {
    (*node)->UU.U1.secondchild = pback;
    (*node)->UU.U1.lowofsecond = (*node)->UU.U1.lowofthird;
    return;
  }
  (*node)->UU.U1.secondchild = (*node)->UU.U1.firstchild;
  (*node)->UU.U1.lowofsecond = (*node)->UU.U1.firstchild->UU.leaf_->key;
  (*node)->UU.U1.firstchild = pback;
  *min = false;
}  /* sub_insert_in_2_3_tree */


Static Void insert_in_2_3_tree(x_element, s)
t_2_3_element *x_element;
t_2_3_node **s;
{
  t_2_3_node *pback, *saves;
  t_2_3_key lowback;
  boolean min;

  min = true;
  if (*s == NULL) {
    *s = (t_2_3_node *)Malloc(sizeof(t_2_3_node));
    if (*s == NULL)
      _OutMem();
    (*s)->node_type = leaf;
    (*s)->count = -2;
    (*s)->UU.leaf_ = (t_2_3_leaf *)Malloc(sizeof(t_2_3_leaf));
    if ((*s)->UU.leaf_ == NULL)
      _OutMem();
    (*s)->UU.leaf_->count = 0;
    (*s)->UU.leaf_->tree_type = x_element->tree_type;
    if (x_element->tree_type == test_tree)
      (*s)->UU.leaf_->UU.test_list = NULL;
    else
      (*s)->UU.leaf_->UU.offset_list = NULL;
    (*s)->UU.leaf_->key = x_element->key;
    insert_leaf_in_2_3_tree(x_element, &(*s)->UU.leaf_);
    return;
  }
  sub_insert_in_2_3_tree(s, x_element, &min, &pback, &lowback);
  if (pback == NULL)
    return;
  saves = *s;
  *s = (t_2_3_node *)Malloc(sizeof(t_2_3_node));
  if (*s == NULL)
    _OutMem();
  (*s)->UU.U1.lowofsecond = -88;
  (*s)->UU.U1.lowofthird = -88;
  (*s)->node_type = interior;
  (*s)->count = -1;
  if (min)
    min = (pback->UU.leaf_->key < saves->UU.leaf_->key);
  if (min) {
    (*s)->UU.U1.firstchild = pback;
    (*s)->UU.U1.secondchild = saves;
    (*s)->UU.U1.lowofsecond = saves->UU.leaf_->key;
  } else {
    (*s)->UU.U1.firstchild = saves;
    (*s)->UU.U1.secondchild = pback;
    (*s)->UU.U1.lowofsecond = lowback;
  }
  (*s)->UU.U1.thirdchild = NULL;
}  /* insert_in_2_3_tree */


Static Void print_offset_list(p)
t_offset_list *p;
{
  write_char(stdout, '[');
  while (p != NULL) {
    print_vertex_set(p->vertex_set);
    write_char(stdout, ':');
    write_integer(stdout, p->offset, 4L);
    p = p->pointer;
  }
  write_char(stdout, ']');
}  /* print_offset_list */


Static Void visit_2_3_tree_preorder(count, a)
long count;
t_2_3_node **a;
{
  long i, TEMP;

  if (*a == NULL) {
    write_char_text(stdout, '-');
    write_line_stdout();
    return;
  }
  if ((*a)->node_type == interior) {
    write_char_text(stdout, '[');
    TEMP = 3;
    write_integer_text(stdout, (*a)->count, &TEMP);
    write_char_text(stdout, ',');
    TEMP = 5;
    write_integer_text(stdout, (*a)->UU.U1.lowofsecond, &TEMP);
    write_char_text(stdout, ',');
    TEMP = 5;
    write_integer_text(stdout, (*a)->UU.U1.lowofthird, &TEMP);
    write_char_text(stdout, ']');
    visit_2_3_tree_preorder(count + 1, &(*a)->UU.U1.firstchild);
    for (i = 1; i <= (count + 1) * 17; i++)
      write_char_stdout(' ');
    visit_2_3_tree_preorder(count + 1, &(*a)->UU.U1.secondchild);
    for (i = 1; i <= (count + 1) * 17; i++)
      write_char_stdout(' ');
    visit_2_3_tree_preorder(count + 1, &(*a)->UU.U1.thirdchild);
    return;
  }
  write_char_text(stdout, '[');
  TEMP = 3;
  write_integer_text(stdout, (*a)->count, &TEMP);
  write_char_text(stdout, ',');
  TEMP = 3;
  write_integer_text(stdout, -1L, &TEMP);
  write_char_text(stdout, ',');
  TEMP = 3;
  write_integer_text(stdout, -1L, &TEMP);
  write_char_text(stdout, ']');
  write_pch_10_text(stdout, ": ", 2L);
  TEMP = 5;
  write_integer_text(stdout, (*a)->UU.leaf_->key, &TEMP);
  write_pch_10_text(stdout, ": ", 2L);
  TEMP = 5;
  write_integer_text(stdout, (*a)->UU.leaf_->count, &TEMP);
  if ((*a)->UU.leaf_->tree_type != test_tree)
    print_offset_list((*a)->UU.leaf_->UU.offset_list);
  write_line_stdout();
}  /* visit_2_3_tree_preorder */


Static Void insert_test_in_2_3_tree(x, key)
t_test_list **x;
long *key;
{
  t_2_3_element element;
  long TEMP;

  /*$ifdef TRACE*/
  if (boolean_option[2]) {
    write_pch_30_text(stdout, " ## insert_test_in_2_3_tree:", 28L);
    TEMP = 8;
    write_integer_text(stdout, *key, &TEMP);
    write_line_stdout();
  }
  /*$endif TRACE*/
  element.tree_type = test_tree;
  element.UU.test_element = *x;
  element.key = *key;
  insert_in_2_3_tree(&element, &test_2_3_tree);
}  /* insert_test_in_2_3_tree */


Static Void insert_test(p, test)
t_test_list **p;
t_test *test;
{
  *p = (t_test_list *)Malloc(sizeof(t_test_list));
  if (*p == NULL)
    _OutMem();
  (*p)->test = *test;
  (*p)->pointer = link_test_list;
  link_test_list = *p;
  if (c_factorizes != 1)
    insert_test_in_2_3_tree(p, &test->paritet);
}  /* insert_test */


Static Void find_test_in_2_3_tree(key, p)
long *key;
t_part_list **p;
{
  t_2_3_leaf *result;
  long TEMP;

  /*$ifdef TRACE*/
  if (boolean_option[2]) {
    write_pch_30_text(stdout, " ## find_test_in_2_3_tree:", 26L);
    TEMP = 8;
    write_integer_text(stdout, *key, &TEMP);
    write_line_stdout();
    visit_2_3_tree_preorder(0L, &test_2_3_tree);
  }
  /*$endif TRACE*/
  *p = NULL;
  if (test_2_3_tree != NULL) {
    find_in_2_3_tree(&test_2_3_tree, *key, &result);
    if (result != NULL)
      *p = result->UU.test_list;
  }
  /*$ifdef TRACE*/
  if (!boolean_option[2])
    return;
  /*$endif TRACE*/
  if (*p == NULL)
    write_pch_20_text(stdout, " <> not found <> ", 17L);
  else {
    write_pch_10_text(stdout, "<> found", 8L);
    write_line_stdout();
  }
}  /* find_test_in_2_3_tree */


#define max_par         65536L


Static long offset_key(a)
long *a;
{
  t_long_integer sum, product;
  t_vertex v, FORLIM;

  if (dimension != 0) {
    sum = 1;
    product = 1;
    FORLIM = last_vertex;
    for (v = first_vertex; v <= FORLIM; v++) {
      if (P_inset(v, a))
	sum = (sum + product) % (max_par / dimension);
      if (product * 2 >= max_par / dimension)
	product = 1;
      else
	product *= 2;
    }
    return (cardinality(a) * (max_par / dimension) + sum);
  } else
    return 0;
}  /* offset_key */

#undef max_par


Static Void insert_offset(a, a_offset, local_offset_list)
long *a;
t_offset a_offset;
t_offset_list **local_offset_list;
{
  t_offset_list *p;

  p = (t_offset_list *)Malloc(sizeof(t_offset_list));
  if (p == NULL)
    _OutMem();
  p->offset = a_offset;
  P_setcpy(p->vertex_set, a);
  p->pointer = *local_offset_list;
  *local_offset_list = p;
}  /* insert_offset */


Static Void insert_offset_in_2_3_tree(a, x)
long *a;
t_offset *x;
{
  t_2_3_element element;
  long TEMP;

  /*$ifdef TRACE*/
  if (boolean_option[1]) {
    write_pch_30_text(stdout, " ## insert_offset_in_2_3_tree:", 30L);
    TEMP = 8;
    write_integer_text(stdout, offset_key(a), &TEMP);
    write_line_stdout();
    print_vertex_set(a);
  }
  /*$endif TRACE*/
  element.tree_type = offset_tree;
  element.UU.offset_element = NULL;
  insert_offset(a, *x, &element.UU.offset_element);
  element.key = offset_key(a);
  insert_in_2_3_tree(&element, &offset_2_3_tree);
}  /* insert_offset_in_2_3_tree */


Static Void insert_offset_in_both(a, a_offset)
long *a;
t_offset a_offset;
{
  if (c_factorizes != 1)
    insert_offset_in_2_3_tree(a, &a_offset);
  else
    insert_offset(a, a_offset, &link_offset_list);
}  /* insert_offset_in_both */


Static Void find_offset_in_2_3_tree(a, p)
long *a;
t_offset_list **p;
{
  t_2_3_leaf *result;
  long TEMP;

  /*$ifdef TRACE*/
  if (boolean_option[1]) {
    write_pch_30_text(stdout, " ## find_offset_in_2_3_tree:", 28L);
    TEMP = 8;
    write_integer_text(stdout, offset_key(a), &TEMP);
    print_vertex_set(a);
    write_line_stdout();
    visit_2_3_tree_preorder(0L, &offset_2_3_tree);
  }
  /*$endif TRACE*/
  *p = NULL;
  if (offset_2_3_tree != NULL) {
    find_in_2_3_tree(&offset_2_3_tree, offset_key(a), &result);
    if (result != NULL)
      *p = result->UU.offset_list;
  }
  /*$ifdef TRACE*/
  if (!boolean_option[1])
    return;
  if (*p == NULL) {
    write_pch_20_text(stdout, " <> not found <> ", 17L);
    return;
  }
  write_pch_10_text(stdout, "<> found", 8L);
  write_line_stdout();
  print_offset_list(*p);
  write_line_stdout();

  /*$endif TRACE*/
}  /* find_offset_in_2_3_tree */


/*@+"margall.p"*/


Static Void invers_offset_hash(offset_index, v_set)
t_offset_index offset_index;
long *v_set;
{
  short sum;
  t_vertex v, FORLIM;

  P_setcpy(v_set, empty_set);
  sum = offset_index - 1;
  FORLIM = first_vertex;
  for (v = last_vertex; v >= FORLIM; v--) {
    if (sum >= (long)floor(exp(log(2.0) * (v - first_vertex)) + 0.5)) {
      P_addset(v_set, v);
      sum -= (long)floor(exp(log(2.0) * (v - first_vertex)) + 0.5);
    }
  }
}  /* invers_offset_hash */


Static Void find_all_marginals(ok)
boolean *ok;
{
  t_cell i;
  t_vertex_set vertex_set[MAX_OFFSET_CELL_NUMBER];
  t_offset_index g_set_nr, set_nr_1, set_nr_2, card;
  t_cell_index number_of_tables, offset_index, index, m_index, a, g_size,
	       g_size_2;
  t_vertex_set g_set, set_1, set_2, c_in_a;
  t_long_integer marg_dim_delta;
  t_vertex l_a_vertex;
  t_v_arr_of_integer prod_1, prod_2, levels;
  t_cell_index FORLIM2;

  a = fna;
  number_of_tables = (long)floor(exp(log(2.0) * dimension) + 0.5);
  for (g_set_nr = 2; g_set_nr < number_of_tables; g_set_nr++) {
    invers_offset_hash(g_set_nr, vertex_set[g_set_nr - 1]);
    offset[g_set_nr - 1] = a;
    a += marginal_dimension(vertex_set[g_set_nr - 1]);
  }
  P_setcpy(vertex_set[number_of_tables - 1], delta);
  if (!TURBO_PC)
    *ok = space_in_n_array(a, 0L);
  if (a > max_cell_number) {
    *ok = false;
    return;
  }
  if (!sorted) {
    *ok = true;
    for (index = FIRST_INDEX + fna; index <= FIRST_INDEX + a; index++)
      n[index] = 0;
    memcpy(i, first_cell, sizeof(t_cell));
    fna = a;
    marg_dim_delta = marginal_dimension(delta);
    for (offset_index = 1; offset_index <= number_of_tables - 2; offset_index++) {
      find_products(delta, vertex_set[offset_index], c_in_a, prod_1, prod_2,
		    levels, &l_a_vertex);
      m_index = offset[offset_index];
      for (index = N_START; index < N_START + marg_dim_delta; index++) {
	n[m_index] += n[index];
	next_c_offset_in_a(c_in_a, &m_index, prod_1, prod_2, levels,
			   &l_a_vertex, i);
      }
    }
    return;
  }
  *ok = true;
  for (index = FIRST_INDEX + fna; index <= FIRST_INDEX + a; index++)
    n[index] = 0;
  memcpy(i, first_cell, sizeof(t_cell));
  fna = a;
  for (card = cardinality(delta) - 1; card >= 1; card--) {
    for (set_nr_1 = 2; set_nr_1 < number_of_tables; set_nr_1++) {
      P_setcpy(set_1, vertex_set[set_nr_1 - 1]);
      if (card == cardinality(set_1)) {
	P_setcpy(g_set, delta);
	g_set_nr = number_of_tables;
	g_size = marginal_dimension(delta);
	for (set_nr_2 = 2; set_nr_2 < number_of_tables; set_nr_2++) {
	  P_setcpy(set_2, vertex_set[set_nr_2 - 1]);
	  g_size_2 = marginal_dimension(set_2);
	  if (P_subset(set_1, set_2) && g_size_2 < g_size &&
	      set_nr_1 != set_nr_2) {
	    P_setcpy(g_set, set_2);
	    g_set_nr = set_nr_2;
	    g_size = g_size_2;
	  }
	}
	find_products(g_set, set_1, c_in_a, prod_1, prod_2, levels,
		      &l_a_vertex);
	m_index = offset[set_nr_1 - 1];
	FORLIM2 = offset[g_set_nr - 1] + g_size;
	for (index = offset[g_set_nr - 1]; index < FORLIM2; index++) {
	  n[m_index] += n[index];
	  next_c_offset_in_a(c_in_a, &m_index, prod_1, prod_2, levels,
			     &l_a_vertex, i);
	}
      }
    }
  }
}  /* find_all_marginals */


/*@+"margnec.p"*/


Static Void visit_marginals(a, p, b, g, size_of_a, size_of_g, g_offset)
long *a;
t_offset_list *p;
boolean *b;
long *g;
t_cell_index *size_of_a, *size_of_g;
t_offset *g_offset;
{
  t_cell_index size_of_g0;
  t_vertex_set g0;

  while (p != NULL && *b && *size_of_a * 2 < *size_of_g) {
    P_setcpy(g0, p->vertex_set);
    if (P_setequal(a, g0)) {
      *g_offset = p->offset;
      *b = false;
      continue;
    }
    size_of_g0 = marginal_dimension(g0);
    if (P_subset(a, g0) && size_of_g0 < *size_of_g) {
      P_setcpy(g, g0);
      *g_offset = p->offset;
      *size_of_g = size_of_g0;
    }
    p = p->pointer;
  }
}  /* visit_marginals */


/* Local variables for found_marginal: */
struct LOC_found_marginal {
  long *a, *g0;
  t_offset *g_offset;
  boolean b;
  t_cell_index size_of_a, size_of_g;
} ;

Local Void visit_marginals_in_2_3_tree(x_key, tree, LINK)
long x_key;
t_2_3_node **tree;
struct LOC_found_marginal *LINK;
{
  if (*tree == NULL)
    return;
  if ((*tree)->node_type != interior) {
    visit_marginals(LINK->a, (*tree)->UU.leaf_->UU.offset_list, &LINK->b,
		    LINK->g0, &LINK->size_of_a, &LINK->size_of_g,
		    LINK->g_offset);
    return;
  }
  if (x_key < (*tree)->UU.U1.lowofsecond)
    visit_marginals_in_2_3_tree(x_key, &(*tree)->UU.U1.firstchild, LINK);
  if ((*tree)->UU.U1.thirdchild == NULL || x_key < (*tree)->UU.U1.lowofthird)
    visit_marginals_in_2_3_tree(x_key, &(*tree)->UU.U1.secondchild, LINK);
  visit_marginals_in_2_3_tree(x_key, &(*tree)->UU.U1.thirdchild, LINK);
}  /* visit_marginals_in_2_3_tree */


Static boolean found_marginal(a_, tmp_marginals, g0_, g_offset_)
long *a_;
t_offset_list **tmp_marginals;
long *g0_;
t_offset *g_offset_;
{
  struct LOC_found_marginal Local_Var;
  t_offset_list *p;

  Local_Var.a = a_;
  Local_Var.g0 = g0_;
  Local_Var.g_offset = g_offset_;
  Local_Var.b = true;
  if (c_factorizes != 1) {
    find_offset_in_2_3_tree(Local_Var.a, &p);
    while (p != NULL && Local_Var.b) {
      if (P_setequal(Local_Var.a, p->vertex_set)) {
	*Local_Var.g_offset = p->offset;
	Local_Var.b = false;
      } else
	p = p->pointer;
    }
  }
  if (!Local_Var.b)
    return (!Local_Var.b);
  P_setcpy(Local_Var.g0, delta);
  *Local_Var.g_offset = N_START - FIRST_INDEX;
  if (datastructure == necessary)
    Local_Var.size_of_g = number_of_cells;
  else
    Local_Var.size_of_g = max_cell_number;
  Local_Var.size_of_a = marginal_dimension(Local_Var.a);
  visit_marginals(Local_Var.a, *tmp_marginals, &Local_Var.b, Local_Var.g0,
		  &Local_Var.size_of_a, &Local_Var.size_of_g,
		  Local_Var.g_offset);
  if (!Local_Var.b)
    return (!Local_Var.b);
  if (c_factorizes != 1)
    visit_marginals_in_2_3_tree(offset_key(Local_Var.a), &offset_2_3_tree,
				&Local_Var);
  else
    visit_marginals(Local_Var.a, link_offset_list, &Local_Var.b, Local_Var.g0,
		    &Local_Var.size_of_a, &Local_Var.size_of_g,
		    Local_Var.g_offset);
  return (!Local_Var.b);
}  /* found_marginal */


Static Void find_the_marginal(a, g, g_offset)
long *a, *g;
t_offset *g_offset;
{
  t_cell_index index, m_index;
  t_long_integer case_number;
  t_cell i;
  t_vertex v;
  t_vertex_set c_in_a;
  t_vertex l_a_vertex;
  t_v_arr_of_integer prod_1, prod_2, levels;
  t_case_list *p_case_list;
  t_cell_index FORLIM;
  long FORLIM1;
  t_vertex FORLIM2;

  memcpy(i, first_cell, sizeof(t_cell));
  FORLIM = fna + last_index(a);
  for (m_index = fna; m_index <= FORLIM; m_index++)
    n[m_index] = 0;
  if (case_list != NULL && P_setequal(g, delta) && datastructure == list_file) {
    p_case_list = case_list;
    FORLIM1 = n[0];
    for (case_number = 1; case_number <= FORLIM1; case_number++) {
      m_index = fna + marginal_hash(a, p_case_list->cell);
      p_case_list = p_case_list->pointer;
      n[m_index]++;
    }
    return;
  }
  if (datastructure == list_file && P_setequal(g, delta) && !exclude_missing) {
    reset_level_file(file_read);
    FORLIM1 = n[0];
    for (case_number = 1; case_number <= FORLIM1; case_number++) {
      FORLIM2 = last_vertex;
      for (v = first_vertex; v <= FORLIM2; v++)
	read_level_file(file_read, &i[v - MIN_VERTEX]);
      m_index = fna + marginal_hash(a, i);
      n[m_index]++;
    }
    return;
  }
  if (datastructure == list_file && P_setequal(g, delta) && exclude_missing) {
    reset_level_file(file_excluded);
    FORLIM1 = n[0];
    for (case_number = 1; case_number <= FORLIM1; case_number++) {
      FORLIM2 = last_vertex;
      for (v = first_vertex; v <= FORLIM2; v++) {
	if (P_inset(v, delta_missing_excluded))
	  read_level_file(file_excluded, &i[v - MIN_VERTEX]);
      }
      m_index = fna + marginal_hash(a, i);
      n[m_index]++;
    }
    return;
  }
  find_products(g, a, c_in_a, prod_1, prod_2, levels, &l_a_vertex);
  m_index = fna;
  FORLIM = *g_offset + last_index(g);
  for (index = *g_offset; index <= FORLIM; index++) {
    n[m_index] += n[index];
    next_c_offset_in_a(c_in_a, &m_index, prod_1, prod_2, levels, &l_a_vertex,
		       i);
  }
}  /* find_the_marginal */


Static t_offset sub_find_marginal(a, tmp_marginals, use_temporary, ok)
long *a;
t_offset_list **tmp_marginals;
boolean use_temporary, *ok;
{
  t_offset Result, g_offset;
  t_long_integer off;
  t_vertex_set g;

  if (em)
    write_warning(stdout, "1: CoCo should not be here when EM used.", 40L);
  if ((!TURBO_PC) & (marginal_dimension(a) < INFINITY))
    *ok = space_in_n_array(marginal_dimension(a), 0L);
  if (marginal_dimension(a) > max_cell_number) {
    *ok = false;
    return 0;
  }
  *ok = true;
  if (found_marginal(a, tmp_marginals, g, &g_offset))
    return g_offset;
  Result = fna;
  off = fna + marginal_dimension(a);
  if (trace) {
    write_pch(stdout, " Marginal:", 10L);
    write_integer(stdout, off, 5L);
    write_line(stdout);
  }
  if (!TURBO_PC)
    *ok = space_in_n_array(off, 0L);
  if (off > max_cell_number) {
    *ok = false;
    return Result;
  }
  if (use_temporary)
    insert_offset(a, fna, tmp_marginals);
  else
    insert_offset_in_both(a, fna);
  find_the_marginal(a, g, &g_offset);
  fna = off;
  return Result;
}  /* sub_find_marginal */


Static t_offset find_marginal(a, ok)
long *a;
boolean *ok;
{
  t_offset_list *p;

  p = NULL;
  return (sub_find_marginal(a, &p, false, ok));
}  /* find_marginal */


Static Void insert_set_in_list_of_marginals_to_find(a, set_list)
long *a;
t_set_list **set_list;
{
  t_set_list *p, *q;
  t_long_integer card_a;
  boolean b;

  if (*set_list == NULL) {
    insert_set_in_set_list(a, set_list);
    return;
  }
  card_a = cardinality(a);
  b = true;
  p = *set_list;
  q = p;
  if (P_setequal(a, p->vertex_set))
    b = false;
  else if (cardinality(p->vertex_set) <= card_a) {
    insert_set_in_set_list(a, set_list);
    b = false;
  } else
    p = p->pointer;
  while (p != NULL && b) {
    if (P_setequal(a, p->vertex_set)) {
      b = false;
      break;
    }
    if (cardinality(p->vertex_set) <= card_a) {
      insert_set_in_set_list(a, &p);
      q->pointer = p;
      b = false;
    } else {
      q = p;
      p = p->pointer;
    }
  }
  if (p == NULL) {
    insert_set_in_set_list(a, &p);
    q->pointer = p;
  }
}  /* insert_set_in_list_of_marginals_to_find */


Static Void find_list_of_marginals(p, ok)
t_set_list **p;
boolean *ok;
{
  t_set_list *q;
  t_long_integer dummy;

  *ok = true;
  while (*p != NULL && *ok) {
    q = (*p)->pointer;
    dummy = find_marginal((*p)->vertex_set, ok);
    Free(*p);
    *p = q;
  }
  if (!*ok)
    dispose_set_list(p);
}  /* find_list_of_marginals */


/*@+"margdis.p"*/


Static Void dispose_marginals()
{
  t_model_list *link_model;

  link_model = link_model_list;
  while (link_model != NULL) {
    link_model->model.found_ps = false;
    link_model = link_model->pointer;
  }
  dispose_offsets();
  if (datastructure == necessary) {
    if (exclude_missing) {
      insert_offset_in_both(delta_missing_excluded,
			    N_START - FIRST_INDEX + number_of_cells);
      fna = N_START - FIRST_INDEX + number_of_cells +
	    marginal_dimension(delta_missing_excluded);
    } else {
      insert_offset_in_both(delta, (long)(N_START - FIRST_INDEX));
      fna = N_START - FIRST_INDEX + number_of_cells;
    }
  } else if (datastructure == list_file)
    fna = N_START - FIRST_INDEX;
  insert_offset_in_both(empty_set, (long)(-FIRST_INDEX));
}  /* dispose_marginals */


Static Void dispose_tmp_marginals(tmp_marginals, tmp_fna)
t_offset_list **tmp_marginals;
t_cell_index *tmp_fna;
{
  t_offset_list *q;

  if (datastructure != all &&
      (fna * 2 > max_cell_number || (fna - *tmp_fna) * 4 > max_cell_number)) {
    dispose_offset_list(tmp_marginals);
    if (link_offset_list == NULL && offset_2_3_tree == NULL)
      dispose_marginals();
    else
      fna = *tmp_fna;
    return;
  }
  q = *tmp_marginals;
  while (q != NULL) {
    insert_offset_in_both(q->vertex_set, q->offset);
    q = q->pointer;
  }
  dispose_offset_list(tmp_marginals);
}  /* dispose_tmp_marginals */


Static Void dispose_marginals_cond()
{
  if (datastructure != all && fna * 2 > max_cell_number)
    dispose_marginals();
}  /* dispose_marginals_cond */


Static Void conditional_dispose_both_marginals(tmp_marginals)
t_offset_list **tmp_marginals;
{
  if (datastructure != all && fna * 2 > max_cell_number) {
    dispose_marginals();
    dispose_offset_list(tmp_marginals);
  }
}  /* conditional_dispose_both_marginals */


/*@+"exclude.p"*/


Static t_cell_index hash_total(i)
t_level *i;
{
  t_cell_index sum, product;
  t_vertex v, FORLIM;

  sum = FIRST_INDEX;
  product = 1;
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    sum += (i[v - MIN_VERTEX] - FIRST_LEVEL) * product;
    product *= vertex_inf[v - MIN_VERTEX].levels_total;
  }
  return sum;
}  /* hash_total */


Static Void do_exclude(a)
long *a;
{
  t_model_list *link_model;
  t_cell_index index, m_index, off;
  t_cell_count n_cell;
  t_cell i;
  t_vertex v;
  t_long_integer number_of_cases;
  boolean ok;
  t_case_list *p_case_list;
  t_vertex FORLIM;
  _REC_t_vertex_inf *WITH;
  t_cell_index FORLIM1;

  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    WITH = &vertex_inf[v - MIN_VERTEX];
    if (P_inset(v, a))
      WITH->levels = WITH->levels_total - WITH->levels_missing;
    else
      WITH->levels = WITH->levels_total;
    last_cell[v - MIN_VERTEX] = FIRST_LEVEL + vertex_inf[v - MIN_VERTEX].levels - 1;
  }
  link_model = link_model_list;
  off = N_START - FIRST_INDEX + number_of_cells;
  P_setcpy(delta_missing_excluded, a);
  while (link_model != NULL) {
    link_model->model.found_ps = false;
    link_model->model.found_log_l = false;
    link_model = link_model->pointer;
  }
  dispose_offsets();
  if (datastructure == necessary)
    insert_offset_in_both(delta_missing_excluded, off);
  insert_offset_in_both(empty_set, (long)(-FIRST_INDEX));
  if (datastructure == necessary) {
    fna = N_START - FIRST_INDEX + number_of_cells +
	  marginal_dimension(delta_missing_excluded);
    FORLIM1 = off + last_index(a);
    for (index = off; index <= FORLIM1; index++)
      n[index] = 0;
    n[0] = 0;
    memcpy(i, first_cell, sizeof(t_cell));
    FORLIM1 = marginal_dimension(delta);
    for (index = 1; index <= FORLIM1; index++) {
      m_index = off + marginal_hash(a, i);
      n_cell = n[N_START - FIRST_INDEX + hash_total(i)];
      n[0] += n_cell;
      n[m_index] += n_cell;
      next_cell(i);
    }
    return;
  }
  if (case_list_read != NULL) {
    fna = N_START - FIRST_INDEX;
    number_of_cases = 0;
    dispose_case_list(&case_list_excluded);
    case_list = case_list_read;
    while (case_list != NULL) {
      ok = true;
      FORLIM = last_vertex;
      for (v = first_vertex; v <= FORLIM; v++) {
	if (P_inset(v, delta_missing_excluded))
	  ok = (ok && case_list->cell[v - MIN_VERTEX] <
		      FIRST_LEVEL + vertex_inf[v - MIN_VERTEX].levels);
      }
      if (ok) {
	p_case_list = (t_case_list *)Malloc(sizeof(t_case_list));
	if (p_case_list == NULL)
	  _OutMem();
	p_case_list->pointer = case_list_excluded;
	memcpy(p_case_list->cell, case_list->cell, sizeof(t_cell));
	case_list_excluded = p_case_list;
	number_of_cases++;
      }
      case_list = case_list->pointer;
    }
    n[0] = number_of_cases;
    case_list = case_list_excluded;
    return;
  }
  fna = N_START - FIRST_INDEX;
  number_of_cases = 0;
  reset_level_file(file_read);
  reassign_tmp_level_file_write(&file_excluded, file_name_excluded);
  rewrite_level_file(file_excluded);
  while (!eof_level_file(file_read)) {
    FORLIM = last_vertex;
    for (v = first_vertex; v <= FORLIM; v++)
      read_level_file(file_read, &i[v - MIN_VERTEX]);
    ok = true;
    FORLIM = last_vertex;
    for (v = first_vertex; v <= FORLIM; v++) {
      if (P_inset(v, delta_missing_excluded))
	ok = (ok && i[v - MIN_VERTEX] <
		    FIRST_LEVEL + vertex_inf[v - MIN_VERTEX].levels);
    }
    if (ok) {
      FORLIM = last_vertex;
      for (v = first_vertex; v <= FORLIM; v++) {
	if (P_inset(v, delta_missing_excluded))
	  write_level_file(file_excluded, i[v - MIN_VERTEX]);
      }
      number_of_cases++;
    }
  }
  n[0] = number_of_cases;
}  /* do_exclude */


Static Void print_n_total_exclude(g, short_test_output, write_models, n_total,
				  dept)
long *g;
boolean *short_test_output, *write_models;
long n_total, dept;
{
  if (*short_test_output) {
    if (*write_models) {
      write_space(stdout, 2L);
      print_vertex_set(g);
      if (!long_names)
	write_space(stdout, dimension - cardinality(g));
    }
    write_space(stdout, 1L);
    write_integer(stdout, n_total, 7L);
    return;
  }
  write_space(stdout, dept + 1);
  write_pch(stdout, "Number of complete observations in marginal table ",
	      50L);
  print_vertex_set(g);
  if (!long_names)
    write_space(stdout, (dimension - cardinality(g)) % 10);
  write_pch(stdout, ": ", 2L);
  write_integer(stdout, n_total, width);
  write_line(stdout);
}  /* print_n_total_exclude */


Static Void print_do_exclude(g, short_test_output, write_models, dept)
long *g;
boolean *short_test_output, *write_models;
long dept;
{
  if (graph_mode || !exclude_missing)
    return;
  if (!P_setequal(g, delta_missing_excluded))
    do_exclude(g);
  if (!just)
    print_n_total_exclude(g, short_test_output, write_models, n[0], dept);
}  /* print_do_exclude */


/*@+"retoff.p"*/


Static t_offset_index offset_hash(a)
long *a;
{
  t_offset_index sum, product;
  t_vertex v, FORLIM;

  sum = 1;
  product = 1;
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    if (P_inset(v, a))
      sum += product;
    product *= 2;
  }
  return sum;
}  /* offset_hash */


Static t_offset return_offset(a, ok)
long *a;
boolean *ok;
{
  if (em)
    write_warning(stdout, "1: CoCo should not be here when EM used.", 40L);
  if (datastructure == all) {
    *ok = true;
    /*$ifdef TRACE*/
    if (boolean_option[28]) {
      write_integer(stdout, offset[offset_hash(a) - 1], 8L);
      write_line(stdout);
    }
    /*$endif TRACE*/
    return (offset[offset_hash(a) - 1]);
  } else
    return (find_marginal(a, ok));
}  /* return_offset */


/*@-"graph.c"*/
/*@+"rmcsh.p"*/


Static Void revers_offset_list(p)
t_offset_list **p;
{
  t_offset_list *hp1, *hp2;

  hp1 = NULL;
  while (*p != NULL) {
    hp2 = hp1;
    hp1 = *p;
    *p = (*p)->pointer;
    hp1->pointer = hp2;
  }
  *p = hp1;
}  /* revers_offset_list */


Static Void delete_node_in_adjacency_matrix(matrix, link_node)
t_adjacency_matrix *matrix;
t_am_node **link_node;
{
  if ((*link_node)->node_type == first) {
    matrix->vertex_list[(*link_node)->UU.vertex - MIN_VERTEX] = (*link_node)->
								forward_link;
    if ((*link_node)->forward_link != NULL) {
      (*link_node)->forward_link->node_type = first;
      (*link_node)->forward_link->UU.vertex = (*link_node)->UU.vertex;
    }
  } else {
    if ((*link_node)->forward_link != NULL)
      (*link_node)->forward_link->UU.backward_link = (*link_node)->UU.backward_link;
    (*link_node)->UU.backward_link->forward_link = (*link_node)->forward_link;
  }
  Free(*link_node);
}  /* delete_node_in_adjacency_matrix */


Static Void delete_edge_in_adjacency_matrix(matrix, link_edge)
t_adjacency_matrix *matrix;
t_am_edge_list *link_edge;
{
  t_am_node_ref *p, *q;

  p = link_edge->nodes;
  while (p != NULL) {
    delete_node_in_adjacency_matrix(matrix, &p->node);
    q = p;
    p = p->pointer;
    Free(q);
  }
  if (link_edge->forward_link != NULL)
    link_edge->forward_link->backward_link = link_edge->backward_link;
  if (link_edge->backward_link != NULL)
    link_edge->backward_link->forward_link = link_edge->forward_link;
  else
    matrix->am_edge_list = link_edge->forward_link;
  Free(link_edge);
}  /* delete_edge_in_adjacency_matrix */


Static Void return_and_delete_edges_with_vertex(matrix, v, edges)
t_adjacency_matrix *matrix;
t_vertex v;
t_set_list **edges;
{
  while (matrix->vertex_list[v - MIN_VERTEX] != NULL) {
    insert_set_in_set_list(matrix->vertex_list[v - MIN_VERTEX]->link_edge->
			   vertex_set, edges);
    delete_edge_in_adjacency_matrix(matrix,
      matrix->vertex_list[v - MIN_VERTEX]->link_edge);
  }
}  /* return_and_delete_edges_with_vertex */


Static Void return_and_delete_edges_with_vertices(matrix, a, edges)
t_adjacency_matrix *matrix;
long *a;
t_set_list **edges;
{
  t_vertex v, FORLIM;

  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    if (P_inset(v, a))
      return_and_delete_edges_with_vertex(matrix, v, edges);
  }
}  /* return_and_delete_edges_with_vertices */


Static Void insert_edge_in_adjacency_matrix(matrix, edge)
t_adjacency_matrix *matrix;
long *edge;
{
  t_vertex v;
  t_am_edge_list *p_edge;
  t_am_node *p_node;
  t_am_node_ref *p_ref;
  t_vertex FORLIM;

  if (P_setequal(edge, empty_set))
    return;
  p_edge = (t_am_edge_list *)Malloc(sizeof(t_am_edge_list));
  if (p_edge == NULL)
    _OutMem();
  P_setcpy(p_edge->vertex_set, edge);
  p_edge->nodes = NULL;
  p_edge->forward_link = matrix->am_edge_list;
  p_edge->backward_link = NULL;
  if (matrix->am_edge_list != NULL)
    matrix->am_edge_list->backward_link = p_edge;
  matrix->am_edge_list = p_edge;
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    if (P_inset(v, edge)) {
      p_node = (t_am_node *)Malloc(sizeof(t_am_node));
      if (p_node == NULL)
	_OutMem();
      if (matrix->vertex_list[v - MIN_VERTEX] != NULL) {
	matrix->vertex_list[v - MIN_VERTEX]->node_type = not_first;
	matrix->vertex_list[v - MIN_VERTEX]->UU.backward_link = p_node;
      }
      p_node->node_type = first;
      p_node->UU.vertex = v;
      p_node->forward_link = matrix->vertex_list[v - MIN_VERTEX];
      p_node->link_edge = p_edge;
      matrix->vertex_list[v - MIN_VERTEX] = p_node;
      p_ref = (t_am_node_ref *)Malloc(sizeof(t_am_node_ref));
      if (p_ref == NULL)
	_OutMem();
      p_ref->node = matrix->vertex_list[v - MIN_VERTEX];
      p_ref->pointer = matrix->am_edge_list->nodes;
      matrix->am_edge_list->nodes = p_ref;
    }
  }
}  /* insert_edge_in_adjacency_matrix */


Static Void insert_edges_in_adjacency_matrix(matrix, edges)
t_adjacency_matrix *matrix;
t_set_list *edges;
{
  while (edges != NULL) {
    insert_edge_in_adjacency_matrix(matrix, edges->vertex_set);
    edges = edges->pointer;
  }
}  /* insert_edges_in_adjacency_matrix */


Static Void new_adjacency_matrix(matrix)
t_adjacency_matrix *matrix;
{
  t_vertex v, FORLIM;

  matrix->am_edge_list = NULL;
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++)
    matrix->vertex_list[v - MIN_VERTEX] = NULL;
}  /* new_adjacency_matrix */


Static Void create_adjacency_matrix(matrix, edges)
t_adjacency_matrix *matrix;
t_set_list *edges;
{
  new_adjacency_matrix(matrix);
  insert_edges_in_adjacency_matrix(matrix, edges);
}  /* create_adjacency_matrix */


Static Void delete_edges_with_vertex(matrix, v)
t_adjacency_matrix *matrix;
t_vertex *v;
{
  t_set_list *g_c_a;

  g_c_a = NULL;
  return_and_delete_edges_with_vertex(matrix, *v, &g_c_a);
  dispose_set_list(&g_c_a);
}  /* delete_edges_with_vertex */


Static Void delete_edges_with_vertices(matrix, a)
t_adjacency_matrix *matrix;
long *a;
{
  t_set_list *g_c_a;

  g_c_a = NULL;
  return_and_delete_edges_with_vertices(matrix, a, &g_c_a);
  dispose_set_list(&g_c_a);
}  /* delete_edges_with_vertices */


/* Local variables for restricted_maximim_cardinality_search_on_hypergraph: */
struct LOC_restricted_maximim_cardinality_search_on_hypergraph {
  t_adjacency_matrix *matrix_gc;
  boolean *no_exhausted_edges;
  short *alpha, *beta;
  t_vertex *invers_order;
  t_offset_list **r;
  t_0_max_dimension i;
  t_am_edge_list *s;
  t_offset_list *q;
} ;

Local Void init_sets(s, sets, LINK)
t_am_edge_list *s;
t_hyper_set_list **sets;
struct LOC_restricted_maximim_cardinality_search_on_hypergraph *LINK;
{
  t_hyper_set_node *set_node;

  *sets = (t_hyper_set_list *)Malloc(sizeof(t_hyper_set_list));
  if (*sets == NULL)
    _OutMem();
  (*sets)->forward_link = NULL;
  (*sets)->backward_link = NULL;
  (*sets)->node = NULL;
  while (s != NULL) {
    set_node = (t_hyper_set_node *)Malloc(sizeof(t_hyper_set_node));
    if (set_node == NULL)
      _OutMem();
    set_node->link_edge = s;
    set_node->hyper_set = *sets;
    s->beta = -1;
    s->gamma = -1;
    s->size = 0;
    s->card = cardinality(s->vertex_set);
    s->hyper_set_node = set_node;
    if ((*sets)->node != NULL) {
      set_node->forward_link = (*sets)->node;
      (*sets)->node->backward_link = set_node;
    } else
      set_node->forward_link = NULL;
    set_node->backward_link = NULL;
    (*sets)->node = set_node;
    s = s->forward_link;
  }
}  /* init_sets */

Local Void delete_node(sets, s, LINK)
t_hyper_set_list **sets;
t_am_edge_list **s;
struct LOC_restricted_maximim_cardinality_search_on_hypergraph *LINK;
{
  t_hyper_set_node *set_node;

  set_node = (*sets)->node;
  *s = set_node->link_edge;
  if (set_node->forward_link != NULL)
    set_node->forward_link->backward_link = NULL;
  (*sets)->node = set_node->forward_link;
  Free(set_node);
  /*$ifdef TRACE*/
  if (!boolean_option[6])
    return;
  /*$endif TRACE*/
  write_char_n_text(stdout, '*', 50L);
  write_line(stdout);
  print_vertex_set((*s)->vertex_set);
  write_line(stdout);
  write_char_n_text(stdout, '*', 50L);
  write_line(stdout);
}  /* delete_node */

Local Void unlink_node(s, set_node, LINK)
t_am_edge_list **s;
t_hyper_set_node **set_node;
struct LOC_restricted_maximim_cardinality_search_on_hypergraph *LINK;
{
  *set_node = (*s)->hyper_set_node;
  if ((*set_node)->forward_link != NULL)
    (*set_node)->forward_link->backward_link = (*set_node)->backward_link;
  if ((*set_node)->backward_link != NULL)
    (*set_node)->backward_link->forward_link = (*set_node)->forward_link;
  else
    (*set_node)->hyper_set->node = (*set_node)->forward_link;
}  /* unlink_node */

Local Void relink_node(sets, set_node, LINK)
t_hyper_set_list **sets;
t_hyper_set_node **set_node;
struct LOC_restricted_maximim_cardinality_search_on_hypergraph *LINK;
{
  t_hyper_set_list *tmp_sets;

  tmp_sets = (*set_node)->hyper_set->backward_link;
  if (tmp_sets == NULL) {
    tmp_sets = (t_hyper_set_list *)Malloc(sizeof(t_hyper_set_list));
    if (tmp_sets == NULL)
      _OutMem();
    tmp_sets->forward_link = *sets;
    tmp_sets->backward_link = NULL;
    tmp_sets->node = NULL;
    (*sets)->backward_link = tmp_sets;
    *sets = tmp_sets;
  }
  if (tmp_sets->node != NULL) {
    (*set_node)->forward_link = tmp_sets->node;
    tmp_sets->node->backward_link = *set_node;
  } else
    (*set_node)->forward_link = NULL;
  (*set_node)->backward_link = NULL;
  tmp_sets->node = *set_node;
  (*set_node)->hyper_set = tmp_sets;
}  /* relink_node */

Local Void discard_node(s, set_node, LINK)
t_am_edge_list **s;
t_hyper_set_node **set_node;
struct LOC_restricted_maximim_cardinality_search_on_hypergraph *LINK;
{
  Free(*set_node);
  (*s)->hyper_set_node = NULL;
}  /* discard_node */

Local Void clean_up_sets(sets, LINK)
t_hyper_set_list **sets;
struct LOC_restricted_maximim_cardinality_search_on_hypergraph *LINK;
{
  t_hyper_set_list *tmp_sets;

  while ((*sets)->forward_link != NULL && (*sets)->node == NULL) {
    tmp_sets = *sets;
    *sets = (*sets)->forward_link;
    (*sets)->backward_link = NULL;
    Free(tmp_sets);
  }
  if ((*sets)->node == NULL) {
    Free(*sets);
    *sets = NULL;
  }
}  /* clean_up_sets */

Local Void write_sets(sets, LINK)
t_hyper_set_list **sets;
struct LOC_restricted_maximim_cardinality_search_on_hypergraph *LINK;
{
  t_am_edge_list *s_tmp;
  t_hyper_set_list *tmp_sets;
  t_hyper_set_node *set_node_tmp;
  long TEMP;
  FILE *TEMP1;

  write_char_n_text(stdout, '+', 50L);
  write_line(stdout);
  tmp_sets = *sets;
  while (tmp_sets != NULL) {
    set_node_tmp = tmp_sets->node;
    while (set_node_tmp != NULL) {
      s_tmp = set_node_tmp->link_edge;
      TEMP = 3;
      write_integer_text(stdout, s_tmp->beta, &TEMP);
      TEMP = 3;
      write_integer_text(stdout, s_tmp->gamma, &TEMP);
      TEMP = 3;
      write_integer_text(stdout, s_tmp->size, &TEMP);
      TEMP = 3;
      write_integer_text(stdout, s_tmp->card, &TEMP);
      write_char_n_text(stdout, ' ', 3L);
      print_vertex_set(s_tmp->vertex_set);
      write_line(stdout);
      set_node_tmp = set_node_tmp->forward_link;
    }
    write_char_n_text(stdout, '+', 50L);
    write_line(stdout);
    tmp_sets = tmp_sets->forward_link;
  }
  TEMP1 = stdout;
  flush_file(&TEMP1);
}  /* write_sets */

Local Void report_results(LINK)
struct LOC_restricted_maximim_cardinality_search_on_hypergraph *LINK;
{
  t_vertex_set a, b;
  t_vertex v;
  long TEMP;
  t_vertex FORLIM;
  FILE *TEMP1;

  write_char_n_text(stdout, '=', 50L);
  write_line(stdout);
  LINK->s = LINK->matrix_gc->am_edge_list;
  while (LINK->s != NULL) {
    TEMP = 3;
    write_integer_text(stdout, LINK->s->beta, &TEMP);
    TEMP = 3;
    write_integer_text(stdout, LINK->s->gamma, &TEMP);
    TEMP = 3;
    write_integer_text(stdout, LINK->s->size, &TEMP);
    TEMP = 3;
    write_integer_text(stdout, LINK->s->card, &TEMP);
    write_char_n_text(stdout, ' ', 3L);
    print_vertex_set(LINK->s->vertex_set);
    write_line(stdout);
    LINK->s = LINK->s->forward_link;
  }
  write_char_n_text(stdout, '=', 50L);
  write_line(stdout);
  write_char_n_text(stdout, '=', 50L);
  write_line(stdout);
  revers_offset_list(LINK->r);
  LINK->q = *LINK->r;
  P_setcpy(a, empty_set);
  while (LINK->q != NULL) {
    write_integer(stdout, LINK->q->offset, 4L);
    write_space(stdout, 2L);
    print_vertex_set(LINK->q->vertex_set);
    write_space(stdout, 2L);
    P_setint(b, a, LINK->q->vertex_set);
    print_vertex_set(b);
    P_setunion(a, a, LINK->q->vertex_set);
    write_space(stdout, 2L);
    FORLIM = last_vertex;
    for (v = first_vertex; v <= FORLIM; v++) {
      if (LINK->beta[v - MIN_VERTEX] <= LINK->q->offset) {
	if (P_inset(v, LINK->q->vertex_set))
	  print_vertex(v);
      }
    }
    write_space(stdout, 2L);
    LINK->i = dimension;
    while (LINK->beta[LINK->invers_order[LINK->i - 1] - MIN_VERTEX] <=
	   LINK->q->offset) {
      if (P_inset(LINK->invers_order[LINK->i - 1], LINK->q->vertex_set))
	print_vertex(LINK->invers_order[LINK->i - 1]);
      LINK->i--;
    }
    write_line(stdout);
    LINK->q = LINK->q->pointer;
  }
  revers_offset_list(LINK->r);
  write_char_n_text(stdout, '=', 50L);
  write_line(stdout);
  write_space(stdout, 2L);
  write_char(stdout, 'V');
  write_pch(stdout, "  ", 2L);
  write_pch(stdout, "  alpha(V)", 10L);
  write_space(stdout, 3L);
  write_pch(stdout, "   beta(V)", 10L);
  write_line(stdout);
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    write_space(stdout, 2L);
    print_vertex_on_file(stdout, v);
    write_pch(stdout, ": ", 2L);
    write_integer(stdout, (long)LINK->alpha[v - MIN_VERTEX], 10L);
    write_space(stdout, 3L);
    write_integer(stdout, (long)LINK->beta[v - MIN_VERTEX], 10L);
    write_line(stdout);
  }
  write_line(stdout);
  write_char_n_text(stdout, '%', 50L);
  write_line(stdout);
  if (*LINK->no_exhausted_edges)
    write_pch_40_text(stdout, " Decomposabel: No exhausted edges ", 34L);
  else
    write_pch_40_text(stdout, " Decomposabel: exhausted edges @@@@@@   ", 34L);
  write_line(stdout);
  write_char_n_text(stdout, '%', 50L);
  write_line(stdout);
  TEMP1 = stdout;
  flush_file(&TEMP1);
}  /* report_results */


Static Void restricted_maximim_cardinality_search_on_hypergraph(matrix_gc_, a,
  no_exhausted_edges_, alpha_, beta_, invers_order_, r_)
t_adjacency_matrix *matrix_gc_;
long *a;
boolean *no_exhausted_edges_;
short *alpha_, *beta_;
t_vertex *invers_order_;
t_offset_list **r_;
{
  struct LOC_restricted_maximim_cardinality_search_on_hypergraph Local_Var;
  t_vertex v;
  t_0_max_dimension k;
  t_am_node *p;
  t_am_edge_list *t;
  t_hyper_set_list *sets;
  t_hyper_set_node *set_node;
  t_vertex FORLIM;

  Local_Var.matrix_gc = matrix_gc_;
  Local_Var.no_exhausted_edges = no_exhausted_edges_;
  Local_Var.alpha = alpha_;
  Local_Var.beta = beta_;
  Local_Var.invers_order = invers_order_;
  Local_Var.r = r_;
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++)
    Local_Var.beta[v - MIN_VERTEX] = MAX_DIMENSION;
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++)
    Local_Var.alpha[v - MIN_VERTEX] = 0;
  init_sets(Local_Var.matrix_gc->am_edge_list, &sets, &Local_Var);
  if (!P_setequal(a, empty_set)) {
    Local_Var.s = Local_Var.matrix_gc->am_edge_list;
    while (!P_subset(a, Local_Var.s->vertex_set))
      Local_Var.s = Local_Var.s->forward_link;
    unlink_node(&Local_Var.s, &set_node, &Local_Var);
    relink_node(&sets, &set_node, &Local_Var);
  }
  *Local_Var.no_exhausted_edges = true;
  *Local_Var.r = NULL;
  Local_Var.i = dimension + 1;
  k = 0;
  /*$ifdef TRACE*/
  if (boolean_option[6])
    write_sets(&sets, &Local_Var);
  /*$endif TRACE*/
  clean_up_sets(&sets, &Local_Var);
  /*$ifdef TRACE*/
  if (boolean_option[6])
    write_sets(&sets, &Local_Var);
  /*$endif TRACE*/
  while (sets != NULL) {
    delete_node(&sets, &Local_Var.s, &Local_Var);
    k++;
    Local_Var.s->beta = k;
    Local_Var.s->size = -1;
    insert_offset(Local_Var.s->vertex_set, Local_Var.s->gamma, Local_Var.r);
    FORLIM = last_vertex;
    for (v = first_vertex; v <= FORLIM; v++) {
      if (Local_Var.alpha[v - MIN_VERTEX] == 0) {
	if (P_inset(v, Local_Var.s->vertex_set)) {
	  /*$ifdef TRACE*/
	  if (boolean_option[6]) {
	    write_char_n_text(stdout, '*', 2L);
	    print_vertex(v);
	    write_char_n_text(stdout, '*', 2L);
	    write_line(stdout);
	  }
	  /*$endif TRACE*/
	  Local_Var.i--;
	  Local_Var.alpha[v - MIN_VERTEX] = Local_Var.i;
	  Local_Var.invers_order[Local_Var.i - 1] = v;
	  Local_Var.beta[v - MIN_VERTEX] = k;
	  p = Local_Var.matrix_gc->vertex_list[v - MIN_VERTEX];
	  while (p != NULL) {
	    if (p->link_edge->size >= 0) {
	      t = p->link_edge;
	      t->gamma = k;
	      unlink_node(&t, &set_node, &Local_Var);
	      t->size++;
	      if (t->size < t->card)
		relink_node(&sets, &set_node, &Local_Var);
	      else if (t->size == t->card) {
		t->size = -1;
		discard_node(&t, &set_node, &Local_Var);
		*Local_Var.no_exhausted_edges = false;
	      } else
		note_error(51L);
	      /*$ifdef TRACE*/
	      if (boolean_option[6]) {
		/*$endif TRACE*/
		write_sets(&sets, &Local_Var);
	      }
	    }
	    p = p->forward_link;
	  }
	}
      }
    }
    clean_up_sets(&sets, &Local_Var);
    /*$ifdef TRACE*/
    if (boolean_option[6]) {
      /*$endif TRACE*/
      write_sets(&sets, &Local_Var);
    }
  }
  /*$ifdef TRACE*/
  if (boolean_option[6]) {
    /*$endif TRACE*/
    report_results(&Local_Var);
  }
}  /* restricted_maximim_cardinality_search_on_hypergraph */


Static boolean test_acyclic_hypergraph(beta, r)
short *beta;
t_offset_list **r;
{
  t_vertex v;
  t_0_max_dimension i;
  t_offset_list *t, *s;
  boolean acyclic;
  t_v_arr_of_order index;
  t_vertex FORLIM;

  acyclic = true;
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++)
    index[v - MIN_VERTEX] = 0;
  i = 1;
  t = *r;
  while (t != NULL && acyclic) {
    FORLIM = last_vertex;
    for (v = first_vertex; v <= FORLIM; v++) {
      if (P_inset(v, t->vertex_set))
	index[v - MIN_VERTEX] = i;
    }
    s = *r;
    while (s != NULL && acyclic) {
      if (s->offset == i) {
	FORLIM = last_vertex;
	for (v = first_vertex; v <= FORLIM; v++) {
	  if (beta[v - MIN_VERTEX] < i && index[v - MIN_VERTEX] < i) {
	    if (P_inset(v, s->vertex_set))
	      acyclic = false;
	  }
	}
      }
      s = s->pointer;
    }
    t = t->pointer;
    i++;
  }
  return acyclic;
}  /* test_acyclic_hypergraph */


typedef t_long_real t_l[MAX_VERTEX - MIN_VERTEX + 1];


/*@+"lexm.p"*/


Static Void marked_lex_m(s, adj_list, order, invers_order, fill_in_adj_list)
long *s;
t_vertex_list **adj_list;
short *order;
t_vertex *invers_order;
t_vertex_list **fill_in_adj_list;
{
  t_vertex_list *reach[MAX_DIMENSION + 1];
  t_0_max_dimension i, j, k;
  t_vertex v, w, z;
  t_long_integer lab[MAX_2_DIMENSION];
  t_v_arr_of_boolean reached;
  t_l l;
  t_vertex_list *p, *q, *r;
  short a, m;
  t_vertex FORLIM;

  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    l[v - MIN_VERTEX] = 1.0;
    order[v - MIN_VERTEX] = 0;
  }
  k = 1;
  for (i = dimension + 1; i >= 1; i--) {
    for (j = 1; j <= k; j++)
      reach[j] = NULL;
    if (i == dimension + 1) {
      v = last_vertex + 1;
      FORLIM = last_vertex;
      for (w = first_vertex; w <= FORLIM; w++) {
	if (P_inset(w, s)) {
	  insert_vertex_in_vertex_list(w,
	    &reach[(int)((long)floor(l[w - MIN_VERTEX] + 0.5))]);
	  P_putbits_UB(reached, w - MIN_VERTEX, 1, 0, 3);
	  l[w - MIN_VERTEX] += 1.0 / 2;
	} else
	  P_clrbits_B(reached, w - MIN_VERTEX, 0, 3);
      }
    } else {
      v = first_vertex;
      while (order[v - MIN_VERTEX] != 0 || l[v - MIN_VERTEX] != k)
	v++;
      invers_order[i - 1] = v;
      order[v - MIN_VERTEX] = i;
      FORLIM = last_vertex;
      for (w = first_vertex; w <= FORLIM; w++) {
	P_clrbits_B(reached, w - MIN_VERTEX, 0, 3);
	P_putbits_UB(reached, w - MIN_VERTEX, order[w - MIN_VERTEX] != 0, 0,
		     3);
      }
      p = adj_list[v - MIN_VERTEX];
      while (p != NULL) {
	w = p->vertex;
	if (order[w - MIN_VERTEX] == 0) {
	  insert_vertex_in_vertex_list(w,
	    &reach[(int)((long)floor(l[w - MIN_VERTEX] + 0.5))]);
	  P_putbits_UB(reached, w - MIN_VERTEX, 1, 0, 3);
	  l[w - MIN_VERTEX] += 1.0 / 2;
	  insert_vertex_in_vertex_list(v, &fill_in_adj_list[w - MIN_VERTEX]);
	  insert_vertex_in_vertex_list(w, &fill_in_adj_list[v - MIN_VERTEX]);
	}
	p = p->pointer;
      }
    }
    for (j = 1; j <= k; j++) {
      p = reach[j];
      while (p != NULL) {
	w = p->vertex;
	q = p;
	p = p->pointer;
	Free(q);
	q = adj_list[w - MIN_VERTEX];
	while (q != NULL) {
	  z = q->vertex;
	  if (!P_getbits_UB(reached, z - MIN_VERTEX, 0, 3)) {
	    r = (t_vertex_list *)Malloc(sizeof(t_vertex_list));
	    if (r == NULL)
	      _OutMem();
	    r->vertex = z;
	    P_putbits_UB(reached, z - MIN_VERTEX, 1, 0, 3);
	    if (l[z - MIN_VERTEX] > j) {
	      r->pointer = reach[(int)((long)floor(l[z - MIN_VERTEX] + 0.5))];
	      reach[(int)((long)floor(l[z - MIN_VERTEX] + 0.5))] = r;
	      l[z - MIN_VERTEX] += 1.0 / 2;
	      if (v > last_vertex)
		write_pch(stdout, "%%% e9 %%%", 10L);
	      else {
		insert_vertex_in_vertex_list(v,
		  &fill_in_adj_list[z - MIN_VERTEX]);
		insert_vertex_in_vertex_list(z,
		  &fill_in_adj_list[v - MIN_VERTEX]);
	      }
	    } else {
	      r->pointer = p;
	      p = r;
	    }
	  }
	  q = q->pointer;
	}
      }
    }
    a = k * 2 + 1;
    for (m = 0; m < a; m++)
      lab[m] = 0;
    /*$ifdef TRACE*/
    if (boolean_option[28]) {
      write_line(stdout);
      write_pch(stdout, " Order:   ", 10L);
      FORLIM = last_vertex;
      for (v = first_vertex; v <= FORLIM; v++)
	write_integer(stdout, (long)order[v - MIN_VERTEX], 5L);
      write_line(stdout);
      write_pch(stdout, " L:       ", 10L);
      FORLIM = last_vertex;
      for (v = first_vertex; v <= FORLIM; v++)
	write_real(stdout, l[v - MIN_VERTEX], 5L, 1L);
      write_line(stdout);
    }
    FORLIM = last_vertex;
    /*$endif TRACE*/
    for (v = first_vertex; v <= FORLIM; v++) {
      if (order[v - MIN_VERTEX] == 0)
	lab[(int)((long)floor(2 * l[v - MIN_VERTEX] + 0.5)) - 1] = 1;
    }
    /*$ifdef TRACE*/
    if (boolean_option[28]) {
      write_pch(stdout, " Lab:     ", 10L);
      for (m = 0; m < a; m++)
	write_integer(stdout, lab[m], 5L);
      write_line(stdout);
    }
    /*$endif TRACE*/
    k = 0;
    for (m = 0; m < a; m++) {
      if (lab[m] == 1) {
	k++;
	lab[m] = k;
      }
    }
    /*$ifdef TRACE*/
    if (boolean_option[28]) {
      write_pch(stdout, " K:       ", 10L);
      write_integer(stdout, (long)k, 5L);
      write_line(stdout);
      write_pch(stdout, " Lab:     ", 10L);
      for (m = 0; m < a; m++)
	write_integer(stdout, lab[m], 5L);
      write_line(stdout);
    }
    FORLIM = last_vertex;
    /*$endif TRACE*/
    for (v = first_vertex; v <= FORLIM; v++) {
      if (order[v - MIN_VERTEX] == 0)
	l[v - MIN_VERTEX] = lab[(int)((long)floor(2 * l[v - MIN_VERTEX] + 0.5)) - 1];
    }
    /*$ifdef TRACE*/
    if (boolean_option[28]) {
      write_pch(stdout, " L:       ", 10L);
      FORLIM = last_vertex;
      for (v = first_vertex; v <= FORLIM; v++)
	write_real(stdout, l[v - MIN_VERTEX], 5L, 1L);
      write_line(stdout);
    }
    /*$endif TRACE*/
  }
}  /* marked_lex_m */


Static Void lex_m(adj_list, order, invers_order, fill_in_adj_list)
t_vertex_list **adj_list;
short *order;
t_vertex *invers_order;
t_vertex_list **fill_in_adj_list;
{
  marked_lex_m(empty_set, adj_list, order, invers_order, fill_in_adj_list);
}  /* lex_m */


/*@+"maxcard.p"*/


Static Void maximum_cardinality_search(adj_list, order, invers_order)
t_vertex_list **adj_list;
short *order;
t_vertex *invers_order;
{
  t_vertex_set set_num[MAX_DIMENSION + 1];
  t_0_max_dimension i, j;
  t_vertex v, w;
  t_v_arr_of_order size;
  t_vertex_list *p;
  t_0_max_dimension FORLIM;
  t_vertex FORLIM1;

  FORLIM = dimension;
  for (i = 0; i <= FORLIM; i++)
    P_setcpy(set_num[i], empty_set);
  FORLIM1 = last_vertex;
  for (v = first_vertex; v <= FORLIM1; v++) {
    size[v - MIN_VERTEX] = 0;
    P_addset(set_num[0], v);
  }
  invers_order[dimension] = last_vertex + 1;
  order[last_vertex - MIN_VERTEX + 1] = dimension + 1;
  j = 0;
  for (i = dimension; i >= 1; i--) {
    v = first_vertex;
    while (!P_inset(v, set_num[j]))
      v++;
    order[v - MIN_VERTEX] = i;
    invers_order[i - 1] = v;
    size[v - MIN_VERTEX] = -1;
    P_remset(set_num[j], v);
    p = adj_list[v - MIN_VERTEX];
    while (p != NULL) {
      w = p->vertex;
      if (size[w - MIN_VERTEX] >= 0) {
	P_remset(set_num[size[w - MIN_VERTEX]], w);
	size[w - MIN_VERTEX]++;
	P_addset(set_num[size[w - MIN_VERTEX]], w);
      }
      p = p->pointer;
    }
    j++;
    while (j > 0 && P_setequal(set_num[j], empty_set))
      j--;
  }
}  /* maximum_cardinality_search */


Static Void fill_in_computation(adj_list, order, invers_order,
				fill_in_adj_list)
t_vertex_list **adj_list;
short *order;
t_vertex *invers_order;
t_vertex_list **fill_in_adj_list;
{
  t_vertex v, w;
  t_long_integer i;
  t_vertex_list *p;
  t_v_arr_of_vertex follow;
  t_v_arr_of_order index;
  t_vertex FORLIM;
  long FORLIM1;

  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++)
    fill_in_adj_list[v - MIN_VERTEX] = NULL;
  FORLIM1 = dimension;
  for (i = 1; i <= FORLIM1; i++) {
    w = invers_order[i - 1];
    follow[w - MIN_VERTEX] = w;
    index[w - MIN_VERTEX] = i;
    p = adj_list[w - MIN_VERTEX];
    while (p != NULL) {
      v = p->vertex;
      if (order[v - MIN_VERTEX] < i) {
	while (index[v - MIN_VERTEX] < i) {
	  index[v - MIN_VERTEX] = i;
	  insert_vertex_in_vertex_list(v, &fill_in_adj_list[w - MIN_VERTEX]);
	  insert_vertex_in_vertex_list(w, &fill_in_adj_list[v - MIN_VERTEX]);
	  v = follow[v - MIN_VERTEX];
	}
	if (follow[v - MIN_VERTEX] == v)
	  follow[v - MIN_VERTEX] = w;
      }
      p = p->pointer;
    }
  }
}  /* fill_in_computation */


Static boolean test_for_zero_fill_in(adj_list, order, invers_order)
t_vertex_list **adj_list;
short *order;
t_vertex *invers_order;
{
  t_vertex v, w;
  t_long_integer i;
  t_vertex_list *p;
  boolean ok;
  t_v_arr_of_vertex follow;
  t_v_arr_of_order index;

  ok = true;
  i = 1;
  while (i <= dimension && ok == true) {
    w = invers_order[i - 1];
    follow[w - MIN_VERTEX] = w;
    index[w - MIN_VERTEX] = i;
    p = adj_list[w - MIN_VERTEX];
    while (p != NULL) {
      v = p->vertex;
      if (order[v - MIN_VERTEX] < i) {
	index[v - MIN_VERTEX] = i;
	if (follow[v - MIN_VERTEX] == v)
	  follow[v - MIN_VERTEX] = w;
      }
      p = p->pointer;
    }
    p = adj_list[w - MIN_VERTEX];
    while (p != NULL && ok == true) {
      v = p->vertex;
      if (order[v - MIN_VERTEX] < i) {
	if (index[follow[v - MIN_VERTEX] - MIN_VERTEX] < i)
	  ok = false;
      }
      p = p->pointer;
    }
    i++;
  }
  return ok;
}  /* test_for_zero_fill_in */


/*@+"listop.p"*/


Static Void insert_edge_in_adj_list(adj_list, v1, v2)
t_vertex_list **adj_list;
t_vertex *v1, *v2;
{
  t_vertex_list *p;
  boolean b;

  b = true;
  p = adj_list[*v1 - MIN_VERTEX];
  while (p != NULL && b) {
    if (*v2 == p->vertex)
      b = false;
    else
      p = p->pointer;
  }
  if (p == NULL) {
    insert_vertex_in_vertex_list(*v1, &adj_list[*v2 - MIN_VERTEX]);
    insert_vertex_in_vertex_list(*v2, &adj_list[*v1 - MIN_VERTEX]);
  }
}  /* insert_edge_in_adj_list */


Local Void insert_edge_in_adj_list_fast(adj_list, v1, v2)
t_vertex_list **adj_list;
t_vertex v1, v2;
{
  insert_vertex_in_vertex_list(v1, &adj_list[v2 - MIN_VERTEX]);
  insert_vertex_in_vertex_list(v2, &adj_list[v1 - MIN_VERTEX]);
}  /* insert_edge_in_adj_list_fast */


Static Void adj_set_to_adj_list(adj_set, adj_list)
t_vertex_set *adj_set;
t_vertex_list **adj_list;
{
  t_vertex v1, v2, FORLIM, FORLIM1;

  FORLIM = last_vertex;
  for (v1 = first_vertex; v1 <= FORLIM; v1++)
    adj_list[v1 - MIN_VERTEX] = NULL;
  FORLIM = last_vertex;
  for (v1 = first_vertex; v1 < FORLIM; v1++) {
    FORLIM1 = last_vertex;
    for (v2 = v1 + 1; v2 <= FORLIM1; v2++) {
      if (P_inset(v2, adj_set[v1 - MIN_VERTEX]))
	insert_edge_in_adj_list_fast(adj_list, v1, v2);
    }
  }
}  /* adj_set_to_adj_list */


Static Void adj_list_to_adj_set(adj_list, adj_set)
t_vertex_list **adj_list;
t_vertex_set *adj_set;
{
  t_vertex_list *p_vertex;
  t_vertex v, FORLIM;

  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    P_setcpy(adj_set[v - MIN_VERTEX], empty_set);
    p_vertex = adj_list[v - MIN_VERTEX];
    while (p_vertex != NULL) {
      P_addset(adj_set[v - MIN_VERTEX], p_vertex->vertex);
      p_vertex = p_vertex->pointer;
    }
  }
}  /* adj_list_to_adj_set */


Static Void dispose_adj_list(adj_list)
t_vertex_list **adj_list;
{
  t_vertex_list *p, *q;
  t_vertex v, FORLIM;

  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    p = adj_list[v - MIN_VERTEX];
    while (p != NULL) {
      q = p->pointer;
      Free(p);
      p = q;
    }
    adj_list[v - MIN_VERTEX] = NULL;
  }
}  /* dispose_adj_list */


Static Void hypergraph_sets_to_graph_sets(p_g_c, model_set, adj_set)
t_set_list *p_g_c;
long *model_set;
t_vertex_set *adj_set;
{
  t_vertex v;
  t_vertex_set a;
  t_vertex FORLIM;

  P_setcpy(model_set, empty_set);
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++)
    P_setcpy(adj_set[v - MIN_VERTEX], empty_set);
  while (p_g_c != NULL) {
    P_setcpy(a, p_g_c->vertex_set);
    P_setunion(model_set, model_set, a);
    FORLIM = last_vertex;
    for (v = first_vertex; v <= FORLIM; v++) {
      if (P_inset(v, a))
	P_setunion(adj_set[v - MIN_VERTEX], adj_set[v - MIN_VERTEX], a);
    }
    p_g_c = p_g_c->pointer;
  }
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++)
    P_remset(adj_set[v - MIN_VERTEX], v);
}  /* hypergraph_sets_to_graph_sets */


Static Void copy_set_list(link_1, link_2)
t_set_list *link_1, **link_2;
{
  *link_2 = NULL;
  while (link_1 != NULL) {
    insert_set_in_set_list(link_1->vertex_set, link_2);
    link_1 = link_1->pointer;
  }
}  /* copy_set_list */


Static boolean test_list_of_sets_subset_of_list_of_sets(link_1, link_2)
t_set_list *link_1, *link_2;
{
  t_set_list *p;
  boolean ok;
  t_vertex_set a;

  ok = true;
  while (link_1 != NULL && ok) {
    P_setcpy(a, link_1->vertex_set);
    ok = false;
    p = link_2;
    while (p != NULL && !ok) {
      if (P_setequal(a, p->vertex_set))
	ok = true;
      else
	p = p->pointer;
    }
    link_1 = link_1->pointer;
  }
  return ok;
}  /* test_list_of_sets_subset_of_list_of_sets */


Static boolean subset_of_an_edge(a, list_of_cliques)
long *a;
t_set_list **list_of_cliques;
{
  t_set_list *p;
  boolean b;

  b = true;
  p = *list_of_cliques;
  while (p != NULL && b) {
    if (P_subset(a, p->vertex_set))
      b = false;
    else
      p = p->pointer;
  }
  return (!b);
}  /* subset_of_an_edge */


Static boolean contains_an_edge(a, list_of_cliques)
long *a;
t_set_list **list_of_cliques;
{
  t_set_list *p;
  boolean b;

  b = true;
  p = *list_of_cliques;
  while (p != NULL && b) {
    if (P_subset(p->vertex_set, a))
      b = false;
    else
      p = p->pointer;
  }
  return (!b);
}  /* contains_an_edge */


Static boolean test_sub_g_c(link_1, link_2)
t_set_list *link_1, *link_2;
{
  t_set_list *p;
  boolean ok;
  t_vertex_set a;

  ok = true;
  while (link_1 != NULL && ok) {
    P_setcpy(a, link_1->vertex_set);
    ok = false;
    p = link_2;
    while (p != NULL && !ok) {
      if (P_subset(a, p->vertex_set))
	ok = true;
      else
	p = p->pointer;
    }
    link_1 = link_1->pointer;
  }
  return ok;
}  /* test_sub_g_c */


Static Void find_connected_component(g, d, a, u, adj_list)
long *g, *d, *a;
t_vertex *u;
t_vertex_list **adj_list;
{
  t_v_arr_of_boolean explored;
  t_vertex_list *queue, *p;
  t_vertex v, w;
  t_vertex FORLIM;
  long TEMP;

  P_addset(P_expset(a, 0L), *u);
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++)
    P_clrbits_B(explored, v - MIN_VERTEX, 0, 3);
  TEMP = *u - MIN_VERTEX;
  P_putbits_UB(explored, TEMP, 1, 0, 3);
  queue = NULL;
  insert_vertex_in_vertex_list(*u, &queue);
  while (queue != NULL) {
    v = queue->vertex;
    p = queue;
    queue = queue->pointer;
    Free(p);
    p = adj_list[v - MIN_VERTEX];
    while (p != NULL) {
      w = p->vertex;
      if ((!P_getbits_UB(explored, w - MIN_VERTEX, 0, 3)) & (!P_inset(w, d)) &
	  P_inset(w, g)) {
	insert_vertex_in_vertex_list(w, &queue);
	P_addset(a, w);
	P_putbits_UB(explored, w - MIN_VERTEX, 1, 0, 3);
      }
      p = p->pointer;
    }
  }
}  /* find_connected_component */


Static Void find_c(adj_set, order, invers_order, fill_in_adj_list, c,
		   complete)
t_vertex_set *adj_set;
short *order;
t_vertex *invers_order;
t_vertex_list **fill_in_adj_list;
t_vertex_set *c;
uchar *complete;
{
  t_1_max_dimension i;
  t_vertex_list *p;
  t_vertex u, v;
  t_1_max_dimension FORLIM;
  int TEMP;

  P_setcpy(c[last_vertex - MIN_VERTEX + 1], empty_set);
  P_putbits_UB(complete, last_vertex - MIN_VERTEX + 1, 1, 0, 3);
  FORLIM = dimension;
  for (i = 1; i <= FORLIM; i++) {
    u = invers_order[i - 1];
    P_setcpy(c[u - MIN_VERTEX], empty_set);
    P_putbits_UB(complete, u - MIN_VERTEX, 1, 0, 3);
    p = fill_in_adj_list[u - MIN_VERTEX];
    while (p != NULL) {
      v = p->vertex;
      if (i < order[v - MIN_VERTEX]) {
	TEMP = (P_getbits_UB(complete, u - MIN_VERTEX, 0, 3) &&
		P_subset(c[u - MIN_VERTEX], adj_set[v - MIN_VERTEX]));
	P_clrbits_B(complete, u - MIN_VERTEX, 0, 3);
	P_putbits_UB(complete, u - MIN_VERTEX, TEMP, 0, 3);
	P_addset(c[u - MIN_VERTEX], v);
      }
      p = p->pointer;
    }
  }
}  /* find_c */


Static boolean adj_set_decomposable(adj_set)
t_vertex_set *adj_set;
{
  boolean Result;
  t_v_arr_of_v_lists adj_list;
  t_v_arr_of_order order;
  t_o_arr_of_vertex invers_order;

  adj_set_to_adj_list(adj_set, adj_list);
  maximum_cardinality_search(adj_list, order, invers_order);
  Result = test_for_zero_fill_in(adj_list, order, invers_order);
  dispose_adj_list(adj_list);
  return Result;
}  /* adj_set_decomposable */


Static Void find_edges(adj_list_1, adj_set_2, link_edge_list)
t_vertex_list **adj_list_1;
t_vertex_set *adj_set_2;
t_edge_list **link_edge_list;
{
  t_v_arr_of_boolean explored;
  t_vertex_list *queue, *q, *p;
  t_vertex u, v, w, FORLIM;

  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++)
    P_clrbits_B(explored, v - MIN_VERTEX, 0, 3);
  u = first_vertex;
  do {
    P_putbits_UB(explored, u - MIN_VERTEX, 1, 0, 3);
    queue = NULL;
    insert_vertex_in_vertex_list(u, &queue);
    while (queue != NULL) {
      v = queue->vertex;
      q = queue;
      queue = queue->pointer;
      Free(q);
      p = adj_list_1[v - MIN_VERTEX];
      while (p != NULL) {
	w = p->vertex;
	if (!P_inset(v, adj_set_2[w - MIN_VERTEX]) && v < w)
	  insert_edge_in_edge_list(v, w, link_edge_list);
	if (!P_getbits_UB(explored, w - MIN_VERTEX, 0, 3)) {
	  insert_vertex_in_vertex_list(w, &queue);
	  P_putbits_UB(explored, w - MIN_VERTEX, 1, 0, 3);
	}
	p = p->pointer;
      }
    }
    while (P_getbits_UB(explored, u - MIN_VERTEX, 0, 3) && u < last_vertex)
      u++;
  } while (!P_getbits_UB(explored, u - MIN_VERTEX, 0, 3));   /* find_edges */
}


Static Void insert_set_minimal(a, list_of_sets)
long *a;
t_set_list **list_of_sets;
{
  t_set_list *p, *q;
  boolean b;

  b = true;
  p = *list_of_sets;
  while (p != NULL && b) {
    if (P_subset(p->vertex_set, a))
      b = false;
    else
      p = p->pointer;
  }
  if (!b)
    return;
  p = *list_of_sets;
  insert_set_in_set_list(a, list_of_sets);
  q = *list_of_sets;
  while (p != NULL) {
    if (P_subset(a, p->vertex_set)) {
      q->pointer = p->pointer;
      Free(p);
      p = q->pointer;
    } else {
      q = p;
      p = p->pointer;
    }
  }
}  /* insert_set_minimal */


Static Void insert_clique(a, list_of_sets)
long *a;
t_set_list **list_of_sets;
{
  t_set_list *p, *q;
  boolean b;

  b = true;
  p = *list_of_sets;
  while (p != NULL && b) {
    if (P_subset(a, p->vertex_set))
      b = false;
    else
      p = p->pointer;
  }
  if (!b)
    return;
  p = *list_of_sets;
  insert_set_in_set_list(a, list_of_sets);
  q = *list_of_sets;
  while (p != NULL) {
    if (P_subset(p->vertex_set, a)) {
      q->pointer = p->pointer;
      Free(p);
      p = q->pointer;
    } else {
      q = p;
      p = p->pointer;
    }
  }
}  /* insert_clique */


Static Void add_cliques(add_list, list_of_cliques)
t_set_list *add_list, **list_of_cliques;
{
  while (add_list != NULL) {
    insert_clique(add_list->vertex_set, list_of_cliques);
    add_list = add_list->pointer;
  }
}  /* add_cliques */


Static boolean was_edge_in_one_clique(v, w, g_c, a)
t_vertex *v, *w;
t_set_list **g_c;
long *a;
{
  t_set_list *p_g_c, *q_g_c, *r_g_c;
  boolean first_, second, ok;
  t_vertex_set b;

  /*$ifdef TRACE*/
  if (boolean_option[27]) {
    write_char(stdout, '<');
    print_vertex(*v);
    write_char(stdout, ',');
    print_vertex(*w);
    write_char(stdout, ';');
    print_g_c(*g_c, 0L, line_length);
    write_char(stdout, '>');
  }
  P_addset(P_expset(b, 0L), *v);
  P_addset(b, *w);
  /*$endif TRACE*/
  if (P_subset(b, (*g_c)->vertex_set)) {
    first_ = true;
    r_g_c = NULL;
    P_setcpy(a, (*g_c)->vertex_set);
  } else
    first_ = false;
  second = false;
  q_g_c = *g_c;
  p_g_c = (*g_c)->pointer;
  while (p_g_c != NULL && !second) {
    if (P_subset(b, p_g_c->vertex_set)) {
      if (first_)
	second = true;
      first_ = true;
      r_g_c = q_g_c;
      P_setcpy(a, p_g_c->vertex_set);
    }
    q_g_c = p_g_c;
    p_g_c = p_g_c->pointer;
  }
  ok = (first_ && !second);
  if (!ok)
    return ok;
  if (r_g_c == NULL) {
    p_g_c = *g_c;
    *g_c = (*g_c)->pointer;
    Free(p_g_c);
    return ok;
  }
  p_g_c = r_g_c->pointer;
  r_g_c->pointer = r_g_c->pointer->pointer;
  Free(p_g_c);
  return ok;
}  /* was_edge_in_one_clique */


/*@+"subsup.p"*/


Static Void exclude_vertex_sets_in_list(set_list, remove_set, exclude_list)
t_set_list **set_list;
_PROCEDURE remove_set;
t_set_list **exclude_list;
{
  boolean cont;
  t_set_list *p, *q;

  cont = true;
  while (*set_list != NULL && cont) {
    if (!((remove_set.link != NULL) ? (*(boolean(*) PP((long *a,
		  t_set_list **list_of_cliques,
		  Anyptr _link)))remove_set.proc)((*set_list)->vertex_set,
	  exclude_list, remove_set.link) : (
	  *(boolean(*) PP((long *a, t_set_list **list_of_cliques)))
	    remove_set.proc)((*set_list)->vertex_set, exclude_list))) {
      cont = false;
      break;
    }
    p = *set_list;
    *set_list = (*set_list)->pointer;
    Free(p);
  }
  if (*set_list == NULL)
    return;
  p = *set_list;
  q = (*set_list)->pointer;
  while (q != NULL) {
    if ((remove_set.link != NULL) ? (*(boolean(*) PP((long *a,
						      t_set_list **list_of_cliques,
						      Anyptr _link)))remove_set.proc)(
	  q->vertex_set, exclude_list, remove_set.link) : (
	  *(boolean(*) PP((long *a, t_set_list **list_of_cliques)))
	   remove_set.proc)(q->vertex_set, exclude_list)) {
      p->pointer = q->pointer;
      Free(q);
      q = p->pointer;
    } else {
      p = q;
      q = p->pointer;
    }
  }
}  /* exclude_vertex_sets_in_list */


/*$ifdef On-DOS
procedure exclude_sub_vertex_sets_in_list(var set_list: t_link_set_list;
                                          var exclude_list: t_link_set_list);
var
   cont: boolean;
   p, q: t_link_set_list;
begin
   cont := true;
   while (set_list <> nil) and cont do begin
      if subset_of_an_edge(set_list^.vertex_set, exclude_list) then begin
         p := set_list;
         set_list := set_list^.pointer;
         dispose(p)
      end else
         cont := false
   end;
   if set_list <> nil then begin
      p := set_list;
      q := set_list^.pointer;
      while q <> nil do begin
         if subset_of_an_edge(q^.vertex_set, exclude_list) then begin
            p^.pointer := q^.pointer;
            dispose(q);
            q := p^.pointer
         end else begin
            p := q;
            q := p^.pointer
         end
      end
   end
end;

procedure exclude_super_vertex_sets_in_list(var set_list: t_link_set_list;
                                            var exclude_list: t_link_set_list);
var
   cont: boolean;
   p, q: t_link_set_list;
begin
   cont := true;
   while (set_list <> nil) and cont do begin
      if contains_an_edge(set_list^.vertex_set, exclude_list) then begin
         p := set_list;
         set_list := set_list^.pointer;
         dispose(p)
      end else
         cont := false
   end;
   if set_list <> nil then begin
      p := set_list;
      q := set_list^.pointer;
      while q <> nil do begin
         if contains_an_edge(q^.vertex_set, exclude_list) then begin
            p^.pointer := q^.pointer;
            dispose(q);
            q := p^.pointer
         end else begin
            p := q;
            q := p^.pointer
         end
      end
   end
end;
 $endif On-DOS*/

/*@+"subm.p"*/


Static boolean test_grap_submodel(g_c_1, g_c_2, adj_set_1, adj_set_2, g)
t_set_list **g_c_1, **g_c_2;
t_vertex_set *adj_set_1, *adj_set_2;
long *g;
{
  boolean Result;
  t_vertex_set g2;
  t_vertex u;
  boolean ok;

  Result = false;
  hypergraph_sets_to_graph_sets(*g_c_1, g, adj_set_1);
  hypergraph_sets_to_graph_sets(*g_c_2, g2, adj_set_2);
  if (!P_setequal(g, g2)) {
    write_pch(stdout, " Graphs has not same sets of vertexes", 37L);
    write_line(stdout);
    return Result;
  }
  ok = true;
  u = first_vertex;
  while (ok && u < last_vertex) {
    ok = P_subset(adj_set_1[u - MIN_VERTEX], adj_set_2[u - MIN_VERTEX]);
    u++;
  }
  if (ok && u == last_vertex)
    ok = P_subset(adj_set_1[u - MIN_VERTEX], adj_set_2[u - MIN_VERTEX]);
  if (!ok) {
    write_pch(stdout, " Edges of graph 1 not subset of edges of graph 2",
		48L);
    write_line(stdout);
    return Result;
  }
  u = first_vertex;
  while (ok && u < last_vertex) {
    ok = P_setequal(adj_set_1[u - MIN_VERTEX], adj_set_2[u - MIN_VERTEX]);
    u++;
  }
  if (ok && u == last_vertex)
    ok = P_setequal(adj_set_1[u - MIN_VERTEX], adj_set_2[u - MIN_VERTEX]);
  if (!ok)
    return true;
  write_pch(stdout, " Collaps.", 9L);
  write_line(stdout);
  write_pch(stdout, " Models ", 8L);
  print_g_c(*g_c_1, 8L, line_length);
  write_line(stdout);
  write_pch(stdout, " and    ", 8L);
  print_g_c(*g_c_2, 8L, line_length);
  write_line(stdout);
  write_pch(stdout, " on ", 4L);
  print_vertex_set(g);
  write_pch(stdout, " identical.", 11L);
  return Result;
}  /* test_grap_submodel */


Static boolean test_hier_submodel(g_c_1, g_c_2, short_test_output,
				  write_models, dept)
t_set_list **g_c_1, **g_c_2;
boolean short_test_output, write_models;
long dept;
{
  boolean Result;
  t_vertex_set g1, g2;
  t_set_list *p;

  Result = false;
  P_setcpy(g1, empty_set);
  p = *g_c_1;
  while (p != NULL) {
    P_setunion(g1, g1, p->vertex_set);
    p = p->pointer;
  }
  P_setcpy(g2, empty_set);
  p = *g_c_2;
  while (p != NULL) {
    P_setunion(g2, g2, p->vertex_set);
    p = p->pointer;
  }
  if (P_subset(g1, g2)) {
    if (test_sub_g_c(*g_c_1, *g_c_2)) {
      if (!test_list_of_sets_subset_of_list_of_sets(*g_c_2, *g_c_1))
	return true;
      if (short_test_output || just)
	return Result;
      write_space(stdout, dept + 1);
      write_pch(stdout, "Collaps.", 8L);
      write_line(stdout);
      write_space(stdout, dept + 1);
      write_pch(stdout, "Models  ", 8L);
      print_g_c(*g_c_1, dept + 9, line_length);
      write_line(stdout);
      write_space(stdout, dept + 1);
      write_pch(stdout, "and     ", 8L);
      print_g_c(*g_c_2, dept + 9, line_length);
      write_line(stdout);
      write_space(stdout, dept + 1);
      write_pch(stdout, "on ", 3L);
      print_vertex_set(g1);
      write_pch(stdout, " identical.", 11L);
      write_line(stdout);
      return Result;
    }
    if (!short_test_output) {
      write_space(stdout, dept + 1);
      write_pch(stdout,
		  "Edges of graph 1 not subset of edges of graph 2", 47L);
      write_line(stdout);
      return Result;
    }
    write_space(stdout, 1L);
    write_pch(stdout, "Edges of ", 9L);
    print_g_c(*g_c_1, 10L, line_length);
    write_pch(stdout, " not subset of edges of ", 24L);
    print_g_c(*g_c_2, 10L, line_length);
    write_line(stdout);
    return Result;
  }
  if (!short_test_output) {
    write_space(stdout, dept + 1);
    write_pch(stdout, "Vertexes of graph 1 not subset of edges of graph 2",
		50L);
    write_line(stdout);
    return Result;
  }
  write_space(stdout, 1L);
  write_pch(stdout, "Vertexes of ", 12L);
  print_g_c(*g_c_1, 13L, line_length);
  write_pch(stdout, " not subset of edges of ", 24L);
  print_g_c(*g_c_2, 24L, line_length);
  write_line(stdout);
  return Result;
}  /* test_hier_submodel */


Local Void find_complete(a, adj_set, list_of_cliques, lv, v)
long *a;
t_vertex_set *adj_set;
t_set_list **list_of_cliques;
t_vertex *lv, v;
{
  t_vertex_set b;

  if (v != *lv)
    find_complete(a, adj_set, list_of_cliques, lv, v + 1);
  if (!P_subset(a, adj_set[v - MIN_VERTEX]))
    return;
  P_addset(P_expset(b, 0L), v);
  P_setunion(b, a, b);
  insert_clique(b, list_of_cliques);
  if (v != *lv)
    find_complete(b, adj_set, list_of_cliques, lv, v + 1);
}  /* find_complete */


/*@+"cliques.p"*/


Static Void find_sub_cliques(adj_set_, sub_set, list_of_cliques)
t_vertex_set *adj_set_;
long *sub_set;
t_set_list **list_of_cliques;
{
  t_v_arr_of_v_sets adj_set;
  t_vertex_set a, b;
  t_vertex u, v, w, lv;
  t_set_list *p;
  t_vertex FORLIM;
  t_vertex FORLIM1;

  memcpy(adj_set, adj_set_, sizeof(t_v_arr_of_v_sets));
  lv = first_vertex;
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    if (P_inset(v, sub_set)) {
      P_setint(a, sub_set, adj_set[v - MIN_VERTEX]);
      P_setcpy(b, empty_set);
      w = first_vertex;
      FORLIM1 = last_vertex;
      for (u = first_vertex; u <= FORLIM1; u++) {
	if (P_inset(u, sub_set)) {
	  if (P_inset(u, a))
	    P_addset(b, w);
	  w++;
	}
      }
      P_setcpy(adj_set[lv - MIN_VERTEX], b);
      lv++;
    }
  }
  lv--;
  find_complete(empty_set, adj_set, list_of_cliques, &lv, first_vertex);
  p = *list_of_cliques;
  while (p != NULL) {
    P_setcpy(a, p->vertex_set);
    P_setcpy(b, empty_set);
    w = first_vertex;
    FORLIM = last_vertex;
    for (v = first_vertex; v <= FORLIM; v++) {
      if (P_inset(v, sub_set)) {
	if (P_inset(w, a))
	  P_addset(b, v);
	w++;
      }
    }
    P_setcpy(p->vertex_set, b);
    p = p->pointer;
  }
}  /* find_sub_cliques */


Local Void find_cliques_decomposable(sub_set, adj_list, order, invers_order,
				     list_of_cliques)
long *sub_set;
t_vertex_list **adj_list;
short *order;
t_vertex *invers_order;
t_set_list **list_of_cliques;
{
  t_vertex_set decomp_set;
  t_1_max_dimension i;
  t_vertex_list *p;
  t_vertex u, v;
  t_1_max_dimension FORLIM;

  FORLIM = dimension;
  for (i = 1; i <= FORLIM; i++) {
    u = invers_order[i - 1];
    if (P_inset(u, sub_set)) {
      P_setcpy(decomp_set, empty_set);
      p = adj_list[u - MIN_VERTEX];
      while (p != NULL) {
	v = p->vertex;
	if (i < order[v - MIN_VERTEX])
	  P_addset(decomp_set, v);
	p = p->pointer;
      }
      P_addset(decomp_set, u);
      insert_clique(decomp_set, list_of_cliques);
    }
  }
}  /* find_cliques_decomposable */

Local Void find_cliques_graphical(sub_set, adj_list, adj_set, invers_order, c,
				  complete, list_of_cliques)
long *sub_set;
t_vertex_list **adj_list;
t_vertex_set *adj_set;
t_vertex *invers_order;
t_vertex_set *c;
uchar *complete;
t_set_list **list_of_cliques;
{
  t_1_max_dimension i, j;
  t_vertex_set a, b, g, d;
  t_vertex u, v;
  t_set_list *p, *q;

  P_setcpy(g, sub_set);
  P_setcpy(b, g);
  i = 1;
  while (!P_setequal(b, empty_set)) {
    u = invers_order[i - 1];
    while (!(P_getbits_UB(complete, u - MIN_VERTEX, 0, 3) & P_inset(u, g))) {
      i++;
      u = invers_order[i - 1];
    }
    if (P_subset(c[u - MIN_VERTEX], adj_set[u - MIN_VERTEX]) &
	P_getbits_UB(complete, u - MIN_VERTEX, 0, 3)) {
      j = i + 1;
      v = invers_order[j - 1];
      P_addset(P_expset(d, 0L), v);
      P_setunion(d, c[v - MIN_VERTEX], d);
      while ((P_subset(d, c[u - MIN_VERTEX]) && j < dimension) & P_inset(v, g)) {
	j++;
	v = invers_order[j - 1];
	P_addset(P_expset(d, 0L), v);
	P_setunion(d, c[v - MIN_VERTEX], d);
      }
      i = j - 1;
      u = invers_order[i - 1];
      find_connected_component(g, c[u - MIN_VERTEX], a, &u, adj_list);
      P_setunion(d, a, c[u - MIN_VERTEX]);
      insert_clique(d, list_of_cliques);
    } else {
      find_connected_component(g, c[u - MIN_VERTEX], a, &u, adj_list);
      p = NULL;
      P_setunion(d, a, c[u - MIN_VERTEX]);
      find_sub_cliques(adj_set, d, &p);
      while (p != NULL) {
	insert_clique(p->vertex_set, list_of_cliques);
	q = p;
	p = p->pointer;
	Free(q);
      }
    }
    P_setdiff(g, g, a);
    P_setdiff(b, g, c[u - MIN_VERTEX]);
    i++;
  }
}  /* find_cliques_graphical */


Static Void find_cliques_and_order(adj_set, adj_list, fill_in_adj_list, order,
  invers_order, c, complete, decomposable, sub_set, list_of_cliques)
t_vertex_set *adj_set;
t_vertex_list **adj_list, **fill_in_adj_list;
short *order;
t_vertex *invers_order;
t_vertex_set *c;
uchar *complete;
boolean *decomposable;
long *sub_set;
t_set_list **list_of_cliques;
{
  t_vertex v, FORLIM;

  maximum_cardinality_search(adj_list, order, invers_order);
  if (test_for_zero_fill_in(adj_list, order, invers_order)) {
    *decomposable = true;
    find_cliques_decomposable(sub_set, adj_list, order, invers_order,
			      list_of_cliques);
    return;
  }
  *decomposable = false;
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++)
    fill_in_adj_list[v - MIN_VERTEX] = NULL;
  lex_m(adj_list, order, invers_order, fill_in_adj_list);
  find_c(adj_set, order, invers_order, fill_in_adj_list, c, complete);
  find_cliques_graphical(sub_set, adj_list, adj_set, invers_order, c,
			 complete, list_of_cliques);
}  /* find_cliques_and_order */


Local Void find_complete_(a, adj_set, list_of_cliques, v)
long *a;
t_vertex_set *adj_set;
t_set_list **list_of_cliques;
t_vertex v;
{
  t_vertex_set b;

  if (v != last_vertex)
    find_complete_(a, adj_set, list_of_cliques, v + 1);
  P_addset(P_expset(b, 0L), v);
  P_setunion(b, a, b);
  if (!P_subset(a, adj_set[v - MIN_VERTEX]))
    return;
  insert_clique(b, list_of_cliques);
  if (v != last_vertex)
    find_complete_(b, adj_set, list_of_cliques, v + 1);
}  /* find_complete */

Local Void find_cliques_(adj_set, list_of_cliques)
t_vertex_set *adj_set;
t_set_list **list_of_cliques;
{
  *list_of_cliques = NULL;
  find_complete_(empty_set, adj_set, list_of_cliques, first_vertex);
}  /* find_cliques */


Static Void find_cliques(adj_set, sub_set, list_of_cliques)
t_vertex_set *adj_set;
long *sub_set;
t_set_list **list_of_cliques;
{
  t_v_arr_of_v_lists adj_list, fill_in_adj_list;
  t_v_arr_of_order order;
  t_o_arr_of_vertex invers_order;
  t_v_arr_of_v_sets c;
  t_v_arr_of_boolean complete;
  boolean decomposable;
  t_vertex v, FORLIM;

  *list_of_cliques = NULL;
  if (cardinality(sub_set) <= 10) {
    if (P_setequal(sub_set, delta))
      find_cliques_(adj_set, list_of_cliques);
    else
      find_sub_cliques(adj_set, sub_set, list_of_cliques);
    return;
  }
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    if (P_inset(v, sub_set))
      P_setint(adj_set[v - MIN_VERTEX], sub_set, adj_set[v - MIN_VERTEX]);
    else
      P_setcpy(adj_set[v - MIN_VERTEX], empty_set);
  }
  adj_set_to_adj_list(adj_set, adj_list);
  find_cliques_and_order(adj_set, adj_list, fill_in_adj_list, order,
			 invers_order, c, complete, &decomposable, sub_set,
			 list_of_cliques);
  if (!decomposable)
    dispose_adj_list(fill_in_adj_list);
  dispose_adj_list(adj_list);
}  /* find_cliques */


/*@+"hyper.p"*/


Static boolean test_graphical(adj_set, gc)
t_vertex_set *adj_set;
t_set_list **gc;
{
  t_set_list *p, *q, *work, *gc_a, *gc_b;
  boolean ok;
  t_vertex_set a, b, g;
  t_vertex v, FORLIM;
  t_integer count;

  P_setcpy(g, empty_set);
  p = *gc;
  work = NULL;
  count = 0;
  while (p != NULL) {
    count++;
    P_setunion(g, g, p->vertex_set);
    insert_set_in_set_list(empty_set, &work);
    p = p->pointer;
  }
  ok = true;
  if (count > 2) {
    FORLIM = last_vertex;
    for (v = first_vertex; v <= FORLIM; v++) {
      if (P_inset(v, g) && ok) {
	gc_a = NULL;
	gc_b = NULL;
	p = *gc;
	while (p != NULL) {
	  if (P_inset(v, p->vertex_set)) {
	    q = work;
	    work = work->pointer;
	    P_setcpy(q->vertex_set, p->vertex_set);
	    q->pointer = gc_b;
	    gc_b = q;
	  } else {
	    P_setint(a, adj_set[v - MIN_VERTEX], p->vertex_set);
	    if (!P_setequal(a, empty_set)) {
	      q = work;
	      work = work->pointer;
	      P_setcpy(q->vertex_set, p->vertex_set);
	      q->pointer = gc_a;
	      gc_a = q;
	    }
	  }
	  p = p->pointer;
	}
	p = gc_a;
	while (ok && p != NULL) {
	  P_setint(a, adj_set[v - MIN_VERTEX], p->vertex_set);
	  P_addset(P_expset(b, 0L), v);
	  P_setunion(a, a, b);
	  ok = false;
	  q = gc_b;
	  while (q != NULL && !ok) {
	    if (P_subset(a, q->vertex_set))
	      ok = true;
	    else
	      q = q->pointer;
	  }
	  p = p->pointer;
	}
	if (gc_a != NULL) {
	  p = gc_a;
	  q = gc_a->pointer;
	  while (q != NULL) {
	    p = p->pointer;
	    q = q->pointer;
	  }
	  p->pointer = work;
	  work = gc_a;
	}
	if (gc_b != NULL) {
	  p = gc_b;
	  q = gc_b->pointer;
	  while (q != NULL) {
	    p = p->pointer;
	    q = q->pointer;
	  }
	  p->pointer = work;
	  work = gc_b;
	}
      }
    }
  }
  dispose_set_list(&work);
  return ok;
}  /* test_graphical */


Static boolean test_decomposable_hypergraph(g_c, a, b, d, g_c_a, g_c_b)
t_set_list **g_c;
long *a, *b, *d;
t_set_list **g_c_a, **g_c_b;
{
  t_set_list *g_c_c, *g_c_e, *p, *p1, *p2;
  boolean ok;
  t_vertex_set vertex_set;

  *g_c_a = NULL;
  *g_c_b = NULL;
  p = *g_c;
  while (p != NULL) {
    P_setint(vertex_set, p->vertex_set, a);
    insert_clique(vertex_set, g_c_a);
    P_setint(vertex_set, p->vertex_set, b);
    insert_clique(vertex_set, g_c_b);
    p = p->pointer;
  }
  g_c_c = NULL;
  p = *g_c_a;
  while (p != NULL) {
    insert_clique(p->vertex_set, &g_c_c);
    p = p->pointer;
  }
  p = *g_c_b;
  while (p != NULL) {
    insert_clique(p->vertex_set, &g_c_c);
    p = p->pointer;
  }
  g_c_e = NULL;
  p1 = *g_c_a;
  while (p1 != NULL) {
    p2 = *g_c_b;
    while (p2 != NULL) {
      P_setint(vertex_set, p1->vertex_set, p2->vertex_set);
      insert_clique(vertex_set, &g_c_e);
      p2 = p2->pointer;
    }
    p1 = p1->pointer;
  }
  if (g_c_e != NULL)
    ok = (P_setequal(g_c_e->vertex_set, d) && g_c_e->pointer == NULL) &
	 test_list_of_sets_subset_of_list_of_sets(*g_c, g_c_c);
  else
    ok = false;
  if (!ok) {
    dispose_set_list(g_c_a);
    dispose_set_list(g_c_b);
  }
  dispose_set_list(&g_c_c);
  dispose_set_list(&g_c_e);
  return ok;
}  /* test_decomposable_hypergraph */


Static Void find_graphical_and_decomposable_gc(sets_h_g_c, sets_d_g_c,
  sets_g_g_c, decomposable, graphical)
t_set_list **sets_h_g_c, **sets_d_g_c, **sets_g_g_c;
boolean *decomposable, *graphical;
{
  t_v_arr_of_v_sets fill_in_adj_set, adj_set;
  t_v_arr_of_v_lists adj_list;
  t_vertex v;
  t_vertex_set model_set;
  t_v_arr_of_v_lists fill_in_adj_list;
  t_v_arr_of_order order;
  t_o_arr_of_vertex invers_order;
  t_v_arr_of_v_sets c;
  t_v_arr_of_boolean complete;
  t_vertex FORLIM;

  *sets_g_g_c = NULL;
  *sets_d_g_c = NULL;
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    order[v - MIN_VERTEX] = 1;
    fill_in_adj_list[v - MIN_VERTEX] = NULL;
    P_setcpy(c[v - MIN_VERTEX], empty_set);
    P_clrbits_B(complete, v - MIN_VERTEX, 0, 3);
  }
  *graphical = true;
  *decomposable = true;
  hypergraph_sets_to_graph_sets(*sets_h_g_c, model_set, adj_set);
  adj_set_to_adj_list(adj_set, adj_list);
  if (!test_graphical(adj_set, sets_h_g_c)) {
    *graphical = false;
    find_cliques_and_order(adj_set, adj_list, fill_in_adj_list, order,
			   invers_order, c, complete, decomposable, model_set,
			   sets_g_g_c);
    if (!*decomposable) {
      adj_list_to_adj_set(fill_in_adj_list, fill_in_adj_set);
      find_cliques(fill_in_adj_set, model_set, sets_d_g_c);
    }
  } else {
    maximum_cardinality_search(adj_list, order, invers_order);
    if (!test_for_zero_fill_in(adj_list, order, invers_order)) {
      *decomposable = false;
      lex_m(adj_list, order, invers_order, fill_in_adj_list);
      adj_list_to_adj_set(fill_in_adj_list, fill_in_adj_set);
      find_cliques(fill_in_adj_set, model_set, sets_d_g_c);
    }
  }
  dispose_adj_list(fill_in_adj_list);
  dispose_adj_list(adj_list);
}  /* find_graphical_and_decomposable_gc */


Static Void pick_partitioning(adj_list, g, list_of_sets, a, d, b)
t_vertex_list **adj_list;
long *g;
t_set_list *list_of_sets;
long *a, *d, *b;
{
  long s, s1, s2;
  t_vertex u;
  t_vertex_set vertex_set;

  s = dimension;
  while (list_of_sets != NULL) {
    u = first_vertex;
    P_setdiff(vertex_set, g, list_of_sets->vertex_set);
    while (!P_inset(u, vertex_set))
      u++;
    find_connected_component(g, list_of_sets->vertex_set, a, &u, adj_list);
    P_setunion(vertex_set, a, list_of_sets->vertex_set);
    s1 = cardinality(vertex_set);
    P_setdiff(vertex_set, g, a);
    s2 = cardinality(vertex_set);
    if (s1 < s && s2 < s) {
      P_setcpy(d, list_of_sets->vertex_set);
      s = s1;
      if (s2 > s)
	s = s2;
    }
    list_of_sets = list_of_sets->pointer;
  }
  u = first_vertex;
  P_setdiff(vertex_set, g, d);
  while (!P_inset(u, vertex_set))
    u++;
  find_connected_component(g, d, a, &u, adj_list);
  P_setdiff(b, g, a);
  P_setdiff(b, b, d);
}  /* pick_partitioning */


/*@+"fillin.p"*/


Static double state_space_size(q)
t_set_list *q;
{
  t_long_real tmp_size;

  tmp_size = 0.0;
  while (q != NULL) {
    tmp_size += marginal_dimension_real(q->vertex_set);
    q = q->pointer;
  }
  return tmp_size;
}  /* state_space_size */


Static t_vertex select_vertex(g, adj_set)
long *g;
t_vertex_set *adj_set;
{
  t_vertex v, u, FORLIM;
  t_long_real size, size_u;

  size_u = INFINITY_REAL;
  u = MAX_VERTEX;
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    if (P_inset(v, g)) {
      switch (c_factorizes) {

      case 1:
	size = vertex_inf[v - MIN_VERTEX].levels;
	break;

      case 2:
	size = cardinality(adj_set[v - MIN_VERTEX]);
	break;

      case 3:
	size = marginal_dimension_real(adj_set[v - MIN_VERTEX]);
	break;
      }
      if (size < size_u) {
	size_u = size;
	u = v;
      }
    }
  }
  return u;
}  /* select_vertex */


/* Local variables for find_smallest_state_fill_in: */
struct LOC_find_smallest_state_fill_in {
  t_long_real size, old_size;
  t_set_list *fill_in, *fill_in_start, *r, *result;
  t_vertex v1, v2;
} ;

Local Void find_d(g, adj_set, LINK)
long *g;
t_vertex_set *adj_set;
struct LOC_find_smallest_state_fill_in *LINK;
{
  t_vertex v, u;
  t_v_arr_of_v_sets new_adj_set;
  t_set_list *p;
  t_vertex_set a, b, c, v_set, u_set;
  t_vertex FORLIM, FORLIM1;

  /*$ifdef TRACE*/
  if (boolean_option[7]) {
    write_pch(stdout, " Find D   ", 8L);
    write_integer(stdout, cardinality(g), 10L);
    write_pch(stdout, " G:       ", 4L);
    print_vertex_set(g);
    write_pch(stdout, " Fill In: ", 10L);
    print_g_c(LINK->fill_in, 0L, line_length);
    write_pch(stdout, " Result:  ", 10L);
    print_g_c(LINK->result, 0L, line_length);
    write_line(stdout);
  }
  /*$endif TRACE*/
  if (adj_set_decomposable(adj_set)) {
    find_cliques(adj_set, g, &LINK->r);
    if (LINK->fill_in_start != NULL)
      LINK->fill_in_start->pointer = LINK->r;
    else
      LINK->fill_in = LINK->r;
    LINK->size = state_space_size(LINK->fill_in);
    if (LINK->size < LINK->old_size) {
      LINK->old_size = LINK->size;
      dispose_set_list(&LINK->result);
      copy_set_list(LINK->fill_in, &LINK->result);
    }
    /*$ifdef TRACE*/
    if (boolean_option[7]) {
      write_pch(stdout, " Tail:    ", 7L);
      print_g_c(LINK->r, 0L, line_length);
      write_pch(stdout, " Size:    ", 7L);
      write_real(stdout, LINK->size, 10L, 1L);
      write_pch(stdout, " Result:  ", 9L);
      print_g_c(LINK->result, 0L, line_length);
      write_line(stdout);
    }
    /*$endif TRACE*/
    if (LINK->fill_in_start != NULL)
      LINK->fill_in_start->pointer = NULL;
    dispose_set_list(&LINK->r);
    return;
  }
  p = (t_set_list *)Malloc(sizeof(t_set_list));
  if (p == NULL)
    _OutMem();
  p->pointer = LINK->fill_in;
  LINK->fill_in = p;
  if (LINK->fill_in_start == NULL)
    LINK->fill_in_start = LINK->fill_in;
  FORLIM = LINK->v2;
  for (u = LINK->v1; u <= FORLIM; u++) {
    if (P_inset(u, g)) {
      P_addset(P_expset(u_set, 0L), u);
      P_setcpy(a, adj_set[u - MIN_VERTEX]);
      P_setunion(p->vertex_set, a, u_set);
      /*$ifdef TRACE*/
      if (boolean_option[7]) {
	write_pch(stdout, " Insert D ", 10L);
	write_pch(stdout, " U:       ", 4L);
	print_vertex_set(u_set);
	write_pch(stdout, " A:       ", 4L);
	print_vertex_set(a);
	write_line(stdout);
      }
      FORLIM1 = last_vertex;
      /*$endif TRACE*/
      for (v = first_vertex; v <= FORLIM1; v++) {
	if (P_inset(v, a)) {
	  P_addset(P_expset(v_set, 0L), v);
	  P_setdiff(b, a, v_set);
	  P_setdiff(c, adj_set[v - MIN_VERTEX], u_set);
	  P_setunion(new_adj_set[v - MIN_VERTEX], c, b);
	} else
	  P_setcpy(new_adj_set[v - MIN_VERTEX], adj_set[v - MIN_VERTEX]);
      }
      P_setcpy(new_adj_set[u - MIN_VERTEX], empty_set);
      P_setdiff(b, g, u_set);
      find_d(b, new_adj_set, LINK);
    }
  }
  LINK->fill_in = LINK->fill_in->pointer;
  Free(p);
}  /* find_d */


Static t_set_list *find_smallest_state_fill_in(g, adj_set)
long *g;
t_vertex_set *adj_set;
{
  struct LOC_find_smallest_state_fill_in Local_Var;

  /*$ifdef TRACE*/
  if (boolean_option[7]) {
    write_pch(stdout, " Find Smallest State Fill In  ", 30L);
    write_line(stdout);
  }
  /*$endif TRACE*/
  Local_Var.v1 = first_vertex;
  while (!P_inset(Local_Var.v1, g))
    Local_Var.v1++;
  Local_Var.v2 = last_vertex;
  while (!P_inset(Local_Var.v2, g))
    Local_Var.v2--;
  Local_Var.result = NULL;
  Local_Var.fill_in = NULL;
  Local_Var.fill_in_start = NULL;
  Local_Var.old_size = INFINITY_REAL;
  find_d(g, adj_set, &Local_Var);
  /*$ifdef TRACE*/
  if (!boolean_option[7])
    return Local_Var.result;
  write_pch(stdout, " Find Smallest State Fill In: ", 30L);
  print_g_c(Local_Var.result, 0L, line_length);
  write_line(stdout);
  /*$endif TRACE*/
  return Local_Var.result;
}  /* find_smallest_state_fill_in */


Static t_set_list *find_fill_in_(gc)
t_set_list **gc;
{
  t_set_list *fill_in, *p, *fill_in_start;
  boolean ok;
  t_vertex_set a, b, c, v_set, u_set, g;
  t_vertex v, u;
  t_v_arr_of_v_sets adj_set;
  t_vertex FORLIM;

  hypergraph_sets_to_graph_sets(*gc, g, adj_set);
  if (sorted & (cardinality(g) < 8))
    return (find_smallest_state_fill_in(g, adj_set));
  else {
    /*$ifdef TRACE*/
    if (boolean_option[7]) {
      write_pch(stdout, " Find Fill In                 ", 30L);
      write_line(stdout);
    }
    /*$endif TRACE*/
    fill_in_start = NULL;
    fill_in = NULL;
    ok = !adj_set_decomposable(adj_set);
    while (ok) {
      u = select_vertex(g, adj_set);
      P_addset(P_expset(u_set, 0L), u);
      P_setcpy(a, adj_set[u - MIN_VERTEX]);
      P_setunion(b, a, u_set);
      insert_set_in_set_list(b, &fill_in);
      if (fill_in_start == NULL)
	fill_in_start = fill_in;
      P_setdiff(g, g, u_set);
      FORLIM = last_vertex;
      for (v = first_vertex; v <= FORLIM; v++) {
	if (P_inset(v, a)) {
	  P_addset(P_expset(v_set, 0L), v);
	  P_setdiff(b, a, v_set);
	  P_setdiff(c, adj_set[v - MIN_VERTEX], u_set);
	  P_setunion(adj_set[v - MIN_VERTEX], c, b);
	}
      }
      P_setcpy(adj_set[u - MIN_VERTEX], empty_set);
      ok = !adj_set_decomposable(adj_set);
    }
    find_cliques(adj_set, g, &p);
    if (fill_in != NULL)
      fill_in_start->pointer = p;
    else
      fill_in = p;
    state_space_size(fill_in);
    /*$ifdef TRACE*/
    if (!boolean_option[7])
      return fill_in;
    write_pch(stdout, " Find Fill In:                ", 30L);
    print_g_c(fill_in, 0L, line_length);
    write_line(stdout);
    /*$endif TRACE*/
    return fill_in;
  }
}  /* find_fill_in_ */


Static t_set_list *find_fill_in(generating_class)
t_set_list **generating_class;
{
  boolean decomposable, graphical;
  t_set_list *fill_in, *ggc;

  if (!fast) {
    fill_in = find_fill_in_(generating_class);
    return fill_in;
  }
  fill_in = NULL;
  ggc = NULL;
  decomposable = false;
  graphical = false;
  find_graphical_and_decomposable_gc(generating_class, &fill_in, &ggc,
				     &decomposable, &graphical);
  if (graphical && decomposable) {
    copy_set_list(*generating_class, &fill_in);
    return fill_in;
  }
  if (!graphical && decomposable)
    fill_in = ggc;
  else if (ggc != NULL)
    dispose_set_list(&ggc);
  return fill_in;
}  /* find_fill_in */


/*@+"radim.p"*/


Static Void set_list_to_ips_set_list(set_list, ips_set_list)
t_set_list *set_list;
t_ips_set_list **ips_set_list;
{
  t_ips_set_list *p;

  *ips_set_list = NULL;
  while (set_list != NULL) {
    p = (t_ips_set_list *)Malloc(sizeof(t_ips_set_list));
    if (p == NULL)
      _OutMem();
    p->pointer = *ips_set_list;
    p->n_offset = MAX_OFFSET;
    P_setcpy(p->vertex_set, set_list->vertex_set);
    *ips_set_list = p;
    set_list = set_list->pointer;
  }
}  /* set_list_to_ips_set_list */


Static Void sub_insert_ips_element_2(ips_list, ips_set_list, a, radim_part,
				     n_offset, p_offset, link_q_tables)
t_list_ips_elements **ips_list;
t_ips_set_list *ips_set_list;
long *a;
boolean radim_part;
t_offset n_offset, p_offset;
t_offset_list *link_q_tables;
{
  t_list_ips_elements *q;

  q = (t_list_ips_elements *)Malloc(sizeof(t_list_ips_elements));
  if (q == NULL)
    _OutMem();
  q->pointer = *ips_list;
  q->ips_element.gen_class = ips_set_list;
  P_setcpy(q->ips_element.a, a);
  q->ips_element.radim_part = radim_part;
  q->ips_element.n_offset = n_offset;
  q->ips_element.p_offset = p_offset;
  q->ips_element.link_q_tables = link_q_tables;
  *ips_list = q;
}  /* sub_insert_ips_element_2 */


/* Local variables for find_upper_and_lower: */
struct LOC_find_upper_and_lower {
  long *count;
  t_offset_list **upper, **lower, **from;
  t_vertex_set b;
} ;

Local Void insert_set(set_upper, set_lower, LINK)
long *set_upper, *set_lower;
struct LOC_find_upper_and_lower *LINK;
{
  /*$ifdef TRACE*/
  if (boolean_option[5]) {
    write_pch(stdout, " Insert: ", 9L);
    print_vertex_set(set_upper);
    print_vertex_set(set_lower);
    write_line(stdout);
  }
  /*$endif TRACE*/
  (*LINK->count)++;
  P_setdiff(LINK->b, set_upper, set_lower);
  insert_offset(LINK->b, 123L, LINK->upper);
  insert_offset(set_lower, 123L, LINK->lower);
  insert_offset(empty_set, 123L, LINK->from);
}  /* insert_set */


Static Void find_upper_and_lower(beta, invers_order, r, count_, upper_,
				 lower_, from_)
short *beta;
t_vertex *invers_order;
t_offset_list **r;
long *count_;
t_offset_list **upper_, **lower_, **from_;
{
  struct LOC_find_upper_and_lower Local_Var;
  t_vertex_set a;
  t_offset_list *q;
  t_long_integer i;

  Local_Var.count = count_;
  Local_Var.upper = upper_;
  Local_Var.lower = lower_;
  Local_Var.from = from_;
  *Local_Var.count = 0;
  q = *r;
  while (q != NULL) {
    P_setcpy(a, empty_set);
    i = dimension;
    while (beta[invers_order[i - 1] - MIN_VERTEX] <= q->offset) {
      if (P_inset(invers_order[i - 1], q->vertex_set))
	P_addset(a, invers_order[i - 1]);
      i--;
    }
    insert_set(q->vertex_set, a, &Local_Var);
    q = q->pointer;
  }
}  /* find_upper_and_lower */


Static boolean insert_gc_in_radim_element(a, ips_generating_class,
  generating_class, radim_list, link_q_tables)
long *a;
t_ips_set_list **ips_generating_class;
t_set_list *generating_class;
t_list_radim_elements **radim_list;
t_offset_list *link_q_tables;
{
  boolean error, found;
  t_integer pred_count, count;
  t_vertex_set vertex_set;
  t_list_radim_elements *r;
  t_offset_list *r_;
  t_v_arr_of_order alpha, beta;
  t_o_arr_of_vertex invers_order;
  t_radim_part *p;
  t_set_list *fill_in, *tmp_set_list;
  t_offset_list *q;
  t_adjacency_matrix matrix_gc;

  if (c_factorizes != 1 && !em && mean_ips_in_use == normal_ips &&
      !P_setequal(generating_class->vertex_set, empty_set)) {
    /*$ifdef TRACE*/
    if (boolean_option[5]) {
      write_pch(stdout, " Radim: ", 8L);
      print_vertex_set(a);
      print_g_c(generating_class, 21L, line_length);
      write_line(stdout);
    }
    /*$endif TRACE*/
    r = (t_list_radim_elements *)Malloc(sizeof(t_list_radim_elements));
    if (r == NULL)
      _OutMem();
    r->pointer = *radim_list;
    *radim_list = r;
    P_setcpy(r->radim_element.a, a);
    r->radim_element.gen_class = *ips_generating_class;
    r->radim_element.link_q_tables = link_q_tables;
    r->radim_element.radim_parts = NULL;
    r->radim_element.lower_n_offsets = NULL;
    if (link_q_tables == NULL)
      fill_in = find_fill_in(&generating_class);
    else {
      tmp_set_list = NULL;
      copy_set_list(generating_class, &tmp_set_list);
      q = link_q_tables;
      while (q != NULL) {
	P_setint(vertex_set, a, q->vertex_set);
	insert_clique(vertex_set, &tmp_set_list);
	q = q->pointer;
      }
      fill_in = find_fill_in(&tmp_set_list);
      dispose_set_list(&tmp_set_list);
    }
    /*$ifdef TRACE*/
    if (boolean_option[5]) {
      write_pch(stdout, " FillIn: ", 9L);
      print_vertex_set(a);
      print_g_c(fill_in, 21L, line_length);
      write_line(stdout);
    }
    /*$endif TRACE*/
    create_adjacency_matrix(&matrix_gc, fill_in);
    pred_count = 0;
    error = false;
    while (generating_class != NULL && !error) {
      p = r->radim_element.radim_parts;
      found = false;
      while (!found && p != NULL) {
	P_setunion(vertex_set, p->upper->vertex_set, p->lower->vertex_set);
	if (P_subset(generating_class->vertex_set, vertex_set))
	  found = true;
	if (!found)
	  p = p->pointer;
      }
      if (found)
	insert_offset(generating_class->vertex_set, 111L, &p->generators);
      else {
	p = (t_radim_part *)Malloc(sizeof(t_radim_part));
	if (p == NULL)
	  _OutMem();
	p->pointer = r->radim_element.radim_parts;
	r->radim_element.radim_parts = p;
	p->upper = NULL;
	p->lower = NULL;
	p->from = NULL;
	p->generators = NULL;
	insert_offset(generating_class->vertex_set, 222L, &p->generators);
	/*$ifdef TRACE*/
	if (boolean_option[5]) {
	  write_pch(stdout, " Before: ", 9L);
	  print_vertex_set(generating_class->vertex_set);
	  write_line(stdout);
	}
	/*$endif TRACE*/
	restricted_maximim_cardinality_search_on_hypergraph(&matrix_gc,
	  generating_class->vertex_set, &found, alpha, beta, invers_order,
	  &r_);
	find_upper_and_lower(beta, invers_order, &r_, &count, &p->upper,
			     &p->lower, &p->from);
	if (pred_count == 0)
	  pred_count = count;
	else
	  error = (pred_count != count);
	dispose_offset_list(&r_);
      }
      generating_class = generating_class->pointer;
    }
    delete_edges_with_vertices(&matrix_gc, a);
    dispose_set_list(&fill_in);
    if (error)
      note_error(101L);
    if (error) {
      dispose_radim_element(&(*radim_list)->radim_element);
      r = *radim_list;
      *radim_list = (*radim_list)->pointer;
      Free(r);
      return false;
    } else
      return true;
  } else
    return false;
}  /* insert_gc_in_radim_element */


Static Void seek_dj(d, radim_part, c, offset)
long *d;
t_radim_part **radim_part;
long *c;
t_offset *offset;
{
  boolean found;
  t_offset_list *upper, *lower;
  t_vertex_set vertex_set;

  found = false;
  upper = (*radim_part)->upper;
  lower = (*radim_part)->lower;
  while (upper != NULL && !found) {
    P_setunion(vertex_set, upper->vertex_set, lower->vertex_set);
    if (P_subset(d, vertex_set))
      found = true;
    else {
      upper = upper->pointer;
      lower = lower->pointer;
    }
  }
  if (found) {
    P_setunion(c, upper->vertex_set, lower->vertex_set);
    *offset = upper->offset;
  } else
    note_error(102L);
}  /* seek_dj */


Static Void return_ips_list_for_radim_elements(radim_list, ips_list)
t_list_radim_elements *radim_list;
t_list_ips_elements **ips_list;
{
  t_offset_list *upper, *lower;
  t_vertex_set both_;

  while (radim_list != NULL) {
    if (radim_list->radim_element.radim_parts != NULL) {
      upper = radim_list->radim_element.radim_parts->upper;
      lower = radim_list->radim_element.radim_parts->lower;
      while (upper != NULL) {
	P_setunion(both_, upper->vertex_set, lower->vertex_set);
	sub_insert_ips_element_2(ips_list,
				 radim_list->radim_element.gen_class, both_,
				 true, 333L, 333L, NULL);
	upper = upper->pointer;
	lower = lower->pointer;
      }
    }
    radim_list = radim_list->pointer;
  }
}  /* return_ips_list_for_radim_elements */


Local Void revers_list(p)
t_integer_list **p;
{
  t_integer_list *hp1, *hp2;

  hp1 = NULL;
  while (*p != NULL) {
    hp2 = hp1;
    hp1 = *p;
    *p = (*p)->pointer;
    hp1->pointer = hp2;
  }
  *p = hp1;
}  /* revers_list */


Static Void find_of_one_radim_marginals_and_insert_offsets(radim_element,
  ips_list, ok_n, ok_p)
t_radim_element *radim_element;
t_list_ips_elements **ips_list;
boolean *ok_n, *ok_p;
{
  t_long_integer m, tmp_fpa, max_m;
  t_vertex_set a, d, g;
  t_radim_part *radim_part;
  t_offset_list *generators, *upper, *lower, *from;
  t_offset dummy_offset;
  t_integer_list *integer_list;

  *ok_n = true;
  *ok_p = true;
  tmp_fpa = fpa;
  radim_part = radim_element->radim_parts;
  if (radim_part != NULL) {
    generators = radim_part->generators;
    while (generators != NULL && *ok_n) {
      generators->offset = return_offset(generators->vertex_set, ok_n);
      generators = generators->pointer;
    }
    from = radim_part->from;
    upper = radim_part->upper;
    lower = radim_part->lower;
    P_setunion(a, upper->vertex_set, lower->vertex_set);
    P_setcpy(g, a);
    upper->offset = tmp_fpa;
    lower->offset = return_offset(a, ok_n);
    m = marginal_dimension(a);
    if (m < MAX_P_CELL_NUMBER_MAX - tmp_fpa)
      tmp_fpa += m;
    else
      *ok_p = false;
    sub_insert_ips_element_2(ips_list, radim_element->gen_class, a, true,
			     lower->offset, upper->offset, NULL);
    upper = upper->pointer;
    lower = lower->pointer;
    from = from->pointer;
    max_m = m;
    while (upper != NULL && *ok_p) {
      P_setunion(a, upper->vertex_set, lower->vertex_set);
      upper->offset = tmp_fpa;
      lower->offset = return_offset(a, ok_n);
      m = marginal_dimension(a);
      if (m < MAX_P_CELL_NUMBER_MAX - tmp_fpa)
	tmp_fpa += m;
      else
	*ok_p = false;
      if (m > max_m)
	max_m = m;
      sub_insert_ips_element_2(ips_list, radim_element->gen_class, a, true,
			       lower->offset, upper->offset, NULL);
      P_setint(d, g, a);
      P_setunion(g, g, a);
      seek_dj(d, &radim_part, d, &dummy_offset);
      P_setcpy(from->vertex_set, d);
      from->offset = dummy_offset;
      from = from->pointer;
      upper = upper->pointer;
      lower = lower->pointer;
    }
    radim_part = radim_part->pointer;
  }
  m = max_m;
  if (ips_in_use == 1)
    m += tmp_fpa - fpa;
  if (m < MAX_P_CELL_NUMBER_MAX - tmp_fpa)
    tmp_fpa += m;
  else
    *ok_p = false;
  if (*ok_p && !TURBO_PC)
    *ok_p = space_in_p_array(tmp_fpa, 0L);
  if (*ok_n && *ok_p)
    fpa = tmp_fpa - m;
  if (*ok_p) {
    while (radim_part != NULL && *ok_n) {
      generators = radim_part->generators;
      while (generators != NULL && *ok_n) {
	generators->offset = return_offset(generators->vertex_set, ok_n);
	generators = generators->pointer;
      }
      from = radim_part->from;
      upper = radim_part->upper;
      lower = radim_part->lower;
      P_setunion(a, upper->vertex_set, lower->vertex_set);
      seek_dj(a, &radim_element->radim_parts, d, &dummy_offset);
      upper->offset = dummy_offset;
      P_setcpy(g, a);
      lower->offset = return_offset(a, ok_n);
      upper = upper->pointer;
      lower = lower->pointer;
      from = from->pointer;
      while (upper != NULL) {
	P_setunion(a, upper->vertex_set, lower->vertex_set);
	seek_dj(a, &radim_element->radim_parts, d, &dummy_offset);
	upper->offset = dummy_offset;
	P_setint(d, g, a);
	P_setunion(g, g, a);
	seek_dj(d, &radim_part, d, &dummy_offset);
	P_setcpy(from->vertex_set, d);
	from->offset = dummy_offset;
	lower->offset = return_offset(a, ok_n);
	from = from->pointer;
	upper = upper->pointer;
	lower = lower->pointer;
      }
      radim_part = radim_part->pointer;
    }
  }
  if (radim_element->radim_parts == NULL)
    return;
  lower = radim_element->radim_parts->lower;
  integer_list = NULL;
  while (lower != NULL && *ok_n) {
    insert_integer_in_integer_list(return_offset(lower->vertex_set, ok_n),
				   &integer_list);
    lower = lower->pointer;
  }
  revers_list(&integer_list);
  dispose_integer_list(&radim_element->lower_n_offsets);
  radim_element->lower_n_offsets = integer_list;
}  /* find_of_one_radim_marginals_and_insert_offsets */


Static Void find_radim_marginals_and_insert_offsets(radim_list, ips_list,
						    ok_n, ok_p)
t_list_radim_elements **radim_list;
t_list_ips_elements **ips_list;
boolean *ok_n, *ok_p;
{
  t_list_radim_elements *p_radim;
  t_list_ips_elements *p, *q;
  boolean ok;

  ok = true;
  p = *ips_list;
  while (*ips_list != NULL && ok) {
    if (!(*ips_list)->ips_element.radim_part) {
      ok = false;
      break;
    }
    q = *ips_list;
    *ips_list = (*ips_list)->pointer;
    dispose_ips_element(&q->ips_element);
    Free(q);
  }
  p_radim = *radim_list;
  while (p_radim != NULL && *ok_n && *ok_p) {
    find_of_one_radim_marginals_and_insert_offsets(&p_radim->radim_element,
						   ips_list, ok_n, ok_p);
    p_radim = p_radim->pointer;
  }
  if (*ok_n || !*ok_p)
    return;
  while (*ips_list != p) {
    q = *ips_list;
    *ips_list = (*ips_list)->pointer;
    Free(q);
  }
}  /* find_radim_marginals_and_insert_offsets */


/*@+"decomp.p"*/


Static Void find_perfect_scheme_expression(model_set, adj_list, order,
  invers_order, constant, expression, dim)
long *model_set;
t_vertex_list **adj_list;
short *order;
t_vertex *invers_order;
double *constant;
t_expression **expression;
long *dim;
{
  t_vertex_set a, b;
  t_1_max_dimension i;
  t_vertex_list *p;
  t_long_integer x;
  t_vertex u, v;
  boolean ok;
  t_v_arr_of_v_sets c;
  t_v_arr_of_integer product;
  t_1_max_dimension FORLIM;

  *dim = 0;
  *constant = 1.0;
  FORLIM = dimension;
  for (i = 1; i <= FORLIM; i++) {
    u = invers_order[i - 1];
    x = 1;
    P_setcpy(a, empty_set);
    if (P_inset(u, model_set)) {
      p = adj_list[u - MIN_VERTEX];
      while (p != NULL) {
	v = p->vertex;
	if (i < order[v - MIN_VERTEX]) {
	  P_addset(a, v);
	  if (x < (double)INFINITY / vertex_inf[v - MIN_VERTEX].levels)
	    x *= vertex_inf[v - MIN_VERTEX].levels;
	  else
	    x = INFINITY;
	}
	p = p->pointer;
      }
    }
    P_setcpy(c[u - MIN_VERTEX], a);
    product[u - MIN_VERTEX] = x;
  }
  i = 1;
  while (i <= dimension) {
    u = invers_order[i - 1];
    if (P_inset(u, model_set)) {
      P_setcpy(a, c[u - MIN_VERTEX]);
      P_addset(P_expset(b, 0L), u);
      P_setunion(b, a, b);
      put_factor(expression, b, 1L);
      ok = true;
      while (i < dimension && ok) {
	P_addset(P_expset(b, 0L), invers_order[i]);
	P_setunion(b, c[invers_order[i] - MIN_VERTEX], b);
	if (P_subset(b, a))
	  i++;
	else
	  ok = false;
      }
      put_factor(expression, c[invers_order[i - 1] - MIN_VERTEX], -1L);
      x = product[u - MIN_VERTEX];
      if (*dim < INFINITY &&
	  x < (double)INFINITY / vertex_inf[u - MIN_VERTEX].levels)
	*dim += vertex_inf[u - MIN_VERTEX].levels * x -
		product[invers_order[i - 1] - MIN_VERTEX];
      else
	*dim = INFINITY;
    } else
      *constant /= vertex_inf[u - MIN_VERTEX].levels;
    i++;
  }
}  /* find_perfect_scheme_expression */


Static long find_dimension(p)
t_set_list *p;
{
  long Result;
  t_set_list *q;
  t_vertex_set c, vertex_set;
  t_long_integer d1, d2, d3;

  if (p->pointer == NULL) {
    d1 = marginal_dimension(p->vertex_set);
    if (d1 != INFINITY)
      d1--;
    return d1;
  }
  q = NULL;
  P_setcpy(c, p->vertex_set);
  d1 = marginal_dimension(c);
  d2 = find_dimension(p->pointer);
  p = p->pointer;
  while (p != NULL) {
    P_setint(vertex_set, c, p->vertex_set);
    insert_clique(vertex_set, &q);
    p = p->pointer;
  }
  d3 = find_dimension(q);
  if (d1 != INFINITY && d2 != INFINITY && d3 != INFINITY)
    Result = d1 + d2 - d3 - 1;
  else
    Result = INFINITY;
  dispose_set_list(&q);
  return Result;
}  /* find_dimension */


Static Void insert_g_c(a, generating_class, link_expression, ips_list,
		       radim_list)
long *a;
t_set_list **generating_class;
t_expression **link_expression;
t_list_ips_elements **ips_list;
t_list_radim_elements **radim_list;
{
  t_ips_set_list *ips_set_list;

  if (*generating_class == NULL)
    return;
  if ((*generating_class)->pointer == NULL &&
      P_setequal((*generating_class)->vertex_set, a)) {
    put_factor(link_expression, a, 1L);
    put_factor(link_expression, empty_set, -1L);
    return;
  }
  set_list_to_ips_set_list(*generating_class, &ips_set_list);
  if (!insert_gc_in_radim_element(a, &ips_set_list, *generating_class,
				  radim_list, NULL))
    sub_insert_ips_element_2(ips_list, ips_set_list, a, false, MAX_OFFSET,
			     MAX_OFFSET, NULL);
}  /* insert_g_c */


Static Void update_dimension_set(dim, a, sign)
long *dim;
long *a;
long sign;
{
  t_long_integer dimension_a;

  if (*dim >= INFINITY)
    return;
  dimension_a = marginal_dimension(a);
  if (dimension_a < INFINITY)
    *dim += sign * (dimension_a - 1);
  else
    *dim = INFINITY;
}  /* update_dimension_set */


Static Void update_dimension_gc(dim, g_c)
long *dim;
t_set_list **g_c;
{
  t_long_integer dimension_a;

  if (*dim >= INFINITY)
    return;
  dimension_a = find_dimension(*g_c);
  if (dimension_a < INFINITY)
    *dim += dimension_a;
  else
    *dim = INFINITY;
}  /* update_dimension_gc */


Static Void hypergraph_find_expression(r, model_set, constant, expression, dim)
t_offset_list **r;
long *model_set;
double *constant;
t_expression **expression;
long *dim;
{
  t_vertex_set a, b;
  t_offset_list *q;

  *dim = 0;
  P_setdiff(b, delta, model_set);
  *constant = 1 / marginal_dimension_real(b);
  q = *r;
  P_setcpy(b, empty_set);
  while (q != NULL) {
    put_factor(expression, q->vertex_set, 1L);
    P_setint(a, b, q->vertex_set);
    put_factor(expression, a, -1L);
    P_setunion(b, b, q->vertex_set);
    update_dimension_set(dim, q->vertex_set, 1L);
    update_dimension_set(dim, a, -1L);
    q = q->pointer;
  }
}  /* hypergraph_find_expression */


Static Void find_connected_component_list(g, d, a, a_list, u, adj_list)
long *g, *d, *a;
t_vertex_list **a_list;
t_vertex *u;
t_vertex_list **adj_list;
{
  t_v_arr_of_boolean explored;
  t_vertex_list *queue, *q, *p;
  t_vertex v, w;
  t_vertex FORLIM;
  long TEMP;

  P_addset(P_expset(a, 0L), *u);
  insert_vertex_in_vertex_list(*u, a_list);
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++)
    P_clrbits_B(explored, v - MIN_VERTEX, 0, 3);
  TEMP = *u - MIN_VERTEX;
  P_putbits_UB(explored, TEMP, 1, 0, 3);
  queue = NULL;
  insert_vertex_in_vertex_list(*u, &queue);
  while (queue != NULL) {
    v = queue->vertex;
    q = queue;
    queue = queue->pointer;
    Free(q);
    p = adj_list[v - MIN_VERTEX];
    while (p != NULL) {
      w = p->vertex;
      if ((!P_getbits_UB(explored, w - MIN_VERTEX, 0, 3)) & (!P_inset(w, d)) &
	  P_inset(w, g)) {
	insert_vertex_in_vertex_list(w, &queue);
	insert_vertex_in_vertex_list(w, a_list);
	P_addset(a, w);
	P_putbits_UB(explored, w - MIN_VERTEX, 1, 0, 3);
      }
      p = p->pointer;
    }
  }
}  /* find_connected_component_list */


Static Void return_and_delete_edges_with_vertices_list(matrix, a_list, edges)
t_adjacency_matrix *matrix;
t_vertex_list *a_list;
t_set_list **edges;
{
  while (a_list != NULL) {
    return_and_delete_edges_with_vertex(matrix, a_list->vertex, edges);
    a_list = a_list->pointer;
  }
}  /* return_and_delete_edges_with_vertices_list */


Local boolean subset_of_an_edge_(i, a, invers_order, matrix)
t_1_max_dimension i;
long *a;
t_vertex *invers_order;
t_adjacency_matrix *matrix;
{
  t_am_node *p;
  boolean b;
  t_vertex u;

  while (!P_inset(invers_order[i - 1], a) && i < dimension)
    i++;
  u = invers_order[i - 1];
  b = true;
  p = matrix->vertex_list[u - MIN_VERTEX];
  while (p != NULL && b) {
    if (P_subset(a, p->link_edge->vertex_set))
      b = false;
    else
      p = p->forward_link;
  }
  return (!b);
}  /* subset_of_an_edge */

Local Void print_adjacency_matrix(matrix)
t_adjacency_matrix *matrix;
{
  t_am_edge_list *p, *q;

  p = matrix->am_edge_list;
  while (p != NULL) {
    write_line(stdout);
    write_pch(stdout, " *** WARNING ***    ", 20L);
    write_line(stdout);
    print_vertex_set(p->vertex_set);
    write_line(stdout);
    write_pch(stdout, " *** WARNING ***    ", 20L);
    write_line(stdout);
    q = p;
    p = p->forward_link;
    Free(q);
  }
}  /* print_adjacency_matrix */


Static Void decompose_non_decomposable(graphical, matrix_gc, model_set,
  adj_list, adj_set, invers_order, c, complete, constant, expression,
  ips_list, radim_list, dim)
boolean *graphical;
t_adjacency_matrix *matrix_gc;
long *model_set;
t_vertex_list **adj_list;
t_vertex_set *adj_set;
t_vertex *invers_order;
t_vertex_set *c;
uchar *complete;
double *constant;
t_expression **expression;
t_list_ips_elements **ips_list;
t_list_radim_elements **radim_list;
long *dim;
{
  t_1_max_dimension i, j;
  t_vertex u, v;
  t_vertex_set a, b, g;
  t_set_list *g_c_a, *g_c_b;
  t_adjacency_matrix matrix_separators;
  t_vertex_list *a_list;
  boolean ok;

  /*$ifdef TRACE*/
  if (boolean_option[6])
    sub_print_invers_order(invers_order, c, complete);
  /*$endif TRACE*/
  new_adjacency_matrix(&matrix_separators);
  a_list = NULL;
  g_c_a = NULL;
  g_c_b = NULL;
  *dim = 0;
  P_setdiff(b, delta, model_set);
  *constant = 1 / marginal_dimension_real(b);
  P_setcpy(g, model_set);
  P_setcpy(b, g);
  i = 1;
  while (!P_setequal(b, empty_set)) {
    u = invers_order[i - 1];
    /*$ifdef TRACE*/
    if (boolean_option[6]) {
      write_line(stdout);
      print_vertex_set_table(b);
      write_integer(stdout, (long)i, 3L);
      print_vertex_on_file(stdout, u);
    }
    /*$endif TRACE*/
    while (!(P_getbits_UB(complete, u - MIN_VERTEX, 0, 3) & P_inset(u, g))) {
      i++;
      u = invers_order[i - 1];
      /*$ifdef TRACE*/
      if (boolean_option[6]) {
	write_integer(stdout, (long)i, 3L);
	print_vertex_on_file(stdout, u);
      }
      /*$endif TRACE*/
    }
    if (*graphical)
      ok = true;
    else
      ok = subset_of_an_edge_(i, c[u - MIN_VERTEX], invers_order, matrix_gc);
    if (ok || i == dimension) {
      if (*graphical)
	ok = P_subset(c[u - MIN_VERTEX], adj_set[u - MIN_VERTEX]);
      else if (ok) {
	P_addset(P_expset(b, 0L), invers_order[i - 1]);
	P_setunion(b, b, c[u - MIN_VERTEX]);
	ok = subset_of_an_edge_(i, b, invers_order, matrix_gc);
      }
      if (ok || c_factorizes == 3) {
	if (ok) {
	  delete_edges_with_vertex(matrix_gc, &u);
	  delete_edges_with_vertex(&matrix_separators, &u);
	}
	j = i + 1;
	if (j < dimension) {
	  v = invers_order[j - 1];
	  P_addset(P_expset(b, 0L), v);
	  P_setunion(b, b, c[v - MIN_VERTEX]);
	  while ((P_subset(b, c[u - MIN_VERTEX]) && j < dimension) &
		 P_inset(v, g)) {
	    if (ok) {
	      delete_edges_with_vertex(matrix_gc, &v);
	      delete_edges_with_vertex(&matrix_separators, &v);
	    }
	    j++;
	    v = invers_order[j - 1];
	    P_addset(P_expset(b, 0L), v);
	    P_setunion(b, b, c[v - MIN_VERTEX]);
	    /*$ifdef TRACE*/
	    if (boolean_option[6]) {
	      print_vertex_set_table(b);
	      write_integer(stdout, (long)j, 3L);
	      print_vertex_on_file(stdout, v);
	    }
	    /*$endif TRACE*/
	  }
	}
	P_addset(P_expset(b, 0L), u);
	P_setunion(b, b, c[u - MIN_VERTEX]);
	i = j - 1;
	u = invers_order[i - 1];
      }
      if (ok) {
	/*$ifdef TRACE*/
	if (boolean_option[6])
	  write_pch(stdout, " Complete ", 10L);
	/*$endif TRACE*/
	P_setdiff(a, b, c[u - MIN_VERTEX]);
	put_factor(expression, b, 1L);
	put_factor(expression, empty_set, -1L);
	insert_edge_in_adjacency_matrix(&matrix_separators, c[u - MIN_VERTEX]);
	update_dimension_set(dim, b, 1L);
      } else {
	/*$ifdef TRACE*/
	if (boolean_option[6])
	  write_pch(stdout, " NonComp ", 9L);
	/*$endif TRACE*/
	find_connected_component_list(g, c[u - MIN_VERTEX], a, &a_list, &u,
				      adj_list);
	return_and_delete_edges_with_vertices_list(matrix_gc, a_list, &g_c_a);
	return_and_delete_edges_with_vertices_list(&matrix_separators, a_list,
						   &g_c_b);
	dispose_vertex_list(&a_list);
	insert_clique(c[u - MIN_VERTEX], &g_c_a);
	add_cliques(g_c_b, &g_c_a);
	dispose_set_list(&g_c_b);
	P_setunion(b, a, c[u - MIN_VERTEX]);
	insert_g_c(b, &g_c_a, expression, ips_list, radim_list);
	insert_edge_in_adjacency_matrix(&matrix_separators, c[u - MIN_VERTEX]);
	update_dimension_gc(dim, &g_c_a);
	dispose_set_list(&g_c_a);
      }
      /*$ifdef TRACE*/
      if (boolean_option[6]) {
	print_vertex_set_table(g);
	print_vertex_set_table(a);
	print_vertex_set_table(c[u - MIN_VERTEX]);
	print_vertex_set_table(b);
      }
      /*$endif TRACE*/
      if (!P_setequal(g, b)) {
	/*$ifdef TRACE*/
	if (boolean_option[6])
	  write_pch(stdout, " Decompose", 10L);
	/*$endif TRACE*/
	put_factor(expression, c[u - MIN_VERTEX], -1L);
	put_factor(expression, empty_set, 1L);
	update_dimension_set(dim, c[u - MIN_VERTEX], -1L);
      }
      P_setdiff(g, g, a);
      /*$ifdef TRACE*/
      if (boolean_option[6]) {
	write_pch(stdout, " End: ", 6L);
	print_vertex_set_table(g);
	print_vertex_set_table(a);
      }
      /*$endif TRACE*/
      P_setdiff(b, g, c[u - MIN_VERTEX]);
    } else if (i > dimension) {
      write_warning(stdout, "Error in Decomposition Algorithm.", 33L);
      P_setcpy(b, empty_set);
    }
    i++;
  }
  delete_edges_with_vertices(&matrix_separators, g);
  print_adjacency_matrix(&matrix_separators);
}  /* decompose_non_decomposable */


Static Void find_partitioning(g_c_1, g_c_2, adj_list, adj_set, g,
			      check_incomplete, list_of_sets)
t_set_list **g_c_1, **g_c_2;
t_vertex_list **adj_list;
t_vertex_set *adj_set;
long *g;
boolean check_incomplete;
t_set_list **list_of_sets;
{
  boolean continue_;
  t_set_list *g_c_a, *g_c_b;
  t_vertex_set a, d, b;
  t_vertex u;
  t_1_max_dimension i;
  t_v_arr_of_order order;
  t_o_arr_of_vertex invers_order;
  t_v_arr_of_v_lists fill_in_adj_list;
  t_v_arr_of_v_sets c;
  t_v_arr_of_boolean complete;
  t_vertex FORLIM;
  long TEMP;

  maximum_cardinality_search(adj_list, order, invers_order);
  if (test_for_zero_fill_in(adj_list, order, invers_order))
    find_c(adj_set, order, invers_order, adj_list, c, complete);
  else {
    FORLIM = last_vertex;
    for (u = first_vertex; u <= FORLIM; u++)
      fill_in_adj_list[u - MIN_VERTEX] = NULL;
    lex_m(adj_list, order, invers_order, fill_in_adj_list);
    find_c(adj_set, order, invers_order, fill_in_adj_list, c, complete);
    dispose_adj_list(fill_in_adj_list);
  }
  continue_ = true;
  i = 1;
  *list_of_sets = NULL;
  while (continue_ && i <= dimension) {
    while (!((TEMP = invers_order[i - 1] - MIN_VERTEX, P_getbits_UB(complete,
		TEMP, 0, 3)) & P_inset(invers_order[i - 1], g)) &&
	   i < dimension)
      i++;
    TEMP = invers_order[i - 1] - MIN_VERTEX;
    if (!(P_getbits_UB(complete, TEMP, 0, 3) & P_inset(invers_order[i - 1], g))) {
      continue_ = false;
      break;
    }
    u = invers_order[i - 1];
    find_connected_component(g, c[u - MIN_VERTEX], a, &u, adj_list);
    P_setunion(b, a, c[u - MIN_VERTEX]);
    if (P_setequal(g, b)) {
      continue_ = false;
      break;
    }
    P_setdiff(d, g, a);
    if (test_decomposable_hypergraph(g_c_2, b, d, c[u - MIN_VERTEX], &g_c_a,
				     &g_c_b)) {
      dispose_set_list(&g_c_a);
      dispose_set_list(&g_c_b);
      if (test_decomposable_hypergraph(g_c_1, b, d, c[u - MIN_VERTEX], &g_c_a,
				       &g_c_b)) {
	dispose_set_list(&g_c_a);
	dispose_set_list(&g_c_b);
	if (incomplete_table && check_incomplete) {
	  if (test_decomposable_hypergraph(&g_c_q_tables, b, d,
		c[u - MIN_VERTEX], &g_c_a, &g_c_b)) {
	    dispose_set_list(&g_c_a);
	    dispose_set_list(&g_c_b);
	    insert_set_minimal(c[u - MIN_VERTEX], list_of_sets);
	  }
	} else
	  insert_set_minimal(c[u - MIN_VERTEX], list_of_sets);
      }
    }
    i++;
  }
}  /* find_partitioning */


/*@+"incomp.p"*/


Static Void insert_ips_element(a, gc, graphical, ips_list, radim_list,
			       link_q_tables, dim)
long *a;
t_set_list *gc;
boolean graphical;
t_list_ips_elements **ips_list;
t_list_radim_elements **radim_list;
t_offset_list **link_q_tables;
long *dim;
{
  t_ips_set_list *ips_set_list;
  t_set_list *list_of_cliques;
  t_vertex_set vertex_set;

  list_of_cliques = NULL;
  while (gc != NULL) {
    P_setint(vertex_set, gc->vertex_set, a);
    insert_clique(vertex_set, &list_of_cliques);
    gc = gc->pointer;
  }
  *dim = 0;
  if (list_of_cliques == NULL)
    return;
  if (P_setequal(list_of_cliques->vertex_set, empty_set))
    return;
  *dim = find_dimension(list_of_cliques);
  set_list_to_ips_set_list(list_of_cliques, &ips_set_list);
  if (!insert_gc_in_radim_element(a, &ips_set_list, list_of_cliques,
				  radim_list, *link_q_tables))
    sub_insert_ips_element_2(ips_list, ips_set_list, a, false, MAX_OFFSET,
			     MAX_OFFSET, *link_q_tables);
  dispose_set_list(&list_of_cliques);
}  /* insert_ips_element */


Static Void partitioning_incomplete_table(g_c_1, g_c_n, model_set, constant,
  expression, ips_list, radim_list, dim)
t_set_list **g_c_1, **g_c_n;
long *model_set;
double *constant;
t_expression **expression;
t_list_ips_elements **ips_list;
t_list_radim_elements **radim_list;
long *dim;
{
  t_v_arr_of_v_lists adj_list;
  t_v_arr_of_v_sets adj_set;
  t_vertex_set a, b, d, g, e, f, vertex_set;
  t_set_list *list_of_sets, *g_c_a1, *g_c_a2, *g_c_b1, *g_c_b2;
  boolean ok;
  t_offset_list *q, *insert_list;
  t_long_integer dimension_a;

  /*$ifdef TRACE*/
  if (boolean_option[9]) {
    write_pch(stdout, " Q-tables: ", 11L);
    print_g_c(*g_c_n, 15L, line_length);
    write_pch(stdout, " GC: ", 5L);
    print_g_c(*g_c_1, 15L, line_length);
  }
  /*$endif TRACE*/
  ok = false;
  hypergraph_sets_to_graph_sets(*g_c_1, g, adj_set);
  if (decompose_incomplete) {
    adj_set_to_adj_list(adj_set, adj_list);
    find_partitioning(g_c_1, g_c_n, adj_list, adj_set, g, false,
		      &list_of_sets);
    if (list_of_sets != NULL) {
      pick_partitioning(adj_list, g, list_of_sets, a, d, b);
      dispose_set_list(&list_of_sets);
      P_setunion(e, a, d);
      P_setunion(f, b, d);
      ok = test_decomposable_hypergraph(g_c_1, e, f, d, &g_c_a1, &g_c_b1);
      ok = test_decomposable_hypergraph(g_c_n, e, f, d, &g_c_a2, &g_c_b2);
    }
    dispose_adj_list(adj_list);
  }
  if (ok) {
    /*$ifdef TRACE*/
    if (boolean_option[9]) {
      write_pch(stdout, " Decomp   ", 10L);
      write_line(stdout);
      write_space(stdout, 1L);
      write_pch(stdout, "Model ", 6L);
      print_g_c(*g_c_1, 9L, line_length);
      write_space(stdout, 1L);
      write_pch(stdout, "and Q ", 6L);
      print_g_c(*g_c_n, 9L, line_length);
      write_line(stdout);
      write_space(stdout, 1L);
      write_pch(stdout, "Partition of ", 13L);
      print_vertex_set(g);
      write_pch(stdout, " in ", 4L);
      P_setunion(e, a, d);
      print_vertex_set(e);
      write_char(stdout, ',');
      P_setunion(f, b, d);
      print_vertex_set(f);
      write_pch(stdout, " by ", 4L);
      print_vertex_set(d);
      write_line(stdout);
    }
    /*$endif TRACE*/
    put_factor(expression, d, -1L);
    put_factor(expression, empty_set, 1L);
    if (*dim < INFINITY)
      *dim += 1 - marginal_dimension(d);
    partitioning_incomplete_table(&g_c_a1, &g_c_a2, model_set, constant,
				  expression, ips_list, radim_list, dim);
    dispose_set_list(&g_c_a1);
    dispose_set_list(&g_c_a2);
    partitioning_incomplete_table(&g_c_b1, &g_c_b2, model_set, constant,
				  expression, ips_list, radim_list, dim);
    dispose_set_list(&g_c_b1);
    dispose_set_list(&g_c_b2);
    return;
  }
  if (P_setequal(model_set, empty_set))
    return;
  /*$ifdef TRACE*/
  if (boolean_option[9]) {
    write_pch(stdout, " Insert   ", 10L);
    write_line(stdout);
  }
  /*$endif TRACE*/
  q = q_tables_offsets;
  insert_list = NULL;
  while (q != NULL) {
    P_setint(vertex_set, q->vertex_set, g);
    if (!P_setequal(vertex_set, empty_set)) {
      if (true)
	insert_offset(q->vertex_set, q->offset, &insert_list);
    }
    q = q->pointer;
  }
  insert_ips_element(g, *g_c_1, false, ips_list, radim_list, &insert_list,
		     &dimension_a);
  if (*dim < INFINITY && dimension_a < INFINITY)
    *dim += dimension_a;
  else
    *dim = INFINITY;
}  /* partitioning_incomplete_table */


Static Void decompose_incomplete_model(sets_h_g_c, model_set, constant,
				       expression, ips_list, radim_list, dim)
t_set_list **sets_h_g_c;
long *model_set;
double *constant;
t_expression **expression;
t_list_ips_elements **ips_list;
t_list_radim_elements **radim_list;
long *dim;
{
  t_vertex_set vertex_set;

  P_setcpy(model_set, empty_set);
  add_union_of_gc(*sets_h_g_c, model_set);
  *dim = 0;
  P_setdiff(vertex_set, delta, model_set);
  *constant = 1 / marginal_dimension_real(vertex_set);
  *expression = NULL;
  *ips_list = NULL;
  *radim_list = NULL;
  partitioning_incomplete_table(sets_h_g_c, &g_c_q_tables, model_set,
				constant, expression, ips_list, radim_list,
				dim);
}  /* decompose_incomplete_model */


/*@+"identify.p"*/


Static Void identify_model(model)
t_model *model;
{
  t_set_list *sets_h_g_c;
  t_o_arr_of_vertex invers_order;
  t_v_arr_of_order order;
  t_v_arr_of_v_lists fill_in_adj_list, adj_list;
  t_v_arr_of_v_sets adj_set, c;
  t_v_arr_of_boolean complete;
  t_vertex v;
  t_offset_list *r;
  t_v_arr_of_order beta;
  t_adjacency_matrix gc_adjacency_matrix;
  t_vertex FORLIM;

  sets_h_g_c = model->sets_h_g_c;
  model->sets_h_g_c = NULL;
  dispose_model(model);
  model->sets_h_g_c = sets_h_g_c;
  if (incomplete_table)
    decompose_incomplete_model(&model->sets_h_g_c, model->model_set,
      &model->constant, &model->expression, &model->ips_list,
      &model->radim_list, &model->dim);
  else {
    create_adjacency_matrix(&gc_adjacency_matrix, model->sets_h_g_c);

    restricted_maximim_cardinality_search_on_hypergraph(&gc_adjacency_matrix,
      empty_set, &model->decomposable, order, beta, invers_order, &r);
    revers_offset_list(&r);
    if (model->decomposable)
      model->decomposable = test_acyclic_hypergraph(beta, &r);
    model->graphical = true;
    if (model->decomposable) {
      add_union_of_gc(model->sets_h_g_c, model->model_set);
      hypergraph_find_expression(&r, model->model_set, &model->constant,
				 &model->expression, &model->dim);
    } else {
      FORLIM = last_vertex;
      for (v = first_vertex; v <= FORLIM; v++) {
	order[v - MIN_VERTEX] = 1;
	fill_in_adj_list[v - MIN_VERTEX] = NULL;
	P_setcpy(c[v - MIN_VERTEX], empty_set);
	P_clrbits_B(complete, v - MIN_VERTEX, 0, 3);
      }
      hypergraph_sets_to_graph_sets(model->sets_h_g_c, model->model_set,
				    adj_set);
      adj_set_to_adj_list(adj_set, adj_list);
      model->graphical = test_graphical(adj_set, &model->sets_h_g_c);
      maximum_cardinality_search(adj_list, order, invers_order);
      model->decomposable = test_for_zero_fill_in(adj_list, order, invers_order);
      if (model->decomposable)
	find_c(adj_set, order, invers_order, adj_list, c, complete);
      else {
	lex_m(adj_list, order, invers_order, fill_in_adj_list);
	find_c(adj_set, order, invers_order, fill_in_adj_list, c, complete);
	dispose_adj_list(fill_in_adj_list);
      }
      decompose_non_decomposable(&model->graphical, &gc_adjacency_matrix,
	model->model_set, adj_list, adj_set, invers_order, c, complete,
	&model->constant, &model->expression, &model->ips_list,
	&model->radim_list, &model->dim);
      dispose_adj_list(adj_list);
    }
    dispose_offset_list(&r);
    delete_edges_with_vertices(&gc_adjacency_matrix, model->model_set);
  }
  model->found_expression = true;
}  /* identify_model */


/*@-"ips.c"*/
/*@+"compute.p"*/


Static long return_q_cell(i, link_q_tables)
t_level *i;
t_offset_list *link_q_tables;
{
  t_long_integer ii;

  ii = 1;
  while (link_q_tables != NULL && ii != 0) {
    ii *= q_array[marginal_hash(link_q_tables->vertex_set, i) +
		  link_q_tables->offset];
    link_q_tables = link_q_tables->pointer;
  }
  return ii;
}  /* return_q_cell */


Static long return_marginal_q_cell(a, i_, link_q_tables)
long *a;
t_level *i_;
t_offset_list *link_q_tables;
{
  t_cell i;
  t_long_integer q_cell;
  t_vertex v;
  t_vertex_set b, aa;
  t_cell_count index;
  t_offset_list *link_q;
  t_vertex FORLIM;
  t_cell_count FORLIM1;

  memcpy(i, i_, sizeof(t_cell));
  P_setcpy(b, empty_set);
  link_q = link_q_tables;
  while (link_q != NULL) {
    P_setunion(b, b, link_q->vertex_set);
    link_q = link_q->pointer;
  }
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    if (!P_inset(v, a))
      i[v - MIN_VERTEX] = FIRST_LEVEL;
  }
  q_cell = 0;
  P_setdiff(aa, b, a);
  FORLIM1 = marginal_dimension(aa);
  for (index = 1; index <= FORLIM1; index++) {
    next_marginal_cell(aa, i);
    q_cell += return_q_cell(i, link_q_tables);
  }
  return q_cell;
}  /* return_marginal_q_cell */


Static boolean zero_cell(i, link_q_tables)
t_level *i;
t_offset_list *link_q_tables;
{
  boolean b;

  b = true;
  while (link_q_tables != NULL && b) {
    if (q_array[marginal_hash(link_q_tables->vertex_set, i) + link_q_tables->
							      offset] == 0)
      b = false;
    link_q_tables = link_q_tables->pointer;
  }
  return (!b);
}  /* zero_cell */


Static boolean marginal_zero_cell(a, i_, link_q_tables)
long *a;
t_level *i_;
t_offset_list *link_q_tables;
{
  t_cell i;
  boolean zero;
  t_vertex v;
  t_vertex_set b, aa;
  t_cell_count index, index_stop;
  t_offset_list *link_q;
  t_vertex FORLIM;

  memcpy(i, i_, sizeof(t_cell));
  P_setcpy(b, empty_set);
  link_q = link_q_tables;
  while (link_q != NULL) {
    P_setunion(b, b, link_q->vertex_set);
    link_q = link_q->pointer;
  }
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    if (!P_inset(v, a))
      i[v - MIN_VERTEX] = FIRST_LEVEL;
  }
  index = 1;
  zero = zero_cell(i, link_q_tables);
  P_setdiff(aa, b, a);
  index_stop = marginal_dimension(aa);
  while (index < index_stop && zero) {
    index++;
    next_marginal_cell(aa, i);
    zero = zero_cell(i, link_q_tables);
  }
  return zero;
}  /* marginal_zero_cell */


Static double compute_p_fast(model)
t_model *model;
{
  double Result;
  t_long_integer count_zero, term;
  t_long_real p_cell, prob;
  t_expression *link_expression;
  t_list_ips_elements *link_ips_list;
  long TEMP;

  p_cell = model->constant;
  count_zero = 0;
  link_expression = model->expression;
  while (link_expression != NULL) {
    term = n[link_expression->offset];
    if (term == 0)
      count_zero += link_expression->factor;
    else
      p_cell *= exp(log((double)term) * link_expression->factor);
    link_expression = link_expression->pointer;
  }
  link_ips_list = model->ips_list;
  while (link_ips_list != NULL) {
    prob = p[link_ips_list->ips_element.p_offset];
    if (prob == 0)
      count_zero++;
    else
      p_cell *= prob;
    link_ips_list = link_ips_list->pointer;
  }
  /*$ifdef TRACE*/
  if (boolean_option[17])
    write_real_text(stdout, &p_cell, 12L, 7L);
  /*$endif TRACE*/
  if (count_zero == 0)
    return p_cell;
  if (count_zero > 0)
    return 0.0;
  Result = LONG_MAX;
  write_pch_40_text(report_file, " :: Compute(P(i)):  CountZero = ",
		    42L);
  TEMP = 5;
  write_integer_text(report_file, count_zero, &TEMP);
  write_line_text(report_file);
  return Result;
}  /* compute_p_fast */


Static double compute_p(i, model)
t_level *i;
t_model *model;
{
  double Result;
  t_long_integer count_zero, term;
  t_long_real p_cell, prob;
  t_expression *link_expression;
  t_list_ips_elements *link_ips_list;
  t_vertex v;
  long TEMP;
  t_vertex FORLIM;

  p_cell = model->constant;
  count_zero = 0;
  link_expression = model->expression;
  while (link_expression != NULL) {
    term = n[marginal_hash(link_expression->vertex_set, i) + link_expression->
							     offset];
    if (term == 0)
      count_zero += link_expression->factor;
    else
      p_cell *= exp(log((double)term) * link_expression->factor);
    link_expression = link_expression->pointer;
  }
  link_ips_list = model->ips_list;
  while (link_ips_list != NULL) {
    prob = p[link_ips_list->ips_element.p_offset +
	     marginal_hash(link_ips_list->ips_element.a, i)];
    if (prob == 0)
      count_zero++;
    else
      p_cell *= prob;
    link_ips_list = link_ips_list->pointer;
  }
  /*$ifdef TRACE*/
  if (boolean_option[17])
    write_real_text(stdout, &p_cell, 12L, 7L);
  /*$endif TRACE*/
  if (count_zero == 0)
    return p_cell;
  if (count_zero > 0)
    return 0.0;
  Result = LONG_MAX;
  write_pch_40_text(report_file, " :: Compute(P(i)):  CountZero = ",
		    42L);
  TEMP = 5;
  write_integer_text(report_file, count_zero, &TEMP);
  write_pch_10_text(report_file, ", i: ", 5L);
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    TEMP = 3;
    write_level_text(report_file, &i[v - MIN_VERTEX], &TEMP);
  }
  write_line_text(report_file);
  return Result;
}  /* compute_p */


Static double compute_m_p(a, i, model)
long *a;
t_level *i;
t_model *model;
{
  t_vertex_set b, c;
  t_vertex v;
  t_cell_count index;
  t_long_real p_a;
  t_vertex FORLIM;
  t_cell_count FORLIM1;

  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    if (!P_inset(v, a))
      i[v - MIN_VERTEX] = FIRST_LEVEL;
  }
  p_a = 0.0;
  P_setdiff(b, delta, a);
  P_setint(c, b, model->model_set);
  FORLIM1 = marginal_dimension(c);
  for (index = 1; index <= FORLIM1; index++) {
    p_a += compute_p(i, model);
    next_marginal_cell(c, i);
  }
  P_setdiff(c, delta, model->model_set);
  P_setint(c, b, c);
  return (p_a * marginal_dimension_real(c));
}  /* compute_m_p */


Static double compute_m_p_fast(a, i, model)
long *a;
t_level *i;
t_model *model;
{
  t_vertex_set b, c;
  t_vertex v;
  t_cell_count index;
  t_long_real p_a;
  t_product_list *link_prod_list;
  t_v_arr_of_integer levels;
  t_vertex l_a_vertex, FORLIM;
  t_cell_count FORLIM1;

  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    if (!P_inset(v, a))
      i[v - MIN_VERTEX] = FIRST_LEVEL;
  }
  p_a = 0.0;
  P_setdiff(b, delta, a);
  P_setint(c, b, model->model_set);
  if (false) {
    find_product_list(c, model, &link_prod_list, levels, &l_a_vertex);
    add_to_offsets(model, (long)FIRST_INDEX);
    FORLIM1 = marginal_dimension(c);
    for (index = 1; index <= FORLIM1; index++) {
      p_a += compute_p_fast(model);
      next_offset_in_exp_list(model, &link_prod_list, levels, &l_a_vertex, i);
    }
    add_to_offsets(model, (long)(-FIRST_INDEX));
    dispose_product_list(&link_prod_list);
  } else {
    FORLIM1 = marginal_dimension(c);
    for (index = 1; index <= FORLIM1; index++) {
      p_a += compute_p(i, model);
      next_marginal_cell(c, i);
    }
  }
  /*$ifdef TRACE*/
  if (boolean_option[17])
    write_real_text(stdout, &p_a, 12L, 7L);
  /*$endif TRACE*/
  P_setdiff(c, delta, model->model_set);
  P_setint(c, b, c);
  return (p_a * marginal_dimension_real(c));
}  /* compute_m_p_fast */


Static double compute_p_em(i, model)
t_level *i;
t_model *model;
{
  double Result;
  t_long_integer count_zero;
  t_long_real p_cell, prob, term;
  t_expression *link_expression;
  t_list_ips_elements *link_ips_list;
  t_vertex v;
  long TEMP;
  t_vertex FORLIM;

  p_cell = model->constant;
  count_zero = 0;
  link_expression = model->expression;
  while (link_expression != NULL) {
    if (em)
      term = p[marginal_hash(link_expression->vertex_set, i) +
	       link_expression->offset];
    else
      term = n[marginal_hash(link_expression->vertex_set, i) +
	       link_expression->offset];
    if (term == 0)
      count_zero += link_expression->factor;
    else
      p_cell *= exp(log(term) * link_expression->factor);
    link_expression = link_expression->pointer;
  }
  link_ips_list = model->ips_list;
  while (link_ips_list != NULL) {
    prob = p[link_ips_list->ips_element.p_offset +
	     marginal_hash(link_ips_list->ips_element.a, i)];
    if (prob == 0)
      count_zero++;
    else
      p_cell *= prob;
    link_ips_list = link_ips_list->pointer;
  }
  if (count_zero == 0)
    return p_cell;
  if (count_zero > 0)
    return 0.0;
  Result = LONG_MAX;
  write_pch_40_text(report_file, " :: Compute(P(i)):  CountZero = ",
		    42L);
  TEMP = 5;
  write_integer_text(report_file, count_zero, &TEMP);
  write_pch_10_text(report_file, ", i: ", 5L);
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    TEMP = 3;
    write_level_text(report_file, &i[v - MIN_VERTEX], &TEMP);
  }
  write_line_text(report_file);
  return Result;
}  /* compute_p_em */


Static double compute_m_p_em(a, i, model)
long *a;
t_level *i;
t_model *model;
{
  t_vertex_set b, c;
  t_vertex v;
  t_cell_count index;
  t_long_real p_a;
  t_vertex FORLIM;
  t_cell_count FORLIM1;

  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    if (!P_inset(v, a))
      i[v - MIN_VERTEX] = FIRST_LEVEL;
  }
  p_a = 0.0;
  P_setdiff(b, delta, a);
  P_setint(c, b, model->model_set);
  FORLIM1 = marginal_dimension(c);
  for (index = 1; index <= FORLIM1; index++) {
    p_a += compute_p_em(i, model);
    next_marginal_cell(c, i);
  }
  P_setdiff(c, delta, model->model_set);
  P_setint(c, b, c);
  return (p_a * marginal_dimension_real(c));
}  /* compute_m_p_em */


Static double compute_c(i, model)
t_level *i;
t_model *model;
{
  t_long_integer count_zero;
  t_long_real m, sum, term;
  t_expression *link_expression;

  if (model->ips_list == NULL && !em) {
    count_zero = 0;
    sum = -1.0 / n[0];
    link_expression = model->expression;
    while (link_expression != NULL) {
      if (em)
	term = p[marginal_hash(link_expression->vertex_set, i) +
		 link_expression->offset];
      else
	term = n[marginal_hash(link_expression->vertex_set, i) +
		 link_expression->offset];
      if (term == 0)
	count_zero += link_expression->factor;
      else
	sum -= link_expression->factor / term;
      link_expression = link_expression->pointer;
    }
    if (count_zero == 0) {
      m = n[0] * compute_p_em(i, model) / model->constant;
      return (m * (1 - m * sum));
    } else
      return INFINITY_REAL;
  } else
    return INFINITY_REAL;
}  /* compute_c */


Static double return_table_value(a, table_type, a_offset, n_total, a_index, i,
				 model_set_offset, model)
long *a;
long table_type;
t_offset *a_offset;
double *n_total;
long a_index;
t_level *i;
t_offset *model_set_offset;
t_model *model;
{
  t_vertex_set a_unio, a_comp, b, c;
  t_vertex v;
  t_long_real f, n_hat, p_hat, q, q_hat, x, y, c_hat, m_hat;
  t_cell_count index, m_index;
  boolean zero;
  t_long_integer new_table_type;
  t_vertex FORLIM;
  t_cell_count FORLIM1;

  x = INFINITY_REAL;
  new_table_type = table_type & (MAX_NUMBER_OF_TABLE_VALUES - 1);
  if (incomplete_table && MAX_NUMBER_OF_TABLE_VALUES <= table_type &&
      table_type <= MAX_NUMBER_OF_TABLE_VALUES * 2 - 2)
    zero = marginal_zero_cell(a, i, q_tables_offsets);
  else
    zero = false;
  if (zero)
    x = INFINITY_REAL;
  else if (new_table_type < 4) {
    switch (new_table_type) {

    case 0:
      if (em)
	x = p[a_index + *a_offset];
      else
	x = n[a_index + *a_offset];
      break;

    case 1:
      if (em)
	x = compute_m_p_em(a, i, model);
      else
	x = compute_m_p_fast(a, i, model);
      break;

    case 2:
      if (em)
	x = compute_m_p_em(a, i, model) * *n_total;
      else
	x = compute_m_p_fast(a, i, model) * *n_total;
      break;

    case 3:
      if (em)
	x = compute_m_p_em(a, i, model) * *n_total - p[a_index + *a_offset];
      else
	x = compute_m_p_fast(a, i, model) * *n_total - n[a_index + *a_offset];
      break;
    }
  } else if (new_table_type == 14)
    x = a_index;
  else if (table_type == 15) {
    if (c_factorizes != 1)
      x = return_marginal_q_cell(a, i, q_tables_offsets);
    else if (marginal_zero_cell(a, i, q_tables_offsets))
      x = 0.0;
    else
      x = 1.0;
  } else if (table_type == MAX_NUMBER_OF_TABLE_VALUES * 2 - 1) {
    if (marginal_zero_cell(a, i, q_tables_offsets)) {
      if (em)
	x = p[a_index + *a_offset];
      else
	x = n[a_index + *a_offset];
    } else
      x = INFINITY_REAL;
  } else {
    FORLIM = last_vertex;
    for (v = first_vertex; v <= FORLIM; v++) {
      if (!P_inset(v, a))
	i[v - MIN_VERTEX] = FIRST_LEVEL;
    }
    x = 0.0;
    P_setdiff(b, delta, a);
    P_setdiff(c, delta, model->model_set);
    P_setint(c, b, c);
    P_setunion(a_unio, model->model_set, a);
    P_setint(a_comp, b, model->model_set);
    f = marginal_dimension_real(c);
    q = 1 / marginal_dimension_real(a_unio);
    FORLIM1 = marginal_dimension(a_comp);
    for (index = 1; index <= FORLIM1; index++) {
      m_index = marginal_hash(a_unio, i);
      if (em)
	q_hat = f * compute_p_em(i, model);
      else
	q_hat = f * compute_p(i, model);
      if (em)
	n_hat = p[m_index + *model_set_offset];
      else
	n_hat = n[m_index + *model_set_offset];
      switch (new_table_type) {

      case 4:
	p_hat = n_hat / *n_total;
	if (p_hat == 0 || p_hat == 1)
	  y = INFINITY_REAL;
	else
	  y = sqrt(*n_total) * (p_hat - q_hat) / sqrt(p_hat * (1 - p_hat));
	break;

      case 5:
	p_hat = n_hat / *n_total;
	if (q_hat == 0 || q_hat == 1)
	  y = INFINITY_REAL;
	else
	  y = sqrt(*n_total) * (p_hat - q_hat) / sqrt(q_hat * (1 - q_hat));
	break;

      case 6:
	if (q_hat == 0 || q_hat == 1)
	  y = INFINITY_REAL;
	else
	  y = sqrt(*n_total) * (q_hat - q) / sqrt(q_hat * (1 - q_hat));
	break;

      case 7:
	if (q == 0 || q == 1)
	  y = INFINITY_REAL;
	else
	  y = sqrt(*n_total) * (q_hat - q) / sqrt(q * (1 - q));
	break;

      case 8:
	m_hat = q_hat * *n_total;
	c_hat = compute_c(i, model);
	if ((c_hat == 0) | is_infinity_real(c_hat))
	  y = INFINITY_REAL;
	else
	  y = (n_hat - m_hat) / sqrt(c_hat);
	break;

      case 16:
	c_hat = compute_c(i, model);
	if (is_infinity_real(c_hat))
	  y = INFINITY_REAL;
	else
	  y = c_hat;
	break;

      case 9:
	m_hat = q_hat * *n_total;
	if (m_hat == 0)
	  y = INFINITY_REAL;
	else
	  y = (n_hat - m_hat) / sqrt(m_hat);
	break;

      case 10:
	m_hat = q_hat * *n_total;
	if (n_hat == 0)
	  y = 0.0;
	else if (m_hat == 0)
	  y = INFINITY_REAL;
	else
	  y = 2 * n_hat * log(n_hat / m_hat);
	break;

      case 11:
	y = sqrt(n_hat) + sqrt(n_hat + 1) - sqrt(4 * q_hat * *n_total + 1);
	break;

      case 12:
	y = 2 * (sqrt(n_hat) - sqrt(q_hat * *n_total));
	break;

      case 13:
	m_hat = q_hat * *n_total;
	if (n_hat == 0)
	  y = 0.0;
	else if (m_hat == 0)
	  y = INFINITY_REAL;
	else
	  y = 2 / (lambda * (lambda + 1)) * n_hat *
	      (exp(log(n_hat / m_hat) * lambda) - 1);
	break;
      }
      next_marginal_cell(a_comp, i);
      if (is_infinity_real(y))
	x = INFINITY_REAL;
      else if (!is_infinity_real(x))
	x += y;
    }
  }
  if (fabs(x) < ROUND_ERROR * *n_total && new_table_type >= 3)
    x = 0.0;
  return x;
}  /* return_table_value */


/*@+"ips.p"*/


Static Void ips_next_c_offset_in_a(c_in_a, offset, increm, decrem, levels,
				   l_a_vertex, i)
boolean *c_in_a;
t_cell_index *offset;
long *increm, *decrem, *levels;
t_vertex *l_a_vertex;
t_level *i;
{
  t_vertex v;

  v = first_vertex;
  while (i[v - MIN_VERTEX] == levels[v - MIN_VERTEX]) {
    if (c_in_a[v - MIN_VERTEX])
      *offset -= decrem[v - MIN_VERTEX];
    i[v - MIN_VERTEX] = FIRST_LEVEL;
    v++;
  }
  if (v > *l_a_vertex)
    return;
  if (c_in_a[v - MIN_VERTEX])
    *offset += increm[v - MIN_VERTEX];
  i[v - MIN_VERTEX]++;
}  /* ips_next_c_offset_in_a */


Static Void ips_find_products(a, c, c_in_a, increm, decrem, levels, l)
long *a, *c;
boolean *c_in_a;
long *increm, *decrem, *levels;
t_vertex *l;
{
  t_cell_index product;
  t_vertex v, w, FORLIM;

  product = 1;
  w = first_vertex;
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    if (P_inset(v, a)) {
      if (P_inset(v, c)) {
	c_in_a[w - MIN_VERTEX] = true;
	increm[w - MIN_VERTEX] = product;
	product *= vertex_inf[v - MIN_VERTEX].levels;
	decrem[w - MIN_VERTEX] = product - increm[w - MIN_VERTEX];
      } else
	c_in_a[w - MIN_VERTEX] = false;
      levels[w - MIN_VERTEX] = FIRST_LEVEL + vertex_inf[v - MIN_VERTEX].levels - 1;
      w++;
    }
  }
  levels[w - MIN_VERTEX] = _INVALID_LEVEL;
  *l = w - 1;
}  /* ips_find_products */


Static Void clear_p(from, size)
t_e_cell_index from, size;
{
  t_e_cell_index index;

  for (index = from; index < from + size; index++)
    p[index] = 0.0;
}  /* clear_p */


Static Void marginalize_p(a, c, c_in_a, increm, decrem, levels, l_a_vertex,
			  from_offset, workspace_offset, m, i)
long *a, *c;
boolean *c_in_a;
long *increm, *decrem, *levels;
t_vertex *l_a_vertex;
t_offset *from_offset;
t_cell_index *workspace_offset;
t_e_cell_index *m;
t_level *i;
{
  t_cell_index c_index, index, FORLIM;

  clear_p(*workspace_offset, marginal_dimension(c));
  ips_find_products(a, c, c_in_a, increm, decrem, levels, l_a_vertex);
  c_index = *workspace_offset;
  FORLIM = *from_offset + *m;
  for (index = *from_offset; index < FORLIM; index++) {
    p[c_index] += p[index];
    ips_next_c_offset_in_a(c_in_a, &c_index, increm, decrem, levels,
			   l_a_vertex, i);
  }
}  /* marginalize_p */


Static Void adjust_from_n(c_in_a, increm, decrem, levels, l_a_vertex, n_total,
			  atom_offset, index_1, m, delta, i)
boolean *c_in_a;
long *increm, *decrem, *levels;
t_vertex *l_a_vertex;
t_cell_count *n_total;
t_offset *atom_offset;
t_cell_index *index_1;
t_e_cell_index *m, delta;
t_level *i;
{
  t_cell_index index, FORLIM;
  long TEMP;
  double TEMP1;

  /*$ifdef TRACE*/
  if (boolean_option[21]) {
    write_pch_20_text(stdout, " Adjust from N: ", 16L);
    write_line_stdout();
  }
  FORLIM = *atom_offset + *m;
  /*$endif TRACE*/
  for (index = *atom_offset; index < FORLIM; index++) {
    /*$ifdef TRACE*/
    if (boolean_option[21]) {
      write_short_real_text(stdout, &p[index], 15L, 10L);
      write_short_real_text(stdout, &p[*index_1], 15L, 10L);
      TEMP = 10;
      write_cell_count_text(stdout, &n[delta + *index_1], &TEMP);
      TEMP1 = (double)n[delta + *index_1] / *n_total;
      write_real_text(stdout, &TEMP1, 15L, 10L);
    }
    /*$endif TRACE*/
    if (p[*index_1] != 0)
      p[index] *= (double)n[delta + *index_1] / *n_total / p[*index_1];
    /*$ifdef TRACE*/
    if (boolean_option[21]) {
      write_short_real_text(stdout, &p[index], 15L, 10L);
      write_line_stdout();
    }
    /*$endif TRACE*/
    ips_next_c_offset_in_a(c_in_a, index_1, increm, decrem, levels,
			   l_a_vertex, i);
  }
  *index_1 -= FIRST_INDEX;
}  /* adjust_from_n */


Static Void adjust_from_p(c_in_a, increm, decrem, levels, l_a_vertex, n_total,
			  atom_offset, index_1, m, delta, i)
boolean *c_in_a;
long *increm, *decrem, *levels;
t_vertex *l_a_vertex;
t_cell_count n_total;
t_offset *atom_offset;
t_cell_index *index_1;
t_e_cell_index *m, delta;
t_level *i;
{
  t_cell_index index, FORLIM;
  double TEMP;

  /*$ifdef TRACE*/
  if (boolean_option[21]) {
    write_pch_20_text(stdout, " Adjust from P: ", 16L);
    write_line_stdout();
  }
  FORLIM = *atom_offset + *m;
  /*$endif TRACE*/
  for (index = *atom_offset; index < FORLIM; index++) {
    /*$ifdef TRACE*/
    if (boolean_option[21]) {
      write_short_real_text(stdout, &p[index], 15L, 10L);
      write_short_real_text(stdout, &p[*index_1], 15L, 10L);
      TEMP = p[delta + *index_1] / n_total;
      write_real_text(stdout, &TEMP, 15L, 10L);
    }
    /*$endif TRACE*/
    if (p[*index_1] != 0)
      p[index] *= p[delta + *index_1] / n_total / p[*index_1];
    /*$ifdef TRACE*/
    if (boolean_option[21]) {
      write_short_real_text(stdout, &p[index], 15L, 10L);
      write_line_stdout();
    }
    /*$endif TRACE*/
    ips_next_c_offset_in_a(c_in_a, index_1, increm, decrem, levels,
			   l_a_vertex, i);
  }
  *index_1 -= FIRST_INDEX;
}  /* adjust_from_p */


Static Void mean_adjust_from_n(c_in_a, increm, decrem, levels, l_a_vertex,
			       n_total, atom_offset, index_1, mean_offset, m,
			       delta, i)
boolean *c_in_a;
long *increm, *decrem, *levels;
t_vertex *l_a_vertex;
t_cell_count *n_total;
t_offset *atom_offset;
t_cell_index *index_1;
t_e_cell_index *mean_offset, *m, delta;
t_level *i;
{
  t_cell_index index, mean_index, FORLIM;
  t_long_real x;
  long TEMP;
  double TEMP1;

  /*$ifdef TRACE*/
  if (boolean_option[21]) {
    write_pch_20_text(stdout, " Adjust from N: ", 16L);
    write_line_stdout();
  }
  FORLIM = *atom_offset + *m;
  /*$endif TRACE*/
  for (index = *atom_offset; index < FORLIM; index++) {
    /*$ifdef TRACE*/
    if (boolean_option[21]) {
      write_short_real_text(stdout, &p[index], 15L, 10L);
      write_short_real_text(stdout, &p[*index_1], 15L, 10L);
      TEMP = 10;
      write_cell_count_text(stdout, &n[delta + *index_1], &TEMP);
      TEMP1 = (double)n[delta + *index_1] / *n_total;
      write_real_text(stdout, &TEMP1, 15L, 10L);
    }
    /*$endif TRACE*/
    if (p[*index_1] != 0) {
      x = p[index] * ((double)n[delta + *index_1] / *n_total / p[*index_1]);
      mean_index = *mean_offset + index - *atom_offset;
      switch (mean_ips_in_use) {

      case arithmetic:
	p[mean_index] += x;
	break;

      case geometric:
	p[mean_index] *= x;
	break;

      case harmonic:
	if (x == 0)
	  p[mean_index] = 0.0;
	else
	  p[mean_index] += 1 / x;
	break;
      }
    }
    /*$ifdef TRACE*/
    if (boolean_option[21]) {
      write_short_real_text(stdout, &p[mean_index], 15L, 10L);
      write_line_stdout();
    }
    /*$endif TRACE*/
    ips_next_c_offset_in_a(c_in_a, index_1, increm, decrem, levels,
			   l_a_vertex, i);
  }
  *index_1 -= FIRST_INDEX;
}  /* mean_adjust_from_n */


Static Void mean_adjust_from_p(c_in_a, increm, decrem, levels, l_a_vertex,
			       n_total, atom_offset, index_1, mean_offset, m,
			       delta, i)
boolean *c_in_a;
long *increm, *decrem, *levels;
t_vertex *l_a_vertex;
t_cell_count n_total;
t_offset *atom_offset;
t_cell_index *index_1;
t_e_cell_index *mean_offset, *m, delta;
t_level *i;
{
  t_cell_index index, mean_index, FORLIM;
  t_long_real x;
  double TEMP;

  /*$ifdef TRACE*/
  if (boolean_option[21]) {
    write_pch_20_text(stdout, " Adjust from P: ", 16L);
    write_line_stdout();
  }
  FORLIM = *atom_offset + *m;
  /*$endif TRACE*/
  for (index = *atom_offset; index < FORLIM; index++) {
    /*$ifdef TRACE*/
    if (boolean_option[21]) {
      write_short_real_text(stdout, &p[index], 15L, 10L);
      write_short_real_text(stdout, &p[*index_1], 15L, 10L);
      TEMP = p[delta + *index_1] / n_total;
      write_real_text(stdout, &TEMP, 15L, 10L);
    }
    /*$endif TRACE*/
    if (p[*index_1] != 0) {
      x = p[index] * (p[delta + *index_1] / n_total / p[*index_1]);
      mean_index = *mean_offset + index - *atom_offset;
      switch (mean_ips_in_use) {

      case arithmetic:
	p[mean_index] += x;
	break;

      case geometric:
	p[mean_index] *= x;
	break;

      case harmonic:
	if (x == 0)
	  p[mean_index] = 0.0;
	else
	  p[mean_index] += 1 / x;
	break;
      }
    }
    /*$ifdef TRACE*/
    if (boolean_option[21]) {
      write_short_real_text(stdout, &p[mean_index], 15L, 10L);
      write_line_stdout();
    }
    /*$endif TRACE*/
    ips_next_c_offset_in_a(c_in_a, index_1, increm, decrem, levels,
			   l_a_vertex, i);
  }
  *index_1 -= FIRST_INDEX;
}  /* mean_adjust_from_p */


Static Void clear_estimates(mean_offset, m)
t_e_cell_index *mean_offset, *m;
{
  t_e_cell_index index, FORLIM;

  FORLIM = *m;
  for (index = FIRST_INDEX; index < FORLIM; index++) {
    if (mean_ips_in_use == geometric)
      p[*mean_offset + index] = 1.0;
    else
      p[*mean_offset + index] = 0.0;
  }
}  /* clear_estimates */


Static Void update_estimates(count, atom_offset, mean_offset, m)
long *count;
t_offset *atom_offset;
t_e_cell_index *mean_offset, *m;
{
  t_e_cell_index index, FORLIM;
  t_long_real x, sum;

  sum = 0.0;
  FORLIM = *m;
  for (index = FIRST_INDEX; index < FORLIM; index++) {
    if (p[*mean_offset + index] == 0)
      p[*atom_offset + index] = 0.0;
    else {
      switch (mean_ips_in_use) {

      case arithmetic:
	x = p[*mean_offset + index] / *count;
	break;

      case geometric:
	x = exp(log(p[*mean_offset + index]) / *count);
	break;

      case harmonic:
	x = *count / p[*mean_offset + index];
	break;
      }
      p[*atom_offset + index] = x;
      sum += x;
    }
  }
  FORLIM = *atom_offset + *m;
  for (index = *atom_offset; index < FORLIM; index++)
    p[index] /= sum;
}  /* update_estimates */


Static Void copy_estimates(atom_offset, copy_offset, m)
t_offset *atom_offset;
t_e_cell_index *copy_offset, *m;
{
  t_e_cell_index index, FORLIM;

  FORLIM = *m;
  for (index = FIRST_INDEX; index < FORLIM; index++)
    p[*copy_offset + index] = p[*atom_offset + index];
}  /* copy_estimates */


Static double find_change(atom_offset, copy_offset, m)
t_offset *atom_offset;
t_e_cell_index *copy_offset, *m;
{
  t_long_real d, cell_d;
  t_e_cell_index index, FORLIM;

  d = 0.0;
  FORLIM = *m;
  for (index = FIRST_INDEX; index < FORLIM; index++) {
    cell_d = fabs(p[*atom_offset + index] - p[*copy_offset + index]);
    if (cell_d > d)
      d = cell_d;
  }
  return d;
}  /* find_change */


Static Void report_ips(link_clique, a, cycle_number, start_clock, d,
		       ips_epsilon)
t_ips_set_list *link_clique;
long *a;
long *cycle_number;
double *start_clock, *d, *ips_epsilon;
{
  long TEMP;

  write_pch_30_text(report_file, " :: Ips -  Nr.Cycles: ", 22L);
  TEMP = 5;
  write_integer_text(report_file, *cycle_number, &TEMP);
  write_pch_10_text(report_file, ",  Delta: ", 10L);
  write_real_text(report_file, d, 13L, 10L);
  write_time_text(report_file, ",  Time: ", 9L, (double)my_clock()/1,
		  *start_clock, 8L, 3L);
  write_pch_10_text(report_file, ",  A: ", 6L);
  TEMP = 4;
  write_integer_text(report_file, cardinality(a), &TEMP);
  write_pch_10_text(report_file, ",  ", 3L);
  print_vertex_set_on_report(report_file, a);
  write_line_text(report_file);
  write_pch_10_text(report_file, " :: Ips - ", 10L);
  if (fabs(*d) > *ips_epsilon)
    write_pch_30_text(report_file, " !!!!! No convergence !!!!!", 27L);
  write_pch_10_text(report_file, " GC: ", 5L);
  while (link_clique != NULL) {
    print_vertex_set_x_on_report(report_file, link_clique->vertex_set);
    link_clique = link_clique->pointer;
    if (link_clique != NULL)
      write_char_text(report_file, ',');
  }
  write_char_text(report_file, '.');
  write_line_text(report_file);
  fflush(report_file);
  P_ioresult = 0;
}  /* report_ips */


Local Void init_table(atom_offset, m, a, link_q_tables)
t_offset *atom_offset;
t_e_cell_index *m;
long *a;
t_offset_list **link_q_tables;
{
  t_cell i;
  t_e_cell_index index, FORLIM;

  if (!incomplete_table) {
    FORLIM = *m;
    for (index = FIRST_INDEX; index < FORLIM; index++)
      p[*atom_offset + index] = 1.0 / *m;
    return;
  }
  if (initial_values_for_ips) {
    memcpy(i, first_cell, sizeof(t_cell));
    FORLIM = *m;
    for (index = FIRST_INDEX; index < FORLIM; index++) {
      p[*atom_offset + index] = (double)return_marginal_q_cell(a, i,
				  *link_q_tables) / *m;
      write_short_real_text(report_file, &p[*atom_offset + index], 10L, 5L);
      if (index % 10 == 0)
	write_line_text(report_file);
      next_marginal_cell(a, i);
    }
    write_line_text(report_file);
    return;
  }
  memcpy(i, first_cell, sizeof(t_cell));
  FORLIM = *m;
  for (index = FIRST_INDEX; index < FORLIM; index++) {
    if (marginal_zero_cell(a, i, *link_q_tables))
      p[*atom_offset + index] = 0.0;
    else
      p[*atom_offset + index] = 1.0 / *m;
    next_marginal_cell(a, i);
  }
}  /* init_table */

Local double find_deviance(atom_offset, m, n_offset)
t_offset *atom_offset;
t_e_cell_index *m;
t_offset *n_offset;
{
  double Result;
  t_long_real l1;
  t_e_cell_index n_m_p_off, index, FORLIM;

  l1 = 0.0;
  n_m_p_off = *n_offset - *atom_offset;
  if (em) {
    FORLIM = *atom_offset + *m;
    for (index = *atom_offset; index < FORLIM; index++) {
      if (p[index] != 0)
	l1 += p[n_m_p_off + index] * log(p[index]);
    }
  } else {
    FORLIM = *atom_offset + *m;
    for (index = *atom_offset; index < FORLIM; index++) {
      if (p[index] != 0)
	l1 += n[n_m_p_off + index] * log(p[index]);
    }
  }
  Result = l1;
  /*$ifdef TRACE*/
  if (boolean_option[21]) {
    /*$endif TRACE*/
    write_real_text(stdout, &l1, 15L, 7L);
  }
  return Result;
}  /* find_deviance */

Local Void iterate(atom_offset, m, workspace_offset, copy_offset, mean_offset,
		   n_offset, gc, a, n_total, cycle_number, d, l1, l2)
t_offset *atom_offset;
t_e_cell_index *m;
t_cell_index *workspace_offset;
t_e_cell_index *copy_offset, *mean_offset;
t_offset *n_offset;
t_ips_set_list *gc;
long *a;
t_cell_count *n_total;
long *cycle_number;
double *d, *l1, *l2;
{
  t_u_v_arr_of_boolean c_in_a;
  t_vertex l_a_vertex;
  t_v_arr_of_integer increm, decrem, levels;
  t_cell i;
  t_long_integer count;

  memcpy(i, first_cell, sizeof(t_cell));
  (*cycle_number)++;
  if (ips_in_use == 1)
    copy_estimates(atom_offset, copy_offset, m);
  else
    *l2 = *l1;
  if (mean_ips_in_use != normal_ips)
    clear_estimates(mean_offset, m);
  count = 0;
  while (gc != NULL) {
    /*$ifdef TRACE*/
    if (boolean_option[21]) {
      write_pch_20_text(stdout, " Generator: ", 12L);
      print_vertex_set_on_report(stdout, gc->vertex_set);
      write_line_text(stdout);
    }
    /*$endif TRACE*/
    marginalize_p(a, gc->vertex_set, c_in_a, increm, decrem, levels,
		  &l_a_vertex, atom_offset, workspace_offset, m, i);
    if (mean_ips_in_use == normal_ips) {
      if (em)
	adjust_from_p(c_in_a, increm, decrem, levels, &l_a_vertex, *n_total,
		      atom_offset, workspace_offset, m,
		      gc->n_offset - *workspace_offset, i);
      else
	adjust_from_n(c_in_a, increm, decrem, levels, &l_a_vertex, n_total,
		      atom_offset, workspace_offset, m,
		      gc->n_offset - *workspace_offset, i);
    } else if (em)
      mean_adjust_from_p(c_in_a, increm, decrem, levels, &l_a_vertex,
			 *n_total, atom_offset, workspace_offset, mean_offset,
			 m, gc->n_offset - *workspace_offset, i);
    else
      mean_adjust_from_n(c_in_a, increm, decrem, levels, &l_a_vertex, n_total,
			 atom_offset, workspace_offset, mean_offset, m,
			 gc->n_offset - *workspace_offset, i);
    count++;
    gc = gc->pointer;
  }
  if (mean_ips_in_use != normal_ips)
    update_estimates(&count, atom_offset, mean_offset, m);
  if (ips_in_use == 1)
    *d = find_change(atom_offset, copy_offset, m);
  else {
    *l1 = find_deviance(atom_offset, m, n_offset);
    /*$ifdef TRACE*/
    if (boolean_option[21]) {
      write_pch_20_text(stdout, " Likelihood: ", 13L);
      write_real_text(stdout, l1, 20L, 10L);
    }
    /*$endif TRACE*/
    *d = *l2 - *l1;
  }
  /*$ifdef TRACE*/
  if (!boolean_option[21])
    return;
  /*$endif TRACE*/
  write_pch_10_text(stdout, " Delta: ", 8L);
  write_real_text(stdout, d, 20L, 10L);
  write_line_stdout();
}  /* iterate */


Static Void ips_em(ips_element, n_total, ips_epsilon, max_cycle_number, init)
t_ips_element *ips_element;
t_cell_count *n_total;
double ips_epsilon;
long *max_cycle_number;
boolean init;
{
  t_offset atom_offset;
  t_cell_index workspace_offset;
  t_e_cell_index m, copy_offset, mean_offset;
  t_long_integer cycle_number;
  t_long_real start_clock, d, l1, l2;

  start_clock = my_clock()/1;
  atom_offset = ips_element->p_offset;
  if (*max_cycle_number <= 0) {
    warning_ips(ips_element->gen_class);
    return;
  }
  m = marginal_dimension(ips_element->a);
  if (init)
    init_table(&atom_offset, &m, ips_element->a, &ips_element->link_q_tables);
  if (em) {
    workspace_offset = fpa;
    copy_offset = max_p_cell_number - m;
    mean_offset = max_p_cell_number - m - m;
  } else {
    if (ips_in_use == 1) {
      copy_offset = atom_offset + m;
      workspace_offset = atom_offset + m + m;
    } else
      workspace_offset = atom_offset + m;
    mean_offset = max_p_cell_number - m;
  }
  d = 2 * ips_epsilon;
  if (ips_in_use != 1)
    l1 = find_deviance(&atom_offset, &m, &ips_element->n_offset);
  /*$ifdef TRACE*/
  if (boolean_option[21])
    write_line_stdout();
  /*$endif TRACE*/
  cycle_number = 0;
  while (fabs(d) > ips_epsilon && cycle_number < *max_cycle_number &&
	 !interrupt_1)
    iterate(&atom_offset, &m, &workspace_offset, &copy_offset, &mean_offset,
	    &ips_element->n_offset, ips_element->gen_class, ips_element->a,
	    n_total, &cycle_number, &d, &l1, &l2);
  if (fabs(d) > ips_epsilon)
    no_ips_convergence(ips_element->gen_class, &cycle_number, &d);
  report_ips(ips_element->gen_class, ips_element->a, &cycle_number,
	     &start_clock, &d, &ips_epsilon);
}  /* ips_em */


Local double find_deviance_(radim_element, workspace_offset)
t_radim_element *radim_element;
t_cell_index *workspace_offset;
{
  double Result;
  t_vertex l_a_vertex;
  t_u_v_arr_of_boolean c_in_a;
  t_v_arr_of_integer increm, decrem, levels;
  t_cell i;
  t_long_real l1;
  t_e_cell_index p_offset, n_offset, index;
  t_vertex_set a;
  t_offset_list *upper, *lower;
  t_integer_list *lower_n;
  t_e_cell_index m;
  boolean ok;
  t_e_cell_index FORLIM;

  memcpy(i, first_cell, sizeof(t_cell));
  l1 = 0.0;
  upper = radim_element->radim_parts->upper;
  lower = radim_element->radim_parts->lower;
  lower_n = radim_element->lower_n_offsets;
  ok = false;
  while (upper != NULL) {
    P_setunion(a, upper->vertex_set, lower->vertex_set);
    p_offset = upper->offset;
    n_offset = lower->offset;
    m = marginal_dimension(a);
    if (em) {
      for (index = p_offset; index < p_offset + m; index++) {
	if (p[index] != 0)
	  l1 += p[n_offset - p_offset + index] * log(p[index]);
      }
    } else {
      for (index = p_offset; index < p_offset + m; index++) {
	if (p[index] != 0)
	  l1 += n[n_offset - p_offset + index] * log(p[index]);
      }
    }
    if (ok && !fast) {
      marginalize_p(a, lower->vertex_set, c_in_a, increm, decrem, levels,
		    &l_a_vertex, &upper->offset, workspace_offset, &m, i);
      m = marginal_dimension(lower->vertex_set);
      n_offset = lower_n->x;
      if (em) {
	FORLIM = *workspace_offset + m;
	for (index = *workspace_offset; index < FORLIM; index++) {
	  if (p[index] != 0)
	    l1 -= p[n_offset - *workspace_offset + index] * log(p[index]);
	}
      } else {
	FORLIM = *workspace_offset + m;
	for (index = *workspace_offset; index < FORLIM; index++) {
	  if (p[index] != 0)
	    l1 -= n[n_offset - *workspace_offset + index] * log(p[index]);
	}
      }
    } else
      ok = true;
    upper = upper->pointer;
    lower = lower->pointer;
    lower_n = lower_n->pointer;
  }
  Result = l1;
  /*$ifdef TRACE*/
  if (boolean_option[21]) {
    write_real_text(stdout, &l1, 20L, 10L);
    write_char_text(stdout, '.');
  }
  /*$endif TRACE*/
  return Result;
}  /* find_deviance */

Local Void iterate_(radim_element, first_offset, total_size, workspace_offset,
		    copy_offset, n_total, cycle_number, d, l1, l2)
t_radim_element *radim_element;
t_offset *first_offset;
t_e_cell_index *total_size;
t_cell_index *workspace_offset;
t_e_cell_index *copy_offset;
t_cell_count *n_total;
long *cycle_number;
double *d, *l1, *l2;
{
  t_vertex l_a_vertex;
  t_u_v_arr_of_boolean c_in_a;
  t_v_arr_of_integer increm, decrem, levels;
  t_radim_part *radim_part;
  t_offset_list *link_clique, *upper, *lower, *from;
  t_vertex_set a;
  t_e_cell_index m;
  t_cell_index q_hat_offset;
  t_cell i;

  memcpy(i, first_cell, sizeof(t_cell));
  (*cycle_number)++;
  if (ips_in_use == 1)
    copy_estimates(first_offset, copy_offset, total_size);
  else
    *l2 = *l1;
  radim_part = radim_element->radim_parts;
  while (radim_part != NULL) {
    link_clique = radim_part->generators;
    while (link_clique != NULL) {
      upper = radim_part->upper;
      lower = radim_part->lower;
      from = radim_part->from;
      P_setunion(a, upper->vertex_set, lower->vertex_set);
      m = marginal_dimension(a);
      /*$ifdef TRACE*/
      if (boolean_option[21]) {
	write_pch_20_text(stdout, " Generator: @@@@@@@ ", 13L);
	print_vertex_set_on_report(stdout, link_clique->vertex_set);
	write_pch_20_text(stdout, "    Upper: @@@@@@@@ ", 12L);
	print_vertex_set_on_report(stdout, upper->vertex_set);
	write_pch_10_text(stdout, "  Lower:  ", 10L);
	print_vertex_set_on_report(stdout, lower->vertex_set);
	write_line_text(stdout);
      }
      /*$endif TRACE*/
      marginalize_p(a, link_clique->vertex_set, c_in_a, increm, decrem,
		    levels, &l_a_vertex, &upper->offset, workspace_offset, &m,
		    i);
      if (em)
	adjust_from_p(c_in_a, increm, decrem, levels, &l_a_vertex, *n_total,
		      &upper->offset, workspace_offset, &m,
		      link_clique->offset - *workspace_offset, i);
      else
	adjust_from_n(c_in_a, increm, decrem, levels, &l_a_vertex, n_total,
		      &upper->offset, workspace_offset, &m,
		      link_clique->offset - *workspace_offset, i);
      from = from->pointer;
      upper = upper->pointer;
      lower = lower->pointer;
      while (upper != NULL) {
	/*$ifdef TRACE*/
	if (boolean_option[21]) {
	  write_pch_10_text(stdout, " Upper: ", 8L);
	  print_vertex_set_on_report(stdout, upper->vertex_set);
	  write_pch_10_text(stdout, "  Lower: ", 9L);
	  print_vertex_set_on_report(stdout, lower->vertex_set);
	  write_pch_10_text(stdout, "  From: ", 8L);
	  print_vertex_set_on_report(stdout, from->vertex_set);
	  write_line_text(stdout);
	}
	/*$endif TRACE*/
	P_setcpy(a, from->vertex_set);
	m = marginal_dimension(a);
	q_hat_offset = *workspace_offset + marginal_dimension(lower->vertex_set);
	marginalize_p(a, lower->vertex_set, c_in_a, increm, decrem, levels,
		      &l_a_vertex, &from->offset, &q_hat_offset, &m, i);
	P_setunion(a, upper->vertex_set, lower->vertex_set);
	m = marginal_dimension(a);
	marginalize_p(a, lower->vertex_set, c_in_a, increm, decrem, levels,
		      &l_a_vertex, &upper->offset, workspace_offset, &m, i);
	adjust_from_p(c_in_a, increm, decrem, levels, &l_a_vertex, 1L,
		      &upper->offset, workspace_offset, &m,
		      q_hat_offset - *workspace_offset, i);
	from = from->pointer;
	upper = upper->pointer;
	lower = lower->pointer;
      }
      link_clique = link_clique->pointer;
    }
    radim_part = radim_part->pointer;
  }
  if (ips_in_use == 1)
    *d = find_change(first_offset, copy_offset, total_size);
  else {
    *l1 = find_deviance_(radim_element, workspace_offset);
    /*$ifdef TRACE*/
    if (boolean_option[21]) {
      write_pch_20_text(stdout, " Likelihood: ", 13L);
      write_real_text(stdout, l1, 20L, 10L);
    }
    /*$endif TRACE*/
    *d = *l2 - *l1;
  }
  /*$ifdef TRACE*/
  if (!boolean_option[21])
    return;
  /*$endif TRACE*/
  write_pch_10_text(stdout, " Delta: ", 8L);
  write_real_text(stdout, d, 20L, 10L);
  write_line_text(stdout);
}  /* iterate */

Local Void adjust_by_denominator(c_in_a, increm, decrem, levels, l_a_vertex,
				 atom_offset, index_1, m, i)
boolean *c_in_a;
long *increm, *decrem, *levels;
t_vertex *l_a_vertex;
t_offset *atom_offset;
t_cell_index index_1;
t_e_cell_index m;
t_level *i;
{
  t_cell_index index, FORLIM;

  /*$ifdef TRACE*/
  if (boolean_option[21]) {
    write_pch_30_text(stdout, " Adjust by Denominator: ", 24L);
    write_line_text(stdout);
  }
  FORLIM = *atom_offset + m;
  /*$endif TRACE*/
  for (index = *atom_offset; index < FORLIM; index++) {
    /*$ifdef TRACE*/
    if (boolean_option[21]) {
      write_short_real_text(stdout, &p[index_1], 15L, 10L);
      write_short_real_text(stdout, &p[index], 15L, 10L);
    }
    /*$endif TRACE*/
    if (p[index_1] != 0)
      p[index] /= p[index_1];
    /*$ifdef TRACE*/
    if (boolean_option[21]) {
      write_short_real_text(stdout, &p[index], 15L, 10L);
      write_line_text(stdout);
    }
    /*$endif TRACE*/
    ips_next_c_offset_in_a(c_in_a, &index_1, increm, decrem, levels,
			   l_a_vertex, i);
  }
}  /* adjust_by_denominator */

Local Void final_adjustment(radim_element, workspace_offset)
t_radim_element *radim_element;
t_cell_index *workspace_offset;
{
  t_vertex l_a_vertex;
  t_u_v_arr_of_boolean c_in_a;
  t_v_arr_of_integer increm, decrem, levels;
  t_offset_list *upper, *lower;
  t_vertex_set a;
  t_e_cell_index m;
  t_cell i;

  memcpy(i, first_cell, sizeof(t_cell));
  if (radim_element->radim_parts == NULL)
    return;
  upper = radim_element->radim_parts->upper->pointer;
  lower = radim_element->radim_parts->lower->pointer;
  while (upper != NULL) {
    P_setunion(a, upper->vertex_set, lower->vertex_set);
    m = marginal_dimension(a);
    marginalize_p(a, lower->vertex_set, c_in_a, increm, decrem, levels,
		  &l_a_vertex, &upper->offset, workspace_offset, &m, i);
    adjust_by_denominator(c_in_a, increm, decrem, levels, &l_a_vertex,
			  &upper->offset, *workspace_offset, m, i);
    upper = upper->pointer;
    lower = lower->pointer;
  }
}  /* final_adjustment */

Local Void init_tables(radim_element, first_offset, total_size, link_q_tables)
t_radim_element *radim_element;
t_offset *first_offset;
t_e_cell_index *total_size;
t_offset_list **link_q_tables;
{
  t_cell i;
  t_e_cell_index p_offset, index;
  t_vertex_set a;
  t_offset_list *upper, *lower;
  t_offset m;

  *total_size = 0;
  upper = radim_element->radim_parts->upper;
  lower = radim_element->radim_parts->lower;
  *first_offset = upper->offset;
  while (upper != NULL) {
    P_setunion(a, upper->vertex_set, lower->vertex_set);
    p_offset = upper->offset;
    if (p_offset < *first_offset)
      *first_offset = p_offset;
    m = marginal_dimension(a);
    *total_size += m;
    if (incomplete_table) {
      if (initial_values_for_ips) {
	memcpy(i, first_cell, sizeof(t_cell));
	for (index = FIRST_INDEX; index < m; index++) {
	  p[p_offset + index] = (double)return_marginal_q_cell(a, i,
				  *link_q_tables) / m;
	  write_short_real_text(report_file, &p[p_offset + index], 10L, 5L);
	  if (index % 10 == 0)
	    write_line_text(report_file);
	  next_marginal_cell(a, i);
	}
	write_line_text(report_file);
      } else {
	memcpy(i, first_cell, sizeof(t_cell));
	for (index = FIRST_INDEX; index < m; index++) {
	  if (marginal_zero_cell(a, i, *link_q_tables))
	    p[p_offset + index] = 0.0;
	  else
	    p[p_offset + index] = 1.0 / m;
	  next_marginal_cell(a, i);
	}
      }
    } else {
      for (index = FIRST_INDEX; index < m; index++)
	p[p_offset + index] = 1.0 / m;
    }
    upper = upper->pointer;
    lower = lower->pointer;
  }
}  /* init_tables */


/*@+"dips.p"*/


Static Void decomposed_ips_em(radim_element, n_total, ips_epsilon,
			      max_cycle_number, init)
t_radim_element *radim_element;
t_cell_count *n_total;
double *ips_epsilon;
long *max_cycle_number;
boolean init;
{
  t_offset first_offset;
  t_e_cell_index total_size, copy_offset;
  t_cell_index workspace_offset;
  t_long_integer cycle_number;
  t_long_real start_clock, d, l1, l2;

  start_clock = my_clock()/1;
  if (*max_cycle_number <= 0) {
    warning_ips(radim_element->gen_class);
    return;
  }
  if (init)
    init_tables(radim_element, &first_offset, &total_size,
		&radim_element->link_q_tables);
  workspace_offset = fpa;
  copy_offset = max_p_cell_number - total_size;
  if (ips_in_use != 1)
    l1 = find_deviance_(radim_element, &workspace_offset);
  /*$ifdef TRACE*/
  if (boolean_option[21])
    write_line_stdout();
  /*$endif TRACE*/
  cycle_number = 0;
  d = 2 * *ips_epsilon;
  while (fabs(d) > *ips_epsilon && cycle_number < *max_cycle_number &&
	 !interrupt_1)
    iterate_(radim_element, &first_offset, &total_size, &workspace_offset,
	     &copy_offset, n_total, &cycle_number, &d, &l1, &l2);
  final_adjustment(radim_element, &workspace_offset);
  if (fabs(d) > *ips_epsilon)
    no_ips_convergence(radim_element->gen_class, &cycle_number, &d);
  report_ips(radim_element->gen_class, radim_element->a, &cycle_number,
	     &start_clock, &d, ips_epsilon);
}  /* decomposed_ips_em */


/*@-"deviance.c"*/
/*@+"marghug.p"*/


Static long marginal_hash_integer(a, i)
long *a;
t_level *i;
{
  t_long_integer sum, product;
  t_vertex v, f, l;
  t_vertex_set b;

  if (P_setequal(a, empty_set)) {
    sum = FIRST_INDEX;
    return sum;
  }
  f = first_vertex;
  while (!P_inset(f, a))
    f++;
  sum = FIRST_INDEX + i[f - MIN_VERTEX] - FIRST_LEVEL;
  P_addset(P_expset(b, 0L), f);
  if (P_setequal(a, b))
    return sum;
  l = last_vertex;
  while (!P_inset(l, a))
    l--;
  product = vertex_inf[f - MIN_VERTEX].levels;
  for (v = f + 1; v < l; v++) {
    if (P_inset(v, a)) {
      sum += (i[v - MIN_VERTEX] - FIRST_LEVEL) * product;
      product *= vertex_inf[v - MIN_VERTEX].levels;
    }
  }
  sum += (i[l - MIN_VERTEX] - FIRST_LEVEL) * product;
  return sum;
}  /* marginal_hash_integer */


Static Void invers_marginal_hash(index, a, i)
long index;
long *a;
t_level *i;
{
  t_vertex v, FORLIM;
  t_long_integer product;

  index -= FIRST_INDEX;
  product = marginal_hash_integer(a, last_cell) - FIRST_INDEX + 1;
  FORLIM = first_vertex;
  for (v = last_vertex; v >= FORLIM; v--) {
    if (P_inset(v, a)) {
      product /= vertex_inf[v - MIN_VERTEX].levels;
      if (product <= index) {
	i[v - MIN_VERTEX] = FIRST_LEVEL + index / product;
	index %= product;
      } else
	i[v - MIN_VERTEX] = FIRST_LEVEL;
    }
  }
}  /* invers_marginal_hash */


Static Void insert_cell_list(p_integer_list, p_set_list, a, n_cell, n_sets, i,
  marginal_percentages, b_offset, b, ifail, sub_code, arg_int, arg_double,
  index_int, stop_int, index_double, stop_double)
t_integer_list *p_integer_list;
t_set_list *p_set_list;
long *a;
long *n_cell, *n_sets;
t_level *i;
boolean marginal_percentages;
t_offset b_offset;
long *b;
long *ifail, *sub_code;
long **arg_int;
double **arg_double;
long *index_int, *stop_int, *index_double, *stop_double;
{
  t_long_integer j;
  t_vertex v;
  t_long_real x;
  long FORLIM;
  t_vertex FORLIM1;
  long TEMP;

  put_one_integer(arg_int, index_int, stop_int, n_cell);
  FORLIM = *n_sets;
  for (j = 1; j <= FORLIM; j++) {
    invers_marginal_hash(p_integer_list->x, p_set_list->vertex_set, i);
    p_integer_list = p_integer_list->pointer;
    p_set_list = p_set_list->pointer;
  }
  FORLIM1 = last_vertex;
  for (v = first_vertex; v <= FORLIM1; v++) {
    if (P_inset(v, a)) {
      TEMP = i[v - MIN_VERTEX] + 1;
      put_one_integer(arg_int, index_int, stop_int, &TEMP);
    }
  }
  if (marginal_percentages) {
    x = *n_cell * 100.0 / n[b_offset + marginal_hash(b, i)];
    put_one_long_real(arg_double, index_double, stop_double, &x);
  }
}  /* write_cell_list */


Static Void write_cell_list(p_integer_list, p_set_list, a, n_cell, n_sets, i,
			    marginal_percentages, b_offset, b)
t_integer_list *p_integer_list;
t_set_list *p_set_list;
long *a;
long *n_cell, *n_sets;
t_level *i;
boolean marginal_percentages;
t_offset b_offset;
long *b;
{
  t_long_integer j;
  t_vertex v;
  long FORLIM;
  t_vertex FORLIM1;

  write_char(stdout, '*');
  write_integer(stdout, *n_cell, 10L);
  write_space(stdout, 1L);
  FORLIM = *n_sets;
  for (j = 1; j <= FORLIM; j++) {
    invers_marginal_hash(p_integer_list->x, p_set_list->vertex_set, i);
    p_integer_list = p_integer_list->pointer;
    p_set_list = p_set_list->pointer;
  }
  FORLIM1 = last_vertex;
  for (v = first_vertex; v <= FORLIM1; v++) {
    if (P_inset(v, a))
      write_integer(stdout, i[v - MIN_VERTEX] + 1L,
	floor_x(2 + log_10((double)vertex_inf[v - MIN_VERTEX].levels)));
  }
  if (marginal_percentages)
    write_real(stdout, *n_cell * 100.0 / n[b_offset + marginal_hash(b, i)],
	       8L, 2L);
  write_line(stdout);
}  /* write_cell_list */


Static boolean integer_list_less_than(p, q)
t_integer_list *p, *q;
{
  while (p->x == q->x && p->pointer != NULL) {
    p = p->pointer;
    q = q->pointer;
  }
  return (p->x < q->x);
}  /* integer_list_less_than */


Static boolean integer_array_less_than(i, j, n_sets)
long i, j, n_sets;
{
  t_long_integer k;

  k = 1;
  while (n[i] == n[j] && k < n_sets) {
    i++;
    j++;
    k++;
  }
  return (n[i] < n[j]);
}  /* integer_array_less_than */


Static Void swap_integer_array(i, j, n_sets)
long *i, *j, *n_sets;
{
  t_long_integer k, x;
  long FORLIM;

  FORLIM = *n_sets;
  for (k = 0; k < FORLIM; k++) {
    x = n[*i + k];
    n[*i + k] = n[*j + k];
    n[*j + k] = x;
  }
}  /* swap_integer_array */


Local long findpivot(i, j, n_sets)
long *i, *j, *n_sets;
{
  long Result;
  t_long_integer k;

  Result = 0;
  k = *i + *n_sets;
  while (k <= *j) {
    if (integer_array_less_than(*i, k, *n_sets)) {
      Result = k;
      k = *j;
    } else if (integer_array_less_than(k, *i, *n_sets)) {
      Result = *i;
      k = *j;
    }
    k += *n_sets;
  }
  return Result;
}  /* findpivot */

Local long partition(l, r, pivotindex, n_sets)
long l, r, *pivotindex, *n_sets;
{
  t_long_integer i;
  long FORLIM;

  FORLIM = *n_sets;
  for (i = 1; i <= FORLIM; i++)
    n[max_cell_number - *n_sets + i] = n[*pivotindex + i - 1];
  *pivotindex = max_cell_number - *n_sets + 1;
  do {
    swap_integer_array(&l, &r, n_sets);
    while (integer_array_less_than(l, *pivotindex, *n_sets))
      l += *n_sets;
    while (!integer_array_less_than(r, *pivotindex, *n_sets))
      r -= *n_sets;
  } while (l <= r);
  return l;
}  /* partition */

Local Void quicksort(i, j, n_sets)
long i, j, n_sets;
{
  t_long_integer pivotindex, k;

  pivotindex = findpivot(&i, &j, &n_sets);
  if (pivotindex == 0)
    return;
  k = partition(i, j, &pivotindex, &n_sets);
  quicksort(i, k - n_sets, n_sets);
  quicksort(k, j, n_sets);
}  /* quicksort */


Static Void sort_integer_array(min, max, n_sets)
long min, max, n_sets;
{
  quicksort(min, max, n_sets);
}  /* sort_integer_array */


/* Local variables for merge: */
struct LOC_merge {
  long *k;
  FILE *f1, *f2;
  t_long_integer used[2];
  boolean fine[2];
  t_integer_list *current[2];
} ;

Local Void getrecord(i, LINK)
long i;
struct LOC_merge *LINK;
{
  if (LINK->used[i - 1] == *LINK->k)
    LINK->fine[i - 1] = true;
  else if (i == 1) {
    if (eof_integer_file(LINK->f1))
      LINK->fine[0] = true;
    else
      read_integer_list(LINK->f1, LINK->current[0]);
  } else if (eof_integer_file(LINK->f2))
    LINK->fine[1] = true;
  else
    read_integer_list(LINK->f2, LINK->current[1]);
  LINK->used[i - 1]++;
}  /* getrecord */


Static Void merge(k_, f1_, f2_, g1, g2, p, q)
long *k_;
FILE *f1_, *f2_, *g1, *g2;
t_integer_list **p, **q;
{
  struct LOC_merge Local_Var;
  boolean outswitch;
  t_long_integer winner;

  Local_Var.k = k_;
  Local_Var.f1 = f1_;
  Local_Var.f2 = f2_;
  Local_Var.current[0] = *p;
  Local_Var.current[1] = *q;
  outswitch = true;
  rewrite_integer_file(g1);
  rewrite_integer_file(g2);
  reset_integer_file(Local_Var.f1);
  reset_integer_file(Local_Var.f2);
  while ((!eof_integer_file(Local_Var.f1)) | (!eof_integer_file(Local_Var.f2))) {
    Local_Var.used[0] = 0;
    Local_Var.used[1] = 0;
    Local_Var.fine[0] = false;
    Local_Var.fine[1] = false;
    getrecord(1L, &Local_Var);
    getrecord(2L, &Local_Var);
    while (!Local_Var.fine[0] || !Local_Var.fine[1]) {
      if (Local_Var.fine[0])
	winner = 2;
      else if (Local_Var.fine[1])
	winner = 1;
      else if (integer_list_less_than(Local_Var.current[0],
				      Local_Var.current[1]))
	winner = 1;
      else
	winner = 2;
      if (outswitch)
	write_integer_list(g1, Local_Var.current[winner - 1]);
      else
	write_integer_list(g2, Local_Var.current[winner - 1]);
      getrecord(winner, &Local_Var);
    }
    outswitch = !outswitch;
  }
}  /* merge */


Local Void init(k, count, n_sets, int_list_1, f, g1, g2)
long *k, *count, *n_sets;
t_integer_list **int_list_1;
FILE *f, *g1, *g2;
{
  boolean outswitch;
  t_long_integer n_int, i, j, min_index;
  long FORLIM;

  rewrite_integer_file(g1);
  rewrite_integer_file(g2);
  reset_integer_file(f);
  if (*k == 1) {
    FORLIM = *count - *count / 2;
    for (i = 1; i <= FORLIM; i++) {
      read_integer_list(f, *int_list_1);
      write_integer_list(g1, *int_list_1);
    }
    FORLIM = *count / 2;
    for (i = 1; i <= FORLIM; i++) {
      read_integer_list(f, *int_list_1);
      write_integer_list(g2, *int_list_1);
    }
    return;
  }
  min_index = fna;
  outswitch = true;
  while (!eof_integer_file(f)) {
    i = 0;
    while (!eof_integer_file(f) && i < *k) {
      FORLIM = *n_sets;
      for (j = 0; j < FORLIM; j++) {
	read_integer_file(f, &n_int);
	n[min_index + i * *n_sets + j] = n_int;
      }
      i++;
    }
    sort_integer_array(min_index, min_index + (i - 1) * *n_sets, *n_sets);
    if (outswitch) {
      FORLIM = min_index + i * *n_sets;
      for (j = min_index; j < FORLIM; j++) {
	n_int = n[j];
	write_integer_file(g1, n_int);
      }
    } else {
      FORLIM = min_index + i * *n_sets;
      for (j = min_index; j < FORLIM; j++) {
	n_int = n[j];
	write_integer_file(g2, n_int);
      }
    }
    outswitch = !outswitch;
  }
}  /* init */


Static Void sort_integer_file(x_file, int_list_1, int_list_2, count, n_sets)
FILE *x_file;
t_integer_list **int_list_1, **int_list_2;
long count, n_sets;
{
  pch_long file_name_f1, file_name_f2, file_name_g1, file_name_g2;
  FILE *f1, *f2, *g1, *g2;
  t_long_integer k;
  boolean ok, out_f;

  g2 = NULL;
  g1 = NULL;
  f2 = NULL;
  f1 = NULL;
  default_to_file_name(DEFAULT_TMP, file_name_f1);
  assign_integer_file_write(&f1, file_name_f1, &tmp_count);
  default_to_file_name(DEFAULT_TMP, file_name_f2);
  assign_integer_file_write(&f2, file_name_f2, &tmp_count);
  default_to_file_name(DEFAULT_TMP, file_name_g1);
  assign_integer_file_write(&g1, file_name_g1, &tmp_count);
  default_to_file_name(DEFAULT_TMP, file_name_g2);
  assign_integer_file_write(&g2, file_name_g2, &tmp_count);
  tmp_count -= 4;
  if ((n[0] + 1) * n_sets > max_cell_number - fna) {
    ok = false;
    k = (n[0] + 1) * n_sets;
    if (k > MAX_CELL_NUMBER_MAX - fna)
      k = MAX_CELL_NUMBER_MAX - fna;
    while (!ok && k > 2) {
      if (!TURBO_PC)
	ok = space_in_n_array(k, fna);
      k /= 2;
    }
  }
  if (8 < (double)(max_cell_number - fna) / n_sets)
    k = floor_x((double)(max_cell_number - fna) / n_sets - 1);
  else
    k = 1;
  out_f = true;
  init(&k, &count, &n_sets, int_list_1, x_file, f1, f2);
  while (k < count) {
    out_f = !out_f;
    /*$ifdef TRACE*/
    if (boolean_option[4]) {
      write_pch(stdout, " Merge:", 7L);
      write_integer(stdout, k, 10L);
      write_integer(stdout, count, 10L);
      write_line(stdout);
    }
    /*$endif TRACE*/
    if (out_f) {
      reassign_integer_file_write(&f1, file_name_f1);
      reassign_integer_file_write(&f2, file_name_f2);
      merge(&k, g1, g2, f1, f2, int_list_1, int_list_2);
    } else {
      reassign_integer_file_write(&g1, file_name_g1);
      reassign_integer_file_write(&g2, file_name_g2);
      merge(&k, f1, f2, g1, g2, int_list_1, int_list_2);
    }
    k *= 2;
  }
  rewrite_integer_file(x_file);
  if (out_f) {
    reset_integer_file(f1);
    while (!eof_integer_file(f1)) {
      read_integer_list(f1, *int_list_1);
      write_integer_list(x_file, *int_list_1);
    }
  } else {
    reset_integer_file(g1);
    while (!eof_integer_file(g1)) {
      read_integer_list(g1, *int_list_1);
      write_integer_list(x_file, *int_list_1);
    }
  }
  unlink_integer_file(&f1, file_name_f1);
  unlink_integer_file(&f2, file_name_f2);
  unlink_integer_file(&g1, file_name_g1);
  unlink_integer_file(&g2, file_name_g2);
  if (f1 != NULL)
    fclose(f1);
  if (f2 != NULL)
    fclose(f2);
  if (g1 != NULL)
    fclose(g1);
  if (g2 != NULL)
    fclose(g2);
}  /* sort_integer_file */


Static Void encode_cell_in_list(i, n_sets, p_set_list, p_integer_list)
t_level *i;
long *n_sets;
t_set_list *p_set_list;
t_integer_list *p_integer_list;
{
  t_long_integer j;
  long FORLIM;

  FORLIM = *n_sets;
  for (j = 1; j <= FORLIM; j++) {
    p_integer_list->x = marginal_hash_integer(p_set_list->vertex_set, i);
    p_integer_list = p_integer_list->pointer;
    p_set_list = p_set_list->pointer;
  }
}  /* encode_cell_in_list */


Static Void find_log_l_file(a, print_table, set_list, x, y, n_sets, log_l,
			    marginal_percentages, b_offset, b, ifail,
			    sub_code, arg_int, arg_double, i_int, stop_int,
			    i_double, stop_double)
long *a;
boolean print_table;
t_set_list **set_list;
t_integer_list **x, **y;
long *n_sets;
double *log_l;
boolean marginal_percentages;
t_offset b_offset;
long *b;
long *ifail, *sub_code;
long **arg_int;
double **arg_double;
long *i_int, *stop_int, *i_double, *stop_double;
{
  t_cell i;
  t_vertex v;
  t_long_integer index, n_cell, num;
  pch_long file_name;
  FILE *x_file;
  t_integer_list *p_integer_list;
  t_case_list *p_case_list;
  long FORLIM;
  t_vertex FORLIM1;

  x_file = NULL;
  /*$ifdef TRACE*/
  if (boolean_option[4]) {
    write_pch(stdout, " On File  ", 10L);
    write_line(stdout);
  }
  /*$endif TRACE*/
  default_to_file_name(DEFAULT_TMP, file_name);
  assign_integer_file_write(&x_file, file_name, &tmp_count);
  for (v = first_vertex; v <= MAX_VERTEX; v++)
    i[v - MIN_VERTEX] = MAX_LEVEL;
  if (case_list != NULL) {
    p_case_list = case_list;
    FORLIM = n[0];
    for (index = 1; index <= FORLIM; index++) {
      encode_cell_in_list(p_case_list->cell, n_sets, *set_list, *x);
      write_integer_list(x_file, *x);
      p_case_list = p_case_list->pointer;
    }
  } else if (!exclude_missing) {
    reset_level_file(file_read);
    FORLIM = n[0];
    for (index = 1; index <= FORLIM; index++) {
      FORLIM1 = last_vertex;
      for (v = first_vertex; v <= FORLIM1; v++)
	read_level_file(file_read, &i[v - MIN_VERTEX]);
      encode_cell_in_list(i, n_sets, *set_list, *x);
      write_integer_list(x_file, *x);
    }
  } else {
    reset_level_file(file_excluded);
    FORLIM = n[0];
    for (index = 1; index <= FORLIM; index++) {
      FORLIM1 = last_vertex;
      for (v = first_vertex; v <= FORLIM1; v++) {
	if (P_inset(v, delta_missing_excluded))
	  read_level_file(file_excluded, &i[v - MIN_VERTEX]);
      }
      encode_cell_in_list(i, n_sets, *set_list, *x);
      write_integer_list(x_file, *x);
    }
  }
  sort_integer_file(x_file, x, y, n[0], *n_sets);
  reset_integer_file(x_file);
  read_integer_list(x_file, *y);
  n_cell = 1;
  num = 1;
  while (!eof_integer_file(x_file)) {
    num++;
    read_integer_list(x_file, *x);
    if (!integer_list_less_than(*y, *x)) {
      n_cell++;
      continue;
    }
    if (print_table) {
      if (*sub_code == 1)
	write_cell_list(*y, *set_list, a, &n_cell, n_sets, i,
			marginal_percentages, b_offset, b);
      else
	insert_cell_list(*y, *set_list, a, &n_cell, n_sets, i,
			 marginal_percentages, b_offset, b, ifail, sub_code,
			 arg_int, arg_double, i_int, stop_int, i_double,
			 stop_double);
    }
    *log_l += n_cell * log((double)n_cell);
    n_cell = 1;
    p_integer_list = *y;
    *y = *x;
    *x = p_integer_list;
  }
  if (print_table) {
    if (*sub_code == 1) {
      write_cell_list(*y, *set_list, a, &n_cell, n_sets, i,
		      marginal_percentages, b_offset, b);
      write_line(stdout);
    } else
      insert_cell_list(*y, *set_list, a, &n_cell, n_sets, i,
		       marginal_percentages, b_offset, b, ifail, sub_code,
		       arg_int, arg_double, i_int, stop_int, i_double,
		       stop_double);
  }
  *log_l += n_cell * log((double)n_cell);
  tmp_count--;
  /*$ifdef TRACE*/
  if (boolean_option[4]) {
    write_pch(stdout, " Number of", 10L);
    write_integer(stdout, num, 5L);
    write_line(stdout);
  }
  /*$endif TRACE*/
  unlink_integer_file(&x_file, file_name);
  if (x_file != NULL)
    fclose(x_file);
}  /* find_log_l_file */


Static Void encode_cell_in_array(i, index, min_index, n_sets, p_set_list)
t_level *i;
long index, *min_index, *n_sets;
t_set_list *p_set_list;
{
  t_long_integer j;
  long FORLIM;

  FORLIM = *n_sets;
  for (j = 0; j < FORLIM; j++) {
    n[*min_index + (index - 1) * *n_sets + j] = marginal_hash_integer(
	p_set_list->vertex_set, i);
    p_set_list = p_set_list->pointer;
  }
}  /* encode_cell_in_array */


Static Void find_log_l_array(a, print_table, set_list, x, y, n_sets, log_l,
			     marginal_percentages, b_offset, b, ifail,
			     sub_code, arg_int, arg_double, i_int, stop_int,
			     i_double, stop_double)
long *a;
boolean print_table;
t_set_list **set_list;
t_integer_list **x, **y;
long *n_sets;
double *log_l;
boolean marginal_percentages;
t_offset b_offset;
long *b;
long *ifail, *sub_code;
long **arg_int;
double **arg_double;
long *i_int, *stop_int, *i_double, *stop_double;
{
  t_cell i;
  t_vertex v;
  t_long_integer min_index, index, n_cell, j;
  t_integer_list *p_integer_list;
  t_case_list *p_case_list;
  long FORLIM;
  t_vertex FORLIM1;
  long FORLIM2;

  /*$ifdef TRACE*/
  if (boolean_option[4]) {
    write_pch(stdout, " In Array ", 10L);
    write_line(stdout);
  }
  /*$endif TRACE*/
  for (v = first_vertex; v <= MAX_VERTEX; v++)
    i[v - MIN_VERTEX] = MAX_LEVEL;
  min_index = fna;
  if (case_list != NULL) {
    p_case_list = case_list;
    FORLIM = n[0];
    for (index = 1; index <= FORLIM; index++) {
      encode_cell_in_array(p_case_list->cell, index, &min_index, n_sets,
			   *set_list);
      p_case_list = p_case_list->pointer;
    }
  } else if (!exclude_missing) {
    reset_level_file(file_read);
    FORLIM = n[0];
    for (index = 1; index <= FORLIM; index++) {
      FORLIM1 = last_vertex;
      for (v = first_vertex; v <= FORLIM1; v++)
	read_level_file(file_read, &i[v - MIN_VERTEX]);
      encode_cell_in_array(i, index, &min_index, n_sets, *set_list);
    }
  } else {
    reset_level_file(file_excluded);
    FORLIM = n[0];
    for (index = 1; index <= FORLIM; index++) {
      FORLIM1 = last_vertex;
      for (v = first_vertex; v <= FORLIM1; v++) {
	if (P_inset(v, delta_missing_excluded))
	  read_level_file(file_excluded, &i[v - MIN_VERTEX]);
      }
      encode_cell_in_array(i, index, &min_index, n_sets, *set_list);
    }
  }
  sort_integer_array(min_index, min_index + (n[0] - 1) * *n_sets, *n_sets);
  n_cell = 1;
  FORLIM = n[0];
  for (index = 2; index <= FORLIM; index++) {
    if (integer_array_less_than(min_index + (index - 2) * *n_sets,
				min_index + (index - 1) * *n_sets, *n_sets)) {
      if (print_table) {
	p_integer_list = *y;
	FORLIM2 = *n_sets;
	for (j = 0; j < FORLIM2; j++) {
	  p_integer_list->x = n[min_index + (index - 2) * *n_sets + j];
	  p_integer_list = p_integer_list->pointer;
	}
	if (*sub_code == 1)
	  write_cell_list(*y, *set_list, a, &n_cell, n_sets, i,
			  marginal_percentages, b_offset, b);
	else
	  insert_cell_list(*y, *set_list, a, &n_cell, n_sets, i,
			   marginal_percentages, b_offset, b, ifail, sub_code,
			   arg_int, arg_double, i_int, stop_int, i_double,
			   stop_double);
      }
      *log_l += n_cell * log((double)n_cell);
      n_cell = 1;
    } else
      n_cell++;
  }
  if (print_table) {
    p_integer_list = *y;
    FORLIM = *n_sets;
    for (j = 0; j < FORLIM; j++) {
      p_integer_list->x = n[min_index + (n[0] - 1) * *n_sets + j];
      p_integer_list = p_integer_list->pointer;
    }
    if (*sub_code == 1) {
      write_cell_list(*y, *set_list, a, &n_cell, n_sets, i,
		      marginal_percentages, b_offset, b);
      write_line(stdout);
    } else
      insert_cell_list(*y, *set_list, a, &n_cell, n_sets, i,
		       marginal_percentages, b_offset, b, ifail, sub_code,
		       arg_int, arg_double, i_int, stop_int, i_double,
		       stop_double);
  }
  *log_l += n_cell * log((double)n_cell);
}  /* find_log_l_array */


Static Void find_log_l_large(a, print_table, log_l, marginal_percentages,
  b_offset, b, ifail, sub_code, arg_int, arg_double, i_int, stop_int,
  i_double, stop_double)
long *a;
boolean print_table;
double *log_l;
boolean marginal_percentages;
t_offset b_offset;
long *b;
long *ifail, *sub_code;
long **arg_int;
double **arg_double;
long *i_int, *stop_int, *i_double, *stop_double;
{
  t_vertex v;
  t_long_integer n_sets, product;
  t_set_list *set_list;
  t_integer_list *x, *y;
  t_vertex FORLIM;

  set_list = NULL;
  insert_set_in_set_list(empty_set, &set_list);
  x = NULL;
  insert_integer_in_integer_list(0L, &x);
  y = NULL;
  insert_integer_in_integer_list(0L, &y);
  product = 1;
  n_sets = 1;
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    if (P_inset(v, a)) {
      if (product >
	  (double)MAX_COUNT_NUMBER / vertex_inf[v - MIN_VERTEX].levels) {
	insert_set_in_set_list(empty_set, &set_list);
	insert_integer_in_integer_list(0L, &x);
	insert_integer_in_integer_list(0L, &y);
	product = 1;
	n_sets++;
      }
      product *= vertex_inf[v - MIN_VERTEX].levels;
      P_addset(set_list->vertex_set, v);
    }
  }
  /*$ifdef TRACE*/
  if (boolean_option[4]) {
    write_line(stdout);
    write_pch(stdout, " In HUGE  ", 10L);
    write_line(stdout);
  }
  /*$endif TRACE*/
  if (case_list == NULL && !exclude_missing && space_for_case_list) {
    /*$ifdef TRACE*/
    if (boolean_option[4]) {
      write_pch(stdout, " Making CASE-LIST   ", 20L);
      write_line(stdout);
    }
    /*$endif TRACE*/
    make_case_list();
  }
  if (max_cell_number - fna < (n[0] + 1) * n_sets)
    find_log_l_file(a, print_table, &set_list, &x, &y, &n_sets, log_l,
		    marginal_percentages, b_offset, b, ifail, sub_code,
		    arg_int, arg_double, i_int, stop_int, i_double,
		    stop_double);
  else
    find_log_l_array(a, print_table, &set_list, &x, &y, &n_sets, log_l,
		     marginal_percentages, b_offset, b, ifail, sub_code,
		     arg_int, arg_double, i_int, stop_int, i_double,
		     stop_double);
  dispose_set_list(&set_list);
  dispose_integer_list(&x);
  dispose_integer_list(&y);
  /*$ifdef TRACE*/
  if (!boolean_option[4])
    return;
  /*$endif TRACE*/
  write_pch(stdout, " N sets  ", 9L);
  write_integer(stdout, n_sets, 5L);
  write_line(stdout);
}  /* find_log_l_large */


Static Void find_log_l_small(a, print_table, offset, log_l,
  marginal_percentages, b_offset, b, ifail, sub_code, arg_int, arg_double,
  i_int, stop_int, i_double, stop_double)
long *a;
boolean print_table;
long offset;
double *log_l;
boolean marginal_percentages;
t_offset b_offset;
long *b;
long *ifail, *sub_code;
long **arg_int;
double **arg_double;
long *i_int, *stop_int, *i_double, *stop_double;
{
  t_cell i;
  t_vertex v;
  t_long_integer j, n_cell;
  t_long_real x;
  long FORLIM;
  t_vertex FORLIM1;
  long TEMP;

  memcpy(i, first_cell, sizeof(t_cell));
  FORLIM = offset + last_index(a);
  for (j = offset; j <= FORLIM; j++) {
    n_cell = n[j];
    if (print_table && n_cell != 0) {
      if (*sub_code > 0) {
	write_integer(stdout, n_cell, 10L);
	write_space(stdout, 2L);
      } else
	put_one_integer(arg_int, i_int, stop_int, &n_cell);
      FORLIM1 = last_vertex;
      for (v = first_vertex; v <= FORLIM1; v++) {
	if (P_inset(v, a)) {
	  if (*sub_code > 0)
	    write_integer(stdout, i[v - MIN_VERTEX] + 1L,
	      floor_x(2 + log_10((double)vertex_inf[v - MIN_VERTEX].levels)));
	  else {
	    TEMP = i[v - MIN_VERTEX] + 1;
	    put_one_integer(arg_int, i_int, stop_int, &TEMP);
	  }
	}
      }
      if (marginal_percentages) {
	x = n_cell * 100.0 / n[b_offset + marginal_hash(b, i)];
	if (*sub_code > 0)
	  write_real(stdout, x, 8L, 2L);
	else
	  put_one_long_real(arg_double, i_double, stop_double, &x);
      }
      if (*sub_code > 0)
	write_line(stdout);
    }
    next_marginal_cell(a, i);
    if (n_cell != 0)
      *log_l += n_cell * log((double)n_cell);
  }
  if (print_table && *sub_code > 0)
    write_line(stdout);
}  /* find_log_l_small */


Static double find_log_l(a, print_table, ok, marginal_percentages, b_offset,
			 b, as_argument, ifail, sub_code, arg_pos_int,
			 arg_pos_double, nargs, arg_int, arg_double)
long *a;
boolean print_table, *ok, marginal_percentages;
t_offset b_offset;
long *b;
boolean as_argument;
long *ifail, *sub_code, arg_pos_int, arg_pos_double;
long **nargs, **arg_int;
double **arg_double;
{
  t_vertex v;
  t_long_real log_l;
  t_long_integer offset, i_int, stop_int, i_double, stop_double;
  t_offset_list *tmp_marginals;
  t_cell_index tmp_fna;
  t_vertex FORLIM;

  i_int = 0;
  stop_int = (*nargs)[arg_pos_int];
  i_double = 0;
  stop_double = (*nargs)[arg_pos_double];
  /*$ifdef TRACE*/
  if (boolean_option[4]) {
    write_pch(stdout, " FindLogL", 9L);
    write_line(stdout);
  }
  /*$endif TRACE*/
  if (print_table && *sub_code > 0) {
    write_line(stdout);
    write_pch(stdout, "     Count", 10L);
    write_space(stdout, 2L);
    FORLIM = last_vertex;
    for (v = first_vertex; v <= FORLIM; v++) {
      if (P_inset(v, a)) {
	write_space(stdout,
	  floor_x(1 + log_10((double)vertex_inf[v - MIN_VERTEX].levels)));
	print_vertex_on_file(stdout, v);
      }
    }
    write_line(stdout);
  }
  *ok = false;
  tmp_fna = fna;
  tmp_marginals = NULL;
  log_l = 0.0;
  if (ok_to_find_marginal_hash(a)) {
    if (large_table(a, n))
      *ok = false;
    else
      offset = sub_find_marginal(a, &tmp_marginals, true, ok);
  }
  if (*ok) {
    find_log_l_small(a, print_table, offset, &log_l, marginal_percentages,
		     b_offset, b, ifail, sub_code, arg_int, arg_double,
		     &i_int, &stop_int, &i_double, &stop_double);
    dispose_tmp_marginals(&tmp_marginals, &tmp_fna);
  } else if (datastructure == list_file) {
#ifdef CoCo_Cygwin
    *ok = false;
#endif /* CoCo_Cygwin */
#ifndef NO_INT_FILE
    *ok = true;
    find_log_l_large(a, print_table, &log_l, marginal_percentages, b_offset,
		     b, ifail, sub_code, arg_int, arg_double, &i_int,
		     &stop_int, &i_double, &stop_double);
#endif /* NO_INT_FILE */
  }
  if (print_table && *sub_code < 0) {
    set_long_end(&i_int, ifail, arg_pos_int, nargs, arg_int);
    set_real_end(&i_double, ifail, arg_pos_double, nargs, arg_double);
  }
  return log_l;
}  /* find_log_l */


/*@+"logl.p"*/


Static double find_expression_log_l(link_expression, found_offsets, found_ps,
				    ok)
t_expression *link_expression;
boolean found_offsets, found_ps, *ok;
{
  t_long_real log_l, log_l_term;
  t_long_integer index, stop, term, ifail, sub_code;
  t_vertex_set a;
  t_cell_index tmp_fna;
  t_offset_list *tmp_marginals;
  long *nargs, *arg_int;
  double *arg_double;

  log_l = 0.0;
  while (link_expression != NULL && *ok) {
    P_setcpy(a, link_expression->vertex_set);
    log_l_term = 0.0;
    tmp_fna = fna;
    tmp_marginals = NULL;
    /*$ifdef TRACE*/
    if (boolean_option[3]) {
      write_pch(stdout, " Part Exp:  ", 12L);
      write_integer(stdout, fna, 5L);
      print_vertex_set(link_expression->vertex_set);
      write_integer(stdout, link_expression->factor, 5L);
      write_integer(stdout, link_expression->offset, 5L);
    }
    /*$endif TRACE*/
    if (large) {
      conditional_dispose_both_marginals(&tmp_marginals);
      if (large_table(a, n))
	*ok = false;
      else
	index = sub_find_marginal(a, &tmp_marginals, true, ok);
    } else if (found_ps) {
      if (found_offsets)
	index = link_expression->offset;
      else
	index = sub_find_marginal(a, &tmp_marginals, true, ok);
    } else if (large_table(a, n))
      *ok = false;
    else
      index = sub_find_marginal(a, &tmp_marginals, true, ok);
    if (*ok) {
      index--;
      /*$ifdef TRACE*/
      if (boolean_option[3])
	write_integer(stdout, index, 5L);
      /*$endif TRACE*/
      stop = index + marginal_dimension(a);
      while (index < stop) {
	index++;
	term = n[index];
	if (term != 0)
	  log_l_term += term * log((double)term);
      }
    } else {
      *ok = true;
      ifail = 0;
      sub_code = 1;
      if (permit_log_l) {
	/*$ifndef TRACE
	            log_l_term := find_log_l(a, false, ok, false, -1, empty_set,
	                                     false, ifail, sub_code, 0,
	                                     0, nargs, arg_int, arg_double)
	 $endifn TRACE*/
	/*$ifdef TRACE*/
	log_l_term = find_log_l(a, boolean_option[3], ok, false, -1L,
				empty_set, false, &ifail, &sub_code, 0L, 0L,
				&nargs, &arg_int, &arg_double);
	/*$endif TRACE*/
      } else
	*ok = false;
    }
    dispose_tmp_marginals(&tmp_marginals, &tmp_fna);
    /*$ifdef TRACE*/
    if (boolean_option[3]) {
      write_real(stdout, log_l_term, print_width + 2, print_dec + 2);
      write_line(stdout);
    }
    /*$endif TRACE*/
    log_l += log_l_term * link_expression->factor;
    link_expression = link_expression->pointer;
  }
  return log_l;
}  /* find_expression_log_l */


Static double find_log_l_for_ips(ips_element, ok)
t_ips_element *ips_element;
boolean *ok;
{
  t_long_real log_l_term, prob;
  t_long_integer index, p_index, stop, term;
  t_vertex_set a;

  P_setcpy(a, ips_element->a);
  index = ips_element->n_offset - 1;
  p_index = ips_element->p_offset - 1;
  stop = index + marginal_dimension(a);
  log_l_term = 0.0;
  while (index < stop && *ok) {
    index++;
    p_index++;
    term = n[index];
    prob = p[p_index];
    if (prob == 0)
      *ok = (term == 0);
    else
      log_l_term += term * log(prob);
  }
  /*$ifdef TRACE*/
  if (!boolean_option[3])
    return log_l_term;
  write_pch(stdout, " Part Ips:  ", 12L);
  write_real(stdout, log_l_term, print_width + 2, print_dec + 2);
  write_line(stdout);
  /*$endif TRACE*/
  return log_l_term;
}  /* find_log_l_for_ips */


Static double find_ips_log_l(link_ips_list, found_ps, ok)
t_list_ips_elements *link_ips_list;
boolean *found_ps, *ok;
{
  t_long_real log_l_term;
  t_vertex_set a;
  t_ips_set_list *link_gc;
  t_offset_list *tmp_marginals;
  t_cell_index tmp_fna;
  t_ips_element *WITH;

  tmp_fna = fna;
  tmp_marginals = NULL;
  log_l_term = 0.0;
  while (link_ips_list != NULL && *ok) {
    if (!large && *found_ps || !link_ips_list->ips_element.radim_part) {
      P_setcpy(a, link_ips_list->ips_element.a);
      if (large || !*found_ps) {
	WITH = &link_ips_list->ips_element;
	conditional_dispose_both_marginals(&tmp_marginals);
	WITH->p_offset = 0;
	WITH->n_offset = sub_find_marginal(WITH->a, &tmp_marginals, true, ok);
	fpa += marginal_dimension(WITH->a);
	if (!TURBO_PC)
	  *ok = space_in_p_array(marginal_dimension(WITH->a) * 2, fpa);
	if (marginal_dimension(WITH->a) * 2 <= max_p_cell_number - fpa) {
	  link_gc = WITH->gen_class;
	  while (link_gc != NULL && *ok) {
	    link_gc->n_offset = sub_find_marginal(link_gc->vertex_set,
						  &tmp_marginals, true, ok);
	    link_gc = link_gc->pointer;
	  }
	}
	if (*ok)
	  ips_em(&link_ips_list->ips_element, n, ips_epsilon, &ips_max_it,
		 true);
	fpa -= marginal_dimension(a);
      }
      if (ips_in_use == 1)
	link_ips_list->ips_element.n_offset = sub_find_marginal(
	    link_ips_list->ips_element.a, &tmp_marginals, true, ok);
      log_l_term += find_log_l_for_ips(&link_ips_list->ips_element, ok);
    }
    link_ips_list = link_ips_list->pointer;
  }
  dispose_tmp_marginals(&tmp_marginals, &tmp_fna);
  /*$ifdef TRACE*/
  if (!boolean_option[3])
    return log_l_term;
  write_pch(stdout, " Sum Ips:   ", 12L);
  write_real(stdout, log_l_term, print_width + 2, print_dec + 2);
  write_line(stdout);
  /*$endif TRACE*/
  return log_l_term;
}  /* find_ips_log_l */


Static double find_radim_log_l(radim_list, found_ps, ok)
t_list_radim_elements *radim_list;
boolean *found_ps, *ok;
{
  boolean ok_n, ok_p;
  t_long_integer tmp_fpa;
  t_list_ips_elements *tmp_ips_list, *ips_list;
  t_long_real log_l_term;
  t_offset_list *tmp_marginals;
  t_cell_index tmp_fna;

  log_l_term = 0.0;
  tmp_fpa = fpa;
  ips_list = NULL;
  while (radim_list != NULL && *ok) {
    if (large || !*found_ps) {
      tmp_fna = fna;
      tmp_marginals = NULL;

      find_of_one_radim_marginals_and_insert_offsets(
	&radim_list->radim_element, &ips_list, &ok_n, &ok_p);
      if (ok_n && ok_p) {
	if (radim_list->radim_element.radim_parts != NULL)
	  decomposed_ips_em(&radim_list->radim_element, n, &ips_epsilon,
			    &ips_max_it, true);
      } else
	*ok = false;
      dispose_tmp_marginals(&tmp_marginals, &tmp_fna);
    }
    tmp_ips_list = ips_list;
    while (tmp_ips_list != NULL && *ok) {
      tmp_ips_list->ips_element.n_offset = sub_find_marginal(
	  tmp_ips_list->ips_element.a, &tmp_marginals, true, ok);
      log_l_term += find_log_l_for_ips(&tmp_ips_list->ips_element, ok);
      dispose_tmp_marginals(&tmp_marginals, &tmp_fna);
      tmp_ips_list = tmp_ips_list->pointer;
    }
    /*$ifdef TRACE*/
    if (boolean_option[3]) {
      write_pch(stdout, " Part Radim:", 12L);
      write_real(stdout, log_l_term, print_width + 2, print_dec + 2);
      write_line(stdout);
    }
    /*$endif TRACE*/
    dispose_ips_list(&ips_list);
    fpa = tmp_fpa;
    radim_list = radim_list->pointer;
  }
  /*$ifdef TRACE*/
  if (!boolean_option[3])
    return log_l_term;
  write_pch(stdout, " Sum Radim: ", 12L);
  write_real(stdout, log_l_term, print_width + 2, print_dec + 2);
  write_line(stdout);
  /*$endif TRACE*/
  return log_l_term;
}  /* find_radim_log_l */


Static double compute_log_l(model, dummy_g)
t_model *model;
long *dummy_g;
{
  double Result;
  t_long_real log_l;
  boolean ok;

  if (em) {
    if (model->found_log_l)
      return (model->log_l);
    else
      return _INVALID_REAL;
  }
  ok = true;
  log_l = n[0] * log(model->constant);
  /*$ifdef TRACE*/
  if (boolean_option[3]) {
    write_real(stdout, log_l, print_width + 2, print_dec + 2);
    write_line(stdout);
  }
  /*$endif TRACE*/
  log_l += find_expression_log_l(model->expression, false, model->found_ps,
				 &ok);
  /*$ifdef TRACE*/
  if (boolean_option[3]) {
    write_real(stdout, log_l, print_width + 2, print_dec + 2);
    write_line(stdout);
  }
  /*$endif TRACE*/
  if ((large || !model->found_ps) && model->radim_list != NULL && ok)
    log_l += find_radim_log_l(model->radim_list, &model->found_ps, &ok);
  /*$ifdef TRACE*/
  if (boolean_option[3]) {
    write_real(stdout, log_l, print_width + 2, print_dec + 2);
    write_line(stdout);
  }
  /*$endif TRACE*/
  if (model->ips_list != NULL && ok)
    log_l += find_ips_log_l(model->ips_list, &model->found_ps, &ok);
  /*$ifdef TRACE*/
  if (boolean_option[3]) {
    write_real(stdout, log_l, print_width + 2, print_dec + 2);
    write_line(stdout);
  }
  /*$endif TRACE*/
  if (ok)
    Result = log_l;
  else
    Result = _INVALID_REAL;
  model->found_log_l = true;
  return Result;
}  /* compute_log_l */


/*@+"xsquare.p"*/


Static Void note_p_value(p1, p2, g, i, index)
double *p1, *p2;
long *g;
t_level *i;
long *index;
{
  t_vertex v;
  long TEMP;
  t_vertex FORLIM;

  write_pch_20_text(report_file, " :: Log(Q): ", 12L);
  write_pch_20_text(report_file, "  P<1>(i): ", 11L);
  if (*p1 == LONG_MAX)
    write_pch_20_text(report_file, " Undef.      ", 13L);
  else
    write_real_text(report_file, p1, 13L, 10L);
  write_pch_20_text(report_file, "  P<2>(i): ", 11L);
  if (*p2 == LONG_MAX)
    write_pch_20_text(report_file, " Undef.      ", 13L);
  else
    write_real_text(report_file, p2, 13L, 10L);
  write_pch_10_text(report_file, "  n(i): ", 8L);
  TEMP = 8;
  write_cell_count_text(report_file, &n[*index], &TEMP);
  write_line_text(report_file);
  write_pch_20_text(report_file, " :: Log(Q): ", 12L);
  write_pch_10_text(report_file, "  DELTA: ", 9L);
  print_vertex_set_on_report(report_file, g);
  write_pch_20_text(report_file, "  SUCC(i): ", 11L);
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    if (P_inset(v, g)) {
      TEMP = 3;
      write_integer_text(report_file, i[v - MIN_VERTEX] - FIRST_LEVEL + 1L,
			 &TEMP);
    }
  }
  write_line_text(report_file);
}  /* note_p_value */


Static Void compute_x_deviance_and_x_pearson_g_offset(model_1, model_2, g,
  g_offset, x_deviance, x_pearson, x_power)
t_model *model_1, *model_2;
long *g;
long g_offset;
double *x_deviance, *x_pearson, *x_power;
{
  t_long_real ln_p2_p1, p1, p2, x;
  t_cell i;
  t_long_integer index, stop;
  boolean ok_1, ok_2;
  t_product_list *link_prod_list;
  t_v_arr_of_integer levels;
  t_vertex l_a_vertex;
  t_vertex_set vertex_set;
  double TEMP;

  *x_deviance = _INVALID_REAL;
  *x_power = _INVALID_REAL;
  *x_pearson = _INVALID_REAL;
  if (model_1->found_log_l && model_2->found_log_l &&
      (em || !(model_1->found_ps && model_2->found_ps))) {
    if (!(is_invalid_real(model_1->log_l) | is_invalid_real(model_2->log_l)))
      *x_deviance = 2 * (model_2->log_l - model_1->log_l);
    return;
  }
  ok_1 = true;
  ok_2 = true;
  *x_deviance = 0.0;
  *x_pearson = 0.0;
  *x_power = 0.0;
  memcpy(i, first_cell, sizeof(t_cell));
  index = g_offset - 1;
  stop = index + marginal_dimension(g);
  find_product_list_2(g, model_1, model_2, &link_prod_list, levels,
		      &l_a_vertex);
  add_to_offsets(model_1, (long)FIRST_INDEX);
  add_to_offsets(model_2, (long)FIRST_INDEX);
  while (index < stop && (ok_1 || ok_2)) {
    index++;
    p1 = compute_p_fast(model_1);
    p2 = compute_p_fast(model_2);
    if (0 < p1 && p1 <= 1 && p2 <= 1) {
      x = 1 / p1;
      TEMP = p1 - p2;
      *x_pearson += TEMP * TEMP * x;
    } else if (n[index] != 0)
      ok_2 = false;
    if (0 < p1 && p1 <= 1 && 0 < p2 && p2 <= 1) {
      ln_p2_p1 = log(p2 * x);
      *x_power += p2 * (exp(ln_p2_p1 * lambda) - 1);
      *x_deviance += n[index] * ln_p2_p1;
    } else if (n[index] != 0)
      ok_1 = false;
    next_offset_in_exp_list_2(model_1, model_2, &link_prod_list, levels,
			      &l_a_vertex, i);
  }
  add_to_offsets(model_1, (long)(-FIRST_INDEX));
  add_to_offsets(model_2, (long)(-FIRST_INDEX));
  dispose_product_list(&link_prod_list);
  P_setdiff(vertex_set, delta, g);
  x = marginal_dimension_real(vertex_set);
  if (!(ok_1 && ok_2))
    note_p_value(&p1, &p2, g, i, &index);
  if (ok_1)
    *x_deviance = 2 * *x_deviance;
  else
    *x_deviance = _INVALID_REAL;
  if (ok_1) {
    *x_power = n[0] * 2 * x * *x_power;
    *x_power /= lambda * (lambda + 1);
  } else
    *x_power = _INVALID_REAL;
  if (ok_2)
    *x_pearson = n[0] * *x_pearson * x;
  else
    *x_pearson = _INVALID_REAL;
}  /* compute_x_deviance_and_x_pearson_g_offset */


Static Void compute_x_deviance_and_x_pearson(model_1, model_2, g, x_deviance,
					     x_pearson, x_power)
t_model *model_1, *model_2;
long *g;
double *x_deviance, *x_pearson, *x_power;
{
  boolean ok;
  t_long_integer g_offset;

  ok = true;
  g_offset = -1;
  if (!em && model_1->found_ps && model_2->found_ps ||
      !(model_1->found_log_l && model_2->found_log_l))
    g_offset = return_offset(g, &ok);
  if (ok) {
    compute_x_deviance_and_x_pearson_g_offset(model_1, model_2, g, g_offset,
					      x_deviance, x_pearson, x_power);
    return;
  }
  *x_deviance = _INVALID_REAL;
  *x_power = _INVALID_REAL;
  *x_pearson = _INVALID_REAL;
}  /* compute_x_deviance_and_x_pearson */


/*@+"xsquaref.p"*/


Static Void compute_full_x_deviance_and_x_pearson(model, g, x_deviance,
						  x_pearson, x_power)
t_model *model;
long *g;
double *x_deviance, *x_pearson, *x_power;
{
  t_long_real ln_p2_p1, p1, p2, marg_dim_g_comp;
  t_cell i;
  t_long_integer index, stop;
  boolean ok_1, ok_2;
  t_product_list *link_prod_list;
  t_v_arr_of_integer levels;
  t_vertex l_a_vertex;
  t_vertex_set vertex_set;
  double TEMP;

  if (em) {
    *x_deviance = _INVALID_REAL;
    *x_power = _INVALID_REAL;
    *x_pearson = _INVALID_REAL;
    return;
  }
  ok_1 = true;
  ok_2 = true;
  *x_deviance = 0.0;
  *x_pearson = 0.0;
  *x_power = 0.0;
  memcpy(i, first_cell, sizeof(t_cell));
  index = return_offset(g, &ok_1) - 1;
  stop = index + marginal_dimension(g);
  P_setdiff(vertex_set, delta, g);
  marg_dim_g_comp = marginal_dimension_real(vertex_set);
  find_product_list(g, model, &link_prod_list, levels, &l_a_vertex);
  add_to_offsets(model, (long)FIRST_INDEX);
  while (index < stop && (ok_1 || ok_2)) {
    index++;
    p1 = compute_p_fast(model);
    p2 = (double)n[index] / n[0] / marg_dim_g_comp;
    if (0 < p1 && p1 <= 1 && 0 < p2 && p2 <= 1) {
      ln_p2_p1 = log(p2 / p1);
      *x_power += p2 * (exp(ln_p2_p1 * lambda) - 1);
      *x_deviance += n[index] * ln_p2_p1;
    } else if (n[index] != 0)
      ok_1 = false;
    if (0 < p1 && p1 <= 1 && p2 <= 1) {
      TEMP = p1 - p2;
      *x_pearson += TEMP * TEMP / p1;
    } else if (n[index] != 0)
      ok_2 = false;
    next_offset_in_exp_list(model, &link_prod_list, levels, &l_a_vertex, i);
  }
  add_to_offsets(model, (long)(-FIRST_INDEX));
  dispose_product_list(&link_prod_list);
  if (!(ok_1 && ok_2))
    note_p_value(&p1, &p2, g, i, &index);
  if (ok_1)
    *x_deviance = 2 * *x_deviance;
  else
    *x_deviance = _INVALID_REAL;
  if (ok_1)
    *x_power = 2 * *x_power / lambda / (lambda + 1) * n[0] * marg_dim_g_comp;
  else
    *x_power = _INVALID_REAL;
  if (ok_2)
    *x_pearson = n[0] * *x_pearson * marg_dim_g_comp;
  else
    *x_pearson = _INVALID_REAL;
}  /* compute_full_x_deviance_and_x_pearson */


/*@+"pslice.p"*/
/*@-"slicehead.c"*/


Static Void write_measure_head(f, c, w, l)
FILE *f;
Char *c;
long w, l;
{
  write_line(f);
  write_space(f, l - w);
  write_pch(f, c, w);
  write_space(f, labs(x_width) - 7);
  write_pch(f, "Statistic", 9L);
  write_space(f, 3L);
  write_pch(f, "DF", 2L);
  write_space(f, labs(prob_width) - 4);
  write_pch(f, "P-value", 7L);
  write_space(f, 3L);
  write_pch(f, "DF", 2L);
  write_space(f, labs(prob_width) - 4);
  write_pch(f, "P-value", 7L);
  write_line(f);
}  /* write_measure_head */


Static Void write_measure(f, c, w, l, k, df_a, df_b, x, p_a, p_b)
FILE *f;
Char *c;
long w, l, k, *df_a, *df_b;
double *x, *p_a, *p_b;
{
  write_pch_r(f, c, w, l);
  write_real(f, *x, x_width, x_dec);
  if (k > 1 && *df_b != _INVALID) {
    write_space(f, 1L);
    write_integer(f, *df_b, 4L);
    write_space(f, 3L);
    write_real(f, *p_b, prob_width, prob_dec);
  }
  if (k > 1) {
    write_space(f, 1L);
    write_integer(f, *df_a, 4L);
    write_space(f, 3L);
    write_real(f, *p_a, prob_width, prob_dec);
  }
  write_line(f);
  *df_a = _INVALID;
  *df_b = _INVALID;
  *x = _INVALID_REAL;
  *p_a = _INVALID_REAL;
  *p_b = _INVALID_REAL;
}  /* write_measure */


Static Void write_measure_normal_head(f, c, w, l)
FILE *f;
Char *c;
long w, l;
{
  write_line(f);
  write_space(f, l - w);
  write_pch(f, c, w);
  write_space(f, labs(x_width) - 7);
  write_pch(f, "Statistic", 9L);
  if (c_factorizes < 2) {
    write_space(f, labs(x_width) - 2);
    write_pch(f, "Var", 3L);
  }
  write_space(f, labs(x_width) - 5);
  write_pch(f, "ASE/1", 5L);
  if (c_factorizes == 1 || c_factorizes == 3) {
    write_space(f, labs(x_width) - 1);
    write_pch(f, "T", 1L);
  }
  if (c_factorizes == 1 || c_factorizes == 2) {
    write_space(f, labs(prob_width) - 6);
    write_pch(f, "P-value", 7L);
  }
  if (c_factorizes < 2) {
    write_line(f);
    write_space(f, l + labs(x_width) + 2);
  }
  if (c_factorizes < 2) {
    write_space(f, labs(x_width) - 2);
    write_pch(f, "Var", 3L);
  }
  write_space(f, labs(x_width) - 5);
  write_pch(f, "ASE/0", 5L);
  if (c_factorizes == 1 || c_factorizes == 3) {
    write_space(f, labs(x_width) - 1);
    write_pch(f, "T", 1L);
  }
  if (c_factorizes == 1 || c_factorizes == 2) {
    write_space(f, labs(prob_width) - 6);
    write_pch(f, "P-value", 7L);
  }
  write_line(f);
}  /* write_measure_normal_head */


Static Void write_measure_normal(f, c, w, l, x, x_s0, x_s1)
FILE *f;
Char *c;
long w, l;
double *x, *x_s0, *x_s1;
{
  write_pch_r(f, c, w, l);
  write_real(f, *x, x_width, x_dec);
  if (((!is_invalid_real(*x)) & (!is_invalid_real(*x_s1))) && *x_s1 != 0) {
    if (c_factorizes < 2) {
      write_char(f, ' ');
      write_real(f, *x_s1, x_width, prob_dec);
    }
    write_real(f, *x_s1 / sqrt(fabs(*x_s1)), x_width, x_dec);
    if (c_factorizes == 1 || c_factorizes == 3) {
      if (*x_s1 > 0)
	write_real(f, *x / sqrt(*x_s1), x_width, x_dec);
      else
	write_space(f, labs(x_width));
    }
    if (c_factorizes == 1 || c_factorizes == 2) {
      write_char(f, ' ');
      if (*x_s1 > 0)
	write_real(f, 2 * pnormal(fabs(*x) / sqrt(*x_s1)), prob_width,
		   prob_dec);
      else
	write_space(f, labs(prob_width));
    }
  } else {
    if (c_factorizes < 2)
      write_space(f, labs(x_width) + 1);
    write_space(f, labs(x_width));
    if (c_factorizes == 1 || c_factorizes == 3)
      write_space(f, labs(x_width));
    if (c_factorizes == 1 || c_factorizes == 2)
      write_space(f, labs(prob_width));
  }
  if (((!is_invalid_real(*x)) & (!is_invalid_real(*x_s0))) && *x_s0 != 0) {
    if (c_factorizes < 2) {
      write_line(f);
      write_space(f, l + labs(x_width) + 2);
    }
    if (c_factorizes < 2) {
      write_char(f, ' ');
      write_real(f, *x_s0, x_width, prob_dec);
    }
    write_real(f, *x_s0 / sqrt(fabs(*x_s0)), x_width, x_dec);
    if (c_factorizes == 1 || c_factorizes == 3) {
      if (*x_s0 > 0)
	write_real(f, *x / sqrt(*x_s0), x_width, x_dec);
      else
	write_space(f, labs(x_width));
    }
    if (c_factorizes == 1 || c_factorizes == 2) {
      write_char(f, ' ');
      if (*x_s0 > 0)
	write_real(f, 2 * pnormal(fabs(*x) / sqrt(*x_s0)), prob_width,
		   prob_dec);
      else
	write_space(f, labs(prob_width));
    }
  }
  write_line(f);
  *x = _INVALID_REAL;
  *x_s0 = _INVALID_REAL;
  *x_s1 = _INVALID_REAL;
}  /* write_measure_normal */


/*@-"gammatau.c"*/


Static Void sub_find_concedances(nrow, ncol, nmatpos, cij, dij, p, q)
long *nrow, *ncol;
long (*nmatpos)[MAX_LEVEL], (*cij)[MAX_LEVEL], (*dij)[MAX_LEVEL];
long *p, *q;
{
  t_long_integer i, j, k, l, nij;
  long FORLIM, FORLIM1, FORLIM2, FORLIM3;

  FORLIM = *nrow;
  for (i = 1; i <= FORLIM; i++) {
    FORLIM1 = *ncol;
    for (j = 1; j <= FORLIM1; j++) {
      cij[i - 1][j - 1] = 0;
      dij[i - 1][j - 1] = 0;
      for (k = 0; k <= i - 2; k++) {
	for (l = 0; l <= j - 2; l++)
	  cij[i - 1][j - 1] += n[nmatpos[k][l]];
      }
      FORLIM2 = *nrow;
      for (k = i; k < FORLIM2; k++) {
	for (l = 0; l <= j - 2; l++)
	  dij[i - 1][j - 1] += n[nmatpos[k][l]];
      }
      for (k = 0; k <= i - 2; k++) {
	FORLIM3 = *ncol;
	for (l = j; l < FORLIM3; l++)
	  dij[i - 1][j - 1] += n[nmatpos[k][l]];
      }
      FORLIM2 = *nrow;
      for (k = i; k < FORLIM2; k++) {
	FORLIM3 = *ncol;
	for (l = j; l < FORLIM3; l++)
	  cij[i - 1][j - 1] += n[nmatpos[k][l]];
      }
      nij = n[nmatpos[i - 1][j - 1]];
      *p += nij * cij[i - 1][j - 1];
      *q += nij * dij[i - 1][j - 1];
    }
  }
}  /* sub_find_concedances */


Static Void gamma_and_tau(n_total, nrow, ncol, n_total_2, n_total_3,
			  n_total_4, ss_r, ss_c, ss_1_r, ss_1_c, m, x, x_s0,
			  x_s1, nrowpos, ncolpos, nmatpos)
long *n_total, *nrow, *ncol;
double *n_total_2, *n_total_3, *n_total_4, *ss_r, *ss_c, *ss_1_r, *ss_1_c, *m,
       *x, *x_s0, *x_s1;
long *nrowpos, *ncolpos;
long (*nmatpos)[MAX_LEVEL];
{
  t_long_real gamma, gamma_s0, gamma_s1, tau_b, tau_b_s0, tau_b_s1, tau_c_s0,
	      d_as_1_s0, d_as_1_s1, d_as_2_s0, d_as_2_s1, ppq, pmq, o, y, w,
	      r_i, c_j;
  t_long_integer p, q, i, j;
  long (*cij)[MAX_LEVEL], (*dij)[MAX_LEVEL];
  long FORLIM, FORLIM1;
  double TEMP;

  p = 0;
  q = 0;
  gamma_s0 = 0.0;
  cij = (long(*)[MAX_LEVEL])Malloc(sizeof(t_level_2_arr_of_integer));
  if (cij == NULL)
    _OutMem();
  dij = (long(*)[MAX_LEVEL])Malloc(sizeof(t_level_2_arr_of_integer));
  if (dij == NULL)
    _OutMem();
  sub_find_concedances(nrow, ncol, nmatpos, cij, dij, &p, &q);
  ppq = p + q;
  pmq = p - q;
  y = sqrt((*n_total_2 - *ss_r) * (*n_total_2 - *ss_c));
  if (y != 0)
    tau_b = pmq / y;
  if (ppq > 0) {
    gamma_s0 = 0.0;
    gamma_s1 = 0.0;
    tau_b_s1 = 0.0;
    d_as_1_s1 = 0.0;
    d_as_2_s1 = 0.0;
    FORLIM = *nrow;
    for (i = 0; i < FORLIM; i++) {
      r_i = n[nrowpos[i]];
      FORLIM1 = *ncol;
      for (j = 0; j < FORLIM1; j++) {
	c_j = n[ncolpos[j]];
	o = n[nmatpos[i][j]];
	w = cij[i][j] - dij[i][j];
	gamma_s0 += o * w * w;
	TEMP = 2 * y * w +
	    tau_b * (c_j * (*n_total_2 - *ss_r) + r_i * (*n_total_2 - *ss_c));
	tau_b_s1 += o * (TEMP * TEMP);
	TEMP = (*n_total_2 - *ss_r) * w + (n[nrowpos[i]] - *n_total) * pmq;
	d_as_1_s1 += o * (TEMP * TEMP);
	TEMP = (*n_total_2 - *ss_c) * w + (n[ncolpos[j]] - *n_total) * pmq;
	d_as_2_s1 += o * (TEMP * TEMP);
	w = q * cij[i][j] - p * dij[i][j];
	gamma_s1 += o * w * w;
      }
    }
    w = *n_total * (*n_total - 1) - *ss_1_r;
    w *= *n_total * (*n_total - 1) - *ss_1_c;
    if (w != 0)
      tau_b_s0 = (gamma_s0 - pmq * pmq / *n_total) * 4 / w;
    tau_c_s0 = gamma_s0 - pmq * pmq / *n_total;
    tau_c_s0 /= *n_total_4;
    TEMP = *m / (*m - 1);
    tau_c_s0 *= 4 * (TEMP * TEMP);
    w = *n_total * (*n_total - 1) - *ss_1_r;
    w *= w;
    d_as_1_s0 = gamma_s0 * 4 / w;
    w = *n_total_2 - *ss_r;
    w *= w;
    d_as_1_s1 = d_as_1_s1 * 4 / (w * w);
    w = *n_total * (*n_total - 1) - *ss_1_c;
    w *= w;
    d_as_2_s0 = gamma_s0 * 4 / w;
    w = *n_total_2 - *ss_c;
    w *= w;
    d_as_2_s1 = d_as_2_s1 * 4 / (w * w);
    TEMP = 2 * *n_total_2 - *ss_r - *ss_c;
    tau_b_s1 -= *n_total_3 * tau_b * tau_b * (TEMP * TEMP);
    TEMP = y * y;
    tau_b_s1 /= TEMP * TEMP;
    gamma_s0 -= pmq * pmq / *n_total;
    gamma_s0 *= 4;
    w = ppq * ppq;
    gamma_s0 /= w;
    gamma_s1 = gamma_s1 * 16 / (w * w);
    gamma = pmq / ppq;
  } else {
    gamma = _INVALID_REAL;
    gamma_s0 = _INVALID_REAL;
    gamma_s1 = _INVALID_REAL;
    tau_b_s0 = _INVALID_REAL;
    tau_b_s1 = _INVALID_REAL;
    tau_c_s0 = _INVALID_REAL;
    d_as_1_s0 = _INVALID_REAL;
    d_as_1_s1 = _INVALID_REAL;
    d_as_2_s0 = _INVALID_REAL;
    d_as_2_s1 = _INVALID_REAL;
  }
  Free(cij);
  Free(dij);
  *x = gamma;
  *x_s0 = gamma_s0;
  *x_s1 = gamma_s1;
  write_measure_normal(stdout, "Gamma, G", 8L, 31L, x,
		       x_s0, x_s1);
  *x = pmq / sqrt((*n_total_2 - *ss_r) * (*n_total_2 - *ss_c));
  *x_s0 = tau_b_s0;
  *x_s1 = tau_b_s1;
  write_measure_normal(stdout, "Kendall's Tau b", 15L, 31L, x,
		       x_s0, x_s1);
  if (*m > 1)
    *x = pmq / *n_total_2 * *m / (*m - 1);
  *x_s0 = tau_c_s0;
  *x_s1 = tau_c_s0;
  write_measure_normal(stdout, "Stuart's Tau c", 14L, 31L, x,
		       x_s0, x_s1);
  *x = pmq / (*n_total_2 - *ss_r);
  *x_s0 = d_as_1_s0;
  *x_s1 = d_as_1_s1;
  write_measure_normal(stdout, "Somers' D, R|C", 14L, 31L, x,
		       x_s0, x_s1);
  *x = pmq / (*n_total_2 - *ss_c);
  *x_s0 = d_as_2_s0;
  *x_s1 = d_as_2_s1;
  write_measure_normal(stdout, "Somers' D, C|R", 14L, 31L, x,
		       x_s0, x_s1);
}  /* gamma_and_tau */


Local double p_(a, b, c, d)
long a, b, c, d;
{
  return exp(log_fact(a + b) + log_fact(c + d) + log_fact(a + c) +
	     log_fact(b + d) - log_fact(a) - log_fact(b) - log_fact(c) -
	     log_fact(d) - log_fact(a + b + c + d));
}  /* p */

Local Void f(a, b, c, d, p_1_side, p_2_side)
long *a, *b, *c, *d;
double *p_1_side, *p_2_side;
{
  t_long_integer i;
  t_long_real x, y;
  long FORLIM;

  if (*a >= 100 && c_factorizes != 1) {
    *p_1_side = _INVALID_REAL;
    *p_2_side = *p_1_side;
    return;
  }
  *p_1_side = 0.0;
  FORLIM = *a;
  for (i = 0; i <= FORLIM; i++)
    *p_1_side += p_(*a - i, *b + i, *c + i, *d - i);
  if (*b < *c)
    i = *b;
  else
    i = *c;
  if (i >= 100 && c_factorizes != 1) {
    *p_2_side = _INVALID_REAL;
    return;
  }
  *p_2_side = *p_1_side;
  x = p_(*a, *b, *c, *d);
  y = p_(*a + i, *b - i, *c - i, *d + i);
  while (y <= x && 0 < i) {
    *p_2_side += y;
    i--;
    y = p_(*a + i, *b - i, *c - i, *d + i);
  }
}  /* f */


Static Void fisher(a, b, c, d, p_1_side, p_2_side)
long a, b, c, d;
double *p_1_side, *p_2_side;
{
  if (a * d < b * c) {
    if (a < d)
      f(&a, &b, &c, &d, p_1_side, p_2_side);
    else
      f(&d, &b, &c, &a, p_1_side, p_2_side);
    return;
  }
  if (b < c)
    f(&b, &a, &d, &c, p_1_side, p_2_side);
  else
    f(&c, &a, &d, &b, p_1_side, p_2_side);
}  /* fisher */


/*@-"optimal.c"*/


Static Void optimal_prediction(n_total, nrow, ncol, x, x_s0, x_s1, nrowpos,
			       ncolpos, nmatpos)
long *n_total, *nrow, *ncol;
double *x, *x_s0, *x_s1;
long *nrowpos, *ncolpos;
long (*nmatpos)[MAX_LEVEL];
{
  t_long_real max_row, max_col, max_row_, max_col_, sum_max_in_row,
	      sum_max_in_col, sum_max_in_row_, sum_max_in_col_, l_ij, l_ji,
	      l_sym, lambda_asym_ji_s1, lambda_asym_ij_s1, lambda_sym_s1,
	      lambda_asyms_ji_s1, lambda_asyms_ij_s1, r_i, c_j, w, o;
  t_level_arr_of_integer max_in_row, max_in_col, n_, m_;
  t_long_integer d_k_i, d_l_j, d_mj_ij, d_in_ij, l_, k_, l__, k__, i, j;
  long FORLIM, FORLIM1;
  double TEMP;
  long TEMP1;

  max_col = 0.0;
  max_col_ = 0.0;
  FORLIM = *ncol;
  for (j = 1; j <= FORLIM; j++) {
    c_j = n[ncolpos[j - 1]];
    if (c_j > max_col) {
      max_col = c_j;
      l_ = j;
    }
    max_in_col[j - 1] = -1;
    w = 0.0;
    FORLIM1 = *nrow;
    for (i = 0; i < FORLIM1; i++) {
      r_i = n[nrowpos[i]];
      if (r_i != 0)
	w += n[nmatpos[i][j - 1]] / r_i;
    }
    if (w > max_col_) {
      max_col_ = w;
      l__ = j;
    }
  }
  max_row = 0.0;
  max_row_ = 0.0;
  FORLIM = *nrow;
  for (i = 1; i <= FORLIM; i++) {
    r_i = n[nrowpos[i - 1]];
    if (r_i > max_row) {
      max_row = r_i;
      k_ = i;
    }
    max_in_row[i - 1] = -1;
    w = 0.0;
    FORLIM1 = *ncol;
    for (j = 0; j < FORLIM1; j++) {
      c_j = n[ncolpos[j]];
      if (c_j != 0)
	w += n[nmatpos[i - 1][j]] / c_j;
    }
    if (w > max_row_) {
      max_row_ = w;
      k__ = i;
    }
  }
  FORLIM = *ncol;
  for (j = 0; j < FORLIM; j++) {
    c_j = (double)n[ncolpos[j]] / *n_total;
    FORLIM1 = *nrow;
    for (i = 0; i < FORLIM1; i++) {
      o = n[nmatpos[i][j]];
      if (o > max_in_col[j]) {
	max_in_col[j] = n[nmatpos[i][j]];
	m_[j] = i + 1;
      }
      if (o > max_in_row[i]) {
	max_in_row[i] = n[nmatpos[i][j]];
	n_[i] = j + 1;
      }
    }
  }
  sum_max_in_col = 0.0;
  sum_max_in_col_ = 0.0;
  FORLIM = *ncol;
  for (j = 0; j < FORLIM; j++) {
    *x = n[ncolpos[j]];
    sum_max_in_col += max_in_col[j];
    if (*x != 0)
      sum_max_in_col_ += max_in_col[j] / *x;
  }
  sum_max_in_row = 0.0;
  sum_max_in_row_ = 0.0;
  FORLIM = *nrow;
  for (i = 0; i < FORLIM; i++) {
    *x = n[nrowpos[i]];
    sum_max_in_row += max_in_row[i];
    if (*x != 0)
      sum_max_in_row_ += max_in_row[i] / *x;
  }
  lambda_asym_ji_s1 = 0.0;
  lambda_asym_ij_s1 = 0.0;
  lambda_sym_s1 = 0.0;
  l_ij = (sum_max_in_row - max_col) / (*n_total - max_col);
  l_ji = (sum_max_in_col - max_row) / (*n_total - max_row);
  l_sym = (sum_max_in_col + sum_max_in_row - max_col - max_row) /
	  (*n_total * 2 - max_col - max_row);
  FORLIM = *ncol;
  for (j = 1; j <= FORLIM; j++) {
    if (j == l_)
      d_l_j = 1;
    else
      d_l_j = 0;
    FORLIM1 = *nrow;
    for (i = 1; i <= FORLIM1; i++) {
      if (i == k_)
	d_k_i = 1;
      else
	d_k_i = 0;
      if (j == n_[i - 1])
	d_in_ij = 1;
      else
	d_in_ij = 0;
      if (i == m_[j - 1])
	d_mj_ij = 1;
      else
	d_mj_ij = 0;
      o = n[nmatpos[i - 1][j - 1]];
      TEMP = d_in_ij - d_l_j + l_sym * d_l_j;
      lambda_asym_ji_s1 += o * (TEMP * TEMP);
      TEMP = d_mj_ij - d_k_i + l_sym * d_k_i;
      lambda_asym_ij_s1 += o * (TEMP * TEMP);
      TEMP = d_in_ij + d_mj_ij - d_l_j - d_k_i + l_sym * (d_l_j + d_k_i);
      lambda_sym_s1 += o * (TEMP * TEMP);
    }
  }
  lambda_asym_ji_s1 -= *n_total * l_ij * l_ij;
  TEMP1 = *n_total - n[ncolpos[l_ - 1]];
  lambda_asym_ji_s1 /= TEMP1 * TEMP1;
  lambda_asym_ij_s1 -= *n_total * l_ji * l_ji;
  TEMP1 = *n_total - n[nrowpos[k_ - 1]];
  lambda_asym_ij_s1 /= TEMP1 * TEMP1;
  lambda_sym_s1 -= *n_total * 4 * l_sym * l_sym;
  TEMP1 = *n_total * 2 - n[nrowpos[k_ - 1]] - n[ncolpos[l_ - 1]];
  lambda_sym_s1 /= TEMP1 * TEMP1;
  l_ji = (sum_max_in_row_ - max_col_) / (*nrow - max_col_);
  l_ij = (sum_max_in_col_ - max_row_) / (*ncol - max_row_);
  lambda_asyms_ji_s1 = 0.0;
  lambda_asyms_ij_s1 = 0.0;
  FORLIM = *nrow;
  for (i = 0; i < FORLIM; i++) {
    r_i = n[nrowpos[i]];
    o = n[nmatpos[i][l__ - 1]];
    if (r_i > 0) {
      TEMP = n[nmatpos[i][n_[i] - 1]] - o + l_ji * o;
      lambda_asyms_ji_s1 -= TEMP * TEMP / r_i / r_i / r_i;
    }
  }
  FORLIM = *ncol;
  for (j = 0; j < FORLIM; j++) {
    c_j = n[ncolpos[j]];
    o = n[nmatpos[k__ - 1][j]];
    if (c_j > 0) {
      TEMP = n[nmatpos[m_[j] - 1][j]] - o + l_ij * o;
      lambda_asyms_ij_s1 -= TEMP * TEMP / c_j / c_j / c_j;
    }
  }
  FORLIM = *ncol;
  for (j = 1; j <= FORLIM; j++) {
    c_j = n[ncolpos[j - 1]];
    if (j == l__)
      d_l_j = 1;
    else
      d_l_j = 0;
    FORLIM1 = *nrow;
    for (i = 1; i <= FORLIM1; i++) {
      if (i == k__)
	d_k_i = 1;
      else
	d_k_i = 0;
      if (j == n_[i - 1])
	d_in_ij = 1;
      else
	d_in_ij = 0;
      if (i == m_[j - 1])
	d_mj_ij = 1;
      else
	d_mj_ij = 0;
      r_i = n[nrowpos[i - 1]];
      o = n[nmatpos[i - 1][j - 1]];
      if (r_i > 0) {
	TEMP = d_in_ij - d_l_j + l_ji * d_l_j;
	lambda_asyms_ji_s1 += o * (TEMP * TEMP) / (r_i * r_i);
      }
      if (c_j > 0) {
	TEMP = d_mj_ij - d_k_i + l_ij * d_k_i;
	lambda_asyms_ij_s1 += o * (TEMP * TEMP) / (c_j * c_j);
      }
    }
  }
  if (*nrow - max_col_ != 0) {
    TEMP = *nrow - max_col_;
    lambda_asyms_ji_s1 /= TEMP * TEMP;
  }
  if (*ncol - max_row_ != 0) {
    TEMP = *ncol - max_row_;
    lambda_asyms_ij_s1 /= TEMP * TEMP;
  }
  *x = (sum_max_in_row - max_col) / (*n_total - max_col);
  *x_s1 = lambda_asym_ji_s1;
  write_measure_normal(stdout, "Optimal prediction lambda, R|C", 30L, 31L, x,
		       x_s0, x_s1);
  *x = (sum_max_in_col - max_row) / (*n_total - max_row);
  *x_s1 = lambda_asym_ij_s1;
  write_measure_normal(stdout, "Optimal prediction lambda, C|R", 30L, 31L, x,
		       x_s0, x_s1);
  *x = (sum_max_in_col + sum_max_in_row - max_col - max_row) /
       (*n_total * 2 - max_col - max_row);
  *x_s1 = lambda_sym_s1;
  write_measure_normal(stdout, "Optimal prediction lambda, sym", 30L, 31L, x,
		       x_s0, x_s1);
  *x = (sum_max_in_row_ - max_col_) / (*nrow - max_col_);
  *x_s1 = lambda_asyms_ji_s1;
  write_measure_normal(stdout, "Optimal prediction lambda* R|C", 30L, 31L, x,
		       x_s0, x_s1);
  *x = (sum_max_in_col_ - max_row_) / (*ncol - max_row_);
  *x_s1 = lambda_asyms_ij_s1;
  write_measure_normal(stdout, "Optimal prediction lambda* C|R", 30L, 31L, x,
		       x_s0, x_s1);
}  /* optimal_prediction */


/*@-"goodman.c"*/


Static Void goodman_and_kruskal(n_total, nrow, ncol, n_total_2, ss_r, ss_c,
				sc_r, sc_c, x, x_s0, x_s1, nrowpos, ncolpos,
				nmatpos)
long *n_total, *nrow, *ncol;
double *n_total_2, *ss_r, *ss_c, *sc_r, *sc_c, *x, *x_s0, *x_s1;
long *nrowpos, *ncolpos;
long (*nmatpos)[MAX_LEVEL];
{
  t_long_real sum_a_2, sum_a_2_r, sum_a_2_c, sum_a_3_o_r_2, sum_a_3_o_c_2,
	      sum_a_2_c_o_r, sum_a_2_r_o_c, sum_a_2_o_r, sum_a_2_o_c, sum_a_c,
	      sum_a_r, sum_o_r_1, sum_o_r_2, sum_o_r_3, sum_o_c_1, sum_o_c_2,
	      sum_o_c_3, r_i, c_j, o, o_2, o_3, y, v, w;
  t_long_integer i, j;
  long FORLIM, FORLIM1;
  double TEMP;

  sum_o_c_1 = 0.0;
  sum_o_c_2 = 0.0;
  sum_o_c_3 = 0.0;
  FORLIM = *ncol;
  for (j = 0; j < FORLIM; j++) {
    c_j = n[ncolpos[j]];
    sum_a_r = 0.0;
    sum_a_2 = 0.0;
    FORLIM1 = *nrow;
    for (i = 0; i < FORLIM1; i++) {
      r_i = n[nrowpos[i]];
      o = n[nmatpos[i][j]];
      sum_a_r += o * r_i;
      sum_a_2 += o * o;
    }
    if (c_j != 0) {
      sum_o_c_1 += sum_a_r * sum_a_r / c_j;
      sum_o_c_2 += sum_a_2 * sum_a_r / c_j / c_j;
      sum_o_c_3 += sum_a_2 * sum_a_2 / c_j / c_j / c_j;
    }
  }
  sum_o_r_1 = 0.0;
  sum_o_r_2 = 0.0;
  sum_o_r_3 = 0.0;
  FORLIM = *nrow;
  for (i = 0; i < FORLIM; i++) {
    r_i = n[nrowpos[i]];
    sum_a_c = 0.0;
    sum_a_2 = 0.0;
    FORLIM1 = *ncol;
    for (j = 0; j < FORLIM1; j++) {
      c_j = n[ncolpos[j]];
      o = n[nmatpos[i][j]];
      sum_a_c += o * c_j;
      sum_a_2 += o * o;
    }
    if (r_i != 0) {
      sum_o_r_1 += sum_a_c * sum_a_c / r_i;
      sum_o_r_2 += sum_a_c * sum_a_2 / r_i / r_i;
      sum_o_r_3 += sum_a_2 * sum_a_2 / r_i / r_i / r_i;
    }
  }
  sum_a_2_r = 0.0;
  sum_a_2_c = 0.0;
  sum_a_2_o_r = 0.0;
  sum_a_2_o_c = 0.0;
  sum_a_2_c_o_r = 0.0;
  sum_a_2_r_o_c = 0.0;
  sum_a_3_o_r_2 = 0.0;
  sum_a_3_o_c_2 = 0.0;
  FORLIM = *ncol;
  for (j = 0; j < FORLIM; j++) {
    c_j = n[ncolpos[j]];
    FORLIM1 = *nrow;
    for (i = 0; i < FORLIM1; i++) {
      r_i = n[nrowpos[i]];
      o = n[nmatpos[i][j]];
      o_2 = o * o;
      o_3 = o_2 * o;
      sum_a_2_r += o_2 * r_i;
      sum_a_2_c += o_2 * c_j;
      if (c_j > 0) {
	sum_a_2_o_c += o_2 / c_j;
	sum_a_2_r_o_c += o_2 * r_i / c_j;
	sum_a_3_o_c_2 += o_3 / (c_j * c_j);
      }
      if (r_i > 0) {
	sum_a_2_o_r += o_2 / r_i;
	sum_a_2_c_o_r += o_2 * c_j / r_i;
	sum_a_3_o_r_2 += o_3 / (r_i * r_i);
      }
    }
  }
  v = *n_total * sum_a_2_o_r - *ss_c;
  w = *n_total_2 - *ss_c;
  *x = v / w;
  y = v - w;
  *x_s1 = w * w * *n_total_2 * sum_a_3_o_r_2;
  *x_s1 += y * y * *sc_c;
  *x_s1 += 2 * w * y * *n_total * sum_a_2_c_o_r;
  *x_s1 -= w * w * *n_total_2 * sum_o_r_3;
  *x_s1 -= y * y * sum_o_r_1;
  *x_s1 -= 2 * w * y * *n_total * sum_o_r_2;
  TEMP = w * w;
  *x_s1 = *x_s1 * 4 / (TEMP * TEMP);
  write_measure_normal(stdout, "Goodman and Kruskal's Tau, R|C", 30L, 31L, x,
		       x_s0, x_s1);
  v = *n_total * sum_a_2_o_c - *ss_r;
  w = *n_total_2 - *ss_r;
  *x = v / w;
  y = v - w;
  *x_s1 = w * w * *n_total_2 * sum_a_3_o_c_2;
  *x_s1 += y * y * *sc_r;
  *x_s1 += 2 * w * y * *n_total * sum_a_2_r_o_c;
  *x_s1 -= w * w * *n_total_2 * sum_o_c_3;
  *x_s1 -= y * y * sum_o_c_1;
  *x_s1 -= 2 * w * y * *n_total * sum_o_c_2;
  TEMP = w * w;
  *x_s1 = *x_s1 * 4 / (TEMP * TEMP);
  write_measure_normal(stdout, "Goodman and Kruskal's Tau, C|R", 30L, 31L, x,
		       x_s0, x_s1);
}  /* goodman_and_kruskal */


/*@-"spearman.c"*/


Static Void spearman(n_total, nrow, ncol, nr, nc, df_a, df_b, n_total_2,
		     n_total_3, sc_r, sc_c, x, x_s0, x_s1, p_a, p_b, nrowpos,
		     ncolpos, nmatpos)
long *n_total, *nrow, *ncol, *nr, *nc, *df_a, *df_b;
double *n_total_2, *n_total_3, *sc_r, *sc_c, *x, *x_s0, *x_s1, *p_a, *p_b;
long *nrowpos, *ncolpos;
long (*nmatpos)[MAX_LEVEL];
{
  t_long_real a, b, c, d, a_i_i_j_j, a_i_j, r_i_i, c_j_j, pmc_s1, r_s_u,
	      sum_v_ij, sum_w_ij, v_ij, w_ij, ri, cj, r_i, c_j, o, src_s0,
	      src_s1, i_, j_, y, v, w;
  t_long_integer h, i, j, k, l;
  t_level_arr_of_integer cum_row_sum, cum_col_sum;
  long FORLIM, FORLIM1;
  double TEMP;
  long FORLIM2, FORLIM3;

  h = 0;
  j_ = 0.0;
  FORLIM = *ncol;
  for (j = 1; j <= FORLIM; j++) {
    c_j = n[ncolpos[j - 1]];
    cum_col_sum[j - 1] = h;
    h += n[ncolpos[j - 1]];
    j_ += j * c_j;
  }
  j_ /= *n_total;
  h = 0;
  i_ = 0.0;
  FORLIM = *nrow;
  for (i = 1; i <= FORLIM; i++) {
    r_i = n[nrowpos[i - 1]];
    cum_row_sum[i - 1] = h;
    h += n[nrowpos[i - 1]];
    i_ += i * r_i;
  }
  i_ /= *n_total;
  c_j_j = 0.0;
  FORLIM = *ncol;
  for (j = 1; j <= FORLIM; j++) {
    *x = n[ncolpos[j - 1]];
    c_j_j += *x * (j - j_) * (j - j_);
  }
  r_i_i = 0.0;
  FORLIM = *nrow;
  for (i = 1; i <= FORLIM; i++) {
    *x = n[nrowpos[i - 1]];
    r_i_i += *x * (i - i_) * (i - i_);
  }
  a_i_j = 0.0;
  a_i_i_j_j = 0.0;
  r_s_u = 0.0;
  FORLIM = *ncol;
  for (j = 1; j <= FORLIM; j++) {
    c_j = n[ncolpos[j - 1]];
    FORLIM1 = *nrow;
    for (i = 1; i <= FORLIM1; i++) {
      o = n[nmatpos[i - 1][j - 1]];
      r_i = n[nrowpos[i - 1]];
      r_s_u += o * (cum_row_sum[i - 1] + r_i / 2 - *n_total / 2.0) *
	       (cum_col_sum[j - 1] + c_j / 2 - *n_total / 2.0);
      a = i - i_;
      b = j - j_;
      c = a * b;
      d = c * c;
      a_i_j += o * c;
      a_i_i_j_j += o * d;
    }
  }
  y = sqrt(c_j_j * r_i_i);
  pmc_s1 = 0.0;
  FORLIM = *ncol;
  for (j = 1; j <= FORLIM; j++) {
    FORLIM1 = *nrow;
    for (i = 1; i <= FORLIM1; i++) {
      o = n[nmatpos[i - 1][j - 1]];
      a = i - i_;
      b = j - j_;
      TEMP = y * a * b - a_i_j * (a * a * c_j_j + b * b * r_i_i) / 2 / y;
      pmc_s1 += o * (TEMP * TEMP);
    }
  }
  y *= y;
  pmc_s1 /= y * y;
  v = r_s_u;
  w = sqrt(*n_total_3 - *sc_r) * sqrt(*n_total_3 - *sc_c) / 12;
  sum_v_ij = 0.0;
  sum_w_ij = 0.0;
  FORLIM = *ncol;
  for (j = 1; j <= FORLIM; j++) {
    c_j = n[ncolpos[j - 1]];
    cj = cum_col_sum[j - 1] * 2 + c_j - *n_total;
    FORLIM1 = *nrow;
    for (i = 1; i <= FORLIM1; i++) {
      r_i = n[nrowpos[i - 1]];
      ri = cum_row_sum[i - 1] * 2 + r_i - *n_total;
      v_ij = ri * cj;
      FORLIM2 = *ncol;
      for (k = 0; k < FORLIM2; k++)
	v_ij += n[nmatpos[i - 1][k]] *
		(cum_col_sum[k] * 2 + n[ncolpos[k]] - *n_total);
      FORLIM2 = *nrow;
      for (k = 0; k < FORLIM2; k++)
	v_ij += n[nmatpos[k][j - 1]] *
		(cum_row_sum[k] * 2 + n[nrowpos[k]] - *n_total);
      FORLIM2 = *ncol;
      for (l = 0; l < FORLIM2; l++) {
	FORLIM3 = *nrow;
	for (k = i; k < FORLIM3; k++)
	  v_ij += n[nmatpos[k][l]] *
		  (cum_col_sum[l] * 2 + n[ncolpos[l]] - *n_total) * 2;
      }
      FORLIM2 = *nrow;
      for (k = 0; k < FORLIM2; k++) {
	FORLIM3 = *ncol;
	for (l = j; l < FORLIM3; l++)
	  v_ij += n[nmatpos[k][l]] *
		  (cum_row_sum[k] * 2 + n[nrowpos[k]] - *n_total) * 2;
      }
      v_ij = v_ij * *n_total / 4;
      w_ij = (*sc_r - *n_total_3) * c_j * c_j - (*n_total_3 - *sc_c) * r_i * r_i;
      w_ij = w_ij * *n_total / 96 / w;
      o = n[nmatpos[i - 1][j - 1]];
      sum_v_ij += o * v_ij;
      sum_w_ij += o * w_ij;
    }
  }
  src_s0 = 0.0;
  src_s1 = 0.0;
  FORLIM = *ncol;
  for (j = 1; j <= FORLIM; j++) {
    c_j = n[ncolpos[j - 1]];
    cj = cum_col_sum[j - 1] * 2 + c_j - *n_total;
    FORLIM1 = *nrow;
    for (i = 1; i <= FORLIM1; i++) {
      r_i = n[nrowpos[i - 1]];
      ri = cum_row_sum[i - 1] * 2 + r_i - *n_total;
      v_ij = ri * cj;
      FORLIM2 = *ncol;
      for (l = 0; l < FORLIM2; l++)
	v_ij += n[nmatpos[i - 1][l]] *
		(cum_col_sum[l] * 2 + n[ncolpos[l]] - *n_total);
      FORLIM2 = *nrow;
      for (k = 0; k < FORLIM2; k++)
	v_ij += n[nmatpos[k][j - 1]] *
		(cum_row_sum[k] * 2 + n[nrowpos[k]] - *n_total);
      FORLIM2 = *ncol;
      for (l = 0; l < FORLIM2; l++) {
	FORLIM3 = *nrow;
	for (k = i; k < FORLIM3; k++)
	  v_ij += n[nmatpos[k][l]] *
		  (cum_col_sum[l] * 2 + n[ncolpos[l]] - *n_total) * 2;
      }
      FORLIM2 = *nrow;
      for (k = 0; k < FORLIM2; k++) {
	FORLIM3 = *ncol;
	for (l = j; l < FORLIM3; l++)
	  v_ij += n[nmatpos[k][l]] *
		  (cum_row_sum[k] * 2 + n[nrowpos[k]] - *n_total) * 2;
      }
      v_ij = v_ij * *n_total / 4;
      w_ij = (*sc_r - *n_total_3) * c_j * c_j - (*n_total_3 - *sc_c) * r_i * r_i;
      w_ij = w_ij * *n_total / 96 / w;
      o = n[nmatpos[i - 1][j - 1]];
      TEMP = v_ij - sum_v_ij / *n_total;
      src_s0 += o * (TEMP * TEMP);
      TEMP = w * v_ij - v * w_ij - w * sum_v_ij / *n_total +
	     v * sum_w_ij / *n_total;
      src_s1 += o * (TEMP * TEMP);
    }
  }
  w *= w;
  src_s0 = src_s0 / *n_total_2 / w;
  src_s1 = src_s1 / *n_total_2 / (w * w);
  if (*nc == 2 && *nr == 2) {
    *x = (*n_total - 1) * a_i_j * a_i_j / (c_j_j * r_i_i);
    *df_a = 1;
    *p_a = khi(*df_a, *x);
    write_measure(stdout, "Mantel-Haenszel chi-square", 26L, 31L, 3L,
		  df_a, df_b, x, p_a, p_b);
  }
  write_measure_normal_head(stdout, "", 0L, 31L);
  y = sqrt(c_j_j * r_i_i);
  *x = a_i_j / y;
  *x_s0 = (a_i_i_j_j - a_i_j * a_i_j / *n_total) / (y * y);
  *x_s1 = pmc_s1;
  write_measure_normal(stdout, "Pearson (product-moment) corr.", 30L, 31L, x,
		       x_s0, x_s1);
  *x = 12 * r_s_u / sqrt(*n_total_3 - *sc_r) / sqrt(*n_total_3 - *sc_c);
  *x_s0 = src_s0;
  *x_s1 = src_s1;
  write_measure_normal(stdout, "Spearman rank corr. coef.", 25L, 31L, x,
		       x_s0, x_s1);
}  /* spearman */


/*@-"linear.c"*/


Static Void uncertainty(n_total, nrow, ncol, x, x_s0, x_s1, nrowpos, ncolpos,
			nmatpos)
long *n_total, *nrow, *ncol;
double *x, *x_s0, *x_s1;
long *nrowpos, *ncolpos;
long (*nmatpos)[MAX_LEVEL];
{
  t_long_real u_i, u_j, u_ij, s_u_ij, s_u_ji, s_u, r_i, c_j, o;
  t_long_integer i, j;
  long FORLIM, FORLIM1;
  double TEMP, TEMP1;

  u_j = 0.0;
  FORLIM = *ncol;
  for (j = 0; j < FORLIM; j++) {
    c_j = n[ncolpos[j]];
    if (c_j != 0)
      u_j -= log(c_j / *n_total) * (c_j / *n_total);
  }
  u_i = 0.0;
  FORLIM = *nrow;
  for (i = 0; i < FORLIM; i++) {
    r_i = n[nrowpos[i]];
    if (r_i != 0)
      u_i -= log(r_i / *n_total) * (r_i / *n_total);
  }
  u_ij = 0.0;
  FORLIM = *ncol;
  for (j = 0; j < FORLIM; j++) {
    FORLIM1 = *nrow;
    for (i = 0; i < FORLIM1; i++) {
      o = n[nmatpos[i][j]];
      if (o != 0)
	u_ij -= log(o / *n_total) * (o / *n_total);
    }
  }
  s_u_ij = 0.0;
  s_u_ji = 0.0;
  s_u = 0.0;
  FORLIM = *ncol;
  for (j = 0; j < FORLIM; j++) {
    c_j = (double)n[ncolpos[j]] / *n_total;
    FORLIM1 = *nrow;
    for (i = 0; i < FORLIM1; i++) {
      o = n[nmatpos[i][j]];
      o /= *n_total;
      r_i = (double)n[nrowpos[i]] / *n_total;
      if (o > 0) {
	TEMP = (u_i - u_ij) * log(c_j) + u_j * (log(o) - log(r_i));
	s_u_ij += o * (TEMP * TEMP);
	TEMP = (u_j - u_ij) * log(r_i) + u_i * (log(o) - log(c_j));
	s_u_ji += o * (TEMP * TEMP);
	TEMP = u_ij * (log(r_i) + log(c_j)) - (u_j + u_i) * log(o);
	s_u += o * (TEMP * TEMP);
      }
    }
  }
  TEMP = u_j * u_j;
  s_u_ij = s_u_ij / (TEMP * TEMP) / *n_total;
  TEMP = u_i * u_i;
  s_u_ji = s_u_ji / (TEMP * TEMP) / *n_total;
  TEMP = u_j + u_i;
  TEMP1 = TEMP * TEMP;
  s_u = s_u * 4 / (TEMP1 * TEMP1) / *n_total;
  *x = (u_j + u_i - u_ij) / u_j;
  *x_s1 = s_u_ij;
  write_measure_normal(stdout, "Uncertainty coefficient U, R|C", 30L, 31L, x,
		       x_s0, x_s1);
  *x = (u_j + u_i - u_ij) / u_i;
  *x_s1 = s_u_ji;
  write_measure_normal(stdout, "Uncertainty coefficient U, C|R", 30L, 31L, x,
		       x_s0, x_s1);
  *x = (u_j + u_i - u_ij) / (u_i + u_j) * 2;
  *x_s1 = s_u;
  write_measure_normal(stdout, "Uncertainty coefficient U, sym", 30L, 31L, x,
		       x_s0, x_s1);
}  /* uncertainty */


Static Void kappa(n_total, nrow, ncol, n_total_2, n_total_3, x, x_s0, x_s1,
		  nrowpos, ncolpos, nmatpos)
long *n_total, *nrow, *ncol;
double *n_total_2, *n_total_3, *x, *x_s0, *x_s1;
long *nrowpos, *ncolpos;
long (*nmatpos)[MAX_LEVEL];
{
  t_long_real r_i, c_j, o, y, z, p_o, p_c, p_c_1, p_c_2, p_c_3;
  t_long_integer i, j;
  long FORLIM, FORLIM1;
  double TEMP;

  p_o = 0.0;
  p_c = 0.0;
  p_c_1 = 0.0;
  p_c_2 = 0.0;
  p_c_3 = 0.0;
  if (*ncol == *nrow) {
    FORLIM = *ncol;
    for (i = 0; i < FORLIM; i++) {
      r_i = n[nrowpos[i]];
      c_j = n[ncolpos[i]];
      o = n[nmatpos[i][i]];
      p_o += o;
      p_c += r_i * c_j;
      *x = r_i + c_j;
      p_c_1 += o * *x;
      p_c_3 += r_i * c_j * *x;
      FORLIM1 = *ncol;
      for (j = 0; j < FORLIM1; j++) {
	c_j = n[ncolpos[j]];
	o = n[nmatpos[i][j]];
	*x = r_i + c_j;
	p_c_2 += o * *x * *x;
      }
    }
  }
  p_o /= *n_total;
  p_c /= *n_total_2;
  p_c_1 /= *n_total_2;
  p_c_2 /= *n_total_3;
  p_c_3 /= *n_total_3;
  if (*ncol != *nrow)
    return;
  y = 1 - p_c;
  z = y * y;
  *x = (p_o - p_c) / y;
  *x_s0 = p_o * (1 - p_o) / z;
  *x_s1 = *x_s0 / *n_total;
  *x_s0 += 2 * (1 - p_o) * (2 * p_o * p_c - p_c_1) / z / y;
  TEMP = 1 - p_o;
  *x_s0 += TEMP * TEMP * (p_c_2 - 4 * p_c * p_c) / z / z;
  *x_s0 /= *n_total;
  write_measure_normal(stdout, "Kappa", 5L, 31L, x,
		       x_s0, x_s1);
  *x = (p_o - p_c) / y;
  *x_s0 = p_c + p_c * p_c - p_c_3;
  *x_s0 /= z * z;
  *x_s0 /= *n_total;
  write_measure_normal(stdout, "Kappa", 5L, 31L, x,
		       x_s0, x_s1);
}  /* kappa */


Static Void linear_trend(n_total, nrow, ncol, nr, nc, fr, lr, fc, lc, df_a,
			 df_b, x, p_a, p_b, nrowpos, ncolpos, nmatpos)
long *n_total, *nrow, *ncol, *nr, *nc, *fr, *lr, *fc, *lc, *df_a, *df_b;
double *x, *p_a, *p_b;
long *nrowpos, *ncolpos;
long (*nmatpos)[MAX_LEVEL];
{
  t_long_real x_, b, x_2_l, z_2, y, z, p_1, p_2, o_1, mm;
  t_long_integer npoints, i;

  if (*nc != 2 && *nr != 2 || *nc <= 2 && *nr <= 2)
    return;
  if (*nc == 2) {
    p_1 = (double)n[ncolpos[*fc - 1]] / *n_total;
    p_2 = (double)n[ncolpos[*lc - 1]] / *n_total;
    npoints = *nrow;
  } else {
    p_1 = (double)n[nrowpos[*fr - 1]] / *n_total;
    p_2 = (double)n[nrowpos[*lr - 1]] / *n_total;
    npoints = *ncol;
  }
  x_ = 0.0;
  for (i = 1; i <= npoints; i++) {
    if (*nc == 2)
      mm = n[nrowpos[i - 1]];
    else
      mm = n[ncolpos[i - 1]];
    x_ += mm * i;
  }
  x_ /= *n_total;
  b = 0.0;
  y = 0.0;
  for (i = 1; i <= npoints; i++) {
    if (*nc == 2) {
      mm = n[nrowpos[i - 1]];
      o_1 = n[nmatpos[i - 1][*fc - 1]];
    } else {
      mm = n[ncolpos[i - 1]];
      o_1 = n[nmatpos[*fr - 1][i - 1]];
    }
    if (mm > 0) {
      z = i - x_;
      b += mm * (o_1 / mm - p_1) * z;
      y += mm * z * z;
    }
  }
  b /= y;
  z_2 = b * b * y / p_1 / p_2;
  *x = z_2;
  *df_a = 1;
  *p_a = khi(*df_a, *x);
  write_measure(stdout, "Cochran-Armitage Trend Test", 27L, 31L, 3L, df_a,
		df_b, x, p_a, p_b);
  x_2_l = 0.0;
  for (i = 1; i <= npoints; i++) {
    if (*nc == 2) {
      mm = n[nrowpos[i - 1]];
      o_1 = n[nmatpos[i - 1][*fc - 1]];
    } else {
      mm = n[ncolpos[i - 1]];
      o_1 = n[nmatpos[*fr - 1][i - 1]];
    }
    if (mm > 0) {
      z = p_1 + b * (i - x_);
      z = o_1 / mm - z;
      x_2_l += mm * z * z;
    }
  }
  x_2_l = x_2_l / p_1 / p_2;
  *x = x_2_l;
  *df_a = npoints - 2;
  *p_a = khi(*df_a, *x);
  if (*nc == 2)
    *df_b = *nr - 2;
  else
    *df_b = *nc - 2;
  if (*df_b < *df_a)
    *p_b = khi(*df_b, *x);
  else
    *df_b = _INVALID;
  write_measure(stdout, "Goodness of fit, linear trend", 29L, 31L, 3L, df_a,
		df_b, x, p_a, p_b);
}  /* linear_trend */


Static Void mcnemar(nrow, ncol, nr, df_a, df_b, x, p_a, p_b, nmatpos)
long *nrow, *ncol, *nr, *df_a, *df_b;
double *x, *p_a, *p_b;
long (*nmatpos)[MAX_LEVEL];
{
  t_long_real mcnemar, a, b, c;
  t_long_integer i, j;
  long FORLIM, FORLIM1;

  mcnemar = 0.0;
  if (*ncol == *nrow) {
    FORLIM = *ncol;
    for (i = 0; i < FORLIM; i++) {
      FORLIM1 = *nrow;
      for (j = i + 1; j < FORLIM1; j++) {
	a = n[nmatpos[j][i]];
	b = n[nmatpos[i][j]];
	c = a - b;
	if (a + b > 0)
	  mcnemar += c * c / (a + b);
      }
    }
  }
  if (*ncol != *nrow)
    return;
  *x = mcnemar;
  *df_a = (long)floor(*nrow * (*nrow - 1.0) / 2 + 0.5);
  *p_a = khi(*df_a, *x);
  if (*nr < *nrow) {
    *df_b = (long)floor(*nr * (*nr - 1.0) / 2 + 0.5);
    *p_b = khi(*df_b, *x);
  }
  write_measure(stdout, "McNemar's test of symmetry", 26L, 31L, 3L, df_a,
		df_b, x, p_a, p_b);
}  /* mcnemar */


/*@-"slice.c"*/


Static Void print_slice(v__, w__, vertex_set, cell, n_total, nrow, ncol,
			nrowpos, ncolpos, nmatpos)
t_vertex *v__, *w__;
long *vertex_set;
t_level *cell;
long *n_total, *nrow, *ncol;
long *nrowpos, *ncolpos;
long (*nmatpos)[MAX_LEVEL];
{
  t_vertex u__, u___;
  t_long_real n_total_2, n_total_3, n_total_4, p_1_side, p_2_side, x_2, g_2,
	      q_c, o, e, m, x, x_s0, x_s1, p_a, p_b, ss_r, ss_c, ss_1_r,
	      ss_1_c, sc_r, sc_c, r_i, c_j, a, b, c, d, r1, r2, c1, c2;
  t_long_integer fr, lr, fc, lc, nr, nc, df_a, df_b, i, j;
  boolean ok;
  long FORLIM, FORLIM1;
  double TEMP;
  t_vertex FORLIM2;

  n_total_2 = *n_total * *n_total;
  n_total_3 = *n_total * n_total_2;
  n_total_4 = n_total_2 * n_total_2;
  if (n_total_2 >= *n_total && n_total_3 >= n_total_2 &&
      n_total_4 >= n_total_3) {
    nc = 0;
    ss_c = 0.0;
    sc_c = 0.0;
    ss_1_c = 0.0;
    fc = 1;
    lc = 1;
    FORLIM = *ncol;
    for (j = 1; j <= FORLIM; j++) {
      c_j = n[ncolpos[j - 1]];
      if (c_j != 0) {
	nc++;
	if (nc == 1)
	  fc = j;
	else
	  lc = j;
      }
      ss_c += c_j * c_j;
      sc_c += c_j * c_j * c_j;
      ss_1_c += c_j * (c_j - 1);
    }
    nr = 0;
    ss_r = 0.0;
    sc_r = 0.0;
    ss_1_r = 0.0;
    fr = 1;
    lr = 1;
    FORLIM = *nrow;
    for (i = 1; i <= FORLIM; i++) {
      r_i = n[nrowpos[i - 1]];
      if (r_i != 0) {
	nr++;
	if (nr == 1)
	  fr = i;
	else
	  lr = i;
      }
      ss_r += r_i * r_i;
      sc_r += r_i * r_i * r_i;
      ss_1_r += r_i * (r_i - 1);
    }
    df_a = _INVALID;
    df_b = _INVALID;
    x = _INVALID_REAL;
    x_s0 = _INVALID_REAL;
    x_s1 = _INVALID_REAL;
    p_a = _INVALID_REAL;
    p_b = _INVALID_REAL;
    x_2 = 0.0;
    g_2 = 0.0;
    q_c = 0.0;
    FORLIM = *ncol;
    for (j = 0; j < FORLIM; j++) {
      c_j = n[ncolpos[j]];
      FORLIM1 = *nrow;
      for (i = 0; i < FORLIM1; i++) {
	r_i = n[nrowpos[i]];
	e = c_j * r_i / *n_total;
	o = n[nmatpos[i][j]];
	if (e > 0) {
	  TEMP = o - e;
	  x_2 += TEMP * TEMP / e;
	}
	x = fabs(e - o) - 0.5;
	if (x > 0 && e > 0)
	  q_c += x * x / e;
	if (e > 0 && o > 0)
	  g_2 += 2 * o * log(o / e);
      }
    }
    if (*nrow < *ncol)
      m = *nrow;
    else
      m = *ncol;
    if (nr < nc)
      m = nr;
    else
      m = nc;
    a = n[nmatpos[fr - 1][fc - 1]];
    b = n[nmatpos[lr - 1][fc - 1]];
    c = n[nmatpos[fr - 1][lc - 1]];
    d = n[nmatpos[lr - 1][lc - 1]];
    c1 = n[ncolpos[fc - 1]];
    c2 = n[ncolpos[lc - 1]];
    r1 = n[nrowpos[fr - 1]];
    r2 = n[nrowpos[lr - 1]];
    page(stdout);
    write_line(stdout);
    if (!P_setequal(vertex_set, empty_set)) {
      ok = false;
      write_space(stdout, 2L);
      write_pch(stdout, "Cell:", 5L);
      u___ = first_vertex;
      FORLIM2 = last_vertex;
      for (u__ = first_vertex; u__ <= FORLIM2; u__++) {
	if (P_inset(u__, vertex_set)) {
	  if (ok)
	    write_char(stdout, ',');
	  ok = true;
	  write_space(stdout, 2L);
	  print_vertex_on_file(stdout, u__);
	  write_space(stdout, 1L);
	  write_char(stdout, '=');
	  write_space(stdout, 1L);
	  write_integer(stdout, cell[u___ - MIN_VERTEX] - FIRST_LEVEL + 1L,
			1L);
	  u___++;
	}
      }
      write_char(stdout, '.');
      write_line(stdout);
      write_line(stdout);
    }
    write_space(stdout, 3L);
    write_char(stdout, '\\');
    write_char(stdout, ' ');
    write_char(stdout, vertex_inf[*w__ - MIN_VERTEX].name);
    write_char(stdout, ' ');
    write_char(stdout, '|');
    FORLIM = *ncol;
    for (i = 1; i <= FORLIM; i++)
      write_integer(stdout, i, 5L);
    write_space(stdout, 1L);
    write_char(stdout, '|');
    write_space(stdout, 6L);
    if (long_names)
      print_vertex_on_file(stdout, *w__);
    write_line(stdout);
    write_space(stdout, 4L);
    write_char(stdout, '\\');
    write_space(stdout, 2L);
    write_char(stdout, '|');
    write_space(stdout, *ncol * 5 + 1);
    write_char(stdout, '|');
    write_space(stdout, 6L);
    write_line(stdout);
    write_space(stdout, 3L);
    write_char(stdout, vertex_inf[*v__ - MIN_VERTEX].name);
    write_space(stdout, 1L);
    write_char(stdout, '\\');
    write_space(stdout, 1L);
    write_char(stdout, '|');
    write_space(stdout, *ncol * 5 + 1);
    write_char(stdout, '|');
    write_space(stdout, 6L);
    if (long_names)
      print_vertex_on_file(stdout, *v__);
    write_line(stdout);
    write_space(stdout, 2L);
    for (i = 2; i <= 5; i++)
      write_char(stdout, '_');
    write_char(stdout, '\\');
    write_char(stdout, '|');
    FORLIM = *ncol * 5 + 1;
    for (i = 1; i <= FORLIM; i++)
      write_char(stdout, '_');
    write_char(stdout, '|');
    for (i = 1; i <= 6; i++)
      write_char(stdout, '_');
    write_line(stdout);
    FORLIM = *nrow;
    for (j = 1; j <= FORLIM; j++) {
      write_space(stdout, 2L);
      write_integer(stdout, j, 2L);
      write_space(stdout, 2L);
      write_space(stdout, 1L);
      write_char(stdout, '|');
      FORLIM1 = *ncol;
      for (i = 0; i < FORLIM1; i++)
	write_integer(stdout, n[nmatpos[j - 1][i]], 5L);
      write_space(stdout, 1L);
      write_char(stdout, '|');
      write_space(stdout, 1L);
      write_integer(stdout, n[nrowpos[j - 1]], 5L);
      write_line(stdout);
    }
    write_space(stdout, 2L);
    FORLIM = (*ncol + 1) * 5 + 9;
    for (i = 1; i <= FORLIM; i++)
      write_char(stdout, '=');
    write_line(stdout);
    write_space(stdout, 7L);
    write_char(stdout, '|');
    FORLIM = *ncol;
    for (i = 0; i < FORLIM; i++)
      write_integer(stdout, n[ncolpos[i]], 5L);
    write_space(stdout, 1L);
    write_char(stdout, '|');
    write_space(stdout, 1L);
    write_integer(stdout, *n_total, 5L);
    write_line(stdout);
    write_line(stdout);
    if (nc == 2 && nr == 2) {
      fisher((long)floor(a + 0.5), (long)floor(b + 0.5), (long)floor(c + 0.5),
	     (long)floor(d + 0.5), &p_1_side, &p_2_side);
      write_pch_r(stdout, "Fisher's exact test", 19L, 31L);
      write_space(stdout, 2L);
      write_pch(stdout, "(1-Tail): ", 10L);
      write_real(stdout, p_1_side, prob_width, prob_dec);
      write_space(stdout, 1L);
      write_pch(stdout, "(2-Tail): ", 10L);
      write_real(stdout, p_2_side, prob_width, prob_dec);
      write_line(stdout);
    }
    write_measure_head(stdout, "", 0L, 31L);
    x = x_2;
    df_a = (*ncol - 1) * (*nrow - 1);
    p_a = khi(df_a, x);
    if (nc < *ncol || nr < *nrow) {
      df_b = (nc - 1) * (nr - 1);
      p_b = khi(df_b, x);
    }
    write_measure(stdout, "Pearson X^2 test", 16L, 31L, 3L,
		  &df_a, &df_b, &x, &p_a, &p_b);
    x = g_2;
    df_a = (*ncol - 1) * (*nrow - 1);
    p_a = khi(df_a, x);
    if (nc < *ncol || nr < *nrow) {
      df_b = (nc - 1) * (nr - 1);
      p_b = khi(df_b, x);
    }
    write_measure(stdout, "G^2 likelihood ratio test", 25L, 31L, 3L,
		  &df_a, &df_b, &x, &p_a, &p_b);
    x = q_c;
    df_a = (*ncol - 1) * (*nrow - 1);
    p_a = khi(df_a, x);
    if (nc < *ncol || nr < *nrow) {
      df_b = (nc - 1) * (nr - 1);
      p_b = khi(df_b, x);
    }
    write_measure(stdout, "Continuity-adjusted chi-square", 30L, 31L, 3L,
		  &df_a, &df_b, &x, &p_a, &p_b);
    if (nc == 2 && nr == 2) {
      TEMP = fabs(a * d - b * c) - *n_total / 2.0;
      x = *n_total * (TEMP * TEMP) / r1 / r2 / c1 / c2;
      df_a = 1;
      p_a = khi(df_a, x);
      write_measure(stdout, "Yates corrected X^2", 19L, 31L, 3L,
		    &df_a, &df_b, &x, &p_a, &p_b);
    }
    mcnemar(nrow, ncol, &nr, &df_a, &df_b, &x, &p_a, &p_b, nmatpos);
    if (m > 1 && *n_total > 0) {
      x = sqrt(x_2 / *n_total / (m - 1));
      df_a = 1;
      p_a = khi(df_a, x);
    }
    write_measure(stdout, "Cramer's V", 10L, 31L, 3L,
		  &df_a, &df_b, &x, &p_a, &p_b);
    if (nc == 2 && nr == 2)
      x = (a * d - b * c) / sqrt(r1 * r2 * c1 * c2);
    else if (*n_total > 0)
      x = sqrt(x_2 / *n_total);
    write_measure(stdout, "Phi", 3L, 31L, 1L,
		  &df_a, &df_b, &x, &p_a, &p_b);
    if (nc == 2 && nr == 2) {
      if (r1 != 0 && r2 != 0 && c1 != 0 && c2 != 0) {
	if (a * d < b * c)
	  x = -sqrt(r1 * c1 / r2 / c2);
	else
	  x = sqrt(r1 * c2 / r2 / c1);
	if (fabs(x) > 1)
	  x = 1 / x;
      }
      write_measure(stdout, "Max Phi", 7L, 31L, 1L,
		    &df_a, &df_b, &x, &p_a, &p_b);
    }
    if (*n_total > 0)
      x = sqrt(x_2 / (*n_total + x_2));
    write_measure(stdout, "Contingency Coefficient C", 25L, 31L, 1L,
		  &df_a, &df_b, &x, &p_a, &p_b);
    if (nc == 2 && nr == 2) {
      if (r1 != 0 && r2 != 0 && c1 != 0 && c2 != 0) {
	if (a * d < b * c)
	  x = -sqrt(r1 * c1 / r2 / c2);
	else
	  x = sqrt(r1 * c2 / r2 / c1);
	if (fabs(x) > 1)
	  x = 1 / x;
	x = sqrt(x * x / (1 + x * x));
      }
      write_measure(stdout, "Max Contingency coefficient", 27L, 31L, 1L,
		    &df_a, &df_b, &x, &p_a, &p_b);
    }
    if (false)
      write_measure(stdout, "Tetrachoric correlation", 23L, 31L, 3L,
		    &df_a, &df_b, &x, &p_a, &p_b);
    if (nc >= 2 && nr >= 2)
      linear_trend(n_total, nrow, ncol, &nr, &nc, &fr, &lr, &fc, &lc, &df_a,
		   &df_b, &x, &p_a, &p_b, nrowpos, ncolpos, nmatpos);
    if (nc == 2 && nr == 2) {
      if (b * c != 0) {
	x = a * d / (b * c);
	df_a = 1;
	p_a = khi(df_a, x);
      }
      write_measure(stdout, "Cross-product ratio alpha", 25L, 31L, 3L,
		    &df_a, &df_b, &x, &p_a, &p_b);
    }
    if (nc >= 2 && nr >= 2)
      spearman(n_total, nrow, ncol, &nr, &nc, &df_a, &df_b, &n_total_2,
	       &n_total_3, &sc_r, &sc_c, &x, &x_s0, &x_s1, &p_a, &p_b,
	       nrowpos, ncolpos, nmatpos);
    if (nc == 2 && nr == 2) {
      if (a * b * c * d != 0) {
	x = log(a * d / (b * c));
	x_s1 = 1 / a + 1 / b + 1 / c + 1 / d;
	x_s0 = n_total_3 / ((a + b) * (a + c) * (b + d) * (c + d));
      }
      write_measure_normal(stdout, "Ln(Cross-product ratio)", 23L, 31L,
			   &x, &x_s0, &x_s1);
    }
    if (nc == 2 && nr == 2) {
      if (a * d + b * c != 0) {
	x = (a * d - b * c) / (a * d + b * c);
	if (a * b * c * d != 0) {
	  TEMP = 1 - x * x;
	  x_s1 = TEMP * TEMP * (1 / a + 1 / b + 1 / c + 1 / d) / 4;
	}
	x_s0 = n_total_3 / ((a + b) * (a + c) * (b + d) * (c + d)) / 4;
      }
      write_measure_normal(stdout, "Yule's Q", 8L, 31L,
			   &x, &x_s0, &x_s1);
    }
    if (nc == 2 && nr == 2) {
      if (sqrt(a * d) + sqrt(b * c) != 0) {
	x = (sqrt(a * d) - sqrt(b * c)) / (sqrt(a * d) + sqrt(b * c));
	if (a * b * c * d != 0) {
	  TEMP = 1 - x * x;
	  x_s1 = TEMP * TEMP * (1 / a + 1 / b + 1 / c + 1 / d) / 16;
	}
	x_s0 = n_total_3 / ((a + b) * (a + c) * (b + d) * (c + d)) / 16;
      }
      write_measure_normal(stdout, "Yule's Y", 8L, 31L,
			   &x, &x_s0, &x_s1);
    }
    if (nc >= 2 && nr >= 2) {
      gamma_and_tau(n_total, nrow, ncol, &n_total_2, &n_total_3, &n_total_4,
		    &ss_r, &ss_c, &ss_1_r, &ss_1_c, &m, &x, &x_s0, &x_s1,
		    nrowpos, ncolpos, nmatpos);
      goodman_and_kruskal(n_total, nrow, ncol, &n_total_2, &ss_r, &ss_c,
			  &sc_r, &sc_c, &x, &x_s0, &x_s1, nrowpos, ncolpos,
			  nmatpos);
      optimal_prediction(n_total, nrow, ncol, &x, &x_s0, &x_s1, nrowpos,
			 ncolpos, nmatpos);
      uncertainty(n_total, nrow, ncol, &x, &x_s0, &x_s1, nrowpos, ncolpos,
		  nmatpos);
      kappa(n_total, nrow, ncol, &n_total_2, &n_total_3, &x, &x_s0, &x_s1,
	    nrowpos, ncolpos, nmatpos);
    }
  } else
    write_pch(stdout, " Too many observations", 22L);
  write_line(stdout);
}  /* print_slice */


/*@-"gamma.c"*/
/*@+"gamma.p"*/


Static Void find_concedances_fast(nrow, ncol, nmatpos, s, s1, p, q, pvalues,
				  ok)
long *nrow, *ncol;
long (*nmatpos)[MAX_LEVEL];
double *s, *s1;
long *p, *q;
boolean pvalues, *ok;
{
  t_long_integer c, d, i, j, k, l, nij, ncc, ndd, ncd;
  t_long_real p2, q2, m;
  long FORLIM, FORLIM1, FORLIM2, FORLIM3;

  ncc = 0;
  ndd = 0;
  ncd = 0;
  *s = 0.0;
  FORLIM = *nrow;
  for (i = 1; i <= FORLIM; i++) {
    FORLIM1 = *ncol;
    for (j = 1; j <= FORLIM1; j++) {
      c = 0;
      d = 0;
      for (k = 0; k <= i - 2; k++) {
	for (l = 0; l <= j - 2; l++)
	  c += n[nmatpos[k][l]];
      }
      FORLIM2 = *nrow;
      for (k = i; k < FORLIM2; k++) {
	for (l = 0; l <= j - 2; l++)
	  d += n[nmatpos[k][l]];
      }
      for (k = 0; k <= i - 2; k++) {
	FORLIM3 = *ncol;
	for (l = j; l < FORLIM3; l++)
	  d += n[nmatpos[k][l]];
      }
      FORLIM2 = *nrow;
      for (k = i; k < FORLIM2; k++) {
	FORLIM3 = *ncol;
	for (l = j; l < FORLIM3; l++)
	  c += n[nmatpos[k][l]];
      }
      nij = n[nmatpos[i - 1][j - 1]];
      ncc += nij * c * c;
      ndd += nij * d * d;
      ncd += nij * c * d;
      *p += nij * c;
      *q += nij * d;
      m = c - d;
      *s += nij * m * m;
    }
  }
  if (pvalues && *p + *q > 0) {
    *ok = true;
    p2 = *p;
    q2 = *q;
    *s1 = q2 * q2 * ncc + p2 * p2 * ndd - 2 * p2 * q2 * ncd;
  }
  /*$ifdef TRACE*/
  if (!boolean_option[12])
    return;
  /*$endif TRACE*/
  write_real(stdout, m, 10L, 0L);
  write_real(stdout, (double)ncc, 10L, 0L);
  write_real(stdout, (double)ndd, 10L, 0L);
  write_real(stdout, (double)ncd, 10L, 0L);
}  /* find_concedances_fast */


Static Void find_concedances_large_counts(nrow, ncol, nmatpos, s, s1, p, q,
					  pvalues, ok)
long *nrow, *ncol;
long (*nmatpos)[MAX_LEVEL];
double *s, *s1;
long *p, *q;
boolean pvalues, *ok;
{
  t_long_integer i, j;
  t_long_real m;
  long (*cij)[MAX_LEVEL], (*dij)[MAX_LEVEL];
  long FORLIM, FORLIM1;

  cij = (long(*)[MAX_LEVEL])Malloc(sizeof(t_level_2_arr_of_integer));
  if (cij == NULL)
    _OutMem();
  dij = (long(*)[MAX_LEVEL])Malloc(sizeof(t_level_2_arr_of_integer));
  if (dij == NULL)
    _OutMem();
  sub_find_concedances(nrow, ncol, nmatpos, cij, dij, p, q);
  if (pvalues && *p + *q > 0) {
    *ok = true;
    *s = 0.0;
    FORLIM = *nrow;
    for (i = 0; i < FORLIM; i++) {
      FORLIM1 = *ncol;
      for (j = 0; j < FORLIM1; j++) {
	m = cij[i][j] - dij[i][j];
	*s += n[nmatpos[i][j]] * m * m;
	m = *q * cij[i][j] - *p * dij[i][j];
	*s1 += n[nmatpos[i][j]] * m * m;
      }
    }
  }
  Free(cij);
  Free(dij);
}  /* find_concedances_large_counts */


Static Void find_gamma(n_total, nrow, ncol, nmatpos, pvalues, ppq, pmq, gamma,
		       s, s1, ok)
long *n_total, *nrow, *ncol;
long (*nmatpos)[MAX_LEVEL];
boolean pvalues;
double *ppq, *pmq, *gamma, *s, *s1;
boolean *ok;
{
  t_long_integer p, q;

  p = 0;
  q = 0;
  *s = 0.0;
  *s1 = 0.0;
  *ok = false;
  if (c_factorizes == 3 && *n_total < 100 || c_factorizes == 2)
    find_concedances_fast(nrow, ncol, nmatpos, s, s1, &p, &q, pvalues, ok);
  else
    find_concedances_large_counts(nrow, ncol, nmatpos, s, s1, &p, &q, pvalues,
				  ok);
  *ppq = p + q;
  *pmq = p - q;
  if (*ok) {
    *gamma = *pmq / *ppq;
    *s -= *pmq * *pmq / *n_total;
    *s *= 4;
    *s1 = *s1 * 16 / *ppq / *ppq;
  } else {
    *gamma = 0.0;
    *s = 0.0;
    *s1 = 0.0;
    *ok = false;
  }
  /*$ifdef TRACE*/
  if (!boolean_option[12])
    return;
  /*$endif TRACE*/
  write_integer(stdout, *nrow, 4L);
  write_integer(stdout, *ncol, 4L);
  write_integer(stdout, *n_total, 4L);
  write_real(stdout, (double)p, 10L, 0L);
  write_real(stdout, (double)q, 10L, 0L);
  write_line(stdout);
  write_real(stdout, *ppq, 10L, 6L);
  write_real(stdout, *pmq, 10L, 6L);
  write_real(stdout, *gamma, 10L, 6L);
  if (*s > 0)
    write_real(stdout, pnormal(fabs(*gamma / sqrt(*s) * *ppq)), 10L, 6L);
  else
    write_real(stdout, 2.0, 10L, 6L);
  write_real(stdout, *s, 10L, 6L);
  write_real(stdout, *s1, 10L, 6L);
  write_real(stdout, (*s - *s1) / (*s + *s1), 10L, 6L);
  write_line(stdout);
}  /* find_gamma */


Static Void compute_slice_statistics(v, w, n_levels_v, n_levels_w, c,
  vc_offset, wc_offset, vwc_offset, slice_pack, gammatot, stot, s1tot,
  print_slices)
t_vertex *v, *w;
t_level *n_levels_v, *n_levels_w;
long *c;
t_offset vc_offset, wc_offset, vwc_offset;
t_slice_pack *slice_pack;
double *gammatot, *stot, *s1tot;
boolean print_slices;
{
  t_cell_index index_1, index_2, n_l_w_p_vwc_w, pos_1_vc, pos_2_wc, pos_3_vwc;
  boolean ok;
  t_long_real gamma, ppq, pmq, s, s1, ppqtot, pmqtot;
  t_long_integer n_total;
  t_cell i;
  t_offset i_v, i_w, i_c;
  t_integer nrowx, ncolx, ncolx1;
  long *nrowpos, *ncolpos;
  long (*nmatpos)[MAX_LEVEL];
  boolean zero_col[MAX_LEVEL];
  t_offset FORLIM, FORLIM1;
  long TEMP;
  t_offset FORLIM2;

  nmatpos = (long(*)[MAX_LEVEL])Malloc(sizeof(t_level_2_arr_of_integer));
  if (nmatpos == NULL)
    _OutMem();
  nrowpos = (long *)Malloc(sizeof(t_level_arr_of_integer));
  if (nrowpos == NULL)
    _OutMem();
  ncolpos = (long *)Malloc(sizeof(t_level_arr_of_integer));
  if (ncolpos == NULL)
    _OutMem();
  memcpy(i, first_cell, sizeof(t_cell));
  n_l_w_p_vwc_w = *n_levels_w * slice_pack->p_vwc_w;
  pos_1_vc = vc_offset;
  pos_2_wc = wc_offset;
  pos_3_vwc = vwc_offset;
  ppqtot = 0.0;
  pmqtot = 0.0;
  *stot = 0.0;
  *s1tot = 0.0;
  FORLIM = slice_pack->marginal_dimension_c;
  for (i_c = 1; i_c <= FORLIM; i_c++) {
    index_2 = pos_2_wc;
    ncolx = 0;
    n_total = 0;
    /*$ifdef TRACE*/
    if (boolean_option[11])
      write_pch_10_text(stdout, " Ncol: ", 7L);
    FORLIM1 = *n_levels_w;
    /*$endif TRACE*/
    for (i_w = 0; i_w < FORLIM1; i_w++) {
      /*$ifdef TRACE*/
      if (boolean_option[11]) {
	TEMP = 4;
	write_cell_count_text(stdout, &n[index_2], &TEMP);
      }
      /*$endif TRACE*/
      if (n[index_2] == 0 && !print_slices)
	zero_col[i_w] = true;
      else {
	n_total += n[index_2];
	zero_col[i_w] = false;
	ncolx++;
	ncolpos[ncolx - 1] = index_2;
      }
      index_2 += slice_pack->p_wc_w;
    }
    /*$ifdef TRACE*/
    if (boolean_option[11]) {
      TEMP = 4;
      write_integer_text(stdout, n_total, &TEMP);
      TEMP = 4;
      write_integer_text(stdout, ncolx, &TEMP);
      write_line_text(stdout);
    }
    /*$endif TRACE*/
    index_1 = pos_1_vc;
    index_2 = pos_3_vwc;
    nrowx = 0;
    /*$ifdef TRACE*/
    if (boolean_option[11])
      write_pch_10_text(stdout, " Nrow: ", 7L);
    /*$endif TRACE*/
    n_total = 0;
    FORLIM1 = *n_levels_v;
    for (i_v = 1; i_v <= FORLIM1; i_v++) {
      /*$ifdef TRACE*/
      if (boolean_option[11]) {
	TEMP = 4;
	write_cell_count_text(stdout, &n[index_1], &TEMP);
      }
      /*$endif TRACE*/
      if (n[index_1] == 0 && !print_slices) {
	FORLIM2 = *n_levels_w;
	for (i_w = 1; i_w <= FORLIM2; i_w++)
	  index_2 += slice_pack->p_vwc_w;
      } else {
	n_total += n[index_1];
	nrowx++;
	nrowpos[nrowx - 1] = index_1;
	ncolx1 = 0;
	FORLIM2 = *n_levels_w;
	for (i_w = 0; i_w < FORLIM2; i_w++) {
	  if (!zero_col[i_w]) {
	    ncolx1++;
	    nmatpos[nrowx - 1][ncolx1 - 1] = index_2;
	  }
	  index_2 += slice_pack->p_vwc_w;
	}
      }
      index_2 += slice_pack->p_vwc_v - n_l_w_p_vwc_w;
      index_1 += slice_pack->p_vc_v;
    }
    /*$ifdef TRACE*/
    if (boolean_option[11]) {
      TEMP = 4;
      write_integer_text(stdout, n_total, &TEMP);
      TEMP = 4;
      write_integer_text(stdout, nrowx, &TEMP);
      write_line_text(stdout);
    }
    /*$endif TRACE*/
    if (nrowx > 1 && ncolx > 1) {
      if (print_slices)
	print_slice(v, w, c, i, &n_total, &nrowx, &ncolx, nrowpos, ncolpos,
		    nmatpos);
      else {
	find_gamma(&n_total, &nrowx, &ncolx, nmatpos, true, &ppq, &pmq,
		   &gamma, &s, &s1, &ok);
	ppqtot += ppq;
	pmqtot += pmq;
	*stot += s;
	*s1tot += s1;
      }
    }
    next_offset_in_slice(slice_pack, &pos_1_vc, &pos_2_wc, &pos_3_vwc, i);
  }
  Free(nmatpos);
  Free(nrowpos);
  Free(ncolpos);
  if (ppqtot > 0 && !print_slices) {
    *gammatot = pmqtot / ppqtot;
    *stot /= ppqtot;
    *stot /= ppqtot;
    *s1tot /= ppqtot;
    *s1tot /= ppqtot;
  } else {
    *gammatot = _INVALID_REAL;
    *stot = _INVALID_REAL;
    *s1tot = _INVALID_REAL;
  }
  /*$ifdef TRACE*/
  if (!boolean_option[12])
    return;
  /*$endif TRACE*/
  write_real(stdout, ppqtot, 10L, 6L);
  write_real(stdout, pmqtot, 10L, 6L);
  write_real(stdout, *gammatot, 10L, 6L);
  write_real(stdout, pnormal(fabs(*gammatot / sqrt(*stot))), 10L, 6L);
  write_real(stdout, *stot, 10L, 6L);
  write_real(stdout, *s1tot, 10L, 6L);
  write_line(stdout);
}  /* compute_slice_statistics */


/*@-"offsets.c"*/
/*@+"offsets.p"*/


Static boolean ok_to_find_expression_marginals(link_expression)
t_expression *link_expression;
{
  boolean ok;

  ok = true;
  while (ok && link_expression != NULL) {
    ok = ok_to_find_marginal_hash(link_expression->vertex_set);
    link_expression = link_expression->pointer;
  }
  return ok;
}  /* ok_to_find_expression_marginals */


Static boolean ok_to_find_radim_part(upper, lower)
t_offset_list *upper, *lower;
{
  boolean ok;
  t_vertex_set vertex_set;

  ok = true;
  if (lower == NULL) {
    if (upper != NULL)
      ok = ok_to_find_marginal_hash(upper->vertex_set);
    return ok;
  }
  P_setunion(vertex_set, upper->vertex_set, lower->vertex_set);
  ok = ok_to_find_marginal_hash(vertex_set);
  upper = upper->pointer;
  while (upper != NULL && ok) {
    P_setunion(vertex_set, upper->vertex_set, lower->vertex_set);
    ok = ok_to_find_marginal_hash(vertex_set);
    upper = upper->pointer;
    lower = lower->pointer;
  }
  return ok;
}  /* ok_to_find_radim_part */


Static boolean ok_to_find_radim_marginals(radim_list)
t_list_radim_elements *radim_list;
{
  boolean ok;

  ok = true;
  while (radim_list != NULL && ok) {
    if (radim_list->radim_element.radim_parts != NULL)
      ok = ok_to_find_radim_part(radim_list->radim_element.radim_parts->upper,
	  radim_list->radim_element.radim_parts->lower);
    radim_list = radim_list->pointer;
  }
  return ok;
}  /* ok_to_find_radim_marginals */


Static boolean ok_to_find_ips_marginals(ips_list)
t_list_ips_elements *ips_list;
{
  boolean ok;

  ok = true;
  while (ips_list != NULL && ok) {
    ok = ok_to_find_marginal_hash(ips_list->ips_element.a);
    ips_list = ips_list->pointer;
  }
  return ok;
}  /* ok_to_find_ips_marginals */


Static boolean ok_to_find_model_marginals(model)
t_model *model;
{
  boolean ok;

  ok = ok_to_find_expression_marginals(model->expression);
  if (ok)
    ok = ok_to_find_ips_marginals(model->ips_list);
  if (ok)
    ok = ok_to_find_radim_marginals(model->radim_list);
  return ok;
}  /* ok_to_find_model_marginals */


Static Void find_expression_marginals_and_insert_offsets(link_expression, ok)
t_expression *link_expression;
boolean *ok;
{
  *ok = true;
  while (*ok && link_expression != NULL) {
    link_expression->offset = return_offset(link_expression->vertex_set, ok);
    link_expression = link_expression->pointer;
  }
}  /* find_expression_marginals_and_insert_offsets */


Static Void find_ips_marginals_and_insert_offsets(ips_list, ok_n, ok_p)
t_list_ips_elements *ips_list;
boolean *ok_n, *ok_p;
{
  t_ips_set_list *pp;
  t_list_ips_elements *q;
  t_long_integer tmp_fpa, max, s, m, m1, m2;
  t_ips_element *WITH;

  *ok_n = true;
  *ok_p = true;
  tmp_fpa = fpa;
  max = 0;
  s = 0;
  q = ips_list;
  while (ips_list != NULL && tmp_fpa <= max_p_cell_number && *ok_n && *ok_p) {
    WITH = &ips_list->ips_element;
    WITH->p_offset = tmp_fpa;
    if (ips_in_use != 1)
      WITH->n_offset = return_offset(WITH->a, ok_n);
    m = marginal_dimension(WITH->a);
    if (m < MAX_P_CELL_NUMBER_MAX - tmp_fpa)
      tmp_fpa += m;
    else
      *ok_p = false;
    pp = WITH->gen_class;
    m1 = 0;
    while (pp != NULL && *ok_n) {
      pp->n_offset = return_offset(pp->vertex_set, ok_n);
      m2 = marginal_dimension(pp->vertex_set);
      if (m2 > m1)
	m1 = m2;
      pp = pp->pointer;
    }
    s += m;
    if (ips_in_use == 1)
      m1 += m;
    if (mean_ips_in_use != normal_ips)
      m1 += m;
    if (m1 < MAX_P_CELL_NUMBER_MAX - s) {
      if (s + m1 > max)
	max = s + m1;
    } else
      *ok_p = false;
    ips_list = ips_list->pointer;
    if (*ok_p && !TURBO_PC)
      *ok_p = space_in_p_array(tmp_fpa, 0L);
  }
  if (*ok_p && !TURBO_PC)
    *ok_p = space_in_p_array(max, tmp_fpa);
  if (*ok_p)
    *ok_p = (max <= max_p_cell_number - tmp_fpa);
  if (*ok_n && *ok_p) {
    fpa = tmp_fpa;
    return;
  }
  while (q != NULL) {
    q->ips_element.p_offset = MAX_OFFSET;
    q = q->pointer;
  }
}  /* find_ips_marginals_and_insert_offsets */


Static Void insert_expression_marginals_in_list(link_expression, link_set_list)
t_expression *link_expression;
t_set_list **link_set_list;
{
  while (link_expression != NULL) {
    insert_set_in_list_of_marginals_to_find(link_expression->vertex_set,
					    link_set_list);
    link_expression = link_expression->pointer;
  }
}  /* insert_expression_marginals_in_list */


Static Void insert_ips_marginals_in_list(ips_list, link_set_list)
t_list_ips_elements *ips_list;
t_set_list **link_set_list;
{
  t_ips_set_list *p;

  while (ips_list != NULL) {
    if (ips_in_use != 1)
      insert_set_in_list_of_marginals_to_find(ips_list->ips_element.a,
					      link_set_list);
    p = ips_list->ips_element.gen_class;
    while (p != NULL) {
      insert_set_in_list_of_marginals_to_find(p->vertex_set, link_set_list);
      p = p->pointer;
    }
    ips_list = ips_list->pointer;
  }
}  /* insert_ips_marginals_in_list */


Static Void test_expression_marginals(model_1, model_2, g, ok)
t_model *model_1, *model_2;
long *g;
boolean *ok;
{
  t_long_integer dimension_g;
  t_set_list *marginal_list;

  if (datastructure != all) {
    marginal_list = NULL;
    if (ok_to_find_marginal_hash(g)) {
      dimension_g = marginal_dimension(g);
      if (!TURBO_PC)
	*ok = space_in_n_array(dimension_g, fna);
      if (dimension_g <= max_cell_number - fna)
	insert_set_in_list_of_marginals_to_find(g, &marginal_list);
      else
	*ok = false;
    } else
      *ok = false;
    if (*ok) {
      insert_expression_marginals_in_list(model_1->expression, &marginal_list);
      insert_expression_marginals_in_list(model_2->expression, &marginal_list);
      find_list_of_marginals(&marginal_list, ok);
    }
    dispose_set_list(&marginal_list);
  }
  if (*ok) {
    find_expression_marginals_and_insert_offsets(model_1->expression, ok);
    find_expression_marginals_and_insert_offsets(model_2->expression, ok);
  }
}  /* test_expression_marginals */


Static Void test_expression_marginals_one(model_1, g, ok)
t_model *model_1;
long *g;
boolean *ok;
{
  t_long_integer dimension_g;
  t_set_list *marginal_list;

  if (datastructure != all) {
    marginal_list = NULL;
    if (ok_to_find_marginal_hash(g)) {
      dimension_g = marginal_dimension(g);
      if (!TURBO_PC)
	*ok = space_in_n_array(dimension_g, fna);
      if (dimension_g <= max_cell_number - fna)
	insert_set_in_list_of_marginals_to_find(g, &marginal_list);
      else
	*ok = false;
    } else
      *ok = false;
    if (*ok) {
      insert_expression_marginals_in_list(model_1->expression, &marginal_list);
      find_list_of_marginals(&marginal_list, ok);
    }
    dispose_set_list(&marginal_list);
  }
  if (*ok)
    find_expression_marginals_and_insert_offsets(model_1->expression, ok);
}  /* test_expression_marginals_one */


typedef struct _REC_s {
  t_list_ips_elements *pointer;
  t_long_integer x;
} _REC_s;


Static Void sort_ips_list(ips_list)
t_list_ips_elements **ips_list;
{
  t_ips_set_list *q1;
  t_0_max_dimension i, j, k;
  t_e_cell_index m;
  _REC_s s[MAX_DIMENSION];

  if (*ips_list == NULL)
    return;
  i = 0;
  while (*ips_list != NULL) {
    i++;
    q1 = (*ips_list)->ips_element.gen_class;
    s[i - 1].pointer = *ips_list;
    s[i - 1].x = 0;
    while (q1 != NULL) {
      m = marginal_dimension(q1->vertex_set);
      if (m > s[i - 1].x)
	s[i - 1].x = m;
      q1 = q1->pointer;
    }
    if (ips_in_use == 1)
      s[i - 1].x += marginal_dimension((*ips_list)->ips_element.a);
    *ips_list = (*ips_list)->pointer;
  }
  for (j = i; j >= 2; j--) {
    for (k = 1; k < j; k++) {
      if (s[k - 1].x < s[k].x) {
	s[MAX_DIMENSION - 1] = s[k - 1];
	s[k - 1] = s[k];
	s[k] = s[MAX_DIMENSION - 1];
      }
    }
  }
  *ips_list = s[0].pointer;
  for (j = 1; j < i; j++)
    s[j - 1].pointer->pointer = s[j].pointer;
  s[i - 1].pointer->pointer = NULL;
}  /* sort_ips_list */


Static Void test_of_one_radim_marginals_and_insert_offsets(radim_element, ok)
t_radim_element *radim_element;
boolean *ok;
{
  t_long_integer m, tmp_fpa, max_m;
  t_vertex_set a;
  t_radim_part *radim_part;
  t_offset_list *generators, *upper, *lower;
  boolean ok_n;

  *ok = true;
  ok_n = true;
  tmp_fpa = fpa;
  radim_part = radim_element->radim_parts;
  if (radim_part != NULL) {
    generators = radim_part->generators;
    while (generators != NULL && ok_n) {
      generators->offset = return_offset(generators->vertex_set, &ok_n);
      generators = generators->pointer;
    }
    upper = radim_part->upper;
    lower = radim_part->lower;
    P_setunion(a, upper->vertex_set, lower->vertex_set);
    upper->offset = tmp_fpa;
    lower->offset = return_offset(a, &ok_n);
    m = marginal_dimension(a);
    if (m < MAX_P_CELL_NUMBER_MAX - tmp_fpa)
      tmp_fpa += m;
    else
      *ok = false;
    upper = upper->pointer;
    lower = lower->pointer;
    max_m = m;
    while (upper != NULL && *ok) {
      P_setunion(a, upper->vertex_set, lower->vertex_set);
      upper->offset = tmp_fpa;
      lower->offset = return_offset(a, &ok_n);
      m = marginal_dimension(a);
      if (m < MAX_P_CELL_NUMBER_MAX - tmp_fpa)
	tmp_fpa += m;
      else
	*ok = false;
      if (m > max_m)
	max_m = m;
      upper = upper->pointer;
      lower = lower->pointer;
    }
    radim_part = radim_part->pointer;
  }
  m = max_m;
  if (ips_in_use == 1)
    m += tmp_fpa - fpa;
  if (m < MAX_P_CELL_NUMBER_MAX - fpa)
    tmp_fpa += m;
  else
    *ok = false;
  if (*ok && !TURBO_PC)
    *ok = space_in_p_array(tmp_fpa, 0L);
  if (*ok) {
    while (radim_part != NULL && ok_n) {
      generators = radim_part->generators;
      while (generators != NULL && ok_n) {
	generators->offset = return_offset(generators->vertex_set, &ok_n);
	generators = generators->pointer;
      }
      upper = radim_part->upper;
      lower = radim_part->lower;
      P_setunion(a, upper->vertex_set, lower->vertex_set);
      lower->offset = return_offset(a, &ok_n);
      upper = upper->pointer;
      lower = lower->pointer;
      while (upper != NULL) {
	P_setunion(a, upper->vertex_set, lower->vertex_set);
	lower->offset = return_offset(a, &ok_n);
	upper = upper->pointer;
	lower = lower->pointer;
      }
      radim_part = radim_part->pointer;
    }
  }
  *ok = (*ok && ok_n);
  /*$ifdef TRACE*/
  if (!*ok && (boolean_option[3] || boolean_option[4] || boolean_option[5] ||
	       boolean_option[21])) {
    /*$endif TRACE*/
    write_warning(stdout, " Out of space in TestRadimSpace.", 32L);
  }
}  /* test_of_one_radim_marginals_and_insert_offsets */


Static boolean test_radim_space(radim_list)
t_list_radim_elements **radim_list;
{
  t_list_radim_elements *p_radim;
  boolean ok;

  ok = true;
  p_radim = *radim_list;
  while (p_radim != NULL && ok) {
    test_of_one_radim_marginals_and_insert_offsets(&p_radim->radim_element, &ok);
    p_radim = p_radim->pointer;
  }
  return ok;
}  /* test_radim_space */


Static boolean test_ips_space(model)
t_model *model;
{
  t_long_integer m, mp1, mp2;
  boolean ok;
  t_list_ips_elements *link_ips_list;
  t_ips_set_list *link_gc;
  t_ips_element *WITH;

  ok = true;
  link_ips_list = model->ips_list;
  while (link_ips_list != NULL && ok) {
    WITH = &link_ips_list->ips_element;
    m = marginal_dimension(WITH->a);
    mp1 = m;
    if (ips_in_use == 1)
      mp1 += m;
    if (mean_ips_in_use != normal_ips)
      mp1 += m;
    link_gc = WITH->gen_class;
    while (link_gc != NULL && ok) {
      mp2 = marginal_dimension(link_gc->vertex_set);
      m += mp2;
      if (!TURBO_PC)
	ok = space_in_p_array(mp1 + mp2, 0L);
      ok = (mp1 + mp2 <= max_p_cell_number);
      if (ok && !TURBO_PC)
	ok = space_in_n_array(m, fna);
      ok = (m <= max_cell_number - fna && ok);
      link_gc = link_gc->pointer;
    }
    link_ips_list = link_ips_list->pointer;
  }
  /*$ifdef TRACE*/
  if (!ok && (boolean_option[3] || boolean_option[4] || boolean_option[5] ||
	      boolean_option[21]))
    write_warning(stdout, " Out of space in TestIpsSpace.", 30L);
  /*$endif TRACE*/
  if (ok)
    return (test_radim_space(&model->radim_list));
  else
    return false;
}  /* test_ips_space */


Static Void find_offsets_and_marginals(model, expression_marginals, ok_n, ok_p)
t_model *model;
boolean expression_marginals, *ok_n, *ok_p;
{
  t_set_list *marginal_list;

  *ok_p = true;
  if (datastructure != all) {
    marginal_list = NULL;
    if (expression_marginals)
      insert_expression_marginals_in_list(model->expression, &marginal_list);
    insert_ips_marginals_in_list(model->ips_list, &marginal_list);
    find_list_of_marginals(&marginal_list, ok_n);
    dispose_set_list(&marginal_list);
  } else
    *ok_n = true;
  if (!*ok_n)
    return;
  if (expression_marginals)
    find_expression_marginals_and_insert_offsets(model->expression, ok_n);
  if (*ok_n && model->ips_list != NULL)
    find_ips_marginals_and_insert_offsets(model->ips_list, ok_n, ok_p);
  if (*ok_n && *ok_p && model->radim_list != NULL)
    find_radim_marginals_and_insert_offsets(&model->radim_list,
					    &model->ips_list, ok_n, ok_p);
}  /* find_offsets_and_marginals */


/*@+"dual.p"*/


Static Void find_g_c_intersection_maximal(in_1, in_2, out_g_c)
t_set_list *in_1, **in_2, **out_g_c;
{
  t_set_list *p;
  t_vertex_set vertex_set;

  *out_g_c = NULL;
  while (in_1 != NULL) {
    p = *in_2;
    while (p != NULL) {
      P_setint(vertex_set, in_1->vertex_set, p->vertex_set);
      insert_clique(vertex_set, out_g_c);
      p = p->pointer;
    }
    in_1 = in_1->pointer;
  }
}  /* find_g_c_intersection_maximal */


Static Void find_g_c_union_minimal(in_1, in_2, out_g_c)
t_set_list *in_1, **in_2, **out_g_c;
{
  t_set_list *p;
  t_vertex_set vertex_set;

  *out_g_c = NULL;
  while (in_1 != NULL) {
    p = *in_2;
    while (p != NULL) {
      P_setunion(vertex_set, in_1->vertex_set, p->vertex_set);
      insert_set_minimal(vertex_set, out_g_c);
      p = p->pointer;
    }
    in_1 = in_1->pointer;
  }
}  /* find_g_c_union_minimal */


Static Void normal_to_dual(g_c, g, g_c_dual)
t_set_list *g_c;
long *g;
t_set_list **g_c_dual;
{
  t_g_c_list *g_c_list, *tmp_g_c;
  t_set_list *p;
  t_vertex v;
  t_vertex_set b, c;
  t_vertex FORLIM;

  if (g_c == NULL) {
    write_pch(stdout, " --NormalDualError--", 20L);
    *g_c_dual = NULL;
    FORLIM = last_vertex;
    for (v = first_vertex; v <= FORLIM; v++) {
      if (P_inset(v, g)) {
	P_addset(P_expset(b, 0L), v);
	insert_set_in_set_list(b, g_c_dual);
      }
    }
    return;
  }
  if (g_c->pointer == NULL && P_setequal(g_c->vertex_set, g)) {
    *g_c_dual = (t_set_list *)Malloc(sizeof(t_set_list));
    if (*g_c_dual == NULL)
      _OutMem();
    P_setcpy((*g_c_dual)->vertex_set, empty_set);
    (*g_c_dual)->pointer = NULL;
    return;
  }
  g_c_list = NULL;
  while (g_c != NULL) {
    tmp_g_c = (t_g_c_list *)Malloc(sizeof(t_g_c_list));
    if (tmp_g_c == NULL)
      _OutMem();
    tmp_g_c->g_c = NULL;
    tmp_g_c->pointer = g_c_list;
    g_c_list = tmp_g_c;
    P_setdiff(c, g, g_c->vertex_set);
    FORLIM = last_vertex;
    for (v = first_vertex; v <= FORLIM; v++) {
      if (P_inset(v, c)) {
	P_addset(P_expset(b, 0L), v);
	insert_set_in_set_list(b, &g_c_list->g_c);
      }
    }
    g_c = g_c->pointer;
  }
  while (g_c_list->pointer != NULL) {
    find_g_c_union_minimal(g_c_list->g_c, &g_c_list->pointer->g_c, &p);
    dispose_set_list(&g_c_list->g_c);
    tmp_g_c = g_c_list;
    g_c_list = g_c_list->pointer;
    Free(tmp_g_c);
    dispose_set_list(&g_c_list->g_c);
    g_c_list->g_c = p;
  }
  *g_c_dual = g_c_list->g_c;
  Free(g_c_list);
}  /* normal_to_dual */


Static Void dual_to_normal(g_c_dual, g, g_c)
t_set_list *g_c_dual;
long *g;
t_set_list **g_c;
{
  t_g_c_list *g_c_list, *tmp_g_c;
  t_set_list *p;
  t_vertex v;
  t_vertex_set vertex_set;
  t_vertex FORLIM;

  if (g_c_dual == NULL) {
    write_pch(stdout, " --DualNormalError--", 20L);
    *g_c = (t_set_list *)Malloc(sizeof(t_set_list));
    if (*g_c == NULL)
      _OutMem();
    P_setcpy((*g_c)->vertex_set, g);
    (*g_c)->pointer = NULL;
    return;
  }
  if (g_c_dual->pointer == NULL && P_setequal(g_c_dual->vertex_set, empty_set)) {
    *g_c = (t_set_list *)Malloc(sizeof(t_set_list));
    if (*g_c == NULL)
      _OutMem();
    P_setcpy((*g_c)->vertex_set, g);
    (*g_c)->pointer = NULL;
    return;
  }
  g_c_list = NULL;
  while (g_c_dual != NULL) {
    tmp_g_c = (t_g_c_list *)Malloc(sizeof(t_g_c_list));
    if (tmp_g_c == NULL)
      _OutMem();
    tmp_g_c->g_c = NULL;
    tmp_g_c->pointer = g_c_list;
    g_c_list = tmp_g_c;
    FORLIM = last_vertex;
    for (v = first_vertex; v <= FORLIM; v++) {
      if (P_inset(v, g_c_dual->vertex_set)) {
	P_addset(P_expset(vertex_set, 0L), v);
	P_setdiff(vertex_set, g, vertex_set);
	insert_set_in_set_list(vertex_set, &g_c_list->g_c);
      }
    }
    g_c_dual = g_c_dual->pointer;
  }
  while (g_c_list->pointer != NULL) {
    find_g_c_intersection_maximal(g_c_list->g_c, &g_c_list->pointer->g_c, &p);
    dispose_set_list(&g_c_list->g_c);
    tmp_g_c = g_c_list;
    g_c_list = g_c_list->pointer;
    Free(tmp_g_c);
    dispose_set_list(&g_c_list->g_c);
    g_c_list->g_c = p;
  }
  *g_c = g_c_list->g_c;
  Free(g_c_list);
}  /* dual_to_normal */


/*@-"print.c"*/
/*@+"print.p"*/


Static boolean negative_flag_set(sub_code, n)
long *sub_code, n;
{
  boolean ok;

  ok = false;
  if (*sub_code <= -n) {
    ok = true;
    *sub_code += n;
  }
  return ok;
}  /* negative_flag_set */


Static Void identify_model_full(model, sets_d_g_c, sets_g_g_c,
  fill_in_adj_list, order, invers_order, c, complete)
t_model *model;
t_set_list **sets_d_g_c, **sets_g_g_c;
t_vertex_list **fill_in_adj_list;
short *order;
t_vertex *invers_order;
t_vertex_set *c;
uchar *complete;
{
  t_set_list *sets_h_g_c;
  t_v_arr_of_v_sets fill_in_adj_set, adj_set;
  t_v_arr_of_v_lists adj_list;
  t_vertex v;
  t_adjacency_matrix gc_adjacency_matrix;
  t_vertex FORLIM;

  sets_h_g_c = model->sets_h_g_c;
  model->sets_h_g_c = NULL;
  dispose_model(model);
  model->sets_h_g_c = sets_h_g_c;
  *sets_g_g_c = NULL;
  *sets_d_g_c = NULL;
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    order[v - MIN_VERTEX] = 1;
    fill_in_adj_list[v - MIN_VERTEX] = NULL;
    P_setcpy(c[v - MIN_VERTEX], empty_set);
    P_clrbits_B(complete, v - MIN_VERTEX, 0, 3);
  }
  if (incomplete_table)
    decompose_incomplete_model(&model->sets_h_g_c, model->model_set,
      &model->constant, &model->expression, &model->ips_list,
      &model->radim_list, &model->dim);
  else {
    model->graphical = true;
    model->decomposable = true;
    hypergraph_sets_to_graph_sets(model->sets_h_g_c, model->model_set,
				  adj_set);
    adj_set_to_adj_list(adj_set, adj_list);
    if (!test_graphical(adj_set, &model->sets_h_g_c)) {
      model->graphical = false;
      find_cliques_and_order(adj_set, adj_list, fill_in_adj_list, order,
			     invers_order, c, complete, &model->decomposable,
			     model->model_set, sets_g_g_c);
      if (model->decomposable) {
	fill_in_computation(adj_list, order, invers_order, fill_in_adj_list);
	find_c(adj_set, order, invers_order, fill_in_adj_list, c, complete);
      } else {
	adj_list_to_adj_set(fill_in_adj_list, fill_in_adj_set);
	find_cliques(fill_in_adj_set, model->model_set, sets_d_g_c);
      }
    } else {
      model->graphical = true;
      maximum_cardinality_search(adj_list, order, invers_order);
      if (test_for_zero_fill_in(adj_list, order, invers_order)) {
	model->decomposable = true;
	fill_in_computation(adj_list, order, invers_order, fill_in_adj_list);
	find_c(adj_set, order, invers_order, fill_in_adj_list, c, complete);
      } else {
	model->decomposable = false;
	lex_m(adj_list, order, invers_order, fill_in_adj_list);
	find_c(adj_set, order, invers_order, fill_in_adj_list, c, complete);
	adj_list_to_adj_set(fill_in_adj_list, fill_in_adj_set);
	find_cliques(fill_in_adj_set, model->model_set, sets_d_g_c);
      }
    }
    if (model->decomposable && model->graphical)
      find_perfect_scheme_expression(model->model_set, adj_list, order,
	invers_order, &model->constant, &model->expression, &model->dim);
    else {
      create_adjacency_matrix(&gc_adjacency_matrix, model->sets_h_g_c);
      decompose_non_decomposable(&model->graphical, &gc_adjacency_matrix,
	model->model_set, adj_list, adj_set, invers_order, c, complete,
	&model->constant, &model->expression, &model->ips_list,
	&model->radim_list, &model->dim);
      delete_edges_with_vertices(&gc_adjacency_matrix, model->model_set);
    }
    dispose_adj_list(fill_in_adj_list);
    dispose_adj_list(adj_list);
  }
  model->found_expression = true;
}  /* identify_model_full */


Static Void print_adjacency_matrix_(model)
t_model *model;
{
  t_vertex v, w;
  t_v_arr_of_v_sets adj_set;
  t_vertex FORLIM, FORLIM1;

  hypergraph_sets_to_graph_sets(model->sets_h_g_c, model->model_set, adj_set);
  write_line(stdout);
  write_space(stdout, 2L);
  write_pch(stdout, " Adjacency matrix", 17L);
  write_line(stdout);
  write_line(stdout);
  write_space(stdout, 4L);
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    write_char(stdout, vertex_inf[v - MIN_VERTEX].name);
    write_space(stdout, 1L);
  }
  write_line(stdout);
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    write_space(stdout, 2L);
    write_char(stdout, vertex_inf[v - MIN_VERTEX].name);
    write_space(stdout, 1L);
    FORLIM1 = last_vertex;
    for (w = first_vertex; w <= FORLIM1; w++) {
      if (P_inset(w, adj_set[v - MIN_VERTEX]))
	write_char(stdout, '*');
      else
	write_char(stdout, ' ');
      write_char(stdout, ' ');
    }
    write_space(stdout, 2L);
    print_vertex_set_table(adj_set[v - MIN_VERTEX]);
    write_line(stdout);
  }
  write_line(stdout);
}  /* print_adjacency_matrix */


Static Void sub_print_order(order, c, complete)
short *order;
t_vertex_set *c;
uchar *complete;
{
  t_vertex v, FORLIM;

  write_space(stdout, 2L);
  write_char(stdout, 'V');
  write_pch(stdout, "  ", 2L);
  write_pch(stdout, " Order(V) ", 10L);
  write_space(stdout, 2L);
  write_pch(stdout, "C(V)", 4L);
  write_space(stdout, dimension - 2L);
  write_pch(stdout, "Complete(V)  ", 13L);
  write_line(stdout);
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    write_space(stdout, 2L);
    print_vertex_on_file(stdout, v);
    write_pch(stdout, ": ", 2L);
    write_integer(stdout, (long)order[v - MIN_VERTEX], 10L);
    write_space(stdout, 3L);
    print_vertex_set_table_full(c[v - MIN_VERTEX]);
    write_boolean(stdout, P_getbits_UB(complete, v - MIN_VERTEX, 0, 3));
    write_line(stdout);
  }
}  /* sub_print_order */


Static Void print_order(model, print_invers_order)
t_model *model;
boolean print_invers_order;
{
  t_set_list *sets_g_g_c, *sets_d_g_c;
  t_v_arr_of_order order;
  t_o_arr_of_vertex invers_order;
  t_v_arr_of_v_lists fill_in_adj_list;
  t_v_arr_of_v_sets c;
  t_v_arr_of_boolean complete;

  identify_model_full(model, &sets_d_g_c, &sets_g_g_c, fill_in_adj_list,
		      order, invers_order, c, complete);
  if (print_invers_order)
    sub_print_invers_order(invers_order, c, complete);
  else
    sub_print_order(order, c, complete);
  dispose_set_list(&sets_g_g_c);
  dispose_set_list(&sets_d_g_c);
  dispose_adj_list(fill_in_adj_list);
}  /* print_order */


Static Void describe_edges(link_cliques)
t_set_list *link_cliques;
{
  t_edge_list *edge_list[MAX_DIMENSION];
  t_set_list *p;
  t_long_integer count, i, j;
  t_vertex v, w;
  t_vertex_set vertex_set;
  long FORLIM;
  t_vertex FORLIM1, FORLIM2;

  FORLIM = dimension;
  for (i = 0; i < FORLIM; i++)
    edge_list[i] = NULL;
  FORLIM1 = last_vertex;
  for (v = first_vertex; v < FORLIM1; v++) {
    FORLIM2 = last_vertex;
    for (w = v + 1; w <= FORLIM2; w++) {
      P_addset(P_expset(vertex_set, 0L), v);
      P_addset(vertex_set, w);
      p = link_cliques;
      count = 0;
      while (p != NULL) {
	if (P_subset(vertex_set, p->vertex_set))
	  count++;
	p = p->pointer;
      }
      if (count > 0) {
	if (count > dimension)
	  count = dimension;
	insert_edge_in_edge_list(v, w, &edge_list[count - 1]);
      }
    }
  }
  j = dimension;
  while (edge_list[j - 1] == NULL && j >= 2)
    j--;
  for (i = 1; i <= j; i++) {
    if (edge_list[i - 1] != NULL) {
      write_integer(stdout, i, 10L);
      if (i == dimension)
	write_pch(stdout, ">  ", 3L);
      else
	write_pch(stdout, ":  ", 3L);
      print_edge_list(edge_list[i - 1], 13L, line_length);
      dispose_edge_list(&edge_list[i - 1]);
      write_line(stdout);
    }
  }
}  /* describe_edges */


Static Void describe_expression(link_expression, full)
t_expression *link_expression;
boolean full;
{
  while (link_expression != NULL) {
    if (full) {
      write_integer(stdout, marginal_dimension(link_expression->vertex_set),
		    12L);
      write_pch(stdout, " / ", 3L);
    }
    if (em)
      write_pch(stdout, "   p ( I ", 9L);
    else
      write_pch(stdout, "   N ( I ", 9L);
    print_vertex_set_table(link_expression->vertex_set);
    write_pch(stdout, " ) ^ ", 5L);
    write_integer(stdout, link_expression->factor, 3L);
    write_pch(stdout, " * ", 3L);
    write_line(stdout);
    link_expression = link_expression->pointer;
  }
}  /* describe_expression */


Static Void describe_ips_list(ips_list, full)
t_list_ips_elements *ips_list;
boolean full;
{
  t_ips_set_list *q;
  t_set_list *cliques;
  t_long_integer stop;

  while (ips_list != NULL) {
    if (full) {
      write_integer(stdout, marginal_dimension(ips_list->ips_element.a), 12L);
      if (ips_list->ips_element.radim_part)
	write_pch(stdout, " /    R ", 8L);
      else
	write_pch(stdout, " /    P ", 8L);
    } else if (ips_list->ips_element.radim_part)
      write_pch(stdout, "   R ", 5L);
    else
      write_pch(stdout, "   P ", 5L);
    q = ips_list->ips_element.gen_class;
    cliques = NULL;
    while (q != NULL) {
      insert_set_in_set_list(q->vertex_set, &cliques);
      q = q->pointer;
    }
    if (full)
      print_g_c_stop(cliques, 21L, line_length, &stop);
    else
      print_g_c_stop(cliques, 6L, line_length, &stop);
    if (stop > line_length - cardinality(ips_list->ips_element.a) &&
	line_length < MAX_LINE_LENGTH) {
      write_line(stdout);
      write_space(stdout, 19L);
    }
    dispose_set_list(&cliques);
    write_pch(stdout, " ( I ", 5L);
    print_vertex_set(ips_list->ips_element.a);
    write_pch(stdout, " ) * ", 5L);
    write_line(stdout);
    ips_list = ips_list->pointer;
  }
}  /* describe_ips_list */


Static Void describe_radim_list(radim_list, full)
t_list_radim_elements *radim_list;
boolean full;
{
  t_radim_part *r;
  t_offset_list *s;
  t_ips_set_list *q;
  t_set_list *cliques;
  t_long_integer stop;

  while (radim_list != NULL && report) {
    if (full) {
      write_integer(stdout, marginal_dimension(radim_list->radim_element.a),
		    12L);
      write_pch(stdout, " /    F ", 8L);
    } else
      write_pch(stdout, "   F ", 5L);
    q = radim_list->radim_element.gen_class;
    cliques = NULL;
    while (q != NULL) {
      /*$ifdef TRACE*/
      if (false) {
	print_vertex_set_table(q->vertex_set);
	write_integer(stdout, q->n_offset, 10L);
	write_line(stdout);
	write_space(stdout, 30L);
      }
      /*$endif TRACE*/
      insert_set_in_set_list(q->vertex_set, &cliques);
      q = q->pointer;
    }
    if (full)
      print_g_c_stop(cliques, 21L, line_length, &stop);
    else
      print_g_c_stop(cliques, 6L, line_length, &stop);
    if (stop > line_length - cardinality(radim_list->radim_element.a) &&
	line_length < MAX_LINE_LENGTH) {
      write_line(stdout);
      write_space(stdout, 19L);
    }
    dispose_set_list(&cliques);
    write_pch(stdout, " ( I ", 5L);
    print_vertex_set(radim_list->radim_element.a);
    write_pch(stdout, " ) : ", 5L);
    write_line(stdout);
    if (radim_list->radim_element.radim_parts != NULL) {
      r = radim_list->radim_element.radim_parts;
      while (r != NULL) {
	write_space(stdout, 20L);
	write_pch(stdout, "Generators: ", 12L);
	/*$ifdef TRACE*/
	if (boolean_option[18]) {
	  s = r->generators;
	  while (s != NULL) {
	    print_vertex_set_table(s->vertex_set);
	    write_integer(stdout, s->offset, 20L);
	    write_line(stdout);
	    write_space(stdout, 30L);
	    s = s->pointer;
	  }
	}
	/*$endif TRACE*/
	s = r->generators;
	while (s != NULL) {
	  print_vertex_set(s->vertex_set);
	  s = s->pointer;
	}
	write_line(stdout);
	write_space(stdout, 23L);
	write_pch(stdout, "Upper: ", 7L);
	s = r->upper;
	cliques = NULL;
	while (s != NULL) {
	  /*$ifdef TRACE*/
	  if (boolean_option[18]) {
	    print_vertex_set_table(s->vertex_set);
	    write_integer(stdout, s->offset, 10L);
	    write_line(stdout);
	    write_space(stdout, 30L);
	  }
	  /*$endif TRACE*/
	  insert_set_in_set_list(s->vertex_set, &cliques);
	  s = s->pointer;
	}
	print_g_c_stop(cliques, 30L, line_length, &stop);
	dispose_set_list(&cliques);
	write_line(stdout);
	write_space(stdout, 23L);
	write_pch(stdout, "Lower: ", 7L);
	s = r->lower;
	cliques = NULL;
	while (s != NULL) {
	  /*$ifdef TRACE*/
	  if (boolean_option[18]) {
	    print_vertex_set_table(s->vertex_set);
	    write_integer(stdout, s->offset, 20L);
	    write_line(stdout);
	    write_space(stdout, 30L);
	  }
	  /*$endif TRACE*/
	  insert_set_in_set_list(s->vertex_set, &cliques);
	  s = s->pointer;
	}
	print_g_c_stop(cliques, 30L, line_length, &stop);
	dispose_set_list(&cliques);
	write_line(stdout);
	write_space(stdout, 23L);
	write_pch(stdout, "From:  ", 7L);
	s = r->from;
	cliques = NULL;
	while (s != NULL) {
	  /*$ifdef TRACE*/
	  if (boolean_option[18]) {
	    print_vertex_set_table(s->vertex_set);
	    write_integer(stdout, s->offset, 10L);
	    write_line(stdout);
	    write_space(stdout, 30L);
	  }
	  /*$endif TRACE*/
	  insert_set_in_set_list(s->vertex_set, &cliques);
	  s = s->pointer;
	}
	print_g_c_stop(cliques, 30L, line_length, &stop);
	dispose_set_list(&cliques);
	write_line(stdout);
	r = r->pointer;
      }
    }
    radim_list = radim_list->pointer;
    if (radim_list != NULL)
      write_line(stdout);
  }
}  /* describe_radim_list */


Static Void describe_radim_list_short(radim_list, full)
t_list_radim_elements *radim_list;
boolean full;
{
  t_ips_set_list *q;
  t_set_list *cliques;
  t_long_integer stop;

  while (radim_list != NULL) {
    if (full) {
      write_integer(stdout, marginal_dimension(radim_list->radim_element.a),
		    12L);
      write_pch(stdout, " /    F ", 8L);
    } else
      write_pch(stdout, "   F ", 5L);
    q = radim_list->radim_element.gen_class;
    cliques = NULL;
    while (q != NULL) {
      insert_set_in_set_list(q->vertex_set, &cliques);
      q = q->pointer;
    }
    if (full)
      print_g_c_stop(cliques, 21L, line_length, &stop);
    else
      print_g_c_stop(cliques, 6L, line_length, &stop);
    if (stop > line_length - cardinality(radim_list->radim_element.a) &&
	line_length < MAX_LINE_LENGTH) {
      write_line(stdout);
      write_space(stdout, 19L);
    }
    dispose_set_list(&cliques);
    write_pch(stdout, " ( I ", 5L);
    print_vertex_set(radim_list->radim_element.a);
    write_pch(stdout, " ) * ", 5L);
    write_line(stdout);
    radim_list = radim_list->pointer;
  }
}  /* describe_radim_list_short */


Static Void write_model(model, as_is)
t_model *model;
boolean as_is;
{
  t_vertex v;
  t_set_list *sets_g_g_c, *sets_d_g_c;
  t_v_arr_of_order order;
  t_o_arr_of_vertex invers_order;
  t_v_arr_of_v_lists fill_in_adj_list;
  t_v_arr_of_v_sets c;
  t_v_arr_of_boolean complete;
  t_expression *link_expression;
  t_list_ips_elements *link_ips_list;
  t_list_radim_elements *link_radim_list;
  boolean found_exp;
  t_vertex FORLIM;

  sets_g_g_c = NULL;
  sets_d_g_c = NULL;
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    order[v - MIN_VERTEX] = 1;
    fill_in_adj_list[v - MIN_VERTEX] = NULL;
    P_setcpy(c[v - MIN_VERTEX], empty_set);
    P_clrbits_B(complete, v - MIN_VERTEX, 0, 3);
  }
  write_line_diary();
  if (!(model->found_expression &&
	(model->graphical && model->decomposable || incomplete_table)) &&
      !as_is) {
    found_exp = model->found_expression;
    if (found_exp) {
      link_expression = model->expression;
      model->expression = NULL;
      link_ips_list = model->ips_list;
      model->ips_list = NULL;
      link_radim_list = model->radim_list;
      model->radim_list = NULL;
    }
    identify_model_full(model, &sets_d_g_c, &sets_g_g_c, fill_in_adj_list,
			order, invers_order, c, complete);
    if (found_exp) {
      dispose_expression(&model->expression);
      model->expression = link_expression;
      dispose_ips_list_blind(&model->ips_list);
      model->ips_list = link_ips_list;
      dispose_radim_list_blind(&model->radim_list);
      model->radim_list = link_radim_list;
    }
    if (model->decomposable)
      dispose_adj_list(fill_in_adj_list);
  }
  write_integer(stdout, model->model_number, 4L);
  write_pch(stdout, ": ", 2L);
  print_g_c(model->sets_h_g_c, 7L, line_length);
  write_line(stdout);
  if (incomplete_table) {
    write_pch(stdout, " Table is incomplete", 20L);
    write_line(stdout);
  } else {
    if (model->graphical) {
      write_pch(stdout, " Model is graphical", 19L);
      write_line(stdout);
    } else {
      write_pch(stdout, " Model is not graphical", 23L);
      write_line(stdout);
      write_pch(stdout, " Cliques:", 9L);
      print_g_c(sets_g_g_c, 10L, line_length);
      dispose_set_list(&sets_g_g_c);
      write_line(stdout);
      write_pch(stdout, " 2-Section", 10L);
    }
    if (model->decomposable) {
      write_pch(stdout, " Graph is decomposable ", 23L);
      write_line(stdout);
    } else {
      write_pch(stdout, " Graph is not decomposable", 26L);
      dispose_adj_list(fill_in_adj_list);
      write_line(stdout);
      write_pch(stdout, " Generating class for Fill In:", 30L);
      write_char(stdout, ' ');
      print_g_c(sets_d_g_c, 19L, line_length);
      dispose_set_list(&sets_d_g_c);
      write_line(stdout);
    }
  }
  /*$ifdef TRACE*/
  if (!boolean_option[6])
    return;
  if ((model->found_expression &&
       (model->graphical && model->decomposable || incomplete_table)) ||
      as_is)
    return;
  /*$endif TRACE*/
  write_line(stdout);
  sub_print_invers_order(invers_order, c, complete);
  write_line(stdout);
}  /* write_model */


Static Void describe_model(model, print_model, as_is)
t_model *model;
boolean print_model, as_is;
{
  t_set_list *alt_rep;

  if (print_model) {
    write_pch(stdout, " Model no. ", 11L);
    write_integer(stdout, model->model_number, 3L);
    write_char(stdout, ' ');
    print_g_c(model->sets_h_g_c, 16L, line_length);
    write_line(stdout);
    return;
  }
  write_model(model, as_is);
  normal_to_dual(model->sets_h_g_c, model->model_set, &alt_rep);
  write_pch(stdout, " Dual rep:     ", 15L);
  print_g_c(alt_rep, 16L, line_length);
  write_line(stdout);
  dispose_set_list(&alt_rep);
  print_adjacency_matrix_(model);
  write_pch(stdout, "  #Cliques", 10L);
  write_pch(stdout, "   Edges  ", 10L);
  write_line(stdout);
  describe_edges(model->sets_h_g_c);
  write_line(stdout);
  write_pch(stdout, "      #Cells", 12L);
  write_pch(stdout, "      Expression    ", 20L);
  write_line(stdout);
  describe_expression(model->expression, true);
  describe_ips_list(model->ips_list, true);
  if (!model->found_ps)
    describe_radim_list_short(model->radim_list, true);
  write_space(stdout, 15L);
  write_space(stdout, 2L);
  write_real(stdout, model->constant, 12L, 9L);
  write_line(stdout);
  write_line(stdout);
  describe_radim_list(model->radim_list, true);
  write_line(stdout);
  write_line(stdout);
  write_pch(stdout, " Log(L):          ", 18L);
  write_real(stdout, model->log_l, print_width, print_dec);
  write_line(stdout);
  write_pch(stdout, " Dimension:   ", 14L);
  write_integer(stdout, model->dim, 14L);
  write_line(stdout);
  write_line(stdout);
}  /* describe_model */


Static Void return_expression_sets_in_pch(p, upper_sets, lower_sets, full, s,
					  j, stop)
t_expression *p;
boolean *upper_sets, *lower_sets, *full;
Char *s;
long *j, *stop;
{
  while (p != NULL) {
    if (*lower_sets && p->factor <= 0 || *upper_sets && p->factor > 0) {
      if (*j > *stop && !long_names)
	*j += cardinality(p->vertex_set) + 2;
      else
	return_vertex_set_in_pch(p->vertex_set, full, s, j, stop);
    }
    p = p->pointer;
  }
  insert_chr_in_pch('/', s, j, stop);
}  /* return_expression_sets_in_pch */


Static Void return_expression_factors_in_int(p, upper_sets, lower_sets,
					     arg_int, j, stop)
t_expression *p;
boolean *upper_sets, *lower_sets;
long **arg_int;
long *j, *stop;
{
  while (p != NULL) {
    if (*lower_sets && p->factor <= 0 || *upper_sets && p->factor > 0) {
      if (*j < *stop - 1)
	(*arg_int)[*j] = p->factor;
      (*j)++;
    }
    p = p->pointer;
  }
}  /* return_expression_factors_in_int */


Static Void return_ips_set_list_in_pch(p, full, s, j, stop)
t_ips_set_list *p;
boolean *full;
Char *s;
long *j, *stop;
{
  insert_chr_in_pch(',', s, j, stop);
  while (p != NULL) {
    if (*j > *stop && !long_names)
      *j += cardinality(p->vertex_set) + 2;
    else
      return_vertex_set_in_pch(p->vertex_set, full, s, j, stop);
    p = p->pointer;
  }
}  /* return_ips_set_list_in_pch */


Static Void return_radim_list_in_pch(p, generators, full, s, j, stop)
t_list_radim_elements *p;
boolean generators, *full;
Char *s;
long *j, *stop;
{
  while (p != NULL) {
    insert_chr_in_pch('{', s, j, stop);
    if (*j > *stop && !long_names)
      *j += cardinality(p->radim_element.a) + 2;
    else
      return_vertex_set_in_pch(p->radim_element.a, full, s, j, stop);
    if (generators)
      return_ips_set_list_in_pch(p->radim_element.gen_class, full, s, j, stop);
    insert_chr_in_pch('}', s, j, stop);
    p = p->pointer;
  }
  insert_chr_in_pch('/', s, j, stop);
}  /* return_radim_list_in_pch */


Static Void return_ips_list_in_pch(p, generators, full, s, j, stop)
t_list_ips_elements *p;
boolean generators, *full;
Char *s;
long *j, *stop;
{
  while (p != NULL) {
    insert_chr_in_pch('{', s, j, stop);
    if (*j > *stop && !long_names)
      *j += cardinality(p->ips_element.a) + 2;
    else
      return_vertex_set_in_pch(p->ips_element.a, full, s, j, stop);
    if (generators)
      return_ips_set_list_in_pch(p->ips_element.gen_class, full, s, j, stop);
    insert_chr_in_pch('}', s, j, stop);
    p = p->pointer;
  }
  insert_chr_in_pch('/', s, j, stop);
}  /* return_ips_list_in_pch */


Static Void proc_get_expression(command_file, as_argument, ifail, sub_code,
  arg_pos_char, arg_pos_int, arg_pos_double, nargs, arg_char, arg_int,
  arg_double)
FILE *command_file;
boolean as_argument;
long *ifail, *sub_code, arg_pos_char, arg_pos_int, arg_pos_double;
long **nargs;
Char **arg_char;
long **arg_int;
double **arg_double;
{
  t_model_list *q;
  t_long_integer i;
  boolean components, upper_sets, lower_sets, generators, full;
  t_vertex v;
  t_set_list *sets_g_g_c, *sets_d_g_c;
  t_v_arr_of_order order;
  t_o_arr_of_vertex invers_order;
  t_v_arr_of_v_lists fill_in_adj_list;
  t_v_arr_of_v_sets c;
  t_v_arr_of_boolean complete;
  t_expression *link_expression;
  t_list_ips_elements *link_ips_list;
  t_list_radim_elements *link_radim_list;
  boolean found_exp;
  t_vertex FORLIM;

  full = false;
  upper_sets = !negative_flag_set(sub_code, 32L);
  lower_sets = !negative_flag_set(sub_code, 16L);
  generators = !negative_flag_set(sub_code, 8L);
  components = !negative_flag_set(sub_code, 4L);
  q = NULL;
  sub_code_to_model(ifail, sub_code, &q);
  if (q == NULL) {
    set_ifail(ifail, 20L);
    return;
  }
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    order[v - MIN_VERTEX] = 1;
    fill_in_adj_list[v - MIN_VERTEX] = NULL;
    P_setcpy(c[v - MIN_VERTEX], empty_set);
    P_clrbits_B(complete, v - MIN_VERTEX, 0, 3);
  }
  sets_g_g_c = NULL;
  sets_d_g_c = NULL;
  if (components) {
    found_exp = q->model.found_expression;
    if (found_exp) {
      link_expression = q->model.expression;
      q->model.expression = NULL;
      link_ips_list = q->model.ips_list;
      q->model.ips_list = NULL;
      link_radim_list = q->model.radim_list;
      q->model.radim_list = NULL;
    }
    identify_model_full(&q->model, &sets_d_g_c, &sets_g_g_c, fill_in_adj_list,
			order, invers_order, c, complete);
  }
  if (ok_double_arg(ifail, arg_pos_double, 1L, nargs, arg_double)) {
    if (is_invalid_real(q->model.constant))
      (*arg_double)[0] = my_var_na_double;
    else
      (*arg_double)[0] = q->model.constant;
  }
  i = 0;
  return_expression_factors_in_int(q->model.expression, &upper_sets,
    &lower_sets, arg_int, &i, &(*nargs)[arg_pos_int]);
  set_long_end(&i, ifail, arg_pos_int, nargs, arg_int);
  i = PCH_START;
  return_expression_sets_in_pch(q->model.expression, &upper_sets, &lower_sets,
				&full, *arg_char, &i,
				&(*nargs)[arg_pos_char]);
  if (upper_sets) {
    return_radim_list_in_pch(q->model.radim_list, generators, &full,
			     *arg_char, &i, &(*nargs)[arg_pos_char]);
    return_ips_list_in_pch(q->model.ips_list, generators, &full, *arg_char,
			   &i, &(*nargs)[arg_pos_char]);
  }
  set_string_end(&i, ifail, arg_pos_char, nargs, arg_char);
  if (components) {
    if (found_exp) {
      dispose_expression(&q->model.expression);
      q->model.expression = link_expression;
      dispose_ips_list_blind(&q->model.ips_list);
      q->model.ips_list = link_ips_list;
      dispose_radim_list_blind(&q->model.radim_list);
      q->model.radim_list = link_radim_list;
    }
  }
  if (incomplete_table)
    return;
  dispose_adj_list(fill_in_adj_list);
  if (!q->model.graphical)
    dispose_set_list(&sets_g_g_c);
  if (!q->model.decomposable)
    dispose_set_list(&sets_d_g_c);
}  /* proc_get_expression */


Static Void return_invers_order_in_int(invers_order, c, complete, arg_int, j,
				       stop)
t_vertex *invers_order;
t_vertex_set *c;
uchar *complete;
long **arg_int;
long *j, *stop;
{
  t_long_integer i;
  t_vertex v;
  long FORLIM;

  /*$ifdef TRACE*/
  if (boolean_option[27]) {
    write_char(stdout, '2');
    sub_print_invers_order(invers_order, c, complete);
  }
  FORLIM = dimension;
  /*$endif TRACE*/
  for (i = 0; i < FORLIM; i++) {
    v = invers_order[i];
    if (*j < *stop - 2) {
      if (v == MAX_VERTEX) {
	(*arg_int)[*j] = -1;
	(*arg_int)[*j + 1] = -1;
      } else {
	(*arg_int)[*j] = v;
	if (P_getbits_UB(complete, v - MIN_VERTEX, 0, 3))
	  (*arg_int)[*j + 1] = 1;
	else
	  (*arg_int)[*j + 1] = 0;
      }
    }
    *j += 2;
  }

  /* c[v] ? */
}  /* return_invers_order_in_int */


Static Void return_order_in_int(order, c, complete, arg_int, j, stop)
short *order;
t_vertex_set *c;
uchar *complete;
long **arg_int;
long *j, *stop;
{
  t_vertex v, FORLIM;

  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    if (*j < *stop - 2) {
      (*arg_int)[*j] = order[v - MIN_VERTEX];
      if (P_getbits_UB(complete, v - MIN_VERTEX, 0, 3))
	(*arg_int)[*j + 1] = 1;
      else {
	(*arg_int)[*j + 1] = 0;
	/* c[v] ? */
      }
    }
    *j += 2;
  }
}  /* return_order_in_int */


Static Void compute_order(s, sets_h_g_c, max_card, default_order, order,
			  invers_order, c, complete)
long *s;
t_set_list **sets_h_g_c;
boolean *max_card, *default_order;
short *order;
t_vertex *invers_order;
t_vertex_set *c;
uchar *complete;
{
  t_v_arr_of_v_sets adj_set;
  t_v_arr_of_v_lists fill_in_adj_list, adj_list;
  t_vertex v;
  boolean graphical, decomposable;
  t_vertex_set g;
  t_vertex FORLIM;

  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    order[v - MIN_VERTEX] = 1;
    fill_in_adj_list[v - MIN_VERTEX] = NULL;
    P_setcpy(c[v - MIN_VERTEX], empty_set);
    P_clrbits_B(complete, v - MIN_VERTEX, 0, 3);
  }
  hypergraph_sets_to_graph_sets(*sets_h_g_c, g, adj_set);
  adj_set_to_adj_list(adj_set, adj_list);
  graphical = test_graphical(adj_set, sets_h_g_c);
  maximum_cardinality_search(adj_list, order, invers_order);
  decomposable = test_for_zero_fill_in(adj_list, order, invers_order);
  if (*default_order && P_setequal(s, empty_set))
    *max_card = decomposable;
  if (*max_card)
    fill_in_computation(adj_list, order, invers_order, fill_in_adj_list);
  else
    marked_lex_m(s, adj_list, order, invers_order, fill_in_adj_list);
  find_c(adj_set, order, invers_order, fill_in_adj_list, c, complete);
  dispose_adj_list(fill_in_adj_list);
  dispose_adj_list(adj_list);
}  /* compute_order */


/* Local variables for find_the_path: */
struct LOC_find_the_path {
  long *s;
  t_vertex *b;
  t_vertex_list **adj_list;
  t_vertex *invers_order;
  boolean *sub_path, done;
  t_vertex_set r;
} ;

Local Void find_path_set(v, i, path, LINK)
t_vertex v;
long i;
long *path;
struct LOC_find_the_path *LINK;
{
  t_vertex_set new_path, vertex_set;
  t_vertex_list *p;

  /*$ifdef TRACE*/
  if (boolean_option[27]) {
    write_integer(stdout, i, 2L);
    write_char(stdout, ':');
    write_space(stdout, i);
    write_char(stdout, '<');
    print_vertex(v);
    write_char(stdout, '|');
    print_vertex_set(LINK->r);
    write_char(stdout, ',');
    print_vertex_set(path);
    write_char(stdout, '>');
    write_line(stdout);
  }
  /*$endif TRACE*/
  LINK->invers_order[i - 1] = v;
  if (v == *LINK->b) {
    if (P_setequal(path, LINK->s) || *LINK->sub_path)
      LINK->done = true;
    return;
  }
  p = LINK->adj_list[v - MIN_VERTEX];
  P_addset(P_expset(vertex_set, 0L), v);
  P_setunion(new_path, path, vertex_set);
  while (p != NULL && !LINK->done) {
    if (P_inset(p->vertex, LINK->r) & (!P_inset(p->vertex, path)))
      find_path_set(p->vertex, i + 1, new_path, LINK);
    p = p->pointer;
  }
}  /* find_path_set */


Static Void find_the_path(s_, a, b_, adj_list_, invers_order_, sub_path_)
long *s_;
t_vertex *a, *b_;
t_vertex_list **adj_list_;
t_vertex *invers_order_;
boolean *sub_path_;
{
  struct LOC_find_the_path Local_Var;
  t_vertex_list *p;
  long i, FORLIM;

  Local_Var.s = s_;
  Local_Var.b = b_;
  Local_Var.adj_list = adj_list_;
  Local_Var.invers_order = invers_order_;
  Local_Var.sub_path = sub_path_;
  P_addset(P_expset(Local_Var.r, 0L), *Local_Var.b);
  P_setunion(Local_Var.r, Local_Var.s, Local_Var.r);
  /*$ifdef TRACE*/
  if (boolean_option[27]) {
    write_char(stdout, '<');
    print_vertex(*a);
    write_char(stdout, ',');
    print_vertex(*Local_Var.b);
    write_char(stdout, '|');
    print_vertex_set(Local_Var.s);
    write_char(stdout, '/');
    print_vertex_set(Local_Var.r);
    write_char(stdout, '>');
    write_line(stdout);
  }
  /*$endif TRACE*/
  Local_Var.done = false;
  FORLIM = dimension;
  for (i = 0; i < FORLIM; i++)
    Local_Var.invers_order[i] = MAX_VERTEX;   /* min_vertex */
  Local_Var.invers_order[0] = *a;
  p = Local_Var.adj_list[*a - MIN_VERTEX];
  while (p != NULL && !Local_Var.done) {
    if (P_inset(p->vertex, Local_Var.r))
      find_path_set(p->vertex, 2L, empty_set, &Local_Var);
    p = p->pointer;
  }
  if (!Local_Var.done) {
    FORLIM = dimension;
    for (i = 0; i < FORLIM; i++)
      Local_Var.invers_order[i] = 10101;   /* min_vertex */
  }
}  /* find_the_path */


Static Void return_path_order(s, v, w, g_c, invers_order, sub_path)
long *s;
t_vertex *v, *w;
t_set_list **g_c;
t_vertex *invers_order;
boolean *sub_path;
{
  t_v_arr_of_v_sets adj_set;
  t_v_arr_of_v_lists adj_list;
  t_vertex_set g;

  hypergraph_sets_to_graph_sets(*g_c, g, adj_set);
  /*$ifdef TRACE*/
  if (boolean_option[27]) {
    write_char(stdout, '<');
    print_vertex(*v);
    write_char(stdout, ',');
    print_vertex(*w);
    write_char(stdout, '|');
    print_vertex_set(s);
    write_char(stdout, '/');
    print_vertex_set(g);
    write_char(stdout, ':');
    print_g_c(*g_c, 0L, line_length);
    write_char(stdout, '>');
    write_line(stdout);
  }
  /*$endif TRACE*/
  adj_set_to_adj_list(adj_set, adj_list);
  find_the_path(s, v, w, adj_list, invers_order, sub_path);
}  /* return_path_order */


/* Local variables for return_order: */
struct LOC_return_order {
  boolean max_card, default_order, sub_path;
} ;


Static Void return_order(s, v, w, g_c, max_card_, default_order_, path_order,
			 sub_path_, return_invers_order, arg_int, j, stop)
long *s;
t_vertex *v, *w;
t_set_list **g_c;
boolean max_card_, default_order_, path_order, sub_path_, return_invers_order;
long **arg_int;
long *j, *stop;
{
  struct LOC_return_order Local_Var;
  t_vertex u;
  t_v_arr_of_order order;
  t_o_arr_of_vertex invers_order;
  t_v_arr_of_v_sets c;
  t_v_arr_of_boolean complete;
  t_vertex FORLIM;

  Local_Var.max_card = max_card_;
  Local_Var.default_order = default_order_;
  Local_Var.sub_path = sub_path_;
  FORLIM = last_vertex;
  for (u = first_vertex; u <= FORLIM; u++) {
    order[u - MIN_VERTEX] = 1;
    P_setcpy(c[u - MIN_VERTEX], empty_set);
    P_clrbits_B(complete, u - MIN_VERTEX, 0, 3);
  }
  if (path_order)
    return_path_order(s, v, w, g_c, invers_order, &Local_Var.sub_path);
  else
    compute_order(s, g_c, &Local_Var.max_card, &Local_Var.default_order,
		  order, invers_order, c, complete);
  /*$ifdef TRACE*/
  if (boolean_option[27]) {
    write_char(stdout, '1');
    sub_print_invers_order(invers_order, c, complete);
  }
  /*$endif TRACE*/
  if (return_invers_order || path_order)
    return_invers_order_in_int(invers_order, c, complete, arg_int, j, stop);
  else
    return_order_in_int(order, c, complete, arg_int, j, stop);
}  /* return_order */


Static Void proc_return_order(command_file, as_argument, ifail, sub_code,
			      arg_pos_char, arg_pos_int, arg_pos_double,
			      nargs, arg_char, arg_int, arg_double)
FILE *command_file;
boolean as_argument;
long *ifail, *sub_code, arg_pos_char, arg_pos_int, arg_pos_double;
long **nargs;
Char **arg_char;
long **arg_int;
double **arg_double;
{
  t_model_list *q;
  t_long_integer i;
  boolean path_order, max_card, default_order, invers_order;
  t_vertex_set s;

  path_order = negative_flag_set(sub_code, 32L);
  max_card = negative_flag_set(sub_code, 16L);
  default_order = negative_flag_set(sub_code, 8L);
  invers_order = negative_flag_set(sub_code, 4L);
  path_order = false;
  q = NULL;
  sub_code_to_model(ifail, sub_code, &q);
  if (*ifail != 0)
    return;
  i = PCH_START;
  if (!get_vertex_set(command_file, true, true, false, as_argument, &i, ifail,
		      sub_code, arg_pos_char, nargs, arg_char, " SET->",
		      6L, s, s))
    return;
  i = 0;
  if (q != NULL)
    return_order(s, &first_vertex, &last_vertex, &q->model.sets_h_g_c,
		 max_card, default_order, path_order, false, invers_order,
		 arg_int, &i, &(*nargs)[arg_pos_int]);
  set_long_end(&i, ifail, arg_pos_int, nargs, arg_int);
}  /* proc_return_order */


Static Void proc_return_path_order(command_file, as_argument, ifail, sub_code,
  arg_pos_char, arg_pos_int, nargs, arg_char, arg_int)
FILE *command_file;
boolean as_argument;
long *ifail, *sub_code, arg_pos_char, arg_pos_int;
long **nargs;
Char **arg_char;
long **arg_int;
{
  t_vertex_set b;
  t_vertex v, w;
  t_set_list *gc;
  boolean sub_path, invers_order, ok;
  t_model_list *q;
  long i;

  q = NULL;
  ok = negative_flag_set(sub_code, 32L);
  sub_path = negative_flag_set(sub_code, 16L);
  ok = negative_flag_set(sub_code, 8L);
  invers_order = negative_flag_set(sub_code, 4L);
  sub_code_to_model(ifail, sub_code, &q);
  get_two_vertices_and_set_list(command_file, as_argument, false, ifail,
				sub_code, arg_pos_char, nargs, arg_char, &v,
				&w, &gc);
  if (*ifail != 0)
    return;
  P_setcpy(b, empty_set);
  if (gc != NULL) {
    add_union_of_gc(gc, b);
    dispose_set_list(&gc);
  }
  /*$ifdef TRACE*/
  if (boolean_option[27]) {
    write_char(stdout, '<');
    print_vertex(v);
    write_char(stdout, ',');
    print_vertex(w);
    write_char(stdout, '|');
    print_vertex_set(b);
    write_char(stdout, ':');
    print_g_c(gc, 0L, line_length);
    write_char(stdout, '/');
    print_g_c(q->model.sets_h_g_c, 0L, line_length);
    if (*ifail != 0)
      write_integer(stdout, *ifail, 2L);
    write_char(stdout, '>');
    write_line(stdout);
  }
  /*$endif TRACE*/
  i = 0;
  return_order(b, &v, &w, &q->model.sets_h_g_c, false, false, true, sub_path,
	       invers_order, arg_int, &i, &(*nargs)[arg_pos_int]);
  set_long_end(&i, ifail, arg_pos_int, nargs, arg_int);
}  /* proc_return_path_order */


/*@-"model.c"*/
/*@+"table.p"*/


Static Void next_marginal_cell_list(p, i)
t_vertex_list *p;
t_level *i;
{
  if (p == NULL)
    return;
  while (i[p->vertex - MIN_VERTEX] ==
	 FIRST_LEVEL + vertex_inf[p->vertex - MIN_VERTEX].levels - 1 &&
	 p->pointer != NULL) {
    i[p->vertex - MIN_VERTEX] = FIRST_LEVEL;
    p = p->pointer;
  }
  if (p->pointer == NULL &&
      i[p->vertex - MIN_VERTEX] ==
      FIRST_LEVEL + vertex_inf[p->vertex - MIN_VERTEX].levels - 1)
    i[p->vertex - MIN_VERTEX] = FIRST_LEVEL;
  else
    i[p->vertex - MIN_VERTEX]++;
}  /* next_marginal_cell_list */


Static Void print_table(a, p, table_type, log_trans, percent, permuted,
			a_set_offset, n_total, model_set_offset, model)
long *a;
t_vertex_list *p;
long *table_type;
boolean log_trans, percent, permuted;
t_offset *a_set_offset;
double n_total;
t_offset *model_set_offset;
t_model *model;
{
  t_vertex v;
  t_vertex_set b;
  t_cell_index l[MAX_DIMENSION + 1];
  t_vertex_name vn[MAX_DIMENSION + 1];
  t_long_integer a1, a2, ww, i, ii, j, k, card;
  t_cell cell;
  t_long_real x;
  t_vertex_list *q;
  long FORLIM1;

  /*$ifdef TRACE*/
  if (boolean_option[28]) {
    write_integer(stdout, *a_set_offset, width);
    write_integer(stdout, *model_set_offset, width);
    write_line(stdout);
  }
  /*$endif TRACE*/
  card = cardinality(a);
  l[0] = 1;
  ww = labs(width);
  v = first_vertex;
  a1 = 0;
  a2 = 0;
  if (permuted) {
    P_setcpy(b, empty_set);
    q = NULL;
    while (p != NULL) {
      if (!P_inset(p->vertex, b)) {
	P_addset(b, p->vertex);
	insert_vertex_in_vertex_list(p->vertex, &q);
      }
      p = p->pointer;
    }
    revers_vertex_list(&q);
    p = q;
    while (q != NULL && a1 + a2 != card) {
      if (a1 < (card + 1) / 2 &&
	  (ww + 1) * vertex_inf[q->vertex - MIN_VERTEX].levels <
	  line_length - (card - a1) * 3) {
	a1++;
	ww = (ww + 1) * vertex_inf[q->vertex - MIN_VERTEX].levels;
      } else
	a2++;
      l[a1 + a2] = l[a1 + a2 - 1] * vertex_inf[q->vertex - MIN_VERTEX].levels;
      vn[a1 + a2] = vertex_inf[q->vertex - MIN_VERTEX].name;
      q = q->pointer;
    }
  } else {
    while (v <= last_vertex && a1 + a2 != card) {
      if (P_inset(v, a)) {
	if (a1 < (card + 1) / 2 &&
	    (ww + 1) * vertex_inf[v - MIN_VERTEX].levels <
	    line_length - (card - a1) * 3) {
	  a1++;
	  ww = (ww + 1) * vertex_inf[v - MIN_VERTEX].levels;
	} else
	  a2++;
	l[a1 + a2] = l[a1 + a2 - 1] * vertex_inf[v - MIN_VERTEX].levels;
	vn[a1 + a2] = vertex_inf[v - MIN_VERTEX].name;
      }
      if (v != last_vertex)
	v++;
    }
  }
  l[a1 + a2 + 1] = l[a1 + a2] * 2;
  page(stdout);
  write_line(stdout);
  write_space(stdout, 5L);
  if (permuted)
    print_vertex_list(p);
  else
    print_vertex_set(a);
  write_line(stdout);
  write_line(stdout);
  if (card != 0) {
    for (j = a1; j >= 1; j--) {
      for (k = 1; k <= a2; k++)
	write_space(stdout, 3L);
      write_char(stdout, ' ');
      write_char(stdout, vn[j]);
      write_char(stdout, ' ');
      FORLIM1 = l[a1];
      for (i = 1; i <= FORLIM1; i++) {
	if (i % l[j - 1] == 0)
	  write_integer(stdout, (i - l[j - 1]) % l[j] / l[j - 1] + 1, width);
	else
	  write_space(stdout, width);
	for (k = 1; k <= a1; k++) {
	  if (i % l[k] == 0)
	    write_char(stdout, ' ');
	}
      }
      write_line(stdout);
    }
  }
  for (j = a2; j >= 1; j--) {
    write_space(stdout, 2L);
    write_char(stdout, vn[a1 + j]);
  }
  write_line(stdout);
  write_line(stdout);
  memcpy(cell, first_cell, sizeof(t_cell));
  FORLIM1 = marginal_dimension(a);
  for (i = 1; i <= FORLIM1; i++) {
    if ((i - 1) % l[a1] == 0) {
      for (j = a2; j >= 1; j--) {
	if ((i - 1) % l[a1 + j - 1] == 0)
	  write_integer(stdout, (i - 1) % l[a1 + j] / l[a1 + j - 1] + 1, 3L);
	else
	  write_space(stdout, 3L);
      }
      write_space(stdout, 3L);
    }
    if (permuted)
      ii = marginal_hash(a, cell);
    else
      ii = i - 1;
    x = return_table_value(a, *table_type, a_set_offset, &n_total, ii, cell,
			   model_set_offset, model);
    if (permuted)
      next_marginal_cell_list(p, cell);
    else if (*table_type != 0)
      next_marginal_cell(a, cell);
    if (is_infinity_real(x) || x <= 0 && log_trans) {
      write_space(stdout, labs(width) - 1);
      write_char(stdout, '-');
    } else {
      if (log_trans)
	x = log_10(x);
      if (percent) {
	if (n[ii + *a_set_offset] == 0)
	  write_integer(stdout, 0L, width);
	else
	  write_real(stdout, x, width, decexpt);
      } else if (((*table_type) & (MAX_NUMBER_OF_TABLE_VALUES - 1)) < 3) {
	switch ((*table_type) & (MAX_NUMBER_OF_TABLE_VALUES - 1)) {

	case 0:
	  if (log_trans || em)
	    write_real(stdout, x, width, decdiff);
	  else
	    write_integer(stdout, (long)floor(x + 0.5), width);
	  break;

	case 1:
	  write_real(stdout, x, width, decprob);
	  break;

	case 2:
	  write_real(stdout, x, width, decexpt);
	  break;
	}
      } else if (*table_type == MAX_NUMBER_OF_TABLE_VALUES * 2 - 1 && !em)
	write_integer(stdout, (long)floor(x + 0.5), width);
      else
	write_real(stdout, x, width, decdiff);
    }
    for (j = 1; j <= a1; j++) {
      if (i % l[j] == 0)
	write_char(stdout, ' ');
    }
    if (i != marginal_dimension(a)) {
      for (j = 0; j < a2; j++) {
	if (i % l[a1 + j] == 0)
	  write_line(stdout);
      }
    }
  }
  write_line(stdout);
  write_line(stdout);
  if (permuted)
    dispose_vertex_list(&p);
}  /* print_table */


/*@+"plot.p"*/


Static Void return_vector(a, p_a, table_type, log_trans, permuted,
			  a_set_offset, n_total, model_set_offset, model,
			  arg_double)
long *a;
t_vertex_list **p_a;
long *table_type;
boolean *log_trans, *permuted;
t_offset *a_set_offset;
double n_total;
t_offset *model_set_offset;
t_model *model;
double **arg_double;
{
  t_long_integer i, ii;
  t_cell cell;
  t_long_real x;
  long FORLIM;

  memcpy(cell, first_cell, sizeof(t_cell));
  FORLIM = last_index(a);
  for (i = FIRST_INDEX; i <= FORLIM; i++) {
    if (*permuted)
      ii = marginal_hash(a, cell);
    else
      ii = i;
    x = return_table_value(a, *table_type, a_set_offset, &n_total, ii, cell,
			   model_set_offset, model);
    if (*permuted)
      next_marginal_cell_list(*p_a, cell);
    else if (*table_type != 0)
      next_marginal_cell(a, cell);
    if (is_infinity_real(x) || x <= 0 && *log_trans)
      (*arg_double)[i - FIRST_INDEX] = my_var_na_float;
    else {
      if (*log_trans)
	x = log_10(x);
      (*arg_double)[i - FIRST_INDEX] = x;
    }
  }
}  /* return_vector */


Static Void print_vector(a, p_a, table_type, log_trans, permuted,
			 a_set_offset, n_total, model_set_offset, model)
long *a;
t_vertex_list **p_a;
long *table_type;
boolean *log_trans, *permuted;
t_offset *a_set_offset;
double n_total;
t_offset *model_set_offset;
t_model *model;
{
  t_long_integer i, ii, m;
  t_cell cell;
  t_long_real x;

  if (!dump)
    write_line(stdout);
  memcpy(cell, first_cell, sizeof(t_cell));
  m = last_index(a);
  for (i = FIRST_INDEX; i <= m; i++) {
    if (*permuted)
      ii = marginal_hash(a, cell);
    else
      ii = i;
    x = return_table_value(a, *table_type, a_set_offset, &n_total, ii, cell,
			   model_set_offset, model);
    if (*permuted)
      next_marginal_cell_list(*p_a, cell);
    else if (*table_type != 0)
      next_marginal_cell(a, cell);
    if (*log_trans) {
      if (is_infinity_real(x) || x <= 0)
	x = INFINITY_REAL;
      else
	x = log_10(x);
    }
    if (dump) {
      if (is_infinity_real(x)) {
	write_space_text(dump_file, labs(width) - 1);
	write_char_text(dump_file, '-');
      } else
	write_real_text(dump_file, &x, labs(width), decdiff);
      if (i == m)
	write_char_text(dump_file, ';');
      else
	write_char_text(dump_file, ',');
    } else if (is_infinity_real(x))
      write_real(stdout, INFINITY_REAL, width, decdiff);
    else
      write_real(stdout, x, width, decdiff);
    if ((i - FIRST_INDEX) % (line_length / labs(width)) == 0) {   /* fpa */
      if (dump)
	write_line_text(dump_file);
      else
	write_line(stdout);
    }
  }
  if (dump)
    write_line_text(dump_file);
  else
    write_line(stdout);
}  /* print_vector */


Static Void print_list(a, p_a, permuted, a_set_offset, n_total,
		       model_set_offset, model)
long *a;
t_vertex_list **p_a;
boolean *permuted;
t_offset *a_set_offset;
double n_total;
t_offset *model_set_offset;
t_model *model;
{
  t_long_integer i, ii, j;
  t_cell cell;
  t_long_real x;
  t_vertex v, FORLIM;

  page(stdout);
  write_line(stdout);
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    if (P_inset(v, a)) {
      if (vertex_inf[v - MIN_VERTEX].levels > 9)
	write_char(stdout, ' ');
      write_char(stdout, ' ');
      print_vertex_on_file(stdout, v);
    }
  }
  write_space(stdout, labs(width) - 9);
  write_pch(stdout, " Observed", 9L);
  write_space(stdout, 1L);
  write_space(stdout, labs(width) - 9);
  write_pch(stdout, " Probabi.", 9L);
  write_space(stdout, labs(width) - 8);
  write_pch(stdout, " Residual", 9L);
  write_space(stdout, labs(width) - 6);
  write_pch(stdout, "  F-res", 7L);
  write_space(stdout, labs(width) - 6);
  write_pch(stdout, "  Res-F", 7L);
  write_space(stdout, labs(width) - 6);
  write_pch(stdout, "  G-res", 7L);
  write_space(stdout, labs(width) - 6);
  write_pch(stdout, "  Res-G", 7L);
  write_line(stdout);
  write_line(stdout);
  memcpy(cell, first_cell, sizeof(t_cell));
  i = FIRST_INDEX;
  while (i <= last_index(a) && !interrupt_1) {
    if (*permuted)
      ii = marginal_hash(a, cell);
    else
      ii = i;
    FORLIM = last_vertex;
    for (v = first_vertex; v <= FORLIM; v++) {
      if (P_inset(v, a)) {
	if (vertex_inf[v - MIN_VERTEX].levels > 9)
	  write_integer(stdout, cell[v - MIN_VERTEX] - FIRST_LEVEL + 1L, 3L);
	else
	  write_integer(stdout, cell[v - MIN_VERTEX] - FIRST_LEVEL + 1L, 2L);
      }
    }
    if (em)
      write_real(stdout, p[i + *a_set_offset], width, decexpt);
    else
      write_integer(stdout, n[i + *a_set_offset], width);
    if (incomplete_table) {
      if (marginal_zero_cell(a, cell, q_tables_offsets))
	write_char(stdout, '*');
      else
	write_char(stdout, ' ');
    } else
      write_char(stdout, ' ');
    if (em)
      write_real(stdout, compute_m_p_em(a, cell, model), width, decprob);
    else
      write_real(stdout, compute_m_p(a, cell, model), width, decprob);
    for (j = 3; j <= 7; j++) {
      write_char(stdout, ' ');
      x = return_table_value(a, j, a_set_offset, &n_total, ii, cell,
			     model_set_offset, model);
      if (is_infinity_real(x)) {
	write_space(stdout, labs(width) - 1);
	write_char(stdout, '-');
      } else
	write_real(stdout, x, width, print_dec);
    }
    write_line(stdout);
    if (*permuted)
      next_marginal_cell_list(*p_a, cell);
    else
      next_marginal_cell(a, cell);
    i++;
  }
  write_line(stdout);
  write_line(stdout);
  write_line(stdout);
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    if (P_inset(v, a)) {
      if (vertex_inf[v - MIN_VERTEX].levels > 9)
	write_char(stdout, ' ');
      write_char(stdout, ' ');
      print_vertex_on_file(stdout, v);
    }
  }
  write_space(stdout, labs(width) - 9);
  write_pch(stdout, " Expected", 9L);
  write_space(stdout, labs(width) - 8);
  write_pch(stdout, " Adjusted", 9L);
  write_space(stdout, labs(width) - 8);
  write_pch(stdout, " Standard", 9L);
  write_space(stdout, labs(width) - 8);
  write_pch(stdout, " -2Log(q)", 9L);
  write_space(stdout, labs(width) - 7);
  write_pch(stdout, " Freeman", 8L);
  write_space(stdout, labs(width) - 8);
  write_pch(stdout, " 2(/n-/m)", 9L);
  write_space(stdout, labs(width) - 8);
  write_pch(stdout, "    Power", 9L);
  write_line(stdout);
  write_line(stdout);
  memcpy(cell, first_cell, sizeof(t_cell));
  i = FIRST_INDEX;
  while (i <= last_index(a) && !interrupt_1) {
    if (*permuted)
      ii = marginal_hash(a, cell);
    else
      ii = i;
    FORLIM = last_vertex;
    for (v = first_vertex; v <= FORLIM; v++) {
      if (P_inset(v, a)) {
	if (vertex_inf[v - MIN_VERTEX].levels > 9)
	  write_integer(stdout, cell[v - MIN_VERTEX] - FIRST_LEVEL + 1L, 3L);
	else
	  write_integer(stdout, cell[v - MIN_VERTEX] - FIRST_LEVEL + 1L, 2L);
      }
    }
    if (em)
      write_real(stdout, n_total * compute_m_p_em(a, cell, model), width,
		 decexpt);
    else
      write_real(stdout, n_total * compute_m_p(a, cell, model), width,
		 decexpt);
    for (j = 8; j <= 13; j++) {
      write_char(stdout, ' ');
      x = return_table_value(a, j, a_set_offset, &n_total, ii, cell,
			     model_set_offset, model);
      if (is_infinity_real(x)) {
	write_space(stdout, labs(width) - 1);
	write_char(stdout, '-');
      } else
	write_real(stdout, x, width, print_dec);
    }
    write_line(stdout);
    if (*permuted)
      next_marginal_cell_list(*p_a, cell);
    else
      next_marginal_cell(a, cell);
    i++;
  }
  write_line(stdout);
  write_line(stdout);
}  /* print_list */


Static Void plot(a, x_type, y_type, log_x, log_y, x_set_offset, y_set_offset,
		 n_total, x_model_set_offset, x_model, y_model_set_offset,
		 y_model)
long *a;
long *x_type, *y_type;
boolean *log_x, *log_y;
t_offset *x_set_offset, *y_set_offset;
double n_total;
t_offset *x_model_set_offset;
t_model *x_model;
t_offset *y_model_set_offset;
t_model *y_model;
{
  t_long_integer x_length, y_length, count_invalid, i, j, x_i, y_i;
  t_cell cell;
  char plot[129][65];
  t_long_real x_start, x_stop, y_start, y_stop, x, y, x_delta, y_delta, x_min,
	      x_max, y_min, y_max;
  long FORLIM;

  count_invalid = 0;
  memcpy(cell, first_cell, sizeof(t_cell));
  x_min = LONG_MAX;
  x_max = -x_min;
  y_min = LONG_MAX;
  y_max = -y_min;
  FORLIM = last_index(a);
  for (i = FIRST_INDEX; i <= FORLIM; i++) {
    x = return_table_value(a, *x_type, x_set_offset, &n_total, i, cell,
			   x_model_set_offset, x_model);
    y = return_table_value(a, *y_type, y_set_offset, &n_total, i, cell,
			   y_model_set_offset, y_model);
    if ((is_infinity_real(x) | is_infinity_real(y)) || x <= 0 && *log_x ||
	y <= 0 && *log_y)
      count_invalid++;
    else {
      if (*log_x)
	x = log_10(x);
      if (*log_y)
	y = log_10(y);
      if (x < x_min)
	x_min = x;
      if (x > x_max)
	x_max = x;
      if (y < y_min)
	y_min = y;
      if (y > y_max)
	y_max = y;
    }
    next_marginal_cell(a, cell);
  }
  if (x_min != x_max && y_min != y_max) {
    x_length = line_length - labs(print_width) - 4;
    y_length = page_length - 12;
    if (x_length >= 128)
      x_length = 128;
    if (y_length >= 64)
      y_length = 64;
    scale(x_min, x_max, x_length, &x_start, &x_stop, &x_delta, &x_length);
    scale(y_min, y_max, y_length, &y_start, &y_stop, &y_delta, &y_length);
    for (i = 0; i <= y_length; i++) {
      for (j = 0; j <= x_length; j++)
	plot[j][i] = 0;
    }
    memcpy(cell, first_cell, sizeof(t_cell));
    FORLIM = last_index(a);
    for (i = FIRST_INDEX; i <= FORLIM; i++) {
      x = return_table_value(a, *x_type, x_set_offset, &n_total, i, cell,
			     x_model_set_offset, x_model);
      y = return_table_value(a, *y_type, y_set_offset, &n_total, i, cell,
			     y_model_set_offset, y_model);
      if (!(((is_infinity_real(x) || x <= 0 && *log_x) | is_infinity_real(y)) ||
	    y <= 0 && *log_y)) {
	if (*log_x)
	  x = log_10(x);
	if (*log_y)
	  y = log_10(y);
	x_i = (long)floor((x - x_start) / x_delta + 0.5);
	y_i = (long)floor((y - y_start) / y_delta + 0.5);
	if (plot[x_i][y_i] < 127)
	  plot[x_i][y_i]++;
      }
      next_marginal_cell(a, cell);
    }
    page(stdout);
    write_line(stdout);
    write_pch(stdout, "  PLOT OF:  ", 12L);
    print_table_type(*y_type, *log_y);
    write_pch(stdout, " BY ", 4L);
    print_table_type(*x_type, *log_x);
    write_line(stdout);
    write_pch(stdout, "  PLOT", 6L);
    write_line(stdout);
    write_line(stdout);
    write_pch(stdout, " Unit horizontal:", 17L);
    write_pch(stdout, " - = ", 5L);
    write_real(stdout, x_delta, print_width, print_dec);
    write_line(stdout);
    write_pch(stdout, " Unit vertical:  ", 17L);
    write_pch(stdout, " ! = ", 5L);
    write_real(stdout, y_delta, print_width, print_dec);
    write_line(stdout);
    write_line(stdout);
    write_line(stdout);
    print_table_type(*y_type, *log_y);
    write_line(stdout);
    write_space(stdout, labs(print_width) + 2);
    write_char(stdout, '!');
    for (j = 0; j <= x_length; j++)
      write_char(stdout, '-');
    write_char(stdout, '!');
    write_line(stdout);
    for (i = y_length; i >= 0; i--) {
      write_space(stdout, 1L);
      write_real(stdout, delta_round(y_start + i * y_delta, i * y_delta),
		 print_width, print_dec);
      write_space(stdout, 1L);
      write_char(stdout, '!');
      for (j = 0; j <= x_length; j++) {
	if (plot[j][i] == 0)
	  write_char(stdout, ' ');
	else if (plot[j][i] == 1)
	  write_char(stdout, '*');
	else if (plot[j][i] < 10)
	  write_char(stdout, plot[j][i] - 1 + '1');
	else if (plot[j][i] < 35)
	  write_char(stdout, plot[j][i] - 10 + 'a');
	else if (plot[j][i] < 60)
	  write_char(stdout, plot[j][i] - 35 + 'A');
	else
	  write_char(stdout, '^');
      }
      write_char(stdout, '!');
      write_line(stdout);
    }
    write_space(stdout, labs(print_width) + 2);
    write_char(stdout, '!');
    for (j = 0; j <= x_length; j++) {
      if (j % labs(print_width) == 0)
	write_char(stdout, '+');
      else
	write_char(stdout, '-');
    }
    write_char(stdout, '!');
    write_line(stdout);
    write_space(stdout, print_dec + 4);
    FORLIM = (x_length + 1) / labs(print_width);
    for (j = 0; j <= FORLIM; j++) {
      if (char_count + labs(print_width) <= line_length)
	write_real(stdout,
		   delta_round(x_start + j * labs(print_width) * x_delta,
			       j * labs(print_width) * x_delta), print_width,
		   print_dec);
    }
    write_line(stdout);
    write_space(stdout, x_length);
    print_table_type(*x_type, *log_x);
    write_line(stdout);
    write_line(stdout);
    write_space(stdout, labs(print_width) + 2);
    write_pch(stdout, " EXCLUDED:", 10L);
    write_integer(stdout, count_invalid, print_width);
    write_line(stdout);
    write_line(stdout);
    return;
  }
  write_line(stdout);
  write_line(stdout);
  write_pch(stdout, " One value constant ", 20L);
  write_line(stdout);
  write_line(stdout);
}  /* plot */


Local long findpivot_(i, j)
long *i, *j;
{
  long Result;
  t_long_real firstkey;
  t_long_integer k;

  firstkey = p[*i];
  Result = -1;
  k = *i;
  while (k <= *j) {
    if (firstkey < p[k]) {
      Result = k;
      k = *j;
    } else if (p[k] < firstkey) {
      Result = *i;
      k = *j;
    }
    k++;
  }
  return Result;
}  /* findpivot */

Local Void swap_(x, y)
float *x, *y;
{
  t_real z;

  z = *x;
  *x = *y;
  *y = z;
}  /* swap */

Local long partition_(l, r, pivot)
long l, r;
double *pivot;
{
  do {
    swap_(&p[l], &p[r]);
    while (p[l] < *pivot)
      l++;
    while (p[r] >= *pivot)
      r--;
  } while (l <= r);
  return l;
}  /* partition */

Local Void quicksort_(i, j)
long i, j;
{
  t_long_real pivot;
  t_long_integer pivotindex, k;

  pivotindex = findpivot_(&i, &j);
  if (pivotindex == -1)
    return;
  pivot = p[pivotindex];
  k = partition_(i, j, &pivot);
  quicksort_(i, k - 1);
  quicksort_(k, j);
}  /* quicksort */


/*@+"describe.p"*/


Static Void sort_p_array(min, max)
long min, max;
{
  quicksort_(min, max);
}  /* sort_p_array */


/* Local variables for describe_table: */
struct LOC_describe_table {
  long *table_type;
  boolean *log_trans;
  FILE *x_file;
  boolean on_file;
} ;

/* Local variables for merge_: */
struct LOC_merge_ {
  long *k;
  FILE *f1, *f2;
  t_long_integer used[2];
  boolean finf[2];
  t_long_real current[2];
} ;

Local Void getrecord_(i, LINK)
long i;
struct LOC_merge_ *LINK;
{
  if ((LINK->used[i - 1] == *LINK->k) | ((i == 1) & eof_real_file(LINK->f1)) |
      ((i == 2) & eof_real_file(LINK->f2)))
    LINK->finf[i - 1] = true;
  else if (i == 1)
    read_real_file(LINK->f1, &LINK->current[i - 1]);
  else
    read_real_file(LINK->f2, &LINK->current[1]);
  LINK->used[i - 1]++;
}  /* getrecord */

Local Void merge_(k_, f1_, f2_, g1, g2)
long *k_;
FILE *f1_, *f2_, *g1, *g2;
{
  struct LOC_merge_ Local_Var;
  boolean outswitch;
  t_long_integer winner;

  Local_Var.k = k_;
  Local_Var.f1 = f1_;
  Local_Var.f2 = f2_;
  outswitch = true;
  rewrite_real_file(g1);
  rewrite_real_file(g2);
  reset_real_file(Local_Var.f1);
  reset_real_file(Local_Var.f2);
  while ((!eof_real_file(Local_Var.f1)) | (!eof_real_file(Local_Var.f2))) {
    Local_Var.used[0] = 0;
    Local_Var.used[1] = 0;
    Local_Var.finf[0] = false;
    Local_Var.finf[1] = false;
    getrecord_(1L, &Local_Var);
    getrecord_(2L, &Local_Var);
    while (!Local_Var.finf[0] || !Local_Var.finf[1]) {
      if (Local_Var.finf[0])
	winner = 2;
      else if (Local_Var.finf[1])
	winner = 1;
      else if (Local_Var.current[0] < Local_Var.current[1])
	winner = 1;
      else
	winner = 2;
      if (outswitch)
	write_real_file(g1, Local_Var.current[winner - 1]);
      else
	write_real_file(g2, Local_Var.current[winner - 1]);
      getrecord_(winner, &Local_Var);
    }
    outswitch = !outswitch;
  }
}  /* merge */

Local Void init_(k, count, f, g1, g2)
long k, count;
FILE *f, *g1, *g2;
{
  boolean outswitch;
  t_long_real x;
  t_long_integer i, j, min_index;
  long FORLIM;

  rewrite_real_file(g1);
  rewrite_real_file(g2);
  reset_real_file(f);
  if (k == 1) {
    FORLIM = count - count / 2;
    for (i = 1; i <= FORLIM; i++) {
      read_real_file(f, &x);
      write_real_file(g1, x);
    }
    for (i = 1; i <= count / 2; i++) {
      read_real_file(f, &x);
      write_real_file(g2, x);
    }
    return;
  }
  min_index = fpa - 1;
  outswitch = true;
  while (!eof_real_file(f)) {
    i = 0;
    while (!eof_real_file(f) && i < k) {
      i++;
      read_real_file(f, &x);
      p[min_index + i] = x;
    }
    sort_p_array(min_index + 1, min_index + i);
    if (outswitch) {
      for (j = min_index + 1; j <= min_index + i; j++) {
	x = p[j];
	write_real_file(g1, x);
      }
    } else {
      for (j = min_index + 1; j <= min_index + i; j++) {
	x = p[j];
	write_real_file(g2, x);
      }
    }
    outswitch = !outswitch;
  }
}  /* init */

Local Void sort_x_file(x_file, a, b, LINK)
FILE *x_file;
long *a, *b;
struct LOC_describe_table *LINK;
{
  pch_long file_name_f1, file_name_f2, file_name_g1, file_name_g2;
  FILE *f1, *f2, *g1, *g2;
  t_long_integer k;
  t_long_real x;
  boolean out_f;

  g2 = NULL;
  g1 = NULL;
  f2 = NULL;
  f1 = NULL;
  default_to_file_name(DEFAULT_TMP, file_name_f1);
  assign_real_file_write(&f1, file_name_f1, &tmp_count);
  default_to_file_name(DEFAULT_TMP, file_name_f2);
  assign_real_file_write(&f2, file_name_f2, &tmp_count);
  default_to_file_name(DEFAULT_TMP, file_name_g1);
  assign_real_file_write(&g1, file_name_g1, &tmp_count);
  default_to_file_name(DEFAULT_TMP, file_name_g2);
  assign_real_file_write(&g2, file_name_g2, &tmp_count);
  tmp_count -= 4;
  if (8 < max_p_cell_number - fpa)
    k = max_p_cell_number - fpa;
  else
    k = 1;
  out_f = true;
  init_(k, *b - *a + 1, x_file, f1, f2);
  while (k <= *b - *a) {
    out_f = !out_f;
    if (out_f) {
      reassign_real_file_write(&f1, file_name_f1);
      reassign_real_file_write(&f2, file_name_f2);
      merge_(&k, g1, g2, f1, f2);
    } else {
      reassign_real_file_write(&g1, file_name_g1);
      reassign_real_file_write(&g2, file_name_g2);
      merge_(&k, f1, f2, g1, g2);
    }
    k *= 2;
  }
  rewrite_real_file(x_file);
  if (out_f) {
    reset_real_file(f1);
    while (!eof_real_file(f1)) {
      read_real_file(f1, &x);
      write_real_file(x_file, x);
    }
  } else {
    reset_real_file(g1);
    while (!eof_real_file(g1)) {
      read_real_file(g1, &x);
      write_real_file(x_file, x);
    }
  }
  unlink_real_file(&f1, file_name_f1);
  unlink_real_file(&f2, file_name_f2);
  unlink_real_file(&g1, file_name_g1);
  unlink_real_file(&g2, file_name_g2);
  if (f1 != NULL)
    fclose(f1);
  if (f2 != NULL)
    fclose(f2);
  if (g1 != NULL)
    fclose(g1);
  if (g2 != NULL)
    fclose(g2);
}  /* sort_x_file */

Local Void plot_uniform(a, b, y_type, min, max, x_mean, x_variance, LINK)
long *a, *b, y_type;
double *min, *max, *x_mean, *x_variance;
struct LOC_describe_table *LINK;
{
  char plot[129][65];
  t_long_integer count, x_length, y_length, i, j, x_i, y_i;
  t_long_real y_min, y_start, y_stop, y_delta, x, x_start, x_stop, delta;
  long FORLIM;

  count = *b - *a + 1;
  x_length = line_length - labs(print_width) - 4;
  y_length = page_length - 12;
  if (x_length >= 128)
    x_length = 128;
  if (y_length >= 64)
    y_length = 64;
  scale(*min, *max, x_length, &x_start, &x_stop, &delta, &x_length);
  if (y_type != 1) {
    if (y_type == 3)
      y_min = normal_percent_point_approx(0.5 / count);
    else
      y_min = normal_percent_point_approx(2.0 / (count * 3 + 1));
    if ((y_length & 1) != 0)
      y_length--;
    scale(0.0, -2 * y_min, y_length, &y_start, &y_stop, &y_delta, &y_length);
    if ((y_length & 1) != 0) {
      y_length++;
      y_start = y_length / -2.0 * y_delta;
      y_stop = y_length / 2.0 * y_delta;
    } else {
      y_start = -0.5 * y_stop;
      y_stop = 0.5 * y_stop;
    }
  }
  for (i = 0; i <= y_length; i++) {
    for (j = 0; j <= x_length; j++)
      plot[j][i] = 0;
  }
  if (LINK->on_file) {
    reset_real_file(LINK->x_file);
    FORLIM = *b;
    for (i = *a; i <= FORLIM; i++) {
      read_real_file(LINK->x_file, &x);
      x_i = (long)floor((x - x_start) / delta + 0.5);
      switch (y_type) {

      case 1:
	y_i = (long)floor(y_length * (i - *a + 1.0) / count + 0.5);
	break;

      case 2:
	y_i = (long)floor(
		y_length / (y_stop - y_start) * (normal_percent_point_approx(
		    ((i - *a + 1.0) * 3 - 1) / (count * 3 + 1)) - y_start) + 0.5);
	break;

      case 3:
	y_i = (long)floor(
		y_length / (y_stop - y_start) * (normal_percent_point_approx(
		    (i - *a + 0.5) / (*b - *a + 1)) - y_start) + 0.5);
	break;
      }
      if (plot[x_i][y_i] < 127)
	plot[x_i][y_i]++;
    }
  } else {
    FORLIM = *b;
    for (i = *a; i <= FORLIM; i++) {
      x_i = (long)floor((p[i] - x_start) / delta + 0.5);
      switch (y_type) {

      case 1:
	y_i = (long)floor(y_length * (i - *a + 1.0) / count + 0.5);
	break;

      case 2:
	y_i = (long)floor(
		y_length / (y_stop - y_start) * (normal_percent_point_approx(
		    ((i - *a + 1.0) * 3 - 1) / (count * 3 + 1)) - y_start) + 0.5);
	break;

      case 3:
	y_i = (long)floor(
		y_length / (y_stop - y_start) * (normal_percent_point_approx(
		    (i - *a + 0.5) / (*b - *a + 1)) - y_start) + 0.5);
	break;
      }
      if (plot[x_i][y_i] < 127)
	plot[x_i][y_i]++;
    }
  }
  page(stdout);
  write_line(stdout);
  switch (y_type) {

  case 1:
    write_pch(stdout, " Uniform plot", 13L);
    break;

  case 2:
    write_pch(stdout, " Rankit plot", 12L);
    break;

  case 3:
    write_pch(stdout, " Probit plot", 12L);
    break;
  }
  write_line(stdout);
  write_line(stdout);
  write_pch(stdout, " Unit horizontal:", 17L);
  write_pch(stdout, " - = ", 5L);
  write_real(stdout, delta, print_width, print_dec);
  write_line(stdout);
  if (y_type > 1) {
    write_pch(stdout, " Unit vertical:  ", 17L);
    write_pch(stdout, " ! = ", 5L);
    write_real(stdout, y_delta, print_width, print_dec);
    write_line(stdout);
  }
  write_line(stdout);
  write_line(stdout);
  write_line(stdout);
  write_space(stdout, labs(print_width));
  write_char(stdout, '!');
  for (j = 0; j <= x_length; j++)
    write_char(stdout, '-');
  write_char(stdout, '!');
  write_line(stdout);
  for (i = y_length; i >= 0; i--) {
    write_space(stdout, 1L);
    if (y_type == 1)
      write_real(stdout, (double)i / y_length, print_width - 2,
		 print_width - 5);
    else
      write_real(stdout, delta_round(i * y_delta + y_start, i * y_delta),
		 labs(print_width) - 2, labs(print_width) - 5);
    write_space(stdout, 1L);
    write_char(stdout, '!');
    for (j = 0; j <= x_length; j++) {
      if (plot[j][i] == 0) {
	if (y_type != 1) {
	  if ((long)floor(((x_start + j * delta - *x_mean) / sqrt(*x_variance) -
			   y_start) / y_delta + 0.5) == i)
	    write_char(stdout, '+');
	  else
	    write_char(stdout, ' ');
	} else if ((long)floor((x_start - *min + j * delta) / (*max - *min) *
			       y_length + 0.5) == i)
	  write_char(stdout, '+');
	else
	  write_char(stdout, ' ');
      } else if (plot[j][i] == 1)
	write_char(stdout, '*');
      else if (plot[j][i] < 10)
	write_char(stdout, plot[j][i] - 1 + '1');
      else if (plot[j][i] < 35)
	write_char(stdout, plot[j][i] - 10 + 'a');
      else if (plot[j][i] < 60)
	write_char(stdout, plot[j][i] - 35 + 'A');
      else
	write_char(stdout, '^');
    }
    write_char(stdout, '!');
    write_line(stdout);
  }
  write_space(stdout, labs(print_width));
  write_char(stdout, '!');
  for (j = 0; j <= x_length; j++) {
    if (j % labs(print_width) == 0)
      write_char(stdout, '+');
    else
      write_char(stdout, '-');
  }
  write_char(stdout, '!');
  write_line(stdout);
  write_space(stdout, print_dec + 2);
  FORLIM = (x_length + 1) / labs(print_width);
  for (j = 0; j <= FORLIM; j++) {
    if (char_count + labs(print_width) <= line_length)
      write_real(stdout, delta_round(x_start + j * labs(print_width) * delta,
				     j * labs(print_width) * delta),
		 print_width, print_dec);
  }
  write_line(stdout);
  write_space(stdout, x_length + 3);
  print_table_type(*LINK->table_type, *LINK->log_trans);
  write_line(stdout);
  write_line(stdout);
}  /* plot_uniform */

Local Void plot_histogram(a, b, min, max, LINK)
long *a, *b;
double *min, *max;
struct LOC_describe_table *LINK;
{
  t_integer cell[101];
  t_long_integer cell_factor, max_cell, count, x_length, i, j, x_i;
  t_long_real x, x_start, x_stop, delta;
  long FORLIM, FORLIM1;

  count = *b - *a + 1;
  x_length = (long)floor(2 * sqrt((double)count) + 0.5);
  if (x_length > page_length - 12)
    x_length = page_length - 12;
  scale(*min, *max, x_length, &x_start, &x_stop, &delta, &x_length);
  for (i = 0; i <= x_length; i++)
    cell[i] = 0;
  if (LINK->on_file) {
    reset_real_file(LINK->x_file);
    FORLIM = *b;
    for (i = *a; i <= FORLIM; i++) {
      read_real_file(LINK->x_file, &x);
      x_i = (long)floor((x - x_start) / delta + 0.5);
      cell[x_i]++;
    }
  } else {
    FORLIM = *b;
    for (i = *a; i <= FORLIM; i++) {
      x_i = (long)floor((p[i] - x_start) / delta + 0.5);
      cell[x_i]++;
    }
  }
  while (cell[x_length] == 0)
    x_length--;
  max_cell = 0;
  for (i = 0; i <= x_length; i++) {
    if (cell[i] > max_cell)
      max_cell = cell[i];
  }
  page(stdout);
  write_line(stdout);
  write_pch(stdout, " Histogram", 10L);
  write_line(stdout);
  write_line(stdout);
  cell_factor = max_cell / (line_length - 20) + 1;
  write_pch(stdout, " Unit horizontal: ", 18L);
  write_pch(stdout, "* = ", 4L);
  write_integer(stdout, cell_factor, print_width);
  write_line(stdout);
  write_pch(stdout, " Unit vertical:   ", 18L);
  write_pch(stdout, "! = ", 4L);
  write_real(stdout, delta, print_width, print_dec);
  write_line(stdout);
  write_line(stdout);
  for (i = 0; i <= x_length; i++) {
    write_real(stdout, delta_round(x_start + i * delta, i * delta),
	       print_width, print_dec);
    write_pch(stdout, " ->  !  ", 8L);
    FORLIM1 = ceil_x((double)cell[i] / cell_factor);
    for (j = 1; j <= FORLIM1; j++)
      write_char(stdout, '*');
    write_line(stdout);
  }
  write_real(stdout, x_start + (x_length + 1) * delta, print_width, print_dec);
  write_line(stdout);
  write_line(stdout);
}  /* plot_histogram */

/* Local variables for describe_observations: */
struct LOC_describe_observations {
  struct LOC_describe_table *LINK;
} ;

Local double return_x(i, max, j, x_j, LINK)
long i, max, *j;
double *x_j;
struct LOC_describe_observations *LINK;
{
  if (LINK->LINK->on_file) {
    if (i == *j)
      return (*x_j);
    else if (i == *j + 1) {
      (*j)++;
      if (eof_real_file(LINK->LINK->x_file))
	*x_j = _INVALID;
      else
	read_real_file(LINK->LINK->x_file, x_j);
      return (*x_j);
    } else
      _Escape(0);
  } else if (i <= max)
    return (p[i]);
  else if (i == max + 1)
    return _INVALID;
  else
    _Escape(0);
}  /* return_x */

Local Void describe_observations(a, b, LINK)
long *a, *b;
struct LOC_describe_table *LINK;
{
  struct LOC_describe_observations Local_Var;
  t_long_integer i, j, count, j_i, k, i1, i2;
  t_long_real x_k;

  Local_Var.LINK = LINK;
  page(stdout);
  write_line(stdout);
  write_pch(stdout, " Counts", 7L);
  write_line(stdout);
  write_line(stdout);
  write_line(stdout);
  write_pch(stdout, " ! ", 3L);
  write_pch(stdout, "Cell      ", 10L);
  write_pch(stdout, " ! ", 3L);
  write_pch(stdout, "Number of ", 10L);
  write_pch(stdout, " ! ", 3L);
  write_pch(stdout, "Cumm.     ", 10L);
  write_pch(stdout, " ! ", 3L);
  write_pch(stdout, "% of total", 10L);
  write_pch(stdout, " ! ", 3L);
  write_pch(stdout, "Cumm. %   ", 10L);
  write_pch(stdout, " ! ", 3L);
  write_line(stdout);
  write_pch(stdout, " ! ", 3L);
  write_pch(stdout, "count     ", 10L);
  write_pch(stdout, " ! ", 3L);
  write_pch(stdout, "cells with", 10L);
  write_pch(stdout, " ! ", 3L);
  write_pch(stdout, "number of ", 10L);
  write_pch(stdout, " ! ", 3L);
  write_pch(stdout, "number of ", 10L);
  write_pch(stdout, " ! ", 3L);
  write_pch(stdout, "          ", 10L);
  write_pch(stdout, " ! ", 3L);
  write_line(stdout);
  write_pch(stdout, " ! ", 3L);
  write_pch(stdout, "          ", 10L);
  write_pch(stdout, " ! ", 3L);
  write_pch(stdout, "count     ", 10L);
  write_pch(stdout, " ! ", 3L);
  write_pch(stdout, "cells     ", 10L);
  write_pch(stdout, " ! ", 3L);
  write_pch(stdout, "cells     ", 10L);
  write_pch(stdout, " ! ", 3L);
  write_pch(stdout, "          ", 10L);
  write_pch(stdout, " ! ", 3L);
  write_line(stdout);
  write_pch(stdout, " !", 2L);
  for (i1 = 1; i1 <= 5; i1++)
    write_pch(stdout, "------------!", 13L);
  write_line(stdout);
  count = *b - *a + 1;
  i = 0;
  j = *a;
  k = j;
  if (LINK->on_file) {
    reset_real_file(LINK->x_file);
    read_real_file(LINK->x_file, &x_k);
  }
  while ((i <= 10 || (double)(j - *a) / count <= 0.40 || *b - 10 <= j ||
	  0.90 <= (double)(j - *a) / count) && j <= *b) {
    j_i = j;
    while ((long)floor(return_x(j, *b, &k, &x_k, &Local_Var) + 0.5) == i &&
	   j <= *b)
      j++;
    if (j - j_i != 0) {
      write_pch(stdout, " ! ", 3L);
      write_integer(stdout, i, 10L);
      write_pch(stdout, " ! ", 3L);
      write_integer(stdout, j - j_i, 10L);
      write_pch(stdout, " ! ", 3L);
      write_integer(stdout, j - *a, 10L);
      write_pch(stdout, " ! ", 3L);
      write_real(stdout, (double)(j - j_i) / count, 10L, print_dec);
      write_pch(stdout, " ! ", 3L);
      write_real(stdout, (double)(j - *a) / count, 10L, print_dec);
      write_pch(stdout, " ! ", 3L);
      write_line(stdout);
    }
    i++;
  }
  if ((double)(j - *a) / count < 0.90 && j < *b - 10) {
    for (i1 = 1; i1 <= 3; i1++) {
      for (i2 = 1; i2 <= 5; i2++) {
	write_pch(stdout, " ! ", 3L);
	write_space(stdout, 9L);
	write_pch(stdout, ".", 1L);
      }
      write_pch(stdout, " ! ", 3L);
      write_line(stdout);
    }
    j = *b - 10;
    if (LINK->on_file) {
      for (i = k + 1; i <= j; i++)
	read_real_file(LINK->x_file, &x_k);
      k = j;
    }
    i = (long)floor(return_x(j, *b, &k, &x_k, &Local_Var) + 0.5);
    while ((long)floor(return_x(j, *b, &k, &x_k, &Local_Var) + 0.5) == i)
      j++;
    i = (long)floor(return_x(j, *b, &k, &x_k, &Local_Var) + 0.5);
    while (j <= *b) {
      j_i = j;
      while ((long)floor(return_x(j, *b, &k, &x_k, &Local_Var) + 0.5) == i &&
	     j <= *b)
	j++;
      write_pch(stdout, " ! ", 3L);
      write_integer(stdout, i, 10L);
      write_pch(stdout, " ! ", 3L);
      write_integer(stdout, j - j_i, 10L);
      write_pch(stdout, " ! ", 3L);
      write_integer(stdout, j - *a, 10L);
      write_pch(stdout, " ! ", 3L);
      write_real(stdout, (double)(j - j_i) / count, 10L, print_dec);
      write_pch(stdout, " ! ", 3L);
      write_real(stdout, (double)(j - *a) / count, 10L, print_dec);
      write_pch(stdout, " ! ", 3L);
      write_line(stdout);
      if (j <= *b)
	i = (long)floor(return_x(j, *b, &k, &x_k, &Local_Var) + 0.5);
    }
  }
  write_pch(stdout, " !", 2L);
  for (i1 = 1; i1 <= 5; i1++)
    write_pch(stdout, "------------!", 13L);
  write_line(stdout);
  write_line(stdout);
  write_line(stdout);
}  /* describe_observations */

Local Void describe_statistics(a, b, min, max, mean, variance, LINK)
long *a, *b;
double *min, *max, *mean, *variance;
struct LOC_describe_table *LINK;
{
  boolean harm;
  t_long_integer run, max_run, count_zero, i, count, k1, k2, k3;
  t_long_real xk1a, xk1b, xk2a, xk2b, xk3a, xk3b, x_i, x, x1, x2, x3, x4, xp,
	      xr, pred_p, mode, skewness, kurtosis, geometric_, harmonic_,
	      range, sum;
  long FORLIM;

  count_zero = 0;
  count = *b - *a + 1;
  k1 = (count + 2) / 4;
  k2 = (count + 1) / 2;
  k3 = (count + 1) * 3 / 4;
  range = *max - *min;
  sum = 0.0;
  if (LINK->on_file) {
    reset_real_file(LINK->x_file);
    FORLIM = *b;
    for (i = *a; i <= FORLIM; i++) {
      read_real_file(LINK->x_file, &x_i);
      sum += x_i - *min;
    }
  } else {
    FORLIM = *b;
    for (i = *a; i <= FORLIM; i++)
      sum += p[i] - *min;
  }
  *mean = *min + sum / count;
  x1 = 0.0;
  x2 = 0.0;
  x3 = 0.0;
  x4 = 0.0;
  xr = 0.0;
  xp = 1.0;
  harm = true;
  max_run = 1;
  run = 1;
  pred_p = -INFINITY_REAL;
  if (LINK->on_file) {
    reset_real_file(LINK->x_file);
    FORLIM = *b - *a + 1;
    for (i = 1; i <= FORLIM; i++) {
      read_real_file(LINK->x_file, &x_i);
      if (fabs(x_i) <= ips_epsilon)
	count_zero++;
      if (x_i == pred_p) {
	run++;
	if (run > max_run) {
	  max_run = run;
	  mode = x_i;
	}
      } else
	run = 1;
      pred_p = x_i;
      if (i == k1)
	xk1a = x_i;
      else if (i == k1 + 1)
	xk1b = x_i;
      else if (i == k2)
	xk2a = x_i;
      else if (i == k2 + 1)
	xk2b = x_i;
      else if (i == k3)
	xk3a = x_i;
      else if (i == k3 + 1)
	xk3b = x_i;
      x = x_i - *mean;
      x1 += x;
      x2 += x * x;
      x3 += x * x * x;
      x4 += x * x * x * x;
      if (fabs(x_i) < 1 / INFINITY_REAL)
	xp = 0.0;
      else if (fabs(xp) < INFINITY_REAL / (fabs(x_i) + 1))
	xp *= x_i;
      else
	xp = 0.0;
      if (fabs(x_i) > 1 / INFINITY_REAL)
	xr += 1 / x_i;
      else
	harm = false;
    }
  } else {
    xk1a = p[*a + k1 - 1];
    xk1b = p[*a + k1];
    xk2a = p[*a + k2 - 1];
    xk2b = p[*a + k2];
    xk3a = p[*a + k3 - 1];
    xk3b = p[*a + k3];
    FORLIM = *b;
    for (i = *a; i <= FORLIM; i++) {
      if (fabs(p[i]) <= ips_epsilon)
	count_zero++;
      if (p[i] == pred_p) {
	run++;
	if (run > max_run) {
	  max_run = run;
	  mode = p[i];
	}
      } else
	run = 1;
      pred_p = p[i];
      x = p[i] - *mean;
      x1 += x;
      x2 += x * x;
      x3 += x * x * x;
      x4 += x * x * x * x;
      if (fabs(p[i]) < 1 / INFINITY_REAL)
	xp = 0.0;
      else if (fabs(xp) < INFINITY_REAL / (fabs(p[i]) + 1))
	xp *= p[i];
      else
	xp = 0.0;
      if (fabs(p[i]) > 1 / INFINITY_REAL)
	xr += 1 / p[i];
      else
	harm = false;
    }
  }
  *variance = x2 / count;
  skewness = x3 / count / exp(3.0 / 2 * log(x2 / count));
  kurtosis = x4 / count / exp(2 * log(x2 / count));
  if (xp != 0)
    geometric_ = exp(log(fabs(xp)) / count) * fabs(xp) / xp;
  else
    geometric_ = 0.0;
  if (harm)
    harmonic_ = count / xr;
  else
    harmonic_ = 0.0;
  write_line(stdout);
  write_pch(stdout, " Statistics", 11L);
  write_line(stdout);
  write_line(stdout);
  write_pch(stdout, " Number of values:", 18L);
  write_integer(stdout, count, 5L);
  write_line(stdout);
  write_line(stdout);
  write_pch(stdout, " 25%:  ", 7L);
  write_pch(stdout, " Rank: ", 7L);
  write_integer(stdout, k1, 5L);
  write_pch(stdout, " VALUE: ", 8L);
  write_real(stdout, xk1a, print_width, print_dec);
  write_space(stdout, 3L);
  write_pch(stdout, " Rank: ", 7L);
  write_integer(stdout, k1 + 1, 5L);
  write_pch(stdout, " VALUE: ", 8L);
  write_real(stdout, xk1b, print_width, print_dec);
  write_line(stdout);
  write_pch(stdout, " 50%:  ", 7L);
  write_pch(stdout, " Rank: ", 7L);
  write_integer(stdout, k2, 5L);
  write_pch(stdout, " VALUE: ", 8L);
  write_real(stdout, xk2a, print_width, print_dec);
  write_space(stdout, 3L);
  write_pch(stdout, " Rank: ", 7L);
  write_integer(stdout, k2 + 1, 5L);
  write_pch(stdout, " VALUE: ", 8L);
  write_real(stdout, xk2b, print_width, print_dec);
  write_line(stdout);
  write_pch(stdout, " 75%:  ", 7L);
  write_pch(stdout, " Rank: ", 7L);
  write_integer(stdout, k3, 5L);
  write_pch(stdout, " VALUE: ", 8L);
  write_real(stdout, xk3a, print_width, print_dec);
  write_space(stdout, 3L);
  write_pch(stdout, " Rank: ", 7L);
  write_integer(stdout, k3 + 1, 5L);
  write_pch(stdout, " VALUE: ", 8L);
  write_real(stdout, xk3b, print_width, print_dec);
  write_line(stdout);
  write_line(stdout);
  write_pch(stdout, " Minimum: ", 10L);
  write_real(stdout, *min, print_width, print_dec);
  write_space(stdout, 3L);
  write_pch(stdout, " Maximum: ", 10L);
  write_real(stdout, *max, print_width, print_dec);
  write_space(stdout, 3L);
  write_pch(stdout, " Range:   ", 10L);
  write_real(stdout, range, print_width, print_dec);
  write_line(stdout);
  write_pch(stdout, " Max RUN: ", 10L);
  write_integer(stdout, max_run, print_width);
  write_space(stdout, 3L);
  write_pch(stdout, " Mode:    ", 10L);
  if (max_run > 1)
    write_real(stdout, mode, print_width, print_dec);
  else {
    write_space(stdout, labs(print_width) - 1);
    write_char(stdout, '-');
  }
  write_space(stdout, 3L);
  write_pch(stdout, " # < Eps.:", 10L);
  write_integer(stdout, count_zero, print_width);
  write_line(stdout);
  write_line(stdout);
  write_pch(stdout, " Sum  (X)   :       ", 20L);
  write_real(stdout, sum + count * *min, print_width, print_dec);
  write_space(stdout, 3L);
  write_pch(stdout, " Mean:              ", 20L);
  write_real(stdout, *mean, print_width, print_dec);
  write_line(stdout);
  write_pch(stdout, " Sum  (1/X) :       ", 20L);
  if (harm)
    write_real(stdout, xr, print_width, print_dec);
  else {
    write_space(stdout, labs(print_width) - 1);
    write_char(stdout, '-');
  }
  write_space(stdout, 3L);
  write_pch(stdout, " Harmonic Mean:     ", 20L);
  if (harm)
    write_real(stdout, harmonic_, print_width, print_dec);
  else {
    write_space(stdout, labs(print_width) - 1);
    write_char(stdout, '-');
  }
  write_line(stdout);
  write_pch(stdout, " Prod (X)   :       ", 20L);
  write_real(stdout, xp, print_width, print_dec);
  write_space(stdout, 3L);
  write_pch(stdout, " Geometric Mean:    ", 20L);
  write_real(stdout, geometric_, print_width, print_dec);
  write_line(stdout);
  write_pch(stdout, " Sum (X-Mean)^2 :   ", 20L);
  write_real(stdout, x2, print_width, print_dec);
  write_space(stdout, 3L);
  write_pch(stdout, " Variance:          ", 20L);
  write_real(stdout, *variance, print_width, print_dec);
  write_line(stdout);
  write_pch(stdout, " Sum (X-Mean)^3 :   ", 20L);
  write_real(stdout, x3, print_width, print_dec);
  write_space(stdout, 3L);
  write_pch(stdout, " Skewness:          ", 20L);
  write_real(stdout, skewness, print_width, print_dec);
  write_line(stdout);
  write_pch(stdout, " Sum (X-Mean)^4 :   ", 20L);
  write_real(stdout, x4, print_width, print_dec);
  write_space(stdout, 3L);
  write_pch(stdout, " Kurtosis:          ", 20L);
  write_real(stdout, kurtosis, print_width, print_dec);
  write_line(stdout);
  write_line(stdout);
}  /* describe_statistics */


Static Void describe_table(a, table_type_, uniform, rankit, probit,
			   log_trans_, a_set_offset, n_total,
			   model_set_offset, model)
long *a;
long *table_type_;
boolean *uniform, *rankit, *probit, *log_trans_;
t_offset *a_set_offset;
double n_total;
t_offset *model_set_offset;
t_model *model;
{
  struct LOC_describe_table Local_Var;
  t_long_integer i, min_index, max_index;
  t_cell cell;
  t_long_real x, min, max, mean, variance;
  pch_long file_name;
  long FORLIM;

  Local_Var.table_type = table_type_;
  Local_Var.log_trans = log_trans_;
  Local_Var.x_file = NULL;
  memcpy(cell, first_cell, sizeof(t_cell));
  if (last_index(a) >= max_p_cell_number - fpa) {
    write_pch(stdout, " (On file)", 10L);
    write_line(stdout);
    min_index = 1;
    max_index = 0;
    Local_Var.on_file = true;
#ifndef NO_REAL_FILE
    default_to_file_name(DEFAULT_TMP, file_name);
    assign_real_file_write(&Local_Var.x_file, file_name, &tmp_count);
    rewrite_real_file(Local_Var.x_file);
    min = INFINITY_REAL;
    max = -min;
    FORLIM = last_index(a);
    for (i = FIRST_INDEX; i <= FORLIM; i++) {
      x = return_table_value(a, *Local_Var.table_type, a_set_offset, &n_total,
			     i, cell, model_set_offset, model);
      if (!is_infinity_real(x)) {
	if (*Local_Var.log_trans) {
	  if (x > 0) {
	    x = log_10(x);
	    if (x < min)
	      min = x;
	    if (x > max)
	      max = x;
	    max_index++;
	    write_real_file(Local_Var.x_file, x);
	  }
	} else {
	  if (x < min)
	    min = x;
	  if (x > max)
	    max = x;
	  max_index++;
	  write_real_file(Local_Var.x_file, x);
	}
      }
      if (*Local_Var.table_type != 0)
	next_marginal_cell(a, cell);
    }
    sort_x_file(Local_Var.x_file, &min_index, &max_index, &Local_Var);
#endif /*  NO_REAL_FILE */
  } else {
    Local_Var.on_file = false;
    min_index = fpa;
    max_index = min_index - 1;
    FORLIM = last_index(a);
    for (i = FIRST_INDEX; i <= FORLIM; i++) {
      x = return_table_value(a, *Local_Var.table_type, a_set_offset, &n_total,
			     i, cell, model_set_offset, model);
      if (!is_infinity_real(x)) {
	if (*Local_Var.log_trans) {
	  if (x > 0) {
	    max_index++;
	    p[max_index] = log_10(x);
	  }
	} else {
	  max_index++;
	  p[max_index] = x;
	}
      }
      if (*Local_Var.table_type != 0)
	next_marginal_cell(a, cell);
    }
    sort_p_array(min_index, max_index);
    min = p[min_index];
    max = p[max_index];
  }
  page(stdout);
  write_line(stdout);
  write_pch(stdout, " Describe table:         ", 25L);
  print_table_type(*Local_Var.table_type, *Local_Var.log_trans);
  write_line(stdout);
  write_line(stdout);
  write_pch(stdout, " Number of cells in table:    ", 30L);
  write_integer(stdout, marginal_dimension(a), print_width);
  write_line(stdout);
  write_pch(stdout, " Number of invalid cells:     ", 30L);
  write_integer(stdout, marginal_dimension(a) - max_index + min_index - 1,
		print_width);
  write_line(stdout);
  write_pch(stdout, " Number of cells to describe: ", 30L);
  write_integer(stdout, max_index - min_index + 1, print_width);
  write_line(stdout);
  if ((max_index - min_index + 1) / (line_length / labs(print_width)) /
      page_length < 2) {
    write_line(stdout);
    write_line(stdout);
    write_pch(stdout, " Sorted list", 12L);
    write_line(stdout);
    write_line(stdout);
    if (Local_Var.on_file) {
#ifndef NO_REAL_FILE
      reset_real_file(Local_Var.x_file);
      for (i = min_index + 1; i <= max_index + 1; i++) {
	read_real_file(Local_Var.x_file, &x);
	write_real(stdout, x, print_width, print_dec);
	if ((i - min_index) % (line_length / labs(print_width)) == 0)
	  write_line(stdout);
      }
#endif /* NO_REAL_FILE */
    } else {
      for (i = min_index; i <= max_index; i++) {
	write_real(stdout, p[i], print_width, print_dec);
	if ((i - min_index + 1) % (line_length / labs(print_width)) == 0)
	  write_line(stdout);
      }
    }
    write_line(stdout);
  }
  write_line(stdout);
  if (max > min && max_index >= min_index) {
    describe_statistics(&min_index, &max_index, &min, &max, &mean, &variance,
			&Local_Var);
    if (*uniform)
      plot_uniform(&min_index, &max_index, 1L, &min, &max, &mean, &variance,
		   &Local_Var);
    if (*rankit)
      plot_uniform(&min_index, &max_index, 2L, &min, &max, &mean, &variance,
		   &Local_Var);
    if (*probit)
      plot_uniform(&min_index, &max_index, 3L, &min, &max, &mean, &variance,
		   &Local_Var);
    plot_histogram(&min_index, &max_index, &min, &max, &Local_Var);
  }
  if (*Local_Var.table_type == 0 && !*Local_Var.log_trans)
    describe_observations(&min_index, &max_index, &Local_Var);
#ifndef NO_REAL_FILE
  if (Local_Var.on_file)
    unlink_real_file(&Local_Var.x_file, file_name);
  if (Local_Var.x_file != NULL)
    fclose(Local_Var.x_file);
#endif /* NO_REAL_FILE */
}  /* describe_table */


/*@-"readdata.c"*/
/*@+"em.p"*/


Static Void next_cell_total(i)
t_level *i;
{
  t_vertex v;

  v = first_vertex;
  while (i[v - MIN_VERTEX] ==
	 FIRST_LEVEL + vertex_inf[v - MIN_VERTEX].levels_total - 1 &&
	 v < last_vertex) {
    i[v - MIN_VERTEX] = FIRST_LEVEL;
    v++;
  }
  if (v == last_vertex &&
      i[v - MIN_VERTEX] ==
      FIRST_LEVEL + vertex_inf[v - MIN_VERTEX].levels_total - 1)
    i[v - MIN_VERTEX] = FIRST_LEVEL;
  else
    i[v - MIN_VERTEX]++;
}  /* next_cell_total */


Static boolean return_from_offset_from_list(a, a_offset, g, g_offset, fna,
					    local_offset_list)
long *a;
t_offset *a_offset;
long *g;
t_offset *g_offset, *fna;
t_offset_list **local_offset_list;
{
  boolean Result;
  t_offset_list *p;
  t_cell_index size_g, size_g0;
  boolean b;
  t_vertex_set g0;

  b = true;
  p = *local_offset_list;
  P_setcpy(g, delta);
  *g_offset = -1;
  size_g = max_cell_number;
  while (p != NULL) {
    P_setcpy(g0, p->vertex_set);
    if (P_setequal(a, g0)) {
      Result = true;
      b = false;
      *a_offset = p->offset;
    } else {
      size_g0 = marginal_dimension(g0);
      if (P_subset(a, g0) && !P_setequal(a, g0) && size_g0 < size_g) {
	P_setcpy(g, g0);
	*g_offset = p->offset;
	size_g = size_g0;
      }
    }
    p = p->pointer;
  }
  if (!b)
    return Result;
  Result = false;
  insert_offset(a, *fna, local_offset_list);
  *a_offset = *fna;
  *fna += marginal_dimension(a);
  return Result;
}  /* return_from_offset_from_list */


Local long return_p_offset(a, m, tmp_fpa, ok)
long *a;
long *m;
t_offset *tmp_fpa;
boolean *ok;
{
  long Result;

  Result = *tmp_fpa;
  *m = marginal_dimension(a);
  if (*m >= MAX_P_CELL_NUMBER_MAX - *tmp_fpa) {
    *ok = false;
    return Result;
  }
  if (!TURBO_PC)
    *ok = space_in_p_array(*m, *tmp_fpa);
  *tmp_fpa += *m;
  *ok = (*tmp_fpa <= max_p_cell_number);
  return Result;
}  /* return_p_offset */

Local Void revers_list_(p)
t_offset_list **p;
{
  t_offset_list *hp1, *hp2;

  hp1 = NULL;
  while (*p != NULL) {
    hp2 = hp1;
    hp1 = *p;
    *p = (*p)->pointer;
    hp1->pointer = hp2;
  }
  *p = hp1;
}  /* revers_list */


Static Void find_em_offsets(link_expression_1, link_ips_list_1,
  link_expression_2, link_ips_list_2, m, bottom, top, find_list, marg_list,
  from_list, model_set, model_offset, ok)
t_expression **link_expression_1;
t_list_ips_elements **link_ips_list_1;
t_expression **link_expression_2;
t_list_ips_elements **link_ips_list_2;
long *m, *bottom, *top;
t_offset_list **find_list, **marg_list, **from_list;
long *model_set;
t_offset *model_offset;
boolean *ok;
{
  t_offset first_q, tmp_offset, g_offset;
  t_vertex_set g;
  t_long_integer max, m1, m2;
  t_set_list *marginals_to_find, *list_of_sets;
  t_offset_list *local_offset_list;
  t_expression *p_exp;
  t_ips_set_list *p_gc, *tmp_gc;
  t_list_ips_elements *p_ips;
  t_ips_element *WITH;

  list_of_sets = NULL;
  p_ips = *link_ips_list_1;
  while (p_ips != NULL) {
    insert_clique(p_ips->ips_element.a, &list_of_sets);
    p_ips = p_ips->pointer;
  }
  p_exp = *link_expression_1;
  while (p_exp != NULL) {
    insert_clique(p_exp->vertex_set, &list_of_sets);
    p_exp = p_exp->pointer;
  }
  first_q = fpa;
  *ok = true;
  local_offset_list = NULL;
  *find_list = NULL;
  marginals_to_find = NULL;
  p_ips = *link_ips_list_1;
  while (*ok && p_ips != NULL) {
    p_ips->ips_element.p_offset = return_p_offset(p_ips->ips_element.a, m,
						  &first_q, ok);
    p_ips = p_ips->pointer;
  }
  *bottom = first_q;
  p_exp = *link_expression_1;
  while (*ok && p_exp != NULL) {
    if (!return_from_offset_from_list(p_exp->vertex_set, &tmp_offset, g,
	  &g_offset, &first_q, &local_offset_list)) {
      if (P_setequal(p_exp->vertex_set, model_set) |
	  (contains_an_edge(p_exp->vertex_set, &list_of_sets) &&
	   datastructure == list_file))
	insert_offset(p_exp->vertex_set, tmp_offset, find_list);
      else
	insert_set_in_list_of_marginals_to_find(p_exp->vertex_set,
						&marginals_to_find);
    }
    p_exp->offset = tmp_offset;
    if (!TURBO_PC)
      *ok = space_in_p_array(first_q, 0L);
    *ok = (first_q <= max_p_cell_number);
    p_exp = p_exp->pointer;
  }
  *top = first_q;
  if (datastructure != list_file) {
    if (!return_from_offset_from_list(model_set, model_offset, g, &g_offset,
				      &first_q, &local_offset_list))
      insert_offset(model_set, *model_offset, find_list);
  }
  max = 0;
  p_ips = *link_ips_list_1;
  while (*ok && p_ips != NULL) {
    WITH = &p_ips->ips_element;
    if (!return_from_offset_from_list(WITH->a, &tmp_offset, g, &g_offset,
				      &first_q, &local_offset_list)) {
      if (datastructure == list_file)
	insert_offset(WITH->a, tmp_offset, find_list);
      else
	insert_set_in_list_of_marginals_to_find(WITH->a, &marginals_to_find);
    }
    WITH->n_offset = tmp_offset;
    if (!TURBO_PC)
      *ok = space_in_p_array(first_q, 0L);
    *ok = (first_q <= max_p_cell_number);
    p_gc = WITH->gen_class;
    m1 = 0;
    while (p_gc != NULL && *ok) {
      if (!return_from_offset_from_list(p_gc->vertex_set, &tmp_offset, g,
	    &g_offset, &first_q, &local_offset_list))
	insert_set_in_list_of_marginals_to_find(p_gc->vertex_set,
						&marginals_to_find);
      p_gc->n_offset = tmp_offset;
      m2 = marginal_dimension(p_gc->vertex_set);
      if (m2 > m1)
	m1 = m2;
      p_gc = p_gc->pointer;
    }
    if (*m + m1 > max)
      max = *m + m1;
    p_ips = p_ips->pointer;
  }
  dispose_set_list(&list_of_sets);
  *marg_list = NULL;
  *from_list = NULL;
  list_of_sets = marginals_to_find;
  while (marginals_to_find != NULL) {
    if (return_from_offset_from_list(marginals_to_find->vertex_set,
	  &tmp_offset, g, &g_offset, &first_q, &local_offset_list)) {
      insert_offset(marginals_to_find->vertex_set, tmp_offset, marg_list);
      insert_offset(g, g_offset, from_list);
    } else
      write_pch(stdout, " ListFindE", 10L);
    marginals_to_find = marginals_to_find->pointer;
  }
  dispose_offset_list(&local_offset_list);
  dispose_set_list(&list_of_sets);
  revers_list_(marg_list);
  revers_list_(from_list);
  if (!TURBO_PC)
    *ok = space_in_p_array((first_q - *bottom) * 2 + max, fpa);
  *ok = ((first_q - *bottom) * 2 + max <= max_p_cell_number - fpa);
  if (*ok) {
    *m = first_q - *bottom;
    fpa = first_q + *m;
    p_exp = *link_expression_1;
    *link_expression_2 = NULL;
    while (p_exp != NULL) {
      insert_factor_in_expression(p_exp->vertex_set, &p_exp->factor,
				  link_expression_2);
      (*link_expression_2)->offset = p_exp->offset + *m;
      p_exp = p_exp->pointer;
    }
    p_ips = *link_ips_list_1;
    *link_ips_list_2 = NULL;
    while (p_ips != NULL) {
      WITH = &p_ips->ips_element;
      sub_insert_ips_element_2(link_ips_list_2, NULL, p_ips->ips_element.a,
			       false, p_ips->ips_element.n_offset + *m,
			       p_ips->ips_element.p_offset, NULL);
      p_gc = p_ips->ips_element.gen_class;
      while (p_gc != NULL) {
	tmp_gc = (t_ips_set_list *)Malloc(sizeof(t_ips_set_list));
	if (tmp_gc == NULL)
	  _OutMem();
	P_setcpy(tmp_gc->vertex_set, p_gc->vertex_set);
	tmp_gc->n_offset = p_gc->n_offset + *m;
	tmp_gc->pointer = (*link_ips_list_2)->ips_element.gen_class;
	(*link_ips_list_2)->ips_element.gen_class = tmp_gc;
	p_gc = p_gc->pointer;
      }
      p_ips = p_ips->pointer;
    }
    return;
  }
  dispose_offset_list(find_list);
  dispose_offset_list(from_list);
  dispose_offset_list(marg_list);
  p_exp = *link_expression_1;
  while (p_exp != NULL) {
    p_exp->offset = MAX_OFFSET;
    p_exp = p_exp->pointer;
  }
  p_ips = *link_ips_list_1;
  while (p_ips != NULL) {
    p_ips->ips_element.p_offset = MAX_OFFSET;
    p_ips = p_ips->pointer;
  }
}  /* find_em_offsets */


Local Void write_case(count, p_1, p_2, a, b, i)
t_cell_count *count;
double p_1, p_2;
long *a, *b;
t_level *i;
{
  t_vertex v, FORLIM;

  write_integer(stdout, *count, 10L);
  if (p_1 == -1)
    write_space(stdout, labs(print_width) + 2);
  else
    write_real(stdout, p_1, labs(print_width) + 2, print_dec + 2);
  if (p_2 == -1)
    write_space(stdout, labs(print_width) + 2);
  else
    write_real(stdout, p_2, labs(print_width) + 2, print_dec + 2);
  write_space(stdout, 2L);
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    write_integer(stdout, i[v - MIN_VERTEX] - FIRST_LEVEL + 1L,
      floor_x(2 + log_10((double)vertex_inf[v - MIN_VERTEX].levels)));
    if (P_inset(v, b))
      write_char(stdout, ' ');
    else
      write_char(stdout, '*');
    if (P_inset(v, a))
      write_char(stdout, ' ');
    else
      write_char(stdout, '-');
  }
  write_line(stdout);
}  /* write_case */

Local long random_x(dummy, max)
long *dummy;
t_level *max;
{
  *dummy = (*dummy * 7141 + 54773L) % 259200L;
  return ((long)(*dummy / 259200.0 * *max) + 1);
}  /* random_x */

Local Void insert_cases(i_, count, a, offset, model, logl, init_type, seed,
			init_n_table, just_compute_log_l)
t_level *i_;
t_cell_count count;
long *a;
t_offset *offset;
t_model *model;
double *logl;
long *init_type, *seed;
boolean init_n_table, just_compute_log_l;
{
  t_cell i;
  t_vertex v;
  t_long_real p_1, p_2, p_sum;
  t_vertex_set b, c, d, e;
  t_long_integer l_count, l_sum, index, m_index, last_level, j;
  t_vertex FORLIM;
  long FORLIM1;

  memcpy(i, i_, sizeof(t_cell));
  l_count = 0;
  l_sum = 0;
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    if (i[v - MIN_VERTEX] < FIRST_LEVEL + vertex_inf[v - MIN_VERTEX].levels) {
      l_count++;
      l_sum += i[v - MIN_VERTEX];
    }
  }
  P_setcpy(b, empty_set);
  P_setcpy(d, empty_set);
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    if (P_inset(v, a)) {
      if (i[v - MIN_VERTEX] < FIRST_LEVEL + vertex_inf[v - MIN_VERTEX].levels)
	P_addset(d, v);
    }
  }
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    last_level = FIRST_LEVEL + vertex_inf[v - MIN_VERTEX].levels - 1;
    if (P_inset(v, a)) {
      if (i[v - MIN_VERTEX] <= last_level)
	P_addset(b, v);
      else if (init_n_table) {
	if (incomplete_table) {
	  P_addset(d, v);
	  switch (*init_type) {

	  case EM_FIRST:
	    i[v - MIN_VERTEX] = FIRST_LEVEL;
	    while (marginal_zero_cell(d, i, q_tables_offsets) &&
		   i[v - MIN_VERTEX] < last_level)
	      i[v - MIN_VERTEX]++;
	    break;

	  case EM_LAST:
	    i[v - MIN_VERTEX] = last_level;
	    break;

	  case EM_MEAN:
	    if (l_count > 0)
	      i[v - MIN_VERTEX] = (long)floor((double)l_sum / l_count + 0.5);
	    else
	      i[v - MIN_VERTEX] = last_level;
	    break;

	  case EM_RANDOM:
	    i[v - MIN_VERTEX] = FIRST_LEVEL + random_x(seed,
				  &vertex_inf[v - MIN_VERTEX].levels) - 1;
	    j = 0;
	    while (marginal_zero_cell(d, i, q_tables_offsets) &&
		   i[v - MIN_VERTEX] > FIRST_LEVEL && j > 100) {
	      i[v - MIN_VERTEX] = FIRST_LEVEL + random_x(seed,
				    &vertex_inf[v - MIN_VERTEX].levels) - 1;
	      j++;
	    }
	    break;

	  case EM_INPUT:
	    i[v - MIN_VERTEX] -= vertex_inf[v - MIN_VERTEX].levels;
	    break;
	  }
	  /*$ifdef TRACE*/
	  if (boolean_option[26] && init_n_table) {
	    P_addsetr(P_expset(e, 0L), v + 1, last_vertex);
	    P_setunion(e, e, b);
	    write_case(&count, -1.0, -1.0, d, e, i);
	  }
	  /*$endif TRACE*/
	  if (marginal_zero_cell(d, i, q_tables_offsets)) {
	    i[v - MIN_VERTEX] = last_level;
	    while (marginal_zero_cell(d, i, q_tables_offsets) &&
		   i[v - MIN_VERTEX] > FIRST_LEVEL)
	      i[v - MIN_VERTEX]--;
	    if (marginal_zero_cell(d, i, q_tables_offsets)) {
	      write_warning(stdout,
			    " ?: Unable to `initiate complete' in EM.", 40L);
	      write_case(&count, -1.0, -1.0, a, b, i);
	    }
	  }
	} else {
	  switch (*init_type) {

	  case EM_FIRST:
	    i[v - MIN_VERTEX] = FIRST_LEVEL;
	    break;

	  case EM_LAST:
	    i[v - MIN_VERTEX] = last_level;
	    break;

	  case EM_MEAN:
	    if (l_count > 0)
	      i[v - MIN_VERTEX] = (long)floor((double)l_sum / l_count + 0.5);
	    else
	      i[v - MIN_VERTEX] = last_level;
	    break;

	  case EM_RANDOM:
	    i[v - MIN_VERTEX] = FIRST_LEVEL + random_x(seed,
				  &vertex_inf[v - MIN_VERTEX].levels) - 1;
	    break;

	  case EM_INPUT:
	    i[v - MIN_VERTEX] -= vertex_inf[v - MIN_VERTEX].levels;
	    break;
	  }
	}
      } else
	i[v - MIN_VERTEX] = FIRST_LEVEL;
    } else  /* if v in a */
      i[v - MIN_VERTEX] = FIRST_LEVEL;
  }
  if (incomplete_table) {
    if (marginal_zero_cell(d, i, q_tables_offsets)) {
      write_warning(stdout, " ?: Unable to `Initiate Complete' in EM.", 40L);
      write_case(&count, -1.0, -1.0, a, b, i);
    }
  }
  if (init_n_table) {
    P_setcpy(b, delta);
    p_2 = -1.0;
  } else {
    p_2 = compute_m_p_em(b, i, model);
    if (p_2 > 0)
      *logl += count * log(p_2);
    else if (!just_compute_log_l) {
      write_pch(stdout, " Invalid probability", 20L);
      /* write_real(output, p_2, print_width, print_dec); */
      /* write_integer(output, count, print_width); */
      write_case(&count, -1.0, p_2, a, b, i);
      /* write_line(output) */
    }
  }
  /*$ifdef TRACE*/
  if (boolean_option[26] && init_n_table)
    write_case(&count, -1.0, p_2, a, b, i);
  /*$endif TRACE*/
  if (just_compute_log_l) {
    if (print_case_list)
      write_case(&count, -1.0, p_2, a, b, i);
    return;
  }
  P_setdiff(d, delta, b);
  P_setdiff(c, a, b);
  P_setunion(e, a, b);
  if (!P_setequal(d, empty_set)) {
    p_sum = 0.0;
    if (fast) {
      FORLIM1 = marginal_dimension(d);
      for (index = 1; index <= FORLIM1; index++) {
	p_1 = compute_m_p_em(delta, i, model);
	p_sum += p_1;
	if (print_case_list)
	  write_case(&count, p_1, p_2, a, b, i);
	m_index = *offset + marginal_hash(a, i);
	p[m_index] += count * p_1 / p_2;
	next_marginal_cell(d, i);
      }
    } else {
      FORLIM1 = marginal_dimension(c);
      for (index = 1; index <= FORLIM1; index++) {
	p_1 = compute_m_p_em(e, i, model);
	p_sum += p_1;
	if (print_case_list)
	  write_case(&count, p_1, p_2, a, b, i);
	m_index = *offset + marginal_hash(a, i);
	p[m_index] += count * p_1 / p_2;
	next_marginal_cell(c, i);
      }
    }
    if (fabs(p_sum - p_2) > 0.0001)
      write_pch(stdout, " ProbError", 10L);
    return;
  }
  if (print_case_list)
    write_case(&count, -1.0, p_2, a, b, i);
  m_index = *offset + marginal_hash(a, i);
  p[m_index] += count;

  /* if init_n_table */
}  /* insert_cases */


Static Void find_expected_table(a_, offset, model, logl, init_n_table,
				just_compute_log_l)
long *a_;
t_offset offset;
t_model *model;
double *logl;
boolean init_n_table, just_compute_log_l;
{
  t_vertex_set a;
  t_offset m_offset;
  t_long_integer index, m, case_number;
  t_cell i;
  t_vertex v;
  /* , seed */
  t_long_integer init_type;
  t_long_real start_clock;
  long FORLIM;
  t_vertex FORLIM1;
  long TEMP;

  P_setcpy(a, a_);
  start_clock = my_clock()/1;
  if (print_case_list)
    write_line(stdout);
  if (init_n_table && em_initial == EM_UNIFORM) {
    m = marginal_dimension(a);
    if (!just_compute_log_l) {
      FORLIM = offset + last_index(a);
      for (index = offset; index <= FORLIM; index++)
	p[index] = (double)n[0] / m;
    }
    *logl = 0.0;
  } else {
    m = marginal_dimension(a);
    if (!just_compute_log_l) {
      FORLIM = offset + last_index(a);
      for (index = offset; index <= FORLIM; index++)
	p[index] = 0.0;
    }
    *logl = 0.0;
    init_type = em_initial;
    /* seed := 0; */
    memcpy(i, first_cell, sizeof(t_cell));
    if (print_case_list) {
      write_line(stdout);
      write_pch(stdout, "     Count", 10L);
      write_space(stdout, labs(print_width) - 2);
      write_pch(stdout, "P(j)", 4L);
      write_space(stdout, labs(print_width) - 5);
      write_pch(stdout, "P(i{b})", 7L);
      write_space(stdout, 2L);
      FORLIM1 = last_vertex;
      for (v = first_vertex; v <= FORLIM1; v++) {
	if (P_inset(v, a)) {
	  write_space(stdout,
	    floor_x(1 + log_10((double)vertex_inf[v - MIN_VERTEX].levels)));
	  print_vertex_on_file(stdout, v);
	  write_space(stdout, 2L);
	}
      }
      write_line(stdout);
    }
    /*$ifdef TRACE*/
    if (boolean_option[26] && boolean_option[30]) {
      m_offset = fpa;
      write_pch(stdout, "PrintTable", 10L);
      write_line(stdout);
      TEMP = 2;
      print_table(a, NULL, &TEMP, false, false, false, &offset, (double)n[0],
		  &m_offset, model);
      write_integer(stdout, n[0], 10L);
      write_integer(stdout, offset, 10L);
      write_line(stdout);
    }
    /*$endif TRACE*/
    if (datastructure == list_file) {
      reset_level_file(file_read);
      FORLIM = n[0];
      for (case_number = 1; case_number <= FORLIM; case_number++) {
	FORLIM1 = last_vertex;
	for (v = first_vertex; v <= FORLIM1; v++)
	  read_level_file(file_read, &i[v - MIN_VERTEX]);
	insert_cases(i, 1L, a, &offset, model, logl, &init_type, &seed,
		     init_n_table, just_compute_log_l);
      }
    } else {
      FORLIM = N_START + marginal_dimension_tf(delta, true, false);
      for (index = N_START; index < FORLIM; index++) {
	if (n[index] != 0)
	  insert_cases(i, n[index], a, &offset, model, logl, &init_type,
		       &seed, init_n_table, just_compute_log_l);
	next_cell_total(i);
      }
    }
    if (boolean_option[26] && boolean_option[30]) {
      m_offset = fpa;
      write_pch(stdout, "Printtable", 10L);
      write_line(stdout);
      TEMP = 2;
      print_table(a, NULL, &TEMP, false, false, false, &offset, (double)n[0],
		  &m_offset, model);
      write_integer(stdout, n[0], 10L);
      write_integer(stdout, offset, 10L);
      write_line(stdout);
    }
    /*$endif TRACE*/
  }
  write_pch_30_text(report_file, " <> .E-Expt  -  Log L: ", 23L);
  write_real_text(report_file, logl, 13L, 6L);
  write_time_text(report_file, ",  Time: ", 9L, (double)my_clock()/1, start_clock,
		  8L, 3L);
  write_pch_10_text(report_file, "  Table: ", 9L);
  print_vertex_set_on_report(report_file, a);
  write_line_text(report_file);
  fflush(report_file);
  P_ioresult = 0;

  /*$ifdef TRACE*/
}  /* find_expected_table */


Static Void find_marginal_expected_table(a, g, off_a, off_g)
long *a, *g;
t_offset off_a, off_g;
{
  t_cell_index index, m_index;
  t_cell i;
  t_vertex_set c_in_a;
  t_vertex l_a_vertex;
  t_v_arr_of_integer prod_1, prod_2, levels;
  t_long_real start_clock;
  t_cell_index FORLIM;

  start_clock = my_clock()/1;
  memcpy(i, first_cell, sizeof(t_cell));
  FORLIM = off_a + last_index(a);
  for (m_index = off_a; m_index <= FORLIM; m_index++)
    p[m_index] = 0.0;
  find_products(g, a, c_in_a, prod_1, prod_2, levels, &l_a_vertex);
  m_index = off_a;
  FORLIM = off_g + last_index(g);
  for (index = off_g; index <= FORLIM; index++) {
    p[m_index] += p[index];
    next_c_offset_in_a(c_in_a, &m_index, prod_1, prod_2, levels, &l_a_vertex,
		       i);
  }
  write_pch_20_text(report_file, " <> .E-Marg  -  ", 16L);
  write_time_text(report_file, " Time: ", 7L, (double)my_clock()/1, start_clock,
		  8L, 3L);
  write_pch_10_text(report_file, "  Table: ", 9L);
  print_vertex_set_on_report(report_file, a);
  write_space_text(report_file, 10 - cardinality(a) % 10);
  write_pch_20_text(report_file, "  From: @@          ", 8L);
  print_vertex_set_on_report(report_file, g);
  write_line_text(report_file);
  fflush(report_file);
  P_ioresult = 0;
}  /* find_marginal_expected_table */


Static Void e_step(model, find_list, marg_list, from_list, init_n_table,
		   log_l, old_log_l, m)
t_model *model;
t_offset_list **find_list, **marg_list, **from_list;
boolean *init_n_table;
double *log_l, *old_log_l;
long m;
{
  t_long_real start_clock, tmp_log_l;
  t_offset_list *p_1, *p_2;

  start_clock = my_clock()/1;
  *log_l = -98765.43210987654321;
  if ((*find_list)->pointer != NULL && !*init_n_table) {
    find_expected_table(model->model_set, (long)(-FIRST_INDEX), model, log_l,
			*init_n_table, true);
    /*$ifdef TRACE*/
    if (boolean_option[26]) {
      write_pch(stdout, " New L:", 7L);
      write_real(stdout, *log_l, 14L, 6L);
      write_line(stdout);
    }
    /*$endif TRACE*/
    write_pch_30_text(report_file, " <> .E-step  -  New L: @@@@   ", 26L);
    write_real_text(report_file, log_l, 13L, 6L);
    write_time_text(report_file, ",  Time: ", 9L, (double)my_clock()/1,
		    start_clock, 8L, 3L);
    write_line_text(report_file);
    fflush(report_file);
    P_ioresult = 0;
  }
  if (*log_l >= *old_log_l || (*find_list)->pointer == NULL || *init_n_table) {
    p_1 = *find_list;
    while (p_1 != NULL && !interrupt_2) {
      find_expected_table(p_1->vertex_set, p_1->offset + m, model, &tmp_log_l,
			  *init_n_table, false);
      /*$ifdef TRACE*/
      if (boolean_option[26]) {
	write_pch(stdout, " Tmp L:", 7L);
	write_real(stdout, tmp_log_l, 14L, 6L);
	write_line(stdout);
      }
      /*$endif TRACE*/
      write_pch_30_text(report_file, " <> .E-step  -  Tmp L: @@@@   ", 26L);
      write_real_text(report_file, &tmp_log_l, 13L, 6L);
      write_time_text(report_file, ",  Time: ", 9L, (double)my_clock()/1,
		      start_clock, 8L, 3L);
      write_line_text(report_file);
      fflush(report_file);
      P_ioresult = 0;
      p_1 = p_1->pointer;
    }
    if ((*find_list)->pointer == NULL && !*init_n_table)
      *log_l = tmp_log_l;
    if (*log_l >= *old_log_l || *init_n_table) {
      p_1 = *marg_list;
      p_2 = *from_list;
      while (p_1 != NULL && !interrupt_2) {
	find_marginal_expected_table(p_1->vertex_set, p_2->vertex_set,
				     p_1->offset + m, p_2->offset + m);
	p_2 = p_2->pointer;
	p_1 = p_1->pointer;
      }
    }
  }
  write_pch_30_text(report_file, " <> .E-step  -  Log L: ", 23L);
  write_real_text(report_file, log_l, 13L, 6L);
  write_time_text(report_file, ",  Time: ", 9L, (double)my_clock()/1, start_clock,
		  8L, 3L);
  write_line_text(report_file);
  fflush(report_file);
  P_ioresult = 0;
}  /* e_step */


Static Void em_estimate(model)
t_model *model;
{
  t_expression *expression[2];
  t_list_ips_elements *p_ips_list;
  t_list_ips_elements *ips_list[2];
  t_long_integer number_of_iterations, bad_count, i, m, bottom, top, fpa_;
  boolean init_n_table, first_, ok;
  char flip, flop, flap;
  t_offset_list *find_list, *marg_list, *from_list;
  t_long_real log_l, log_l_0, em_delta, d_delta, pred_delta, d_d_delta,
	      pred_d_delta, d_d_d_delta, pred_d_d_delta, d_d_d_d_delta,
	      pred_d_d_d_delta, start_clock, step_clock;
  t_offset model_offset;
  long FORLIM;
  double TEMP;

  start_clock = my_clock()/1;
  expression[0] = model->expression;
  ips_list[0] = model->ips_list;
  /*$ifdef TRACE*/
  if (boolean_option[26]) {
    write_line(stdout);
    write_pch(stdout, " @FirstP: ", 10L);
    write_integer(stdout, fpa, 6L);
    write_line(stdout);
  }
  fpa_ = fpa;
  /*$endif TRACE*/
  find_em_offsets(expression, ips_list, &expression[1], &ips_list[1], &m,
		  &bottom, &top, &find_list, &marg_list, &from_list,
		  model->model_set, &model_offset, &ok);
  FORLIM = fpa;
  for (i = fpa_; i <= FORLIM; i++)
    p[i] = -1.0;
  /*$ifdef TRACE*/
  if (boolean_option[26]) {
    write_pch(stdout, " @Bottom: ", 10L);
    write_integer(stdout, bottom, 6L);
    write_line(stdout);
    write_pch(stdout, " @Top:    ", 10L);
    write_integer(stdout, top, 6L);
    write_line(stdout);
    write_pch(stdout, " @m:      ", 10L);
    write_integer(stdout, m, 6L);
    write_line(stdout);
    write_pch(stdout, " @FirstP: ", 10L);
    write_integer(stdout, fpa, 6L);
    write_line(stdout);
  }
  /*$endif TRACE*/
  write_pch_20_text(report_file, " <> EM-start -  ", 16L);
  write_time_text(report_file, "  Time: ", 8L, (double)my_clock()/1, start_clock,
		  8L, 3L);
  write_line_text(report_file);
  fflush(report_file);
  P_ioresult = 0;
  step_clock = my_clock()/1;
  if (ok) {
    flip = 1;
    flop = 2;
    log_l_0 = -INFINITY;
    em_delta = 2 * em_epsilon;
    init_n_table = true;
    e_step(model, &find_list, &marg_list, &from_list, &init_n_table, &log_l,
	   &log_l_0, 0L);
    write_pch_30_text(report_file, " <> EM-init  -  Log L: ", 23L);
    write_real_text(report_file, &log_l, 13L, 6L);
    write_time_text(report_file, ",  Time: ", 9L, (double)my_clock()/1,
		    start_clock, 8L, 3L);
    write_line_text(report_file);
    fflush(report_file);
    P_ioresult = 0;
    init_n_table = false;
    first_ = true;
    bad_count = 0;
    number_of_iterations = 0;
    pred_delta = 0.0;
    pred_d_delta = 0.0;
    pred_d_d_delta = 0.0;
    pred_d_d_d_delta = 0.0;
    while (em_delta > em_epsilon && bad_count < 5 &&
	   number_of_iterations < em_max_it && !interrupt_2) {
      step_clock = my_clock()/1;
      /*$ifdef TRACE*/
      if (boolean_option[26]) {
	write_pch(stdout, " @Flip:", 7L);
	write_integer(stdout, (long)flip, 2L);
	write_pch(stdout, " @Flop:", 7L);
	write_integer(stdout, (long)flop, 2L);
	write_pch(stdout, " @Cycles:", 9L);
	write_integer(stdout, number_of_iterations, 3L);
	write_pch(stdout, " @Gentag:", 9L);
	write_integer(stdout, bad_count, 3L);
	write_line(stdout);
      }
      /*$endif TRACE*/
      p_ips_list = ips_list[flip - 1];
      while (p_ips_list != NULL && !interrupt_2) {
	if (first_)
	  ips_em(&p_ips_list->ips_element, n, sqrt(ips_epsilon), &ips_max_it,
		 first_);
	else
	  ips_em(&p_ips_list->ips_element, n, ips_epsilon, &ips_max_it,
		 first_);
	p_ips_list = p_ips_list->pointer;
      }
      first_ = false;
      model->expression = expression[flip - 1];
      model->ips_list = ips_list[flip - 1];
      e_step(model, &find_list, &marg_list, &from_list, &init_n_table, &log_l,
	     &log_l_0, (flop - 1L) * m);
      if (log_l_0 == -INFINITY)
	log_l_0 = log_l - 2 * em_epsilon;
      /*$ifdef TRACE*/
      if (boolean_option[26]) {
	write_pch(stdout, " Log L:", 7L);
	write_real(stdout, log_l, 14L, 6L);
	write_pch(stdout, " Pred: ", 7L);
	write_real(stdout, log_l_0, 14L, 6L);
	write_line(stdout);
	write_pch(stdout, " Delta:", 7L);
	write_real(stdout, log_l - log_l_0, 14L, 8L);
	write_real(stdout, log_l - log_l_0 - pred_delta, 14L, 8L);
	write_real(stdout, log_l - log_l_0 - pred_delta - pred_d_delta, 14L,
		   8L);
	write_real(stdout,
	  log_l - log_l_0 - pred_delta - pred_d_delta - pred_d_d_delta, 14L,
	  8L);
	write_real(stdout, log_l - log_l_0 - pred_delta - pred_d_delta -
			   pred_d_d_delta - pred_d_d_d_delta, 14L, 8L);
	write_line(stdout);
      }
      /*$endif TRACE*/
      write_pch_30_text(report_file, " <> EM-step  -  Log L: ", 23L);
      write_real_text(report_file, &log_l, 13L, 6L);
      write_pch_10_text(report_file, ";+ Delta:", 9L);
      TEMP = log_l - log_l_0;
      write_real_text(report_file, &TEMP, 15L, 10L);
      write_time_text(report_file, ", Time: ", 8L, (double)my_clock()/1,
		      start_clock, 8L, 3L);
      write_line_text(report_file);
      fflush(report_file);
      P_ioresult = 0;
      if ((log_l >= log_l_0 || bad_count == 4) && !interrupt_2) {
	bad_count = 0;
	em_delta = fabs(log_l - log_l_0);
	log_l_0 = log_l;
	d_delta = em_delta - pred_delta;
	pred_delta = em_delta;
	d_d_delta = d_delta - pred_d_delta;
	pred_d_delta = d_delta;
	d_d_d_delta = d_d_delta - pred_d_d_delta;
	pred_d_d_delta = d_d_delta;
	d_d_d_d_delta = d_d_d_delta - pred_d_d_d_delta;
	pred_d_d_d_delta = d_d_d_delta;
	flap = flip;
	flip = flop;
	flop = flap;
      } else
	bad_count++;
      number_of_iterations++;
    }
    if (interrupt_2) {
      interrupt_1 = false;
      interrupt_2 = false;
    }
    dispose_offset_list(&find_list);
    dispose_offset_list(&from_list);
    dispose_offset_list(&marg_list);
    if (flip == 2) {
      for (i = bottom; i < top; i++)
	p[i] = p[i + m];
    }
    model->expression = expression[0];
    model->ips_list = ips_list[0];
    model->log_l = log_l;
    model->found_expression = true;
    model->found_log_l = true;
    model->found_ps = true;
  }
  /*$ifdef TRACE*/
  if (boolean_option[26]) {
    write_pch(stdout, " @@ EM end", 10L);
    write_line(stdout);
    write_pch(stdout, " @Flip:", 7L);
    write_integer(stdout, (long)flip, 2L);
    write_pch(stdout, " @Flop:", 7L);
    write_integer(stdout, (long)flop, 2L);
    if (bad_count > 0) {
      write_pch(stdout, " EqualLogL", 10L);
      write_integer(stdout, bad_count, 2L);
    }
    write_line(stdout);
  }
  /*$endif TRACE*/
  write_pch_30_text(report_file, " <> EM-total -  Log L: ", 23L);
  write_real_text(report_file, &log_l, 13L, 6L);
  write_time_text(report_file, ",  Time: ", 9L, (double)my_clock()/1, start_clock,
		  8L, 3L);
  write_line_text(report_file);
  fflush(report_file);
  P_ioresult = 0;
  fpa = top;
  dispose_expression(&expression[1]);
  dispose_ips_list_blind(&ips_list[1]);
}  /* em_estimate */


/*@+"model.p"*/


Static Void estimate_p(model)
t_model *model;
{
  t_list_ips_elements *ips_list;
  t_list_radim_elements *radim_list;

  ips_list = model->ips_list;
  while (ips_list != NULL) {
    if (!ips_list->ips_element.radim_part)
      ips_em(&ips_list->ips_element, n, ips_epsilon, &ips_max_it, true);
    ips_list = ips_list->pointer;
  }
  radim_list = model->radim_list;
  while (radim_list != NULL) {
    if (radim_list->radim_element.radim_parts != NULL)
      decomposed_ips_em(&radim_list->radim_element, n, &ips_epsilon,
			&ips_max_it, true);
    radim_list = radim_list->pointer;
  }
}  /* estimate_p */


Static Void do_model(model, find_marginals, fit_model, ok)
t_model *model;
boolean find_marginals, fit_model, *ok;
{
  t_set_list *link_clique;
  boolean ok_n, ok_p;

  if (exclude_missing) {
    if (model->found_expression) {
      dispose_expression(&model->expression);
      dispose_ips_list(&model->ips_list);
      dispose_radim_list(&model->radim_list);
    }
    model->found_expression = false;
  }
  if (!model->found_expression) {
    identify_model(model);
    model->found_expression = true;
    model->found_ps = false;
  }
  *ok = false;
  if (graph_mode) {
    write_line(stdout);
    write_pch(stdout, " *** WARNING ***    ", 20L);
    write_line(stdout);
    write_pch(stdout, " MARGINALS AND PROB. NOT FOUND FOR      ", 40L);
    link_clique = model->sets_h_g_c;
    while (link_clique != NULL) {
      print_vertex_set(link_clique->vertex_set);
      link_clique = link_clique->pointer;
    }
    write_line(stdout);
    write_pch(stdout, " *** WARNING ***    ", 20L);
    write_line(stdout);
    write_line(stdout);
    return;
  }
  if (model->found_ps) {
    *ok = model->found_ps;
    return;
  }
  if (ok_to_find_model_marginals(model)) {
    if (em) {
      em_estimate(model);
      *ok = model->found_ps;
      return;
    }
    sort_ips_list(&model->ips_list);
    if (!fit_model) {
      *ok = test_ips_space(model);
      return;
    }
    find_offsets_and_marginals(model, find_marginals, &ok_n, &ok_p);
    /*$ifdef TRACE*/
    if (!ok_n && (boolean_option[3] || boolean_option[4] ||
		  boolean_option[5] || boolean_option[21]))
      write_warning(stdout, " Out of space in DoModel: N.", 28L);
    if (!ok_p && (boolean_option[3] || boolean_option[4] ||
		  boolean_option[5] || boolean_option[21]))
      write_warning(stdout, " Out of space in DoModel: P.", 28L);
    /*$endif TRACE*/
    if (!(ok_n && ok_p)) {
      *ok = test_ips_space(model);
      return;
    }
    estimate_p(model);
    model->found_ps = true;
    *ok = true;
    return;
  }
  if (!em) {
    sort_ips_list(&model->ips_list);
    *ok = test_ips_space(model);
  }
}  /* do_model */


Static Void do_em_model(model, ok)
t_model *model;
boolean *ok;
{
  do_model(model, true, true, ok);
}  /* do_em_model */


Static Void do_model_identify(model, ok)
t_model *model;
boolean *ok;
{
  if (!model->found_expression) {
    identify_model(model);
    model->found_expression = true;
    model->found_ps = false;
  }
  *ok = true;
}  /* do_model_identify */


Static Void do_model_to_test(model, ok)
t_model *model;
boolean *ok;
{
  do_model(model, true, true, ok);
}  /* do_model_to_test */


Static Void do_model_fit_values(model, ok)
t_model *model;
boolean *ok;
{
  do_model(model, true, true, ok);
  *ok = (*ok && model->found_ps);
}  /* do_model_fit_values */


Static boolean ok_model_identify(model)
t_model *model;
{
  boolean ok;

  ok = true;
  if (!model->found_expression)
    do_model_identify(model, &ok);
  return ok;
}  /* ok_model_identify */


Static boolean ok_model_to_test(model)
t_model *model;
{
  boolean ok;

  ok = true;
  if (!model->found_ps)
    do_model_to_test(model, &ok);
  return (model->found_ps || ok);
}  /* ok_model_to_test */


Static boolean ok_model_fit_values(model)
t_model *model;
{
  boolean ok;

  ok = true;
  if (!model->found_ps)
    do_model_fit_values(model, &ok);
  return ok;
}  /* ok_model_fit_values */


Static boolean ok_model(model)
t_model *model;
{
  boolean Result, ok;

  ok = ok_model_fit_values(model);
  Result = ok;
  if (!ok && !(permit_log_l && in_test))
    write_pch(stdout, " Out of space", 13L);
  return Result;
}  /* ok_model */


Static boolean ok_current()
{
  return (ok_model(&link_current->model));
}  /* ok_current */


Static boolean ok_base()
{
  return (ok_model(&link_base->model));
}  /* ok_base */


Static boolean ok_model_expression(model)
t_model *model;
{
  boolean Result, ok;

  ok = ok_model_identify(model);
  Result = ok;
  if (!ok)
    write_pch(stdout, " Out of space", 13L);
  return Result;
}  /* ok_model_expression */


Static boolean ok_current_expression()
{
  return (ok_model_expression(&link_current->model));
}  /* ok_current_expression */


Static boolean ok_base_expression()
{
  return (ok_model_expression(&link_base->model));
}  /* ok_base_expression */


Static boolean ok_log_model_silent(model)
t_model *model;
{
  boolean ok;

  ok = true;
  if (model->found_log_l)
    return (ok || permit_log_l);
  if (!model->found_ps)
    do_model_to_test(model, &ok);
  if (ok || permit_log_l)
    model->log_l = compute_log_l(model, model->model_set);
  return (ok || permit_log_l);
}  /* ok_log_model_silent */


Static boolean ok_log_model(model)
t_model *model;
{
  boolean Result, ok;

  ok = ok_log_model_silent(model);
  Result = ok;
  if (!ok)
    write_pch(stdout, " Out of space: Log", 18L);
  return Result;
}  /* ok_log_model */


Static boolean ok_current_log()
{
  return (ok_log_model(&link_current->model));
}  /* ok_current_log */


Static boolean ok_base_log()
{
  return (ok_log_model(&link_base->model));
}  /* ok_base_log */


/*@+"collaps.p"*/


Static t_set_list *return_atoms_from_expression(model)
t_model *model;
{
  t_expression *link_expression;
  t_list_ips_elements *link_ips_list;
  t_list_radim_elements *link_radim_list;
  t_set_list *set_list;

  set_list = NULL;
  link_expression = model->expression;
  while (link_expression != NULL) {
    if (link_expression->factor > 0)
      insert_set_in_set_list(link_expression->vertex_set, &set_list);
    link_expression = link_expression->pointer;
  }
  link_ips_list = model->ips_list;
  while (link_ips_list != NULL) {
    if (!link_ips_list->ips_element.radim_part)
      insert_set_in_set_list(link_ips_list->ips_element.a, &set_list);
    link_ips_list = link_ips_list->pointer;
  }
  link_radim_list = model->radim_list;
  while (link_radim_list != NULL) {
    insert_set_in_set_list(link_radim_list->radim_element.a, &set_list);
    link_radim_list = link_radim_list->pointer;
  }
  return set_list;
}  /* return_atoms_from_expression */


Static Void cut_of_hierarchical(g_c, g_, adj_list, invers_order, c, complete,
				s, r)
t_set_list **g_c;
long *g_;
t_vertex_list **adj_list;
t_vertex *invers_order;
t_vertex_set *c;
uchar *complete;
long *s, *r;
{
  t_vertex_set g;
  t_1_max_dimension i, j;
  t_vertex_set a, b;
  t_vertex u, v;

  P_setcpy(g, g_);
  if (incomplete_table) {
    P_setcpy(r, g);
    return;
  }
  if (P_setequal(s, empty_set)) {
    P_setcpy(r, empty_set);
    return;
  }
  i = 1;
  u = invers_order[i - 1];
  while (!P_inset(u, s)) {
    while ((!(P_getbits_UB(complete, u - MIN_VERTEX, 0, 3) & P_inset(u, g))) &
	   (!P_inset(u, s))) {
      i++;
      u = invers_order[i - 1];
    }
    if (P_inset(u, s))
      break;
    if (subset_of_an_edge(c[u - MIN_VERTEX], g_c)) {
      P_addset(P_expset(b, 0L), u);
      P_setunion(b, b, c[u - MIN_VERTEX]);
      if (subset_of_an_edge(b, g_c)) {
	j = i + 1;
	v = invers_order[j - 1];
	P_addset(P_expset(b, 0L), v);
	P_setunion(b, b, c[v - MIN_VERTEX]);
	while (P_subset(b, c[u - MIN_VERTEX]) & (!P_inset(v, s))) {
	  j++;
	  v = invers_order[j - 1];
	  P_addset(P_expset(b, 0L), v);
	  P_setunion(b, b, c[v - MIN_VERTEX]);
	}
	P_addset(P_expset(a, 0L), u);
	P_setunion(a, a, c[u - MIN_VERTEX]);
	i = j - 1;
	u = invers_order[i - 1];
	P_setdiff(a, a, c[u - MIN_VERTEX]);
      } else
	find_connected_component(g, c[u - MIN_VERTEX], a, &u, adj_list);
      P_setdiff(g, g, a);
    }
    i++;
    u = invers_order[i - 1];
  }
  P_setcpy(r, g);
}  /* cut_of_hierarchical */


Static Void cut_of_graphical(g_, adj_list, adj_set, invers_order, c, complete,
			     s, r)
long *g_;
t_vertex_list **adj_list;
t_vertex_set *adj_set;
t_vertex *invers_order;
t_vertex_set *c;
uchar *complete;
long *s, *r;
{
  t_vertex_set g;
  t_1_max_dimension i, j;
  t_vertex_set a, b;
  t_vertex u, v;

  P_setcpy(g, g_);
  if (incomplete_table) {
    P_setcpy(r, g);
    return;
  }
  if (P_setequal(s, empty_set)) {
    P_setcpy(r, empty_set);
    return;
  }
  i = 1;
  u = invers_order[i - 1];
  while (!P_inset(u, s)) {
    while ((!(P_getbits_UB(complete, u - MIN_VERTEX, 0, 3) & P_inset(u, g))) &
	   (!P_inset(u, s))) {
      i++;
      u = invers_order[i - 1];
    }
    if (P_inset(u, s))
      break;
    if (P_subset(c[u - MIN_VERTEX], adj_set[u - MIN_VERTEX])) {
      j = i + 1;
      v = invers_order[j - 1];
      P_addset(P_expset(b, 0L), v);
      P_setunion(b, b, c[v - MIN_VERTEX]);
      while (P_subset(b, c[u - MIN_VERTEX]) & (!P_inset(v, s))) {
	j++;
	v = invers_order[j - 1];
	P_addset(P_expset(b, 0L), v);
	P_setunion(b, b, c[v - MIN_VERTEX]);
      }
      P_addset(P_expset(a, 0L), u);
      P_setunion(a, a, c[u - MIN_VERTEX]);
      i = j - 1;
      u = invers_order[i - 1];
      P_setdiff(a, a, c[u - MIN_VERTEX]);
    } else
      find_connected_component(g, c[u - MIN_VERTEX], a, &u, adj_list);
    P_setdiff(g, g, a);
    i++;
    u = invers_order[i - 1];
  }
  P_setcpy(r, g);
}  /* cut_of_graphical */


Static Void return_restricted_gc(new_g_c, g_c, a)
t_set_list **new_g_c, **g_c;
long *a;
{
  t_set_list *p;
  t_vertex_set vertex_set;

  p = *g_c;
  while (p != NULL) {
    P_setint(vertex_set, p->vertex_set, a);
    insert_clique(vertex_set, new_g_c);
    p = p->pointer;
  }
}  /* return_restricted_model */


Static Void return_restricted_model(new_model, old_model, a)
t_model *new_model, *old_model;
long *a;
{
  t_set_list *p;
  t_vertex_set vertex_set;

  P_setint(new_model->model_set, a, old_model->model_set);
  p = old_model->sets_h_g_c;
  while (p != NULL) {
    P_setint(vertex_set, p->vertex_set, a);
    insert_clique(vertex_set, &new_model->sets_h_g_c);
    p = p->pointer;
  }
}  /* return_restricted_model */


Static Void do_collapsed_model_from_model(new_model, old_model)
t_model *new_model, *old_model;
{
  t_expression *link_expression, *link_e_old;
  t_list_ips_elements *link_ips_list, *link_i_old;
  boolean b, ok;
  t_ips_element *WITH;

  if (!new_model->found_expression)
    identify_model(new_model);
  new_model->found_expression = true;
  new_model->found_ps = old_model->found_ps;
  link_expression = new_model->expression;
  while (link_expression != NULL) {
    link_e_old = old_model->expression;
    b = false;
    while (link_e_old != NULL && !b) {
      if (P_setequal(link_expression->vertex_set, link_e_old->vertex_set))
	b = true;
      else
	link_e_old = link_e_old->pointer;
    }
    if (!b)
      link_expression->offset = return_offset(link_expression->vertex_set, &ok);
    else
      link_expression->offset = link_e_old->offset;
    link_expression = link_expression->pointer;
  }
  return_ips_list_for_radim_elements(new_model->radim_list,
				     &new_model->ips_list);
  link_ips_list = new_model->ips_list;
  while (link_ips_list != NULL) {
    link_i_old = old_model->ips_list;
    while (!P_setequal(link_ips_list->ips_element.a,
		       link_i_old->ips_element.a))
      link_i_old = link_i_old->pointer;
    WITH = &link_ips_list->ips_element;
    WITH->radim_part = link_i_old->ips_element.radim_part;
    WITH->p_offset = link_i_old->ips_element.p_offset;
    link_ips_list = link_ips_list->pointer;
  }
}  /* do_collapsed_model_from_model */


Static Void clear_offsets(new_model)
t_model *new_model;
{
  t_list_ips_elements *link_ips_list;

  link_ips_list = new_model->ips_list;
  while (link_ips_list != NULL) {
    link_ips_list->ips_element.p_offset = MAX_OFFSET;
    link_ips_list = link_ips_list->pointer;
  }
}  /* clear_offsets */


/* Local variables for return_collaps_set: */
struct LOC_return_collaps_set {
  t_v_arr_of_order order;
  t_v_arr_of_v_sets c;
  t_v_arr_of_boolean complete;
} ;

Local Void print_order_(LINK)
struct LOC_return_collaps_set *LINK;
{
  t_vertex v, FORLIM;

  write_line(stdout);
  write_space(stdout, 2L);
  write_char(stdout, 'V');
  write_pch(stdout, "  ", 2L);
  write_pch(stdout, " Order(V) ", 10L);
  write_space(stdout, 2L);
  write_pch(stdout, "C(V)", 4L);
  write_space(stdout, dimension - 2L);
  write_pch(stdout, "Complete(V)  ", 13L);
  write_line(stdout);
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    write_space(stdout, 2L);
    print_vertex_on_file(stdout, v);
    write_pch(stdout, ": ", 2L);
    write_integer(stdout, (long)LINK->order[v - MIN_VERTEX], 10L);
    write_space(stdout, 3L);
    print_vertex_set_table_full(LINK->c[v - MIN_VERTEX]);
    write_boolean(stdout, P_getbits_UB(LINK->complete, v - MIN_VERTEX, 0, 3));
    write_line(stdout);
  }
}  /* print_order */


Static Void return_collaps_set(a, g, g_c, graphical, atoms_list, r)
long *a, *g;
t_set_list **g_c;
boolean *graphical;
t_set_list **atoms_list;
long *r;
{
  struct LOC_return_collaps_set Local_Var;
  t_o_arr_of_vertex invers_order;
  t_v_arr_of_v_lists fill_in_adj_list, adj_list;
  t_v_arr_of_v_sets adj_set;
  t_vertex v, FORLIM;

  if (P_setequal(a, g) || em) {
    P_setcpy(r, g);
    return;
  }
  if (subset_of_an_edge(a, g_c) && !incomplete_table) {
    P_setcpy(r, a);
    return;
  }
  hypergraph_sets_to_graph_sets(*g_c, g, adj_set);
  adj_set_to_adj_list(adj_set, adj_list);
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++)
    fill_in_adj_list[v - MIN_VERTEX] = NULL;
  marked_lex_m(a, adj_list, Local_Var.order, invers_order, fill_in_adj_list);
  find_c(adj_set, Local_Var.order, invers_order, fill_in_adj_list,
	 Local_Var.c, Local_Var.complete);
  /*$ifdef TRACE*/
  if (boolean_option[22])
    print_order_(&Local_Var);
  /*$endif TRACE*/
  dispose_adj_list(fill_in_adj_list);
  if (*graphical)
    cut_of_graphical(g, adj_list, adj_set, invers_order, Local_Var.c,
		     Local_Var.complete, a, r);
  else
    cut_of_hierarchical(g_c, g, adj_list, invers_order, Local_Var.c,
			Local_Var.complete, a, r);
  /*$ifdef TRACE*/
  if (boolean_option[22])
    print_vertex_set(r);
  /*$endif TRACE*/
  P_setunion(r, r, a);
  dispose_adj_list(adj_list);
}  /* return_collaps_set */


Static boolean collaps_model(a, model, new_model)
long *a;
t_model *model, *new_model;
{
  t_vertex_set r;
  t_set_list *p_list;

  p_list = return_atoms_from_expression(model);
  return_collaps_set(a, model->model_set, &model->sets_h_g_c,
		     &model->graphical, &p_list, r);
  dispose_set_list(&p_list);
  if (!P_setequal(r, model->model_set)) {
    erase_model(new_model);
    return_restricted_model(new_model, model, r);
    if (!large)
      do_collapsed_model_from_model(new_model, model);
    return true;
  } else
    return false;
}  /* collaps_model */


Static boolean return_connected_component(b, g_c, components)
long *b;
t_set_list **g_c, **components;
{
  t_v_arr_of_v_sets adj_set;
  t_v_arr_of_v_lists adj_list;
  t_vertex_set g, d, a;
  t_vertex u;

  hypergraph_sets_to_graph_sets(*g_c, g, adj_set);
  adj_set_to_adj_list(adj_set, adj_list);
  u = first_vertex;
  P_setint(d, b, g);
  while (!P_inset(u, d) && u < last_vertex)
    u++;
  P_setcpy(a, empty_set);
  if (P_inset(u, d))
    find_connected_component(g, empty_set, a, &u, adj_list);
  *components = NULL;
  insert_set_in_set_list(a, components);
  dispose_adj_list(adj_list);
  return P_subset(b, a);
}  /* return_connected_component */


Static boolean return_connected_components(g_c, components)
t_set_list **g_c, **components;
{
  t_v_arr_of_v_sets adj_set;
  t_v_arr_of_v_lists adj_list;
  t_vertex_set g, a;
  t_vertex u;

  hypergraph_sets_to_graph_sets(*g_c, g, adj_set);
  adj_set_to_adj_list(adj_set, adj_list);
  *components = NULL;
  while (!P_setequal(g, empty_set)) {
    u = first_vertex;
    while (!P_inset(u, g))
      u++;
    P_setcpy(a, empty_set);
    find_connected_component(g, empty_set, a, &u, adj_list);
    insert_set_in_set_list(a, components);
    P_setdiff(g, g, a);
  }
  dispose_adj_list(adj_list);
}  /* return_connected_components */


Static Void return_boundary(s, bd, g_c)
long *s, *bd;
t_set_list **g_c;
{
  t_vertex_set a;
  t_set_list *p;

  P_setcpy(bd, empty_set);
  p = *g_c;
  while (p != NULL) {
    P_setint(a, p->vertex_set, s);
    if (!P_setequal(a, empty_set))
      P_setunion(bd, bd, p->vertex_set);
    p = p->pointer;
  }
  P_setdiff(bd, bd, s);
}  /* return_boundary */


Static boolean marginalize_model(r, old_g_c, a, new_g_c)
long *r;
t_set_list **old_g_c;
long *a;
t_set_list **new_g_c;
{
  t_set_list *p, *g_c_b, *cc;
  t_vertex_set b;

  P_setdiff(b, r, a);
  /*$ifdef TRACE*/
  if (boolean_option[27]) {
    write_char(stdout, '[');
    print_vertex_set(a);
    write_char(stdout, ':');
    write_char(stdout, 'O');
    write_char(stdout, ':');
    print_g_c(*old_g_c, 0L, line_length);
    write_char(stdout, ']');
    write_line(stdout);
  }
  /*$endif TRACE*/
  *new_g_c = NULL;
  return_restricted_gc(new_g_c, old_g_c, a);
  g_c_b = NULL;
  return_restricted_gc(&g_c_b, old_g_c, b);
  return_connected_components(&g_c_b, &cc);
  /*$ifdef TRACE*/
  if (boolean_option[27]) {
    write_char(stdout, '[');
    write_char(stdout, 'N');
    write_char(stdout, ':');
    print_g_c(*new_g_c, 0L, line_length);
    write_char(stdout, 'B');
    write_char(stdout, ':');
    print_g_c(g_c_b, 0L, line_length);
    write_char(stdout, 'C');
    write_char(stdout, ':');
    print_g_c(cc, 0L, line_length);
    write_char(stdout, ']');
    write_line(stdout);
  }
  /*$endif TRACE*/
  p = cc;
  while (p != NULL) {
    return_boundary(p->vertex_set, b, old_g_c);
    P_setdiff(b, b, p->vertex_set);
    /*$ifdef TRACE*/
    if (boolean_option[27]) {
      write_char(stdout, '[');
      print_vertex_set(p->vertex_set);
      print_vertex_set(b);
      write_char(stdout, ']');
      write_line(stdout);
    }
    /*$endif TRACE*/
    insert_clique(b, new_g_c);
    p = p->pointer;
  }
  /*$ifdef TRACE*/
  if (boolean_option[27]) {
    write_char(stdout, '[');
    write_char(stdout, 'N');
    write_char(stdout, ':');
    print_g_c(*new_g_c, 0L, line_length);
    write_char(stdout, ']');
    write_line(stdout);
  }
  /*$endif TRACE*/
  dispose_set_list(&g_c_b);
  dispose_set_list(&cc);
}  /* marginalize_model */


/*@-"df.c"*/
/*@+"df.p"*/


Static boolean is_zero_p_em(x)
float *x;
{
  t_long_real y;

  /*$ifdef TRACE*/
  if (boolean_option[10]) {
    y = *x;
    write_real(stdout, y, 10L, 5L);
  }
  /*$endif TRACE*/
  return (*x <= 1e-10);   /* ROUND_ERROR */
  /* 1E-10 */
  /* 1E-3 */
}  /* is_zero_p_em */


Static boolean is_zero_p_fast(model)
t_model *model;
{
  boolean not_zero;
  t_expression *link_expression;
  t_list_ips_elements *link_ips_list;

  not_zero = true;
  link_expression = model->expression;
  while (link_expression != NULL && not_zero) {
    if (em) {
      if (is_zero_p_em(&p[link_expression->offset]))
	not_zero = false;
    } else if (n[link_expression->offset] == 0)
      not_zero = false;
    link_expression = link_expression->pointer;
  }
  link_ips_list = model->ips_list;
  while (link_ips_list != NULL && not_zero) {
    if (is_zero_p_em(&p[link_ips_list->ips_element.p_offset]))
      not_zero = false;
    link_ips_list = link_ips_list->pointer;
  }
  return (!not_zero);
}  /* is_zero_p_fast */


Static boolean is_zero_p(i, model)
t_level *i;
t_model *model;
{
  boolean not_zero;
  t_expression *link_expression;
  t_list_ips_elements *link_ips_list;

  not_zero = true;
  link_expression = model->expression;
  while (link_expression != NULL && not_zero) {
    if (em) {
      if (is_zero_p_em(&p[marginal_hash(link_expression->vertex_set, i) +
			  link_expression->offset]))
	not_zero = false;
    } else if (n[marginal_hash(link_expression->vertex_set, i) +
		 link_expression->offset] == 0)
      not_zero = false;
    link_expression = link_expression->pointer;
  }
  link_ips_list = model->ips_list;
  while (link_ips_list != NULL && not_zero) {
    if (is_zero_p_em(&p[link_ips_list->ips_element.p_offset +
			marginal_hash(link_ips_list->ips_element.a, i)]))
      not_zero = false;
    link_ips_list = link_ips_list->pointer;
  }
  return (!not_zero);
}  /* is_zero_p */


Static boolean is_zero_m_p(a, i, model)
long *a;
t_level *i;
t_model *model;
{
  t_vertex_set d_a;
  t_vertex v;
  t_cell_count index, index_stop;
  boolean p_a;
  t_vertex FORLIM;

  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    if (!P_inset(v, a))
      i[v - MIN_VERTEX] = FIRST_LEVEL;
  }
  index = 1;
  p_a = is_zero_p(i, model);
  P_setdiff(d_a, delta, a);
  P_setint(d_a, d_a, model->model_set);
  index_stop = marginal_dimension(d_a);
  while (index < index_stop && p_a) {
    index++;
    next_marginal_cell(d_a, i);
    p_a = is_zero_p(i, model);
  }
  return p_a;
}  /* is_zero_m_p */


Static Void put_dim_factor(link_expression, a, factor)
t_expression **link_expression;
long *a;
long factor;
{
  t_expression *p, *q;
  boolean b;

  if (*link_expression == NULL) {
    insert_factor_in_expression(a, &factor, link_expression);
    return;
  }
  b = true;
  p = *link_expression;
  q = p;
  while (p != NULL && b) {
    if (P_setequal(a, p->vertex_set))
      b = false;
    else {
      q = p;
      p = p->pointer;
    }
  }
  if (b) {
    insert_factor_in_expression(a, &factor, &p);
    q->pointer = p;
    return;
  }
  p->factor += factor;
  if (p->factor != 0)
    return;
  if (q == p) {
    *link_expression = p->pointer;
    Free(p);
  } else {
    q->pointer = p->pointer;
    Free(p);
  }
}  /* put_dim_factor */


Static Void find_dimension_list(gc, sign, dimension_list)
t_set_list **gc;
long sign;
t_expression **dimension_list;
{
  t_set_list *p, *gc_e;
  t_vertex_set c, vertex_set;

  if ((*gc)->pointer == NULL) {
    put_dim_factor(dimension_list, (*gc)->vertex_set, sign);
    return;
  }
  gc_e = NULL;
  p = (*gc)->pointer;
  P_setcpy(c, (*gc)->vertex_set);
  while (p != NULL) {
    P_setint(vertex_set, c, p->vertex_set);
    insert_clique(vertex_set, &gc_e);
    p = p->pointer;
  }
  put_dim_factor(dimension_list, (*gc)->vertex_set, sign);
  find_dimension_list(&(*gc)->pointer, sign, dimension_list);
  find_dimension_list(&gc_e, -sign, dimension_list);
  dispose_set_list(&gc_e);
}  /* find_dimension_list */


Static t_expression *return_dimension_list(model)
t_model *model;
{
  t_expression *link_expression, *q;
  t_list_ips_elements *link_ips_list;
  t_list_radim_elements *link_radim_list;
  t_ips_set_list *link_clique;
  t_set_list *p;
  t_ips_element *WITH;
  t_radim_element *WITH1;

  q = NULL;
  link_expression = model->expression;
  while (link_expression != NULL) {
    put_dim_factor(&q, link_expression->vertex_set, link_expression->factor);
    link_expression = link_expression->pointer;
  }
  link_ips_list = model->ips_list;
  while (link_ips_list != NULL) {
    if (!link_ips_list->ips_element.radim_part) {
      p = NULL;
      WITH = &link_ips_list->ips_element;
      link_clique = WITH->gen_class;
      while (link_clique != NULL) {
	insert_clique(link_clique->vertex_set, &p);
	link_clique = link_clique->pointer;
      }
      find_dimension_list(&p, 1L, &q);
      dispose_set_list(&p);
    }
    link_ips_list = link_ips_list->pointer;
  }
  link_radim_list = model->radim_list;
  while (link_radim_list != NULL) {
    p = NULL;
    WITH1 = &link_radim_list->radim_element;
    link_clique = WITH1->gen_class;
    while (link_clique != NULL) {
      insert_clique(link_clique->vertex_set, &p);
      link_clique = link_clique->pointer;
    }
    find_dimension_list(&p, 1L, &q);
    dispose_set_list(&p);
    link_radim_list = link_radim_list->pointer;
  }
  return q;
}  /* return_dimension_list */


Static long count_zeros_in_one_table(a, c, only_one, new_model)
long *a, *c;
boolean only_one;
t_model *new_model;
{
  t_integer pos, index_1, index_2, index_s, count_0;
  t_cell i;
  t_vertex_set c_a;
  t_product_list *link_prod_list;
  t_v_arr_of_integer levels;
  t_vertex l_a_vertex;
  long FORLIM;

  count_0 = 0;
  memcpy(i, first_cell, sizeof(t_cell));
  if (P_setequal(a, c) && only_one) {
    find_product_list(a, new_model, &link_prod_list, levels, &l_a_vertex);
    add_to_offsets(new_model, (long)FIRST_INDEX);
    FORLIM = marginal_dimension(a);
    for (index_1 = 1; index_1 <= FORLIM; index_1++) {
      /*$ifdef TRACE*/
      if (boolean_option[10])
	write_integer(stdout, count_0, 4L);
      /*$endif TRACE*/
      if (is_zero_p_fast(new_model)) {
	count_0++;
	/*$ifdef TRACE*/
	if (boolean_option[10])
	  write_pch(stdout, " * ", 3L);
	/*$endif TRACE*/
      }
      /*$ifdef TRACE*/
      if (boolean_option[10])
	write_line(stdout);
      /*$endif TRACE*/
      next_offset_in_exp_list(new_model, &link_prod_list, levels, &l_a_vertex,
			      i);
    }
    add_to_offsets(new_model, (long)(-FIRST_INDEX));
    dispose_product_list(&link_prod_list);
    return count_0;
  }
  if (last_index(c) <= max_p_cell_number - fpa) {
    P_setdiff(c_a, c, a);
    index_s = marginal_dimension(c_a);
    FORLIM = marginal_dimension(a);
    for (index_1 = 1; index_1 <= FORLIM; index_1++) {
      pos = fpa + marginal_hash(c, i);
      index_2 = 1;
      while ((index_2 < index_s) & is_zero_p_em(&p[pos])) {
	index_2++;
	next_marginal_cell(c_a, i);
	pos = fpa + marginal_hash(c, i);
      }
      if (is_zero_p_em(&p[pos]))
	count_0++;
      next_marginal_cell(a, i);
    }
    return count_0;
  }
  FORLIM = marginal_dimension(a);
  for (index_1 = 1; index_1 <= FORLIM; index_1++) {
    if (is_zero_m_p(a, i, new_model))
      count_0++;
    next_marginal_cell(a, i);
  }
  return count_0;
}  /* count_zeros_in_one_table */


Static long count_zeros_in_several_tables(c, set_list, c_model, ok)
long *c;
t_expression **set_list;
t_model *c_model;
boolean *ok;
{
  t_expression *q;
  t_integer index_1, count_0;
  t_model new_model;
  t_cell i;
  t_product_list *link_prod_list;
  t_v_arr_of_integer levels;
  t_vertex l_a_vertex;
  boolean dummy;
  t_offset n_offset, m_offset;
  long FORLIM, TEMP;

  count_0 = 0;
  /*$ifdef TRACE*/
  if (boolean_option[10]) {
    write_pch(stdout, " CountZerosInSeveralTables, ", 28L);
    write_pch(stdout, " on:", 4L);
    print_vertex_set_table(c);
    write_line(stdout);
  }
  /*$endif TRACE*/
  if (P_setequal(c, empty_set))
    return count_0;
  if (!P_setequal(c, c_model->model_set) && !em) {
    erase_model(&new_model);
    return_restricted_model(&new_model, c_model, c);
    if (!large)
      do_collapsed_model_from_model(&new_model, c_model);
  } else
    new_model = *c_model;
  if (large && !new_model.found_ps) {
    new_model.expression = NULL;
    new_model.ips_list = NULL;
    new_model.radim_list = NULL;
    *ok = ok_model_fit_values(&new_model);
    test_expression_marginals_one(&new_model, new_model.model_set, ok);
    /*$ifdef TRACE*/
    if (!*ok && boolean_option[10]) {
      /*$endif TRACE*/
      write_warning(stdout, " Out of space in count zero.", 28L);
    }
  }
  if (*ok) {
    if (!TURBO_PC)
      dummy = space_in_p_array(marginal_dimension(c), fpa);
    if (last_index(c) <= max_p_cell_number - fpa &&
	!(P_setequal((*set_list)->vertex_set, c) &&
	  (*set_list)->pointer == NULL)) {
      memcpy(i, first_cell, sizeof(t_cell));
      find_product_list(c, &new_model, &link_prod_list, levels, &l_a_vertex);
      add_to_offsets(&new_model, (long)FIRST_INDEX);
      FORLIM = last_index(c);
      for (index_1 = FIRST_INDEX; index_1 <= FORLIM; index_1++) {
	if (is_zero_p_fast(&new_model))
	  p[fpa + index_1] = 0.0;
	else
	  p[fpa + index_1] = 1.0;
	next_offset_in_exp_list(&new_model, &link_prod_list, levels,
				&l_a_vertex, i);
      }
      add_to_offsets(&new_model, (long)(-FIRST_INDEX));
      dispose_product_list(&link_prod_list);
    }
    q = *set_list;
    while (q != NULL) {
      /*$ifdef TRACE*/
      if (boolean_option[10]) {
	write_pch(stdout, " Several: ", 10L);
	print_vertex_set_table(q->vertex_set);
	write_integer(stdout, q->factor, 4L);
	n_offset = fpa;
	m_offset = fpa;
	TEMP = 2;
	/* print_table(q^.vertex_set, nil, 0,
	              false, false, false, n_offset,
	              n[0], m_offset, new_model); */
	print_table(q->vertex_set, NULL, &TEMP, false, false, false,
		    &n_offset, (double)n[0], &m_offset, &new_model);
	write_line(stdout);
      }
      /*$endif TRACE*/
      count_0 += q->factor * count_zeros_in_one_table(q->vertex_set, c,
		   (*set_list)->pointer == NULL, &new_model);
      /*$ifdef TRACE*/
      if (boolean_option[10]) {
	write_integer(stdout, count_0, 4L);
	write_line(stdout);
      }
      /*$endif TRACE*/
      q = q->pointer;
    }
  }
  if (P_setequal(c, c_model->model_set))
    return count_0;
  if (!large)
    clear_offsets(&new_model);
  dispose_model(&new_model);
  return count_0;
}  /* count_zeros_in_several_tables */


typedef struct t_set_set_list {
  t_vertex_set vertex_set;
  t_expression *set_list;
  struct t_set_set_list *pointer;
} t_set_set_list;


Local Void find_several_collaps_sets(p, g, g_c, graphical, atoms_list,
				     collaps_list)
t_expression *p;
long *g;
t_set_list **g_c;
boolean *graphical;
t_set_list **atoms_list;
t_set_set_list **collaps_list;
{
  t_vertex_set a, r, vertex_set;
  boolean b;
  t_set_set_list *p_coll;

  while (p != NULL) {
    P_setcpy(a, p->vertex_set);
    P_setint(vertex_set, a, g);
    return_collaps_set(vertex_set, g, g_c, graphical, atoms_list, r);
    P_setunion(r, a, r);
    p_coll = *collaps_list;
    b = true;
    while (p_coll != NULL && b) {
      if (P_setequal(r, p_coll->vertex_set))
	b = false;
      else
	p_coll = p_coll->pointer;
    }
    if (p_coll == NULL) {
      p_coll = (t_set_set_list *)Malloc(sizeof(t_set_set_list));
      if (p_coll == NULL)
	_OutMem();
      p_coll->pointer = *collaps_list;
      p_coll->set_list = NULL;
      P_setcpy(p_coll->vertex_set, r);
      *collaps_list = p_coll;
    }
    insert_factor_in_expression(a, &p->factor, &p_coll->set_list);
    p = p->pointer;
  }
}  /* find_several_collaps_sets */


Static long count_zero_par(c_model, b_model)
t_model *c_model, *b_model;
{
  boolean ok;
  t_set_set_list *p_coll, *collaps_list;
  t_set_list *atoms_list;
  t_expression *sufficient_marginals;
  t_integer count_0;

  ok = true;
  sufficient_marginals = return_dimension_list(b_model);
  atoms_list = return_atoms_from_expression(c_model);
  collaps_list = NULL;
  /*$ifdef TRACE*/
  if (boolean_option[10]) {
    write_pch(stdout, " # Expected 0-parameters in Base:       ", 40L);
    write_line(stdout);
    write_pch(stdout, " Modelset:", 10L);
    print_vertex_set_table(c_model->model_set);
    write_line(stdout);
  }
  /*$endif TRACE*/
  find_several_collaps_sets(sufficient_marginals, b_model->model_set,
			    &c_model->sets_h_g_c, &c_model->graphical,
			    &atoms_list, &collaps_list);
  dispose_set_list(&atoms_list);
  count_0 = 0;
  while (collaps_list != NULL && (ok || boolean_option[10]) && !interrupt_1) {
    /*$ifdef TRACE*/
    /*$endif TRACE*/
    count_0 += count_zeros_in_several_tables(collaps_list->vertex_set,
	&collaps_list->set_list, c_model, &ok);
    dispose_expression(&collaps_list->set_list);
    p_coll = collaps_list;
    collaps_list = collaps_list->pointer;
    Free(p_coll);
  }
  if (interrupt_1) {
    interrupt_1 = false;
    write_warning(stdout, " Interrupt in count zero.", 25L);
  }
  while (collaps_list != NULL) {
    dispose_expression(&collaps_list->set_list);
    p_coll = collaps_list;
    collaps_list = collaps_list->pointer;
    Free(p_coll);
  }
  /*$ifdef TRACE*/
  if (boolean_option[10])
    write_line(stdout);
  /*$endif TRACE*/
  dispose_expression(&sufficient_marginals);
  if (ok)
    return count_0;
  else
    return INFINITY;
}  /* count_zero_par */


Static long count_zero_n(model)
t_model *model;
{
  boolean ok;
  t_long_real log_l;
  t_long_integer count_zero;
  t_expression *p1, *set_list;
  t_e_cell_index index;
  t_offset m_offset, n_offset;
  long TEMP;
  t_e_cell_index FORLIM;

  /*$ifdef TRACE*/
  if (boolean_option[10]) {
    write_pch(stdout, " CountZeroN, ", 13L);
    write_pch(stdout, " # 0-parameters:    ", 20L);
    write_line(stdout);
  }
  /*$endif TRACE*/
  set_list = return_dimension_list(model);
  count_zero = 0;
  p1 = set_list;
  ok = true;
  if (em) {
    m_offset = fpa;
    if (!TURBO_PC)
      ok = space_in_p_array(last_index(model->model_set), m_offset);
    if (last_index(model->model_set) <= max_p_cell_number - m_offset)
      find_expected_table(model->model_set, m_offset, model, &log_l, false,
			  false);
  }
  while (p1 != NULL && ok && !interrupt_1) {
    if (em) {
      n_offset = m_offset + marginal_dimension(model->model_set);
      if (!P_setequal(model->model_set, p1->vertex_set)) {
	if (!TURBO_PC)
	  ok = space_in_p_array(last_index(p1->vertex_set), n_offset);
	if (last_index(p1->vertex_set) <= max_p_cell_number - n_offset) {
	  if (false)
	    find_expected_table(p1->vertex_set, n_offset, model, &log_l,
				false, false);
	  else
	    find_marginal_expected_table(p1->vertex_set, model->model_set,
					 n_offset, m_offset);
	} else
	  ok = false;
      } else
	n_offset = m_offset;
      ok = (n_offset + marginal_dimension(p1->vertex_set) < max_p_cell_number);
    } else
      n_offset = return_offset(p1->vertex_set, &ok);
    /*$ifdef TRACE*/
    if (!ok && boolean_option[10])
      write_warning(stdout, " Out of space in Count Zero N.", 30L);
    /*$endif TRACE*/
    /*$ifdef TRACE*/
    if (boolean_option[10]) {
      write_pch(stdout, " Marginal:", 10L);
      print_vertex_set_table(p1->vertex_set);
      write_integer(stdout, p1->factor, 4L);
      TEMP = 0;
      print_table(p1->vertex_set, NULL, &TEMP, false, false, false, &n_offset,
		  (double)n[0], &m_offset, model);
    }
    /*$endif TRACE*/
    if (ok) {
      if (em) {
	FORLIM = n_offset + last_index(p1->vertex_set);
	for (index = n_offset; index <= FORLIM; index++) {
	  if (is_zero_p_em(&p[index]))
	    count_zero += p1->factor;
	}
      } else {
	FORLIM = n_offset + last_index(p1->vertex_set);
	for (index = n_offset; index <= FORLIM; index++) {
	  if (n[index] == 0)
	    count_zero += p1->factor;
	}
      }
    }
    /*$ifdef TRACE*/
    if (boolean_option[10]) {
      write_integer(stdout, count_zero, 6L);
      write_line(stdout);
    }
    /*$endif TRACE*/
    if (large)
      dispose_marginals();
    p1 = p1->pointer;
  }
  if (interrupt_1) {
    interrupt_1 = false;
    write_warning(stdout, " Interrupt in count zero N.", 27L);
  }
  /*$ifdef TRACE*/
  if (boolean_option[10])
    write_line(stdout);
  /*$endif TRACE*/
  dispose_expression(&set_list);
  if (ok)
    return count_zero;
  else
    return INFINITY;
}  /* count_zero_n */


/*@-"exact.c"*/
/*@+"patef.p"*/


Static long set_n_of_tables(test, ordinal, n_of_tables)
t_test *test;
boolean ordinal;
long *n_of_tables;
{
  long Result;
  t_long_integer i;
  t_two_integers_list *p;

  if (ordinal)
    i = (long)floor(test->mcep_gamma_2 + 0.5);
  else if (!exact_log_l) {
    switch (test_choice) {

    case 1:
      i = (long)floor(test->mcep_deviance + 0.5);
      break;

    case 2:
      i = (long)floor(test->mcep_pearson + 0.5);
      break;

    case 3:
      i = (long)floor(test->mcep_power + 0.5);
      break;
    }
  } else
    i = (long)floor(test->mcep_deviance + 0.5);
  if (link_n_of_tables != NULL) {
    if (*n_of_tables < init_n_of_tables)
      return init_n_of_tables;
    else {
      p = link_n_of_tables;
      while (p->pointer != NULL && p->a < i)
	p = p->pointer;
      if (i <= p->a)
	return (p->b);
      else
	return init_n_of_tables;
    }
  }
  if (i > 8 || *n_of_tables < 20)
    return 20;
  switch (i) {

  case 0:
  case 1:
  case 2:
    Result = 1000;
    break;

  case 3:
  case 4:
  case 5:
    Result = 200;
    break;

  case 6:
  case 7:
  case 8:
    Result = 100;
    break;
  }
  return Result;
}  /* set_n_of_tables */


Static Void trace_add_term(index_1, index_2, n_total, m, n1, n2, p1, p2,
			   ln_p2_p1, x_deviance, x_power, x_pearson)
long index_1, index_2, n_total, m, n1, n2;
double p1, p2, ln_p2_p1, x_deviance, x_power, x_pearson;
{
  write_char(stdout, ':');
  write_char(stdout, '2');
  write_integer(stdout, index_1, 4L);
  write_integer(stdout, index_2, 4L);
  write_integer(stdout, n_total, 10L);
  write_integer(stdout, m, 10L);
  write_integer(stdout, n1, 10L);
  write_integer(stdout, n2, 10L);
  write_space(stdout, 2L);
  write_real(stdout, p1, 8L, 5L);
  write_real(stdout, p2, 8L, 5L);
  write_real(stdout, ln_p2_p1, 10L, 5L);
  write_space(stdout, 2L);
  write_real(stdout, x_deviance, 11L, 6L);
  write_real(stdout, x_power, 11L, 6L);
  write_real(stdout, x_pearson, 11L, 6L);
  write_line(stdout);
}  /* trace_add_term */


#define precision       2e-16


Local long find_count(dummy, ia, ib, ic, id, ie, ii, nlm)
long *dummy, *ia, *ib, *ic, *id, *ie, *ii, *nlm;
{
  t_long_integer nll, flip;
  boolean up;
  t_long_real rand, sumprb, x, y, ia_, id_, ii_, nlm_, nll_;

  sumprb = 1.0;
  do {
    rand = sumprb * uniform(dummy);
    *nlm = (long)floor((double)(*ia) / *ie * *id + 0.5);
    sumprb = exp(log_fact(*ia) + log_fact(*ib) + log_fact(*ic) +
		 log_fact(*id) - log_fact(*ie) - log_fact(*nlm) - log_fact(
		   *id - *nlm) - log_fact(*ia - *nlm) - log_fact(*ii + *nlm));
    /*$ifdef TRACE*/
    if (boolean_option[13]) {
      write_char(stdout, ':');
      write_char(stdout, '1');
      write_integer(stdout, *nlm, 4L);
      write_real(stdout, rand, 12L, 5L);
      write_real(stdout, sumprb, 12L, 5L);
    }
    /*$endif TRACE*/
    if (sumprb < rand) {
      x = sumprb;
      y = x;
      nll = *nlm;
      up = true;
      flip = 0;
      ia_ = *ia;
      id_ = *id;
      ii_ = *ii;
      sumprb -= rand;
      do {
	if (up) {
	  if (flip == 0)
	    up = !up;
	  if (*id == *nlm || *ia == *nlm)
	    flip++;
	  else {
	    /*$ifdef TRACE*/
	    if (boolean_option[13])
	      write_char(stdout, '+');
	    /*$endif TRACE*/
	    nlm_ = *nlm;
	    x *= (id_ - nlm_) * (ia_ - nlm_);
	    nlm_ += 1.0;
	    x /= nlm_ * (ii_ + nlm_);
	    (*nlm)++;
	    /*$ifdef TRACE*/
	    if (boolean_option[13])
	      write_real(stdout, x, 12L, 5L);
	    /*$endif TRACE*/
	    if (x < fabs(sumprb) * precision)
	      flip++;
	    sumprb += x;
	  }
	} else {
	  if (flip == 0)
	    up = !up;
	  if (nll == 0 || *ii + nll == 0)
	    flip++;
	  else {
	    /*$ifdef TRACE*/
	    if (boolean_option[13])
	      write_char(stdout, '-');
	    /*$endif TRACE*/
	    nll_ = nll;
	    y *= nll_ * (ii_ + nll_);
	    nll_ -= 1.0;
	    y /= (id_ - nll_) * (ia_ - nll_);
	    nll--;
	    /*$ifdef TRACE*/
	    if (boolean_option[13])
	      write_real(stdout, y, 12L, 5L);
	    /*$endif TRACE*/
	    if (y < fabs(sumprb) * precision)
	      flip++;
	    sumprb += y;
	  }
	}
      } while (sumprb < 0 && flip != 2);
      sumprb += rand;
      if (flip == 1 && !up || flip == 0 && up)
	*nlm = nll;
    }
    /*$ifdef TRACE*/
    if (boolean_option[13]) {
      write_char(stdout, ':');
      write_integer(stdout, *nlm, 4L);
      write_line(stdout);
    }
    /*$endif TRACE*/
  } while (sumprb < rand);
  return (*nlm);
}  /* find_count */

/* Local variables for as_159: */
struct LOC_as_159 {
  long *nrowpos, *ncolpos;
  long (*nmatpos)[MAX_LEVEL];
} ;

Local Void add_term(m, n1, n2, n_total, minus_log_q, x_power, x_pearson, LINK)
long m, n1, n2, n_total;
double *minus_log_q, *x_power, *x_pearson;
struct LOC_as_159 *LINK;
{
  t_long_real ln_p2_p1, p1, p2, x;
  double TEMP;

  if (exact_log_l) {
    if (m != 0)
      *minus_log_q += m * log((double)m / n1 * ((double)n_total / n2));
  } else {
    x = 1.0 / n_total;
    p1 = n1 * x;
    p1 *= n2 * x;
    p2 = m * x;
    if (p1 != 0) {
      x = 1 / p1;
      TEMP = p1 - p2;
      *x_pearson += n_total * (TEMP * TEMP) * x;
    }
    if (m != 0) {
      ln_p2_p1 = log(p2 * x);
      *minus_log_q += m * ln_p2_p1;
      *x_power += n_total * p2 * (exp(ln_p2_p1 * lambda) - 1);
    }
  }
  /*$ifdef TRACE*/
  if (boolean_option[14]) {
    /*$endif TRACE*/
    trace_add_term(-1L, -1L, n_total, m, n1, n2, p1, p2, ln_p2_p1,
		   *minus_log_q, *x_power, *x_pearson);
  }
}  /* add_term */

Local Void apply_count(return_n, index_1, index_2, mcount, ntotal,
		       minus_log_q, x_power, x_pearson, LINK)
boolean return_n;
long index_1, index_2, mcount, *ntotal;
double *minus_log_q, *x_power, *x_pearson;
struct LOC_as_159 *LINK;
{
  /*$ifdef TRACE*/
  if (boolean_option[14])
    trace_add_term(index_1, index_2,
		   n[LINK->nmatpos[index_1 - 1][index_2 - 1]], mcount,
		   n[LINK->nrowpos[index_1 - 1]],
		   n[LINK->ncolpos[index_2 - 1]], -1.0, -1.0, -1.0, -1.0,
		   -1.0, -1.0);
  /*$endif TRACE*/
  if (return_n)
    n[LINK->nmatpos[index_1 - 1][index_2 - 1]] = mcount;
  else
    add_term(mcount, n[LINK->nrowpos[index_1 - 1]],
	     n[LINK->ncolpos[index_2 - 1]], *ntotal, minus_log_q, x_power,
	     x_pearson, LINK);
}  /* apply_count */

Local Void as_159(nrow, ncol, nrowpos_, ncolpos_, nmatpos_, dummy, ntotal,
		  return_n, minus_log_q, x_power, x_pearson)
long *nrow, *ncol;
long *nrowpos_, *ncolpos_;
long (*nmatpos_)[MAX_LEVEL];
long *dummy, *ntotal;
boolean return_n;
double *minus_log_q, *x_power, *x_pearson;
{
  struct LOC_as_159 Local_Var;
  t_integer nrowtl, ncolm, nrowm;
  t_long_integer j, l, m, ia, ib, ic, id, ie, ii, jc, nlm;
  t_level_arr_of_integer jwork;
  long FORLIM, FORLIM1;

  Local_Var.nrowpos = nrowpos_;
  Local_Var.ncolpos = ncolpos_;
  Local_Var.nmatpos = nmatpos_;
  *ntotal = 0;
  FORLIM = *ncol;
  for (j = 0; j < FORLIM; j++)
    *ntotal += n[Local_Var.ncolpos[j]];
  nrowm = *nrow - 1;
  ncolm = *ncol - 1;
  for (j = 0; j < ncolm; j++)
    jwork[j] = n[Local_Var.ncolpos[j]];
  jc = *ntotal;
  for (l = 1; l <= nrowm; l++) {
    nrowtl = n[Local_Var.nrowpos[l - 1]];
    ia = nrowtl;
    ic = jc;
    jc -= nrowtl;
    m = 0;
    while (m < ncolm) {
      m++;
      id = jwork[m - 1];
      ie = ic;
      ic -= id;
      ib = ie - ia;
      ii = ib - id;
      if (ie == 0) {
	FORLIM1 = *ncol;
	for (j = m; j <= FORLIM1; j++)
	  apply_count(return_n, l, j, 0L, ntotal, minus_log_q, x_power,
		      x_pearson, &Local_Var);
	m = *ncol;
      } else {
	nlm = find_count(dummy, &ia, &ib, &ic, &id, &ie, &ii, &nlm);
	apply_count(return_n, l, m, nlm, ntotal, minus_log_q, x_power,
		    x_pearson, &Local_Var);
	ia -= nlm;
	jwork[m - 1] -= nlm;
      }
    }
    if (ie != 0)
      apply_count(return_n, l, *ncol, ia, ntotal, minus_log_q, x_power,
		  x_pearson, &Local_Var);
  }
  for (m = 1; m <= ncolm; m++)
    apply_count(return_n, *nrow, m, jwork[m - 1], ntotal, minus_log_q,
		x_power, x_pearson, &Local_Var);
  apply_count(return_n, *nrow, *ncol, ib - jwork[ncolm - 1], ntotal,
	      minus_log_q, x_power, x_pearson, &Local_Var);
}  /* as_159 */

Local Void add_statistics(nrowx, ncolx, nrowpos, ncolpos, nmatpos, n_total,
			  minus_log_q, x_power, x_pearson)
long *nrowx, *ncolx;
long *nrowpos, *ncolpos;
long (*nmatpos)[MAX_LEVEL];
long *n_total;
double *minus_log_q, *x_power, *x_pearson;
{
  t_long_integer m;
  t_long_real ln_p2_p1, p1, p2, x;
  t_cell_index index_1, index_2, FORLIM, FORLIM1;
  double TEMP;

  FORLIM = *nrowx;
  for (index_1 = 1; index_1 <= FORLIM; index_1++) {
    FORLIM1 = *ncolx;
    for (index_2 = 1; index_2 <= FORLIM1; index_2++) {
      m = n[nmatpos[index_1 - 1][index_2 - 1]];
      x = 1.0 / *n_total;
      p1 = n[nrowpos[index_1 - 1]] * x;
      p1 *= n[ncolpos[index_2 - 1]];
      p1 *= x;
      p2 = m * x;
      if (p1 != 0) {
	x = 1 / p1;
	TEMP = p1 - p2;
	*x_pearson += *n_total * (TEMP * TEMP) * x;
      }
      if (m != 0) {
	ln_p2_p1 = log(p2 * x);
	*minus_log_q += m * ln_p2_p1;
	*x_power += *n_total * p2 * (exp(ln_p2_p1 * lambda) - 1);
      }
      /*$ifdef TRACE*/
      if (boolean_option[14]) {
	/*$endif TRACE*/
	trace_add_term(index_1, index_2, *n_total, m, n[nrowpos[index_1 - 1]],
		       n[ncolpos[index_2 - 1]], p1, p2, ln_p2_p1,
		       *minus_log_q, *x_power, *x_pearson);
      }
    }
  }
}  /* add_statistics */

Local Void add_deviance(nrowx, ncolx, nrowpos, ncolpos, nmatpos, n_total,
			minus_log_q)
long *nrowx, *ncolx;
long *nrowpos, *ncolpos;
long (*nmatpos)[MAX_LEVEL];
long *n_total;
double *minus_log_q;
{
  t_long_real x;
  t_long_integer m;
  t_cell_index index_1, index_2, FORLIM, FORLIM1;

  FORLIM = *nrowx;
  for (index_1 = 1; index_1 <= FORLIM; index_1++) {
    FORLIM1 = *ncolx;
    for (index_2 = 1; index_2 <= FORLIM1; index_2++) {
      m = n[nmatpos[index_1 - 1][index_2 - 1]];
      if (m != 0) {
	x = (double)(*n_total) / n[nrowpos[index_1 - 1]];
	x *= (double)m / n[ncolpos[index_2 - 1]];
	*minus_log_q += m * log(x);
      }
      /*$ifdef TRACE*/
      if (boolean_option[14]) {
	/*$endif TRACE*/
	trace_add_term(index_1, index_2, *n_total, m, n[nrowpos[index_1 - 1]],
		       n[ncolpos[index_2 - 1]], -1.0, -1.0, -1.0,
		       *minus_log_q, -1.0, -1.0);
      }
    }
  }
}  /* add_deviance */


Static Void patefield_as_159_in_n(n_levels_v, n_levels_w, vc_offset,
  wc_offset, vwc_offset, slice_pack, return_n, compute_statistics,
  compute_gamma, x_deviance, x_power, x_pearson, gamma)
t_level *n_levels_v, *n_levels_w;
t_offset *vc_offset, *wc_offset, *vwc_offset;
t_slice_pack *slice_pack;
boolean return_n, compute_statistics, compute_gamma;
double *x_deviance, *x_power, *x_pearson, *gamma;
{
  t_cell_index index_1, index_2, n_l_w_p_vwc_w, pos_1_vc, pos_2_wc, pos_3_vwc;
  t_cell i;
  boolean ok;
  t_offset i_v, i_w, i_c;
  t_integer nrowx, ncolx, ncolx1;
  t_long_integer n_total;
  t_long_real d_gamma, ppq, pmq, s, s1, ppqtot, pmqtot;
  long *ncolpos, *nrowpos;
  long (*nmatpos)[MAX_LEVEL];
  boolean zero_col[MAX_LEVEL];
  t_offset FORLIM, FORLIM1;
  long TEMP;
  t_offset FORLIM2;

  nmatpos = (long(*)[MAX_LEVEL])Malloc(sizeof(t_level_2_arr_of_integer));
  if (nmatpos == NULL)
    _OutMem();
  ncolpos = (long *)Malloc(sizeof(t_level_arr_of_integer));
  if (ncolpos == NULL)
    _OutMem();
  nrowpos = (long *)Malloc(sizeof(t_level_arr_of_integer));
  if (nrowpos == NULL)
    _OutMem();
  memcpy(i, first_cell, sizeof(t_cell));
  n_l_w_p_vwc_w = *n_levels_w * slice_pack->p_vwc_w;
  pos_1_vc = *vc_offset;
  pos_2_wc = *wc_offset;
  pos_3_vwc = *vwc_offset;
  ppqtot = 0.0;
  pmqtot = 0.0;
  FORLIM = slice_pack->marginal_dimension_c;
  for (i_c = 1; i_c <= FORLIM; i_c++) {
    if (return_n || compute_gamma && compute_statistics) {
      index_2 = pos_2_wc;
      ncolx = 0;
      /*$ifdef TRACE*/
      if (boolean_option[13])
	write_pch_10_text(stdout, " Ncol: ", 7L);
      FORLIM1 = *n_levels_w;
      /*$endif TRACE*/
      for (i_w = 0; i_w < FORLIM1; i_w++) {
	/*$ifdef TRACE*/
	if (boolean_option[13]) {
	  TEMP = 10;
	  write_cell_count_text(stdout, &n[index_2], &TEMP);
	}
	/*$endif TRACE*/
	if (n[index_2] == 0)
	  zero_col[i_w] = true;
	else {
	  zero_col[i_w] = false;
	  ncolx++;
	  ncolpos[ncolx - 1] = index_2;
	}
	index_2 += slice_pack->p_wc_w;
      }
      /*$ifdef TRACE*/
      if (boolean_option[13]) {
	TEMP = 4;
	write_integer_text(stdout, ncolx, &TEMP);
	write_line_text(stdout);
      }
      /*$endif TRACE*/
      index_1 = pos_1_vc;
      index_2 = pos_3_vwc;
      nrowx = 0;
      /*$ifdef TRACE*/
      if (boolean_option[13])
	write_pch_10_text(stdout, " Nrow: ", 7L);
      FORLIM1 = *n_levels_v;
      /*$endif TRACE*/
      for (i_v = 1; i_v <= FORLIM1; i_v++) {
	/*$ifdef TRACE*/
	if (boolean_option[13]) {
	  TEMP = 10;
	  write_cell_count_text(stdout, &n[index_1], &TEMP);
	}
	/*$endif TRACE*/
	if (n[index_1] == 0) {
	  FORLIM2 = *n_levels_w;
	  for (i_w = 1; i_w <= FORLIM2; i_w++) {
	    n[index_2] = 0;
	    index_2 += slice_pack->p_vwc_w;
	  }
	} else {
	  nrowx++;
	  nrowpos[nrowx - 1] = index_1;
	  ncolx1 = 0;
	  FORLIM2 = *n_levels_w;
	  for (i_w = 0; i_w < FORLIM2; i_w++) {
	    if (zero_col[i_w])
	      n[index_2] = 0;
	    else {
	      ncolx1++;
	      nmatpos[nrowx - 1][ncolx1 - 1] = index_2;
	    }
	    index_2 += slice_pack->p_vwc_w;
	  }
	}
	index_2 += slice_pack->p_vwc_v - n_l_w_p_vwc_w;
	index_1 += slice_pack->p_vc_v;
      }
      /*$ifdef TRACE*/
      if (boolean_option[13]) {
	TEMP = 4;
	write_integer_text(stdout, nrowx, &TEMP);
	write_line_text(stdout);
      }
      /*$endif TRACE*/
      if (nrowx > 1 && ncolx > 1)
	as_159(&nrowx, &ncolx, nrowpos, ncolpos, nmatpos, &seed, &n_total,
	       true, x_deviance, x_power, x_pearson);
      else {
	n_total = 0;
	if (nrowx > 1) {
	  for (index_2 = 0; index_2 < nrowx; index_2++) {
	    n_total += n[nrowpos[index_2]];
	    n[nmatpos[index_2][0]] = n[nrowpos[index_2]];
	  }
	} else if (ncolx > 1) {
	  for (index_2 = 0; index_2 < ncolx; index_2++) {
	    n_total += n[ncolpos[index_2]];
	    n[nmatpos[0][index_2]] = n[ncolpos[index_2]];
	  }
	} else if (nrowx == 1 && ncolx == 1) {
	  n_total = n[nrowpos[0]];
	  n[nmatpos[0][0]] = n[nrowpos[0]];
	} else if (nrowx != 0 || ncolx != 0) {
	  write_pch_40_text(stdout,
			    " Row/Column-Error in Patefield:         ", 32L);
	  TEMP = 3;
	  write_integer_text(stdout, nrowx, &TEMP);
	  TEMP = 3;
	  write_integer_text(stdout, ncolx, &TEMP);
	  TEMP = 3;
	  write_integer_text(stdout, ncolx1, &TEMP);
	  write_line_text(stdout);
	}
      }
      if (compute_statistics) {
	if (exact_log_l)
	  add_deviance(&nrowx, &ncolx, nrowpos, ncolpos, nmatpos, &n_total,
		       x_deviance);
	else {
	  add_statistics(&nrowx, &ncolx, nrowpos, ncolpos, nmatpos, &n_total,
			 x_deviance, x_power, x_pearson);
	  if (compute_gamma) {
	    find_gamma(&n_total, &nrowx, &ncolx, nmatpos, false, &ppq, &pmq,
		       &d_gamma, &s, &s1, &ok);
	    ppqtot += ppq;
	    pmqtot += pmq;
	  }
	}
      }
    } else {
      index_2 = pos_2_wc;
      ncolx = 0;
      FORLIM1 = *n_levels_w;
      for (i_w = 1; i_w <= FORLIM1; i_w++) {
	if (n[index_2] != 0) {
	  ncolx++;
	  ncolpos[ncolx - 1] = index_2;
	}
	index_2 += slice_pack->p_wc_w;
      }
      index_1 = pos_1_vc;
      nrowx = 0;
      FORLIM1 = *n_levels_v;
      for (i_v = 1; i_v <= FORLIM1; i_v++) {
	if (n[index_1] != 0) {
	  nrowx++;
	  nrowpos[nrowx - 1] = index_1;
	}
	index_1 += slice_pack->p_vc_v;
      }
      if (nrowx > 1 && ncolx > 1)
	as_159(&nrowx, &ncolx, nrowpos, ncolpos, nmatpos, &seed, &n_total,
	       false, x_deviance, x_power, x_pearson);
    }
    next_offset_in_slice(slice_pack, &pos_1_vc, &pos_2_wc, &pos_3_vwc, i);
  }
  Free(nmatpos);
  Free(ncolpos);
  Free(nrowpos);
  if (!compute_statistics)
    return;
  if (compute_gamma) {
    if (ppqtot > 0)
      *gamma += pmqtot / ppqtot;
  }
}  /* patefield_as_159_in_n */

#undef precision


Static Void set_exact_test(test, x)
t_test *test;
long x;
{
  test->mcep_deviance = x;
  test->mcep_power = x;
  test->mcep_pearson = x;
  test->mcep_gamma_1 = x;
  test->mcep_gamma_2 = x;
  test->number_of_tables = 0;
}  /* set_exact_test */


Static Void scale_exact_test(test, p_test, number_of_tables, compute_gamma)
t_test *test;
t_test_list **p_test;
long *number_of_tables;
boolean compute_gamma;
{
  if (exact_log_l) {
    test->mcep_deviance /= *number_of_tables;
    test->mcep_power = _INVALID_REAL;
    test->mcep_pearson = _INVALID_REAL;
    test->mcep_gamma_1 = _INVALID_REAL;
    test->mcep_gamma_2 = _INVALID_REAL;
  } else {
    test->mcep_deviance /= *number_of_tables;
    test->mcep_power /= *number_of_tables;
    test->mcep_pearson /= *number_of_tables;
    if (compute_gamma) {
      test->mcep_gamma_1 /= *number_of_tables;
      test->mcep_gamma_2 /= *number_of_tables;
    } else {
      test->mcep_gamma_1 = _INVALID_REAL;
      test->mcep_gamma_2 = _INVALID_REAL;
    }
  }
  test->number_of_tables = *number_of_tables;
  (*p_test)->test.mcep_deviance = test->mcep_deviance;
  (*p_test)->test.mcep_power = test->mcep_power;
  (*p_test)->test.mcep_pearson = test->mcep_pearson;
  (*p_test)->test.mcep_gamma_1 = test->mcep_gamma_1;
  (*p_test)->test.mcep_gamma_2 = test->mcep_gamma_2;
  (*p_test)->test.number_of_tables = *number_of_tables;
}  /* scale_exact_test */


Static Void trace_exact_test(i, x_deviance, x_power, x_pearson, gamma, test,
			     compute_gamma)
long i;
double *x_deviance, *x_power, *x_pearson, *gamma;
t_test *test;
boolean compute_gamma;
{
  write_char(stdout, ':');
  write_char(stdout, '3');
  write_integer(stdout, i, 12L);
  write_real(stdout, *x_deviance, 12L, 5L);
  write_real(stdout, *x_power, 12L, 5L);
  write_real(stdout, *x_pearson, 12L, 5L);
  write_real(stdout, *gamma, 12L, 5L);
  write_real(stdout, test->mcep_deviance, 12L, 5L);
  write_real(stdout, test->mcep_power, 12L, 5L);
  write_real(stdout, test->mcep_pearson, 12L, 5L);
  write_real(stdout, test->mcep_gamma_1, 12L, 5L);
  write_real(stdout, test->mcep_gamma_2, 12L, 5L);
  write_line(stdout);
}  /* trace_exact_test */


Static Void adjust_exact_test(x_deviance, x_power, x_pearson, gamma, test,
			      compute_gamma)
double *x_deviance, *x_power, *x_pearson, *gamma;
t_test *test;
boolean compute_gamma;
{
  if (*x_deviance + exact_epsilon >= test->x_deviance)
    test->mcep_deviance++;
  if (!exact_log_l) {
    if (*x_pearson + exact_epsilon >= test->x_pearson)
      test->mcep_pearson++;
    if (*x_power + exact_epsilon >= test->x_power)
      test->mcep_power++;
  }
  if (!compute_gamma)
    return;
  if (fabs(*gamma) + exact_epsilon >= fabs(test->gamma))
    test->mcep_gamma_2++;
  if (test->gamma < 0 && *gamma - exact_epsilon <= test->gamma ||
      test->gamma > 0 && *gamma + exact_epsilon >= test->gamma)
    test->mcep_gamma_1++;
}  /* adjust_exact_test */


typedef struct t_fact_list {
  t_vertex v, w;
  t_vertex_set a, b, c, d, a_x, b_x;
  t_offset a_x_offset, b_x_offset, a_offset, b_offset, d_offset;
  t_slice_pack slice_pack;
  boolean find_a, find_b;
  struct t_fact_list *pointer;
} t_fact_list;


/* Local variables for compute_mcep_nested_decomposable: */
struct LOC_compute_mcep_nested_decomposable {
  boolean ok;
} ;

Local Void find_marginals_from_random(a, g, off_a, off_g, LINK)
long *a, *g;
t_offset *off_a, *off_g;
struct LOC_compute_mcep_nested_decomposable *LINK;
{
  t_cell_index index, m_index;
  t_cell i;
  t_vertex_set c_in_a;
  t_vertex l_a_vertex;
  t_v_arr_of_integer prod_1, prod_2, levels;
  t_cell_index FORLIM;

  memcpy(i, first_cell, sizeof(t_cell));
  FORLIM = *off_a + last_index(a);
  for (m_index = *off_a; m_index <= FORLIM; m_index++)
    n[m_index] = 0;
  find_products(g, a, c_in_a, prod_1, prod_2, levels, &l_a_vertex);
  m_index = *off_a;
  FORLIM = *off_g + last_index(g);
  for (index = *off_g; index <= FORLIM; index++) {
    n[m_index] += n[index];
    next_c_offset_in_a(c_in_a, &m_index, prod_1, prod_2, levels, &l_a_vertex,
		       i);
  }
}  /* find_marginals_from_random */

Local Void find_factorization_edges(g_c_1, g_c_2, link_fact_list, LINK)
t_set_list **g_c_1, **g_c_2;
t_fact_list **link_fact_list;
struct LOC_compute_mcep_nested_decomposable *LINK;
{
  boolean ok;
  t_vertex u1, u2;
  t_vertex_set g, a, su1, su2, am1, am2;
  t_set_list *g_c;
  t_edge_list *link_edge_list, *p, *q;
  t_v_arr_of_v_sets adj_set_a, adj_set_b;
  t_v_arr_of_v_lists adj_list_b;
  t_fact_list *p_link_fact_list;

  *link_fact_list = NULL;
  hypergraph_sets_to_graph_sets(*g_c_1, g, adj_set_a);
  hypergraph_sets_to_graph_sets(*g_c_2, g, adj_set_b);
  ok = true;
  link_edge_list = NULL;
  adj_set_to_adj_list(adj_set_b, adj_list_b);
  find_edges(adj_list_b, adj_set_a, &link_edge_list);
  p = (t_edge_list *)Malloc(sizeof(t_edge_list));
  if (p == NULL)
    _OutMem();
  p->pointer = link_edge_list;
  link_edge_list = p;
  copy_set_list(*g_c_2, &g_c);
  dispose_adj_list(adj_list_b);
  while (link_edge_list->pointer != NULL) {
    p = link_edge_list;
    q = p->pointer;
    ok = false;
    while (!ok && q != NULL) {
      u1 = q->v;
      u2 = q->w;
      ok = was_edge_in_one_clique(&u1, &u2, &g_c, a);
      if (ok) {
	p->pointer = q->pointer;
	Free(q);
      } else {
	p = q;
	q = q->pointer;
      }
    }
    P_addset(P_expset(su1, 0L), u1);
    P_addset(P_expset(su2, 0L), u2);
    P_setdiff(am1, a, su1);
    P_setdiff(am2, a, su2);
    insert_clique(am1, &g_c);
    insert_clique(am2, &g_c);
    p_link_fact_list = (t_fact_list *)Malloc(sizeof(t_fact_list));
    if (p_link_fact_list == NULL)
      _OutMem();
    p_link_fact_list->pointer = *link_fact_list;
    *link_fact_list = p_link_fact_list;
    (*link_fact_list)->v = u1;
    (*link_fact_list)->w = u2;
    P_setcpy((*link_fact_list)->a, am2);
    P_setcpy((*link_fact_list)->b, am1);
    P_setdiff((*link_fact_list)->c, am1, su2);
    P_setcpy((*link_fact_list)->d, a);
    (*link_fact_list)->a_offset = -1;
    (*link_fact_list)->find_a = false;
    (*link_fact_list)->a_x_offset = -1;
    (*link_fact_list)->find_b = false;
    (*link_fact_list)->b_offset = -1;
    (*link_fact_list)->b_x_offset = -1;
    P_setcpy((*link_fact_list)->a_x, empty_set);
    (*link_fact_list)->d_offset = -1;
    P_setcpy((*link_fact_list)->b_x, empty_set);
  }
  Free(link_edge_list);
  dispose_set_list(&g_c);
}  /* find_factorization_edges */

Local Void print_fact_list(link_fact_list, c, w, LINK)
t_fact_list *link_fact_list;
Char *c;
long w;
struct LOC_compute_mcep_nested_decomposable *LINK;
{
  t_fact_list *p;
  t_vertex_set vertex_set;

  write_pch(stdout, c, w);
  write_line(stdout);
  p = link_fact_list;
  while (p != NULL) {
    print_vertex_set(p->a);
    write_space(stdout, 6 - cardinality(p->a));
    write_integer(stdout, p->a_offset, 4L);
    if (p->find_a)
      write_pch(stdout, " find a", 7L);
    else
      write_pch(stdout, " a ok  ", 7L);
    print_vertex_set(p->a_x);
    write_space(stdout, 6 - cardinality(p->a_x));
    write_integer(stdout, p->a_x_offset, 4L);
    write_space(stdout, 1L);
    print_vertex_set(p->b);
    write_space(stdout, 6 - cardinality(p->b));
    write_integer(stdout, p->b_offset, 4L);
    if (p->find_b)
      write_pch(stdout, " find b", 7L);
    else
      write_pch(stdout, " b ok  ", 7L);
    print_vertex_set(p->b_x);
    write_space(stdout, 6 - cardinality(p->b_x));
    write_integer(stdout, p->b_x_offset, 4L);
    write_space(stdout, 1L);
    P_addset(P_expset(vertex_set, 0L), p->v);
    P_addset(vertex_set, p->w);
    print_vertex_set(vertex_set);
    write_space(stdout, 1L);
    print_vertex_set(p->d);
    write_space(stdout, 6 - cardinality(p->d));
    write_integer(stdout, p->d_offset, 4L);
    write_line(stdout);
    p = p->pointer;
  }
}  /* print_fact_list */

Local Void generate_decomposable(number_of_tables, model_1, model_2,
  m2_offset, return_table, compute_statistics, test, link_fact_list,
  x_deviance, x_power, x_pearson, gamma, LINK)
long *number_of_tables;
t_model *model_1, *model_2;
t_offset *m2_offset;
boolean return_table, compute_statistics;
t_test *test;
t_fact_list **link_fact_list;
double *x_deviance, *x_power, *x_pearson, *gamma;
struct LOC_compute_mcep_nested_decomposable *LINK;
{
  t_long_integer i;
  t_fact_list *p;

  set_exact_test(test, 0L);
  i = 1;
  while (i <= *number_of_tables && !interrupt_1) {
    if (compute_statistics) {
      *gamma = 0.0;
      *x_deviance = 0.0;
      *x_power = 0.0;
      *x_pearson = 0.0;
    }
    p = *link_fact_list;
    while (p != NULL) {
      if (p->find_a)
	find_marginals_from_random(p->a, p->a_x, &p->a_offset, &p->a_x_offset,
				   LINK);
      if (p->find_b)
	find_marginals_from_random(p->b, p->b_x, &p->b_offset, &p->b_x_offset,
				   LINK);
      patefield_as_159_in_n(&vertex_inf[p->v - MIN_VERTEX].levels,
	&vertex_inf[p->w - MIN_VERTEX].levels, &p->a_offset, &p->b_offset,
	&p->d_offset, &p->slice_pack, true, compute_statistics, false,
	x_deviance, x_power, x_pearson, gamma);
      p = p->pointer;
    }
    if (!return_table) {
      if (compute_statistics) {
	*x_deviance = 2 * *x_deviance;
	*x_power = 2 * *x_power;
	*x_power /= lambda * (lambda + 1);
      } else if (exact_log_l)
	*x_deviance = find_expression_log_l(model_2->expression, true, true,
					    &LINK->ok);
      else
	compute_x_deviance_and_x_pearson_g_offset(model_1, model_2,
	  model_2->model_set, *m2_offset, x_deviance, x_pearson, x_power);
      adjust_exact_test(x_deviance, x_power, x_pearson, gamma, test, false);
      /*$ifdef TRACE*/
      if (boolean_option[25])
	trace_exact_test(i, x_deviance, x_power, x_pearson, gamma, test,
			 false);
      /*$endif TRACE*/
      monitor_note_exact("Exact test", 10L,
			 (long)floor(*x_deviance + 0.5), i,
			 *number_of_tables);
    }
    i++;
  }
  if (interrupt_1) {
    *number_of_tables = i - 1;
    interrupt_1 = false;
  }
}  /* generate_decomposable */


/*@+"dexact.p"*/


Static Void compute_mcep_nested_decomposable(model_1, model_2, return_table,
					     p_test, test)
t_model *model_1, *model_2;
boolean return_table;
t_test_list **p_test;
t_test *test;
{
  struct LOC_compute_mcep_nested_decomposable Local_Var;
  t_offset m2_offset, dummy_offset, tmp_fna;
  t_long_real model_2_log_l, gamma, x_deviance, x_power, x_pearson;
  t_long_integer n_of_tables;
  t_vertex_set dummy_set;
  t_fact_list *p, *q, *link_fact_list;
  t_offset_list *p_offsets;
  t_expression *p_expression, *tmp_expression;
  t_offset ab_offset;
  boolean found, ok_small, compute_statistics;

  Local_Var.ok = true;
  find_factorization_edges(&model_1->sets_h_g_c, &model_2->sets_h_g_c,
			   &link_fact_list, &Local_Var);
  if (link_fact_list == NULL) {
    set_exact_test(&(*p_test)->test, -3L);
    set_exact_test(test, -2L);
    return;
  }
  p = link_fact_list;
  while (p != NULL && Local_Var.ok) {
    p->find_a = false;
    p->find_b = false;
    q = link_fact_list;
    while (q != p && !(p->find_a && p->find_b)) {
      if (P_subset(p->a, q->d) && (!P_subset(p->a, q->a) || q->find_a) &&
	  (!P_subset(p->a, q->b) || q->find_b))
	p->find_a = true;
      if (P_subset(p->b, q->d) && (!P_subset(p->b, q->a) || q->find_a) &&
	  (!P_subset(p->b, q->b) || q->find_b))
	p->find_b = true;
      q = q->pointer;
    }
    if (!p->find_a)
      p->a_offset = return_offset(p->a, &Local_Var.ok);
    if (!p->find_b)
      p->b_offset = return_offset(p->b, &Local_Var.ok);
    p = p->pointer;
  }
  /*$ifdef TRACE*/
  if (boolean_option[25])
    print_fact_list(link_fact_list, " After a/b offset   ", 20L, &Local_Var);
  /*$endif TRACE*/
  tmp_fna = fna;
  p_offsets = NULL;
  p = link_fact_list;
  if (return_table && Local_Var.ok) {
    Local_Var.ok = return_from_offset_from_list(model_2->model_set,
	&m2_offset, dummy_set, &dummy_offset, &tmp_fna, &p_offsets);
    Local_Var.ok = true;
  }
  /*$ifdef TRACE*/
  if (boolean_option[25]) {
    write_pch(stdout, " M2-offset          ", 20L);
    print_vertex_set(model_2->model_set);
    write_integer(stdout, m2_offset, 12L);
    print_vertex_set(dummy_set);
    write_integer(stdout, dummy_offset, 12L);
    write_integer(stdout, tmp_fna, 12L);
    write_line(stdout);
  }
  /*$endif TRACE*/
  while (p != NULL && Local_Var.ok) {
    if (p->find_a) {
      p->find_a = !return_from_offset_from_list(p->a, &ab_offset, dummy_set,
	  &dummy_offset, &tmp_fna, &p_offsets);
      p->a_offset = ab_offset;
      P_setcpy(p->a_x, dummy_set);
      p->a_x_offset = dummy_offset;
    }
    if (p->find_b) {
      p->find_b = !return_from_offset_from_list(p->b, &ab_offset, dummy_set,
	  &dummy_offset, &tmp_fna, &p_offsets);
      p->b_offset = ab_offset;
      P_setcpy(p->b_x, dummy_set);
      p->b_x_offset = dummy_offset;
    }
    if (return_table && P_setequal(p->d, model_2->model_set))
      p->d_offset = m2_offset;
    else {
      insert_offset(p->d, tmp_fna, &p_offsets);
      p->d_offset = tmp_fna;
      tmp_fna += marginal_dimension(p->d);
    }
    p = p->pointer;
  }
  /*$ifdef TRACE*/
  if (boolean_option[25])
    print_fact_list(link_fact_list, " After d offset etc.", 20L, &Local_Var);
  /*$endif TRACE*/
  if (Local_Var.ok && !TURBO_PC)
    Local_Var.ok = space_in_n_array(tmp_fna, 0L);
  if (Local_Var.ok && tmp_fna <= max_cell_number) {
    ok_small = return_from_offset_from_list(model_2->model_set, &m2_offset,
	dummy_set, &dummy_offset, &tmp_fna, &p_offsets);
    compute_statistics = (fast || large || !ok_small);
    model_2_log_l = 0.0;
    if (exact_log_l && !compute_statistics) {
      model_2_log_l = test->x_deviance;
      test->x_deviance = find_expression_log_l(model_2->expression, true,
					       true, &Local_Var.ok);
      gamma = _INVALID_REAL;
      x_power = _INVALID_REAL;
      x_pearson = _INVALID_REAL;
    }
    /*$ifdef TRACE*/
    if (boolean_option[25]) {
      write_pch(stdout, " M2-offset          ", 20L);
      print_vertex_set(model_2->model_set);
      write_integer(stdout, m2_offset, 12L);
      print_vertex_set(dummy_set);
      write_integer(stdout, dummy_offset, 12L);
      write_integer(stdout, tmp_fna, 12L);
      write_line(stdout);
      trace_exact_test(0L, &x_deviance, &x_power, &x_pearson, &gamma, test,
		       false);
      write_integer(stdout, 0L, 12L);
      write_real(stdout, model_2_log_l, 12L, 5L);
      write_line(stdout);
      if (ok_small)
	write_pch(stdout, " Ok       ", 10L);
      else
	write_pch(stdout, " Not Ok   ", 10L);
      write_line(stdout);
    }
    /*$endif TRACE*/
    p_expression = NULL;
    tmp_expression = model_2->expression;
    while (tmp_expression != NULL) {
      insert_factor_in_expression(tmp_expression->vertex_set,
				  &tmp_expression->factor, &p_expression);
      p_expression->offset = tmp_expression->offset;
      q = link_fact_list;
      found = false;
      while (q != NULL && !found) {
	if (P_setequal(p_expression->vertex_set, q->d)) {
	  found = true;
	  p_expression->offset = q->d_offset;
	}
	q = q->pointer;
      }
      tmp_expression = tmp_expression->pointer;
    }
    tmp_expression = model_2->expression;
    model_2->expression = p_expression;
    p = link_fact_list;
    while (p != NULL) {
      find_slice_products(p->c, p->a, p->b, p->d, &p->v, &p->w,
			  &p->slice_pack);
      p = p->pointer;
    }
    if (return_table)
      n_of_tables = 1;
    else if (number_of_tables > 0)
      n_of_tables = number_of_tables;
    else {
      n_of_tables = init_n_of_tables;
      generate_decomposable(&n_of_tables, model_1, model_2, &m2_offset,
			    return_table, compute_statistics, test,
			    &link_fact_list, &x_deviance, &x_power,
			    &x_pearson, &gamma, &Local_Var);
      n_of_tables = set_n_of_tables(test, false, &n_of_tables);
    }
    generate_decomposable(&n_of_tables, model_1, model_2, &m2_offset,
			  return_table, compute_statistics, test,
			  &link_fact_list, &x_deviance, &x_power, &x_pearson,
			  &gamma, &Local_Var);
    if (exact_log_l && !compute_statistics)
      test->x_deviance = model_2_log_l;
    if (return_table)
      dispose_expression(&tmp_expression);
    else {
      dispose_expression(&model_2->expression);
      model_2->expression = tmp_expression;
    }
    scale_exact_test(test, p_test, &n_of_tables, false);
  } else {
    write_line(stdout);
    write_pch(stdout, " ExactTest:", 11L);
    write_out_of_space(model_1->sets_h_g_c, model_2->sets_h_g_c, "-",
		       short_test_output, 0L, 0L);
  }
  while (link_fact_list != NULL) {
    p = link_fact_list;
    link_fact_list = link_fact_list->pointer;
    Free(p);
  }
  dispose_offset_list(&p_offsets);
}  /* compute_mcep_nested_decomposable */


Static Void return_random_vector(current_model, a, offset, ok)
t_model *current_model;
long *a;
t_offset *offset;
boolean *ok;
{
  t_model tmp_model;
  t_test_list *p_test;
  t_test test;
  t_expression *tmp_expression;

  p_test = (t_test_list *)Malloc(sizeof(t_test_list));
  if (p_test == NULL)
    _OutMem();
  erase_model(&tmp_model);
  P_setcpy(tmp_model.model_set, a);
  insert_set_in_set_list(a, &tmp_model.sets_h_g_c);
  *ok = ok_model_fit_values(&tmp_model);
  compute_mcep_nested_decomposable(current_model, &tmp_model, true, &p_test,
				   &test);
  tmp_expression = tmp_model.expression;
  *ok = false;
  while (tmp_expression != NULL && !*ok) {
    if (P_setequal(tmp_expression->vertex_set, a)) {
      *ok = true;
      *offset = tmp_expression->offset;
    }
    tmp_expression = tmp_expression->pointer;
  }
  dispose_model(&tmp_model);
  Free(p_test);
}  /* return_random_vector */


Static Void substitute(current_model, ok)
t_model *current_model;
boolean *ok;
{
  t_offset i, offset, FORLIM;

  return_random_vector(current_model, delta, &offset, ok);
  FORLIM = last_index(delta);
  for (i = FIRST_INDEX; i <= FORLIM; i++)
    n[i] = n[i + offset];
}  /* substitute */


/* Local variables for compute_mcep_one_edge_set_old: */
struct LOC_compute_mcep_one_edge_set_old {
  boolean ok;
} ;

Local Void generate_one_edge_old(number_of_tables, c, bv, bw, v, w, model_a,
  model_b, test, compute_gamma, vc_offset, wc_offset, vwc_offset, slice_pack,
  x_deviance, x_power, x_pearson, gamma, LINK)
long *number_of_tables;
long *c, *bv, *bw;
t_vertex *v, *w;
t_model *model_a, *model_b;
t_test *test;
boolean *compute_gamma;
t_offset *vc_offset, *wc_offset, *vwc_offset;
t_slice_pack *slice_pack;
double *x_deviance, *x_power, *x_pearson, *gamma;
struct LOC_compute_mcep_one_edge_set_old *LINK;
{
  t_long_integer i;
  t_vertex_set b;
  t_long_real s, s1;

  set_exact_test(test, 0L);
  i = 1;
  P_setint(b, bv, bw);
  while (i <= *number_of_tables && !interrupt_1) {
    if (fast) {
      *x_deviance = 0.0;
      *x_power = 0.0;
      *x_pearson = 0.0;
      *gamma = 0.0;
    }
    patefield_as_159_in_n(&vertex_inf[*v - MIN_VERTEX].levels,
      &vertex_inf[*w - MIN_VERTEX].levels, vc_offset, wc_offset, vwc_offset,
      slice_pack, !(fast && c_factorizes == 3), fast, *compute_gamma,
      x_deviance, x_power, x_pearson, gamma);
    if (fast) {
      *x_deviance = 2 * *x_deviance;
      *x_power = 2 * *x_power;
      *x_power /= lambda * (lambda + 1);
    } else if (exact_log_l)
      *x_deviance = find_expression_log_l(model_b->expression, true, true,
					  &LINK->ok);
    else {
      compute_x_deviance_and_x_pearson_g_offset(model_a, model_b, c,
	*vwc_offset, x_deviance, x_pearson, x_power);
      if (*compute_gamma)
	compute_slice_statistics(v, w, &vertex_inf[*v - MIN_VERTEX].levels,
	  &vertex_inf[*w - MIN_VERTEX].levels, b, *vc_offset, *wc_offset,
	  *vwc_offset, slice_pack, gamma, &s, &s1, false);
    }
    adjust_exact_test(x_deviance, x_power, x_pearson, gamma, test,
		      *compute_gamma);
    /*$ifdef TRACE*/
    if (boolean_option[25])
      trace_exact_test(i, x_deviance, x_power, x_pearson, gamma, test,
		       *compute_gamma);
    /*$endif TRACE*/
    monitor_note_exact("Exact test", 10L,
		       (long)floor(*x_deviance + 0.5), i, *number_of_tables);
    i++;
  }
  if (interrupt_1) {
    *number_of_tables = i - 1;
    interrupt_1 = false;
  }
}  /* generate_one_edge_old */


/*@+"exact.p"*/


Static Void compute_mcep_one_edge_set_old(c, bv, bw, v, w, model_a, model_b,
					  p_test, test)
long *c, *bv, *bw;
t_vertex *v, *w;
t_model *model_a, *model_b;
t_test_list **p_test;
t_test *test;
{
  struct LOC_compute_mcep_one_edge_set_old Local_Var;
  t_long_real tmp_x_deviance, gamma, x_deviance, x_power, x_pearson;
  t_long_integer n_of_tables, tmp_offset;
  t_offset vc_offset, wc_offset, vwc_offset;
  boolean compute_gamma;
  t_slice_pack slice_pack;
  t_vertex_set b;

  compute_gamma = true;
  vc_offset = return_offset(bv, &Local_Var.ok);
  wc_offset = return_offset(bw, &Local_Var.ok);
  if (Local_Var.ok && !TURBO_PC)
    Local_Var.ok = space_in_n_array(marginal_dimension(c), fna);
  if (Local_Var.ok & (marginal_dimension(c) <= max_cell_number - fna)) {
    if (exact_log_l && !fast) {
      tmp_x_deviance = test->x_deviance;
      test->x_deviance = find_expression_log_l(model_b->expression, true,
					       true, &Local_Var.ok);
      x_pearson = _INVALID_REAL;
      x_power = _INVALID_REAL;
      gamma = _INVALID_REAL;
      /*$ifdef TRACE*/
      if (boolean_option[25]) {
	/*$endif TRACE*/
	trace_exact_test(-1L, &test->x_deviance, &x_power, &x_pearson, &gamma,
			 test, compute_gamma);
      }
    }
    vwc_offset = fna;
    if (P_setequal(model_b->expression->vertex_set, c)) {
      tmp_offset = model_b->expression->offset;
      model_b->expression->offset = fna;
    } else {
      tmp_offset = model_b->expression->pointer->offset;
      model_b->expression->pointer->offset = fna;
    }
    compute_gamma = (ordinal_tests && !(em || incomplete_table)) & P_inset(*v,
		      ordinal_factors) & P_inset(*w, ordinal_factors);
    P_setint(b, bv, bw);
    find_slice_products(b, bv, bw, c, v, w, &slice_pack);
    if (number_of_tables > 0)
      n_of_tables = number_of_tables;
    else {
      n_of_tables = init_n_of_tables;
      generate_one_edge_old(&n_of_tables, c, bv, bw, v, w, model_a, model_b,
			    test, &compute_gamma, &vc_offset, &wc_offset,
			    &vwc_offset, &slice_pack, &x_deviance, &x_power,
			    &x_pearson, &gamma, &Local_Var);
      n_of_tables = set_n_of_tables(test, compute_gamma, &n_of_tables);
    }
    generate_one_edge_old(&n_of_tables, c, bv, bw, v, w, model_a, model_b,
			  test, &compute_gamma, &vc_offset, &wc_offset,
			  &vwc_offset, &slice_pack, &x_deviance, &x_power,
			  &x_pearson, &gamma, &Local_Var);
    scale_exact_test(test, p_test, &n_of_tables, compute_gamma);
    if (exact_log_l && !fast)
      test->x_deviance = tmp_x_deviance;
    if (P_setequal(model_b->expression->vertex_set, c))
      model_b->expression->offset = tmp_offset;
    else
      model_b->expression->pointer->offset = tmp_offset;
    return;
  }
  write_line(stdout);
  write_pch(stdout, " ExactTest:", 11L);
  write_out_of_space(model_a->sets_h_g_c, model_b->sets_h_g_c, "-",
		     short_test_output, 0L, 0L);
}  /* compute_mcep_one_edge_set_old */


Local Void generate_one_edge_new(number_of_tables, v, w, test, compute_gamma,
				 vc_offset, wc_offset, vwc_offset, slice_pack,
				 x_deviance, x_power, x_pearson, gamma)
long *number_of_tables;
t_vertex *v, *w;
t_test *test;
boolean *compute_gamma;
t_offset *vc_offset, *wc_offset, *vwc_offset;
t_slice_pack *slice_pack;
double *x_deviance, *x_power, *x_pearson, *gamma;
{
  t_long_integer i;

  set_exact_test(test, 0L);
  i = 1;
  while (i <= *number_of_tables && !interrupt_1) {
    *x_deviance = 0.0;
    *x_power = 0.0;
    *x_pearson = 0.0;
    *gamma = 0.0;
    patefield_as_159_in_n(&vertex_inf[*v - MIN_VERTEX].levels,
      &vertex_inf[*w - MIN_VERTEX].levels, vc_offset, wc_offset, vwc_offset,
      slice_pack, false, true, *compute_gamma, x_deviance, x_power, x_pearson,
      gamma);
    *x_deviance = 2 * *x_deviance;
    *x_power = 2 * *x_power;
    *x_power /= lambda * (lambda + 1);
    adjust_exact_test(x_deviance, x_power, x_pearson, gamma, test,
		      *compute_gamma);
    /*$ifdef TRACE*/
    if (boolean_option[25])
      trace_exact_test(i, x_deviance, x_power, x_pearson, gamma, test,
		       *compute_gamma);
    /*$endif TRACE*/
    i++;
  }
  if (interrupt_1) {
    *number_of_tables = i - 1;
    interrupt_1 = false;
  }
}  /* generate_one_edge_new */


Static Void compute_mcep_one_edge_set(c, bv, bw, v, w, p_test, test)
long *c, *bv, *bw;
t_vertex *v, *w;
t_test_list **p_test;
t_test *test;
{
  t_long_real gamma, x_deviance, x_power, x_pearson;
  t_long_integer n_of_tables;
  t_offset vc_offset, wc_offset, vwc_offset;
  boolean compute_gamma, ok;
  t_slice_pack slice_pack;
  t_vertex_set b;

  vc_offset = return_offset(bv, &ok);
  wc_offset = return_offset(bw, &ok);
  if (ok && !TURBO_PC)
    ok = space_in_n_array(marginal_dimension(c), fna);
  if (ok & (marginal_dimension(c) <= max_cell_number - fna)) {
    vwc_offset = fna;
    compute_gamma = (ordinal_tests && !(em || incomplete_table)) & P_inset(*v,
		      ordinal_factors) & P_inset(*w, ordinal_factors);
    P_setint(b, bv, bw);
    find_slice_products(b, bv, bw, c, v, w, &slice_pack);
    if (number_of_tables > 0)
      n_of_tables = number_of_tables;
    else {
      n_of_tables = init_n_of_tables;
      generate_one_edge_new(&n_of_tables, v, w, test, &compute_gamma,
			    &vc_offset, &wc_offset, &vwc_offset, &slice_pack,
			    &x_deviance, &x_power, &x_pearson, &gamma);
      n_of_tables = set_n_of_tables(test, compute_gamma, &n_of_tables);
    }
    generate_one_edge_new(&n_of_tables, v, w, test, &compute_gamma,
			  &vc_offset, &wc_offset, &vwc_offset, &slice_pack,
			  &x_deviance, &x_power, &x_pearson, &gamma);
    scale_exact_test(test, p_test, &n_of_tables, compute_gamma);
    return;
  }
  write_line(stdout);
  write_pch(stdout, " ExactTest:", 11L);
  write_out_of_space(NULL, NULL, " One Edge ", short_test_output, 0L, 0L);
}  /* compute_mcep_one_edge_set */


Static Void compute_mcep_one_edge(adj_set, v, w, p_test, test)
t_vertex_set *adj_set;
t_vertex *v, *w;
t_test_list **p_test;
t_test *test;
{
  t_vertex u;
  t_vertex_set a, b, bv, bw, c;
  t_model model_a, model_b;
  boolean ok;
  t_vertex FORLIM;

  P_addset(P_expset(a, 0L), *v);
  P_addset(a, *w);
  P_setcpy(b, empty_set);
  FORLIM = last_vertex;
  for (u = first_vertex; u <= FORLIM; u++) {
    if (P_subset(a, adj_set[u - MIN_VERTEX]))
      P_addset(b, u);
  }
  P_addset(P_expset(c, 0L), *v);
  P_setunion(bv, b, c);
  P_addset(P_expset(c, 0L), *w);
  P_setunion(bw, b, c);
  P_setunion(c, a, b);
  if (fast && c_factorizes == 2) {
    compute_mcep_one_edge_set(c, bv, bw, v, w, p_test, test);
    return;
  }
  if (incomplete_table) {
    write_pch(stdout, " *** warning ***  oneedgecollaps used on", 40L);
    write_pch(stdout, " incomplete table  *** warning ***", 34L);
    write_line(stdout);
  }
  erase_model(&model_a);
  erase_model(&model_b);
  insert_set_in_set_list(c, &model_b.sets_h_g_c);
  insert_set_in_set_list(bv, &model_a.sets_h_g_c);
  insert_set_in_set_list(bw, &model_a.sets_h_g_c);
  P_setcpy(model_a.model_set, c);
  P_setcpy(model_b.model_set, c);
  put_factor(&model_a.expression, bv, 1L);
  put_factor(&model_a.expression, bw, 1L);
  put_factor(&model_a.expression, empty_set, -1L);
  put_factor(&model_a.expression, b, -1L);
  put_factor(&model_b.expression, c, 1L);
  put_factor(&model_b.expression, empty_set, -1L);
  P_setdiff(a, delta, c);
  model_a.constant = 1 / marginal_dimension_real(a);
  model_b.constant = model_a.constant;
  model_a.found_expression = true;
  model_b.found_expression = true;
  model_a.found_ps = true;
  model_b.found_ps = true;
  if (!short_test_output && !just) {
    write_pch(stdout, " collaps onto ", 14L);
    print_vertex_set(c);
    write_line(stdout);
  }
  ok = true;   /* write_models */
  print_do_exclude(c, &short_test_output, &ok, 0L);
  if (datastructure == all)
    test_expression_marginals(&model_a, &model_b, c, &ok);
  else if (exact_log_l && !fast)
    find_expression_marginals_and_insert_offsets(model_b.expression, &ok);
  else if (!fast) {
    find_expression_marginals_and_insert_offsets(model_a.expression, &ok);
    find_expression_marginals_and_insert_offsets(model_b.expression, &ok);
  }
  compute_mcep_one_edge_set_old(c, bv, bw, v, w, &model_a, &model_b, p_test,
				test);
  dispose_marginals_cond();
  dispose_set_list(&model_a.sets_h_g_c);
  dispose_set_list(&model_b.sets_h_g_c);
  dispose_expression(&model_a.expression);
  dispose_expression(&model_b.expression);
}  /* compute_mcep_one_edge */


Static Void test_exact_test_g_c(g_c_1, g_c_2, p_test, test)
t_set_list **g_c_1, **g_c_2;
t_test_list **p_test;
t_test *test;
{
  boolean ok;
  t_vertex_set g;
  t_edge_list *link_edge_list, *p;
  t_v_arr_of_v_sets adj_set_1, adj_set_2;
  t_v_arr_of_v_lists adj_list_2;
  t_model model_1, model_2;
  t_vertex v, w;

  if (select_asymptotic_p_value(*p_test) >= asymptotic_limit)
    return;
  hypergraph_sets_to_graph_sets(*g_c_1, g, adj_set_1);
  hypergraph_sets_to_graph_sets(*g_c_2, g, adj_set_2);
  link_edge_list = NULL;
  adj_set_to_adj_list(adj_set_2, adj_list_2);
  find_edges(adj_list_2, adj_set_1, &link_edge_list);
  dispose_adj_list(adj_list_2);
  if (link_edge_list == NULL) {
    set_exact_test(test, 1L);
    return;
  }
  if (link_edge_list->pointer == NULL) {
    v = link_edge_list->v;
    w = link_edge_list->w;
    compute_mcep_one_edge(adj_set_1, &v, &w, p_test, &(*p_test)->test);
  } else {
    erase_model(&model_1);
    model_1.sets_h_g_c = *g_c_1;
    erase_model(&model_2);
    model_2.sets_h_g_c = *g_c_2;
    ok = ok_model_fit_values(&model_1);
    dispose_marginals_cond();
    ok &= ok_model_fit_values(&model_2);
    dispose_marginals_cond();
    if (ok) {
      if (model_1.decomposable && model_2.decomposable && model_1.graphical &&
	  model_2.graphical)
	compute_mcep_nested_decomposable(&model_1, &model_2, false, p_test,
					 &(*p_test)->test);
    }
    model_2.sets_h_g_c = NULL;
    dispose_model(&model_2);
    model_1.sets_h_g_c = NULL;
    dispose_model(&model_1);
  }
  while (link_edge_list != NULL) {
    p = link_edge_list;
    link_edge_list = link_edge_list->pointer;
    Free(p);
  }
  test->number_of_tables = (*p_test)->test.number_of_tables;
  test->mcep_deviance = (*p_test)->test.mcep_deviance;
  test->mcep_power = (*p_test)->test.mcep_power;
  test->mcep_pearson = (*p_test)->test.mcep_pearson;
  test->mcep_gamma_1 = (*p_test)->test.mcep_gamma_1;
  test->mcep_gamma_2 = (*p_test)->test.mcep_gamma_2;
}  /* test_exact_test_g_c */


Static Void test_exact_test(model_1, model_2, p_test, test)
t_model *model_1, *model_2;
t_test_list **p_test;
t_test *test;
{
  if (model_1->decomposable && model_2->decomposable && model_1->graphical &&
      model_2->graphical)
    test_exact_test_g_c(&model_1->sets_h_g_c, &model_2->sets_h_g_c, p_test,
			test);
}  /* test_exact_test */


/*@-"test.c"*/
/*@+"wtest.p"*/


Static Void write_dump_real(x, width, decdiff)
double x;
long width, decdiff;
{
  if (is_invalid_real(x))
    write_invalid(dump_file, width);
  else
    write_real_text(dump_file, &x, labs(width), decdiff);
}  /* write_dump_real */


Static Void write_dump_integer(c, width)
long c, width;
{
  long TEMP;

  if (c == _INVALID)
    write_invalid(dump_file, width);
  else {
    TEMP = labs(width);
    write_integer_text(dump_file, c, &TEMP);
  }
}  /* write_dump_integer */


Static Void write_dump_cond_real(ok, x, width, decdiff)
boolean ok;
double x;
long width, decdiff;
{
  if ((!ok) | is_invalid_real(x))
    write_invalid(dump_file, width);
  else
    write_real_text(dump_file, &x, labs(width), decdiff);
}  /* write_dump_real */


Static Void write_dump_cond_integer(ok, c, width)
boolean ok;
long c, width;
{
  long TEMP;

  if (!ok || c == _INVALID)
    write_invalid(dump_file, width);
  else {
    TEMP = labs(width);
    write_integer_text(dump_file, c, &TEMP);
  }
}  /* write_dump_integer */


Static double find_exact_df(n, df, q, p)
long n, df;
double q, p;
{
  t_long_integer l, m, u;

  if (p < 1.0 / n)
    p = 0.5 / n;
  else if (p > 1 - 1.0 / n)
    p = 1 - 0.5 / n;
  if (p < 1 - khi(df, q)) {
    l = df;
    u = l * 2;
    while (p < 1 - khi(u, q) && u * 2 < INFINITY) {
      l = u;
      u = l * 2;
    }
  } else {
    u = df;
    l = u / 2;
    while (p > 1 - khi(l, q) && 1 < l) {
      u = l;
      l = u / 2;
    }
  }
  m = -1;
  while (1 < u - l) {
    m = (l + u) / 2;
    if (p > 1 - khi(m, q))
      u = m;
    else
      l = m;
  }
  return (l + (p - 1 + khi(l, q)) * (u - l) / (khi(l, q) - khi(u, q)));
}  /* find_exact_df */


Static Void write_test_on_dump_file(test, reuse, eh, graphical, decomposable)
t_test *test;
boolean reuse, eh, graphical, decomposable;
{
  t_long_integer df_adj;

  if (!(eh | test->ok | (!is_invalid_real(test->x_deviance))))
    return;
  if (adj_df && test->adj != INFINITY)
    df_adj = test->df - test->adj;
  else
    df_adj = test->df;
  if (test->df == INFINITY)
    write_dump_real(test->df_real, labs(print_width) + 5, 0L);
  else
    write_dump_integer(test->df, labs(print_width) + 5);
  write_dump_cond_integer(adj_df && test->adj != INFINITY, test->adj,
			  print_width);
  write_dump_cond_integer(adj_df && test->adj != INFINITY, df_adj,
			  print_width);
  write_dump_cond_integer(exact_test && test->mcep_deviance > -1,
			  test->number_of_tables, width);
  write_dump_real(test->x_deviance, print_width, print_dec);
  write_dump_real(khi(test->df, test->x_deviance), print_width, print_dec);
  write_dump_cond_real(adj_df && test->adj != INFINITY,
		       khi(df_adj, test->x_deviance), print_width, print_dec);
  test->ok = (exact_test && test->mcep_deviance > -1);
  write_dump_cond_real(test->ok, test->mcep_deviance, print_width, print_dec);
  write_dump_cond_real(test->ok,
    find_exact_df(test->number_of_tables, test->df, test->x_deviance,
		  test->mcep_deviance), print_width, print_dec);
  if (lambda != 1) {
    write_dump_real(test->x_power, print_width, print_dec);
    write_dump_real(khi(test->df, test->x_power), print_width, print_dec);
    write_dump_cond_real(adj_df && test->adj != INFINITY,
			 khi(df_adj, test->x_power), print_width, print_dec);
    test->ok = (exact_test && test->mcep_power > -1);
    write_dump_cond_real(test->ok, test->mcep_power, print_width, print_dec);
    write_dump_cond_real(test->ok,
      find_exact_df(test->number_of_tables, test->df, test->x_power,
		    test->mcep_power), print_width, print_dec);
  }
  write_dump_real(test->x_pearson, print_width, print_dec);
  write_dump_real(khi(test->df, test->x_pearson), print_width, print_dec);
  write_dump_cond_real(adj_df && test->adj != INFINITY,
		       khi(df_adj, test->x_pearson), print_width, print_dec);
  test->ok = (exact_test && test->mcep_pearson > -1);
  write_dump_cond_real(test->ok, test->mcep_pearson, print_width, print_dec);
  write_dump_cond_real(test->ok,
    find_exact_df(test->number_of_tables, test->df, test->x_pearson,
		  test->mcep_pearson), print_width, print_dec);
  if (ordinal_tests & (!is_invalid_real(test->gamma))) {
    write_dump_real(test->gamma, print_width, print_dec);
    if (test->s > 0)
      write_dump_real(2 * pnormal(fabs(test->gamma / sqrt(test->s))),
		      print_width, print_dec);
    else
      write_dump_real(_INVALID_REAL, print_width, print_dec);
    if (exact_test && test->mcep_gamma_1 > -1) {
      write_dump_real(test->mcep_gamma_1, print_width, print_dec);
      write_dump_real(test->mcep_gamma_2, print_width, print_dec);
    }
    if (test->s > 0)
      write_dump_real(sqrt(test->s), print_width, print_dec);
    else
      write_dump_real(_INVALID_REAL, print_width, print_dec);
    if (test->s1 > 0)
      write_dump_real(sqrt(test->s1), print_width, print_dec);
    else
      write_dump_real(_INVALID_REAL, print_width, print_dec);
    if (exact_test && test->mcep_gamma_1 > -1) {
      write_space(stdout, labs(print_width) - 8);
      write_space(stdout, labs(print_width) - 8);
    }
  }
  write_line_text(dump_file);
  flush_file(&dump_file);
}  /* write_test_on_dump_file */


Static Void sub_write_test(test, short_test_output, write_models, reuse, eh,
			   graphical, decomposable, dept, indent_1, indent_2,
			   class_)
t_test *test;
boolean *short_test_output, *write_models, reuse, eh, graphical, decomposable;
long dept, *indent_1, *indent_2, *class_;
{
  t_long_integer stop, df_adj;
  t_long_real statistic;

  if (dump)
    write_test_on_dump_file(test, reuse, eh, graphical, decomposable);
  if (!(eh | test->ok | (!is_invalid_real(test->x_deviance)))) {
    write_out_of_space(test->g_c_1, test->g_c_2, "-",
		       *short_test_output, *indent_1, dept);
    return;
  }
  if (adj_df && test->adj != INFINITY)
    df_adj = test->df - test->adj;
  else
    df_adj = test->df;
  if (*short_test_output) {
    if (long_names && *write_models) {
      write_line(stdout);
      if (short_report)
	write_space(stdout, 3L);
      write_space(stdout, 7L);
    }
    write_char(stdout, ' ');
    if (test->df == INFINITY)
      write_real(stdout, test->df_real, x_width, 0L);
    else if (true)
      write_integer(stdout, df_adj, x_width);
    else
      write_integer(stdout, df_adj, 4L);
    write_char(stdout, ' ');
    if (adj_df) {
      write_integer(stdout, test->adj, 4L);
      write_char(stdout, ' ');
    }
    write_real(stdout, test->x_deviance, x_width, x_dec);
    write_char(stdout, ' ');
    write_real(stdout, khi(df_adj, test->x_deviance), prob_width, prob_dec);
    write_char(stdout, ' ');
    if (lambda != 1) {
      write_real(stdout, test->x_power, x_width, x_dec);
      write_char(stdout, ' ');
      write_real(stdout, khi(df_adj, test->x_power), prob_width, prob_dec);
      write_char(stdout, ' ');
    }
    write_real(stdout, test->x_pearson, x_width, x_dec);
    write_char(stdout, ' ');
    write_real(stdout, khi(df_adj, test->x_pearson), prob_width, prob_dec);
    write_char(stdout, ' ');
    if (ordinal_tests) {
      write_real(stdout, test->gamma, x_width, prob_dec);
      write_char(stdout, ' ');
      if (test->s > 0)
	write_real(stdout, 2 * pnormal(fabs(test->gamma / sqrt(test->s))),
		   prob_width, prob_dec);
      else
	write_real(stdout, _INVALID_REAL, prob_width, prob_dec);
      write_char(stdout, ' ');
    }
    if (ic) {
      switch (test_choice) {

      case 1:
	statistic = test->x_deviance;
	break;

      case 2:
	statistic = test->x_pearson;
	break;

      case 3:
	statistic = test->x_power;
	break;
      }
      if (bic && exclude_missing) {
	if (test->n_count == _INVALID_COUNT) {
	  write_space(stdout, labs(x_width) - 1);
	  write_char(stdout, '-');
	} else if (test->df == INFINITY)
	  write_real(stdout,
		     statistic - log((double)test->n_count) * test->df_real,
		     x_width, x_dec);
	else
	  write_real(stdout, statistic - log((double)test->n_count) * df_adj,
		     x_width, x_dec);
      } else if (test->df == INFINITY)
	write_real(stdout, statistic - ic_lambda * test->df_real, x_width,
		   x_dec);
      else
	write_real(stdout, statistic - ic_lambda * df_adj, x_width, x_dec);
      write_char(stdout, ' ');
    }
    if (eh) {
      switch (*class_) {

      case 1:
	write_pch(stdout, " Accepted ", 10L);
	break;

      case 2:
	write_pch(stdout, " Rejected ", 10L);
	break;

      case 3:
	write_pch(stdout, " Ignored  ", 10L);
	break;
      }
      if (graphical)
	write_char(stdout, 'G');
      else
	write_char(stdout, ' ');
      if (decomposable && graphical)
	write_char(stdout, 'D');
      else
	write_char(stdout, ' ');
      write_char(stdout, ' ');
      print_g_c_from_stop(test->g_c_1, *indent_2 - 1, *indent_2, line_length,
			  &stop);
    } else {
      if (reuse)
	write_pch(stdout, " R ", 3L);
      else
	write_pch(stdout, "   ", 3L);
      if (*write_models) {
	print_g_c_from_stop(test->g_c_2, *indent_2 - 1, *indent_2,
			    line_length, &stop);
	if ((stop - *indent_2) * 2 > line_length - *indent_2 &&
	    line_length < MAX_LINE_LENGTH) {
	  stop = *indent_2;
	  write_line(stdout);
	  write_space(stdout, *indent_2 - 1);
	}
	write_pch(stdout, " / ", 3L);
	print_g_c_from(test->g_c_1, stop, *indent_2, line_length);
      }
    }
    if (!(exact_test && (test->mcep_deviance > -1 || test->mcep_pearson > -1)))
      return;
    write_line(stdout);
    write_pch(stdout, " Exact", 6L);
    write_pch(stdout, " ( ", 3L);
    write_integer(stdout, test->number_of_tables, 6L);
    write_pch(stdout, " ) ", 3L);
    if (short_report)
      write_space(stdout, 3L);
    if (separators && *write_models)
      write_space(stdout, 11L);
    if (exclude_missing && !(long_names && *write_models))
      write_space(stdout, 8L);
    if (adj_df || *write_models)
      write_space(stdout, 5L);
    write_space(stdout, *indent_1 + labs(x_width) - 9);
    write_real(stdout, test->mcep_deviance, prob_width, prob_dec);
    write_char(stdout, ' ');
    if (lambda != 1) {
      write_space(stdout, labs(x_width) + 1);
      write_real(stdout, test->mcep_power, prob_width, prob_dec);
      write_char(stdout, ' ');
    }
    write_space(stdout, labs(x_width) + 1);
    write_real(stdout, test->mcep_pearson, prob_width, prob_dec);
    if (ordinal_tests) {
      write_space(stdout, labs(x_width) - labs(prob_width) + 1);
      if (!is_invalid_real(test->gamma))
	write_real(stdout, test->mcep_gamma_1, prob_width, prob_dec);
      else
	write_real(stdout, _INVALID_REAL, prob_width, prob_dec);
      write_space(stdout, 1L);
      if (!is_invalid_real(test->gamma))
	write_real(stdout, test->mcep_gamma_2, prob_width, prob_dec);
      else
	write_real(stdout, _INVALID_REAL, prob_width, prob_dec);
    }
    if (!*write_models)
      write_space(stdout, 4L);
    return;
  }
  write_space(stdout, dept + 1);
  write_pch(stdout, "Test of ", 8L);
  print_g_c(test->g_c_1, dept + 10, line_length);
  write_line(stdout);
  write_space(stdout, dept + 1);
  write_pch(stdout, "against ", 8L);
  print_g_c(test->g_c_2, dept + 10, line_length);
  if (reuse)
    write_pch(stdout, " Re-use", 7L);
  write_line(stdout);
  write_line(stdout);
  write_space(stdout, dept + 1);
  write_space(stdout, labs(print_width) + 1);
  write_pch(stdout, "Statistic", 9L);
  write_space(stdout, labs(print_width) - 3);
  write_pch(stdout, "Asymptotic", 10L);
  if (adj_df) {
    write_space(stdout, labs(print_width) - 3);
    write_pch(stdout, "Adjusted", 8L);
  }
  if (exact_test && test->mcep_deviance > -1) {
    write_space(stdout, labs(print_width));
    write_pch(stdout, "Exact", 5L);
  }
  write_line(stdout);
  write_space(stdout, dept + 1);
  write_pch(stdout, "-2log(Q) =", 10L);
  write_real(stdout, test->x_deviance, print_width, print_dec);
  write_pch(stdout, "   P = ", 7L);
  write_real(stdout, khi(test->df, test->x_deviance), print_width, print_dec);
  if (adj_df && test->adj != INFINITY) {
    write_pch(stdout, "  /  ", 5L);
    write_real(stdout, khi(df_adj, test->x_deviance), print_width, print_dec);
  }
  if (exact_test && test->mcep_deviance > -1) {
    write_pch(stdout, "  /  ", 5L);
    write_real(stdout, test->mcep_deviance, print_width, print_dec);
  }
  write_line(stdout);
  write_space(stdout, dept + 1);
  write_pch(stdout, "Power    =", 10L);
  write_real(stdout, test->x_power, print_width, print_dec);
  write_pch(stdout, "   P = ", 7L);
  write_real(stdout, khi(test->df, test->x_power), print_width, print_dec);
  if (adj_df && test->adj != INFINITY) {
    write_pch(stdout, "  /  ", 5L);
    write_real(stdout, khi(df_adj, test->x_power), print_width, print_dec);
  }
  if (exact_test && test->mcep_power > -1) {
    write_pch(stdout, "  /  ", 5L);
    write_real(stdout, test->mcep_power, print_width, print_dec);
  }
  write_line(stdout);
  write_space(stdout, dept + 1);
  write_pch(stdout, "X^2      =", 10L);
  write_real(stdout, test->x_pearson, print_width, print_dec);
  write_pch(stdout, "   P = ", 7L);
  write_real(stdout, khi(test->df, test->x_pearson), print_width, print_dec);
  if (adj_df && test->adj != INFINITY) {
    write_pch(stdout, "  /  ", 5L);
    write_real(stdout, khi(df_adj, test->x_pearson), print_width, print_dec);
  }
  if (exact_test && test->mcep_pearson > -1) {
    write_pch(stdout, "  /  ", 5L);
    write_real(stdout, test->mcep_pearson, print_width, print_dec);
  }
  write_line(stdout);
  write_space(stdout, dept + 1);
  write_pch(stdout, "DF.      =", 10L);
  write_space(stdout, labs(print_width) + 7);
  if (test->df == INFINITY)
    write_real(stdout, test->df_real, print_width, 0L);
  else
    write_integer(stdout, test->df, print_width);
  if (adj_df && test->adj != INFINITY) {
    write_pch(stdout, "  /  ", 5L);
    write_integer(stdout, df_adj, print_width);
  }
  if (exact_test && test->mcep_pearson > -1) {
    write_pch(stdout, "  /  ", 5L);
    write_space(stdout, labs(print_width) - 8);
    write_char(stdout, '(');
    write_integer(stdout, test->number_of_tables, 6L);
    write_char(stdout, ')');
  }
  if (em) {
    write_line(stdout);
    write_space(stdout, dept + 1);
    write_pch(stdout, "Warning: ", 9L);
    write_pch(stdout, "DF. not correct for latent variables!", 37L);
  }
  if (!(ordinal_tests & (!is_invalid_real(test->gamma))))
    return;
  write_line(stdout);
  write_space(stdout, dept + 1);
  write_pch(stdout, "Gamma    =", 10L);
  write_real(stdout, test->gamma, print_width, print_dec);
  write_pch(stdout, "   P = ", 7L);
  if (test->s > 0)
    write_real(stdout, 2 * pnormal(fabs(test->gamma / sqrt(test->s))),
	       print_width, print_dec);
  else
    write_real(stdout, _INVALID_REAL, print_width, print_dec);
  if (adj_df)
    write_pch(stdout, "  /  ", 5L);
  if (exact_test && test->mcep_gamma_1 > -1) {
    write_pch(stdout, "  /  ", 5L);
    write_real(stdout, test->mcep_gamma_1, print_width, print_dec);
    write_real(stdout, test->mcep_gamma_2, print_width, print_dec);
  }
  write_line(stdout);
  write_space(stdout, dept + 1);
  write_pch(stdout, "S.E.(0)  =", 10L);
  if (test->s > 0)
    write_real(stdout, sqrt(test->s), print_width, print_dec);
  else
    write_real(stdout, _INVALID_REAL, print_width, print_dec);
  write_pch(stdout, " (1) = ", 7L);
  if (test->s1 > 0)
    write_real(stdout, sqrt(test->s1), print_width, print_dec);
  else
    write_real(stdout, _INVALID_REAL, print_width, print_dec);
  if (adj_df)
    write_pch(stdout, "  /  ", 5L);
  if (!(exact_test && test->mcep_gamma_1 > -1))
    return;
  write_pch(stdout, "  /  ", 5L);
  write_space(stdout, labs(print_width) - 8);
  write_pch(stdout, "(1-side)", 8L);
  write_space(stdout, labs(print_width) - 8);
  write_pch(stdout, "(2-side)", 8L);
}  /* sub_write_test */


Static long b01(b)
boolean b;
{
  if (b)
    return 1;
  else
    return 0;
}  /* b01 */


/* Local variables for write_test: */
struct LOC_write_test {
  boolean write_models;
} ;


Static Void write_test(test, short_test_output, write_models_, reuse, dept)
t_test *test;
boolean *short_test_output, write_models_, reuse;
long dept;
{
  struct LOC_write_test Local_Var;
  t_long_integer indent, off;

  Local_Var.write_models = write_models_;
  if (Local_Var.write_models)
    off = b01(exclude_missing && partitioning_output &&
	      !(long_names && Local_Var.write_models)) * (dimension + 12) +
	  b01(in_fact_inter) * 5 + b01(adj_df) * 5 +
	  b01(true) * (labs(x_width) - 4);
  else
    off = labs(x_width) - 6;
  indent = (labs(x_width) + labs(prob_width) + 2) * 2 +
	   b01(lambda != 1) * (labs(x_width) + labs(prob_width) + 2) +
	   b01(ic) * (labs(x_width) + 1) + 17;
  indent += off;
  sub_write_test(test, short_test_output, &Local_Var.write_models, reuse,
		 false, true, true, dept, &off, &indent, &indent);
  if (Local_Var.write_models)
    write_line(stdout);
}  /* write_test */


Static Void search_write_test(test, graphical, decomposable, class_)
t_test *test;
boolean *graphical, *decomposable;
long *class_;
{
  t_long_integer indent, off;
  boolean local_short_test_output, local_write_models;

  local_short_test_output = true;
  local_write_models = !short_test_output;
  off = b01(exclude_missing && partitioning_output) * (dimension + 12) +
	b01(in_fact_inter) * 5 + b01(adj_df) * 5 +
	b01(link_eh_pack->link_base != NULL && c_partitioning) * 5 +
	b01(true) * (labs(x_width) - 4) - 5;
  indent = (labs(x_width) + labs(prob_width) + 2) * 2 +
	   b01(lambda != 1) * (labs(x_width) + labs(prob_width) + 2) +
	   b01(ic) * (labs(x_width) + 1) + 17;
  indent += off;
  if (link_eh_pack->link_base != NULL && c_partitioning)
    write_space(stdout, 5L);
  sub_write_test(test, &local_short_test_output, &local_write_models, false,
		 true, *graphical, *decomposable, 0L, &off, &indent, class_);
  write_line(stdout);
}  /* search_write_test */


Static Void write_sorted_list(link_sort_list, short_test_output, write_models)
t_sort_list *link_sort_list;
boolean *short_test_output, *write_models;
{
  t_part_list *p;
  t_vertex_set g, vertex_set;
  t_long_integer offset, dummy_0;
  boolean dummy_true;

  dummy_true = true;
  dummy_0 = 0;
  if (separators)
    offset = 11;
  else
    offset = 0;
  write_line(stdout);
  write_pch(stdout, " Sorted list", 12L);
  write_line(stdout);
  if (*short_test_output) {
    if (*write_models)
      write_test_head(stdout, "  Edge    ", 6L, offset, "Models", 6L,
		      *write_models);
    else
      write_test_head(stdout, "", 0L, -1L, "Edge", 4L,
		      *write_models);
  }
  while (link_sort_list != NULL) {
    if (*write_models) {
      write_space(stdout, 3L);
      print_vertex_set(link_sort_list->vertex_set);
      write_space(stdout, offset);
    }
    p = link_sort_list->link_part_list;
    while (p != NULL) {
      if (exclude_missing && partitioning_output) {
	P_setcpy(g, empty_set);
	add_union_of_gc(p->link_test_list->test.g_c_1, g);
	add_union_of_gc(p->link_test_list->test.g_c_2, g);
	print_n_total_exclude(g, short_test_output, write_models,
			      p->link_test_list->test.n_count, 0L);
      }
      write_test(&p->link_test_list->test, short_test_output, *write_models,
		 dummy_true, dummy_0);
      p = p->pointer;
      if (*write_models)
	write_space(stdout, 3L);
      if (p != NULL)
	write_char(stdout, '+');
      else
	write_char(stdout, '=');
      if (*write_models)
	write_space(stdout, offset + 3);
      if (!*write_models)
	write_line(stdout);
    }
    if (exclude_missing && partitioning_output) {
      P_setcpy(g, empty_set);
      add_union_of_gc(link_sort_list->link_test_list->test.g_c_1, g);
      add_union_of_gc(link_sort_list->link_test_list->test.g_c_2, g);
      print_n_total_exclude(g, short_test_output, write_models,
			    link_sort_list->link_test_list->test.n_count, 0L);
    }
    write_test(&link_sort_list->link_test_list->test, short_test_output,
	       *write_models, dummy_true, dummy_0);
    if (!*write_models) {
      /* write_space(output, 3); */
      print_vertex_set(link_sort_list->vertex_set);
      write_line(stdout);
    }
    p = link_sort_list->link_sepa_list;
    while (p != NULL) {
      if (!*write_models)
	write_test(&p->link_test_list->test, short_test_output, *write_models,
		   dummy_true, dummy_0);
      if (*write_models)
	write_space(stdout, 3L);
      if (*write_models)
	write_char(stdout, '.');
      else {
	P_setdiff(vertex_set, p->link_test_list->test.g_c_1->vertex_set,
		  p->link_test_list->test.g_c_1->pointer->vertex_set);
	print_vertex_set(vertex_set);
      }
      write_char(stdout, '^');
      if (*write_models)
	write_char(stdout, '.');
      else {
	P_setdiff(vertex_set,
		  p->link_test_list->test.g_c_1->pointer->vertex_set,
		  p->link_test_list->test.g_c_1->vertex_set);
	print_vertex_set(vertex_set);
      }
      write_char(stdout, '|');
      P_setint(vertex_set, p->link_test_list->test.g_c_1->vertex_set,
	       p->link_test_list->test.g_c_1->pointer->vertex_set);
      print_vertex_set_table(vertex_set);
      if (*write_models)
	write_space(stdout, 3L);
      else
	write_line(stdout);
      if (*write_models)
	write_test(&p->link_test_list->test, short_test_output, *write_models,
		   dummy_true, dummy_0);
      p = p->pointer;
    }
    link_sort_list = link_sort_list->pointer;
  }
}  /* write_sorted_list */


/*@+"ctest.p"*/


Static long return_df(model_1, model_2, df_real)
t_model *model_1, *model_2;
double *df_real;
{
  t_expression *df_1, *df_2, *q;
  t_vertex_set a, b;
  t_long_integer x, df_integer, sf;

  df_1 = return_dimension_list(model_1);
  df_2 = return_dimension_list(model_2);
  q = df_1;
  while (q != NULL) {
    put_dim_factor(&df_2, q->vertex_set, -q->factor);
    q = q->pointer;
  }
  dispose_expression(&df_1);
  P_setcpy(a, delta);
  q = df_2;
  while (q != NULL) {
    if (!P_setequal(empty_set, q->vertex_set))
      P_setint(a, a, q->vertex_set);
    q = q->pointer;
  }
  x = marginal_dimension(a);
  if (x != INFINITY) {
    df_integer = 0;
    sf = 0;
    q = df_2;
    while (q != NULL && df_integer != INFINITY) {
      if (!P_setequal(empty_set, q->vertex_set)) {
	P_setdiff(b, q->vertex_set, a);
	x = marginal_dimension(b);
	sf += q->factor;
	if (x != INFINITY)
	  df_integer += q->factor * x;
	else
	  df_integer = INFINITY;
      }
      q = q->pointer;
    }
    x = marginal_dimension(a);
    if (x != INFINITY && df_integer < (double)INFINITY / x)
      df_integer = x * df_integer - sf;
    else
      df_integer = INFINITY;
  } else
    df_integer = INFINITY;
  if (df_integer == INFINITY) {
    *df_real = 0.0;
    q = df_2;
    while (q != NULL) {
      P_setdiff(b, q->vertex_set, a);
      *df_real += q->factor * (marginal_dimension_real(b) - 1);
      q = q->pointer;
    }
    *df_real = marginal_dimension_real(a) * *df_real;
  } else
    *df_real = df_integer;
  dispose_expression(&df_2);
  return df_integer;
}  /* return_df */


Static Void find_adjusted_df(model_1, model_2, adj)
t_model *model_1, *model_2;
long *adj;
{
  t_long_integer a, b;

  *adj = INFINITY;
  if (!adj_df || graph_mode)
    return;
  b = count_zero_n(model_1);
  if (b == INFINITY)
    return;
  a = count_zero_par(model_1, model_2);
  if (a != INFINITY)
    *adj = a - b;
}  /* find_adjusted_df */


Static Void compute_test(model_1, model_2, g, p, test)
t_model *model_1, *model_2;
long *g;
t_test_list **p;
t_test *test;
{
  t_long_real x_deviance, x_pearson, x_power;
  boolean ok;

  ok = true;
  x_deviance = _INVALID_REAL;
  x_pearson = _INVALID_REAL;
  x_power = _INVALID_REAL;
  if (!graph_mode) {
    if (em) {
      if (!model_1->found_log_l)
	do_em_model(model_1, &ok);
      if (ok && !model_2->found_log_l)
	do_em_model(model_2, &ok);
    } else
      test_expression_marginals(model_1, model_2, g, &ok);
    if (ok)
      compute_x_deviance_and_x_pearson(model_1, model_2, g, &x_deviance,
				       &x_pearson, &x_power);
    else {
      if (!em) {
	if (!model_1->found_log_l) {
	  model_1->log_l = compute_log_l(model_1, model_1->model_set);
	  model_1->found_log_l = true;
	}
	if (!model_2->found_log_l) {
	  model_2->log_l = compute_log_l(model_2, model_2->model_set);
	  model_2->found_log_l = true;
	}
	x_deviance = 2 * (model_2->log_l - model_1->log_l);
      } else
	write_warning(stdout, " Out of space in `ComputeTest'", 29L);
    }
  }
  clear_test(test);
  copy_set_list(model_1->sets_h_g_c, &test->g_c_1);
  copy_set_list(model_2->sets_h_g_c, &test->g_c_2);
  test->paritet = return_paritet(test->g_c_1, test->g_c_2);
  if (model_1->dim < INFINITY && model_2->dim < INFINITY)
    test->df = model_2->dim - model_1->dim;
  else
    test->df = INFINITY;
  if (test->df == INFINITY)
    test->df = return_df(model_1, model_2, &test->df_real);
  if (ok && test->df < INFINITY)
    find_adjusted_df(model_1, model_2, &test->adj);
  else
    test->adj = INFINITY;
  test->x_deviance = x_deviance;
  test->x_pearson = x_pearson;
  test->x_power = x_power;
  test->ok = (ok || permit_log_l);
  test->n_count = n[0];
  if (re_use_test)
    insert_test(p, test);
}  /* compute_test */


Static Void insert_part(p)
t_test_list **p;
{
  t_part_list *q, *r;

  q = (t_part_list *)Malloc(sizeof(t_part_list));
  if (q == NULL)
    _OutMem();
  q->link_test_list = *p;
  q->pointer = NULL;
  if (link_part_list == NULL) {
    link_part_list = q;
    return;
  }
  r = link_part_list;
  while (r->pointer != NULL)
    r = r->pointer;
  r->pointer = q;
}  /* insert_part */


Static Void insert_test_in_sort_list(p, down, link_sort_list)
t_sort_list **p;
boolean down;
t_sort_list **link_sort_list;
{
  t_sort_list *q;

  (*p)->x = select_p_value((*p)->link_test_list);
  /*$ifdef TRACE*/
  if (boolean_option[2]) {
    write_real(stdout, (*p)->x, 10L, 6L);
    write_line(stdout);
  }
  /*$endif TRACE*/
  if (down)
    (*p)->x = -(*p)->x;
  if (*link_sort_list == NULL) {
    *link_sort_list = *p;
    return;
  }
  if ((*p)->x <= (*link_sort_list)->x) {
    (*p)->pointer = *link_sort_list;
    *link_sort_list = *p;
    return;
  }
  if ((*link_sort_list)->pointer == NULL) {
    (*link_sort_list)->pointer = *p;
    (*p)->pointer = NULL;
    return;
  }
  q = *link_sort_list;
  while ((*p)->x > q->pointer->x && q->pointer->pointer != NULL)
    q = q->pointer;
  if ((*p)->x <= q->pointer->x) {
    (*p)->pointer = q->pointer;
    q->pointer = *p;
  } else {
    q->pointer->pointer = *p;
    (*p)->pointer = NULL;
  }
}  /* insert_test_in_sort_list */


Local boolean found_test(g_c_a, g_c_b, test)
t_set_list **g_c_a, **g_c_b;
t_test *test;
{
  boolean Result;

  Result = false;
  if (!test_list_of_sets_subset_of_list_of_sets(test->g_c_2, *g_c_b))
    return Result;
  if (test_list_of_sets_subset_of_list_of_sets(test->g_c_1, *g_c_a)) {
    if (test_list_of_sets_subset_of_list_of_sets(*g_c_b, test->g_c_2))
      return (test_list_of_sets_subset_of_list_of_sets(*g_c_a, test->g_c_1));
  }
  return Result;
}  /* found_test */


/*@+"rtest.p"*/


Static boolean return_test(g_c_a, g_c_b, p, test)
t_set_list **g_c_a, **g_c_b;
t_test_list **p;
t_test *test;
{
  boolean found;
  t_long_integer paritet;
  t_2_3_key key;
  t_part_list *q;

  /*$ifdef TRACE*/
  if (boolean_option[19]) {
    write_line(stdout);
    write_pch(stdout, " Return test:", 13L);
    print_g_c(*g_c_a, 10L, line_length);
    write_pch(stdout, " against ", 9L);
    print_g_c(*g_c_b, 10L, line_length);
    write_line(stdout);
  }
  /*$endif TRACE*/
  if (re_use_test) {
    found = false;
    paritet = return_paritet(*g_c_a, *g_c_b);
    if (c_factorizes != 1) {
      key = paritet;
      find_test_in_2_3_tree(&key, &q);
      while (q != NULL && !found) {
	if (paritet == q->link_test_list->test.paritet)
	  found = found_test(g_c_a, g_c_b, &q->link_test_list->test);
	if (found)
	  *p = q->link_test_list;
	else
	  q = q->pointer;
      }
    } else {
      *p = link_test_list;
      while (*p != NULL && !found) {
	if (paritet == (*p)->test.paritet)
	  found = found_test(g_c_a, g_c_b, &(*p)->test);
	if (!found)
	  *p = (*p)->pointer;
      }
    }
    if (exact_test && found)
      found = ((*p)->test.number_of_tables == number_of_tables ||
	       number_of_tables == 0 && (*p)->test.number_of_tables > 0);
    if (found)
      *test = (*p)->test;
    return (test->ok && found);
  } else
    return false;
}  /* return_test */


Static Void test_models(model_1, model_2, g, short_test_output, write_tests,
			dept)
t_model *model_1, *model_2;
long *g;
boolean *short_test_output, *write_tests;
long dept;
{
  boolean reuse;
  t_test test;
  t_test_list *p;

  clear_test(&test);
  if (return_test(&model_1->sets_h_g_c, &model_2->sets_h_g_c, &p, &test))
    reuse = true;
  else {
    reuse = false;
    compute_test(model_1, model_2, g, &p, &test);
    if (exact_test_for_test_models && exact_test && model_1->decomposable &&
	model_2->decomposable && model_1->graphical && model_2->graphical)
      test_exact_test(model_1, model_2, &p, &test);
  }
  if (!just)
    write_test(&test, short_test_output, *write_tests, reuse, dept);
  insert_part(&p);
}  /* test_models */


/*@+"sumup.p"*/


Static Void remove_sub_cliques(add_list, list_of_cliques)
t_set_list **add_list, **list_of_cliques;
{
  t_set_list *p, *q;
  boolean b;

  p = *list_of_cliques;
  *list_of_cliques = NULL;
  while (p != NULL) {
    b = true;
    q = *add_list;
    while (q != NULL && b) {
      if (P_subset(p->vertex_set, q->vertex_set))
	b = false;
      else
	q = q->pointer;
    }
    if (b)
      insert_clique(p->vertex_set, list_of_cliques);
    q = p;
    p = p->pointer;
    Free(q);
  }
}  /* remove_sub_cliques */


Static Void add_not_sub_cliques(add_list, list_of_sets, list_of_cliques)
t_set_list *add_list, **list_of_sets, **list_of_cliques;
{
  while (add_list != NULL) {
    if (!subset_of_an_edge(add_list->vertex_set, list_of_sets))
      insert_clique(add_list->vertex_set, list_of_cliques);
    add_list = add_list->pointer;
  }
}  /* add_not_sub_cliques */


Static Void sum_up_partitioning(link_sort_list, direction, parted,
  short_test_output, write_models, just, excl, dept)
t_sort_list **link_sort_list;
long direction;
boolean *parted, *short_test_output, *write_models, *just, excl;
long dept;
{
  boolean reuse;
  t_test test, ret_test;

  *link_sort_list = (t_sort_list *)Malloc(sizeof(t_sort_list));
  if (*link_sort_list == NULL)
    _OutMem();
  (*link_sort_list)->pointer = NULL;
  if (link_part_list->pointer == NULL) {
    (*link_sort_list)->link_sepa_list = NULL;
    (*link_sort_list)->link_part_list = NULL;
    (*link_sort_list)->link_test_list = link_part_list->link_test_list;
    Free(link_part_list);
    link_part_list = NULL;
    return;
  }
  (*link_sort_list)->link_sepa_list = NULL;
  (*link_sort_list)->link_part_list = link_part_list;
  clear_test(&test);
  test.ok = true;
  test.df = 0;
  test.adj = 0;
  test.x_deviance = 0.0;
  test.x_pearson = 0.0;
  test.x_power = 0.0;
  if (link_part_list != NULL) {
    if (link_part_list == NULL) {
      test.gamma = link_part_list->link_test_list->test.gamma;
      test.s = link_part_list->link_test_list->test.s;
      test.s1 = link_part_list->link_test_list->test.s1;
    }
  }
  while (link_part_list != NULL) {
    switch (direction) {

    case -1:
      remove_sub_cliques(&link_part_list->link_test_list->test.g_c_2,
			 &test.g_c_1);
      add_cliques(link_part_list->link_test_list->test.g_c_1, &test.g_c_1);
      break;

    case 0:
      add_cliques(link_part_list->link_test_list->test.g_c_1, &test.g_c_1);
      break;

    case 1:
      add_not_sub_cliques(link_part_list->link_test_list->test.g_c_1,
			  &test.g_c_2, &test.g_c_1);
      break;

    }
    add_cliques(link_part_list->link_test_list->test.g_c_2, &test.g_c_2);
    test.df += link_part_list->link_test_list->test.df;
    test.adj += link_part_list->link_test_list->test.adj;
    if (link_part_list->link_test_list->test.ok) {
      test.x_deviance += link_part_list->link_test_list->test.x_deviance;
      if (em) {
	test.x_pearson = _INVALID_REAL;
	test.x_power = _INVALID_REAL;
      } else {
	test.x_pearson += link_part_list->link_test_list->test.x_pearson;
	test.x_power += link_part_list->link_test_list->test.x_power;
      }
    } else {
      test.x_deviance = _INVALID_REAL;
      test.x_pearson = _INVALID_REAL;
      test.x_power = _INVALID_REAL;
      test.ok = false;
    }
    link_part_list = link_part_list->pointer;
  }
  test.paritet = return_paritet(test.g_c_1, test.g_c_2);
  if (exclude_missing)
    test.n_count = _INVALID_COUNT;
  else
    test.n_count = n[0];
  reuse = false;
  clear_test(&ret_test);
  if (return_test(&test.g_c_1, &test.g_c_2,
		  &(*link_sort_list)->link_test_list, &ret_test)) {
    if (test.df == ret_test.df &&
	fabs(test.x_pearson - ret_test.x_pearson) / test.x_pearson < 0.0001) {
      dispose_set_list(&test.g_c_1);
      test.g_c_1 = ret_test.g_c_1;
      dispose_set_list(&test.g_c_2);
      test.g_c_2 = ret_test.g_c_2;
      reuse = true;
    }
  }
  if (!reuse) {
    insert_test(&(*link_sort_list)->link_test_list, &test);
    if (exact_test_for_sum_up && exact_test)
      test_exact_test_g_c(&test.g_c_1, &test.g_c_2,
			  &(*link_sort_list)->link_test_list, &test);
  }
  if (*just)
    return;
  if (excl) {
    if (*short_test_output) {
      write_pch(stdout, "  Diff. counts", 14L);
      write_space(stdout, dimension - 3L);
      write_char(stdout, '?');
    } else {
      write_pch(stdout, " Different case-numbers", 23L);
      write_line(stdout);
    }
  }
  write_test(&test, short_test_output, *write_models, reuse, dept);
}  /* sum_up_partitioning */


/*@+"onee.p"*/


Static Void one_edge_collaps_set(c, bv, bw, v, w, p_test, short_test_output,
				 write_models, just)
long *c, *bv, *bw;
t_vertex *v, *w;
t_test_list **p_test;
boolean *short_test_output, *write_models, *just;
{
  boolean ok, reuse;
  t_model model_a, model_b;
  t_test test;
  t_long_integer dummy_0;
  t_vertex_set vertex_set;
  t_offset bv_offset, bw_offset, c_offset;
  t_slice_pack slice_pack;

  dummy_0 = 0;
  if (incomplete_table) {
    write_pch(stdout, " *** WARNING ***  OneEdgeCollaps used on", 40L);
    write_pch(stdout, " Incomplete Table  *** WARNING ***", 34L);
    write_line(stdout);
  }
  if (!*short_test_output && !*just) {
    write_pch(stdout, " Collaps onto ", 14L);
    print_vertex_set(c);
    write_line(stdout);
  }
  erase_model(&model_a);
  erase_model(&model_b);
  insert_set_in_set_list(bv, &model_a.sets_h_g_c);
  insert_set_in_set_list(bw, &model_a.sets_h_g_c);
  insert_set_in_set_list(c, &model_b.sets_h_g_c);
  P_setcpy(model_a.model_set, c);
  P_setcpy(model_b.model_set, c);
  clear_test(&test);
  if (return_test(&model_a.sets_h_g_c, &model_b.sets_h_g_c, p_test, &test)) {
    if (exclude_missing && !*just)
      print_n_total_exclude(c, short_test_output, write_models, test.n_count,
			    0L);
    reuse = true;
  } else {
    reuse = false;
    if (exclude_missing)
      print_do_exclude(model_a.model_set, short_test_output, write_models, 0L);
    P_setdiff(vertex_set, delta, c);
    model_a.constant = 1 / marginal_dimension_real(vertex_set);
    model_b.constant = model_a.constant;
    put_factor(&model_a.expression, bv, 1L);
    put_factor(&model_a.expression, bw, 1L);
    put_factor(&model_a.expression, empty_set, -1L);
    P_setint(vertex_set, bv, bw);
    put_factor(&model_a.expression, vertex_set, -1L);
    put_factor(&model_b.expression, c, 1L);
    put_factor(&model_b.expression, empty_set, -1L);
    if ((marginal_dimension(bv) < INFINITY) & (marginal_dimension(bw) < INFINITY))
      model_a.dim = marginal_dimension(bv) +
		    marginal_dimension(bw) - marginal_dimension(vertex_set);
    else
      model_a.dim = INFINITY;
    if (marginal_dimension(c) < INFINITY)
      model_b.dim = marginal_dimension(c);
    else
      model_b.dim = INFINITY;
    model_a.found_expression = true;
    model_b.found_expression = true;
    model_a.found_ps = !em;
    model_b.found_ps = !em;
    compute_test(&model_a, &model_b, c, p_test, &test);
  }
  insert_part(p_test);
  if (!reuse) {
    if (ordinal_tests && !(em || incomplete_table)) {
      if (P_inset(*v, ordinal_factors) & P_inset(*w, ordinal_factors)) {
	P_setint(vertex_set, bv, bw);
	bv_offset = return_offset(bv, &ok);
	if (ok)
	  bw_offset = return_offset(bw, &ok);
	if (ok)
	  c_offset = return_offset(c, &ok);
	if (ok) {
	  find_slice_products(vertex_set, bv, bw, c, v, w, &slice_pack);
	  compute_slice_statistics(v, w, &vertex_inf[*v - MIN_VERTEX].levels,
	    &vertex_inf[*w - MIN_VERTEX].levels, vertex_set, bv_offset,
	    bw_offset, c_offset, &slice_pack, &test.gamma, &test.s, &test.s1,
	    false);
	  (*p_test)->test.gamma = test.gamma;
	  (*p_test)->test.s = test.s;
	  (*p_test)->test.s1 = test.s1;
	}
      }
    }
  }
  if (!exact_test) {
    if (!*just)
      write_test(&test, short_test_output, *write_models, reuse, dummy_0);
  } else if (test.ok) {
    if (!TURBO_PC)
      ok = space_in_n_array(marginal_dimension(c), fna);
    if (marginal_dimension(c) <= max_cell_number - fna) {
      if ((!reuse) & (select_asymptotic_p_value(*p_test) < asymptotic_limit)) {
	if (fast && c_factorizes == 2)
	  compute_mcep_one_edge_set(c, bv, bw, v, w, p_test, &test);
	else
	  compute_mcep_one_edge_set_old(c, bv, bw, v, w, &model_a, &model_b,
					p_test, &test);
      }
      if (!*just)
	write_test(&test, short_test_output, *write_models, reuse, dummy_0);
    } else {
      if (!*just)
	write_test(&test, short_test_output, *write_models, reuse, dummy_0);
      write_pch(stdout, " Out of space in Exact Test", 27L);
      write_line(stdout);
    }
  } else {
    if (!*just)
      write_test(&test, short_test_output, *write_models, reuse, dummy_0);
    write_pch(stdout, " Out of space in One Edge", 25L);
    write_line(stdout);
  }
  if (em) {
    write_pch(stdout, " *** WARNING ***  OneEdgeCollaps used on", 40L);
    write_pch(stdout, " Incomplete Data   *** WARNING ***", 34L);
    write_line(stdout);
  }
  dispose_marginals_cond();
  dispose_set_list(&model_a.sets_h_g_c);
  dispose_set_list(&model_b.sets_h_g_c);
  dispose_expression(&model_a.expression);
  dispose_expression(&model_b.expression);
}  /* one_edge_collaps_set */


Static Void one_edge_collaps(adj_set, v, w, p_test, short_test_output,
			     write_models, just)
t_vertex_set *adj_set;
t_vertex *v, *w;
t_test_list **p_test;
boolean *short_test_output, *write_models, *just;
{
  t_vertex u;
  t_vertex_set a, b, c, bv, bw, SET;
  t_vertex FORLIM;

  P_addset(P_expset(a, 0L), *v);
  P_addset(a, *w);
  P_setcpy(b, empty_set);
  FORLIM = last_vertex;
  for (u = first_vertex; u <= FORLIM; u++) {
    if (P_subset(a, adj_set[u - MIN_VERTEX]))
      P_addset(b, u);
  }
  P_addset(P_expset(bv, 0L), *v);
  P_setunion(bv, b, bv);
  P_addset(P_expset(bw, 0L), *w);
  P_setunion(bw, b, bw);
  P_setunion(c, a, b);
  one_edge_collaps_set(c, bv, bw, v, w, p_test, short_test_output,
		       write_models, just);
}  /* one_edge_collaps */


Static boolean test_if_one_edge_decomposable(g_c_1, g_c_2, p_test, test,
  short_test_output, write_models, just, dept)
t_set_list **g_c_1, **g_c_2;
t_test_list **p_test;
t_test *test;
boolean *short_test_output, *write_models, *just;
long dept;
{
  boolean Result;
  t_vertex_set g;
  t_edge_list *link_edge_list, *p;
  t_v_arr_of_v_sets adj_set_1, adj_set_2;
  t_v_arr_of_v_lists adj_list_2;
  t_vertex v, w;

  Result = false;
  if (incomplete_table)
    return Result;
  hypergraph_sets_to_graph_sets(*g_c_1, g, adj_set_1);
  hypergraph_sets_to_graph_sets(*g_c_2, g, adj_set_2);
  link_edge_list = NULL;
  adj_set_to_adj_list(adj_set_2, adj_list_2);
  find_edges(adj_list_2, adj_set_1, &link_edge_list);
  dispose_adj_list(adj_list_2);
  if (link_edge_list == NULL)
    return Result;
  if (link_edge_list->pointer == NULL) {
    Result = true;
    v = link_edge_list->v;
    w = link_edge_list->w;
    one_edge_collaps(adj_set_1, &v, &w, p_test, short_test_output,
		     write_models, just);
  }
  while (link_edge_list != NULL) {
    p = link_edge_list;
    link_edge_list = link_edge_list->pointer;
    Free(p);
  }
  return Result;
}  /* test_if_one_edge_decomposable */


Static boolean test_if_one_edge(g_c_current, g_c_base, p_test, test,
				short_test_output, write_models, just, dept)
t_set_list **g_c_current, **g_c_base;
t_test_list **p_test;
t_test *test;
boolean *short_test_output, *write_models, *just;
long *dept;
{
  boolean Result;

  Result = false;
  if (*g_c_base == NULL || *g_c_current == NULL)
    return Result;
  if ((*g_c_current)->pointer != NULL) {
    if ((*g_c_base)->pointer == NULL &&
	(*g_c_current)->pointer->pointer == NULL)
      return (test_if_one_edge_decomposable(g_c_current, g_c_base, p_test,
		test, short_test_output, write_models, just, *dept));
  }
  return Result;
}  /* test_if_one_edge */


Static Void test_one_edge_collaps(model_current, model_base, p_test)
t_model *model_current, *model_base;
t_test_list **p_test;
{
  t_test test;
  boolean local_short_test_output, local_just;

  local_short_test_output = false;
  local_just = false;
  if (!test_if_one_edge_decomposable(&model_current->sets_h_g_c,
	&model_base->sets_h_g_c, p_test, &test, &local_short_test_output,
	&local_just, &local_just, 0L))
    write_pch(stdout, " More than one edge.", 20L);
}  /* test_one_edge_collaps */


/*@+"part.p"*/


Static Void test_generating_classes(g_c_1, g_c_2, g, short_test_output,
				    write_models, dept)
t_set_list **g_c_1, **g_c_2;
long *g;
boolean *short_test_output, *write_models;
long *dept;
{
  boolean reuse, ok, local_just;
  t_model model_1, model_2;
  t_test_list *p, *link_test;

  new_test(&link_test);
  p = NULL;
  if (return_test(g_c_1, g_c_2, &p, &link_test->test)) {
    reuse = true;
    if (!just) {
      if (exclude_missing)
	print_n_total_exclude(g, short_test_output, write_models,
			      link_test->test.n_count, *dept);
      write_test(&link_test->test, short_test_output, *write_models, reuse,
		 *dept);
    }
    insert_part(&p);
  } else {
    local_just = true;
    if (test_if_one_edge(g_c_1, g_c_2, &p, &link_test->test,
			 short_test_output, write_models, &local_just,
			 dept)) {
      reuse = false;
      link_test->test = p->test;
      if (!link_test->test.ok && re_use_test) {
	copy_set_list(*g_c_1, &link_test->test.g_c_1);
	copy_set_list(*g_c_2, &link_test->test.g_c_2);
	link_test->test.paritet = return_paritet(link_test->test.g_c_1,
						 link_test->test.g_c_2);
	link_test->test.n_count = n[0];
	insert_test(&p, &link_test->test);
      } else if (!link_test->test.ok) {
	link_test->test.g_c_1 = *g_c_1;
	link_test->test.g_c_2 = *g_c_2;
      }
      if (!just)
	write_test(&link_test->test, short_test_output, *write_models, reuse,
		   *dept);
    } else {
      if (exclude_missing)
	print_do_exclude(g, short_test_output, write_models, *dept);
      reuse = false;
      erase_model(&model_1);
      model_1.sets_h_g_c = *g_c_1;
      ok = ok_model_to_test(&model_1);
      dispose_marginals_cond();
      link_test->test.ok = false;
      if (ok) {
	erase_model(&model_2);
	model_2.sets_h_g_c = *g_c_2;
	ok = ok_model_to_test(&model_2);
	dispose_marginals_cond();
	if (ok)
	  compute_test(&model_1, &model_2, g, &p, &link_test->test);
	if (exact_test_for_partitioning && exact_test &&
	    model_1.decomposable && model_2.decomposable &&
	    model_1.graphical && model_2.graphical)
	  test_exact_test(&model_1, &model_2, &p, &link_test->test);
	dispose_marginals_cond();
	model_2.sets_h_g_c = NULL;
	dispose_model(&model_2);
      }
      model_1.sets_h_g_c = NULL;
      dispose_model(&model_1);
      if (fpa < P_START - FIRST_INDEX)
	fpa = P_START - FIRST_INDEX;
      if (!link_test->test.ok && re_use_test) {
	copy_set_list(*g_c_1, &link_test->test.g_c_1);
	copy_set_list(*g_c_2, &link_test->test.g_c_2);
	link_test->test.paritet = return_paritet(link_test->test.g_c_1,
						 link_test->test.g_c_2);
	link_test->test.n_count = n[0];
	insert_test(&p, &link_test->test);
      } else if (!link_test->test.ok) {
	link_test->test.g_c_1 = *g_c_1;
	link_test->test.g_c_2 = *g_c_2;
      }
      if (!just)
	write_test(&link_test->test, short_test_output, *write_models, reuse,
		   *dept);
      insert_part(&p);
    }
  }
  Free(link_test);
}  /* test_generating_classes */


Static Void print_partitioning(adj_list, g, list_of_sets, dept)
t_vertex_list **adj_list;
long *g;
t_set_list *list_of_sets;
long dept;
{
  t_set_list *p;
  t_vertex_set a, d, b, vertex_set;
  t_vertex u;

  if (list_of_sets == NULL)
    return;
  p = list_of_sets;
  write_space(stdout, dept + 1);
  write_pch(stdout, "Decompositions:  ", 17L);
  write_line(stdout);
  while (list_of_sets != NULL) {
    u = first_vertex;
    P_setdiff(vertex_set, g, list_of_sets->vertex_set);
    while (!P_inset(u, vertex_set))
      u++;
    find_connected_component(g, list_of_sets->vertex_set, a, &u, adj_list);
    write_space(stdout, dept + 1);
    P_setunion(vertex_set, a, list_of_sets->vertex_set);
    print_vertex_set_table(vertex_set);
    write_char(stdout, '(');
    write_integer(stdout, cardinality(vertex_set), 3L);
    write_pch(stdout, ") / ", 4L);
    print_vertex_set_table(list_of_sets->vertex_set);
    write_char(stdout, '(');
    write_integer(stdout, cardinality(list_of_sets->vertex_set), 3L);
    write_pch(stdout, ") / ", 4L);
    P_setdiff(vertex_set, g, a);
    print_vertex_set_table(vertex_set);
    write_char(stdout, '(');
    write_integer(stdout, cardinality(vertex_set), 3L);
    write_char(stdout, ')');
    write_line(stdout);
    list_of_sets = list_of_sets->pointer;
  }
  list_of_sets = p;
  write_space(stdout, dept + 1);
  write_pch(stdout, "Selected: ", 10L);
  write_line(stdout);
  pick_partitioning(adj_list, g, list_of_sets, a, d, b);
  write_space(stdout, dept + 1);
  P_setunion(vertex_set, a, d);
  print_vertex_set_table(vertex_set);
  write_char(stdout, '(');
  write_integer(stdout, cardinality(vertex_set), 3L);
  write_pch(stdout, ") / ", 4L);
  print_vertex_set_table(d);
  write_char(stdout, '(');
  write_integer(stdout, cardinality(d), 3L);
  write_pch(stdout, ") / ", 4L);
  P_setunion(vertex_set, d, b);
  print_vertex_set_table(vertex_set);
  write_char(stdout, '(');
  write_integer(stdout, cardinality(vertex_set), 3L);
  write_char(stdout, ')');
  write_line(stdout);
}  /* print_partitioning */


Static Void write_partitioning(model_1, model_2)
t_model *model_1, *model_2;
{
  t_set_list *list_of_sets;
  t_vertex_set g;
  t_v_arr_of_v_lists adj_list;
  t_v_arr_of_v_sets adj_set;

  if (!test_hier_submodel(&model_1->sets_h_g_c, &model_2->sets_h_g_c, false,
			  false, 0L))
    return;
  hypergraph_sets_to_graph_sets(model_2->sets_h_g_c, g, adj_set);
  adj_set_to_adj_list(adj_set, adj_list);
  find_partitioning(&model_1->sets_h_g_c, &model_2->sets_h_g_c, adj_list,
		    adj_set, g, true, &list_of_sets);
  print_partitioning(adj_list, g, list_of_sets, 1L);
  dispose_adj_list(adj_list);
  dispose_set_list(&list_of_sets);
}  /* write_partitioning */


Static Void partitioning_hierarchical(g_c_1, g_c_2, short_test_output,
				      write_models, number_of_tests, dept)
t_set_list **g_c_1, **g_c_2;
boolean *short_test_output, *write_models;
long *number_of_tests, dept;
{
  t_v_arr_of_v_lists adj_list;
  t_v_arr_of_v_sets adj_set;
  t_vertex_set a, b, d, g, apd, bpd;
  t_set_list *list_of_sets, *g_c_a1, *g_c_a2, *g_c_b1, *g_c_b2;
  boolean ok;

  if (!test_hier_submodel(g_c_1, g_c_2, *short_test_output, *write_models,
			  dept))
    return;
  hypergraph_sets_to_graph_sets(*g_c_2, g, adj_set);
  adj_set_to_adj_list(adj_set, adj_list);
  ok = false;
  find_partitioning(g_c_1, g_c_2, adj_list, adj_set, g, true, &list_of_sets);
  if (report && !*short_test_output)
    print_partitioning(adj_list, g, list_of_sets, dept);
  if (list_of_sets != NULL) {
    pick_partitioning(adj_list, g, list_of_sets, a, d, b);
    dispose_set_list(&list_of_sets);
    P_setunion(apd, a, d);
    P_setunion(bpd, b, d);
    ok = test_decomposable_hypergraph(g_c_1, apd, bpd, d, &g_c_a1, &g_c_b1);
    ok = test_decomposable_hypergraph(g_c_2, apd, bpd, d, &g_c_a2, &g_c_b2);
  }
  dispose_adj_list(adj_list);
  if (ok) {
    if (!*short_test_output && !just) {
      write_space(stdout, dept + 1);
      write_pch(stdout, "Test of ", 8L);
      print_g_c(*g_c_1, dept + 10, line_length);
      write_line(stdout);
      write_space(stdout, dept + 1);
      write_pch(stdout, "against ", 8L);
      print_g_c(*g_c_2, dept + 10, line_length);
      write_line(stdout);
      write_space(stdout, dept + 1);
      write_pch(stdout, "Partition of ", 13L);
      print_vertex_set(g);
      write_pch(stdout, " in ", 4L);
      print_vertex_set(apd);
      write_char(stdout, ',');
      print_vertex_set(bpd);
      write_pch(stdout, " by ", 4L);
      print_vertex_set(d);
      write_line(stdout);
    }
    partitioning_hierarchical(&g_c_a1, &g_c_a2, short_test_output,
			      write_models, number_of_tests, dept + 2);
    dispose_set_list(&g_c_a1);
    dispose_set_list(&g_c_a2);
    partitioning_hierarchical(&g_c_b1, &g_c_b2, short_test_output,
			      write_models, number_of_tests, dept + 2);
    dispose_set_list(&g_c_b1);
    dispose_set_list(&g_c_b2);
    return;
  }
  if (*short_test_output && *number_of_tests != 0 && !just) {
    if (*write_models)
      write_space(stdout, 3L);
    write_char(stdout, '+');
    if (*write_models)
      write_space(stdout, 3L);
    if (*write_models) {
      if (separators)
	write_space(stdout, 11L);
    } else
      write_line(stdout);
  }
  if (!*short_test_output && !just) {
    write_space(stdout, dept + 1);
    write_pch(stdout, "Test on ", 8L);
    print_vertex_set(g);
    write_line(stdout);
  }
  (*number_of_tests)++;
  test_generating_classes(g_c_1, g_c_2, g, short_test_output, write_models,
			  &dept);
}  /* partitioning_hierarchical */


Static Void do_partitioning(d, model_1, model_2)
long *d;
t_model *model_1, *model_2;
{
  t_set_list *g_c_a1, *g_c_a2, *g_c_b1, *g_c_b2;
  t_v_arr_of_v_lists adj_list_2;
  t_v_arr_of_v_sets adj_set_2;
  t_vertex_set a, b, a0, g, vertex_set;
  t_vertex u;
  boolean ok;

  ok = false;
  if (test_hier_submodel(&model_1->sets_h_g_c, &model_2->sets_h_g_c, false,
			 false, 0L)) {
    hypergraph_sets_to_graph_sets(model_2->sets_h_g_c, g, adj_set_2);
    if (!P_setequal(g, d)) {
      adj_set_to_adj_list(adj_set_2, adj_list_2);
      u = first_vertex;
      P_setdiff(vertex_set, g, d);
      while ((u < last_vertex) & (!P_inset(u, vertex_set)))
	u++;
      find_connected_component(g, d, a0, &u, adj_list_2);
      dispose_adj_list(adj_list_2);
      P_setunion(a, a0, d);
      P_setdiff(b, g, a0);
      if (!P_setequal(g, a)) {
	if (test_decomposable_hypergraph(&model_1->sets_h_g_c, a, b, d,
					 &g_c_a1, &g_c_b1)) {
	  if (test_decomposable_hypergraph(&model_2->sets_h_g_c, a, b, d,
					   &g_c_a2, &g_c_b2)) {
	    ok = true;
	    insert_set_list_in_new_model(&g_c_a1);
	    insert_set_list_in_new_model(&g_c_b1);
	    insert_set_list_in_new_model(&g_c_a2);
	    insert_set_list_in_new_model(&g_c_b2);
	  } else {
	    dispose_set_list(&g_c_a1);
	    dispose_set_list(&g_c_b1);
	  }
	}
      }
    }
  }
  if (!ok) {
    write_pch(stdout, " No partitioning", 16L);
    write_line(stdout);
  }
}  /* do_partitioning */


Static Void silent_partitioning(current_model, base_model, p, test,
				short_test_output, write_models)
t_model *current_model, *base_model;
t_test_list **p;
t_test *test;
boolean *short_test_output, *write_models;
{
  t_part_list *tmp_link_part_list;
  t_sort_list *link_sort_list;
  t_long_integer dummy;
  boolean tmp_just, tmp_exact;

  tmp_link_part_list = link_part_list;
  tmp_just = just;
  tmp_exact = exact_test;
  just = true;
  exact_test = false;
  link_part_list = NULL;
  link_sort_list = NULL;
  *p = NULL;
  dummy = 0;
  partitioning_hierarchical(&current_model->sets_h_g_c,
			    &base_model->sets_h_g_c, short_test_output,
			    write_models, &dummy, 0L);
  if (link_part_list != NULL) {
    if (link_part_list->pointer != NULL) {
      sum_up_partitioning(&link_sort_list, 0L, &c_partitioning,
			  short_test_output, write_models, &just,
			  exclude_missing && partitioning_output, 0L);
      *p = link_sort_list->link_test_list;
      link_sort_list->link_test_list = NULL;
    } else {
      *p = link_part_list->link_test_list;
      link_part_list->link_test_list = NULL;
    }
    dispose_sort_list(&link_sort_list);
    dispose_part_list(&link_part_list);
  }
  if (*p != NULL)
    *test = (*p)->test;
  link_part_list = tmp_link_part_list;
  just = tmp_just;
  exact_test = tmp_exact;
}  /* silent_partitioning */


Static Void return_test_and_write(model_1, model_2, g, short_test_output,
  write_models, just, exclude, dept, reuse, p, test)
t_model *model_1, *model_2;
long *g;
boolean *short_test_output, *write_models, just, exclude;
long dept;
boolean *reuse;
t_test_list **p;
t_test *test;
{
  clear_test(test);
  if (return_test(&model_1->sets_h_g_c, &model_2->sets_h_g_c, p, test)) {
    if (exclude && !just)
      print_n_total_exclude(g, short_test_output, write_models, test->n_count,
			    dept);
    *reuse = true;
  } else {
    *reuse = false;
    if (exclude && !just)
      print_do_exclude(model_1->model_set, short_test_output, write_models,
		       0L);
    compute_test(model_1, model_2, g, p, test);
  }
  if (!just)
    write_test(test, short_test_output, *write_models, *reuse, dept);
  insert_part(p);
}  /* return_test_and_write */


Static Void factorization_one_edge_exact(model_1, model_2, p_test, just,
					 short_test_output, write_models)
t_model *model_1, *model_2;
t_test_list **p_test;
boolean just, *short_test_output, *write_models;
{
  boolean reuse;
  t_test test;
  t_long_integer dummy_0;
  t_vertex_set vertex_set;

  P_setunion(vertex_set, model_1->model_set, model_2->model_set);
  return_test_and_write(model_1, model_2, vertex_set, short_test_output,
			write_models, true, false, 0L, &reuse, p_test, &test);
  if (test.ok) {
    dummy_0 = 0;
    if (is_invalid_real(test.x_deviance))
      silent_partitioning(model_1, model_2, p_test, &test, short_test_output,
			  write_models);
    if (!reuse)
      compute_mcep_nested_decomposable(model_1, model_2, false, p_test, &test);
    if (!just)
      write_test(&test, short_test_output, *write_models, reuse, dummy_0);
    return;
  }
  write_pch(stdout, " Out of space in ExactTest of ", 30L);
  print_g_c_from(model_1->sets_h_g_c, 38L, 8L, line_length);
  write_line(stdout);
  write_space(stdout, 7L);
  write_pch(stdout, " against ", 9L);
  print_g_c_from(model_2->sets_h_g_c, 17L, 8L, line_length);
  write_line(stdout);
}  /* factorization_one_edge_exact */


/*@-"edit.c"*/
/*@+"drop.p"*/


Static Void sub_drop_edge_from_g_c(new_g_c, old_g_c, v, w)
t_set_list **new_g_c, **old_g_c;
t_vertex v, w;
{
  t_vertex_set a, b;
  t_set_list *tmp_g_c;

  /*$ifdef TRACE*/
  if (boolean_option[27]) {
    write_char(stdout, '(');
    print_vertex(v);
    write_char(stdout, ',');
    print_vertex(w);
    write_char(stdout, ';');
    print_g_c(*old_g_c, 0L, line_length);
    write_char(stdout, ')');
  }
  P_addset(P_expset(a, 0L), v);
  P_addset(a, w);
  /*$endif TRACE*/
  if (!subset_of_an_edge(a, old_g_c)) {
    copy_set_list(*old_g_c, new_g_c);
    return;
  }
  *new_g_c = NULL;
  tmp_g_c = *old_g_c;
  while (tmp_g_c != NULL) {
    if (P_subset(a, tmp_g_c->vertex_set)) {
      P_addset(P_expset(b, 0L), v);
      P_setdiff(b, tmp_g_c->vertex_set, b);
      insert_clique(b, new_g_c);
      P_addset(P_expset(b, 0L), w);
      P_setdiff(b, tmp_g_c->vertex_set, b);
      insert_clique(b, new_g_c);
    } else
      insert_clique(tmp_g_c->vertex_set, new_g_c);
    tmp_g_c = tmp_g_c->pointer;
  }
}  /* sub_drop_edge_from_g_c */


Static Void new_drop_edges_from_g_c(new_g_c, old_g_c, drop_g_c)
t_set_list **new_g_c, **old_g_c, **drop_g_c;
{
  t_vertex v, w;
  t_vertex_set g, a;
  t_edge_list *p, *edge_list;
  t_set_list *tmp_g_c;
  t_vertex FORLIM, FORLIM1;

  P_setcpy(g, empty_set);
  add_union_of_gc(*old_g_c, g);
  edge_list = NULL;
  FORLIM = last_vertex;
  for (v = first_vertex; v < FORLIM; v++) {
    FORLIM1 = last_vertex;
    for (w = v + 1; w <= FORLIM1; w++) {
      P_addset(P_expset(a, 0L), v);
      P_addset(a, w);
      if (P_subset(a, g)) {
	if (subset_of_an_edge(a, drop_g_c)) {
	  if (subset_of_an_edge(a, old_g_c))
	    insert_edge_in_edge_list(v, w, &edge_list);
	}
      }
    }
  }
  copy_set_list(*old_g_c, new_g_c);
  while (edge_list != NULL) {
    p = edge_list;
    tmp_g_c = *new_g_c;
    sub_drop_edge_from_g_c(new_g_c, &tmp_g_c, p->v, p->w);
    dispose_set_list(&tmp_g_c);
    edge_list = edge_list->pointer;
    Free(p);
  }
}  /* new_drop_edges_from_g_c */


Static Void old_drop_edges_from_g_c(new_g_c, old_g_c, drop_g_c)
t_set_list **new_g_c, **old_g_c, **drop_g_c;
{
  t_edge_list *p, *edge_list;
  t_vertex v, w;
  t_vertex_set g, a;
  t_v_arr_of_v_sets old_adj_set, new_adj_set;
  t_vertex FORLIM, FORLIM1;

  edge_list = NULL;
  hypergraph_sets_to_graph_sets(*old_g_c, g, old_adj_set);
  FORLIM = last_vertex;
  for (v = first_vertex; v < FORLIM; v++) {
    FORLIM1 = last_vertex;
    for (w = v + 1; w <= FORLIM1; w++) {
      P_addset(P_expset(a, 0L), v);
      P_addset(a, w);
      if (P_subset(a, g) & P_inset(w, old_adj_set[v - MIN_VERTEX])) {
	if (!subset_of_an_edge(a, drop_g_c))
	  insert_edge_in_edge_list(v, w, &edge_list);
      }
    }
  }
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++)
    P_setcpy(new_adj_set[v - MIN_VERTEX], empty_set);
  while (edge_list != NULL) {
    p = edge_list;
    P_addset(new_adj_set[p->v - MIN_VERTEX], p->w);
    P_addset(new_adj_set[p->w - MIN_VERTEX], p->v);
    edge_list = edge_list->pointer;
    Free(p);
  }
  find_cliques(new_adj_set, g, new_g_c);
}  /* old_drop_edges_from_g_c */


Static Void drop_edges_from_g_c(new_g_c, old_g_c, drop_g_c)
t_set_list **new_g_c, **old_g_c, **drop_g_c;
{
  if (c_factorizes == 1)
    old_drop_edges_from_g_c(new_g_c, old_g_c, drop_g_c);
  else
    new_drop_edges_from_g_c(new_g_c, old_g_c, drop_g_c);
}  /* drop_edges_from_g_c */


Static Void drop_edge_from_g_c(new_g_c, old_g_c, a)
t_set_list **new_g_c, **old_g_c;
long *a;
{
  t_set_list *p;

  p = NULL;
  insert_set_in_set_list(a, &p);
  drop_edges_from_g_c(new_g_c, old_g_c, &p);
  dispose_set_list(&p);
}  /* drop_edge_from_g_c */


Static Void drop_edge(new_model, old_model, drop_g_c)
t_model *new_model, *old_model;
t_set_list **drop_g_c;
{
  P_setcpy(new_model->model_set, old_model->model_set);
  drop_edges_from_g_c(&new_model->sets_h_g_c, &old_model->sets_h_g_c,
		      drop_g_c);
}  /* drop_edge */


Static Void sub_add_edge_to_g_c(new_g_c, old_g_c, v, w)
t_set_list **new_g_c, **old_g_c;
t_vertex v, w;
{
  t_vertex_set a, b;
  t_set_list *qv, *qw;

  /*$ifdef TRACE*/
  if (boolean_option[27]) {
    write_char(stdout, '(');
    print_vertex(v);
    write_char(stdout, ',');
    print_vertex(w);
    write_char(stdout, ';');
    print_g_c(*old_g_c, 0L, line_length);
    write_char(stdout, '/');
  }
  /*$endif TRACE*/
  copy_set_list(*old_g_c, new_g_c);
  P_addset(P_expset(a, 0L), v);
  P_addset(a, w);
  insert_clique(a, new_g_c);
  qv = *old_g_c;
  while (qv != NULL) {
    if (P_inset(v, qv->vertex_set)) {
      qw = *old_g_c;
      while (qw != NULL) {
	if (P_inset(w, qw->vertex_set)) {
	  P_setint(b, qv->vertex_set, qw->vertex_set);
	  P_setunion(b, b, a);
	  insert_clique(b, new_g_c);
	}
	qw = qw->pointer;
      }
    }
    qv = qv->pointer;
  }
  /*$ifdef TRACE*/
  if (!boolean_option[27])
    return;
  /*$endif TRACE*/
  print_g_c(*new_g_c, 0L, line_length);
  write_char(stdout, ')');
  write_line(stdout);
}  /* sub_add_edge_to_g_c */


Static Void new_add_edges_to_g_c(new_g_c, old_g_c, add_g_c, new_g)
t_set_list **new_g_c, **old_g_c, **add_g_c;
long *new_g;
{
  t_vertex v, w;
  t_vertex_set a;
  t_edge_list *p, *edge_list;
  t_set_list *tmp_g_c;
  t_vertex FORLIM, FORLIM1;

  P_setcpy(new_g, empty_set);
  add_union_of_gc(*add_g_c, new_g);
  edge_list = NULL;
  FORLIM = last_vertex;
  for (v = first_vertex; v < FORLIM; v++) {
    FORLIM1 = last_vertex;
    for (w = v + 1; w <= FORLIM1; w++) {
      P_addset(P_expset(a, 0L), v);
      P_addset(a, w);
      if (P_subset(a, new_g)) {
	if (subset_of_an_edge(a, add_g_c)) {
	  if (!subset_of_an_edge(a, old_g_c))
	    insert_edge_in_edge_list(v, w, &edge_list);
	}
      }
    }
  }
  add_union_of_gc(*old_g_c, new_g);
  copy_set_list(*old_g_c, new_g_c);
  while (edge_list != NULL) {
    p = edge_list;
    tmp_g_c = *new_g_c;
    sub_add_edge_to_g_c(new_g_c, &tmp_g_c, p->v, p->w);
    dispose_set_list(&tmp_g_c);
    edge_list = edge_list->pointer;
    Free(p);
  }
}  /* new_add_edges_to_g_c */


Static Void old_add_edges_to_g_c(new_g_c, old_g_c, add_g_c, new_g)
t_set_list **new_g_c, **old_g_c, **add_g_c;
long *new_g;
{
  t_edge_list *p, *edge_list;
  t_vertex v, w;
  t_vertex_set old_g, a;
  t_v_arr_of_v_sets old_adj_set, new_adj_set;
  t_vertex FORLIM, FORLIM1;

  edge_list = NULL;
  hypergraph_sets_to_graph_sets(*old_g_c, old_g, old_adj_set);
  P_setcpy(new_g, old_g);
  add_union_of_gc(*add_g_c, new_g);
  FORLIM = last_vertex;
  for (v = first_vertex; v < FORLIM; v++) {
    FORLIM1 = last_vertex;
    for (w = v + 1; w <= FORLIM1; w++) {
      P_addset(P_expset(a, 0L), v);
      P_addset(a, w);
      if ((P_subset(a, old_g) & P_inset(w, old_adj_set[v - MIN_VERTEX])) |
	  subset_of_an_edge(a, add_g_c))
	insert_edge_in_edge_list(v, w, &edge_list);
    }
  }
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++)
    P_setcpy(new_adj_set[v - MIN_VERTEX], empty_set);
  while (edge_list != NULL) {
    p = edge_list;
    P_addset(new_adj_set[p->v - MIN_VERTEX], p->w);
    P_addset(new_adj_set[p->w - MIN_VERTEX], p->v);
    edge_list = edge_list->pointer;
    Free(p);
  }
  find_cliques(new_adj_set, new_g, new_g_c);
}  /* old_add_edges_to_g_c */


Static Void add_edges_to_g_c(new_g_c, old_g_c, add_g_c, new_g)
t_set_list **new_g_c, **old_g_c, **add_g_c;
long *new_g;
{
  if (c_factorizes == 1)
    old_add_edges_to_g_c(new_g_c, old_g_c, add_g_c, new_g);
  else
    new_add_edges_to_g_c(new_g_c, old_g_c, add_g_c, new_g);
}  /* add_edges_to_g_c */


Static Void add_edge_to_g_c(new_g_c, old_g_c, a)
t_set_list **new_g_c, **old_g_c;
long *a;
{
  t_set_list *p;
  t_vertex_set new_g;

  p = NULL;
  insert_set_in_set_list(a, &p);
  add_edges_to_g_c(new_g_c, old_g_c, &p, new_g);
  dispose_set_list(&p);
}  /* add_edge_to_g_c */


Static Void add_edge(new_model, old_model, add_g_c)
t_model *new_model, *old_model;
t_set_list **add_g_c;
{
  add_edges_to_g_c(&new_model->sets_h_g_c, &old_model->sets_h_g_c, add_g_c,
		   new_model->model_set);
}  /* add_edge */


Static Void drop_interactions_from_g_c(new_g_c, old_g_c, interactions, new_g)
t_set_list **new_g_c, **old_g_c, **interactions;
long *new_g;
{
  t_set_list *p, *alt_rep;
  t_vertex_set old_g;

  P_setcpy(old_g, empty_set);
  add_union_of_gc(*old_g_c, old_g);
  P_setcpy(new_g, old_g);
  if ((*old_g_c)->pointer == NULL && P_setequal((*old_g_c)->vertex_set, old_g))
    alt_rep = NULL;
  else
    normal_to_dual(*old_g_c, old_g, &alt_rep);
  p = *interactions;
  while (p != NULL) {
    insert_set_minimal(p->vertex_set, &alt_rep);
    p = p->pointer;
  }
  dispose_set_list(interactions);
  dual_to_normal(alt_rep, old_g, new_g_c);
  if (*new_g_c != NULL) {
    P_setcpy(new_g, empty_set);
    add_union_of_gc(*new_g_c, new_g);
  } else
    P_setcpy(new_g, empty_set);
  dispose_set_list(&alt_rep);
}  /* drop_interactions_from_g_c */


Static Void drop_interactions(new_model, old_model, interactions)
t_model *new_model, *old_model;
t_set_list **interactions;
{
  drop_interactions_from_g_c(&new_model->sets_h_g_c, &old_model->sets_h_g_c,
			     interactions, new_model->model_set);
}  /* drop_interactions */


Static Void drop_interaction_from_g_c(new_g_c, old_g_c, a)
t_set_list **new_g_c, **old_g_c;
long *a;
{
  t_set_list *p;
  t_vertex_set new_g;

  p = NULL;
  insert_set_in_set_list(a, &p);
  drop_interactions_from_g_c(new_g_c, old_g_c, &p, new_g);
}  /* drop_interaction_from_g_c */


Static Void add_interactions_to_g_c(new_g_c, old_g_c, interactions)
t_set_list **new_g_c, **old_g_c, **interactions;
{
  t_set_list *p;

  copy_set_list(*old_g_c, new_g_c);
  p = *interactions;
  while (p != NULL) {
    insert_clique(p->vertex_set, new_g_c);
    p = p->pointer;
  }
  dispose_set_list(interactions);
}  /* add_interactions_to_g_c */


Static Void add_interactions(new_model, old_model, interactions)
t_model *new_model, *old_model;
t_set_list **interactions;
{
  P_setcpy(new_model->model_set, old_model->model_set);
  add_interactions_to_g_c(&new_model->sets_h_g_c, &old_model->sets_h_g_c,
			  interactions);
}  /* add_interactions */


Static Void add_interaction_to_g_c(new_g_c, old_g_c, a)
t_set_list **new_g_c, **old_g_c;
long *a;
{
  t_set_list *p;

  p = NULL;
  insert_set_in_set_list(a, &p);
  add_interactions_to_g_c(new_g_c, old_g_c, &p);
}  /* add_interaction_to_g_c */


Static Void meet_models(new_model, model_1, model_2)
t_model *new_model, *model_1, *model_2;
{
  P_setunion(new_model->model_set, model_1->model_set, model_2->model_set);
  find_g_c_intersection_maximal(model_1->sets_h_g_c, &model_2->sets_h_g_c,
				&new_model->sets_h_g_c);
}  /* meet_models */


Static Void join_models(new_model, model_1, model_2)
t_model *new_model, *model_1, *model_2;
{
  t_set_list *p;

  P_setunion(new_model->model_set, model_1->model_set, model_2->model_set);
  copy_set_list(model_1->sets_h_g_c, &new_model->sets_h_g_c);
  p = model_2->sets_h_g_c;
  while (p != NULL) {
    insert_clique(p->vertex_set, &new_model->sets_h_g_c);
    p = p->pointer;
  }
}  /* join_models */


Static Void edge_minus(new_edges, g_c_a, g_c_b)
t_set_list **new_edges, **g_c_a, **g_c_b;
{
  t_set_list *p_g_c;
  t_vertex_set a;

  p_g_c = NULL;
  drop_edges_from_g_c(&p_g_c, g_c_a, g_c_b);
  *new_edges = NULL;
  while (p_g_c != NULL) {
    P_setcpy(a, p_g_c->vertex_set);
    if (cardinality(a) > 1)
      insert_set_minimal(a, new_edges);
    p_g_c = p_g_c->pointer;
  }
  dispose_set_list(&p_g_c);
}  /* edge_minus */


Static Void g_c_minus(new_g_c, g_c_a, g_c_b)
t_set_list **new_g_c, **g_c_a, **g_c_b;
{
  t_set_list *g_c_dual_b;
  t_vertex_set a, g;

  P_setcpy(g, empty_set);
  add_union_of_gc(*g_c_a, g);
  normal_to_dual(*g_c_b, g, &g_c_dual_b);
  *new_g_c = NULL;
  while (g_c_dual_b != NULL) {
    P_setcpy(a, g_c_dual_b->vertex_set);
    if (subset_of_an_edge(a, g_c_a))
      insert_set_minimal(a, new_g_c);
    g_c_dual_b = g_c_dual_b->pointer;
  }
  dispose_set_list(&g_c_dual_b);
}  /* g_c_minus */


Static Void difference_models(new_model, model_1, model_2, edges)
t_model *new_model, *model_1, *model_2;
boolean edges;
{
  P_setunion(new_model->model_set, model_1->model_set, model_2->model_set);
  if (edges)
    edge_minus(&new_model->sets_h_g_c, &model_1->sets_h_g_c,
	       &model_2->sets_h_g_c);
  else
    g_c_minus(&new_model->sets_h_g_c, &model_1->sets_h_g_c,
	      &model_2->sets_h_g_c);
}  /* difference_models */


Static Void drop_total_generator(new_model, old_model, a)
t_model *new_model, *old_model;
long *a;
{
  t_set_list *p;
  t_vertex v;
  t_vertex_set b, c;
  t_vertex FORLIM;

  P_setcpy(new_model->model_set, old_model->model_set);
  p = old_model->sets_h_g_c;
  while (p != NULL) {
    P_setdiff(c, p->vertex_set, a);
    insert_clique(c, &new_model->sets_h_g_c);
    FORLIM = last_vertex;
    for (v = first_vertex; v <= FORLIM; v++) {
      if (P_inset(v, a) & P_inset(v, p->vertex_set)) {
	P_addset(P_expset(b, 0L), v);
	P_setunion(b, c, b);
	insert_clique(b, &new_model->sets_h_g_c);
      }
    }
    p = p->pointer;
  }
}  /* drop_total_generator */


Static Void remove_generator(new_model, old_model, a)
t_model *new_model, *old_model;
long *a;
{
  t_set_list *p;

  P_setcpy(new_model->model_set, old_model->model_set);
  p = old_model->sets_h_g_c;
  while (p != NULL) {
    if (!P_setequal(p->vertex_set, a))
      insert_clique(p->vertex_set, &new_model->sets_h_g_c);
    p = p->pointer;
  }
}  /* remove_generator */


Static Void reduce_generator(new_model, old_model, a)
t_model *new_model, *old_model;
long *a;
{
  t_set_list *p;
  t_vertex v;
  boolean b;
  t_vertex_set c;
  t_vertex FORLIM;

  P_setcpy(new_model->model_set, old_model->model_set);
  p = old_model->sets_h_g_c;
  b = false;
  while (p != NULL) {
    if (!P_setequal(p->vertex_set, a))
      insert_clique(p->vertex_set, &new_model->sets_h_g_c);
    else
      b = true;
    p = p->pointer;
  }
  if (!b)
    return;
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    if (P_inset(v, a)) {
      P_addset(P_expset(c, 0L), v);
      P_setdiff(c, a, c);
      insert_clique(c, &new_model->sets_h_g_c);
    }
  }
}  /* reduce_generator */


Static Void drop_factor(new_model, old_model, v)
t_model *new_model, *old_model;
t_vertex *v;
{
  t_set_list *p;
  t_vertex_set c;

  P_setcpy(new_model->model_set, old_model->model_set);
  p = old_model->sets_h_g_c;
  while (p != NULL) {
    P_addset(P_expset(c, 0L), *v);
    P_setdiff(c, p->vertex_set, c);
    insert_clique(c, &new_model->sets_h_g_c);
    p = p->pointer;
  }
}  /* drop_factor */


/*@-"factorizes.c"*/


Static Void generate_decomposable_model(new_model, old_model)
t_model *new_model, *old_model;
{
  P_setcpy(new_model->model_set, old_model->model_set);
  new_model->sets_h_g_c = find_fill_in(&old_model->sets_h_g_c);
}  /* generate_decomposable_model */


Static Void generate_graphical_model(new_model, old_model)
t_model *new_model, *old_model;
{
  t_set_list *sets_g_g_c, *sets_d_g_c;
  boolean decomposable, graphical;

  P_setcpy(new_model->model_set, old_model->model_set);
  sets_d_g_c = NULL;
  decomposable = false;
  graphical = false;
  if (!(old_model->found_expression && old_model->graphical))
    find_graphical_and_decomposable_gc(&old_model->sets_h_g_c, &sets_d_g_c,
      &sets_g_g_c, &decomposable, &graphical);
  if (old_model->graphical || graphical)
    copy_set_list(old_model->sets_h_g_c, &new_model->sets_h_g_c);
  else
    new_model->sets_h_g_c = sets_g_g_c;
  if (!(old_model->decomposable || decomposable))
    dispose_set_list(&sets_d_g_c);
}  /* generate_graphical_model */


/* Local variables for test_one_inter_part: */
struct LOC_test_one_inter_part {
  t_model *model_2;
  boolean *short_test_output, *write_models;
  t_set_list *g_c_1, *g_c_2;
  t_vertex_set g;
} ;

Local Void insert_d(d, LINK)
long *d;
struct LOC_test_one_inter_part *LINK;
{
  t_long_integer number_of_tests;

  if (!subset_of_an_edge(d, &LINK->model_2->sets_h_g_c) || interrupt_2)
    return;
  insert_clique(d, &LINK->g_c_2);
  if (test_sub_g_c(LINK->g_c_2, LINK->g_c_1))
    return;
  if (*LINK->write_models) {
    if (*LINK->short_test_output) {
      write_space(stdout, 3L);
      print_vertex_set_table(d);
    } else {
      write_pch(stdout, " Edge: ", 7L);
      print_vertex_set(d);
      write_line(stdout);
    }
  }
  number_of_tests = 0;
  partitioning_hierarchical(&LINK->g_c_1, &LINK->g_c_2,
			    LINK->short_test_output, LINK->write_models,
			    &number_of_tests, 0L);
  if (!*LINK->write_models) {
    if (*LINK->short_test_output) {
      print_vertex_set_table(d);
      write_line(stdout);
    }
  }
  dispose_set_list(&LINK->g_c_1);
  copy_set_list(LINK->g_c_2, &LINK->g_c_1);
}  /* insert_d */

Local Void find_d_(v1, v2, d, LINK)
t_vertex v1, v2;
long *d;
struct LOC_test_one_inter_part *LINK;
{
  t_vertex v;
  t_vertex_set b;

  if (v2 == last_vertex) {
    for (v = v1; v <= v2; v++) {
      if (P_inset(v, LINK->g)) {
	P_addset(P_expset(b, 0L), v);
	P_setunion(b, d, b);
	insert_d(b, LINK);
      }
    }
    return;
  }
  for (v = v1; v <= v2; v++) {
    if (P_inset(v, LINK->g)) {
      P_addset(P_expset(b, 0L), v);
      P_setunion(b, d, b);
      find_d_(v + 1, v2 + 1, b, LINK);
    }
  }
}  /* find_d */


/*@+"facti.p"*/


Static Void test_one_inter_part(model_1, model_2_, vertex_order,
				short_test_output_, write_models_)
t_model *model_1, *model_2_;
t_vertex_list *vertex_order;
boolean *short_test_output_, *write_models_;
{
  struct LOC_test_one_inter_part Local_Var;
  t_vertex v;
  t_vertex FORLIM;

  Local_Var.model_2 = model_2_;
  Local_Var.short_test_output = short_test_output_;
  Local_Var.write_models = write_models_;
  copy_set_list(model_1->sets_h_g_c, &Local_Var.g_c_1);
  copy_set_list(Local_Var.g_c_1, &Local_Var.g_c_2);
  P_setcpy(Local_Var.g, empty_set);
  while (vertex_order != NULL) {
    P_addset(Local_Var.g, vertex_order->vertex);
    FORLIM = first_vertex;
    for (v = last_vertex; v >= FORLIM; v--)
      find_d_(first_vertex, v, empty_set, &Local_Var);
    vertex_order = vertex_order->pointer;
  }
  P_setcpy(Local_Var.g, delta);
  FORLIM = first_vertex;
  for (v = last_vertex; v >= FORLIM; v--)
    find_d_(first_vertex, v, empty_set, &Local_Var);
  dispose_set_list(&Local_Var.g_c_1);
  dispose_set_list(&Local_Var.g_c_2);
}  /* test_one_inter_part */


/* Local variables for test_one_inter_fast: */
struct LOC_test_one_inter_fast {
  t_model *model_2;
  boolean *short_test_output, *write_models;
  t_model_list *link_model, *link_model_1, *link_model_2;
  boolean ok;
  t_vertex_set g;
} ;

Local boolean subset_of_an_edge__(a, list_of_cliques, LINK)
long *a;
t_set_list *list_of_cliques;
struct LOC_test_one_inter_fast *LINK;
{
  t_set_list *p;
  boolean b;

  b = true;
  p = list_of_cliques;
  while (p != NULL && b) {
    if (P_subset(a, p->vertex_set))
      b = false;
    else
      p = p->pointer;
  }
  return (!b);
}  /* subset_of_an_edge */

Local Void fit_model(model, ok, LINK)
t_model *model;
boolean *ok;
struct LOC_test_one_inter_fast *LINK;
{
  t_set_list *g_c;

  g_c = model->sets_h_g_c;
  model->sets_h_g_c = NULL;
  erase_model(model);
  model->sets_h_g_c = g_c;
  identify_model(model);
  *ok = ok_model_to_test(model);
}  /* fit_model */

Local Void insert_d_(d, LINK)
long *d;
struct LOC_test_one_inter_fast *LINK;
{
  if (!(subset_of_an_edge__(d, LINK->model_2->sets_h_g_c, LINK) && LINK->ok) ||
      interrupt_2)
    return;
  insert_clique(d, &LINK->link_model_2->model.sets_h_g_c);
  if (test_sub_g_c(LINK->link_model_2->model.sets_h_g_c,
		   LINK->link_model_1->model.sets_h_g_c))
    return;
  if (*LINK->write_models) {
    if (*LINK->short_test_output) {
      write_space(stdout, 3L);
      print_vertex_set_table(d);
    } else {
      write_pch(stdout, " Edge: ", 7L);
      print_vertex_set(d);
      write_line(stdout);
    }
  }
  fit_model(&LINK->link_model_2->model, &LINK->ok, LINK);
  if (LINK->ok) {
    test_models(&LINK->link_model_1->model, &LINK->link_model_2->model, delta,
		LINK->short_test_output, LINK->write_models, 0L);
    link_model_list = LINK->link_model_2;
    link_model_list->pointer = NULL;
    dispose_model(&LINK->link_model_1->model);
    LINK->link_model = LINK->link_model_1;
    LINK->link_model_1 = LINK->link_model_2;
    LINK->link_model_2 = LINK->link_model;
    copy_set_list(LINK->link_model_1->model.sets_h_g_c,
		  &LINK->link_model_2->model.sets_h_g_c);
  }
  if (*LINK->write_models)
    return;
  if (*LINK->short_test_output) {
    print_vertex_set_table(d);
    write_line(stdout);
  }
}  /* insert_d */

Local Void find_d__(v1, v2, d, LINK)
t_vertex v1, v2;
long *d;
struct LOC_test_one_inter_fast *LINK;
{
  t_vertex v;
  t_vertex_set b;

  if (v2 == last_vertex) {
    for (v = v1; v <= v2; v++) {
      if (P_inset(v, LINK->g)) {
	P_addset(P_expset(b, 0L), v);
	P_setunion(b, d, b);
	insert_d_(b, LINK);
      }
    }
    return;
  }
  for (v = v1; v <= v2; v++) {
    if (P_inset(v, LINK->g)) {
      P_addset(P_expset(b, 0L), v);
      P_setunion(b, d, b);
      find_d__(v + 1, v2 + 1, b, LINK);
    }
  }
}  /* find_d */


Static Void test_one_inter_fast(model_1, model_2_, vertex_order,
				short_test_output_, write_models_)
t_model *model_1, *model_2_;
t_vertex_list *vertex_order;
boolean *short_test_output_, *write_models_;
{
  struct LOC_test_one_inter_fast Local_Var;
  t_model_list *l_m_l;
  t_vertex v;
  t_vertex FORLIM;

  Local_Var.model_2 = model_2_;
  Local_Var.short_test_output = short_test_output_;
  Local_Var.write_models = write_models_;
  Local_Var.link_model_1 = (t_model_list *)Malloc(sizeof(t_model_list));
  if (Local_Var.link_model_1 == NULL)
    _OutMem();
  Local_Var.link_model_2 = (t_model_list *)Malloc(sizeof(t_model_list));
  if (Local_Var.link_model_2 == NULL)
    _OutMem();
  l_m_l = link_model_list;
  copy_set_list(model_1->sets_h_g_c,
		&Local_Var.link_model_1->model.sets_h_g_c);
  copy_set_list(Local_Var.link_model_1->model.sets_h_g_c,
		&Local_Var.link_model_2->model.sets_h_g_c);
  fit_model(&Local_Var.link_model_1->model, &Local_Var.ok, &Local_Var);
  P_setcpy(Local_Var.g, empty_set);
  while (vertex_order != NULL) {
    P_addset(Local_Var.g, vertex_order->vertex);
    FORLIM = first_vertex;
    for (v = last_vertex; v >= FORLIM; v--)
      find_d__(first_vertex, v, empty_set, &Local_Var);
    vertex_order = vertex_order->pointer;
  }
  P_setcpy(Local_Var.g, delta);
  FORLIM = first_vertex;
  for (v = last_vertex; v >= FORLIM; v--)
    find_d__(first_vertex, v, empty_set, &Local_Var);
  if (!Local_Var.ok) {
    write_pch(stdout, " Out of space", 13L);
    write_line(stdout);
  }
  dispose_model(&Local_Var.link_model_1->model);
  dispose_model(&Local_Var.link_model_2->model);
  Free(Local_Var.link_model_1);
  Free(Local_Var.link_model_2);
  link_model_list = l_m_l;
}  /* test_one_inter_fast */


/*@+"facte.p"*/


Static Void factorizes_c(model_1, model_2, vertex_order, short_test_output,
			 write_models, partitioning)
t_model *model_1, *model_2;
t_vertex_list *vertex_order;
boolean *short_test_output, *write_models, *partitioning;
{
  boolean ok;
  t_vertex u1, u2;
  t_vertex_set g, a, b, am1, am2, su1, su2;
  t_model model_a, model_b;
  t_set_list *g_c;
  t_edge_list *link_edge_list, *p, *q;
  t_o_arr_of_vertex invers_order;
  t_v_arr_of_order order;
  t_v_arr_of_v_sets adj_set_a, adj_set_b;
  t_v_arr_of_v_lists adj_list_a, adj_list_b;
  t_long_integer number_of_tests;
  t_test_list *p_test;

  erase_model(&model_a);
  erase_model(&model_b);
  model_a.found_expression = true;
  model_b.found_expression = true;
  model_a.found_ps = !em;
  model_b.found_ps = !em;
  if (!test_grap_submodel(&model_1->sets_h_g_c, &model_2->sets_h_g_c,
			  adj_set_a, adj_set_b, g))
    return;
  ok = true;
  link_edge_list = NULL;
  adj_set_to_adj_list(adj_set_b, adj_list_b);
  find_edges(adj_list_b, adj_set_a, &link_edge_list);
  p = (t_edge_list *)Malloc(sizeof(t_edge_list));
  if (p == NULL)
    _OutMem();
  p->pointer = link_edge_list;
  link_edge_list = p;
  copy_set_list(model_2->sets_h_g_c, &g_c);
  if (!*partitioning || incomplete_table) {
    number_of_tests = 0;
    copy_set_list(model_2->sets_h_g_c, &model_b.sets_h_g_c);
    P_setcpy(model_a.model_set, g);
    model_a.ips_list = NULL;
    model_a.radim_list = NULL;
    P_setcpy(model_b.model_set, g);
    model_b.ips_list = NULL;
    model_b.radim_list = NULL;
    maximum_cardinality_search(adj_list_b, order, invers_order);
    model_b.expression = NULL;
    find_perfect_scheme_expression(g, adj_list_b, order, invers_order,
      &model_b.constant, &model_b.expression, &model_b.dim);
  }
  dispose_adj_list(adj_list_b);
  memcpy(adj_set_a, adj_set_b, sizeof(t_v_arr_of_v_sets));
  P_setcpy(b, empty_set);
  if (vertex_order == NULL)
    P_setcpy(b, g);
  else {
    P_addset(b, vertex_order->vertex);
    vertex_order = vertex_order->pointer;
  }
  if (vertex_order == NULL)
    P_setcpy(b, g);
  else {
    P_addset(b, vertex_order->vertex);
    vertex_order = vertex_order->pointer;
  }
  while (link_edge_list->pointer != NULL && !interrupt_2) {
    do {
      p = link_edge_list;
      q = p->pointer;
      ok = false;
      while (!ok && q != NULL) {
	u1 = q->v;
	u2 = q->w;
	if (P_inset(u1, b) & P_inset(u2, b))
	  ok = was_edge_in_one_clique(&u1, &u2, &g_c, a);
	if (ok) {
	  p->pointer = q->pointer;
	  Free(q);
	} else {
	  p = q;
	  q = q->pointer;
	}
      }
      if (!ok) {
	if (vertex_order == NULL)
	  P_setcpy(b, g);
	else {
	  P_addset(b, vertex_order->vertex);
	  vertex_order = vertex_order->pointer;
	}
      }
    } while (!ok);
    P_remset(adj_set_a[u1 - MIN_VERTEX], u2);
    P_remset(adj_set_a[u2 - MIN_VERTEX], u1);
    P_addset(P_expset(su1, 0L), u1);
    P_setdiff(am1, a, su1);
    insert_clique(am1, &g_c);
    P_addset(P_expset(su2, 0L), u2);
    P_setdiff(am2, a, su2);
    insert_clique(am2, &g_c);
    if (*write_models)
      print_edge(stdout, *short_test_output, *write_models, u1, u2);
    if (*partitioning && !incomplete_table)
      one_edge_collaps(adj_set_a, &u1, &u2, &p_test, short_test_output,
		       write_models, &just);
    else {
      model_a.sets_h_g_c = g_c;
      if (incomplete_table)
	partitioning_hierarchical(&model_a.sets_h_g_c, &model_b.sets_h_g_c,
				  short_test_output, write_models,
				  &number_of_tests, 0L);
      else {
	adj_set_to_adj_list(adj_set_a, adj_list_a);
	maximum_cardinality_search(adj_list_a, order, invers_order);
	model_a.expression = NULL;
	find_perfect_scheme_expression(g, adj_list_a, order, invers_order,
	  &model_a.constant, &model_a.expression, &model_a.dim);
	dispose_adj_list(adj_list_a);
	test_models(&model_a, &model_b, g, short_test_output, write_models,
		    0L);
	dispose_marginals_cond();
	dispose_expression(&model_b.expression);
	model_b.constant = model_a.constant;
	model_b.dim = model_a.dim;
	model_b.expression = model_a.expression;
      }
      dispose_set_list(&model_b.sets_h_g_c);
      copy_set_list(model_a.sets_h_g_c, &model_b.sets_h_g_c);
    }
    if (!*write_models) {
      print_edge(stdout, *short_test_output, *write_models, u1, u2);
      write_line(stdout);
    }
  }
  if (interrupt_2) {
    interrupt_1 = false;
    interrupt_2 = false;
  }
  Free(link_edge_list);
  if (!*partitioning || incomplete_table) {
    dispose_set_list(&model_b.sets_h_g_c);
    dispose_expression(&model_b.expression);
  }
  dispose_set_list(&g_c);
}  /* factorizes_c */


Static Void factorizes_b(model_1, model_2, vertex_order, short_test_output,
			 write_models, partitioning)
t_model *model_1, *model_2;
t_vertex_list *vertex_order;
boolean *short_test_output, *write_models, *partitioning;
{
  boolean ok;
  t_vertex u1, u2;
  t_vertex_set g, b;
  t_model model_a, model_b;
  t_edge_list *link_edge_list, *p, *q;
  t_vertex_list *a1, *a2;
  t_o_arr_of_vertex invers_order;
  t_v_arr_of_order order;
  t_v_arr_of_v_sets adj_set_a, adj_set_b;
  t_v_arr_of_v_lists adj_list_b;
  t_long_integer number_of_tests;
  t_test_list *p_test;

  erase_model(&model_a);
  erase_model(&model_b);
  model_a.found_expression = true;
  model_b.found_expression = true;
  model_a.found_ps = !em;
  model_b.found_ps = !em;
  if (!test_grap_submodel(&model_1->sets_h_g_c, &model_2->sets_h_g_c,
			  adj_set_a, adj_set_b, g))
    return;
  ok = true;
  link_edge_list = NULL;
  adj_set_to_adj_list(adj_set_b, adj_list_b);
  find_edges(adj_list_b, adj_set_a, &link_edge_list);
  p = (t_edge_list *)Malloc(sizeof(t_edge_list));
  if (p == NULL)
    _OutMem();
  p->pointer = link_edge_list;
  link_edge_list = p;
  dispose_adj_list(adj_list_b);
  adj_set_to_adj_list(adj_set_a, adj_list_b);
  if (!*partitioning || incomplete_table) {
    number_of_tests = 0;
    memcpy(adj_set_b, adj_set_a, sizeof(t_v_arr_of_v_sets));
    copy_set_list(model_1->sets_h_g_c, &model_a.sets_h_g_c);
    P_setcpy(model_a.model_set, g);
    model_a.ips_list = NULL;
    model_a.radim_list = NULL;
    P_setcpy(model_b.model_set, g);
    model_b.ips_list = NULL;
    model_b.radim_list = NULL;
    maximum_cardinality_search(adj_list_b, order, invers_order);
    model_a.expression = NULL;
    find_perfect_scheme_expression(g, adj_list_b, order, invers_order,
      &model_a.constant, &model_a.expression, &model_a.dim);
  }
  P_setcpy(b, empty_set);
  if (vertex_order == NULL)
    P_setcpy(b, g);
  else {
    P_addset(b, vertex_order->vertex);
    vertex_order = vertex_order->pointer;
  }
  if (vertex_order == NULL)
    P_setcpy(b, g);
  else {
    P_addset(b, vertex_order->vertex);
    vertex_order = vertex_order->pointer;
  }
  while (link_edge_list->pointer != NULL && !interrupt_2) {
    a1 = (t_vertex_list *)Malloc(sizeof(t_vertex_list));
    if (a1 == NULL)
      _OutMem();
    a2 = (t_vertex_list *)Malloc(sizeof(t_vertex_list));
    if (a2 == NULL)
      _OutMem();
    ok = false;
    do {
      p = link_edge_list;
      q = p->pointer;
      while (!ok && q != NULL) {
	u1 = q->v;
	u2 = q->w;
	if (!(P_inset(u1, b) & P_inset(u2, b))) {
	  p = q;
	  q = q->pointer;
	  continue;
	}
	a1->vertex = u1;
	a1->pointer = adj_list_b[u2 - MIN_VERTEX];
	adj_list_b[u2 - MIN_VERTEX] = a1;
	a2->vertex = u2;
	a2->pointer = adj_list_b[u1 - MIN_VERTEX];
	adj_list_b[u1 - MIN_VERTEX] = a2;
	maximum_cardinality_search(adj_list_b, order, invers_order);
	ok = test_for_zero_fill_in(adj_list_b, order, invers_order);
	if (ok) {
	  p->pointer = q->pointer;
	  Free(q);
	} else {
	  adj_list_b[u1 - MIN_VERTEX] = adj_list_b[u1 - MIN_VERTEX]->pointer;
	  adj_list_b[u2 - MIN_VERTEX] = adj_list_b[u2 - MIN_VERTEX]->pointer;
	  p = q;
	  q = q->pointer;
	}
      }
      if (!ok) {
	if (vertex_order == NULL)
	  P_setcpy(b, g);
	else {
	  P_addset(b, vertex_order->vertex);
	  vertex_order = vertex_order->pointer;
	}
      }
    } while (!ok);
    if (*write_models)
      print_edge(stdout, *short_test_output, *write_models, u1, u2);
    if (*partitioning && !incomplete_table) {
      one_edge_collaps(adj_set_a, &u1, &u2, &p_test, short_test_output,
		       write_models, &just);
      P_addset(adj_set_a[u1 - MIN_VERTEX], u2);
      P_addset(adj_set_a[u2 - MIN_VERTEX], u1);
    } else {
      P_addset(adj_set_b[u1 - MIN_VERTEX], u2);
      P_addset(adj_set_b[u2 - MIN_VERTEX], u1);
      find_cliques(adj_set_b, g, &model_b.sets_h_g_c);
      if (incomplete_table)
	partitioning_hierarchical(&model_a.sets_h_g_c, &model_b.sets_h_g_c,
				  short_test_output, write_models,
				  &number_of_tests, 0L);
      else {
	model_b.expression = NULL;
	find_perfect_scheme_expression(g, adj_list_b, order, invers_order,
	  &model_b.constant, &model_b.expression, &model_b.dim);
	test_models(&model_a, &model_b, g, short_test_output, write_models,
		    0L);
	dispose_marginals_cond();
	dispose_expression(&model_a.expression);
	model_a.constant = model_b.constant;
	model_a.dim = model_b.dim;
	model_a.expression = model_b.expression;
      }
      dispose_set_list(&model_a.sets_h_g_c);
      model_a.sets_h_g_c = model_b.sets_h_g_c;
    }
    if (!*write_models) {
      print_edge(stdout, *short_test_output, *write_models, u1, u2);
      write_line(stdout);
    }
  }
  if (interrupt_2) {
    interrupt_1 = false;
    interrupt_2 = false;
  }
  dispose_adj_list(adj_list_b);
  Free(link_edge_list);
  if (!*partitioning || incomplete_table) {
    dispose_set_list(&model_a.sets_h_g_c);
    dispose_expression(&model_a.expression);
  }
}  /* factorizes_b */


Static Void factorizes_a(model_1, model_2, vertex_order, short_test_output,
			 write_models, partitioning)
t_model *model_1, *model_2;
t_vertex_list *vertex_order;
boolean *short_test_output, *write_models, *partitioning;
{
  boolean ok;
  t_vertex u1, u2;
  t_vertex_set g, b;
  t_model model_a, model_b;
  t_long_integer number_of_tests;
  t_set_list *g_c_a, *g_c_b;
  t_o_arr_of_vertex invers_order;
  t_v_arr_of_order order;
  t_v_arr_of_v_sets adj_set_1, adj_set_2;
  t_v_arr_of_v_lists adj_list_a, adj_list_b;

  erase_model(&model_a);
  erase_model(&model_b);
  model_a.found_expression = true;
  model_b.found_expression = true;
  model_a.found_ps = !em;
  model_b.found_ps = !em;
  if (!test_grap_submodel(&model_1->sets_h_g_c, &model_2->sets_h_g_c,
			  adj_set_1, adj_set_2, g))
    return;
  ok = true;
  if (*partitioning)
    copy_set_list(model_1->sets_h_g_c, &g_c_a);
  else {
    copy_set_list(model_1->sets_h_g_c, &model_a.sets_h_g_c);
    P_setcpy(model_a.model_set, g);
    model_a.ips_list = NULL;
    model_a.radim_list = NULL;
    P_setcpy(model_b.model_set, g);
    model_b.ips_list = NULL;
    model_b.radim_list = NULL;
    adj_set_to_adj_list(adj_set_1, adj_list_a);
    maximum_cardinality_search(adj_list_a, order, invers_order);
    model_a.expression = NULL;
    find_perfect_scheme_expression(g, adj_list_a, order, invers_order,
				   &model_a.constant, &model_a.expression,
				   &model_a.dim);
    dispose_adj_list(adj_list_a);
  }
  P_setcpy(b, empty_set);
  if (vertex_order == NULL)
    P_setcpy(b, g);
  else {
    P_addset(b, vertex_order->vertex);
    vertex_order = vertex_order->pointer;
  }
  if (vertex_order == NULL)
    P_setcpy(b, g);
  else {
    P_addset(b, vertex_order->vertex);
    vertex_order = vertex_order->pointer;
  }
  while (ok && !interrupt_2) {
    do {
      u1 = first_vertex;
      ok = false;
      while (!ok && u1 < last_vertex) {
	if (P_inset(u1, b)) {
	  u2 = u1;
	  do {
	    u2++;
	    if (P_inset(u2, adj_set_2[u1 - MIN_VERTEX]) &
		(!P_inset(u2, adj_set_1[u1 - MIN_VERTEX])) & P_inset(u2, b)) {
	      adj_set_to_adj_list(adj_set_1, adj_list_b);
	      insert_edge_in_adj_list(adj_list_b, &u1, &u2);
	      maximum_cardinality_search(adj_list_b, order, invers_order);
	      ok = test_for_zero_fill_in(adj_list_b, order, invers_order);
	      if (!ok)
		dispose_adj_list(adj_list_b);
	    }
	  } while (!(ok || u2 == last_vertex));
	}
	if (!ok)
	  u1++;
      }
      if (!ok) {
	if (!P_setequal(b, g)) {
	  u1 = first_vertex;
	  if (vertex_order == NULL)
	    P_setcpy(b, g);
	  else {
	    P_addset(b, vertex_order->vertex);
	    vertex_order = vertex_order->pointer;
	  }
	}
      }
    } while (!(ok || u1 == last_vertex));
    if (!ok)
      break;
    if (*write_models)
      print_edge(stdout, *short_test_output, *write_models, u1, u2);
    P_addset(adj_set_1[u1 - MIN_VERTEX], u2);
    P_addset(adj_set_1[u2 - MIN_VERTEX], u1);
    find_cliques(adj_set_1, g, &g_c_b);
    number_of_tests = 0;
    if (*partitioning) {
      partitioning_hierarchical(&g_c_a, &g_c_b, short_test_output,
				write_models, &number_of_tests, 0L);
      dispose_set_list(&g_c_a);
      g_c_a = g_c_b;
    } else {
      model_b.sets_h_g_c = g_c_b;
      model_b.expression = NULL;
      find_perfect_scheme_expression(g, adj_list_b, order, invers_order,
	&model_b.constant, &model_b.expression, &model_b.dim);
      test_models(&model_a, &model_b, g, short_test_output, write_models, 0L);
      dispose_marginals_cond();
      dispose_expression(&model_a.expression);
      model_a.constant = model_b.constant;
      model_a.dim = model_b.dim;
      model_a.expression = model_b.expression;
      dispose_set_list(&model_a.sets_h_g_c);
      model_a.sets_h_g_c = model_b.sets_h_g_c;
    }
    if (!*write_models) {
      print_edge(stdout, *short_test_output, *write_models, u1, u2);
      write_line(stdout);
    }
    dispose_adj_list(adj_list_b);
  }
  if (interrupt_2) {
    interrupt_1 = false;
    interrupt_2 = false;
  }
  if (*partitioning)
    dispose_set_list(&g_c_a);
  else {
    dispose_set_list(&model_a.sets_h_g_c);
    dispose_expression(&model_a.expression);
  }
}  /* factorizes_a */


/*@-"stepwise.c"*/
/*@+"stepwise.p"*/


Static boolean g_c_decomposable(g_c)
t_set_list **g_c;
{
  t_o_arr_of_vertex invers_order;
  t_v_arr_of_order order, beta;
  t_offset_list *r;
  t_adjacency_matrix gc_adjacency_matrix;
  boolean decomposable;

  create_adjacency_matrix(&gc_adjacency_matrix, *g_c);
  restricted_maximim_cardinality_search_on_hypergraph(&gc_adjacency_matrix,
    empty_set, &decomposable, order, beta, invers_order, &r);
  revers_offset_list(&r);
  if (decomposable)
    decomposable = test_acyclic_hypergraph(beta, &r);
  dispose_offset_list(&r);
  delete_edges_with_vertices(&gc_adjacency_matrix, delta);
  return decomposable;
}  /* g_c_decomposable */


Static boolean g_c_conformal(g_c)
t_set_list **g_c;
{
  t_v_arr_of_v_sets adj_set;
  t_vertex_set a;

  hypergraph_sets_to_graph_sets(*g_c, a, adj_set);
  return (test_graphical(adj_set, g_c));
}  /* g_c_conformal */


/* Local variables for find_shortest_path: */
struct LOC_find_shortest_path {
  t_vertex *b;
  t_vertex_list **adj_list;
  t_set_list **paths;
} ;

Local Void find_set(v, path, LINK)
t_vertex v;
long *path;
struct LOC_find_shortest_path *LINK;
{
  t_vertex_set new_path, vertex_set;
  t_vertex_list *p;

  if (v == *LINK->b) {
    insert_set_minimal(path, LINK->paths);
    return;
  }
  p = LINK->adj_list[v - MIN_VERTEX];
  P_addset(P_expset(vertex_set, 0L), v);
  P_setunion(new_path, path, vertex_set);
  while (p != NULL) {
    if (!P_inset(p->vertex, path))
      find_set(p->vertex, new_path, LINK);
    p = p->pointer;
  }
}  /* find_set */


Static Void find_shortest_path(a, b_, adj_list_, paths_)
t_vertex *a, *b_;
t_vertex_list **adj_list_;
t_set_list **paths_;
{
  struct LOC_find_shortest_path Local_Var;
  t_vertex_list *p;

  Local_Var.b = b_;
  Local_Var.adj_list = adj_list_;
  Local_Var.paths = paths_;
  p = Local_Var.adj_list[*a - MIN_VERTEX];
  while (p != NULL) {
    find_set(p->vertex, empty_set, &Local_Var);
    p = p->pointer;
  }
}  /* find_shortest_path */


Static Void find_minimal_cut_sets(a, b, adj_list, cut_sets)
t_vertex *a, *b;
t_vertex_list **adj_list;
t_set_list **cut_sets;
{
  t_set_list *p, *paths;

  paths = NULL;
  find_shortest_path(a, b, adj_list, &paths);
  /*$ifdef TRACE*/
  if (boolean_option[16]) {
    write_pch(stdout, "Paths :   ", 10L);
    if (paths != NULL)
      print_g_c(paths, 10L, line_length);
    write_line(stdout);
  }
  /*$endif TRACE*/
  if (paths == NULL) {
    *cut_sets = NULL;
    return;
  }
  p = paths;
  while (p != NULL) {
    P_setdiff(p->vertex_set, delta, p->vertex_set);
    p = p->pointer;
  }
  /*$ifdef TRACE*/
  if (boolean_option[16]) {
    write_pch(stdout, "*\\Paths : ", 10L);
    print_g_c(paths, 10L, line_length);
    write_line(stdout);
  }
  /*$endif TRACE*/
  normal_to_dual(paths, delta, cut_sets);
  /*$ifdef TRACE*/
  if (boolean_option[16]) {
    write_pch(stdout, "Cut Sets: ", 10L);
    print_g_c(*cut_sets, 10L, line_length);
    write_line(stdout);
  }
  /*$endif TRACE*/
  dispose_set_list(&paths);
}  /* find_minimal_cut_sets */


Static Void test_all_cut_sets(g_c, v, w, p_test, just, short_test_output,
			      write_models)
t_set_list **g_c;
t_vertex *v, *w;
t_test_list **p_test;
boolean *just, *short_test_output, *write_models;
{
  t_v_arr_of_v_sets adj_set;
  t_set_list *p, *cut_sets;
  t_v_arr_of_v_lists adj_list;
  t_vertex_set a, b, bv, bw, d;

  /*$ifdef TRACE*/
  if (boolean_option[16]) {
    print_g_c(*g_c, 10L, line_length);
    write_line(stdout);
  }
  /*$endif TRACE*/
  hypergraph_sets_to_graph_sets(*g_c, a, adj_set);
  adj_set_to_adj_list(adj_set, adj_list);
  find_minimal_cut_sets(v, w, adj_list, &cut_sets);
  dispose_adj_list(adj_list);
  p = cut_sets;
  while (p != NULL) {
    P_addset(P_expset(b, 0L), *v);
    P_setunion(bv, p->vertex_set, b);
    P_addset(P_expset(b, 0L), *w);
    P_setunion(bw, p->vertex_set, b);
    P_setunion(d, bv, b);
    if (!*write_models)
      one_edge_collaps_set(d, bv, bw, v, w, p_test, short_test_output,
			   write_models, just);
    if (*write_models)
      write_space(stdout, 3L);
    print_vertex_on_file(stdout, *v);
    write_char(stdout, '^');
    print_vertex_on_file(stdout, *w);
    write_char(stdout, '|');
    print_vertex_set_table(p->vertex_set);
    if (*write_models)
      write_space(stdout, 3L);
    else
      write_line(stdout);
    if (*write_models)
      one_edge_collaps_set(d, bv, bw, v, w, p_test, short_test_output,
			   write_models, just);
    p = p->pointer;
  }
  dispose_set_list(&cut_sets);
}  /* test_all_cut_sets */


Static Void select_and_update(link_sort_list, p_test, rejected_edges,
			      accepted_edges, edge, p_edge, coherent, follow,
			      in_forward)
t_sort_list *link_sort_list;
t_test_list **p_test;
t_set_list **rejected_edges, **accepted_edges;
long *edge;
double *p_edge;
boolean coherent, follow, in_forward;
{
  t_long_real select_limit, p_value;
  t_vertex_set a;
  boolean reject;
  t_part_list *p;

  /*$ifdef TRACE*/
  if (boolean_option[15])
    write_real(stdout, *p_edge, 10L, 6L);
  /*$endif TRACE*/
  if (ic && !exact_test) {
    if (!follow && !in_forward)
      select_limit = *p_edge;
    else
      select_limit = 0 + alfa_reject;
  } else
    select_limit = alfa_reject;
  if (in_forward)
    *p_edge = INFINITY;
  else if (!ic || exact_test || follow)
    *p_edge = -INFINITY;
  /*$ifdef TRACE*/
  if (boolean_option[15])
    write_real(stdout, *p_edge, 10L, 6L);
  /*$endif TRACE*/
  P_setcpy(edge, empty_set);
  while (link_sort_list != NULL) {
    P_setcpy(a, link_sort_list->vertex_set);
    p_value = select_p_value(link_sort_list->link_test_list);
    if (is_invalid_real(p_value))
      reject = false;
    else
      reject = (p_value <= select_limit);
    if (parts_limit < 1 && !reject) {
      p = link_sort_list->link_part_list;
      while (!reject && p != NULL) {
	reject = (select_p_value(p->link_test_list) < parts_limit);
	p = p->pointer;
      }
    }
    if (separators_limit < 1 && !reject) {
      p = link_sort_list->link_sepa_list;
      while (!reject && p != NULL) {
	reject = (select_p_value(p->link_test_list) < separators_limit);
	p = p->pointer;
      }
    }
    if (reject) {
      if (in_forward && p_value <= *p_edge) {
	*p_test = link_sort_list->link_test_list;
	*p_edge = p_value;
	P_setcpy(edge, a);
      }
      if (coherent || in_forward)
	insert_clique(a, rejected_edges);
    } else if (!is_invalid_real(p_value)) {
      if (!in_forward && p_value >= *p_edge) {
	*p_test = link_sort_list->link_test_list;
	*p_edge = p_value;
	P_setcpy(edge, a);
      }
      if ((coherent || !in_forward) && p_value >= alfa_)
	insert_clique(a, accepted_edges);
    }
    /*$ifdef TRACE*/
    if (boolean_option[15])
      write_real(stdout, *p_edge, 10L, 6L);
    /*$endif TRACE*/
    link_sort_list = link_sort_list->pointer;
  }
  /*$ifdef TRACE*/
  if (boolean_option[15]) {
    /*$endif TRACE*/
    write_line(stdout);
  }
}  /* select_and_update */


Static Void shuffle_edges(p_edges)
t_set_list **p_edges;
{
  t_set_list *p, *q, *new_edges;
  t_integer number_of_edges, selected, i, j;

  number_of_edges = 0;
  p = *p_edges;
  while (p != NULL) {
    number_of_edges++;
    p = p->pointer;
  }
  new_edges = NULL;
  for (j = number_of_edges; j >= 1; j--) {
    selected = floor_x(j * uniform(&seed));
    if (selected == 0) {
      q = *p_edges;
      *p_edges = (*p_edges)->pointer;
    } else {
      p = *p_edges;
      for (i = 1; i < selected; i++)
	p = p->pointer;
      q = p->pointer;
      p->pointer = p->pointer->pointer;
    }
    q->pointer = new_edges;
    new_edges = q;
  }
  *p_edges = new_edges;
}  /* shuffle_edges */


Static Void return_first_and_last(a, v, w)
long *a;
t_vertex *v, *w;
{
  *v = first_vertex;
  while (!P_inset(*v, a) && *v < last_vertex)
    (*v)++;
  *w = last_vertex;
  while (!P_inset(*w, a) && first_vertex < *w)
    (*w)--;
}  /* return_first_and_last */


Static Void write_stepwise_head(v, w, c, hierarchical_search, separators,
				short_test_output, write_models)
t_vertex *v, *w;
long *c;
boolean *hierarchical_search, *separators, *short_test_output, *write_models;
{
  if (*write_models) {
    if (*hierarchical_search) {
      write_space(stdout, 3L);
      print_vertex_set_table(c);
      write_space(stdout, 1L);
    } else
      print_edge(stdout, *short_test_output, *write_models, *v, *w);
  }
  if (*separators && *write_models)
    write_space(stdout, 11L);
}  /* write_stepwise_head */


Static Void write_not_decomposable(tmp_g_c, from_g_c, v, w, c, model_set,
  forward_selection, graphical_model, hierarchical_search, just, short_report,
  separators, short_test_output, write_models)
t_set_list *tmp_g_c, **from_g_c;
t_vertex *v, *w;
long *c, *model_set;
boolean forward_selection, *graphical_model, *hierarchical_search, *just,
	*short_report, *separators, *short_test_output, *write_models;
{
  if (*short_report)
    return;
  if (*just)
    write_stepwise_head(v, w, c, hierarchical_search, separators,
			short_test_output, write_models);
  write_space(stdout, 2L);
  if (tmp_g_c == NULL) {
    if (cardinality(model_set) < 10 && *write_models) {
      if (!*graphical_model || *hierarchical_search) {
	if (forward_selection)
	  add_interaction_to_g_c(&tmp_g_c, from_g_c, c);
	else
	  drop_interaction_from_g_c(&tmp_g_c, from_g_c, c);
      } else if (forward_selection) {
	if (c_factorizes == 1)
	  add_edge_to_g_c(&tmp_g_c, from_g_c, c);
	else
	  sub_add_edge_to_g_c(&tmp_g_c, from_g_c, *v, *w);
      } else if (c_factorizes == 1)
	drop_edge_from_g_c(&tmp_g_c, from_g_c, c);
      else
	sub_drop_edge_from_g_c(&tmp_g_c, from_g_c, *v, *w);
      print_g_c(tmp_g_c, 10L, line_length);
      dispose_set_list(&tmp_g_c);
    } else {
      if (!*write_models)
	write_space(stdout, 16L);
      write_pch(stdout, " Resulting model", 16L);
    }
  } else
    print_g_c(tmp_g_c, 10L, line_length);
  write_pch(stdout, " is not decomposable", 20L);
  if (*write_models) {
    write_line(stdout);
    return;
  }
  write_char(stdout, ':');
  write_char(stdout, ' ');
  print_vertex_set_table(c);
  write_line(stdout);
}  /* write_not_decomposable */


Static Void end_stepwise_step(g_c, v, w, c, p, link_sort_list, p_test,
  hierarchical_search, forward_selection, reversed, sorted_list, short_report,
  just, separators, short_test_output, write_models, partitioning)
t_set_list **g_c;
t_vertex *v, *w;
long *c;
t_sort_list **p, **link_sort_list;
t_test_list **p_test;
boolean hierarchical_search, forward_selection, reversed, sorted_list,
	short_report, *just, *separators, *short_test_output, *write_models,
	*partitioning;
{
  dispose_marginals_cond();
  if (link_part_list != NULL) {
    sum_up_partitioning(p, 0L, &c_partitioning, short_test_output,
			write_models, just, exclude_missing && *partitioning,
			0L);
    if (!*write_models && !short_report && !*just) {
      if (hierarchical_search) {
	write_space(stdout, 3L);
	print_vertex_set_table(c);
	write_space(stdout, 1L);
      } else
	print_edge(stdout, *short_test_output, *write_models, *v, *w);
      write_line(stdout);
    }
    if (*separators)
      test_all_cut_sets(g_c, v, w, p_test, just, short_test_output,
			write_models);
    (*p)->link_sepa_list = link_part_list;
    link_part_list = NULL;
    if (sorted_list) {
      P_setcpy((*p)->vertex_set, c);
      insert_test_in_sort_list(p, reversed, link_sort_list);
    } else
      dispose_sort_list(p);
    return;
  }
  if (!*separators)
    return;
  if (!*write_models && !short_report && !*just) {
    if (hierarchical_search) {
      write_space(stdout, 3L);
      print_vertex_set_table(c);
      write_space(stdout, 1L);
    } else
      print_edge(stdout, *short_test_output, *write_models, *v, *w);
    write_line(stdout);
  }
  test_all_cut_sets(g_c, v, w, p_test, just, short_test_output, write_models);
  dispose_part_list(&link_part_list);
}  /* end_stepwise_step */


Static Void note_edge(current, rejected, accepted, eligible, edge)
t_set_list **current, **rejected, **accepted, **eligible;
long *edge;
{
  boolean ok;

  if (default_dump_set || dump_set) {
    flush_file(&dump_file);
    close_file(dump_file);
    unlink_tmp_file(&dump_file, dump_name, dump_set || !default_dump_set);
  }
  ok = true;
  assign_write(&dump_file, dump_name, &ok);
  rewrite_text_file(dump_file);
  write_pch_20_text(dump_file, " Current edge:      ", 20L);
  print_vertex_set_on_report(dump_file, edge);
  write_line_text(dump_file);
  if (coherent) {
    write_pch_20_text(dump_file, " Rejected edges:    ", 20L);
    print_set_list_on_report(dump_file, *rejected);
    write_line_text(dump_file);
  }
  write_pch_20_text(dump_file, " Accepted edges:    ", 20L);
  print_set_list_on_report(dump_file, *accepted);
  write_line_text(dump_file);
  write_pch_20_text(dump_file, " Model:             ", 20L);
  print_set_list_on_report(dump_file, *current);
  write_line_text(dump_file);
  if (*eligible != NULL) {
    write_pch_20_text(dump_file, " Edges eligible:    ", 20L);
    print_set_list_on_report(dump_file, *eligible);
    write_line_text(dump_file);
  }
  flush_file(&dump_file);
}  /* note_edge */


Static Void report_stepwise(current, rejected, accepted, eligible, edge, test,
  forward_selection, offset, just, sorted_list, short_report, alternative,
  headlong, coherent, short_test_output, write_models)
t_set_list **current, **rejected, **accepted, **eligible;
long *edge;
t_test *test;
boolean forward_selection;
long *offset;
boolean *just, *sorted_list, *short_report, *alternative, *headlong,
	*coherent, *short_test_output, *write_models;
{
  boolean dummy_true;
  t_long_integer dummy_0;

  if (*short_report) {
    if (dump)
      note_edge(current, rejected, accepted, eligible, edge);
    if (*alternative || !*headlong)
      return;
    dummy_true = true;
    dummy_0 = 0;
    if (!*write_models) {
      if (exclude_missing)
	print_n_total_exclude(empty_set, short_test_output, write_models,
			      test->n_count, dummy_0);
      write_test(test, short_test_output, *write_models, dummy_true, dummy_0);
    }
    if (*short_test_output) {
      if (*write_models)
	write_space(stdout, 3L);
      print_vertex_set(edge);
      write_space(stdout, 3L);
    }
    if (!*write_models)
      write_line(stdout);
    if (!*write_models)
      return;
    if (exclude_missing)
      print_n_total_exclude(empty_set, short_test_output, write_models,
			    test->n_count, dummy_0);
    write_test(test, short_test_output, *write_models, dummy_true, dummy_0);
    return;
  }
  if (*just && !*sorted_list)
    return;
  if (*short_test_output)
    write_line(stdout);
  write_pch(stdout, " Edge selected:     ", 20L);
  print_vertex_set(edge);
  write_line(stdout);
  write_pch(stdout, " Rejected edges:    ", 20L);
  print_g_c(*rejected, 20L, line_length);
  write_line(stdout);
  write_pch(stdout, " Accepted edges:    ", 20L);
  print_g_c(*accepted, 20L, line_length);
  write_line(stdout);
  write_pch(stdout, " Model:             ", 20L);
  print_g_c(*current, 20L, line_length);
  write_line(stdout);
  write_pch(stdout, " Edges eligible:    ", 20L);
  if (*eligible == NULL)
    write_pch(stdout, "Empty", 5L);
  else
    print_g_c(*eligible, 20L, line_length);
  write_line(stdout);
  if (!*short_test_output || *just || *eligible == NULL) {
    write_line(stdout);
    return;
  }
  if (forward_selection)
    write_test_head_stepwise(stdout, " Adding   ", *offset,
			     *short_test_output, *write_models, *short_report,
			     *just);
  else
    write_test_head_stepwise(stdout, " Removing ", *offset,
			     *short_test_output, *write_models, *short_report,
			     *just);
}  /* report_stepwise */


Static Void report_last_test(forward_selection, p, p_edge_list,
  headlong_p_value, headlong_select_limit, start_clock, short_report,
  alternative, headlong, short_test_output, write_models)
boolean forward_selection;
t_sort_list **p;
t_set_list **p_edge_list;
double *headlong_p_value, *headlong_select_limit, *start_clock;
boolean *short_report, *alternative, *headlong, *short_test_output,
	*write_models;
{
  boolean dummy_true;
  t_long_integer dummy_0;

  if (!(*p != NULL && (*headlong || *short_report)))
    return;
  *headlong_p_value = select_p_value((*p)->link_test_list);
  if (dump && *short_report) {
    write_pch_20_text(dump_file, " Current_edge: ", 15L);
    print_vertex_set_on_report(dump_file, (*p_edge_list)->vertex_set);
    write_pch_10_text(dump_file, " P-value: ", 10L);
    write_real_text(dump_file, headlong_p_value, 14L, 6L);
    write_time_text(dump_file, " Time: ", 7L, (double)my_clock()/1,
		    *start_clock, 14L, 3L);
    write_line_text(dump_file);
    flush_file(&dump_file);
  }
  if ((!forward_selection && *headlong_p_value > *headlong_select_limit) |
      ((forward_selection && *headlong_p_value < *headlong_select_limit &&
	!*headlong &&
	*short_report) & (!is_invalid_real(*headlong_p_value)))) {
    if (!forward_selection && *alternative ||
	forward_selection && !*alternative) {
      dummy_true = true;
      dummy_0 = 0;
      if (!*write_models)
	write_test(&(*p)->link_test_list->test, short_test_output,
		   *write_models, dummy_true, dummy_0);
      if (*short_test_output) {
	write_space(stdout, 3L);
	print_vertex_set((*p_edge_list)->vertex_set);
	write_space(stdout, 3L);
      }
      if (*write_models)
	write_test(&(*p)->link_test_list->test, short_test_output,
		   *write_models, dummy_true, dummy_0);
    }
  }
  /*$ifdef TRACE*/
  if (!boolean_option[15])
    return;
  /*$endif TRACE*/
  write_pch_r(stdout, "HeadlongP:", 10L, 30L);
  write_real(stdout, *headlong_p_value, 10L, 6L);
  write_line(stdout);
}  /* report_last_test */


/*@+"backward.p"*/


Static Void backward_parted(g_c_current, g_c_base, g_c, v, w, c, local_delta,
  p_test, offset, ok_to_collaps, graphical_model, just, short_report,
  separators, hierarchical_search, short_test_output, write_models)
t_set_list **g_c_current, **g_c_base, **g_c;
t_vertex *v, *w;
long *c, *local_delta;
t_test_list **p_test;
long *offset;
boolean *ok_to_collaps, *graphical_model, *just, *short_report, *separators,
	*hierarchical_search, *short_test_output, *write_models;
{
  boolean ok;
  t_vertex_set a, bv, bw;
  t_long_integer number_of_tests;
  t_set_list *tmp_g_c;

  *g_c = NULL;
  if (*hierarchical_search || incomplete_table)
    ok = false;
  else if (*graphical_model) {
    copy_set_list(*g_c_current, &tmp_g_c);
    ok = was_edge_in_one_clique(v, w, &tmp_g_c, a);
    dispose_set_list(&tmp_g_c);
  } else
    ok = false;
  if (*ok_to_collaps && ok) {
    P_addset(P_expset(bv, 0L), *w);
    P_setdiff(bv, a, bv);
    P_addset(P_expset(bw, 0L), *v);
    P_setdiff(bw, a, bw);
    insert_set_in_set_list(bv, g_c);
    insert_set_in_set_list(bw, g_c);
    one_edge_collaps_set(a, bv, bw, v, w, p_test, short_test_output,
			 write_models, just);
    return;
  }
  if (*graphical_model && !*hierarchical_search) {
    if (*ok_to_collaps) {
      if (ok || !decomposable_mode) {
	if (c_factorizes == 1)
	  drop_edge_from_g_c(g_c, g_c_current, c);
	else
	  sub_drop_edge_from_g_c(g_c, g_c_current, *v, *w);
      } else
	*g_c = NULL;
    } else {
      if (c_factorizes == 1)
	drop_edge_from_g_c(g_c, g_c_current, c);
      else
	sub_drop_edge_from_g_c(g_c, g_c_current, *v, *w);
      if (decomposable_mode)
	ok = g_c_decomposable(g_c);
      else
	ok = true;
    }
  } else {
    drop_interaction_from_g_c(g_c, g_c_current, c);
    if (decomposable_mode)
      ok = g_c_decomposable(g_c);
    else
      ok = true;
  }
  if ((!ok || incomplete_table) && decomposable_mode) {
    write_not_decomposable(*g_c, g_c_current, v, w, c, local_delta, false,
			   graphical_model, hierarchical_search, short_report,
			   just, separators, short_test_output, write_models);
    return;
  }
  number_of_tests = 0;
  partitioning_hierarchical(g_c, g_c_base, short_test_output, write_models,
			    &number_of_tests, 0L);
  if (!*short_test_output || *just || link_part_list == NULL)
    return;
  if (link_part_list->pointer == NULL)
    return;
  if (*write_models)
    write_space(stdout, 3L);
  write_char(stdout, '=');
  if (*write_models)
    write_space(stdout, *offset + 3);
  else
    write_line(stdout);
}  /* backward_parted */


Static Void backward_non_parted(g_c_current, g_c_base, g_c, v, w, c,
  local_delta, graphical_model, just, short_report, separators,
  hierarchical_search, short_test_output, write_models)
t_set_list **g_c_current, **g_c_base, **g_c;
t_vertex *v, *w;
long *c, *local_delta;
boolean *graphical_model, *just, *short_report, *separators,
	*hierarchical_search, *short_test_output, *write_models;
{
  boolean ok;
  t_long_integer dummy_0;

  if (*graphical_model && !*hierarchical_search) {
    if (c_factorizes == 1)
      drop_edge_from_g_c(g_c, g_c_current, c);
    else
      sub_drop_edge_from_g_c(g_c, g_c_current, *v, *w);
  } else
    drop_interaction_from_g_c(g_c, g_c_current, c);
  if (!test_hier_submodel(g_c, g_c_base, *short_test_output, *write_models,
			  0L))
    return;
  if (decomposable_mode)
    ok = g_c_decomposable(g_c);
  else
    ok = true;
  dummy_0 = 0;
  if (ok)
    test_generating_classes(g_c, g_c_base, local_delta, short_test_output,
			    write_models, &dummy_0);
  else
    write_not_decomposable(*g_c, g_c_current, v, w, c, local_delta, false,
			   graphical_model, hierarchical_search, short_report,
			   just, separators, short_test_output, write_models);
}  /* backward_non_parted */


Static Void backward_try_one_edge(g_c_current, g_c_base, graphical_model,
  ok_to_collaps, link_sort_list, link_last_test, c, local_delta, offset, just,
  reversed, sorted_list, short_report, recursive, separators,
  hierarchical_search, short_test_output, write_models, partitioning)
t_set_list **g_c_current, **g_c_base;
boolean *graphical_model, *ok_to_collaps;
t_sort_list **link_sort_list, **link_last_test;
long *c, *local_delta;
long *offset;
boolean *just, *reversed, *sorted_list, *short_report, *recursive,
	*separators, *hierarchical_search, *short_test_output, *write_models,
	*partitioning;
{
  t_test_list *p_test;
  t_vertex v, w;
  t_set_list *tmp_g_c;
  FILE *TEMP;

  if (!*hierarchical_search)
    return_first_and_last(c, &v, &w);
  if (!*just)
    write_stepwise_head(&v, &w, c, hierarchical_search, separators,
			short_test_output, write_models);
  TEMP = stdout;
  flush_file(&TEMP);
  flush_file(&diary_file);
  if (*partitioning)
    backward_parted(g_c_current, g_c_base, &tmp_g_c, &v, &w, c, local_delta,
		    &p_test, offset, ok_to_collaps, graphical_model, just,
		    short_report, separators, hierarchical_search,
		    short_test_output, write_models);
  else
    backward_non_parted(g_c_current, g_c_base, &tmp_g_c, &v, &w, c,
			local_delta, graphical_model, just, short_report,
			separators, hierarchical_search, short_test_output,
			write_models);
  end_stepwise_step(&tmp_g_c, &v, &w, c, link_last_test, link_sort_list,
		    &p_test, *hierarchical_search, false, *reversed, true,
		    *short_report, just, separators, short_test_output,
		    write_models, partitioning);
  dispose_set_list(&tmp_g_c);
}  /* backward_try_one_edge */


Static Void backward_return_terms(g_c, eligible_edges)
t_set_list **g_c, **eligible_edges;
{
  _PROCEDURE TEMP;

  dispose_set_list(eligible_edges);
  copy_set_list(*g_c, eligible_edges);

  TEMP.proc = (Anyptr)subset_of_an_edge;
  TEMP.link = (Anyptr)NULL;

  /*$ifdef On-DOS
  exclude_sub_vertex_sets_in_list(eligible_edges, fix_edges_gc)
   $endif On-DOS*/
  exclude_vertex_sets_in_list(eligible_edges, TEMP, &fix_edges_gc);
}  /* backward_return_terms */


Static Void backward_one_step(g_c_current, g_c_base, local_delta, offset,
  graphical_model, just, reversed, sorted_list, short_report, headlong,
  recursive, coherent, follow, separators, hierarchical_search,
  short_test_output, write_models, partitioning)
t_set_list **g_c_current, **g_c_base;
long *local_delta;
long *offset;
boolean *graphical_model, *just, *reversed, *sorted_list, *short_report,
	*headlong, *recursive, *coherent, *follow, *separators,
	*hierarchical_search, *short_test_output, *write_models,
	*partitioning;
{
  boolean ok_to_collaps;
  t_vertex v, w;
  t_sort_list *link_last_test, *link_sort_list;
  t_vertex_set a, edge;
  t_long_real p_edge;
  t_test_list *selected_test;
  t_set_list *rejected_edges, *accepted_edges;

  link_sort_list = NULL;
  if (*follow && !*recursive)
    *g_c_base = *g_c_current;
  ok_to_collaps = !*hierarchical_search;
  if (ok_to_collaps)
    ok_to_collaps = g_c_conformal(g_c_base);
  if (ok_to_collaps)
    ok_to_collaps = g_c_decomposable(g_c_base);
  if (ok_to_collaps && !*follow)
    ok_to_collaps = test_sub_g_c(*g_c_base, *g_c_current);
  v = first_vertex;
  while (v < last_vertex && !interrupt_2) {
    w = v + 1;
    while (w <= last_vertex && !interrupt_2) {
      P_addset(P_expset(a, 0L), v);
      P_addset(a, w);
      if (P_subset(a, local_delta) & subset_of_an_edge(a, g_c_current) &
	  (!P_inset(w, fix_edges_adj_set[v - MIN_VERTEX])))
	backward_try_one_edge(g_c_current, g_c_base, graphical_model,
	  &ok_to_collaps, &link_sort_list, &link_last_test, a, local_delta,
	  offset, just, reversed, sorted_list, short_report, recursive,
	  separators, hierarchical_search, short_test_output, write_models,
	  partitioning);
      w++;
    }
    v++;
  }
  P_setcpy(edge, empty_set);
  p_edge = 0.0;
  rejected_edges = NULL;
  accepted_edges = NULL;
  select_and_update(link_sort_list, &selected_test, &rejected_edges,
		    &accepted_edges, edge, &p_edge, *coherent, *follow,
		    false);
  write_line(stdout);
  write_pch(stdout, " Accepted edges:    ", 20L);
  print_g_c(accepted_edges, 16L, line_length);
  write_line(stdout);
  dispose_set_list(&rejected_edges);
  drop_edges_from_g_c(&rejected_edges, g_c_current, &accepted_edges);
  insert_set_list_in_new_model(&rejected_edges);
  dispose_set_list(&accepted_edges);
  if (*sorted_list)
    write_sorted_list(link_sort_list, short_test_output, write_models);
  dispose_sort_list(&link_sort_list);
}  /* backward_one_step */


Static Void backward_update_model(g_c_current, graphical_model, ok_to_collaps,
  edge, local_delta, accepted_edges, alternative, hierarchical_search)
t_set_list **g_c_current;
boolean *graphical_model, *ok_to_collaps;
long *edge, *local_delta;
t_set_list **accepted_edges;
boolean *alternative, *hierarchical_search;
{
  t_set_list *tmp_g_c, *tmp_set_list;

  if (*alternative) {
    if (*graphical_model && !*hierarchical_search)
      drop_edges_from_g_c(&tmp_g_c, g_c_current, accepted_edges);
    else {
      copy_set_list(*accepted_edges, &tmp_set_list);
      drop_interactions_from_g_c(&tmp_g_c, g_c_current, &tmp_set_list,
				 local_delta);
    }
  } else if (*ok_to_collaps || *graphical_model && !*hierarchical_search)
    drop_edge_from_g_c(&tmp_g_c, g_c_current, edge);
  else
    drop_interaction_from_g_c(&tmp_g_c, g_c_current, edge);
  insert_set_list_in_new_model(&tmp_g_c);
  *g_c_current = tmp_g_c;
}  /* backward_update_model */


Static Void backward_update_edges(rejected_edges, accepted_edges,
				  eligible_edges, edge, alternative)
t_set_list **rejected_edges, **accepted_edges, **eligible_edges;
long *edge;
boolean *alternative;
{
  t_set_list *p_edge_list, *q_edge_list;
  t_vertex_set a;

  q_edge_list = *eligible_edges;
  *eligible_edges = NULL;
  while (q_edge_list != NULL) {
    p_edge_list = q_edge_list;
    P_setcpy(a, q_edge_list->vertex_set);
    q_edge_list = q_edge_list->pointer;
    if ((((*alternative) & contains_an_edge(a, accepted_edges)) |
	 subset_of_an_edge(a, rejected_edges)) || P_subset(edge, a))
      Free(p_edge_list);
    else {
      p_edge_list->pointer = *eligible_edges;
      *eligible_edges = p_edge_list;
    }
  }
}  /* backward_update_edges */


Static Void backward_many_steps(g_c_current, g_c_base, local_delta, offset,
  graphical_model, just, reversed, sorted_list, short_report, alternative,
  headlong, recursive, coherent, follow, separators, hierarchical_search,
  short_test_output, write_models, partitioning)
t_set_list **g_c_current, **g_c_base;
long *local_delta;
long *offset;
boolean *graphical_model, *just, *reversed, *sorted_list, *short_report,
	*alternative, *headlong, *recursive, *coherent, *follow, *separators,
	*hierarchical_search, *short_test_output, *write_models,
	*partitioning;
{
  boolean ok_to_collaps;
  t_vertex v, w;
  t_long_real headlong_p_value, headlong_select_limit, p_edge, start_clock;
  t_vertex_set a, edge;
  t_set_list *eligible_edges, *p_edge_list, *rejected_edges, *accepted_edges;
  t_sort_list *link_last_test, *link_sort_list;
  t_test_list *selected_test;
  t_vertex FORLIM, FORLIM1;

  *separators = (*separators && !*hierarchical_search);
  if (*hierarchical_search)
    *offset += 5;
  p_edge = 0.0;
  rejected_edges = NULL;
  accepted_edges = NULL;
  eligible_edges = NULL;
  if (*hierarchical_search)
    backward_return_terms(g_c_current, &eligible_edges);
  else {
    FORLIM = last_vertex;
    for (v = first_vertex; v < FORLIM; v++) {
      FORLIM1 = last_vertex;
      for (w = v + 1; w <= FORLIM1; w++) {
	P_addset(P_expset(a, 0L), v);
	P_addset(a, w);
	if (P_subset(a, local_delta) & subset_of_an_edge(a, g_c_current) &
	    (!P_inset(w, fix_edges_adj_set[v - MIN_VERTEX])))
	  insert_set_in_set_list(a, &eligible_edges);
      }
    }
  }
  start_clock = my_clock()/1;
  do {
    if (*hierarchical_search)
      *graphical_model = g_c_conformal(g_c_current);
    else
      *graphical_model = true;
    if (*follow)
      *g_c_base = *g_c_current;
    ok_to_collaps = !*hierarchical_search;
    if (ok_to_collaps)
      ok_to_collaps = g_c_conformal(g_c_base);
    if (ok_to_collaps)
      ok_to_collaps = g_c_decomposable(g_c_base);
    if (ok_to_collaps && !*follow)
      ok_to_collaps = test_sub_g_c(*g_c_base, *g_c_current);
    if (ic && !exact_test) {
      if (!*follow)
	headlong_select_limit = p_edge;
      else
	headlong_select_limit = 0 + alfa_;
    } else
      headlong_select_limit = alfa_;
    headlong_p_value = headlong_select_limit - ROUND_ERROR;
    if (*headlong)
      shuffle_edges(&eligible_edges);
    link_sort_list = NULL;
    p_edge_list = eligible_edges;
    while ((!interrupt_2 && p_edge_list != NULL) &
	   (!((*headlong && headlong_p_value > headlong_select_limit) &
	      (!is_invalid_real(headlong_p_value))))) {
      link_last_test = NULL;
      backward_try_one_edge(g_c_current, g_c_base, graphical_model,
	&ok_to_collaps, &link_sort_list, &link_last_test,
	p_edge_list->vertex_set, local_delta, offset, just, reversed,
	sorted_list, short_report, recursive, separators, hierarchical_search,
	short_test_output, write_models, partitioning);
      report_last_test(false, &link_last_test, &p_edge_list,
		       &headlong_p_value, &headlong_select_limit,
		       &start_clock, short_report, alternative, headlong,
		       short_test_output, write_models);
      p_edge_list = p_edge_list->pointer;
    }
    if (timer && !*short_report && !*just)
      write_used_time(stdout, start_clock);
    select_and_update(link_sort_list, &selected_test, &rejected_edges,
		      &accepted_edges, edge, &p_edge, *coherent, *follow,
		      false);
    if (*sorted_list) {
      if (link_sort_list != NULL)
	write_sorted_list(link_sort_list, short_test_output, write_models);
      dispose_sort_list(&link_sort_list);
    } else
      dispose_sort_list(&link_sort_list);
    if (p_edge >= alfa_ && !P_setequal(edge, empty_set) &&
	accepted_edges != NULL) {
      backward_update_model(g_c_current, graphical_model, &ok_to_collaps,
			    edge, local_delta, &accepted_edges, alternative,
			    hierarchical_search);
      if (*hierarchical_search)
	backward_return_terms(g_c_current, &eligible_edges);
      backward_update_edges(&rejected_edges, &accepted_edges, &eligible_edges,
			    edge, alternative);
      report_stepwise(g_c_current, &rejected_edges, &accepted_edges,
		      &eligible_edges, edge, &selected_test->test, false,
		      offset, just, sorted_list, short_report, alternative,
		      headlong, coherent, short_test_output, write_models);
    }
  } while (!(!*recursive || p_edge < alfa_ || P_setequal(edge, empty_set) ||
	     accepted_edges == NULL ||
	     eligible_edges == NULL || interrupt_2));
  dispose_set_list(&rejected_edges);
  dispose_set_list(&accepted_edges);
  dispose_set_list(&eligible_edges);
}  /* backward_many_steps */


Static Void backward_elimination(link_curr, link_base, just, reversed,
  sorted_list, short_report, alternative, headlong, recursive, coherent,
  follow, separators, hierarchical_search, short_test_output, write_models,
  partitioning)
t_model_list *link_curr, *link_base;
boolean *just, *reversed, *sorted_list, *short_report, *alternative,
	*headlong, *recursive, *coherent, *follow, *separators,
	*hierarchical_search, *short_test_output, *write_models,
	*partitioning;
{
  boolean graphical_model;
  t_vertex_set local_delta;
  t_long_integer offset;
  t_set_list *g_c_current, *g_c_base;

  P_setcpy(local_delta, link_curr->model.model_set);
  g_c_current = link_curr->model.sets_h_g_c;
  g_c_base = link_base->model.sets_h_g_c;
  if (*short_report)
    sorted = false;
  if (*short_report)
    *reversed = false;
  offset = 0;
  if (*separators && *write_models)
    offset = 11;
  if ((*follow) | test_sub_g_c(g_c_current, g_c_base)) {
    graphical_model = g_c_conformal(&g_c_current);
    *hierarchical_search = (*hierarchical_search || !graphical_model);
    if (*recursive || *hierarchical_search)
      backward_many_steps(&g_c_current, &g_c_base, local_delta, &offset,
			  &graphical_model, just, reversed, sorted_list,
			  short_report, alternative, headlong, recursive,
			  coherent, follow, separators, hierarchical_search,
			  short_test_output, write_models, partitioning);
    else
      backward_one_step(&g_c_current, &g_c_base, local_delta, &offset,
			&graphical_model, just, reversed, sorted_list,
			short_report, headlong, recursive, coherent, follow,
			separators, hierarchical_search, short_test_output,
			write_models, partitioning);
    if (interrupt_2) {
      interrupt_1 = false;
      interrupt_2 = false;
    }
    return;
  }
  write_space(stdout, 3L);
  print_g_c(g_c_current, 11L, line_length);
  write_pch(stdout, " not submodel of ", 17L);
  write_line(stdout);
  write_space(stdout, 3L);
  print_g_c(g_c_base, 11L, line_length);
  write_line(stdout);
}  /* backward_elimination */


Static Void proc_backward(code)
long *code;
{
  boolean tmp_re_use, ok, try_interactions;
  t_test_list *p;
  t_long_integer offset;
  t_model_list *link_model;
  boolean local_short_test_output, local_write_models;

  local_short_test_output = true;
  local_write_models = !short_test_output;
  if (!current_and_base())
    return;
  ok = true;
  if (!c_partitioning)
    ok = ok_base();
  if (!ok)
    return;
  link_model = link_current;
  if (!link_model->model.found_expression)
    identify_model(&link_model->model);
  if (!link_model->model.graphical && *code == 1) {
    new_model(&link_model_list, &first_model_available);
    generate_graphical_model(&link_model_list->model, &link_model->model);
    link_model = link_model_list;
    identify_model(&link_model->model);
  }
  try_interactions = (*code == 2 ||
		      (*code == 3 && !link_model->model.graphical &&
		       !incomplete_table));
  separators = (separators && !try_interactions);
  if (separators && local_write_models)
    offset = 11;
  else
    offset = 0;
  if (try_interactions)
    offset += 5;
  write_test_head_stepwise(stdout, "Removing  ", offset,
			   local_short_test_output, local_write_models,
			   short_report, just);
  if (!re_use_test && (direct || sorted_list || brute)) {
    p = link_test_list;
    link_test_list = NULL;
    re_use_test = true;
    tmp_re_use = true;
  } else
    tmp_re_use = false;
  just = (just || short_report);
  backward_elimination(link_model, link_base, &just, &reversed, &sorted_list,
		       &short_report, &alternative, &brute, &direct,
		       &coherent, &follow, &separators, &try_interactions,
		       &local_short_test_output, &local_write_models,
		       &c_partitioning);
  if (tmp_re_use) {
    dispose_tests();
    link_test_list = p;
    re_use_test = false;
  }
  just = false;
  reversed = false;
  sorted_list = false;
  short_report = false;
  alternative = false;
  follow = false;
  separators = false;
  coherent = false;
  direct = false;
  brute = false;
  note_command_end_pch(stdout, " Test computed", 14L);
}  /* proc_backward */


/*@+"forward.p"*/


Static boolean test_decomposable_after_adding_edge(g_c, v, w, a)
t_set_list **g_c;
t_vertex *v, *w;
long *a;
{
  boolean decomposable;
  t_v_arr_of_v_sets adj_set;
  t_vertex u;
  t_vertex_set g, b;
  t_vertex FORLIM;

  hypergraph_sets_to_graph_sets(*g_c, g, adj_set);
  P_addset(adj_set[*v - MIN_VERTEX], *w);
  P_addset(adj_set[*w - MIN_VERTEX], *v);
  decomposable = adj_set_decomposable(adj_set);
  P_setcpy(a, empty_set);
  if (!decomposable)
    return decomposable;
  P_addset(P_expset(b, 0L), *v);
  P_addset(b, *w);
  FORLIM = last_vertex;
  for (u = first_vertex; u <= FORLIM; u++) {
    if (P_subset(b, adj_set[u - MIN_VERTEX]))
      P_addset(a, u);
  }
  return decomposable;
}  /* test_decomposable_after_adding_edge */


Static Void forward_parted(g_c_current, v, w, c, local_delta, p_test, offset,
			   decomposable_model, graphical_model, just,
			   short_report, separators, hierarchical_search,
			   short_test_output, write_models)
t_set_list **g_c_current;
t_vertex *v, *w;
long *c, *local_delta;
t_test_list **p_test;
long *offset;
boolean *decomposable_model, *graphical_model, *just, *short_report,
	*separators, *hierarchical_search, *short_test_output, *write_models;
{
  boolean ok;
  t_vertex_set a, bv, bw;
  t_long_integer number_of_tests;
  t_set_list *tmp_g_c;

  if (*hierarchical_search || incomplete_table)
    ok = false;
  else if (*graphical_model)
    ok = test_decomposable_after_adding_edge(g_c_current, v, w, a);
  else
    ok = false;
  if (*decomposable_model && ok) {
    P_addset(P_expset(bv, 0L), *v);
    P_setunion(bv, a, bv);
    P_addset(P_expset(bw, 0L), *w);
    P_setunion(bw, a, bw);
    P_setunion(a, bv, bw);
    one_edge_collaps_set(a, bv, bw, v, w, p_test, short_test_output,
			 write_models, just);
    return;
  }
  tmp_g_c = NULL;
  if (*graphical_model && !*hierarchical_search) {
    if (*decomposable_model) {
      if (ok || !decomposable_mode) {
	if (c_factorizes == 1)
	  add_edge_to_g_c(&tmp_g_c, g_c_current, c);
	else
	  sub_add_edge_to_g_c(&tmp_g_c, g_c_current, *v, *w);
      }
    } else {
      if (c_factorizes == 1)
	add_edge_to_g_c(&tmp_g_c, g_c_current, c);
      else
	sub_add_edge_to_g_c(&tmp_g_c, g_c_current, *v, *w);
      if (decomposable_mode)
	ok = g_c_decomposable(&tmp_g_c);
      else
	ok = true;
    }
  } else {
    add_interaction_to_g_c(&tmp_g_c, g_c_current, c);
    if (decomposable_mode)
      ok = g_c_decomposable(&tmp_g_c);
    else
      ok = true;
  }
  if (ok && !incomplete_table || !decomposable_mode) {
    number_of_tests = 0;
    partitioning_hierarchical(g_c_current, &tmp_g_c, short_test_output,
			      write_models, &number_of_tests, 0L);
    if (*short_test_output && !*just && link_part_list != NULL) {
      if (link_part_list->pointer != NULL) {
	if (*write_models)
	  write_space(stdout, 3L);
	write_char(stdout, '=');
	if (*write_models)
	  write_space(stdout, *offset + 3);
	else
	  write_line(stdout);
      }
    }
  } else
    write_not_decomposable(NULL, g_c_current, v, w, c, local_delta, true,
			   graphical_model, hierarchical_search, short_report,
			   just, separators, short_test_output, write_models);
  dispose_set_list(&tmp_g_c);
}  /* forward_parted */


Static Void forward_non_parted(g_c_current, v, w, c, local_delta,
  graphical_model, just, short_report, separators, hierarchical_search,
  short_test_output, write_models)
t_set_list **g_c_current;
t_vertex *v, *w;
long *c, *local_delta;
boolean *graphical_model, *just, *short_report, *separators,
	*hierarchical_search, *short_test_output, *write_models;
{
  boolean ok;
  t_set_list *tmp_g_c;
  t_long_integer dummy_0;

  if (*graphical_model && !*hierarchical_search) {
    if (c_factorizes == 1)
      add_edge_to_g_c(&tmp_g_c, g_c_current, c);
    else
      sub_add_edge_to_g_c(&tmp_g_c, g_c_current, *v, *w);
  } else
    add_interaction_to_g_c(&tmp_g_c, g_c_current, c);
  if (decomposable_mode)
    ok = g_c_decomposable(&tmp_g_c);
  else
    ok = true;
  dummy_0 = 0;
  if (ok)
    test_generating_classes(g_c_current, &tmp_g_c, local_delta,
			    short_test_output, write_models, &dummy_0);
  else
    write_not_decomposable(tmp_g_c, g_c_current, v, w, c, local_delta, true,
			   graphical_model, hierarchical_search, short_report,
			   just, separators, short_test_output, write_models);
  dispose_set_list(&tmp_g_c);
}  /* forward_non_parted */


Static Void forward_try_one_edge(g_c_current, decomposable_model,
  graphical_model, link_sort_list, link_last_test, c, local_delta, offset,
  just, reversed, sorted_list, short_report, recursive, separators,
  hierarchical_search, short_test_output, write_models, partitioning)
t_set_list **g_c_current;
boolean *decomposable_model, *graphical_model;
t_sort_list **link_sort_list, **link_last_test;
long *c, *local_delta;
long *offset;
boolean *just, *reversed, *sorted_list, *short_report, *recursive,
	*separators, *hierarchical_search, *short_test_output, *write_models,
	*partitioning;
{
  t_test_list *p_test;
  t_vertex v, w;
  FILE *TEMP;

  if (!*hierarchical_search)
    return_first_and_last(c, &v, &w);
  if (!*just)
    write_stepwise_head(&v, &w, c, hierarchical_search, separators,
			short_test_output, write_models);
  TEMP = stdout;
  flush_file(&TEMP);
  flush_file(&diary_file);
  if (*partitioning)
    forward_parted(g_c_current, &v, &w, c, local_delta, &p_test, offset,
		   decomposable_model, graphical_model, just, short_report,
		   separators, hierarchical_search, short_test_output,
		   write_models);
  else
    forward_non_parted(g_c_current, &v, &w, c, local_delta, graphical_model,
		       just, short_report, separators, hierarchical_search,
		       short_test_output, write_models);
  end_stepwise_step(g_c_current, &v, &w, c, link_last_test, link_sort_list,
		    &p_test, *hierarchical_search, true, !*reversed, true,
		    *short_report, just, separators, short_test_output,
		    write_models, partitioning);
}  /* forward_try_one_edge */


Static Void forward_return_terms(model_set, g_c, eligible_edges)
long *model_set;
t_set_list **g_c, **eligible_edges;
{
  _PROCEDURE TEMP;

  dispose_set_list(eligible_edges);
  normal_to_dual(*g_c, model_set, eligible_edges);

  TEMP.proc = (Anyptr)contains_an_edge;
  TEMP.link = (Anyptr)NULL;

  /*$ifdef On-DOS
  exclude_super_vertex_sets_in_list(eligible_edges, fix_edges_gc)
   $endif On-DOS*/
  exclude_vertex_sets_in_list(eligible_edges, TEMP, &fix_edges_gc);
}  /* forward_return_terms */


Static Void forward_one_step(g_c_current, local_delta, offset,
  graphical_model, just, reversed, sorted_list, short_report, recursive,
  coherent, separators, hierarchical_search, short_test_output, write_models,
  partitioning)
t_set_list **g_c_current;
long *local_delta;
long *offset;
boolean *graphical_model, *just, *reversed, *sorted_list, *short_report,
	*recursive, *coherent, *separators, *hierarchical_search,
	*short_test_output, *write_models, *partitioning;
{
  boolean decomposable_model;
  t_vertex v, w;
  t_sort_list *link_last_test, *link_sort_list;
  t_vertex_set a, edge;
  t_long_real p_edge;
  t_test_list *selected_test;
  t_set_list *rejected_edges, *accepted_edges;

  link_sort_list = NULL;
  if (*graphical_model)
    decomposable_model = g_c_decomposable(g_c_current);
  else
    decomposable_model = false;
  v = first_vertex;
  while (v < last_vertex && !interrupt_2) {
    w = v + 1;
    while (w <= last_vertex && !interrupt_2) {
      P_addset(P_expset(a, 0L), v);
      P_addset(a, w);
      if (P_subset(a, local_delta) & (!subset_of_an_edge(a, g_c_current)) &
	  (!P_inset(w, fix_edges_adj_set[v - MIN_VERTEX])))
	forward_try_one_edge(g_c_current, &decomposable_model,
	  graphical_model, &link_sort_list, &link_last_test, a, local_delta,
	  offset, just, reversed, sorted_list, short_report, recursive,
	  separators, hierarchical_search, short_test_output, write_models,
	  partitioning);
      w++;
    }
    v++;
  }
  P_setcpy(edge, empty_set);
  p_edge = 0.0;
  rejected_edges = NULL;
  accepted_edges = NULL;
  select_and_update(link_sort_list, &selected_test, &rejected_edges,
		    &accepted_edges, edge, &p_edge, *coherent, true, true);
  write_line(stdout);
  write_pch(stdout, " Rejected edges:    ", 20L);
  print_g_c(rejected_edges, 16L, line_length);
  write_line(stdout);
  dispose_set_list(&accepted_edges);
  add_edges_to_g_c(&accepted_edges, g_c_current, &rejected_edges, local_delta);
  insert_set_list_in_new_model(&accepted_edges);
  dispose_set_list(&rejected_edges);
  if (*sorted_list)
    write_sorted_list(link_sort_list, short_test_output, write_models);
  dispose_sort_list(&link_sort_list);
}  /* forward_one_step */


Static Void forward_update_model(g_c_current, graphical_model, edge,
  local_delta, rejected_edges, alternative, hierarchical_search)
t_set_list **g_c_current;
boolean *graphical_model;
long *edge, *local_delta;
t_set_list **rejected_edges;
boolean *alternative, *hierarchical_search;
{
  t_set_list *tmp_g_c, *tmp_set_list;

  if (!*alternative) {
    if (*graphical_model && !*hierarchical_search)
      add_edges_to_g_c(&tmp_g_c, g_c_current, rejected_edges, local_delta);
    else {
      copy_set_list(*rejected_edges, &tmp_set_list);
      add_interactions_to_g_c(&tmp_g_c, g_c_current, &tmp_set_list);
    }
  } else if (*graphical_model && !*hierarchical_search)
    add_edge_to_g_c(&tmp_g_c, g_c_current, edge);
  else
    add_interaction_to_g_c(&tmp_g_c, g_c_current, edge);
  insert_set_list_in_new_model(&tmp_g_c);
  *g_c_current = tmp_g_c;
}  /* forward_update_model */


Static Void forward_update_edges(rejected_edges, accepted_edges,
				 eligible_edges, edge, alternative)
t_set_list **rejected_edges, **accepted_edges, **eligible_edges;
long *edge;
boolean *alternative;
{
  t_set_list *p_edge_list, *q_edge_list;
  t_vertex_set a;

  q_edge_list = *eligible_edges;
  *eligible_edges = NULL;
  while (q_edge_list != NULL) {
    p_edge_list = q_edge_list;
    P_setcpy(a, q_edge_list->vertex_set);
    q_edge_list = q_edge_list->pointer;
    if ((((!*alternative) & subset_of_an_edge(a, rejected_edges)) |
	 contains_an_edge(a, accepted_edges)) || P_subset(a, edge))
      Free(p_edge_list);
    else {
      p_edge_list->pointer = *eligible_edges;
      *eligible_edges = p_edge_list;
    }
  }
}  /* forward_update_edges */


Static Void forward_many_steps(g_c_current, local_delta, offset,
  graphical_model, just, reversed, sorted_list, short_report, alternative,
  headlong, recursive, coherent, follow, separators, hierarchical_search,
  short_test_output, write_models, partitioning)
t_set_list **g_c_current;
long *local_delta;
long *offset;
boolean *graphical_model, *just, *reversed, *sorted_list, *short_report,
	*alternative, *headlong, *recursive, *coherent, *follow, *separators,
	*hierarchical_search, *short_test_output, *write_models,
	*partitioning;
{
  boolean decomposable_model;
  t_vertex v, w;
  t_long_real headlong_p_value, headlong_select_limit, p_edge, start_clock;
  t_vertex_set a, edge;
  t_set_list *eligible_edges, *p_edge_list, *rejected_edges, *accepted_edges;
  t_sort_list *link_last_test, *link_sort_list;
  t_test_list *selected_test;
  t_vertex FORLIM, FORLIM1;

  *separators = (*separators && !*hierarchical_search);
  if (*hierarchical_search)
    *offset += 5;
  p_edge = 0.0;
  rejected_edges = NULL;
  accepted_edges = NULL;
  eligible_edges = NULL;
  if (*hierarchical_search)
    forward_return_terms(local_delta, g_c_current, &eligible_edges);
  else {
    FORLIM = last_vertex;
    for (v = first_vertex; v < FORLIM; v++) {
      FORLIM1 = last_vertex;
      for (w = v + 1; w <= FORLIM1; w++) {
	P_addset(P_expset(a, 0L), v);
	P_addset(a, w);
	if (P_subset(a, local_delta) & (!subset_of_an_edge(a, g_c_current)) &
	    (!P_inset(w, fix_edges_adj_set[v - MIN_VERTEX])))
	  insert_set_in_set_list(a, &eligible_edges);
      }
    }
  }
  start_clock = my_clock()/1;
  do {
    if (*hierarchical_search)
      *graphical_model = g_c_conformal(g_c_current);
    else
      *graphical_model = true;
    if (*graphical_model)
      decomposable_model = g_c_decomposable(g_c_current);
    else
      decomposable_model = false;
    if (ic && !exact_test)
      headlong_select_limit = 0 + alfa_reject;
    else
      headlong_select_limit = alfa_reject;
    headlong_p_value = headlong_select_limit + ROUND_ERROR;
    if (*headlong)
      shuffle_edges(&eligible_edges);
    link_sort_list = NULL;
    p_edge_list = eligible_edges;
    while ((!interrupt_2 && p_edge_list != NULL) &
	   (!((*headlong && headlong_p_value < headlong_select_limit) &
	      (!is_invalid_real(headlong_p_value))))) {
      link_last_test = NULL;
      forward_try_one_edge(g_c_current, &decomposable_model, graphical_model,
	&link_sort_list, &link_last_test, p_edge_list->vertex_set,
	local_delta, offset, just, reversed, sorted_list, short_report,
	recursive, separators, hierarchical_search, short_test_output,
	write_models, partitioning);
      report_last_test(true, &link_last_test, &p_edge_list, &headlong_p_value,
		       &headlong_select_limit, &start_clock, short_report,
		       alternative, headlong, short_test_output,
		       write_models);
      p_edge_list = p_edge_list->pointer;
    }
    if (timer && !*short_report && !*just)
      write_used_time(stdout, start_clock);
    select_and_update(link_sort_list, &selected_test, &rejected_edges,
		      &accepted_edges, edge, &p_edge, *coherent, *follow,
		      true);
    if (*sorted_list) {
      if (link_sort_list != NULL)
	write_sorted_list(link_sort_list, short_test_output, write_models);
      dispose_sort_list(&link_sort_list);
    } else
      dispose_sort_list(&link_sort_list);
    if (p_edge < alfa_reject && !P_setequal(edge, empty_set) &&
	rejected_edges != NULL) {
      forward_update_model(g_c_current, graphical_model, edge, local_delta,
			   &rejected_edges, alternative, hierarchical_search);
      if (*hierarchical_search)
	forward_return_terms(local_delta, g_c_current, &eligible_edges);
      forward_update_edges(&rejected_edges, &accepted_edges, &eligible_edges,
			   edge, alternative);
      report_stepwise(g_c_current, &rejected_edges, &accepted_edges,
		      &eligible_edges, edge, &selected_test->test, true,
		      offset, just, sorted_list, short_report, alternative,
		      headlong, coherent, short_test_output, write_models);
    }
  } while (!(!*recursive || p_edge > alfa_reject ||
	     P_setequal(edge, empty_set) || rejected_edges == NULL ||
	     eligible_edges == NULL || interrupt_2));
  dispose_set_list(&rejected_edges);
  dispose_set_list(&accepted_edges);
  dispose_set_list(&eligible_edges);
}  /* forward_many_steps */


Static Void forward_selection(link_curr, just, reversed, sorted_list,
  short_report, alternative, headlong, recursive, coherent, follow,
  separators, hierarchical_search, short_test_output, write_models,
  partitioning)
t_model_list **link_curr;
boolean *just, *reversed, *sorted_list, *short_report, *alternative,
	*headlong, *recursive, *coherent, *follow, *separators,
	*hierarchical_search, *short_test_output, *write_models,
	*partitioning;
{
  boolean graphical_model;
  t_vertex_set local_delta;
  t_long_integer offset;
  t_set_list *g_c_current;

  P_setcpy(local_delta, (*link_curr)->model.model_set);
  g_c_current = (*link_curr)->model.sets_h_g_c;
  if (*short_report)
    sorted = false;
  if (*short_report)
    *reversed = false;
  offset = 0;
  if (*separators && *write_models)
    offset = 11;
  graphical_model = g_c_conformal(&g_c_current);
  *hierarchical_search = (*hierarchical_search || !graphical_model);
  if (*recursive || *hierarchical_search)
    forward_many_steps(&g_c_current, local_delta, &offset, &graphical_model,
		       just, reversed, sorted_list, short_report, alternative,
		       headlong, recursive, coherent, follow, separators,
		       hierarchical_search, short_test_output, write_models,
		       partitioning);
  else
    forward_one_step(&g_c_current, local_delta, &offset, &graphical_model,
		     just, reversed, sorted_list, short_report, recursive,
		     coherent, separators, hierarchical_search,
		     short_test_output, write_models, partitioning);
  if (interrupt_2) {
    interrupt_1 = false;
    interrupt_2 = false;
  }
}  /* forward_selection */


Static Void proc_forward(code)
long *code;
{
  boolean tmp_re_use, ok, try_interactions;
  t_test_list *p;
  t_long_integer offset;
  t_model_list *link_model;
  boolean local_short_test_output, local_write_models;

  local_short_test_output = true;
  local_write_models = !short_test_output;
  if (!current_and_base())
    return;
  ok = true;
  if (!ok)
    return;
  link_model = link_current;
  if (!link_model->model.found_expression)
    identify_model(&link_model->model);
  if (!link_model->model.graphical && *code == 1) {
    new_model(&link_model_list, &first_model_available);
    generate_graphical_model(&link_model_list->model, &link_model->model);
    link_model = link_model_list;
    identify_model(&link_model->model);
  }
  try_interactions = (*code == 2 ||
		      (*code == 3 && !link_model->model.graphical &&
		       !incomplete_table));
  separators = (separators && !try_interactions);
  if (separators && local_write_models)
    offset = 11;
  else
    offset = 0;
  if (try_interactions)
    offset += 5;
  write_test_head_stepwise(stdout, "Adding    ", offset,
			   local_short_test_output, local_write_models,
			   short_report, just);
  if (!re_use_test && (direct || sorted_list)) {
    p = link_test_list;
    link_test_list = NULL;
    re_use_test = true;
    tmp_re_use = true;
  } else
    tmp_re_use = false;
  just = (just || short_report);
  forward_selection(&link_model, &just, &reversed, &sorted_list,
		    &short_report, &alternative, &brute, &direct, &coherent,
		    &follow, &separators, &try_interactions,
		    &local_short_test_output, &local_write_models,
		    &c_partitioning);
  if (tmp_re_use) {
    dispose_tests();
    link_test_list = p;
    re_use_test = false;
  }
  separators = false;
  just = false;
  reversed = false;
  sorted_list = false;
  short_report = false;
  alternative = false;
  follow = false;
  coherent = false;
  direct = false;
  brute = false;
  note_command_end_pch(stdout, " Test computed", 14L);
}  /* proc_forward */


/*@-"eh.c"*/
/*@+"ehinsert.p"*/


Static Void add_set_list_maximal(p, out_g_c)
t_set_list *p, **out_g_c;
{
  while (p != NULL) {
    insert_clique(p->vertex_set, out_g_c);
    p = p->pointer;
  }
}  /* add_set_list_maximal */


Static boolean empty_g_c(g_c)
t_set_list **g_c;
{
  if (*g_c == NULL)
    return true;
  else if ((*g_c)->pointer == NULL &&
	   P_setequal((*g_c)->vertex_set, empty_set))
    return true;
  else
    return false;
}  /* empty_g_c */


Static Void first_order_to_graph_sets(p_g_c, adj_set)
t_set_list *p_g_c;
t_vertex_set *adj_set;
{
  t_vertex v1, v2;
  t_vertex_set a, b;
  t_vertex FORLIM, FORLIM1;

  FORLIM = last_vertex;
  for (v1 = first_vertex; v1 <= FORLIM; v1++)
    P_setcpy(adj_set[v1 - MIN_VERTEX], empty_set);
  while (p_g_c != NULL) {
    P_setcpy(a, p_g_c->vertex_set);
    if (cardinality(a) == 2) {
      FORLIM = last_vertex;
      for (v1 = first_vertex; v1 < FORLIM; v1++) {
	FORLIM1 = last_vertex;
	for (v2 = v1 + 1; v2 <= FORLIM1; v2++) {
	  P_addset(P_expset(b, 0L), v1);
	  P_addset(b, v2);
	  if (P_subset(b, a)) {
	    P_addset(adj_set[v1 - MIN_VERTEX], v2);
	    P_addset(adj_set[v2 - MIN_VERTEX], v1);
	  }
	}
      }
    }
    p_g_c = p_g_c->pointer;
  }
}  /* first_order_to_graph_sets */


Static boolean test_sub_g_c_dual(link_1, link_2)
t_set_list *link_1, *link_2;
{
  t_set_list *p;
  boolean ok;
  t_vertex_set a;

  ok = true;
  while (link_2 != NULL && ok) {
    P_setcpy(a, link_2->vertex_set);
    ok = false;
    p = link_1;
    while (p != NULL && !ok) {
      if (P_subset(p->vertex_set, a))
	ok = true;
      else
	p = p->pointer;
    }
    link_2 = link_2->pointer;
  }
  return ok;
}  /* test_sub_g_c_dual */


Static Void insert_maximal_dual(g_c, list_of_models)
t_set_list **g_c;
t_g_c_list **list_of_models;
{
  t_g_c_list *p, *q;
  boolean b;

  b = true;
  p = *list_of_models;
  while (p != NULL && b) {
    if (test_sub_g_c_dual(*g_c, p->g_c))
      b = false;
    else
      p = p->pointer;
  }
  if (!b) {
    dispose_set_list(g_c);
    return;
  }
  p = *list_of_models;
  insert_g_c_in_g_c_list(*g_c, list_of_models);
  q = *list_of_models;
  while (p != NULL) {
    if (test_sub_g_c_dual(p->g_c, *g_c)) {
      q->pointer = p->pointer;
      dispose_set_list(&p->g_c);
      Free(p);
      p = q->pointer;
    } else {
      q = p;
      p = p->pointer;
    }
  }
}  /* insert_maximal_dual */


Static Void insert_maximal(g_c, list_of_models)
t_set_list **g_c;
t_g_c_list **list_of_models;
{
  t_g_c_list *p, *q;
  boolean b;

  b = true;
  p = *list_of_models;
  while (p != NULL && b) {
    if (test_sub_g_c(*g_c, p->g_c))
      b = false;
    else
      p = p->pointer;
  }
  if (!b) {
    dispose_set_list(g_c);
    return;
  }
  p = *list_of_models;
  insert_g_c_in_g_c_list(*g_c, list_of_models);
  q = *list_of_models;
  while (p != NULL) {
    if (test_sub_g_c(p->g_c, *g_c)) {
      q->pointer = p->pointer;
      dispose_set_list(&p->g_c);
      Free(p);
      p = q->pointer;
    } else {
      q = p;
      p = p->pointer;
    }
  }
}  /* insert_maximal */


Static Void insert_minimal(g_c, list_of_models)
t_set_list **g_c;
t_g_c_list **list_of_models;
{
  t_g_c_list *p, *q;
  boolean b;

  b = true;
  p = *list_of_models;
  while (p != NULL && b) {
    if (test_sub_g_c(p->g_c, *g_c))
      b = false;
    else
      p = p->pointer;
  }
  if (!b) {
    dispose_set_list(g_c);
    return;
  }
  p = *list_of_models;
  insert_g_c_in_g_c_list(*g_c, list_of_models);
  q = *list_of_models;
  while (p != NULL) {
    if (test_sub_g_c(*g_c, p->g_c)) {
      q->pointer = p->pointer;
      dispose_set_list(&p->g_c);
      Free(p);
      p = q->pointer;
    } else {
      q = p;
      p = p->pointer;
    }
  }
}  /* insert_minimal */


/*@+"plus.p"*/


Static Void plus_to_normal(edge_list, g, g_c)
t_edge_list *edge_list;
long *g;
t_set_list **g_c;
{
  t_v_arr_of_v_sets adj_set;
  t_vertex v, FORLIM;

  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++)
    P_setcpy(adj_set[v - MIN_VERTEX], empty_set);
  while (edge_list != NULL) {
    P_addset(adj_set[edge_list->v - MIN_VERTEX], edge_list->w);
    P_addset(adj_set[edge_list->w - MIN_VERTEX], edge_list->v);
    edge_list = edge_list->pointer;
  }
  find_cliques(adj_set, g, g_c);
}  /* plus_to_normal */


Static Void normal_to_plus(g_c, g, edge_list)
t_set_list **g_c;
long *g;
t_edge_list **edge_list;
{
  t_v_arr_of_v_sets adj_set;
  t_vertex_set a;
  t_vertex v, w, FORLIM, FORLIM1;

  hypergraph_sets_to_graph_sets(*g_c, a, adj_set);
  *edge_list = NULL;
  FORLIM = last_vertex;
  for (v = first_vertex; v < FORLIM; v++) {
    if (P_inset(v, g)) {
      FORLIM1 = last_vertex;
      for (w = v + 1; w <= FORLIM1; w++) {
	if (P_inset(w, g) & P_inset(w, adj_set[v - MIN_VERTEX]))
	  insert_edge_in_edge_list(v, w, edge_list);
      }
    }
  }
}  /* normal_to_plus */


Static Void minus_to_normal(edge_list, g, g_c)
t_edge_list *edge_list;
long *g;
t_set_list **g_c;
{
  t_v_arr_of_v_sets adj_set;
  t_vertex v, FORLIM;

  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    if (P_inset(v, g))
      P_setcpy(adj_set[v - MIN_VERTEX], g);
    else
      P_setcpy(adj_set[v - MIN_VERTEX], empty_set);
  }
  while (edge_list != NULL) {
    P_remset(adj_set[edge_list->v - MIN_VERTEX], edge_list->w);
    P_remset(adj_set[edge_list->w - MIN_VERTEX], edge_list->v);
    edge_list = edge_list->pointer;
  }
  find_cliques(adj_set, g, g_c);
}  /* minus_to_normal */


Static Void normal_to_minus(g_c, g, edge_list)
t_set_list **g_c;
long *g;
t_edge_list **edge_list;
{
  t_v_arr_of_v_sets adj_set;
  t_vertex_set a;
  t_vertex v, w, FORLIM, FORLIM1;

  hypergraph_sets_to_graph_sets(*g_c, a, adj_set);
  *edge_list = NULL;
  FORLIM = last_vertex;
  for (v = first_vertex; v < FORLIM; v++) {
    if (P_inset(v, g)) {
      FORLIM1 = last_vertex;
      for (w = v + 1; w <= FORLIM1; w++) {
	if (P_inset(w, g) & (!P_inset(w, adj_set[v - MIN_VERTEX])))
	  insert_edge_in_edge_list(v, w, edge_list);
      }
    }
  }
}  /* normal_to_minus */


/*@+"updateg.p"*/


Static Void update_d_r_graphical(m, g, d_r)
t_set_list **m;
long *g;
t_g_c_list **d_r;
{
  t_edge_list *p, *m_edge_list, *edge_list, *edge_list_insert;
  t_g_c_list *p_1, *p_0;
  t_set_list *g_c_insert;

  normal_to_plus(m, g, &m_edge_list);
  edge_list_insert = (t_edge_list *)Malloc(sizeof(t_edge_list));
  if (edge_list_insert == NULL)
    _OutMem();
  p_1 = *d_r;
  *d_r = NULL;
  if (p_1 != NULL) {
    while (p_1 != NULL) {
      normal_to_minus(&p_1->g_c, g, &edge_list);
      edge_list_insert->pointer = edge_list;
      p = m_edge_list;
      while (p != NULL) {
	edge_list_insert->v = p->v;
	edge_list_insert->w = p->w;
	minus_to_normal(edge_list_insert, g, &g_c_insert);
	insert_maximal(&g_c_insert, d_r);
	p = p->pointer;
      }
      dispose_edge_list(&edge_list);
      p_0 = p_1;
      p_1 = p_1->pointer;
      dispose_set_list(&p_0->g_c);
      Free(p_0);
    }
  } else {
    edge_list_insert->pointer = NULL;
    p = m_edge_list;
    while (p != NULL) {
      edge_list_insert->v = p->v;
      edge_list_insert->w = p->w;
      minus_to_normal(edge_list_insert, g, &g_c_insert);
      insert_maximal(&g_c_insert, d_r);
      p = p->pointer;
    }
  }
  dispose_edge_list(&m_edge_list);
  Free(edge_list_insert);
}  /* update_d_r_graphical */


Static Void update_d_a_graphical(m, g, d_a)
t_set_list **m;
long *g;
t_g_c_list **d_a;
{
  t_edge_list *p, *m_edge_list, *edge_list, *edge_list_insert;
  t_g_c_list *p_1, *p_0;
  t_set_list *g_c_insert;

  normal_to_minus(m, g, &m_edge_list);
  edge_list_insert = (t_edge_list *)Malloc(sizeof(t_edge_list));
  if (edge_list_insert == NULL)
    _OutMem();
  p_1 = *d_a;
  *d_a = NULL;
  if (p_1 != NULL) {
    while (p_1 != NULL) {
      normal_to_plus(&p_1->g_c, g, &edge_list);
      edge_list_insert->pointer = edge_list;
      p = m_edge_list;
      while (p != NULL) {
	edge_list_insert->v = p->v;
	edge_list_insert->w = p->w;
	plus_to_normal(edge_list_insert, g, &g_c_insert);
	insert_minimal(&g_c_insert, d_a);
	p = p->pointer;
      }
      dispose_edge_list(&edge_list);
      p_0 = p_1;
      p_1 = p_1->pointer;
      dispose_set_list(&p_0->g_c);
      Free(p_0);
    }
  } else {
    edge_list_insert->pointer = NULL;
    p = m_edge_list;
    while (p != NULL) {
      edge_list_insert->v = p->v;
      edge_list_insert->w = p->w;
      plus_to_normal(edge_list_insert, g, &g_c_insert);
      insert_minimal(&g_c_insert, d_a);
      p = p->pointer;
    }
  }
  dispose_edge_list(&m_edge_list);
  Free(edge_list_insert);
}  /* update_d_a_graphical */


/*@+"updateh.p"*/


Static Void update_d_r_hierarchical(m, g, d_r)
t_set_list **m;
long *g;
t_g_c_list **d_r;
{
  t_g_c_list *p_0, *p_1;
  t_set_list *g_c_insert, *p, *model_d, *model_d_insert;

  p_1 = NULL;
  if (*d_r != NULL) {
    while (*d_r != NULL) {
      normal_to_dual((*d_r)->g_c, g, &model_d);
      p = *m;
      while (p != NULL) {
	if (cardinality(p->vertex_set) == 1) {
	  p = p->pointer;
	  continue;
	}
	copy_set_list(model_d, &model_d_insert);
	insert_set_minimal(p->vertex_set, &model_d_insert);
	dual_to_normal(model_d_insert, g, &g_c_insert);
	dispose_set_list(&model_d_insert);
	insert_maximal(&g_c_insert, &p_1);
	p = p->pointer;
      }
      dispose_set_list(&model_d);
      p_0 = *d_r;
      *d_r = (*d_r)->pointer;
      dispose_set_list(&p_0->g_c);
      Free(p_0);
    }
  } else {
    p = *m;
    while (p != NULL) {
      if (cardinality(p->vertex_set) == 1) {
	p = p->pointer;
	continue;
      }
      model_d_insert = (t_set_list *)Malloc(sizeof(t_set_list));
      if (model_d_insert == NULL)
	_OutMem();
      model_d_insert->pointer = NULL;
      P_setcpy(model_d_insert->vertex_set, p->vertex_set);
      dual_to_normal(model_d_insert, g, &g_c_insert);
      Free(model_d_insert);
      insert_maximal(&g_c_insert, &p_1);
      p = p->pointer;
    }
  }
  *d_r = p_1;
}  /* update_d_r_hierarchical */


Static Void update_d_a_hierarchical(m, g, d_a)
t_set_list **m;
long *g;
t_g_c_list **d_a;
{
  t_g_c_list *p_0, *p_1;
  t_set_list *m_dual, *p, *g_c_insert;
  t_vertex v;
  t_vertex_set vertex_set;
  t_vertex FORLIM;

  normal_to_dual(*m, g, &m_dual);
  p_1 = NULL;
  if (*d_a != NULL) {
    while (*d_a != NULL) {
      p = m_dual;
      while (p != NULL) {
	copy_set_list((*d_a)->g_c, &g_c_insert);
	insert_clique(p->vertex_set, &g_c_insert);
	insert_minimal(&g_c_insert, &p_1);
	p = p->pointer;
      }
      p_0 = *d_a;
      *d_a = (*d_a)->pointer;
      dispose_set_list(&p_0->g_c);
      Free(p_0);
    }
  } else {
    p = m_dual;
    while (p != NULL) {
      g_c_insert = (t_set_list *)Malloc(sizeof(t_set_list));
      if (g_c_insert == NULL)
	_OutMem();
      g_c_insert->pointer = NULL;
      P_setcpy(g_c_insert->vertex_set, p->vertex_set);
      FORLIM = last_vertex;
      for (v = first_vertex; v <= FORLIM; v++) {
	if (P_inset(v, g)) {
	  P_addset(P_expset(vertex_set, 0L), v);
	  insert_clique(vertex_set, &g_c_insert);
	}
      }
      insert_minimal(&g_c_insert, &p_1);
      p = p->pointer;
    }
  }
  dispose_set_list(&m_dual);
  *d_a = p_1;
}  /* update_d_a_hierarchical */


/*@+"findg.p"*/


Static Void dispose_adj_set_list(p)
t_adj_set_list **p;
{
  t_adj_set_list *q;

  while (*p != NULL) {
    q = (*p)->pointer;
    Free(*p);
    *p = q;
  }
}  /* dispose_adj_set_list */


Static boolean test_sub_adj_set(adj_set_1, adj_set_2)
t_vertex_set *adj_set_1, *adj_set_2;
{
  boolean ok;
  t_vertex v;

  ok = true;
  v = first_vertex;
  while (ok && v < last_vertex) {
    ok = P_subset(adj_set_1[v - MIN_VERTEX], adj_set_2[v - MIN_VERTEX]);
    v++;
  }
  if (ok)
    ok = P_subset(adj_set_1[last_vertex - MIN_VERTEX],
		  adj_set_2[last_vertex - MIN_VERTEX]);
  return ok;
}  /* test_sub_adj_set */


Static Void insert_minimal_adj_set(adj_set, list_of_models)
t_vertex_set *adj_set;
t_adj_set_list **list_of_models;
{
  t_adj_set_list *p, *q;
  boolean b;
  t_vertex v, FORLIM;

  b = true;
  p = *list_of_models;
  while (p != NULL && b) {
    if (test_sub_adj_set(p->adj_set, adj_set))
      b = false;
    else
      p = p->pointer;
  }
  if (!b)
    return;
  p = *list_of_models;
  *list_of_models = (t_adj_set_list *)Malloc(sizeof(t_adj_set_list));
  if (*list_of_models == NULL)
    _OutMem();
  q = *list_of_models;
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++)
    P_setcpy(q->adj_set[v - MIN_VERTEX], adj_set[v - MIN_VERTEX]);
  q->pointer = p;
  while (p != NULL) {
    if (test_sub_adj_set(adj_set, p->adj_set)) {
      q->pointer = p->pointer;
      Free(p);
      p = q->pointer;
    } else {
      q = p;
      p = p->pointer;
    }
  }
}  /* insert_minimal_adj_set */


Static Void exclude_edges_in_adj_set(edge_list, adj_set)
t_edge_list **edge_list;
t_vertex_set *adj_set;
{
  boolean cont;
  t_edge_list *p, *q;

  cont = true;
  while (*edge_list != NULL && cont) {
    if (!P_inset((*edge_list)->v, adj_set[(*edge_list)->w - MIN_VERTEX])) {
      cont = false;
      break;
    }
    p = *edge_list;
    *edge_list = (*edge_list)->pointer;
    Free(p);
  }
  if (*edge_list == NULL)
    return;
  p = *edge_list;
  q = (*edge_list)->pointer;
  while (q != NULL) {
    if (P_inset(q->v, adj_set[q->w - MIN_VERTEX])) {
      p->pointer = q->pointer;
      Free(q);
      q = p->pointer;
    } else {
      p = q;
      q = p->pointer;
    }
  }
}  /* exclude_edges_in_adj_set */


Static Void find_d_r_graphical(s, g, d_r)
t_g_c_list **s;
long *g;
t_g_c_list **d_r;
{
  t_adj_set_list *q, *d_r_minus, *d_r_minus_x;
  t_g_c_list *p, *r;
  t_vertex v;
  t_edge_list *el, *edge_list;
  t_v_arr_of_v_sets tmp_model;
  boolean not_there;
  t_vertex FORLIM;

  d_r_minus = NULL;
  if (*s != NULL) {
    p = *s;
    if (link_eh_pack->fix_out) {
      d_r_minus = (t_adj_set_list *)Malloc(sizeof(t_adj_set_list));
      if (d_r_minus == NULL)
	_OutMem();
      d_r_minus->pointer = NULL;
      FORLIM = last_vertex;
      for (v = first_vertex; v <= FORLIM; v++)
	P_setcpy(d_r_minus->adj_set[v - MIN_VERTEX],
		 link_eh_pack->fix_out_adj_set[v - MIN_VERTEX]);
    } else {
      normal_to_plus(&p->g_c, g, &edge_list);
      if (link_eh_pack->fix_in)
	exclude_edges_in_adj_set(&edge_list, link_eh_pack->fix_in_adj_set);
      el = edge_list;
      while (el != NULL) {
	q = (t_adj_set_list *)Malloc(sizeof(t_adj_set_list));
	if (q == NULL)
	  _OutMem();
	FORLIM = last_vertex;
	for (v = first_vertex; v <= FORLIM; v++)
	  P_setcpy(q->adj_set[v - MIN_VERTEX], empty_set);
	P_addset(P_expset(q->adj_set[el->w - MIN_VERTEX], 0L), el->v);
	P_addset(P_expset(q->adj_set[el->v - MIN_VERTEX], 0L), el->w);
	q->pointer = d_r_minus;
	d_r_minus = q;
	el = el->pointer;
      }
      dispose_edge_list(&edge_list);
      p = p->pointer;
    }
    while (p != NULL && !interrupt_2) {
      d_r_minus_x = NULL;
      normal_to_plus(&p->g_c, g, &edge_list);
      if (link_eh_pack->fix_in)
	exclude_edges_in_adj_set(&edge_list, link_eh_pack->fix_in_adj_set);
      while (d_r_minus != NULL && !interrupt_3) {
	el = edge_list;
	not_there = true;
	while (el != NULL) {
	  if (!P_inset(el->v, d_r_minus->adj_set[el->w - MIN_VERTEX])) {
	    FORLIM = last_vertex;
	    for (v = first_vertex; v <= FORLIM; v++)
	      P_setcpy(tmp_model[v - MIN_VERTEX],
		       d_r_minus->adj_set[v - MIN_VERTEX]);
	    P_addset(tmp_model[el->w - MIN_VERTEX], el->v);
	    P_addset(tmp_model[el->v - MIN_VERTEX], el->w);
	    insert_minimal_adj_set(tmp_model, &d_r_minus_x);
	  } else if (not_there) {
	    not_there = false;
	    insert_minimal_adj_set(d_r_minus->adj_set, &d_r_minus_x);
	  }
	  el = el->pointer;
	}
	q = d_r_minus;
	d_r_minus = d_r_minus->pointer;
	Free(q);
      }
      if (interrupt_3)
	dispose_adj_set_list(&d_r_minus_x);
      dispose_edge_list(&edge_list);
      d_r_minus = d_r_minus_x;
      p = p->pointer;
    }
  }
  *d_r = NULL;
  while (d_r_minus != NULL) {
    r = (t_g_c_list *)Malloc(sizeof(t_g_c_list));
    if (r == NULL)
      _OutMem();
    r->pointer = *d_r;
    *d_r = r;
    FORLIM = last_vertex;
    for (v = first_vertex; v <= FORLIM; v++)
      P_setdiff(d_r_minus->adj_set[v - MIN_VERTEX], g,
		d_r_minus->adj_set[v - MIN_VERTEX]);
    find_cliques(d_r_minus->adj_set, g, &(*d_r)->g_c);
    q = d_r_minus;
    d_r_minus = d_r_minus->pointer;
    Free(q);
  }
}  /* find_d_r_graphical */


Static Void find_d_a_graphical(s, g, d_a)
t_g_c_list **s;
long *g;
t_g_c_list **d_a;
{
  t_adj_set_list *q, *d_a_plus, *d_a_plus_x;
  t_g_c_list *p, *r;
  t_vertex v;
  boolean not_there;
  t_edge_list *el, *edge_list;
  t_v_arr_of_v_sets tmp_model;
  t_vertex FORLIM;

  d_a_plus = NULL;
  p = *s;
  if (link_eh_pack->fix_in) {
    d_a_plus = (t_adj_set_list *)Malloc(sizeof(t_adj_set_list));
    if (d_a_plus == NULL)
      _OutMem();
    d_a_plus->pointer = NULL;
    FORLIM = last_vertex;
    for (v = first_vertex; v <= FORLIM; v++)
      P_setcpy(d_a_plus->adj_set[v - MIN_VERTEX],
	       link_eh_pack->fix_in_adj_set[v - MIN_VERTEX]);
  } else {
    normal_to_minus(&p->g_c, g, &edge_list);
    if (link_eh_pack->fix_out)
      exclude_edges_in_adj_set(&edge_list, link_eh_pack->fix_out_adj_set);
    el = edge_list;
    while (el != NULL) {
      q = (t_adj_set_list *)Malloc(sizeof(t_adj_set_list));
      if (q == NULL)
	_OutMem();
      FORLIM = last_vertex;
      for (v = first_vertex; v <= FORLIM; v++)
	P_setcpy(q->adj_set[v - MIN_VERTEX], empty_set);
      P_addset(P_expset(q->adj_set[el->w - MIN_VERTEX], 0L), el->v);
      P_addset(P_expset(q->adj_set[el->v - MIN_VERTEX], 0L), el->w);
      q->pointer = d_a_plus;
      d_a_plus = q;
      el = el->pointer;
    }
    dispose_edge_list(&edge_list);
    p = p->pointer;
  }
  while (p != NULL && !interrupt_2) {
    d_a_plus_x = NULL;
    normal_to_minus(&p->g_c, g, &edge_list);
    if (link_eh_pack->fix_out)
      exclude_edges_in_adj_set(&edge_list, link_eh_pack->fix_out_adj_set);
    while (d_a_plus != NULL && !interrupt_3) {
      el = edge_list;
      not_there = true;
      while (el != NULL) {
	if (!P_inset(el->v, d_a_plus->adj_set[el->w - MIN_VERTEX])) {
	  FORLIM = last_vertex;
	  for (v = first_vertex; v <= FORLIM; v++)
	    P_setcpy(tmp_model[v - MIN_VERTEX],
		     d_a_plus->adj_set[v - MIN_VERTEX]);
	  P_addset(tmp_model[el->w - MIN_VERTEX], el->v);
	  P_addset(tmp_model[el->v - MIN_VERTEX], el->w);
	  insert_minimal_adj_set(tmp_model, &d_a_plus_x);
	} else if (not_there) {
	  not_there = false;
	  insert_minimal_adj_set(d_a_plus->adj_set, &d_a_plus_x);
	}
	el = el->pointer;
      }
      q = d_a_plus;
      d_a_plus = d_a_plus->pointer;
      Free(q);
    }
    if (interrupt_3)
      dispose_adj_set_list(&d_a_plus_x);
    dispose_edge_list(&edge_list);
    d_a_plus = d_a_plus_x;
    p = p->pointer;
  }
  *d_a = NULL;
  while (d_a_plus != NULL) {
    r = (t_g_c_list *)Malloc(sizeof(t_g_c_list));
    if (r == NULL)
      _OutMem();
    r->pointer = *d_a;
    *d_a = r;
    find_cliques(d_a_plus->adj_set, g, &(*d_a)->g_c);
    q = d_a_plus;
    d_a_plus = d_a_plus->pointer;
    Free(q);
  }
}  /* find_d_a_graphical */


/*@+"findh.p"*/


Static Void find_d_r_hierarchical(s, g, d_r)
t_g_c_list **s;
long *g;
t_g_c_list **d_r;
{
  t_g_c_list *p, *q, *d_r_dual, *d_r_dual_x;
  t_set_list *g_c_0, *g_c, *g_c_x;
  boolean not_there;
  _PROCEDURE TEMP;

  d_r_dual = NULL;
  if (*s != NULL) {
    p = *s;
    if (link_eh_pack->fix_out) {
      d_r_dual = (t_g_c_list *)Malloc(sizeof(t_g_c_list));
      if (d_r_dual == NULL)
	_OutMem();
      d_r_dual->pointer = NULL;
      copy_set_list(link_eh_pack->fix_out_gc, &d_r_dual->g_c);
    } else {
      if (link_eh_pack->fix_in) {
	copy_set_list(p->g_c, &g_c_0);

	TEMP.proc = (Anyptr)subset_of_an_edge;
	TEMP.link = (Anyptr)NULL;

	/*$ifdef On-DOS
	exclude_sub_vertex_sets_in_list(g_c_0, link_eh_pack^.fix_in_gc)
	 $endif On-DOS*/
	exclude_vertex_sets_in_list(&g_c_0, TEMP, &link_eh_pack->fix_in_gc);
      } else
	g_c_0 = p->g_c;
      g_c = g_c_0;
      while (g_c != NULL) {
	if (cardinality(g_c->vertex_set) > 1) {
	  q = (t_g_c_list *)Malloc(sizeof(t_g_c_list));
	  if (q == NULL)
	    _OutMem();
	  q->g_c = (t_set_list *)Malloc(sizeof(t_set_list));
	  if (q->g_c == NULL)
	    _OutMem();
	  P_setcpy(q->g_c->vertex_set, g_c->vertex_set);
	  q->g_c->pointer = NULL;
	  q->pointer = d_r_dual;
	  d_r_dual = q;
	}
	g_c = g_c->pointer;
      }
      if (link_eh_pack->fix_in)
	dispose_set_list(&g_c_0);
      p = p->pointer;
    }
    while (p != NULL && !interrupt_2) {
      d_r_dual_x = NULL;
      if (link_eh_pack->fix_in) {
	copy_set_list(p->g_c, &g_c_0);

	TEMP.proc = (Anyptr)subset_of_an_edge;
	TEMP.link = (Anyptr)NULL;

	/*$ifdef On-DOS
	exclude_sub_vertex_sets_in_list(g_c_0, link_eh_pack^.fix_in_gc)
	 $endif On-DOS*/
	exclude_vertex_sets_in_list(&g_c_0, TEMP, &link_eh_pack->fix_in_gc);
      } else
	g_c_0 = p->g_c;
      while (d_r_dual != NULL && !interrupt_3) {
	g_c = g_c_0;
	not_there = true;
	while (g_c != NULL) {
	  if (cardinality(g_c->vertex_set) > 1) {
	    if (!contains_an_edge(g_c->vertex_set, &d_r_dual->g_c)) {
	      copy_set_list(d_r_dual->g_c, &g_c_x);
	      insert_set_minimal(g_c->vertex_set, &g_c_x);
	      insert_maximal_dual(&g_c_x, &d_r_dual_x);
	    } else if (not_there) {
	      not_there = false;
	      copy_set_list(d_r_dual->g_c, &g_c_x);
	      insert_maximal_dual(&g_c_x, &d_r_dual_x);
	    }
	  }
	  g_c = g_c->pointer;
	}
	dispose_set_list(&d_r_dual->g_c);
	q = d_r_dual;
	d_r_dual = d_r_dual->pointer;
	Free(q);
      }
      if (interrupt_3)
	dispose_g_c_list(&d_r_dual_x);
      if (link_eh_pack->fix_in)
	dispose_set_list(&g_c_0);
      d_r_dual = d_r_dual_x;
      p = p->pointer;
    }
  }
  *d_r = NULL;
  while (d_r_dual != NULL) {
    q = (t_g_c_list *)Malloc(sizeof(t_g_c_list));
    if (q == NULL)
      _OutMem();
    q->pointer = *d_r;
    *d_r = q;
    dual_to_normal(d_r_dual->g_c, g, &(*d_r)->g_c);
    dispose_set_list(&d_r_dual->g_c);
    q = d_r_dual;
    d_r_dual = d_r_dual->pointer;
    Free(q);
  }
}  /* find_d_r_hierarchical */


Static Void find_d_a_hierarchical(s, g, d_a)
t_g_c_list **s;
long *g;
t_g_c_list **d_a;
{
  t_g_c_list *p, *q, *d_a_x;
  t_set_list *dual_g_c, *g_c, *g_c_x;
  t_vertex v;
  t_vertex_set a, d;
  boolean not_there;
  _PROCEDURE TEMP;
  t_vertex FORLIM;

  *d_a = NULL;
  if (*s != NULL) {
    p = *s;
    if (link_eh_pack->fix_in) {
      *d_a = (t_g_c_list *)Malloc(sizeof(t_g_c_list));
      if (*d_a == NULL)
	_OutMem();
      (*d_a)->pointer = NULL;
      copy_set_list(link_eh_pack->fix_in_gc, &(*d_a)->g_c);
    } else {
      normal_to_dual(p->g_c, g, &dual_g_c);
      if (link_eh_pack->fix_out) {
	if (!empty_g_c(&link_eh_pack->fix_out_gc)) {
	  TEMP.proc = (Anyptr)contains_an_edge;
	  TEMP.link = (Anyptr)NULL;
	  exclude_vertex_sets_in_list(&dual_g_c, TEMP,
				      &link_eh_pack->fix_out_gc);
	}

      }

      /*$ifdef On-DOS
      exclude_super_vertex_sets_in_list(dual_g_c,
                                        link_eh_pack^.fix_out_gc);
       $endif On-DOS*/
      g_c = dual_g_c;
      while (g_c != NULL) {
	q = (t_g_c_list *)Malloc(sizeof(t_g_c_list));
	if (q == NULL)
	  _OutMem();
	q->g_c = (t_set_list *)Malloc(sizeof(t_set_list));
	if (q->g_c == NULL)
	  _OutMem();
	P_setcpy(q->g_c->vertex_set, g_c->vertex_set);
	q->g_c->pointer = NULL;
	q->pointer = *d_a;
	*d_a = q;
	g_c = g_c->pointer;
      }
      dispose_set_list(&dual_g_c);
      p = p->pointer;
    }
    while (p != NULL && !interrupt_2) {
      normal_to_dual(p->g_c, g, &dual_g_c);
      if (link_eh_pack->fix_out) {
	if (!empty_g_c(&link_eh_pack->fix_out_gc)) {
	  TEMP.proc = (Anyptr)contains_an_edge;
	  TEMP.link = (Anyptr)NULL;
	  exclude_vertex_sets_in_list(&dual_g_c, TEMP,
				      &link_eh_pack->fix_out_gc);
	}

      }

      /*$ifdef On-DOS
      exclude_super_vertex_sets_in_list(dual_g_c,
                                        link_eh_pack^.fix_out_gc);
       $endif On-DOS*/
      d_a_x = NULL;
      while (*d_a != NULL && !interrupt_3) {
	g_c = dual_g_c;
	not_there = true;
	while (g_c != NULL) {
	  if (!subset_of_an_edge(g_c->vertex_set, &(*d_a)->g_c)) {
	    copy_set_list((*d_a)->g_c, &g_c_x);
	    insert_clique(g_c->vertex_set, &g_c_x);
	    insert_minimal(&g_c_x, &d_a_x);
	  } else if (not_there) {
	    not_there = false;
	    copy_set_list((*d_a)->g_c, &g_c_x);
	    insert_minimal(&g_c_x, &d_a_x);
	  }
	  g_c = g_c->pointer;
	}
	dispose_set_list(&(*d_a)->g_c);
	q = *d_a;
	*d_a = (*d_a)->pointer;
	Free(q);
      }
      if (interrupt_3)
	dispose_g_c_list(&d_a_x);
      *d_a = d_a_x;
      dispose_set_list(&dual_g_c);
      p = p->pointer;
    }
  }
  q = *d_a;
  while (q != NULL) {
    g_c = q->g_c;
    P_setcpy(a, empty_set);
    while (g_c != NULL) {
      P_setunion(a, a, g_c->vertex_set);
      g_c = g_c->pointer;
    }
    P_setdiff(d, g, a);
    if (!P_setequal(d, empty_set)) {
      FORLIM = last_vertex;
      for (v = first_vertex; v <= FORLIM; v++) {
	if (P_inset(v, d)) {
	  g_c = (t_set_list *)Malloc(sizeof(t_set_list));
	  if (g_c == NULL)
	    _OutMem();
	  P_addset(P_expset(g_c->vertex_set, 0L), v);
	  g_c->pointer = q->g_c;
	  q->g_c = g_c;
	}
      }
    }
    q = q->pointer;
  }
}  /* find_d_a_hierarchical */


/*@+"ehsizes.p"*/


Static long class_size(q)
t_g_c_list *q;
{
  t_long_integer tmp_size;

  tmp_size = 0;
  while (q != NULL) {
    tmp_size++;
    q = q->pointer;
  }
  return tmp_size;
}  /* class_size */


Static long g_c_size(q)
t_set_list *q;
{
  t_long_integer tmp_size;

  tmp_size = 0;
  while (q != NULL) {
    tmp_size++;
    q = q->pointer;
  }
  return tmp_size;
}  /* g_c_size */


Static double log_a_dual(g, fit_gra, p)
long *g;
boolean *fit_gra;
t_g_c_list *p;
{
  t_long_integer dim, n_edges;
  t_long_real log_d_a_size;
  t_set_list *alt_rep;
  t_vertex v;
  t_v_arr_of_v_sets adj_set;
  t_vertex FORLIM;

  if (*fit_gra) {
    log_d_a_size = 0.0;
    dim = cardinality(g);
    while (p != NULL) {
      hypergraph_sets_to_graph_sets(p->g_c, g, adj_set);
      n_edges = 0;
      FORLIM = last_vertex;
      for (v = first_vertex; v <= FORLIM; v++)
	n_edges += dim - cardinality(adj_set[v - MIN_VERTEX]) - 1;
      if (n_edges != 0)
	log_d_a_size += log_10(n_edges / 2.0);
      p = p->pointer;
    }
    return log_d_a_size;
  }
  log_d_a_size = 0.0;
  while (p != NULL) {
    normal_to_dual(p->g_c, g, &alt_rep);
    n_edges = g_c_size(alt_rep);
    dispose_set_list(&alt_rep);
    if (n_edges != 0)
      log_d_a_size += log_10((double)n_edges);
    p = p->pointer;
  }
  return log_d_a_size;
}  /* log_a_dual */


Static double log_r_dual(g, fit_gra, p)
long *g;
boolean *fit_gra;
t_g_c_list *p;
{
  t_long_integer n_edges;
  t_long_real log_d_r_size;
  t_vertex v;
  t_v_arr_of_v_sets adj_set;
  t_vertex FORLIM;

  if (*fit_gra) {
    log_d_r_size = 0.0;
    while (p != NULL) {
      hypergraph_sets_to_graph_sets(p->g_c, g, adj_set);
      n_edges = 0;
      FORLIM = last_vertex;
      for (v = first_vertex; v <= FORLIM; v++)
	n_edges += cardinality(adj_set[v - MIN_VERTEX]);
      if (n_edges != 0)
	log_d_r_size += log_10(n_edges / 2.0);
      p = p->pointer;
    }
    return log_d_r_size;
  }
  log_d_r_size = 0.0;
  while (p != NULL) {
    n_edges = g_c_size(p->g_c);
    if (n_edges != 0)
      log_d_r_size += log_10((double)n_edges);
    p = p->pointer;
  }
  return log_d_r_size;
}  /* log_r_dual */


/*@+"find.p"*/


Static Void update_d_r(fit_gra, g_c, g, d_r)
boolean *fit_gra;
t_set_list **g_c;
long *g;
t_g_c_list **d_r;
{
  long TEMP;

  if (*fit_gra)
    update_d_r_graphical(g_c, g, d_r);
  else
    update_d_r_hierarchical(g_c, g, d_r);
  write_pch_20_text(report_file, " DualRej.:  ", 12L);
  TEMP = 7;
  write_integer_text(report_file, class_size(*d_r), &TEMP);
  write_space_text(report_file, 3L);
}  /* update_d_r */


Static Void update_d_a(fit_gra, g_c, g, d_a)
boolean *fit_gra;
t_set_list **g_c;
long *g;
t_g_c_list **d_a;
{
  long TEMP;

  if (*fit_gra)
    update_d_a_graphical(g_c, g, d_a);
  else
    update_d_a_hierarchical(g_c, g, d_a);
  write_pch_20_text(report_file, " DualAcc.:  @@@@@@@ ", 12L);
  TEMP = 7;
  write_integer_text(report_file, class_size(*d_a), &TEMP);
  write_space_text(report_file, 3L);
}  /* update_d_a */


Static Void find_a_dual(g, fit_gra, p, d_a)
long *g;
boolean *fit_gra;
t_g_c_list *p, **d_a;
{
  t_long_real start_clock;
  double TEMP;
  long TEMP1;

  if (*fit_gra)
    write_pch_30_text(report_file, " -- Find A-Dual Graphical    ", 29L);
  else
    write_pch_30_text(report_file, " -- Find A-Dual Hierarchical ", 29L);
  write_line_text(report_file);
  start_clock = my_clock()/1;
  write_pch_20_text(report_file, " -- RoughADual:", 15L);
  TEMP = log_a_dual(g, fit_gra, p);
  write_real_text(report_file, &TEMP, 10L, 2L);
  write_pch_20_text(report_file, " RoughDualTime: ", 16L);
  write_time_text(report_file, "", 0L, (double)my_clock()/1, start_clock,
		  8L, 3L);
  write_line_text(report_file);
  fflush(report_file);
  P_ioresult = 0;
  dispose_g_c_list(d_a);
  if (link_eh_pack->search_opt == 3) {
    start_clock = my_clock()/1;
    if (*fit_gra)
      find_d_a_graphical(&p, g, d_a);
    else
      find_d_a_hierarchical(&p, g, d_a);
    write_pch_20_text(report_file, " -- DualAcc.:  ", 15L);
    TEMP1 = 7;
    write_integer_text(report_file, class_size(*d_a), &TEMP1);
    write_space_text(report_file, 3L);
    write_pch_20_text(report_file, " TimeFindDual:  ", 16L);
    write_time_text(report_file, "", 0L, (double)my_clock()/1,
		    start_clock, 8L, 3L);
    write_line_text(report_file);
  } else {
    while (p != NULL && !interrupt_2) {
      start_clock = my_clock()/1;
      write_pch_10_text(report_file, " //", 3L);
      update_d_a(fit_gra, &p->g_c, g, d_a);
      write_pch_20_text(report_file, " TimeUpDate: ", 13L);
      write_time_text(report_file, "", 0L, (double)my_clock()/1,
		      start_clock, 8L, 3L);
      write_line_text(report_file);
      fflush(report_file);
      P_ioresult = 0;
      p = p->pointer;
    }
  }
  fflush(report_file);
  P_ioresult = 0;
}  /* find_a_dual */


Static Void find_r_dual(g, fit_gra, p, d_r)
long *g;
boolean *fit_gra;
t_g_c_list *p, **d_r;
{
  t_long_real start_clock;
  double TEMP;
  long TEMP1;

  start_clock = my_clock()/1;
  if (*fit_gra)
    write_pch_30_text(report_file, " -- Find R-Dual Graphical    ", 29L);
  else
    write_pch_30_text(report_file, " -- Find R-Dual Hierarchical ", 29L);
  write_line_text(report_file);
  write_pch_20_text(report_file, " -- RoughRDual:", 15L);
  TEMP = log_r_dual(g, fit_gra, p);
  write_real_text(report_file, &TEMP, 10L, 2L);
  write_pch_20_text(report_file, " RoughDualTime: ", 16L);
  write_time_text(report_file, "", 0L, (double)my_clock()/1, start_clock,
		  8L, 3L);
  write_line_text(report_file);
  fflush(report_file);
  P_ioresult = 0;
  dispose_g_c_list(d_r);
  if (link_eh_pack->search_opt == 3) {
    start_clock = my_clock()/1;
    if (*fit_gra)
      find_d_r_graphical(&p, g, d_r);
    else
      find_d_r_hierarchical(&p, g, d_r);
    write_pch_20_text(report_file, " -- DualRej.:  ", 15L);
    TEMP1 = 7;
    write_integer_text(report_file, class_size(*d_r), &TEMP1);
    write_space_text(report_file, 3L);
    write_pch_20_text(report_file, " TimeFindDual:  ", 16L);
    write_time_text(report_file, "", 0L, (double)my_clock()/1,
		    start_clock, 8L, 3L);
    write_line_text(report_file);
  } else {
    while (p != NULL && !interrupt_2) {
      start_clock = my_clock()/1;
      write_pch_10_text(report_file, " //", 3L);
      update_d_r(fit_gra, &p->g_c, g, d_r);
      write_pch_20_text(report_file, " TimeUpDate: ", 13L);
      write_time_text(report_file, "", 0L, (double)my_clock()/1,
		      start_clock, 8L, 3L);
      write_line_text(report_file);
      fflush(report_file);
      P_ioresult = 0;
      p = p->pointer;
    }
  }
  fflush(report_file);
  P_ioresult = 0;
}  /* find_r_dual */


/*@+"ehtest.p"*/


Static Void eh_test_against_saturated(model, g, test)
t_model *model;
long *g;
t_test *test;
{
  test->ok = ok_model_fit_values(model);
  if (test->ok)
    compute_full_x_deviance_and_x_pearson(model, g, &test->x_deviance,
					  &test->x_pearson, &test->x_power);
  else {
    test->ok = ok_model_to_test(model) & ok_model_to_test(&link_full->model);
    if (test->ok)
      compute_x_deviance_and_x_pearson(model, &link_full->model, g,
	&test->x_deviance, &test->x_pearson, &test->x_power);
  }
  if (test->ok && test->df < INFINITY)
    find_adjusted_df(model, &link_full->model, &test->adj);
  else
    test->adj = INFINITY;
  dispose_marginals_cond();
  if (!test->ok)
    write_out_of_space(model->sets_h_g_c, NULL, "SATURATED ", true, 0L, 0L);
}  /* eh_test_against_saturated */


Static Void eh_test_against_base_without_partitioning(model, base_model, g, test)
t_model *model, *base_model;
long *g;
t_test *test;
{
  test->ok = ok_model_to_test(model);
  if (test->ok)
    compute_x_deviance_and_x_pearson(model, base_model, g, &test->x_deviance,
				     &test->x_pearson, &test->x_power);
  if (test->ok && test->df < INFINITY)
    find_adjusted_df(model, base_model, &test->adj);
  else
    test->adj = INFINITY;
  dispose_marginals_cond();
  if (!test->ok)
    write_out_of_space(model->sets_h_g_c, NULL, "BASE      ", true, 0L, 0L);
}  /* eh_test_against_base_without_partitioning */


Static Void eh_test_against_base(model, base_model, g, test)
t_model *model, *base_model;
long *g;
t_test *test;
{
  t_long_integer dummy;
  t_sort_list *link_sort_list;
  boolean local_short_test_output, local_write_models;

  local_short_test_output = true;
  local_write_models = !short_test_output;
  if (!c_partitioning) {
    eh_test_against_base_without_partitioning(model, base_model, g, test);
    return;
  }
  if (local_short_test_output && !just)
    write_space(stdout, 7L);
  dummy = 0;
  dispose_part_list(&link_part_list);
  partitioning_hierarchical(&model->sets_h_g_c, &base_model->sets_h_g_c,
			    &local_short_test_output, &local_write_models,
			    &dummy, 0L);
  if (link_part_list != NULL) {
    if (link_part_list->pointer != NULL && !just) {
      if (local_short_test_output)
	write_pch(stdout, "   =   ", 7L);
      else {
	write_pch(stdout, " Total ", 7L);
	write_line(stdout);
      }
    }
    sum_up_partitioning(&link_sort_list, 0L, &c_partitioning,
			&local_short_test_output, &local_write_models, &just,
			exclude_missing, 0L);
    test->x_pearson = link_sort_list->link_test_list->test.x_pearson;
    test->x_power = link_sort_list->link_test_list->test.x_power;
    test->x_deviance = link_sort_list->link_test_list->test.x_deviance;
    test->df = link_sort_list->link_test_list->test.df;
    test->adj = link_sort_list->link_test_list->test.adj;
    test->ok = link_sort_list->link_test_list->test.ok;
    dispose_sort_list(&link_sort_list);
    return;
  }
  test->x_pearson = 0.0;
  test->x_power = 0.0;
  test->x_deviance = 0.0;
  test->df = 0;
  test->adj = 0;
  test->ok = true;
  if (local_short_test_output && !just)
    write_line(stdout);
}  /* eh_test_against_base */


Static Void eh_test(g_c, link_base, graphical, decomposable, g, test)
t_set_list **g_c;
t_model_list **link_base;
boolean *graphical, *decomposable;
long *g;
t_test *test;
{
  boolean reuse;
  t_model model;
  t_test_list *link_test;
  t_long_real start_clock;
  boolean local_short_test_output, local_write_models;
  double TEMP;

  local_short_test_output = true;
  local_write_models = !short_test_output;
  clear_test(test);
  if (*link_base != NULL)
    reuse = return_test(g_c, &(*link_base)->model.sets_h_g_c, &link_test,
			test);
  else
    reuse = return_test(g_c, &link_full->model.sets_h_g_c, &link_test, test);
  erase_model(&model);
  model.sets_h_g_c = *g_c;
  identify_model(&model);
  /*$ifdef TRACE*/
  if (boolean_option[19]) {
    if (*link_base != NULL)
      describe_model(&(*link_base)->model, false, true);
    else
      describe_model(&link_full->model, false, true);
    describe_model(&model, false, true);
  }
  /*$endif TRACE*/
  *graphical = model.graphical;
  *decomposable = model.decomposable;
  if (!reuse) {
    test->g_c_1 = *g_c;
    if ((model.dim < INFINITY) & (marginal_dimension(g) < INFINITY))
      test->df = marginal_dimension(g) - model.dim - 1;
    else
      test->df = INFINITY;
    start_clock = my_clock()/1;
    if (model.decomposable && model.graphical && exact_test &&
	exact_test_for_test_models &&
	!(*link_base != NULL && c_partitioning)) {
      dispose_marginals_cond();
      if (*link_base != NULL)
	factorization_one_edge_exact(&model, &(*link_base)->model, &link_test,
				     true, &local_short_test_output,
				     &local_write_models);
      else
	factorization_one_edge_exact(&model, &link_full->model, &link_test,
				     true, &local_short_test_output,
				     &local_write_models);
      *test = link_test->test;
      dispose_marginals_cond();
      write_pch_20_text(report_file, " TimeExact:     ", 16L);
      TEMP = (my_clock()/1 - start_clock) / 1000;
      write_real_text(report_file, &TEMP, 8L, 3L);
      write_pch_10_text(report_file, "s.        ", 2L);
    } else {
      if (!decomposable_mode || *graphical && *decomposable) {
	if (*link_base != NULL)
	  eh_test_against_base(&model, &(*link_base)->model, g, test);
	else
	  eh_test_against_saturated(&model, g, test);
      }
      if (re_use_test) {
	copy_set_list(*g_c, &test->g_c_1);
	if (*link_base != NULL)
	  copy_set_list((*link_base)->model.sets_h_g_c, &test->g_c_2);
	else
	  copy_set_list(link_full->model.sets_h_g_c, &test->g_c_2);
	insert_test(&link_test, test);
      }
      write_pch_20_text(report_file, " TimeTest:      ", 16L);
      TEMP = (my_clock()/1 - start_clock) / 1000;
      write_real_text(report_file, &TEMP, 8L, 3L);
      write_pch_10_text(report_file, "s.        ", 2L);
    }
  }
  model.sets_h_g_c = NULL;
  dispose_model(&model);
}  /* eh_test */


/*@+"ehfit.p"*/


Static Void fit(alfa_, g, fit_gra, find_duals, s, a, r, d_a, d_r, fit_a_dual,
		fit_r_dual, acc, rej)
double *alfa_;
long *g;
boolean *fit_gra, find_duals;
t_g_c_list **s, **a, **r, **d_a, **d_r;
boolean fit_a_dual, fit_r_dual;
long *acc, *rej;
{
  t_long_real start_clock, test_clock, p_value;
  boolean p_value_ok, gra, dec;
  t_g_c_list *p;
  t_set_list *m;
  t_test test;
  t_long_integer decision;
  FILE *TEMP;
  long TEMP1;
  double TEMP2;

  if (*fit_gra)
    write_pch_20_text(report_file, " Graphical Fit ", 15L);
  else
    write_pch_20_text(report_file, " Hierarchical Fit ", 18L);
  write_line_text(report_file);
  page(stdout);
  TEMP = stdout;
  flush_file(&TEMP);
  flush_file(&diary_file);
  write_line(stdout);
  write_space(stdout, 2L);
  if (link_eh_pack->link_base != NULL && c_partitioning)
    write_space(stdout, 5L);
  sub_write_test_head(stdout, true);
  write_space(stdout, 7L);
  write_pch(stdout, " Model ", 7L);
  write_line(stdout);
  write_line(stdout);
  *acc = 0;
  *rej = 0;
  p = *s;
  test_clock = my_clock()/1;
  while (p != NULL && !interrupt_2) {
    eh_test(&p->g_c, &link_eh_pack->link_base, &gra, &dec, g, &test);
    p_value = sub_select_p_value(&test);
    if (ic)
      p_value_ok = !is_invalid_real(test.x_deviance);
    else
      p_value_ok = test.ok;
    if (p_value < 0 && !ic)
      p_value = 1.0;
    copy_set_list(p->g_c, &m);
    start_clock = my_clock()/1;
    decision = 3;
    if (p_value_ok) {
      if (p_value < *alfa_) {
	decision = 2;
	(*rej)++;
	insert_maximal(&m, r);
	write_pch_10_text(report_file, " Rej.: ", 7L);
	TEMP1 = 5;
	write_integer_text(report_file, class_size(*r), &TEMP1);
	write_space_text(report_file, 2L);
	if (link_eh_pack->search_opt == 1)
	  update_d_a(fit_gra, &p->g_c, g, d_a);
      } else {
	decision = 1;
	(*acc)++;
	insert_minimal(&m, a);
	write_pch_10_text(report_file, " Acc.: ", 7L);
	TEMP1 = 5;
	write_integer_text(report_file, class_size(*a), &TEMP1);
	write_space_text(report_file, 2L);
	if (link_eh_pack->search_opt == 1)
	  update_d_r(fit_gra, &p->g_c, g, d_r);
      }
    } else
      dispose_set_list(&m);
    write_pch_20_text(report_file, " TimeUpDate: ", 13L);
    TEMP2 = (my_clock()/1 - start_clock) / 1000;
    write_real_text(report_file, &TEMP2, 8L, 3L);
    write_pch_10_text(report_file, "s.", 2L);
    write_line_text(report_file);
    fflush(report_file);
    P_ioresult = 0;
    write_space(stdout, 2L);
    search_write_test(&test, &gra, &dec, &decision);
    p = p->pointer;
    TEMP = stdout;
    flush_file(&TEMP);
    flush_file(&diary_file);
  }
  if (interrupt_2) {
    interrupt_1 = false;
    interrupt_2 = false;
  }
  write_pch_20_text(report_file, " TotalTestTime: ", 16L);
  TEMP2 = (my_clock()/1 - test_clock) / 1000;
  write_real_text(report_file, &TEMP2, 8L, 3L);
  write_pch_10_text(report_file, "s.", 2L);
  write_pch_10_text(report_file, "  Acc.: ", 8L);
  TEMP1 = 5;
  write_integer_text(report_file, *acc, &TEMP1);
  write_char_text(report_file, ' ');
  write_pch_10_text(report_file, "  Rej.: ", 8L);
  TEMP1 = 5;
  write_integer_text(report_file, *rej, &TEMP1);
  write_line_text(report_file);
  fflush(report_file);
  P_ioresult = 0;
  write_line(stdout);
  write_pch(stdout, "    Accepted:", 13L);
  write_integer(stdout, *acc, 5L);
  write_line(stdout);
  write_pch(stdout, "    Rejected:", 13L);
  write_integer(stdout, *rej, 5L);
  write_line(stdout);
  write_line(stdout);
  TEMP = stdout;
  flush_file(&TEMP);
  flush_file(&diary_file);
  if (link_eh_pack->search_opt != 1) {
    if (*acc != 0 && !(*rej == 0 && fit_a_dual)) {
      if (find_duals)
	find_r_dual(g, fit_gra, *a, d_r);
      else
	dispose_g_c_list(d_r);
    }
    if (*rej != 0 && !(*acc == 0 && fit_r_dual)) {
      if (find_duals)
	find_a_dual(g, fit_gra, *r, d_a);
      else
	dispose_g_c_list(d_a);
    }
  }
  write_pch_10_text(report_file, " Fit End ", 9L);
  write_line_text(report_file);
}  /* fit */


Static Void find_d_r_a_com_r(a, b, c)
t_g_c_list *a, *b, **c;
{
  t_g_c_list *p;
  boolean ok;

  *c = NULL;
  while (a != NULL) {
    ok = false;
    p = b;
    while (!ok && p != NULL) {
      if (test_sub_g_c(a->g_c, p->g_c))
	ok = true;
      else
	p = p->pointer;
    }
    if (p == NULL) {
      p = (t_g_c_list *)Malloc(sizeof(t_g_c_list));
      if (p == NULL)
	_OutMem();
      p->pointer = *c;
      *c = p;
      copy_set_list(a->g_c, &(*c)->g_c);
    }
    a = a->pointer;
  }
}  /* find_d_r_a_com_r */


Static Void find_d_a_r_com_a(a, b, c)
t_g_c_list *a, *b, **c;
{
  t_g_c_list *p;
  boolean ok;

  *c = NULL;
  while (a != NULL) {
    ok = false;
    p = b;
    while (!ok && p != NULL) {
      if (test_sub_g_c(p->g_c, a->g_c))
	ok = true;
      else
	p = p->pointer;
    }
    if (p == NULL) {
      p = (t_g_c_list *)Malloc(sizeof(t_g_c_list));
      if (p == NULL)
	_OutMem();
      p->pointer = *c;
      *c = p;
      copy_set_list(a->g_c, &(*c)->g_c);
    }
    a = a->pointer;
  }
}  /* find_d_a_r_com_a */


/*@+"ehprint.p"*/


Static Void print_base_fix_out_fix_in()
{
  write_line_diary();
  if (link_eh_pack->link_base != NULL) {
    write_pch(stdout, " Base Model:  ", 14L);
    print_g_c(link_eh_pack->link_base->model.sets_h_g_c, 14L, line_length);
    write_line(stdout);
  }
  if (link_eh_pack->fix_out) {
    write_pch(stdout, " Fix Out:     ", 14L);
    print_g_c(link_eh_pack->fix_out_gc, 14L, line_length);
    write_line(stdout);
  }
  if (!link_eh_pack->fix_in)
    return;
  write_pch(stdout, " Fix In:      ", 14L);
  print_g_c(link_eh_pack->fix_in_gc, 14L, line_length);
  write_line(stdout);
}  /* print_base_fix_out_fix_in */


Static Void print_models(heading)
boolean heading;
{
  FILE *TEMP;

  page(stdout);
  if (heading) {
    if (link_eh_pack->graphical_search)
      write_pch(stdout, " Inital sets for graphical search:   ", 37L);
    else
      write_pch(stdout, " Inital sets for hierarchical search:", 37L);
    write_line(stdout);
    write_line(stdout);
  }
  write_pch(stdout, " Accepted:", 10L);
  write_line(stdout);
  print_g_c_list(link_eh_pack->a);
  write_pch(stdout, " Rejected:", 10L);
  write_line(stdout);
  print_g_c_list(link_eh_pack->r);
  write_line(stdout);
  TEMP = stdout;
  flush_file(&TEMP);
  flush_file(&diary_file);
}  /* print_models */


Static Void report_sizes(g, fit_gra, a, r, d_a, d_r, d_a_of_r_com_a,
			 d_r_of_a_com_r)
long *g;
boolean *fit_gra;
t_g_c_list *a, *r, *d_a, *d_r, *d_a_of_r_com_a, *d_r_of_a_com_r;
{
  t_long_real t_r, t_a, start_clock, log_d_a_size, log_d_r_size;
  t_long_integer a_size, r_size, d_a_size, d_r_size, d_a_com_size,
		 d_r_com_size;
  long TEMP;
  double TEMP1;

  if (*fit_gra)
    write_pch_20_text(report_file, " Graphical Report", 17L);
  else
    write_pch_20_text(report_file, " Hierarchical Report", 20L);
  write_line_text(report_file);
  start_clock = my_clock()/1;
  a_size = class_size(a);
  d_r_size = class_size(d_r);
  d_r_com_size = class_size(d_r_of_a_com_r);
  t_r = my_clock()/1;
  log_d_r_size = log_r_dual(g, fit_gra, a);
  t_r = my_clock()/1 - t_r;
  r_size = class_size(r);
  d_a_size = class_size(d_a);
  d_a_com_size = class_size(d_a_of_r_com_a);
  t_a = my_clock()/1;
  log_d_a_size = log_a_dual(g, fit_gra, r);
  t_a = my_clock()/1 - t_a;
  write_pch_20_text(report_file, " == Acc.:        ", 17L);
  TEMP = 10;
  write_integer_text(report_file, a_size, &TEMP);
  write_line_text(report_file);
  write_pch_20_text(report_file, " == DualRej.:    ", 17L);
  if (d_r_size != 0) {
    TEMP = 10;
    write_integer_text(report_file, d_r_size, &TEMP);
    if (a_size != 0) {
      TEMP1 = (double)d_r_size / a_size;
      write_real_text(report_file, &TEMP1, 10L, 2L);
    } else
      write_space_text(report_file, 10L);
  }
  write_line_text(report_file);
  write_pch_20_text(report_file, " == DualRej.\\R:  ", 17L);
  if (d_r_size != 0) {
    TEMP = 10;
    write_integer_text(report_file, d_r_com_size, &TEMP);
    if (a_size != 0) {
      TEMP1 = (double)d_r_com_size / a_size;
      write_real_text(report_file, &TEMP1, 10L, 2L);
    } else
      write_space_text(report_file, 10L);
    if (d_r_size != 0) {
      TEMP1 = (double)d_r_com_size / d_r_size;
      write_real_text(report_file, &TEMP1, 10L, 2L);
    } else
      write_space_text(report_file, 10L);
  }
  write_line_text(report_file);
  write_pch_20_text(report_file, " == Log DualRej.:", 17L);
  write_real_text(report_file, &log_d_r_size, 10L, 2L);
  if (a_size > 0) {
    TEMP1 = log_d_r_size - log_10((double)a_size);
    write_real_text(report_file, &TEMP1, 10L, 2L);
  } else
    write_space_text(report_file, 10L);
  if (d_r_size > 0) {
    TEMP1 = log_d_r_size - log_10((double)d_r_size);
    write_real_text(report_file, &TEMP1, 10L, 2L);
  } else
    write_space_text(report_file, 10L);
  if (d_r_com_size > 0) {
    TEMP1 = log_d_r_size - log_10((double)d_r_com_size);
    write_real_text(report_file, &TEMP1, 10L, 2L);
  } else
    write_space_text(report_file, 10L);
  write_pch_10_text(report_file, " Time: ", 7L);
  TEMP1 = t_r / 1000;
  write_real_text(report_file, &TEMP1, 8L, 3L);
  write_pch_10_text(report_file, "s.", 2L);
  write_line_text(report_file);
  write_pch_20_text(report_file, " == Rej.:        ", 17L);
  TEMP = 10;
  write_integer_text(report_file, r_size, &TEMP);
  write_line_text(report_file);
  write_pch_20_text(report_file, " == DualAcc.:    ", 17L);
  if (d_a_size != 0) {
    TEMP = 10;
    write_integer_text(report_file, d_a_size, &TEMP);
    if (r_size != 0) {
      TEMP1 = (double)d_a_size / r_size;
      write_real_text(report_file, &TEMP1, 10L, 2L);
    } else
      write_space_text(report_file, 10L);
  }
  write_line_text(report_file);
  write_pch_20_text(report_file, " == DualAcc.\\A:  ", 17L);
  if (d_a_size != 0) {
    TEMP = 10;
    write_integer_text(report_file, d_a_com_size, &TEMP);
    if (r_size != 0) {
      TEMP1 = (double)d_a_com_size / r_size;
      write_real_text(report_file, &TEMP1, 10L, 2L);
    } else
      write_space_text(report_file, 10L);
    if (d_a_size != 0) {
      TEMP1 = (double)d_a_com_size / d_a_size;
      write_real_text(report_file, &TEMP1, 10L, 2L);
    } else
      write_space_text(report_file, 10L);
  }
  write_line_text(report_file);
  write_pch_20_text(report_file, " == Log DualAcc.:", 17L);
  write_real_text(report_file, &log_d_a_size, 10L, 2L);
  if (r_size > 0) {
    TEMP1 = log_d_a_size - log_10((double)r_size);
    write_real_text(report_file, &TEMP1, 10L, 2L);
  } else
    write_space_text(report_file, 10L);
  if (d_a_size > 0) {
    TEMP1 = log_d_a_size - log_10((double)d_a_size);
    write_real_text(report_file, &TEMP1, 10L, 2L);
  } else
    write_space_text(report_file, 10L);
  if (d_a_com_size > 0) {
    TEMP1 = log_d_a_size - log_10((double)d_a_com_size);
    write_real_text(report_file, &TEMP1, 10L, 2L);
  } else
    write_space_text(report_file, 10L);
  write_pch_10_text(report_file, " Time: ", 7L);
  TEMP1 = t_a / 1000;
  write_real_text(report_file, &TEMP1, 8L, 3L);
  write_pch_10_text(report_file, "s.", 2L);
  write_line_text(report_file);
  if (d_r_com_size == d_a_com_size)
    write_pch_40_text(report_file,
		      " == Size D<R>(A)\\R = D<A>(R)\\A  ", 32L);
  else if (d_r_com_size < d_a_com_size)
    write_pch_30_text(report_file, " == D<R>(A)\\R Smallest  ", 24L);
  else
    write_pch_30_text(report_file, " == D<A>(R)\\A Smallest  ", 24L);
  if ((d_r_com_size <= d_a_com_size) == (log_d_r_size <= log_d_a_size))
    write_pch_20_text(report_file, " Equal Rough ", 13L);
  else if (d_r_com_size != 0 && d_a_com_size != 0 &&
	   d_r_com_size != d_a_com_size)
    write_pch_30_text(report_file, " ***** Diff. Rough ***** ", 25L);
  write_line_text(report_file);
  write_pch_20_text(report_file, " == ReportTime: ", 16L);
  write_line_text(report_file);
  TEMP1 = (my_clock()/1 - start_clock) / 1000;
  write_real_text(report_file, &TEMP1, 8L, 3L);
  write_pch_10_text(report_file, "s.", 2L);
}  /* report_sizes */


Static Void print_duals(complete, heading, fit_gra, g, a, r, d_a, d_r,
			d_a_of_r_com_a, d_r_of_a_com_r)
boolean complete, heading, *fit_gra;
long *g;
t_g_c_list *a, *r, *d_a, *d_r, *d_a_of_r_com_a, *d_r_of_a_com_r;
{
  FILE *TEMP;

  report_sizes(g, fit_gra, a, r, d_a, d_r, d_a_of_r_com_a, d_r_of_a_com_r);
  if (report) {
    page(stdout);
    write_pch(stdout, " D<A>(R): ", 10L);
    write_line(stdout);
    if (d_a == NULL) {
      write_line(stdout);
      write_pch(stdout, " Not found/updated. ", 20L);
      write_line(stdout);
      write_line(stdout);
    } else
      print_g_c_list(d_a);
    write_pch(stdout, " D<R>(A): ", 10L);
    write_line(stdout);
    if (d_r == NULL) {
      write_line(stdout);
      write_pch(stdout, " Not found/updated. ", 20L);
      write_line(stdout);
      write_line(stdout);
    } else
      print_g_c_list(d_r);
    write_line(stdout);
  }
  if (complete) {
    if (!report)
      page(stdout);
    if (heading) {
      write_pch(stdout, " CHOOSE BETWEEN ", 16L);
      write_line(stdout);
      write_line(stdout);
    }
    write_pch(stdout, " 1)  D<A>(R)\\A: ", 16L);
    write_line(stdout);
    print_g_c_list(d_a_of_r_com_a);
    write_pch(stdout, " 2)  D<R>(A)\\R: ", 16L);
    write_line(stdout);
    print_g_c_list(d_r_of_a_com_r);
    write_line(stdout);
  }
  TEMP = stdout;
  flush_file(&TEMP);
  flush_file(&diary_file);
}  /* print_duals */


/*@+"ehinit.p"*/


Static Void dispose_duals()
{
  dispose_g_c_list(&link_eh_pack->d_r);
  dispose_g_c_list(&link_eh_pack->d_a);
}  /* dispose_duals */


Static Void dispose_classes()
{
  dispose_g_c_list(&link_eh_pack->a);
  dispose_g_c_list(&link_eh_pack->r);
}  /* dispose_classes */


Static Void dispose_duals_and_models()
{
  dispose_g_c_list(&link_eh_pack->d_r);
  dispose_g_c_list(&link_eh_pack->d_a);
  dispose_g_c_list(&link_eh_pack->a);
  dispose_g_c_list(&link_eh_pack->r);
}  /* dispose_duals_and_models */


Static Void read_main_effects_arguments(a)
long *a;
{
  boolean ok;

  dispose_duals_and_models();
  P_setcpy(link_eh_pack->g, a);
  ok = false;
  print_do_exclude(link_eh_pack->g, &ok, &ok, 0L);
}  /* read_main_effects_arguments */


Static Void proc_set_main_effects(command_file, as_argument, ifail, sub_code,
				  arg_pos, nargs, arg_char)
FILE *command_file;
boolean as_argument;
long *ifail, *sub_code, arg_pos;
long **nargs;
Char **arg_char;
{
  t_vertex_set a;
  t_long_integer i;

  P_setcpy(a, link_eh_pack->g);
  i = PCH_START;
  if (get_vertex_set(command_file, true, true, false, as_argument, &i, ifail,
		     sub_code, arg_pos, nargs, arg_char, " SET->", 6L, a,
		     a) && *sub_code != -1)
    read_main_effects_arguments(a);
}  /* proc_set_main_effects */


Static Void init_graphical_search()
{
  t_set_list *m;
  t_vertex v;
  t_vertex_set b;
  t_vertex FORLIM;

  dispose_duals_and_models();
  link_eh_pack->graphical_search = true;
  m = NULL;
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    if (P_inset(v, link_eh_pack->g)) {
      P_addset(P_expset(b, 0L), v);
      insert_set_in_set_list(b, &m);
    }
  }
  insert_maximal(&m, &link_eh_pack->r);
  m = NULL;
  insert_set_in_set_list(link_eh_pack->g, &m);
  insert_minimal(&m, &link_eh_pack->a);
}  /* init_graphical_search */


Static Void find_duals()
{
  write_line(stdout);
  print_models(true);
  if (link_eh_pack->d_a == NULL)
    find_a_dual(link_eh_pack->g, &link_eh_pack->graphical_search,
		link_eh_pack->r, &link_eh_pack->d_a);
  if (link_eh_pack->d_r == NULL)
    find_r_dual(link_eh_pack->g, &link_eh_pack->graphical_search,
		link_eh_pack->a, &link_eh_pack->d_r);
}  /* find_duals */


Static Void insert_base_model(g_c)
t_set_list **g_c;
{
  t_vertex_set g_local;
  t_set_list *tmp_p;
  boolean ok;
  t_model *WITH;

  if (link_eh_pack->link_base != NULL)
    dispose_model(&link_eh_pack->link_base->model);
  else {
    link_eh_pack->link_base = (t_model_list *)Malloc(sizeof(t_model_list));
    if (link_eh_pack->link_base == NULL)
      _OutMem();
    link_eh_pack->link_base->pointer = NULL;
  }
  erase_model(&link_eh_pack->link_base->model);
  WITH = &link_eh_pack->link_base->model;
  P_setcpy(WITH->model_set, empty_set);
  add_union_of_gc(*g_c, WITH->model_set);
  WITH->sets_h_g_c = *g_c;
  identify_model(&link_eh_pack->link_base->model);
  ok = ok_model_to_test(&link_eh_pack->link_base->model);
  link_eh_pack->fix_out = true;
  P_setcpy(link_eh_pack->g, WITH->model_set);
  ok = false;
  print_do_exclude(link_eh_pack->g, &ok, &ok, 0L);
  dispose_set_list(&link_eh_pack->fix_out_gc);
  normal_to_dual(WITH->sets_h_g_c, link_eh_pack->g, &link_eh_pack->fix_out_gc);
  if (link_eh_pack->fix_in) {
    if (!test_sub_g_c(link_eh_pack->fix_in_gc, WITH->sets_h_g_c)) {
      write_pch(stdout, " FixIn not sub GC of BaseModel.", 31L);
      write_line(stdout);
      find_g_c_intersection_maximal(link_eh_pack->fix_in_gc,
				    &WITH->sets_h_g_c, &tmp_p);
      dispose_set_list(&link_eh_pack->fix_in_gc);
      link_eh_pack->fix_in_gc = tmp_p;
      hypergraph_sets_to_graph_sets(link_eh_pack->fix_in_gc, g_local,
				    link_eh_pack->fix_in_adj_set);
    }
  }
  first_order_to_graph_sets(link_eh_pack->fix_out_gc,
			    link_eh_pack->fix_out_adj_set);
  print_base_fix_out_fix_in();
  write_pch(stdout, " Base model read", 16L);
}  /* insert_base_model */


Static Void proc_set_base_model(command_file, as_argument, ifail, sub_code,
				arg_pos, nargs, arg_char)
FILE *command_file;
boolean as_argument;
long *ifail, *sub_code, arg_pos;
long **nargs;
Char **arg_char;
{
  t_set_list *gc;
  t_long_integer i;

  gc = NULL;
  i = PCH_START;
  if (get_gc(command_file, true, true, false, as_argument, &i, ifail,
	     sub_code, arg_pos, nargs, arg_char, " GC->", 5L,
	     &link_eh_pack->link_base->model.sets_h_g_c,
	     &gc) && *sub_code != -1)
    insert_base_model(&gc);
}  /* proc_set_base_model */


Static Void search_base()
{
  if (current()) {
    if (link_current->model.sets_h_g_c != NULL)
      insert_base_model(&link_current->model.sets_h_g_c);
  }
}  /* search_base */


Static boolean to_update_fix_in_or_out()
{
  t_set_list *p, *q;
  boolean to_update;

  p = link_eh_pack->fix_out_gc;
  to_update = false;
  while (p != NULL) {
    q = link_eh_pack->fix_in_gc;
    while (q != NULL) {
      if (P_subset(p->vertex_set, q->vertex_set)) {
	if (!to_update) {
	  write_line_diary();
	  write_pch(stdout, " FixOut Edges subset of FixIn edges.", 36L);
	  write_line(stdout);
	}
	to_update = true;
	write_pch(stdout, " FixIn:   ", 10L);
	print_vertex_set_table(q->vertex_set);
	write_line(stdout);
	write_pch(stdout, " FixOut:  ", 10L);
	print_vertex_set_table(p->vertex_set);
	write_line(stdout);
      }
      q = q->pointer;
    }
    p = p->pointer;
  }
  return to_update;
}  /* to_update_fix_in_or_out */


Static Void do_fix_out()
{
  t_set_list *alt_rep, *tmp_p;

  link_eh_pack->fix_out = true;
  if (link_eh_pack->link_base != NULL) {
    dual_to_normal(link_eh_pack->fix_out_gc, link_eh_pack->g, &alt_rep);
    find_g_c_intersection_maximal(link_eh_pack->link_base->model.sets_h_g_c,
				  &alt_rep, &tmp_p);
    dispose_set_list(&alt_rep);
    dispose_set_list(&link_eh_pack->fix_out_gc);
    normal_to_dual(tmp_p, link_eh_pack->g, &link_eh_pack->fix_out_gc);
    dispose_set_list(&tmp_p);
  }
  if (link_eh_pack->fix_in) {
    if (!empty_g_c(&link_eh_pack->fix_out_gc)) {
      if (to_update_fix_in_or_out()) {
	dual_to_normal(link_eh_pack->fix_out_gc, link_eh_pack->g, &alt_rep);
	find_g_c_intersection_maximal(link_eh_pack->fix_in_gc, &alt_rep,
				      &tmp_p);
	dispose_set_list(&alt_rep);
	dispose_set_list(&link_eh_pack->fix_in_gc);
	link_eh_pack->fix_in_gc = tmp_p;
      }
    }
  }
  first_order_to_graph_sets(link_eh_pack->fix_out_gc,
			    link_eh_pack->fix_out_adj_set);
}  /* do_fix_out */


Static Void do_fix_in()
{
  t_set_list *alt_rep, *tmp_p;
  t_vertex_set g_local;

  if (link_eh_pack->fix_out) {
    if (!empty_g_c(&link_eh_pack->fix_out_gc)) {
      if (to_update_fix_in_or_out()) {
	dual_to_normal(link_eh_pack->fix_out_gc, link_eh_pack->g, &alt_rep);
	add_set_list_maximal(link_eh_pack->fix_in_gc, &alt_rep);
	dispose_set_list(&link_eh_pack->fix_out_gc);
	normal_to_dual(alt_rep, link_eh_pack->g, &link_eh_pack->fix_out_gc);
	dispose_set_list(&alt_rep);
      }
    }
  }
  if (link_eh_pack->link_base != NULL) {
    if (!test_sub_g_c(link_eh_pack->fix_in_gc,
		      link_eh_pack->link_base->model.sets_h_g_c)) {
      write_pch(stdout, " FixIn not sub GC of BaseModel.", 31L);
      write_line(stdout);
      find_g_c_intersection_maximal(link_eh_pack->fix_in_gc,
	&link_eh_pack->link_base->model.sets_h_g_c, &tmp_p);
      copy_set_list(link_eh_pack->link_base->model.sets_h_g_c, &alt_rep);
      add_set_list_maximal(link_eh_pack->fix_in_gc, &alt_rep);
      write_pch(stdout, " Alternative BaseModel:", 23L);
      print_g_c(alt_rep, 1L, line_length);
      write_line(stdout);
      dispose_set_list(&alt_rep);
      dispose_set_list(&link_eh_pack->fix_in_gc);
      link_eh_pack->fix_in_gc = tmp_p;
    }
  }
  hypergraph_sets_to_graph_sets(link_eh_pack->fix_in_gc, g_local,
				link_eh_pack->fix_in_adj_set);
}  /* do_fix_in */


Static Void fix_out_argument(p)
t_set_list **p;
{
  link_eh_pack->fix_out = true;
  dispose_set_list(&link_eh_pack->fix_out_gc);
  dispose_set_list(&link_eh_pack->fix_out_gc_x);
  link_eh_pack->fix_out_gc = *p;
  copy_set_list(link_eh_pack->fix_out_gc, &link_eh_pack->fix_out_gc_x);
  do_fix_out();
  print_base_fix_out_fix_in();
}  /* fix_out_argument */


Static Void proc_set_fix_out(command_file, as_argument, ifail, sub_code,
			     arg_pos, nargs, arg_char)
FILE *command_file;
boolean as_argument;
long *ifail, *sub_code, arg_pos;
long **nargs;
Char **arg_char;
{
  t_set_list *p;
  t_long_integer i;

  p = NULL;
  i = PCH_START;
  if (get_gc(command_file, true, true, false, as_argument, &i, ifail,
	     sub_code, arg_pos, nargs, arg_char, " GC->", 5L,
	     &link_eh_pack->fix_out_gc, &p) && *sub_code != -1)
    fix_out_argument(&p);
  else if (*sub_code != -1)
    print_base_fix_out_fix_in();
}  /* proc_set_fix_out */


Static Void redo_fix_out()
{
  dispose_set_list(&link_eh_pack->fix_out_gc);
  copy_set_list(link_eh_pack->fix_out_gc_x, &link_eh_pack->fix_out_gc);
  do_fix_out();
  print_base_fix_out_fix_in();
}  /* redo_fix_out */


Static Void add_fix_out_argument(p)
t_set_list **p;
{
  t_set_list *q;

  q = *p;
  while (q != NULL) {
    insert_set_minimal((*p)->vertex_set, &link_eh_pack->fix_out_gc);
    insert_set_minimal((*p)->vertex_set, &link_eh_pack->fix_out_gc_x);
    q = q->pointer;
  }
  dispose_set_list(p);
  do_fix_out();
  print_base_fix_out_fix_in();
}  /* add_fix_out_argument */


Static Void proc_add_fix_out(command_file, as_argument, ifail, sub_code,
			     arg_pos, nargs, arg_char)
FILE *command_file;
boolean as_argument;
long *ifail, *sub_code, arg_pos;
long **nargs;
Char **arg_char;
{
  t_set_list *p;
  t_long_integer i;

  p = NULL;
  i = PCH_START;
  if (get_gc(command_file, true, true, false, as_argument, &i, ifail,
	     sub_code, arg_pos, nargs, arg_char, " GC->", 5L,
	     &link_eh_pack->fix_out_gc_x, &p) && *sub_code != -1)
    add_fix_out_argument(&p);
  else if (*sub_code != -1)
    print_base_fix_out_fix_in();
}  /* proc_add_fix_out */


Static Void fix_in_argument(p)
t_set_list **p;
{
  link_eh_pack->fix_in = true;
  dispose_set_list(&link_eh_pack->fix_in_gc);
  dispose_set_list(&link_eh_pack->fix_in_gc_x);
  link_eh_pack->fix_in_gc = *p;
  copy_set_list(link_eh_pack->fix_in_gc, &link_eh_pack->fix_in_gc_x);
  do_fix_in();
  print_base_fix_out_fix_in();
}  /* fix_in_argument */


Static Void proc_set_fix_in(command_file, as_argument, ifail, sub_code,
			    arg_pos, nargs, arg_char)
FILE *command_file;
boolean as_argument;
long *ifail, *sub_code, arg_pos;
long **nargs;
Char **arg_char;
{
  t_set_list *p;
  t_long_integer i;

  p = NULL;
  i = PCH_START;
  if (get_gc(command_file, true, true, false, as_argument, &i, ifail,
	     sub_code, arg_pos, nargs, arg_char, " GC->", 5L,
	     &link_eh_pack->fix_in_gc, &p) && *sub_code != -1)
    fix_in_argument(&p);
  else if (*sub_code != -1)
    print_base_fix_out_fix_in();
}  /* proc_set_fix_in */


Static Void redo_fix_in()
{
  dispose_set_list(&link_eh_pack->fix_in_gc);
  copy_set_list(link_eh_pack->fix_in_gc_x, &link_eh_pack->fix_in_gc);
  do_fix_in();
  print_base_fix_out_fix_in();
}  /* redo_fix_in */


Static Void add_fix_in_argument(p)
t_set_list **p;
{
  t_set_list *q;

  q = *p;
  while (q != NULL) {
    insert_clique((*p)->vertex_set, &link_eh_pack->fix_in_gc);
    insert_clique((*p)->vertex_set, &link_eh_pack->fix_in_gc_x);
    q = q->pointer;
  }
  dispose_set_list(p);
  do_fix_in();
  print_base_fix_out_fix_in();
}  /* add_fix_in_argument */


Static Void proc_add_fix_in(command_file, as_argument, ifail, sub_code,
			    arg_pos, nargs, arg_char)
FILE *command_file;
boolean as_argument;
long *ifail, *sub_code, arg_pos;
long **nargs;
Char **arg_char;
{
  t_set_list *p;
  t_long_integer i;

  p = NULL;
  i = PCH_START;
  if (get_gc(command_file, true, true, false, as_argument, &i, ifail,
	     sub_code, arg_pos, nargs, arg_char, " GC->", 5L,
	     &link_eh_pack->fix_in_gc_x, &p) && *sub_code != -1)
    add_fix_in_argument(&p);
  else if (*sub_code != -1)
    print_base_fix_out_fix_in();
}  /* proc_add_fix_in */


Static Void add_models_to_accepted(s, copy, a, d_r)
t_g_c_list *s;
boolean copy;
t_g_c_list **a, **d_r;
{
  t_g_c_list *p;
  t_set_list *g_c;

  while (s != NULL) {
    if (!empty_g_c(&s->g_c)) {
      if (copy) {
	copy_set_list(s->g_c, &g_c);
	insert_minimal(&g_c, a);
      } else {
	insert_minimal(&s->g_c, a);
	s->g_c = NULL;
      }
    }
    p = s;
    s = s->pointer;
    if (!copy)
      Free(p);
  }
  find_r_dual(link_eh_pack->g, &link_eh_pack->graphical_search, *a, d_r);
}  /* add_models_to_accepted */


Static Void add_models_to_rejected(s, copy, r, d_a)
t_g_c_list *s;
boolean copy;
t_g_c_list **r, **d_a;
{
  t_g_c_list *p;
  t_set_list *g_c;

  while (s != NULL) {
    if (!empty_g_c(&s->g_c)) {
      if (copy) {
	copy_set_list(s->g_c, &g_c);
	insert_maximal(&g_c, r);
      } else {
	insert_maximal(&s->g_c, r);
	s->g_c = NULL;
      }
    }
    p = s;
    s = s->pointer;
    if (!copy)
      Free(p);
  }
  find_a_dual(link_eh_pack->g, &link_eh_pack->graphical_search, *r, d_a);
}  /* add_models_to_rejected */


Static Void add_a_dual_to_accepted(a, d_r)
t_g_c_list **a, **d_r;
{
  t_g_c_list *s;

  s = NULL;
  find_a_dual(link_eh_pack->g, &link_eh_pack->graphical_search, *a, &s);
  add_models_to_accepted(s, false, a, d_r);
}  /* add_a_dual_to_accepted */


Static Void add_r_dual_to_rejected(r, d_a)
t_g_c_list **r, **d_a;
{
  t_g_c_list *s;

  s = NULL;
  find_r_dual(link_eh_pack->g, &link_eh_pack->graphical_search, *r, &s);
  add_models_to_rejected(s, false, r, d_a);
}  /* add_r_dual_to_rejected */


Static Void proc_set_accepted_models(command_file, as_argument, ifail,
				     sub_code, arg_pos, nargs, arg_char)
FILE *command_file;
boolean as_argument;
long *ifail, *sub_code, arg_pos;
long **nargs;
Char **arg_char;
{
  t_g_c_list *s;
  t_long_integer i;

  s = NULL;
  i = PCH_START;
  if (!(get_gc_list(command_file, true, true, false, as_argument, &i, ifail,
		    sub_code, arg_pos, nargs, arg_char, " Models->", 9L,
		    &link_eh_pack->a, &s) && *sub_code != -1))
    return;
  write_line(stdout);
  write_line(stdout);
  write_pch(stdout, " Read models: ", 14L);
  write_line(stdout);
  print_g_c_list(s);
  write_line(stdout);
  add_models_to_accepted(s, false, &link_eh_pack->a, &link_eh_pack->d_r);
  print_models(true);
}  /* proc_set_accepted_models */


Static Void proc_set_rejected_models(command_file, as_argument, ifail,
				     sub_code, arg_pos, nargs, arg_char)
FILE *command_file;
boolean as_argument;
long *ifail, *sub_code, arg_pos;
long **nargs;
Char **arg_char;
{
  t_g_c_list *s;
  t_long_integer i;

  s = NULL;
  i = PCH_START;
  if (!(get_gc_list(command_file, true, true, false, as_argument, &i, ifail,
		    sub_code, arg_pos, nargs, arg_char, " Models->", 9L,
		    &link_eh_pack->r, &s) && *sub_code != -1))
    return;
  write_line(stdout);
  write_line(stdout);
  write_pch(stdout, " Read models: ", 14L);
  write_line(stdout);
  print_g_c_list(s);
  write_line(stdout);
  add_models_to_rejected(s, false, &link_eh_pack->r, &link_eh_pack->d_a);
  print_models(true);
}  /* proc_set_rejected_models */


Static Void proc_set_start_models(command_file, as_argument, ifail, sub_code,
				  arg_pos, nargs, arg_char)
FILE *command_file;
boolean as_argument;
long *ifail, *sub_code, arg_pos;
long **nargs;
Char **arg_char;
{
  t_g_c_list *s;
  t_long_integer i, acc, rej;

  s = NULL;
  i = PCH_START;
  if (!get_gc_list(command_file, true, true, false, as_argument, &i, ifail,
		   sub_code, arg_pos, nargs, arg_char, " Models->", 9L, &s,
		   &s))
    return;
  write_line(stdout);
  page(stdout);
  write_pch(stdout, " Initial set: ", 14L);
  write_line(stdout);
  print_g_c_list(s);
  write_line(stdout);
  acc = 0;
  rej = 0;
  fit(&alfa_, link_eh_pack->g, &link_eh_pack->graphical_search, false, &s,
      &link_eh_pack->a, &link_eh_pack->r, &link_eh_pack->d_a,
      &link_eh_pack->d_r, false, false, &acc, &rej);
  dispose_g_c_list(&s);
  print_models(true);
}  /* proc_set_start_models */


Static Void set_search_class(code)
long *code;
{
  if (*code <= 9)
    return;
  decomposable_mode = (*code / 10 == 1);
  if (link_eh_pack->graphical_search == (*code / 10 != 3))
    return;
  link_eh_pack->graphical_search = (*code / 10 != 3);
  dispose_duals();
  find_duals();
}  /* set_search_class */


Static Void end_search(link_eh_pack)
t_eh_pack **link_eh_pack;
{
  t_eh_pack *WITH;

  WITH = *link_eh_pack;
  if (timer) {
    write_pch(stdout, " Search ", 8L);
    write_pch(stdout, " TIME: ", 7L);
    write_real(stdout, WITH->search_time / 1000, 10L, 3L);
    write_pch(stdout, "secs.", 5L);
    write_line(stdout);
  }
  dispose_duals_and_models();
  dispose_set_list(&WITH->fix_in_gc);
  dispose_set_list(&WITH->fix_out_gc);
  dispose_set_list(&WITH->fix_in_gc_x);
  dispose_set_list(&WITH->fix_out_gc_x);
  dispose_model(&link_full->model);
  Free(link_full);
  link_full = NULL;
  if (WITH->link_base != NULL) {
    dispose_model(&WITH->link_base->model);
    Free((*link_eh_pack)->link_base);
    (*link_eh_pack)->link_base = NULL;
  }
  Free(*link_eh_pack);
  *link_eh_pack = NULL;
  write_pch(stdout, " Search ended", 13L);
  write_line(stdout);
}  /* end_search */


Static Void start_search(link_eh_pack)
t_eh_pack **link_eh_pack;
{
  boolean ok;
  t_eh_pack *WITH;

  *link_eh_pack = (t_eh_pack *)Malloc(sizeof(t_eh_pack));
  if (*link_eh_pack == NULL)
    _OutMem();
  WITH = *link_eh_pack;
  WITH->fix_in_gc_x = NULL;
  WITH->fix_out_gc_x = NULL;
  WITH->fix_out_gc = NULL;
  WITH->fix_in_gc = NULL;
  WITH->fix_out = false;
  WITH->fix_in = false;
  WITH->link_base = NULL;
  link_full = (t_model_list *)Malloc(sizeof(t_model_list));
  if (link_full == NULL)
    _OutMem();
  link_full->pointer = NULL;
  erase_model(&link_full->model);
  insert_set_in_set_list(delta, &link_full->model.sets_h_g_c);
  identify_model(&link_full->model);
  ok = ok_model_to_test(&link_full->model);
  P_setcpy(WITH->g, delta);
  WITH->a = NULL;
  WITH->r = NULL;
  WITH->d_a = NULL;
  WITH->d_r = NULL;
  WITH->search_opt = 3;
  WITH->search_time = 0.0;
  WITH->graphical_search = true;
  WITH->search_strategy = 1;
}  /* start_search */


Static Void search_status()
{
  t_eh_pack *WITH;

  if (link_eh_pack == NULL) {
    write_line_diary();
    start_search(&link_eh_pack);
    write_pch(stdout, " Search started", 15L);
    write_line(stdout);
  }
  WITH = link_eh_pack;
  print_models(true);
  page(stdout);
  print_duals(false, false, &WITH->graphical_search, WITH->g, WITH->a,
	      WITH->r, WITH->d_a, WITH->d_r, NULL, NULL);
  write_pch(stdout, " D<A>(R): ", 10L);
  write_line(stdout);
  if (WITH->d_a == NULL) {
    write_line(stdout);
    write_pch(stdout, " Not found/updated.", 19L);
    write_line(stdout);
    write_line(stdout);
  } else
    print_g_c_list(WITH->d_a);
  write_pch(stdout, " D<R>(A): ", 10L);
  write_line(stdout);
  if (WITH->d_r == NULL) {
    write_line(stdout);
    write_pch(stdout, " Not found/updated.", 19L);
    write_line(stdout);
    write_line(stdout);
  } else
    print_g_c_list(WITH->d_r);
  write_line(stdout);
  switch (WITH->search_strategy) {

  case 1:
    write_pch(stdout, " Smallest Search", 16L);
    break;

  case 2:
    write_pch(stdout, " Alternating Search", 19L);
    break;

  case 3:
    write_pch(stdout, " Rough Search", 13L);
    break;
  }
  write_line(stdout);
  page(stdout);
  print_base_fix_out_fix_in();
  write_line(stdout);
  write_pch(stdout, " Main effects: ", 15L);
  print_vertex_set(WITH->g);
  write_line(stdout);
}  /* search_status */


Static Void proc_extract_models(code)
long code;
{
  t_g_c_list *p;

  switch (code % 10) {

  case 1:
    p = link_eh_pack->a;
    break;

  case 2:
    p = link_eh_pack->r;
    break;

  case 3:
    p = link_eh_pack->d_a;
    break;

  case 4:
    p = link_eh_pack->d_r;
    break;
  }
  while (p != NULL) {
    new_model(&link_model_list, &first_model_available);
    copy_set_list(p->g_c, &link_model_list->model.sets_h_g_c);
    add_union_of_gc(link_model_list->model.sets_h_g_c,
		    link_model_list->model.model_set);
    p = p->pointer;
  }
}  /* proc_extract_models */


Static Void enter_accepted_models(s)
t_g_c_list **s;
{
  write_pch(stdout, " Initial set: ", 14L);
  write_line(stdout);
  print_g_c_list(*s);
  write_line(stdout);
  add_models_to_accepted(*s, false, &link_eh_pack->a, &link_eh_pack->d_r);
  print_models(true);
}  /* enter_accepted_models */


Static Void enter_rejected_models(s)
t_g_c_list **s;
{
  write_pch(stdout, " Initial set: ", 14L);
  write_line(stdout);
  print_g_c_list(*s);
  write_line(stdout);
  add_models_to_rejected(*s, false, &link_eh_pack->r, &link_eh_pack->d_a);
  print_models(true);
}  /* enter_rejected_models */


Static Void enter_start_models(s)
t_g_c_list **s;
{
  t_long_integer acc, rej;

  write_pch(stdout, " Initial set: ", 14L);
  write_line(stdout);
  print_g_c_list(*s);
  write_line(stdout);
  fit(&alfa_, link_eh_pack->g, &link_eh_pack->graphical_search, false, s,
      &link_eh_pack->a, &link_eh_pack->r, &link_eh_pack->d_a,
      &link_eh_pack->d_r, false, false, &acc, &rej);
  dispose_g_c_list(s);
  print_models(true);
}  /* enter_start_models */


Static Void proc_export_one(base, current, code)
boolean base, current;
long code;
{
  t_model_list *link_model;
  t_g_c_list *s;

  if (current)
    link_model = link_current;
  else if (base)
    link_model = link_base;
  else
    link_model = link_model_list;
  if (link_model == NULL)
    return;
  s = (t_g_c_list *)Malloc(sizeof(t_g_c_list));
  if (s == NULL)
    _OutMem();
  s->pointer = NULL;
  copy_set_list(link_model->model.sets_h_g_c, &s->g_c);
  if (code == 0) {
    enter_start_models(&s);
    return;
  }
  if (code == 1)
    enter_accepted_models(&s);
  else
    enter_rejected_models(&s);
}  /* proc_export_one */


Static Void proc_export_interval(command_file, all_, one, code, as_argument,
				 ifail, sub_code, arg_pos, nargs, arg_int)
FILE *command_file;
boolean all_, one;
long code;
boolean as_argument;
long *ifail, *sub_code, arg_pos;
long **nargs, **arg_int;
{
  t_model_list *link_model;
  t_g_c_list *s, *t;
  t_long_integer nr1, nr2, i;

  if (!all_) {
    i = 0;
    nr1 = 0;
    nr2 = 0;
    get_next_integer(command_file, as_argument, &i, ifail, sub_code, arg_pos,
		     nargs, arg_int, " Number->", 9L, &nr1);
    if (one)
      nr2 = nr1;
    else
      get_next_integer(command_file, as_argument, &i, ifail, sub_code,
		       arg_pos, nargs, arg_int, " Number->", 9L, &nr2);
  }
  link_model = link_model_list;
  s = NULL;
  while (link_model != NULL) {
    if ((nr1 <= link_model->model.model_number &&
	 link_model->model.model_number <= nr2) || all_) {
      t = (t_g_c_list *)Malloc(sizeof(t_g_c_list));
      if (t == NULL)
	_OutMem();
      t->pointer = s;
      copy_set_list(link_model->model.sets_h_g_c, &t->g_c);
      s = t;
    }
    link_model = link_model->pointer;
  }
  if (s == NULL)
    return;
  if (code == 0) {
    enter_start_models(&s);
    return;
  }
  if (code == 1)
    enter_accepted_models(&s);
  else
    enter_rejected_models(&s);
}  /* proc_export_interval */


/*@+"maineh.p"*/


Static Void search_directed(command_file, alfa_, g, fit_gra, a, r, d_a, d_r)
FILE *command_file;
double *alfa_;
long *g;
boolean *fit_gra;
t_g_c_list **a, **r, **d_a, **d_r;
{
  t_g_c_list *s, *d_a_of_r_com_a, *d_r_of_a_com_r;
  t_long_integer rej, acc, choice;
  boolean stop;

  stop = false;
  if (*d_a == NULL)
    find_a_dual(g, fit_gra, *r, d_a);
  if (*d_r == NULL)
    find_r_dual(g, fit_gra, *a, d_r);
  while (!stop) {
    find_d_r_a_com_r(*d_r, *r, &d_r_of_a_com_r);
    find_d_a_r_com_a(*d_a, *a, &d_a_of_r_com_a);
    print_duals(true, true, fit_gra, g, *a, *r, *d_a, *d_r, d_a_of_r_com_a,
		d_r_of_a_com_r);
    read_integer(command_file, " 1/2/3->  ", 8L, &choice);
    if ((unsigned long)choice >= 32 || ((1L << choice) & 0x6) == 0) {
      stop = true;
      break;
    }
    if (choice == 2)
      s = d_r_of_a_com_r;
    else
      s = d_a_of_r_com_a;
    fit(alfa_, g, fit_gra, true, &s, a, r, d_a, d_r, choice == 1, choice == 2,
	&acc, &rej);
    dispose_g_c_list(&d_r_of_a_com_r);
    dispose_g_c_list(&d_a_of_r_com_a);
    print_models(false);
    stop = (choice == 1 && rej == 0 || choice == 2 && acc == 0);
  }
}  /* search_directed */


Static Void search_auto(alfa_, g, fit_gra, a, r, d_a, d_r)
double *alfa_;
long *g;
boolean *fit_gra;
t_g_c_list **a, **r, **d_a, **d_r;
{
  t_g_c_list *s, *d_a_of_r_com_a, *d_r_of_a_com_r, *p;
  t_long_integer rej, acc, choice;
  boolean stop, r_dual;

  stop = false;
  if (*d_a == NULL)
    find_a_dual(g, fit_gra, *r, d_a);
  if (*d_r == NULL)
    find_r_dual(g, fit_gra, *a, d_r);
  while (!stop) {
    find_d_r_a_com_r(*d_r, *r, &d_r_of_a_com_r);
    find_d_a_r_com_a(*d_a, *a, &d_a_of_r_com_a);
    choice = 0;
    p = d_r_of_a_com_r;
    while (p != NULL) {
      choice++;
      p = p->pointer;
    }
    p = d_a_of_r_com_a;
    while (p != NULL) {
      choice--;
      p = p->pointer;
    }
    print_duals(true, false, fit_gra, g, *a, *r, *d_a, *d_r, d_a_of_r_com_a,
		d_r_of_a_com_r);
    r_dual = (choice <= 0);
    if (r_dual)
      s = d_r_of_a_com_r;
    else
      s = d_a_of_r_com_a;
    fit(alfa_, g, fit_gra, true, &s, a, r, d_a, d_r, !r_dual, r_dual, &acc,
	&rej);
    dispose_g_c_list(&d_r_of_a_com_r);
    dispose_g_c_list(&d_a_of_r_com_a);
    print_models(false);
    stop = (!r_dual && rej == 0 || r_dual && acc == 0 || interrupt_3);
  }
}  /* search_auto */


Static Void alter_search_auto(alfa_, g, fit_gra, a, r, d_a, d_r)
double *alfa_;
long *g;
boolean *fit_gra;
t_g_c_list **a, **r, **d_a, **d_r;
{
  t_g_c_list *s, *d_a_of_r_com_a, *d_r_of_a_com_r;
  t_long_integer rej, acc;
  boolean stop, a_dual;

  stop = false;
  a_dual = false;
  while (!stop) {
    if (a_dual) {
      d_r_of_a_com_r = NULL;
      if (*d_a == NULL)
	find_a_dual(g, fit_gra, *r, d_a);
      find_d_a_r_com_a(*d_a, *a, &d_a_of_r_com_a);
      s = d_a_of_r_com_a;
    } else {
      d_a_of_r_com_a = NULL;
      if (*d_r == NULL)
	find_r_dual(g, fit_gra, *a, d_r);
      find_d_r_a_com_r(*d_r, *r, &d_r_of_a_com_r);
      s = d_r_of_a_com_r;
    }
    print_duals(false, false, fit_gra, g, *a, *r, *d_a, *d_r, d_a_of_r_com_a,
		d_r_of_a_com_r);
    fit(alfa_, g, fit_gra, false, &s, a, r, d_a, d_r, a_dual, !a_dual, &acc,
	&rej);
    dispose_g_c_list(&d_r_of_a_com_r);
    dispose_g_c_list(&d_a_of_r_com_a);
    print_models(false);
    stop = (a_dual && rej == 0 || !a_dual && acc == 0 || interrupt_3);
    a_dual = !a_dual;
  }
}  /* alter_search_auto */


Static Void rough_search_auto(alfa_, g, fit_gra, a, r, d_a, d_r)
double *alfa_;
long *g;
boolean *fit_gra;
t_g_c_list **a, **r, **d_a, **d_r;
{
  t_g_c_list *s, *d_a_of_r_com_a, *d_r_of_a_com_r;
  t_long_integer rej, acc;
  boolean stop, a_dual;

  stop = false;
  while (!stop) {
    a_dual = (log_a_dual(g, fit_gra, *r) < log_r_dual(g, fit_gra, *a));
    if (a_dual) {
      d_r_of_a_com_r = NULL;
      if (*d_a == NULL)
	find_a_dual(g, fit_gra, *r, d_a);
      find_d_a_r_com_a(*d_a, *a, &d_a_of_r_com_a);
      s = d_a_of_r_com_a;
    } else {
      d_a_of_r_com_a = NULL;
      if (*d_r == NULL)
	find_r_dual(g, fit_gra, *a, d_r);
      find_d_r_a_com_r(*d_r, *r, &d_r_of_a_com_r);
      s = d_r_of_a_com_r;
    }
    print_duals(false, false, fit_gra, g, *a, *r, *d_a, *d_r, d_a_of_r_com_a,
		d_r_of_a_com_r);
    fit(alfa_, g, fit_gra, false, &s, a, r, d_a, d_r, a_dual, !a_dual, &acc,
	&rej);
    dispose_g_c_list(&d_r_of_a_com_r);
    dispose_g_c_list(&d_a_of_r_com_a);
    print_models(false);
    stop = (a_dual && rej == 0 || !a_dual && acc == 0 || interrupt_3);
  }
}  /* rough_search_auto */


Static Void proc_search(code)
long *code;
{
  t_eh_pack *WITH;

  set_search_class(code);
  if (*code % 10 != 5)
    link_eh_pack->search_strategy = *code % 10;
  WITH = link_eh_pack;
  switch (WITH->search_strategy) {

  case 1:
    search_auto(&alfa_, WITH->g, &WITH->graphical_search, &WITH->a, &WITH->r,
		&WITH->d_a, &WITH->d_r);
    break;

  case 2:
    alter_search_auto(&alfa_, WITH->g, &WITH->graphical_search, &WITH->a,
		      &WITH->r, &WITH->d_a, &WITH->d_r);
    break;

  case 3:
    rough_search_auto(&alfa_, WITH->g, &WITH->graphical_search, &WITH->a,
		      &WITH->r, &WITH->d_a, &WITH->d_r);
    break;
  }
}  /* proc_search */


Static Void fit_size(smallest, alfa_, g, fit_gra, a, r, d_a, d_r)
boolean smallest;
double *alfa_;
long *g;
boolean *fit_gra;
t_g_c_list **a, **r, **d_a, **d_r;
{
  t_g_c_list *s, *d_a_of_r_com_a, *d_r_of_a_com_r, *p;
  t_long_integer rej, acc, choice;
  boolean r_dual;

  if (*d_a == NULL)
    find_a_dual(g, fit_gra, *r, d_a);
  if (*d_r == NULL)
    find_r_dual(g, fit_gra, *a, d_r);
  find_d_r_a_com_r(*d_r, *r, &d_r_of_a_com_r);
  find_d_a_r_com_a(*d_a, *a, &d_a_of_r_com_a);
  choice = 0;
  p = d_r_of_a_com_r;
  while (p != NULL) {
    choice++;
    p = p->pointer;
  }
  p = d_a_of_r_com_a;
  while (p != NULL) {
    choice--;
    p = p->pointer;
  }
  print_duals(true, false, fit_gra, g, *a, *r, *d_a, *d_r, d_a_of_r_com_a,
	      d_r_of_a_com_r);
  r_dual = (choice <= 0 && smallest || choice >= 0 && !smallest);
  if (r_dual)
    s = d_r_of_a_com_r;
  else
    s = d_a_of_r_com_a;
  fit(alfa_, g, fit_gra, false, &s, a, r, d_a, d_r, !r_dual, r_dual, &acc,
      &rej);
  dispose_g_c_list(&d_r_of_a_com_r);
  dispose_g_c_list(&d_a_of_r_com_a);
  print_models(false);
}  /* fit_size */


Static Void fit_a_dual(alfa_, g, fit_gra, a, r, d_a, d_r)
double *alfa_;
long *g;
boolean *fit_gra;
t_g_c_list **a, **r, **d_a, **d_r;
{
  t_g_c_list *d_a_of_r_com_a;
  t_long_integer rej, acc;

  if (*d_a == NULL)
    find_a_dual(g, fit_gra, *r, d_a);
  find_d_a_r_com_a(*d_a, *a, &d_a_of_r_com_a);
  fit(alfa_, g, fit_gra, false, &d_a_of_r_com_a, a, r, d_a, d_r, true, false,
      &acc, &rej);
  dispose_g_c_list(&d_a_of_r_com_a);
  print_models(false);
}  /* fit_a_dual */


Static Void fit_r_dual(alfa_, g, fit_gra, a, r, d_a, d_r)
double *alfa_;
long *g;
boolean *fit_gra;
t_g_c_list **a, **r, **d_a, **d_r;
{
  t_g_c_list *d_r_of_a_com_r;
  t_long_integer rej, acc;

  if (*d_r == NULL)
    find_r_dual(g, fit_gra, *a, d_r);
  find_d_r_a_com_r(*d_r, *r, &d_r_of_a_com_r);
  fit(alfa_, g, fit_gra, false, &d_r_of_a_com_r, a, r, d_a, d_r, false, true,
      &acc, &rej);
  dispose_g_c_list(&d_r_of_a_com_r);
  print_models(false);
}  /* fit_r_dual */


Static Void fit_both(alfa_, g, fit_gra, a, r, d_a, d_r)
double *alfa_;
long *g;
boolean *fit_gra;
t_g_c_list **a, **r, **d_a, **d_r;
{
  t_g_c_list *d_a_of_r_com_a, *d_r_of_a_com_r;
  t_long_integer rej, acc;

  if (*d_a == NULL)
    find_a_dual(g, fit_gra, *r, d_a);
  find_d_a_r_com_a(*d_a, *a, &d_a_of_r_com_a);
  if (*d_r == NULL)
    find_r_dual(g, fit_gra, *a, d_r);
  find_d_r_a_com_r(*d_r, *r, &d_r_of_a_com_r);
  fit(alfa_, g, fit_gra, false, &d_a_of_r_com_a, a, r, d_a, d_r, true, false,
      &acc, &rej);
  fit(alfa_, g, fit_gra, false, &d_r_of_a_com_r, a, r, d_a, d_r, false, true,
      &acc, &rej);
  dispose_g_c_list(&d_a_of_r_com_a);
  dispose_g_c_list(&d_r_of_a_com_r);
  print_models(false);
}  /* fit_both */


/*@-"describe.c"*/
/*@+"readsel.p"*/


Static Void insert_name_in_name_list(v, name_list)
t_vertex *v;
t_vertex_name_list **name_list;
{
  t_vertex_name_list *p;

  p = (t_vertex_name_list *)Malloc(sizeof(t_vertex_name_list));
  if (p == NULL)
    _OutMem();
  p->vertex = *v;
  p->pointer = *name_list;
  *name_list = p;
}  /* insert_name_in_name_list */


Static Void note_select(p1, p2)
double p1, p2;
{
  if (datastructure == list_file && p1 * 3 <= max_cell_number) {
    write_pch(stdout, " Choos datastructure or CoCo", 28L);
    write_pch(stdout, " will use computer-time", 23L);
    write_line(stdout);
    write_pch(stdout, " to do it when reading observations.", 36L);
    write_line(stdout);
    write_pch(stdout, " (if more than", 14L);
    write_integer(stdout, (long)floor(p1 / N_LIMIT_T / dimension + 0.5), 8L);
    write_pch(stdout, " cases then use SET DATASTRUCTURE NECESSARY",
		43L);
    write_line(stdout);
    write_pch(stdout, " between READ SPECIFICATION and READ OBSERVATIONS)",
		50L);
    write_line(stdout);
  }
  if (datastructure == all || p2 > max_cell_number)
    return;
  write_pch(stdout, " If model-search is going to be performed then use",
	      50L);
  write_line(stdout);
  write_pch(stdout, " SET DATASTRUCTURE ALL before READ OBSERVATIONS.",
	      48L);
  write_line(stdout);
}  /* note_select */


Static Void revers_vertex_name_list(p)
t_vertex_name_list **p;
{
  t_vertex_name_list *hp1, *hp2;

  hp1 = NULL;
  while (*p != NULL) {
    hp2 = hp1;
    hp1 = *p;
    *p = (*p)->pointer;
    hp1->pointer = hp2;
  }
  *p = hp1;
}  /* revers_vertex_name_list */


Static Void dispose_vertex_name_list(p)
t_vertex_name_list **p;
{
  t_vertex_name_list *q;

  while (*p != NULL) {
    q = (*p)->pointer;
    Free(*p);
    *p = q;
  }
}  /* dispose_vertex_name_list */


Static Void test_long_vertex_names()
{
  t_vertex_name_list *p_name_list, *q_name_list;
  t_integer i, count;

  q_name_list = full_name_list;
  while (q_name_list != NULL) {
    p_name_list = full_name_list;
    count = 0;
    while (p_name_list != NULL) {
      i = 1;
      while (q_name_list->name[i - PCH_START] ==
	     p_name_list->name[i - PCH_START] && i < p_name_list->length &&
	     i < q_name_list->length)
	i++;
      if (i == p_name_list->length && i == q_name_list->length &&
	  q_name_list->name[i - PCH_START] == p_name_list->name[i - PCH_START])
	count++;
      p_name_list = p_name_list->pointer;
    }
    if (count > 1) {
      write_pch(stdout, " Not unique factor name: `", 26L);
      write_pch(stdout, q_name_list->name, q_name_list->length);
      write_char(stdout, '\'');
      write_line(stdout);
    }
    q_name_list = q_name_list->pointer;
  }
}  /* test_long_vertex_names */


Static Void select_datastructure(init_select)
boolean init_select;
{
  t_vertex v;
  t_long_real p1, p2, p3, p4;
  t_vertex_name name;
  t_vertex_name_list *q_name_list;
  short TEMP;
  t_vertex FORLIM;

  dispose_all_models();
  fna = N_START - FIRST_INDEX;
  fpa = P_START - FIRST_INDEX;
  first_vertex = MIN_VERTEX;
  P_expset(full_names, 0L);
  for (TEMP = MIN_NAME; TEMP <= MAX_NAME; TEMP++) {
    name = TEMP;
    full_name_to_vertex[name - MIN_NAME] = MAX_VERTEX;
    name_to_vertex[name - MIN_NAME] = MAX_VERTEX;
  }
  p1 = 1.0;
  p2 = 1.0;
  p3 = 1.0;
  p4 = 1.0;
  if (long_names) {
    test_long_vertex_names();
    dispose_vertex_name_list(&name_list);
    q_name_list = full_name_list;
    while (q_name_list != NULL) {
      insert_name_in_name_list(&q_name_list->vertex, &name_list);
      name_list->length = q_name_list->length;
      memcpy(name_list->name, q_name_list->name, sizeof(pch_long));
      q_name_list = q_name_list->pointer;
    }
    revers_vertex_name_list(&name_list);
  }
  FORLIM = full_last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    if (init_select)
      full_vertex_inf[v - MIN_VERTEX].levels +=
	full_vertex_inf[v - MIN_VERTEX].levels_missing;
    full_vertex_inf[v - MIN_VERTEX].levels_total =
      full_vertex_inf[v - MIN_VERTEX].levels;
    vertex_inf[v - MIN_VERTEX] = full_vertex_inf[v - MIN_VERTEX];
    if (P_inset(full_vertex_inf[v - MIN_VERTEX].name, full_names) &&
	!long_names) {
      write_pch(stdout, " Warning: Duplicated name: ", 27L);
      write_char(stdout, full_vertex_inf[v - MIN_VERTEX].name);
      write_line(stdout);
    }
    P_addset(full_names, full_vertex_inf[v - MIN_VERTEX].name);
    full_name_to_vertex[full_vertex_inf[v - MIN_VERTEX].name - MIN_NAME] = v;
    name_to_vertex[vertex_inf[v - MIN_VERTEX].name - MIN_NAME] = v;
    full_last_cell[v - MIN_VERTEX] =
      FIRST_LEVEL + full_vertex_inf[v - MIN_VERTEX].levels - 1;
    last_cell[v - MIN_VERTEX] = FIRST_LEVEL + vertex_inf[v - MIN_VERTEX].levels - 1;
    first_cell[v - MIN_VERTEX] = FIRST_LEVEL;
    p1 *= vertex_inf[v - MIN_VERTEX].levels;
    p2 *= vertex_inf[v - MIN_VERTEX].levels + 1;
    p3 *= vertex_inf[v - MIN_VERTEX].levels -
	  vertex_inf[v - MIN_VERTEX].levels_missing;
    p4 *= vertex_inf[v - MIN_VERTEX].levels -
	  vertex_inf[v - MIN_VERTEX].levels_missing + 1;
  }
  hash_overflow = (p1 > max_cell_number);
  last_vertex = full_last_vertex;
  P_addsetr(P_expset(full_delta, 0L), first_vertex, full_last_vertex);
  P_setcpy(delta, full_delta);
  P_setcpy(subset, delta);
  P_setcpy(names, full_names);
  full_dimension = full_last_vertex - first_vertex + 1;
  dimension = full_dimension;
  link_select = NULL;
  link_reject = NULL;
  reject_missing = false;
  read_subset = false;
  if (p2 <= max_cell_number && dimension <= MAX_FIND_ALL)
    datastructure = all;
  else if (p1 * 3 <= max_cell_number && p1 <= N_LIMIT * N_LIMIT_T * dimension)
    datastructure = necessary;
  else
    datastructure = list_file;
#ifdef CoCo_Cygwin
#ifdef NO_LEVEL_FILE
  if (datastructure == list_file || datastructure == both) {
    datastructure = necessary; /* !?!?!? */
  }
#endif
#endif /* CoCo_Cygwin */
  if (term && diary)
    write_line_diary();
  note_select(p1, p2);
}  /* select_datastructure */


Static Void set_read_subset_argument(a)
long *a;
{
  t_vertex v, w;
  t_long_real p1, p2, p3, p4;
  t_vertex_name_list *q_name_list;
  t_vertex FORLIM;

  P_expset(ordinal_factors, 0L);
  ordinal_tests = false;
  P_setcpy(subset, a);
  dispose_all_models();
  dispose_set_list(&g_c_q_tables);
  dispose_offset_list(&q_tables_offsets);
  g_c_q_tables = NULL;
  q_tables_offsets = NULL;
  incomplete_table = false;
  fqa = Q_START - FIRST_INDEX;
  read_obs = false;
  note_command_end_line(stdout);
  w = first_vertex;
  fna = N_START - FIRST_INDEX;
  fpa = P_START - FIRST_INDEX;
  p1 = 1.0;
  p2 = 1.0;
  p3 = 1.0;
  p4 = 1.0;
  P_expset(names, 0L);
  FORLIM = full_last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    vertex_inf[v - MIN_VERTEX].levels = 0;
    vertex_inf[v - MIN_VERTEX].levels_total = 0;
    vertex_inf[v - MIN_VERTEX].levels_missing = 0;
    vertex_inf[v - MIN_VERTEX].name = '@';
  }
  if (long_names) {
    w = first_vertex;
    dispose_vertex_name_list(&name_list);
    q_name_list = full_name_list;
    while (q_name_list != NULL) {
      if (P_inset(q_name_list->vertex, subset)) {
	insert_name_in_name_list(&w, &name_list);
	name_list->length = q_name_list->length;
	memcpy(name_list->name, q_name_list->name, sizeof(pch_long));
	w++;
      }
      q_name_list = q_name_list->pointer;
    }
    revers_vertex_name_list(&name_list);
  }
  w = first_vertex;
  FORLIM = full_last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    if (P_inset(v, subset)) {
      vertex_inf[w - MIN_VERTEX] = full_vertex_inf[v - MIN_VERTEX];
      if (P_inset(vertex_inf[v - MIN_VERTEX].name, names) && !long_names) {
	write_pch(stdout, " Warning: Duplicated name: ", 27L);
	write_char(stdout, vertex_inf[v - MIN_VERTEX].name);
	write_line(stdout);
      }
      P_addset(names, vertex_inf[w - MIN_VERTEX].name);
      name_to_vertex[vertex_inf[w - MIN_VERTEX].name - MIN_NAME] = w;
      full_last_cell[w - MIN_VERTEX] =
	FIRST_LEVEL + full_vertex_inf[w - MIN_VERTEX].levels - 1;
      last_cell[w - MIN_VERTEX] = FIRST_LEVEL +
				  vertex_inf[w - MIN_VERTEX].levels - 1;
      first_cell[w - MIN_VERTEX] = FIRST_LEVEL;
      p1 *= vertex_inf[w - MIN_VERTEX].levels;
      p2 *= vertex_inf[w - MIN_VERTEX].levels + 1;
      p3 *= vertex_inf[w - MIN_VERTEX].levels -
	    vertex_inf[w - MIN_VERTEX].levels_missing;
      p4 *= vertex_inf[w - MIN_VERTEX].levels -
	    vertex_inf[w - MIN_VERTEX].levels_missing + 1;
      w++;
    }
  }
  hash_overflow = (p1 > max_cell_number);
  last_vertex = w - 1;
  if (last_vertex >= first_vertex)
    P_addsetr(P_expset(delta, 0L), first_vertex, last_vertex);
  else
    P_setcpy(delta, empty_set);
  dimension = last_vertex - first_vertex + 1;
  link_select = NULL;
  link_reject = NULL;
  reject_missing = false;
  read_subset = true;
  if (p2 <= max_cell_number && dimension <= MAX_FIND_ALL)
    datastructure = all;
  else if (p1 * 3 <= max_cell_number && p1 <= N_LIMIT * N_LIMIT_T * dimension)
    datastructure = necessary;
  else
    datastructure = list_file;
#ifdef CoCo_Cygwin
#ifdef NO_LEVEL_FILE
  if (datastructure == list_file || datastructure == both) {
    datastructure = necessary; /* !?!?!? */
  }
#endif
#endif /* CoCo_Cygwin */
  if (term && diary)
    write_line_diary();
  note_select(p1, p2);
}  /* set_read_subset_argument */


Static Void set_read_all()
{
  select_datastructure(false);
}  /* set_read_all */


Static Void proc_set_read_subset(command_file, as_argument, ifail, sub_code,
				 arg_pos, nargs, arg_char)
FILE *command_file;
boolean as_argument;
long *ifail, *sub_code, arg_pos;
long **nargs;
Char **arg_char;
{
  t_vertex_set a;
  t_long_integer i;

  if (*sub_code == 1) {
    select_datastructure(false);
    return;
  }
  P_setcpy(a, empty_set);
  i = PCH_START;
  if (get_vertex_set(command_file, true, true, true, as_argument, &i, ifail,
		     sub_code, arg_pos, nargs, arg_char, " SET->", 6L,
		     subset, a))
    set_read_subset_argument(a);
}  /* proc_set_read_subset */


Static Void get_cell_list(command_file, as_argument, ifail, sub_code,
			  arg_pos_char, arg_pos_int, nargs, arg_char, arg_int,
			  do_dispose, cell_list)
FILE *command_file;
boolean as_argument;
long *ifail, *sub_code, arg_pos_char, arg_pos_int;
long **nargs;
Char **arg_char;
long **arg_int;
boolean do_dispose;
t_cell_list **cell_list;
{
  t_cell_list *r;
  t_vertex_list *p;
  t_long_integer x, i;
  Char c;
  boolean ok;
  t_cell_list *WITH;

  if (do_dispose)
    dispose_cell_list(cell_list);
  r = (t_cell_list *)Malloc(sizeof(t_cell_list));
  if (r == NULL)
    _OutMem();
  r->pointer = *cell_list;
  *cell_list = r;
  WITH = *cell_list;
  WITH->vertex_list = NULL;
  i = PCH_START;
  ok = get_vertex_list(command_file, true, true, true, as_argument, &i, ifail,
		       sub_code, arg_pos_char, nargs, arg_char, " Set->",
		       6L, &WITH->vertex_list, &WITH->vertex_list);
  if (WITH->vertex_list == NULL)
    return;
  revers_vertex_list(&WITH->vertex_list);
  p = WITH->vertex_list;
  i = 0;
  while (p != NULL && *ifail == 0) {
    get_next_level(command_file, stdout, true, true, true, as_argument, &i,
		   ifail, sub_code, arg_pos_int, nargs, arg_int, " Level->",
		   8L, &x, &c, MAX_LEVEL, p->vertex);
    WITH->cell[p->vertex - MIN_VERTEX] = FIRST_LEVEL + x - 1;
    p = p->pointer;
  }
}  /* get_cell_list */


Static Void proc_select_reject(command_file, as_argument, ifail, sub_code,
			       arg_pos_char, arg_pos_int, nargs, arg_char,
			       arg_int)
FILE *command_file;
boolean as_argument;
long *ifail, *sub_code, arg_pos_char, arg_pos_int;
long **nargs;
Char **arg_char;
long **arg_int;
{
  switch (*sub_code) {

  case 96:
    get_cell_list(command_file, as_argument, ifail, sub_code, arg_pos_char,
		  arg_pos_int, nargs, arg_char, arg_int, true, &link_select);
    break;

  case 97:
    get_cell_list(command_file, as_argument, ifail, sub_code, arg_pos_char,
		  arg_pos_int, nargs, arg_char, arg_int, false, &link_select);
    break;

  case 98:
    get_cell_list(command_file, as_argument, ifail, sub_code, arg_pos_char,
		  arg_pos_int, nargs, arg_char, arg_int, true, &link_reject);
    break;

  case 99:
    get_cell_list(command_file, as_argument, ifail, sub_code, arg_pos_char,
		  arg_pos_int, nargs, arg_char, arg_int, false, &link_reject);
    break;
  }
  if (link_reject != NULL) {
    if (link_reject->pointer == NULL && link_reject->vertex_list == NULL)
      dispose_cell_list(&link_reject);
  }
}  /* proc_select_reject */


Static Void read_cutpoint(fil, c, ok)
FILE *fil;
Char *c;
boolean *ok;
{
  t_vertex v;
  t_long_integer i;
  t_long_real x;
  boolean do_read_cutpoints;

  read_vertex(fil, false, false, true, &v);
  if (full_vertex_inf[v - MIN_VERTEX].levels_total == 0)
    i = 0;
  else if (full_vertex_inf[v - MIN_VERTEX].levels_total == 1)
    i = 1;
  else
    i = 2;
  *c = ' ';
  *ok = true;
  if (cutpoints[v - MIN_VERTEX] != NULL) {
    do_read_cutpoints = false;
    write_pch(stdout, " Ignoring cutpoint for factor `", 31L);
    print_full_vertex_on_file(stdout, v);
    write_pch(stdout, "' on datafile", 13L);
    write_line(stdout);
  } else
    do_read_cutpoints = true;
  while (i <= full_vertex_inf[v - MIN_VERTEX].levels_total && *ok) {
    read_real_separator(fil, false, false, "1234567890", 0L, &x, c);
    if (x != _INVALID && x != MISSING && x != _UNDEF) {
      if (do_read_cutpoints)
	insert_real_in_real_list(x, &cutpoints[v - MIN_VERTEX]);
      i++;
      continue;
    }
    *ok = false;
    if (*c == 'C' || *c == 'c')
      write_pch(stdout, " To few cutpoints for factor `", 30L);
    else
      write_pch(stdout, " Invalid cutpoint for factor `", 30L);
    print_full_vertex_on_file(stdout, v);
    write_pch(stdout, "' on datafile", 13L);
    write_line(stdout);
  }
}  /* read_cutpoint */


Static Void proc_enter_cutpoints(command_file, as_argument, ifail, sub_code,
  arg_pos_char, arg_pos_double, nargs, arg_char, arg_double)
FILE *command_file;
boolean as_argument;
long *ifail, *sub_code, arg_pos_char, arg_pos_double;
long **nargs;
Char **arg_char;
double **arg_double;
{
  boolean eod;
  t_vertex v;
  t_long_integer i, j;
  t_long_real x;
  t_real_list *p;
  long FORLIM;

  eod = false;
  v = first_vertex;
  i = PCH_START;
  if (*sub_code == -1) {
    *sub_code = 1;
    if (!get_vertex(command_file, true, true, true, as_argument, &i, ifail,
		    sub_code, arg_pos_char, nargs, arg_char, " Factor->", 9L,
		    &v, &v)) {
      set_ifail(ifail, 80L);
      return;
    }
    if (cutpoints[v - MIN_VERTEX] == NULL) {
      set_ifail(ifail, 81L);
      return;
    }
    *sub_code = -1;
    j = 0;
    p = cutpoints[v - MIN_VERTEX];
    FORLIM = full_vertex_inf[v - MIN_VERTEX].levels_total;
    for (i = 1; i < FORLIM; i++) {
      get_next_long_real(command_file, as_argument, &j, ifail, sub_code,
			 arg_pos_double, nargs, arg_double, "", 0L,
			 &p->x);
      p = p->pointer;
    }
    return;
  }
  if (!get_vertex(command_file, true, true, true, as_argument, &i, ifail,
		  sub_code, arg_pos_char, nargs, arg_char, " Factor->", 9L,
		  &v, &v))
    return;
  if (cutpoints[v - MIN_VERTEX] != NULL)
    dispose_real_list(&cutpoints[v - MIN_VERTEX]);
  j = 0;
  FORLIM = full_vertex_inf[v - MIN_VERTEX].levels_total;
  for (i = 1; i < FORLIM; i++) {
    do {
      write_pch(stdout, " Cutpoint(", 10L);
      print_full_vertex_on_file(stdout, v);
      write_char(stdout, ',');
      write_integer(stdout, i, 3L);
      write_pch(stdout, ")-> ", 4L);
      x = _INVALID;
      get_next_long_real(command_file, as_argument, &j, ifail, sub_code,
			 arg_pos_double, nargs, arg_double, " Point.->", 9L,
			 &x);
      if (x != _INVALID && x != MISSING && x != _UNDEF)
	write_real(stdout, x, 10L, 3L);
      else
	write_pch(stdout, " Invalid  ", 10L);
      write_line(stdout);
      if (!as_argument)
	eod = eof_command(command_file);
    } while (!(x != _INVALID && x != MISSING && x != _UNDEF || *ifail != 0 ||
	       eod));
    insert_real_in_real_list(x, &cutpoints[v - MIN_VERTEX]);
  }
}  /* proc_enter_cutpoints */


Static Void skip_missing()
{
  t_vertex v, FORLIM;

  reject_missing = true;
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    vertex_inf[v - MIN_VERTEX].levels = vertex_inf[v - MIN_VERTEX].levels_total -
	vertex_inf[v - MIN_VERTEX].levels_missing;
    last_cell[v - MIN_VERTEX] = FIRST_LEVEL + vertex_inf[v - MIN_VERTEX].levels - 1;
  }
}  /* skip_missing */


/*@+"readini.p"*/


Static t_cell_index hash(i)
t_level *i;
{
  t_cell_index sum, product;
  t_vertex v, FORLIM;

  sum = FIRST_INDEX;
  product = 1;
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    sum += (i[v - MIN_VERTEX] - FIRST_LEVEL) * product;
    product *= vertex_inf[v - MIN_VERTEX].levels;
  }
  return sum;
}  /* hash */


Static Void init_datastructure()
{
  t_long_integer i;
  t_vertex v, FORLIM;
  t_long_real p1;
  long FORLIM1;

  if (exclude_missing)
    do_exclude(empty_set);
#ifdef CoCo_Cygwin
#ifdef NO_LEVEL_FILE
  if (datastructure == list_file || datastructure == both) {
    datastructure = necessary; /* !?!?!? */
  }
#endif
#endif /* CoCo_Cygwin */
  if (!datastructure_selected && datastructure != all) {
    p1 = 1.0;
    FORLIM = last_vertex;
    for (v = first_vertex; v <= FORLIM; v++)
      p1 *= vertex_inf[v - MIN_VERTEX].levels;
    if (p1 * 3 <= max_cell_number)
      datastructure = both;
  }
  n[0] = 0;
  if (datastructure == list_file || datastructure == both) {
    number_of_cells = 0;
    if (file_read_set) {
      reassign_tmp_level_file_write(&file_read, file_name_read);
      rewrite_level_file(file_read);
    } else {
      default_to_file_name(DEFAULT_TMP, file_name_read);
      assign_tmp_level_write(&file_read, file_name_read, &tmp_count);
      default_to_file_name(DEFAULT_TMP, file_name_excluded);
      assign_tmp_level_write(&file_excluded, file_name_excluded, &tmp_count);
      file_read_set = true;
    }
  }
  if (datastructure == all || datastructure == necessary ||
      datastructure == both) {
    number_of_cells = marginal_dimension(delta);
    fna = N_START - FIRST_INDEX + number_of_cells;
    if (number_of_cells < max_cell_number) {
      FORLIM1 = FIRST_INDEX + number_of_cells;
      for (i = FIRST_INDEX; i <= FORLIM1; i++)
	n[i] = 0;
    }
    if (dimension <= MAX_OFFSET_DIM)
      offset[(int)((long)floor(exp(log(2.0) * dimension) + 0.5)) - 1] =
	N_START - FIRST_INDEX;
    offset[0] = -FIRST_INDEX;
  }
  dispose_marginals();
}  /* init_datastructure */


Static Void close_datastructure()
{
  boolean dummy_ok;
  t_long_integer dummy;
  t_vertex v;
  t_long_real p1, t1, t2, t3, t4;
  t_vertex_set dummy_set;
  t_vertex FORLIM;

  if (datastructure == both) {
    p1 = 1.0;
    FORLIM = last_vertex;
    for (v = first_vertex; v <= FORLIM; v++)
      p1 *= vertex_inf[v - MIN_VERTEX].levels;
    if (p1 <= n[0] * N_LIMIT_T * dimension / 1000)
      datastructure = necessary;
    else if (p1 >= n[0] * N_LIMIT_T * dimension * 1000)
      datastructure = list_file;
    else {
      t1 = my_clock()/1;
      datastructure = necessary;
      dispose_marginals();
      P_addset(P_expset(dummy_set, 0L), first_vertex);
      dummy = find_marginal(dummy_set, &dummy_ok);
      t2 = my_clock()/1;
      write_line(stdout);
      write_pch(stdout, " Time(NECESSARY):   ", 20L);
      write_real(stdout, (t2 - t1) / 1000, 10L, 3L);
      write_pch(stdout, "secs.", 5L);
      t3 = my_clock()/1;
      datastructure = list_file;
      dispose_marginals();
      fna = N_START - FIRST_INDEX + number_of_cells;
      dummy = find_marginal(dummy_set, &dummy_ok);
      t4 = my_clock()/1;
      write_line(stdout);
      write_pch(stdout, " Time(FILE):        ", 20L);
      write_real(stdout, (t4 - t3) / 1000, 10L, 3L);
      write_pch(stdout, "secs.", 5L);
      if (t2 - t1 < t4 - t3)
	datastructure = necessary;
    }
    if (datastructure == necessary) {
      reassign_tmp_level_file_write(&file_read, file_name_read);
      rewrite_level_file(file_read);
    } else
      number_of_cells = 0;
    dispose_marginals();
  }
  space_for_case_list = (n[0] < max_cases_in_list_var);
  if (!(space_for_case_list && datastructure == list_file))
    return;
  /*$ifdef TRACE*/
  if (boolean_option[4]) {
    write_pch(stdout, " Making CASE-LIST   ", 20L);
    write_line(stdout);
  }
  /*$endif TRACE*/
  make_case_list();
}  /* close_datastructure */


Local boolean cell_equal(i, link)
t_level *i;
t_cell_list **link;
{
  boolean ok;
  t_vertex_list *link_vertex;
  t_vertex v;
  t_cell_list *WITH;

  ok = true;
  WITH = *link;
  link_vertex = WITH->vertex_list;
  while (ok && link_vertex != NULL) {
    v = link_vertex->vertex;
    ok = (i[v - MIN_VERTEX] == WITH->cell[v - MIN_VERTEX] ||
	  (i[v - MIN_VERTEX] >=
	   FIRST_LEVEL + full_vertex_inf[v - MIN_VERTEX].levels_total -
	   full_vertex_inf[v - MIN_VERTEX].levels_missing &&
	   WITH->cell[v - MIN_VERTEX] == MISSING_LEVEL));
    link_vertex = link_vertex->pointer;
  }
  return ok;
}  /* cell_equal */


Static boolean include(i)
t_level *i;
{
  boolean ok;
  t_vertex v;
  t_cell_list *link;
  t_vertex FORLIM;

  if (link_select != NULL) {
    ok = false;
    link = link_select;
    while (!ok && link != NULL) {
      ok = cell_equal(i, &link);
      link = link->pointer;
    }
  } else
    ok = true;
  link = link_reject;
  while (ok && link != NULL) {
    ok = !cell_equal(i, &link);
    link = link->pointer;
  }
  if (!reject_missing)
    return ok;
  FORLIM = full_last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    if (P_inset(v, subset))
      ok = (ok && i[v - MIN_VERTEX] <
		  FIRST_LEVEL + full_vertex_inf[v - MIN_VERTEX].levels_total -
		  full_vertex_inf[v - MIN_VERTEX].levels_missing);
  }
  return ok;
}  /* include */


Static boolean space_for_saturated_q_table(q)
t_offset_list **q;
{
  long index;
  boolean ok;
  long FORLIM;

  ok = true;
  if (!TURBO_PC)
    ok = space_in_q_array(marginal_dimension(delta), fqa);
  if (last_index(delta) > max_q_cell_number - fqa) {
    ok = false;
    return ok;
  }
  incomplete_table = true;
  insert_set_minimal(delta, &g_c_q_tables);
  insert_offset(delta, fqa, &q_tables_offsets);
  *q = q_tables_offsets;
  fqa += marginal_dimension(delta);
  FORLIM = (*q)->offset + last_index(delta);
  for (index = (*q)->offset; index <= FORLIM; index++)
    q_array[index] = 1;
  return ok;
}  /* space_for_saturated_q_table */


Static Void insert_structural_zero_cell(i)
t_level *i;
{
  t_offset_list *q;
  boolean ok;

  ok = true;
  if (incomplete_table) {
    q = q_tables_offsets;
    while (q->pointer != NULL && !P_setequal(q->vertex_set, delta))
      q = q->pointer;
    if (!P_setequal(q->vertex_set, delta))
      ok = space_for_saturated_q_table(&q);
  } else
    ok = space_for_saturated_q_table(&q);
  if (ok)
    q_array[q->offset + hash(i)] = 0;
  else {
    write_pch(stdout, " Structural table to large. ", 28L);
    write_line(stdout);
  }
}  /* insert_structural_zero_cell */


Static Void clear_structural_zero_cell(i)
t_level *i;
{
  t_offset_list *q;

  q = q_tables_offsets;
  while (q->pointer != NULL && !P_setequal(q->vertex_set, delta))
    q = q->pointer;
  if (P_setequal(q->vertex_set, delta)) {
    q_array[q->offset + hash(i)] = 1;
    return;
  }
  if (space_for_saturated_q_table(&q))
    q_array[q->offset + hash(i)] = 1;
  else {
    write_pch(stdout, " Structural table to large. ", 28L);
    write_line(stdout);
  }
}  /* clear_structural_zero_cell */


Static Void insert_cases_(i, count)
t_level *i;
t_cell_count count;
{
  t_cell_count j;
  t_vertex v, w;
  t_cell ii;
  t_vertex FORLIM;

  if (!include(i))
    return;
  if (datastructure == all || datastructure == necessary ||
      datastructure == both) {
    if (read_subset) {
      w = first_vertex;
      FORLIM = full_last_vertex;
      for (v = first_vertex; v <= FORLIM; v++) {
	if (P_inset(v, subset)) {
	  ii[w - MIN_VERTEX] = i[v - MIN_VERTEX];
	  w++;
	}
      }
      if (count != STRUCT_ZERO_COUNT) {
	if (incomplete_table) {
	  if (n[N_START - FIRST_INDEX + hash(ii)] == 0)
	    clear_structural_zero_cell(ii);
	}
	n[N_START - FIRST_INDEX + hash(ii)] += count;
      } else if (n[N_START - FIRST_INDEX + hash(ii)] == 0)
	insert_structural_zero_cell(ii);
    } else if (count != STRUCT_ZERO_COUNT)
      n[N_START - FIRST_INDEX + hash(i)] += count;
    else
      insert_structural_zero_cell(i);
  }
  if (datastructure == list_file || datastructure == both) {
    for (j = 1; j <= count; j++) {
      FORLIM = full_last_vertex;
      for (v = first_vertex; v <= FORLIM; v++) {
	if (P_inset(v, subset))
	  write_level_file(file_read, i[v - MIN_VERTEX]);
      }
    }
  }
  if (count != STRUCT_ZERO_COUNT)
    n[0] += count;
}  /* insert_cases */


/* Local variables for test_zero_data: */
struct LOC_test_zero_data {
  boolean noted;
} ;

Local Void note(LINK)
struct LOC_test_zero_data *LINK;
{
  if (LINK->noted)
    return;
  LINK->noted = true;
  write_pch(stdout, " *** WARNING *** Obs. in ZeroCells.  Use", 40L);
  write_pch(stdout, " `clean data' *** WARNING *** ", 30L);
  write_line(stdout);
}  /* note */


Static Void test_zero_data()
{
  struct LOC_test_zero_data Local_Var;
  t_long_integer index, case_number;
  t_cell i;
  t_vertex v;
  t_case_list *p_case_list;
  long FORLIM;
  t_vertex FORLIM1;

  Local_Var.noted = false;
  if (case_list != NULL) {
    p_case_list = case_list;
    FORLIM = n[0];
    for (index = 1; index <= FORLIM; index++) {
      if (zero_cell(p_case_list->cell, q_tables_offsets))
	note(&Local_Var);
      p_case_list = p_case_list->pointer;
    }
    return;
  }
  if (datastructure == list_file && !exclude_missing) {
    reset_level_file(file_read);
    FORLIM = n[0];
    for (case_number = 1; case_number <= FORLIM; case_number++) {
      FORLIM1 = last_vertex;
      for (v = first_vertex; v <= FORLIM1; v++)
	read_level_file(file_read, &i[v - MIN_VERTEX]);
      if (zero_cell(i, q_tables_offsets))
	note(&Local_Var);
    }
    return;
  }
  if (datastructure == list_file && exclude_missing) {
    reset_level_file(file_excluded);
    FORLIM = n[0];
    for (case_number = 1; case_number <= FORLIM; case_number++) {
      FORLIM1 = last_vertex;
      for (v = first_vertex; v <= FORLIM1; v++) {
	if (P_inset(v, delta_missing_excluded))
	  read_level_file(file_excluded, &i[v - MIN_VERTEX]);
      }
      if (zero_cell(i, q_tables_offsets))
	note(&Local_Var);
    }
    return;
  }
  memcpy(i, first_cell, sizeof(t_cell));
  FORLIM = last_index(delta);
  for (index = FIRST_INDEX; index <= FORLIM; index++) {
    if (zero_cell(i, q_tables_offsets) && n[N_START + index] != 0)
      note(&Local_Var);
    next_cell(i);
  }
}  /* test_zero_data */


Static Void clean_data()
{
  pch_long file_name;
  t_long_integer index, case_number;
  FILE *x_file;
  t_vertex v;
  t_cell i;
  boolean ok;
  t_case_list *p_case_list, *q_case_list;
  long FORLIM;
  t_vertex FORLIM1;

  x_file = NULL;
  dispose_all_expressions();
  dispose_tests();
  default_to_file_name(DEFAULT_TMP, file_name);
  assign_tmp_level_write(&x_file, file_name, &tmp_count);
  if (datastructure == list_file && !exclude_missing) {
    dispose_case_list(&case_list_read);
    case_list = NULL;
    reset_level_file(file_read);
    rewrite_level_file(x_file);
    FORLIM = n[0];
    for (case_number = 1; case_number <= FORLIM; case_number++) {
      FORLIM1 = last_vertex;
      for (v = first_vertex; v <= FORLIM1; v++)
	read_level_file(file_read, &i[v - MIN_VERTEX]);
      if (zero_cell(i, q_tables_offsets))
	n[0]--;
      else {
	FORLIM1 = last_vertex;
	for (v = first_vertex; v <= FORLIM1; v++)
	  write_level_file(x_file, i[v - MIN_VERTEX]);
      }
    }
    reassign_tmp_level_file_write(&file_read, file_name_read);
    rewrite_level_file(file_read);
    reset_level_file(x_file);
    FORLIM = n[0];
    for (case_number = 1; case_number <= FORLIM; case_number++) {
      FORLIM1 = last_vertex;
      for (v = first_vertex; v <= FORLIM1; v++) {
	read_level_file(x_file, &i[v - MIN_VERTEX]);
	write_level_file(file_read, i[v - MIN_VERTEX]);
      }
    }
    if (space_for_case_list) {
      /*$ifdef TRACE*/
      if (boolean_option[4]) {
	write_pch(stdout, " Making CASE-LIST   ", 20L);
	write_line(stdout);
      }
      /*$endif TRACE*/
      make_case_list();
    }
  } else if (datastructure == list_file && exclude_missing &&
	     case_list_excluded != NULL) {
    q_case_list = case_list_excluded;
    case_list = NULL;
    while (q_case_list != NULL) {
      if (zero_cell(q_case_list->cell, q_tables_offsets))
	n[0]--;
      else {
	p_case_list = (t_case_list *)Malloc(sizeof(t_case_list));
	if (p_case_list == NULL)
	  _OutMem();
	p_case_list->pointer = case_list;
	memcpy(p_case_list->cell, q_case_list->cell, sizeof(t_cell));
	case_list = p_case_list;
      }
      q_case_list = q_case_list->pointer;
    }
    dispose_case_list(&case_list_excluded);
    case_list_excluded = case_list;
  } else if (datastructure == list_file && exclude_missing) {
    reset_level_file(file_excluded);
    rewrite_level_file(x_file);
    FORLIM = n[0];
    for (case_number = 1; case_number <= FORLIM; case_number++) {
      FORLIM1 = last_vertex;
      for (v = first_vertex; v <= FORLIM1; v++) {
	if (P_inset(v, delta_missing_excluded))
	  read_level_file(file_excluded, &i[v - MIN_VERTEX]);
      }
      if (zero_cell(i, q_tables_offsets))
	n[0]--;
      else {
	FORLIM1 = last_vertex;
	for (v = first_vertex; v <= FORLIM1; v++)
	  write_level_file(x_file, i[v - MIN_VERTEX]);
      }
    }
    reassign_tmp_level_file_write(&file_excluded, file_name_excluded);
    rewrite_level_file(file_excluded);
    reset_level_file(x_file);
    FORLIM = n[0];
    for (case_number = 1; case_number <= FORLIM; case_number++) {
      FORLIM1 = last_vertex;
      for (v = first_vertex; v <= FORLIM1; v++) {
	if (P_inset(v, delta_missing_excluded)) {
	  read_level_file(x_file, &i[v - MIN_VERTEX]);
	  write_level_file(file_excluded, i[v - MIN_VERTEX]);
	}
      }
    }
  } else {
    memcpy(i, first_cell, sizeof(t_cell));
    FORLIM = last_index(delta);
    for (index = FIRST_INDEX; index <= FORLIM; index++) {
      if (zero_cell(i, q_tables_offsets)) {
	n[0] -= n[N_START + index];
	n[N_START + index] = 0;
      }
      next_cell(i);
    }
  }
  if (datastructure == all) {
    if (TURBO_PC)
      write_pch(stdout, " WAIT !! -", 10L);
    write_pch(stdout, " Finding all marginals.  ", 25L);
    if (exclude_missing)
      fna = N_START - FIRST_INDEX + number_of_cells +
	    marginal_dimension(delta_missing_excluded);
    else
      fna = N_START - FIRST_INDEX + number_of_cells;
    find_all_marginals(&ok);
  } else
    dispose_marginals();
  if (x_file != NULL)
    fclose(x_file);
}  /* clean_data */


/*@+"readspe.p"*/


Static Void read_factors(f)
FILE *f;
{
  t_vertex v;
  Char c;
  t_integer i;
  t_vertex FORLIM;

  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++)
    dispose_real_list(&cutpoints[v - MIN_VERTEX]);
  read_spec = true;
  read_obs = false;
  em = false;
  exclude_missing = false;
  term = (terminal || !strncmp(command_name, spec_name, sizeof(pch_long)));
  v = MIN_VERTEX;
  long_names = false;
  dispose_vertex_name_list(&full_name_list);
  do {
    seek_non_blank_data(f, false, false, &c);
    if (c == ':') {
      if (!long_names && v != MIN_VERTEX) {
	write_pch(stdout, " First factor name must start with `:', ", 40L);
	write_pch(stdout, "if long names are to be used.", 29L);
	write_line(stdout);
      } else
	long_names = true;
    }
    if (c != '/' && c != ';') {
      if (long_names) {
	if (c == ':')
	  read_char_data(f, &c);
	insert_name_in_name_list(&v, &full_name_list);
	i = 1;
	full_name_list->name[i - PCH_START] = c;
	full_vertex_inf[v - MIN_VERTEX].name = c;
	while ((c != ' ' && c != ':' && c != '/' && c != ';') &
	       (!eolnorf_data(f))) {
	  read_char_data(f, &c);
	  i++;
	  full_name_list->name[i - PCH_START] = c;
	}
	if (eolnorf_data(f) && c != ' ' && c != ':' && c != '/' && c != ';')
	  full_name_list->length = i;
	else
	  full_name_list->length = i - 1;
	while (eolnnotf_data(f))
	  read_line_data_plus(f);
      } else
	full_vertex_inf[v - MIN_VERTEX].name = c;
      read_level(f, &full_vertex_inf[v - MIN_VERTEX].levels, &c);
      if (full_vertex_inf[v - MIN_VERTEX].levels == _UNDEF_LEVEL ||
	  full_vertex_inf[v - MIN_VERTEX].levels == MISSING_LEVEL ||
	  full_vertex_inf[v - MIN_VERTEX].levels == _INVALID_LEVEL) {
	write_pch(stdout, " Invalid number of levels at ", 29L);
	print_full_vertex_on_file(stdout, v);
	full_vertex_inf[v - MIN_VERTEX].levels = 0;
	write_line(stdout);
      }
      if (c != '/' && c != ';') {
	if (c == '.' || c == '*')
	  full_vertex_inf[v - MIN_VERTEX].levels_missing = 1;
	else {
	  read_level(f, &full_vertex_inf[v - MIN_VERTEX].levels_missing, &c);
	  if (full_vertex_inf[v - MIN_VERTEX].levels_missing == _UNDEF_LEVEL)
	    full_vertex_inf[v - MIN_VERTEX].levels_missing = 0;
	  else if (full_vertex_inf[v - MIN_VERTEX].levels_missing ==
		   _INVALID_LEVEL) {
	    write_pch(stdout, " Invalid missing count at ", 26L);
	    print_full_vertex_on_file(stdout, v);
	    write_line(stdout);
	    full_vertex_inf[v - MIN_VERTEX].levels_missing = 0;
	  } else if (full_vertex_inf[v - MIN_VERTEX].levels_missing ==
		     MISSING_LEVEL)
	    full_vertex_inf[v - MIN_VERTEX].levels_missing = 1;
	}
	while (c != '/' && c != ';') {
	  if (eolnnotf_data(f))
	    read_line_data_plus(f);
	  else if (eof_data(f))
	    c = '/';
	  else
	    read_char_data(f, &c);
	}
      } else
	full_vertex_inf[v - MIN_VERTEX].levels_missing = 0;
      c = ' ';
      v++;
    }
  } while (c != '/' && c != ';' && v <= MAX_VERTEX);
  full_last_vertex = v - 1;
  revers_vertex_name_list(&full_name_list);
  if (c == '/' || c == ';')
    select_datastructure(true);
  else
    write_pch(stdout, " Too many factors", 17L);
}  /* read_factors */


Static Void new_enter_names(arg_pos_char, arg_pos_int, nargs, arg_char,
			    arg_int, ifail)
long arg_pos_char, arg_pos_int;
long **nargs;
Char **arg_char;
long **arg_int;
long *ifail;
{
  t_vertex v, FORLIM;
  t_integer i, j, length_names, n_levels, n_missing;
  long TEMP;

  if (!(ok_char_arg(ifail, arg_pos_char, 0L, nargs, arg_char) &
	ok_int_arg(ifail, arg_pos_int, 3L, nargs, arg_int)))
    return;
  length_names = (*arg_int)[0];
  n_levels = (*arg_int)[1];
  n_missing = (*arg_int)[2];
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++)
    dispose_real_list(&cutpoints[v - MIN_VERTEX]);
  read_spec = true;
  read_obs = false;
  em = false;
  exclude_missing = false;
  v = MIN_VERTEX;
  i = PCH_START;
  long_names = false;
  dispose_vertex_name_list(&full_name_list);
  while (i <= length_names && (*arg_char)[i - PCH_START] != '\0' &&
	 (*arg_char)[i - PCH_START] != ';' && v <= MAX_VERTEX) {
    /*$ifdef TRACE*/
    if (boolean_option[20]) {
      write_pch_10_text(stdout, " Enter  ", 8L);
      TEMP = 3;
      write_integer_text(stdout, i, &TEMP);
      write_char_text(stdout, ' ');
      write_char_text(stdout, (*arg_char)[i - PCH_START]);
      write_space_text(stdout, 2L);
      write_line_text(stdout);
    }
    /*$endif TRACE*/
    if ((*arg_char)[i - PCH_START] == ':') {
      if (!long_names && v != MIN_VERTEX) {
	write_pch(stdout, " First factor name must start with `:', ", 40L);
	write_pch(stdout, "if long names are to be used.", 29L);
	write_line(stdout);
      } else
	long_names = true;
    }
    if (long_names) {
      /*$ifdef TRACE*/
      if (boolean_option[20]) {
	write_pch_10_text(stdout, " Long  ", 7L);
	TEMP = 3;
	write_integer_text(stdout, i, &TEMP);
	write_char_text(stdout, ' ');
	write_char_text(stdout, (*arg_char)[i - PCH_START]);
	write_space_text(stdout, 2L);
	write_line_text(stdout);
      }
      /*$endif TRACE*/
      if ((*arg_char)[i - PCH_START] == ':')
	i++;
      insert_name_in_name_list(&v, &full_name_list);
      full_vertex_inf[v - MIN_VERTEX].name = (*arg_char)[i - PCH_START];
      j = 1;
      /*$ifdef TRACE*/
      if (boolean_option[20]) {
	write_pch_10_text(stdout, " Before ", 8L);
	TEMP = 3;
	write_integer_text(stdout, i, &TEMP);
	write_char_text(stdout, ' ');
	write_char_text(stdout, (*arg_char)[i - PCH_START]);
	write_space_text(stdout, 2L);
	write_line_text(stdout);
      }
      /*$endif TRACE*/
      while ((*arg_char)[i - PCH_START] != ' ' &&
	     (*arg_char)[i - PCH_START] != ':' &&
	     (*arg_char)[i - PCH_START] != ',' &&
	     i <= length_names && (*arg_char)[i - PCH_START] != '\0') {
	full_name_list->name[j - PCH_START] = (*arg_char)[i - PCH_START];
	j++;
	i++;
	/*$ifdef TRACE*/
	if (!boolean_option[20])
	  continue;
	/*$endif TRACE*/
	write_char_text(stdout, ' ');
	TEMP = 3;
	write_integer_text(stdout, i, &TEMP);
	write_char_text(stdout, ' ');
	write_char_text(stdout, (*arg_char)[i - PCH_START]);
	write_space_text(stdout, 2L);
	write_line_text(stdout);
      }
      /*$ifdef TRACE*/
      if (boolean_option[20])
	write_line_stdout();
      /*$endif TRACE*/
      /*$ifdef TRACE*/
      if (boolean_option[20]) {
	write_pch_10_text(stdout, " After @@ ", 8L);
	TEMP = 3;
	write_integer_text(stdout, i, &TEMP);
	write_char_text(stdout, ' ');
	write_char_text(stdout, (*arg_char)[i - PCH_START]);
	write_space_text(stdout, 2L);
	write_line_text(stdout);
      }
      /*$endif TRACE*/
      if (i <= length_names && (*arg_char)[i - PCH_START] != '\0')
	i++;
      /*$ifdef TRACE*/
      if (boolean_option[20]) {
	write_pch_10_text(stdout, " End     ", 9L);
	TEMP = 3;
	write_integer_text(stdout, i, &TEMP);
	write_char_text(stdout, ' ');
	write_char_text(stdout, (*arg_char)[i - PCH_START]);
	write_space_text(stdout, 2L);
	write_line_text(stdout);
      }
      /*$endif TRACE*/
      full_name_list->length = j - 1;
    } else {
      full_vertex_inf[v - MIN_VERTEX].name = (*arg_char)[i - PCH_START];
      i++;
    }
    v++;
  }
  revers_vertex_name_list(&full_name_list);
  full_last_vertex = v;
  v = MIN_VERTEX;
  for (i = 3; i <= n_levels + 2; i++) {
    full_vertex_inf[v - MIN_VERTEX].levels = (*arg_int)[i];
    full_vertex_inf[v - MIN_VERTEX].levels_missing = 0;
    if (full_vertex_inf[v - MIN_VERTEX].levels >= _INVALID_LEVEL ||
	full_vertex_inf[v - MIN_VERTEX].levels == _UNDEF_LEVEL ||
	full_vertex_inf[v - MIN_VERTEX].levels == _INVALID_LEVEL) {
      *ifail = 11;
      write_pch(stdout, " Invalid number of levels at ", 29L);
      print_full_vertex_on_file(stdout, v);
      write_line(stdout);
      full_vertex_inf[v - MIN_VERTEX].levels = 0;
    }
    v++;
  }
  if (v == full_last_vertex) {
    v = MIN_VERTEX;
    for (i = 3; i <= n_missing + 2; i++) {
      full_vertex_inf[v - MIN_VERTEX].levels_missing = (*arg_int)[n_levels + i];
      if (full_vertex_inf[v - MIN_VERTEX].levels_missing == MISSING_LEVEL)
	full_vertex_inf[v - MIN_VERTEX].levels_missing = 1;
      else if (full_vertex_inf[v - MIN_VERTEX].levels_missing == _UNDEF_LEVEL)
	full_vertex_inf[v - MIN_VERTEX].levels_missing = 0;
      else if (full_vertex_inf[v - MIN_VERTEX].levels_missing >= _INVALID_LEVEL) {
	/* or (full_vertex_inf[v].levels_missing < 0) */
	*ifail = 12;
	write_pch(stdout, " Invalid missing count at ", 26L);
	print_full_vertex_on_file(stdout, v);
	write_line(stdout);
	full_vertex_inf[v - MIN_VERTEX].levels_missing = 0;
      }
      v++;
    }
    full_last_vertex--;
    select_datastructure(true);
    return;
  }
  *ifail = 13;
  full_last_vertex = v - 1;
  write_pch(stdout, " Number of names and levels differs     ", 40L);
  write_line(stdout);
}  /* new_enter_names */


Static Void read_names(f)
FILE *f;
{
  t_vertex v;
  Char c;
  t_integer i;
  t_vertex FORLIM;

  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++)
    dispose_real_list(&cutpoints[v - MIN_VERTEX]);
  read_spec = true;
  read_obs = false;
  em = false;
  exclude_missing = false;
  term = (terminal || !strncmp(command_name, spec_name, sizeof(pch_long)));
  long_names = false;
  dispose_vertex_name_list(&full_name_list);
  v = MIN_VERTEX;
  do {
    seek_non_blank_data(f, false, false, &c);
    if (c == ':') {
      if (!long_names && v != MIN_VERTEX) {
	write_pch(stdout, " First factor name must start with `:', ", 40L);
	write_pch(stdout, "if long names are to be used.", 29L);
	write_line(stdout);
      } else
	long_names = true;
    }
    if (c != '/' && c != ';') {
      if (long_names) {
	if (c == ':')
	  read_char_data(f, &c);
	insert_name_in_name_list(&v, &full_name_list);
	i = 1;
	full_name_list->name[i - PCH_START] = c;
	full_vertex_inf[v - MIN_VERTEX].name = c;
	while ((c != ' ' && c != ':' && c != '/' && c != ';') &
	       (!eolnorf_data(f))) {
	  read_char_data(f, &c);
	  i++;
	  full_name_list->name[i - PCH_START] = c;
	}
	if (eolnorf_data(f) && c != ' ' && c != ':' && c != '/' && c != ';')
	  full_name_list->length = i;
	else
	  full_name_list->length = i - 1;
	while (eolnnotf_data(f))
	  read_line_data_plus(f);
      } else
	full_vertex_inf[v - MIN_VERTEX].name = c;
      v++;
    }
  } while (c != '/' && c != ';' && v <= MAX_VERTEX);
  revers_vertex_name_list(&full_name_list);
  full_last_vertex = v;
  if (c != '/' && c != ';') {
    full_last_vertex--;
    write_pch(stdout, " Too many factors", 17L);
    return;
  }
  v = MIN_VERTEX;
  do {
    read_level(f, &full_vertex_inf[v - MIN_VERTEX].levels, &c);
    full_vertex_inf[v - MIN_VERTEX].levels_missing = 0;
    if (full_vertex_inf[v - MIN_VERTEX].levels == _UNDEF_LEVEL ||
	full_vertex_inf[v - MIN_VERTEX].levels == MISSING_LEVEL ||
	full_vertex_inf[v - MIN_VERTEX].levels == _INVALID_LEVEL) {
      write_pch(stdout, " Invalid number of levels at ", 29L);
      print_full_vertex_on_file(stdout, v);
      write_line(stdout);
      full_vertex_inf[v - MIN_VERTEX].levels = 0;
      c = '/';
    } else
      v++;
  } while (c != '/' && c != ';' && v != full_last_vertex);
  if (v == full_last_vertex) {
    while (c != '/' && c != ';') {
      if (eoln_data(f))
	read_line_data_plus(f);
      else if (eof_data(f))
	c = ';';
      else
	read_char_data(f, &c);
    }
    v = MIN_VERTEX;
    do {
      read_level(f, &full_vertex_inf[v - MIN_VERTEX].levels_missing, &c);
      if (full_vertex_inf[v - MIN_VERTEX].levels_missing == MISSING_LEVEL)
	full_vertex_inf[v - MIN_VERTEX].levels_missing = 1;
      else if (full_vertex_inf[v - MIN_VERTEX].levels_missing == _UNDEF_LEVEL) {
	full_vertex_inf[v - MIN_VERTEX].levels_missing = 0;
	c = '/';
      } else if (full_vertex_inf[v - MIN_VERTEX].levels_missing ==
		 _INVALID_LEVEL) {
	write_pch(stdout, " Invalid missing count at ", 26L);
	print_full_vertex_on_file(stdout, v);
	write_line(stdout);
	full_vertex_inf[v - MIN_VERTEX].levels_missing = 0;
	c = '/';
      }
      v++;
    } while (c != '/' && c != ';' && v != full_last_vertex);
    full_last_vertex--;
    select_datastructure(true);
    return;
  }
  if (v > first_vertex)
    full_last_vertex = v - 1;
  write_pch(stdout, " More names than levels defined", 31L);
}  /* read_names */


Static Void proc_redefine_factor(command_file, as_argument, ifail, sub_code,
  arg_pos_char, arg_pos_int, nargs, arg_char, arg_int)
FILE *command_file;
boolean as_argument;
long *ifail, *sub_code, arg_pos_char, arg_pos_int;
long **nargs;
Char **arg_char;
long **arg_int;
{
  t_vertex v;
  t_level levels, levels_missing;
  Char c;
  t_long_integer i, x;

  v = first_vertex;
  i = PCH_START;
  c = '@';
  if (!get_vertex(command_file, true, true, true, as_argument, &i, ifail,
		  sub_code, arg_pos_char, nargs, arg_char, " Factor->", 9L,
		  &v, &v))
    return;
  read_obs = false;
  i = 0;
  get_next_level(command_file, stdout, true, true, true, as_argument, &i,
		 ifail, sub_code, arg_pos_int, nargs, arg_int, " Levels->",
		 9L, &x, &c, MAX_LEVEL, v);
  if (x == _INVALID_LEVEL || x == MISSING_LEVEL || x == _UNDEF_LEVEL) {
    write_pch(stdout, " Invalid number of levels at ", 29L);
    print_full_vertex_on_file(stdout, v);
    levels = 0;
    write_line(stdout);
  } else
    levels = x;
  if (c != '/' && c != ';') {
    if (c == '.' || c == '*')
      levels_missing = 1;
    else {
      get_next_level(command_file, stdout, true, true, true, as_argument, &i,
		     ifail, sub_code, arg_pos_int, nargs, arg_int,
		     " Missing->", 10L, &x, &c, MAX_LEVEL, v);
      if (x == _UNDEF_LEVEL || *ifail != 0)
	levels_missing = 0;
      else if (x == _INVALID_LEVEL) {
	write_pch(stdout, " Invalid missing count at ", 26L);
	print_full_vertex_on_file(stdout, v);
	levels_missing = 0;
      } else if (x == MISSING_LEVEL)
	levels_missing = 1;
      else
	levels_missing = x;
    }
  } else
    levels_missing = 0;
  if (levels == 0)
    return;
  full_vertex_inf[v - MIN_VERTEX].levels = levels + levels_missing;
  full_vertex_inf[v - MIN_VERTEX].levels_missing = levels_missing;
  /* Cutpoints ?? */
  select_datastructure(false);   /* => delta == subset */
  if (!P_subset(delta, subset))
    set_read_subset_argument(subset);
}  /* proc_redefine_factor */


/*@+"readobs.p"*/


Static Void read_count(f, count)
FILE *f;
t_cell_count *count;
{
  t_long_integer i;

  read_integer_data(f, false, false, &i);
  if (i == MISSING) {
    *count = _INVALID_COUNT;
    return;
  }
  if (i == _INVALID) {
    *count = _INVALID_COUNT;
    return;
  }
  if (i == _UNDEF) {
    *count = _UNDEF_COUNT;
    return;
  }
  if (i == STRUCT_ZERO || i == MISSING) {
    *count = STRUCT_ZERO_COUNT;
    return;
  }
  if ((unsigned long)i <= MAX_COUNT_NUMBER)
    *count = i;
  else
    *count = _INVALID_COUNT;
}  /* read_count */


Static Void x_to_cutpoint_level(x, level, v)
double x;
t_level *level;
t_vertex *v;
{
  t_real_list *p;

  if (x == MISSING || x == -1) {
    *level = MISSING_LEVEL;
    return;
  }
  if (x == _UNDEF) {
    *level = _UNDEF_LEVEL;
    return;
  }
  *level = FIRST_LEVEL + full_vertex_inf[*v - MIN_VERTEX].levels_total - 1;
  p = cutpoints[*v - MIN_VERTEX];
  while (p != NULL) {
    if (p->x < x)
      p = NULL;
    else {
      (*level)--;
      p = p->pointer;
    }
  }
}  /* x_to_cutpoint_level */


Static Void read_cutpoint_level(f, level, c, v)
FILE *f;
t_level *level;
Char *c;
t_vertex *v;
{
  t_long_real x;

  read_real_separator(f, false, false, "1234567890", 0L, &x, c);
  x_to_cutpoint_level(x, level, v);
}  /* read_cutpoint_level */


Static Void full_next_cell(i)
t_level *i;
{
  t_vertex v;

  v = first_vertex;
  while (i[v - MIN_VERTEX] ==
	 FIRST_LEVEL + full_vertex_inf[v - MIN_VERTEX].levels_total - 1 &&
	 v < full_last_vertex) {
    i[v - MIN_VERTEX] = FIRST_LEVEL;
    v++;
  }
  if (v == full_last_vertex &&
      i[v - MIN_VERTEX] ==
      FIRST_LEVEL + full_vertex_inf[v - MIN_VERTEX].levels_total - 1)
    i[v - MIN_VERTEX] = FIRST_LEVEL;
  else
    i[v - MIN_VERTEX]++;
}  /* full_next_cell */


Static Void note_last_read_data_line(data_file)
FILE *data_file;
{
  Char c;

  write_pch(stdout, " Total number of lines read on datafiles:",
	      41L);
  write_integer(stdout, data_line_number, 6L);
  write_line(stdout);
  write_pch(stdout, " Total number of observation lines read: ",
	      41L);
  write_integer(stdout, data_line_number - observation_line_number, 6L);
  write_line(stdout);
  write_pch(stdout, " Last read line on data file:", 29L);
  write_line(stdout);
  write_pch(stdout, " >", 2L);
  write_pch(stdout, last_data_line, data_line_position);
  write_line(stdout);
  if (eoln_data(data_file) || term)
    return;
  write_pch(stdout, " Skipping to EndOfLine on data file:  > ", 40L);
  while (!eolnorf_data(data_file)) {
    read_text_char(data_file, &c);
    if (log_on && log_data_on)
      write_char_text(log_file, c);
    write_char(stdout, c);
  }
  write_line(stdout);
}  /* note_last_read_data_line */


Static Void note_skip_case(i, term, as_argument, case_number, data_file)
t_level *i;
boolean *term, as_argument;
long *case_number;
FILE *data_file;
{
  t_vertex v, FORLIM;

  if (*term && diary && !as_argument)
    write_line_diary();
  write_pch(stdout, " Case number ", 13L);
  write_integer(stdout, *case_number, 10L);
  write_pch(stdout, " skipped.", 9L);
  write_line(stdout);
  FORLIM = full_last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    if (i[v - MIN_VERTEX] == MISSING_LEVEL &&
	full_vertex_inf[v - MIN_VERTEX].levels_missing == 0)
	  /* (i[v] < first_level) or */
	    write_pch(stdout, "  .", 3L);
    else if (i[v - MIN_VERTEX] == _INVALID_LEVEL)
      write_pch(stdout, "  ?", 3L);
    else
      write_integer(stdout, i[v - MIN_VERTEX] - FIRST_LEVEL + 1L, 3L);
    if (FIRST_LEVEL + full_vertex_inf[v - MIN_VERTEX].levels_total - 1 <
	i[v - MIN_VERTEX])
      write_char(stdout, '%');
    else
      write_char(stdout, ' ');
  }
  write_line(stdout);
  if (as_argument)
    return;
  note_last_read_data_line(data_file);
  if (*term && diary)
    write_pch_10_text(diary_file, " DATA->", 7L);
}  /* note_skip_case */


Static boolean end_of_data(as_argument, index, max_index, data_file)
boolean as_argument;
long *index, *max_index;
FILE *data_file;
{
  if (as_argument)
    return (*index >= *max_index);
  else
    return (eof_data(data_file));
}  /* end_of_data */


Static Void new_enter_table(arg_pos_int, nargs, arg_int, ifail, as_argument,
			    note_data, data_file)
long arg_pos_int;
long **nargs, **arg_int;
long *ifail;
boolean as_argument, note_data;
FILE *data_file;
{
  t_cell_count count;
  t_long_integer number_of_cells_expected, index, max_index;
  t_cell i;
  Char c;
  boolean ok;
  long TEMP;

  if (as_argument) {
    if (ok_int_arg(ifail, arg_pos_int, 2L, nargs, arg_int))
      max_index = (*nargs)[arg_pos_int];
  }
  /*$ifdef TRACE*/
  if (boolean_option[20]) {
    if (as_argument) {
      write_pch_20_text(stdout, " Max_index: ", 12L);
      TEMP = 3;
      write_integer_text(stdout, max_index, &TEMP);
      write_line_text(stdout);
    }
  }
  /*$endif TRACE*/
  dispose_all_expressions();
  dispose_tests();
  dispose_marginals();
  read_obs = true;
  term = (terminal || !strncmp(command_name, data_name, sizeof(pch_long)) ||
	  as_argument);
  ok = true;
  init_datastructure();
  index = 0;
  memcpy(i, first_cell, sizeof(t_cell));
  number_of_cells_expected = marginal_dimension_tf(full_delta, true, true);
  /*$ifdef TRACE*/
  if (boolean_option[20]) {
    if (as_argument) {
      write_pch_20_text(stdout, " Before WHILE", 13L);
      write_line_text(stdout);
    }
  }
  /*$endif TRACE*/
  while ((ok && index < number_of_cells_expected) &
	 (!end_of_data(as_argument, &index, &max_index, data_file))) {
    /*$ifdef TRACE*/
    if (boolean_option[20]) {
      if (as_argument) {
	write_pch_10_text(stdout, " In WHILE", 9L);
	write_line_text(stdout);
      }
    }
    /*$endif TRACE*/
    if (as_argument) {
      /*$ifdef TRACE*/
      if (boolean_option[20]) {
	write_pch_10_text(stdout, " Index: ", 8L);
	TEMP = 3;
	write_integer_text(stdout, index, &TEMP);
      }
      /*$endif TRACE*/
      count = (*arg_int)[index];
      /*$ifdef TRACE*/
      if (boolean_option[20]) {
	write_pch_10_text(stdout, " Count: ", 8L);
	TEMP = 3;
	write_cell_count_text(stdout, &count, &TEMP);
	write_line_text(stdout);
      }
      /*$endif TRACE*/
    } else
      read_count(data_file, &count);
    if ((count != _INVALID_COUNT && count != _UNDEF_COUNT &&
	 count < MAX_COUNT_NUMBER - n[0]) || count == STRUCT_ZERO_COUNT)
      insert_cases_(i, count);
    else
      ok = false;
    index++;
    full_next_cell(i);
  }
  if (term && diary && !as_argument)
    write_line_diary();
  if (!as_argument || note_data) {
    write_integer(stdout, index, 4L);
    write_pch(stdout, " cells with ", 12L);
    write_integer(stdout, n[0], 5L);
    write_pch(stdout, " cases read.", 12L);
    write_line(stdout);
  }
  if ((index < number_of_cells_expected) & end_of_data(as_argument, &index,
	&max_index, data_file)) {
    set_ifail(ifail, 16L);
    if (datastructure == all) {
      datastructure = necessary;
      dispose_marginals();
    }
    write_integer(stdout, number_of_cells_expected, 4L);
    write_pch(stdout, " cells expected.", 16L);
  } else {
    if (ok) {
      if (datastructure == all) {
	if (TURBO_PC)
	  write_pch(stdout, " WAIT !! -", 10L);
	if (!as_argument || note_data)
	  write_pch(stdout, " Finding all marginals.", 23L);
	find_all_marginals(&ok);
      }
    } else {
      if (datastructure == all) {
	datastructure = necessary;
	dispose_marginals();
      }
      if (count == _INVALID_COUNT || count == _UNDEF_COUNT) {
	set_ifail(ifail, 17L);
	write_pch(stdout, " Invalid count in last read cell.", 33L);
      } else {
	set_ifail(ifail, 18L);
	write_pch(stdout, " Too many observations.", 23L);
      }
    }
    if (!as_argument) {
      while (eolnnotf_data(data_file) && !term)
	read_line_data(data_file);
    }
    if (!end_of_data(as_argument, &index, &max_index, data_file) && !term) {
      write_line(stdout);
      write_pch(stdout, " Cells skipped:  ", 17L);
      write_line(stdout);
      write_line(stdout);
      if (as_argument) {
	while (index < max_index) {
	  /*$ifdef TRACE*/
	  if (boolean_option[20]) {
	    write_pch_10_text(stdout, " Index: ", 8L);
	    TEMP = 3;
	    write_integer_text(stdout, index, &TEMP);
	    write_pch_10_text(stdout, " Count: ", 8L);
	    TEMP = 3;
	    write_integer_text(stdout, (*arg_int)[index], &TEMP);
	    write_line_text(stdout);
	  }
	  /*$endif TRACE*/
	  write_integer(stdout, (*arg_int)[index], 5L);
	  write_line(stdout);
	  index++;
	}
      } else {
	while (!eof_data(data_file)) {
	  if (eoln_data(data_file)) {
	    read_text_ln(data_file);
	    if (log_on && log_data_on)
	      write_line_text(log_file);
	    write_line(stdout);
	  } else {
	    read_text_char(data_file, &c);
	    if (log_on && log_data_on)
	      write_char_text(log_file, c);
	    write_char(stdout, c);
	  }
	}
      }
    }
  }
  close_datastructure();
  if (incomplete_table) {
    write_line(stdout);
    test_zero_data();
  }
  if (as_argument && note_data)
    write_line(stdout);
}  /* new_enter_table */


Static Void read_table(data_file)
FILE *data_file;
{
  t_long_integer ifail;
  long *nargs, *arg_int;

  ifail = 0;
  nargs = NULL;
  arg_int = NULL;
  new_enter_table(0L, &nargs, &arg_int, &ifail, false, false, data_file);
}  /* read_table */


Static Void full_next_marginal_cell_list(p, i)
t_vertex_list *p;
t_level *i;
{
  if (p == NULL)
    return;
  while (i[p->vertex - MIN_VERTEX] ==
	 FIRST_LEVEL + full_vertex_inf[p->vertex - MIN_VERTEX].levels - 1 &&
	 p->pointer != NULL) {
    i[p->vertex - MIN_VERTEX] = FIRST_LEVEL;
    p = p->pointer;
  }
  if (p->pointer == NULL &&
      i[p->vertex - MIN_VERTEX] ==
      FIRST_LEVEL + full_vertex_inf[p->vertex - MIN_VERTEX].levels - 1)
    i[p->vertex - MIN_VERTEX] = FIRST_LEVEL;
  else
    i[p->vertex - MIN_VERTEX]++;
}  /* full_next_marginal_cell_list */


Static long full_cardinality(a)
long *a;
{
  t_vertex v, FORLIM;
  t_long_integer card;

  card = 0;
  FORLIM = full_last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    if (P_inset(v, a))
      card++;
  }
  return card;
}  /* full_cardinality */


Static boolean init_q_table(a, table, b, q, as_argument, data_file)
long *a;
boolean table;
long *b;
t_offset_list **q;
boolean as_argument;
FILE *data_file;
{
  Char c;
  boolean subset_of_existing, contains_existing, ok;
  long index;
  t_vertex v, w, FORLIM;
  long FORLIM1;

  dispose_all_expressions();
  dispose_tests();
  dispose_marginals();
  P_setcpy(b, empty_set);
  w = first_vertex;
  FORLIM = full_last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    if (P_inset(v, subset)) {
      if (P_inset(v, a))
	P_addset(b, w);
      w++;
    }
  }
  subset_of_existing = subset_of_an_edge(b, &g_c_q_tables);
  contains_existing = contains_an_edge(b, &g_c_q_tables);
  if (subset_of_existing && contains_existing) {
    *q = q_tables_offsets;
    while (!P_setequal((*q)->vertex_set, b))
      *q = (*q)->pointer;
    ok = true;
    if (term && diary)
      write_line_diary();
    if (table)
      write_pch(stdout, " Warning - Over-writing existing Q-table", 40L);
    else
      write_pch(stdout,
		  " Warning - Adding ZeroCells to an existing Q-table", 50L);
    write_line(stdout);
  } else {
    if (subset_of_existing) {
      if (term && diary)
	write_line_diary();
      write_pch(stdout, " Warning - Subset of an existing Q-table", 40L);
      write_line(stdout);
    }
    if (contains_existing) {
      if (term && diary)
	write_line_diary();
      write_pch(stdout, " Warning - Contains an existing Q-table", 39L);
      write_line(stdout);
    }
    if (!TURBO_PC)
      ok = space_in_q_array(marginal_dimension(b), fqa);
    ok = (last_index(b) <= max_q_cell_number - fqa);
    if (ok) {
      if (table) {
	FORLIM1 = fqa + last_index(b);
	for (index = fqa; index <= FORLIM1; index++)
	  q_array[index] = 0;
      } else {
	FORLIM1 = fqa + last_index(b);
	for (index = fqa; index <= FORLIM1; index++)
	  q_array[index] = 1;
      }
      insert_offset(b, fqa, &q_tables_offsets);
      *q = q_tables_offsets;
      fqa += marginal_dimension(b);
      insert_set_in_set_list(b, &g_c_q_tables);
    }
  }
  if (ok)
    return ok;
  write_pch(stdout, " Structural table to large.", 27L);
  write_line(stdout);
  if (as_argument)
    return ok;
  note_last_read_data_line(data_file);
  while (eolnnotf_data(data_file) && !term)
    read_line_data(data_file);
  if (!eof_data(data_file) && !term) {
    write_line(stdout);
    write_pch(stdout, " Cases skipped:  ", 17L);
    write_line(stdout);
    write_line(stdout);
    while (!eof_data(data_file) && c != ';' && c != '/') {
      if (eoln_data(data_file)) {
	read_text_ln(data_file);
	write_line(stdout);
      } else {
	read_text_char(data_file, &c);
	write_char(stdout, c);
      }
    }
  }
  write_line(stdout);
  return ok;
}  /* init_q_table */


Static Void enter_q_table(a, p, arg_int, max_index, as_argument, data_file)
long *a;
t_vertex_list *p;
long *arg_int;
long max_index;
boolean as_argument;
FILE *data_file;
{
  t_cell_count index, count;
  t_cell i;
  Char c;
  boolean ok;
  t_offset_list *q;
  t_vertex_set b;
  t_vertex v, w;
  t_cell ii;
  t_long_integer j, expected_number_off_cells;
  t_vertex FORLIM;

  term = (terminal || !strncmp(command_name, data_name, sizeof(pch_long)) ||
	  as_argument);
  if (init_q_table(a, true, b, &q, as_argument, data_file)) {
    ok = true;
    index = 1;
    j = 0;
    memcpy(i, first_cell, sizeof(t_cell));
    incomplete_table = true;
    expected_number_off_cells = marginal_dimension_tf(a, false, true);
    while ((ok && index <= expected_number_off_cells) &
	   (!end_of_data(as_argument, &j, &max_index, data_file))) {
      if (as_argument) {
	count = arg_int[j];
	j++;
      } else
	read_count(data_file, &count);
      if (count != _INVALID_COUNT && count != _UNDEF_COUNT ||
	  count == STRUCT_ZERO_COUNT) {
	if (count != STRUCT_ZERO_COUNT && count != 0) {
	  if (read_subset) {
	    w = first_vertex;
	    FORLIM = full_last_vertex;
	    for (v = first_vertex; v <= FORLIM; v++) {
	      if (P_inset(v, subset)) {
		ii[w - MIN_VERTEX] = i[v - MIN_VERTEX];
		w++;
	      }
	    }
	    q_array[q->offset + marginal_hash(b, ii)] += count;
	  } else
	    q_array[q->offset + marginal_hash(b, i)] = count;
	  if (count != 1)
	    initial_values_for_ips = true;
	}
      } else
	ok = false;
      index++;
      full_next_marginal_cell_list(p, i);
    }
    if (term && diary)
      write_line_diary();
    write_integer(stdout, index - 1, 4L);
    write_pch(stdout, " Q-cells read.", 14L);
    write_line(stdout);
    if (index < marginal_dimension_tf(full_delta, true, true)) {
      write_integer(stdout, expected_number_off_cells, 4L);
      write_pch(stdout, " cells expected.", 16L);
      write_line(stdout);
    }
    if (!ok) {
      write_pch(stdout, " Invalid count in last read cell.", 33L);
      write_line(stdout);
      if (!as_argument) {
	note_last_read_data_line(data_file);
	while (eolnnotf_data(data_file) && !term)
	  read_line_data(data_file);
	if (!eof_data(data_file) && !term) {
	  write_line(stdout);
	  write_pch(stdout, " Cells skipped:  ", 17L);
	  write_line(stdout);
	  write_line(stdout);
	  while (!eof_data(data_file) && c != ';' && c != '/') {
	    if (eoln_data(data_file)) {
	      read_text_ln(data_file);
	      write_line(stdout);
	    } else {
	      read_text_char(data_file, &c);
	      write_char(stdout, c);
	    }
	  }
	  write_line(stdout);
	}
      }
    }
  }
  if (initial_values_for_ips) {
    write_pch(stdout, " Initial values for IPS used.", 29L);
    write_line(stdout);
  }
  if (read_obs)
    test_zero_data();
}  /* enter_q_table */


Static Void get_case_q(arg_int, j, max_index, i, a, p, ok_case, end_file)
long **arg_int;
long *j, *max_index;
t_level *i;
long *a;
t_vertex_list *p;
boolean *ok_case, *end_file;
{
  t_vertex v, FORLIM;

  v = p->vertex;
  p = p->pointer;
  if (cutpoints[v - MIN_VERTEX] == NULL) {
    if ((*arg_int)[*j] == -1)
      i[v - MIN_VERTEX] = MISSING_LEVEL;
    else
      i[v - MIN_VERTEX] = FIRST_LEVEL + (*arg_int)[*j] - 1;
  } else
    x_to_cutpoint_level((double)(*arg_int)[*j], &i[v - MIN_VERTEX], &v);
  (*j)++;
  if (i[v - MIN_VERTEX] == MISSING_LEVEL)
    i[v - MIN_VERTEX] = FIRST_LEVEL + full_vertex_inf[v - MIN_VERTEX].levels_total -
			full_vertex_inf[v - MIN_VERTEX].levels_missing;
  if (i[v - MIN_VERTEX] == _UNDEF_LEVEL)
    *end_file = true;
  else {
    while (!*end_file && p != NULL) {
      v = p->vertex;
      p = p->pointer;
      if (cutpoints[v - MIN_VERTEX] == NULL) {
	if ((*arg_int)[*j] == -1)
	  i[v - MIN_VERTEX] = MISSING_LEVEL;
	else
	  i[v - MIN_VERTEX] = FIRST_LEVEL + (*arg_int)[*j] - 1;
      } else
	x_to_cutpoint_level((double)(*arg_int)[*j], &i[v - MIN_VERTEX], &v);
      (*j)++;
      if (i[v - MIN_VERTEX] == _UNDEF_LEVEL)
	*end_file = true;
      else if (i[v - MIN_VERTEX] == MISSING_LEVEL)
	i[v - MIN_VERTEX] = FIRST_LEVEL +
			    full_vertex_inf[v - MIN_VERTEX].levels_total -
			    full_vertex_inf[v - MIN_VERTEX].levels_missing;
    }
  }
  *ok_case = (p == NULL);
  FORLIM = full_last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    if (P_inset(v, a)) {   /* (i[v] < first_level) or */
      if (FIRST_LEVEL + full_vertex_inf[v - MIN_VERTEX].levels_total - 1 <
	  i[v - MIN_VERTEX])
	*ok_case = false;
    }
  }
}  /* get_case_q */


Static Void read_case_q(data_file, i, c, a, p, ok_case, end_file)
FILE *data_file;
t_level *i;
Char *c;
long *a;
t_vertex_list *p;
boolean *ok_case, *end_file;
{
  t_vertex v, FORLIM;

  v = p->vertex;
  p = p->pointer;
  if (cutpoints[v - MIN_VERTEX] == NULL)
    read_list_level(data_file,
		    full_vertex_inf[v - MIN_VERTEX].levels_total < 10,
		    &i[v - MIN_VERTEX], c);
  else
    read_cutpoint_level(data_file, &i[v - MIN_VERTEX], c, &v);
  if (i[v - MIN_VERTEX] == MISSING_LEVEL)
    i[v - MIN_VERTEX] = FIRST_LEVEL + full_vertex_inf[v - MIN_VERTEX].levels_total -
			full_vertex_inf[v - MIN_VERTEX].levels_missing;
  if (i[v - MIN_VERTEX] == _UNDEF_LEVEL)
    *end_file = true;
  else {
    while (!eof_data(data_file) && !*end_file && p != NULL) {
      v = p->vertex;
      p = p->pointer;
      if (cutpoints[v - MIN_VERTEX] == NULL)
	read_list_level(data_file,
			full_vertex_inf[v - MIN_VERTEX].levels_total < 10,
			&i[v - MIN_VERTEX], c);
      else
	read_cutpoint_level(data_file, &i[v - MIN_VERTEX], c, &v);
      if (i[v - MIN_VERTEX] == _UNDEF_LEVEL)
	*end_file = true;
      else if (i[v - MIN_VERTEX] == MISSING_LEVEL)
	i[v - MIN_VERTEX] = FIRST_LEVEL +
			    full_vertex_inf[v - MIN_VERTEX].levels_total -
			    full_vertex_inf[v - MIN_VERTEX].levels_missing;
    }
  }
  *ok_case = (p == NULL);
  FORLIM = full_last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    if (P_inset(v, a)) {   /* (i[v] < first_level) or */
      if (FIRST_LEVEL + full_vertex_inf[v - MIN_VERTEX].levels_total - 1 <
	  i[v - MIN_VERTEX])
	*ok_case = false;
    }
  }
}  /* read_case_q */


Static Void enter_q_list(a, p, arg_int, max_index, as_argument, data_file)
long *a;
t_vertex_list **p;
long *arg_int;
long max_index;
boolean as_argument;
FILE *data_file;
{
  Char c;
  boolean ok, ok_case, end_file;
  t_cell i, ii;
  t_cell_count index;
  t_offset_list *q;
  t_vertex v, w;
  t_vertex_set b;
  t_long_integer case_number, j;
  t_vertex FORLIM;

  term = (terminal || !strncmp(command_name, data_name, sizeof(pch_long)) ||
	  as_argument);
  if (init_q_table(a, false, b, &q, as_argument, data_file)) {
    ok = true;
    index = 1;
    memcpy(i, first_cell, sizeof(t_cell));
    incomplete_table = true;
    end_file = false;
    case_number = 1;
    j = 0;
    if (as_argument)
      get_case_q(&arg_int, &j, &max_index, i, a, *p, &ok_case, &end_file);
    else
      read_case_q(data_file, i, &c, a, *p, &ok_case, &end_file);
    while (!end_file) {
      if (ok_case) {
	if (read_subset) {
	  w = first_vertex;
	  FORLIM = full_last_vertex;
	  for (v = first_vertex; v <= FORLIM; v++) {
	    if (P_inset(v, subset)) {
	      ii[w - MIN_VERTEX] = i[v - MIN_VERTEX];
	      w++;
	    }
	  }
	  q_array[q->offset + marginal_hash(b, ii)] = 0;
	} else
	  q_array[q->offset + marginal_hash(b, i)] = 0;
      } else
	note_skip_case(i, &term, as_argument, &case_number, data_file);
      case_number++;
      if ((c == ';') | end_of_data(as_argument, &j, &max_index, data_file)) {
	end_file = true;
	break;
      }
      if (as_argument)
	get_case_q(&arg_int, &j, &max_index, i, a, *p, &ok_case, &end_file);
      else
	read_case_q(data_file, i, &c, a, *p, &ok_case, &end_file);
    }
    if (term && diary)
      write_line_diary();
    if (end_file | end_of_data(as_argument, &j, &max_index, data_file)) {
      write_integer(stdout, case_number - 1, 5L);
      write_pch(stdout, " cases read.", 12L);
      write_line(stdout);
    }
  }
  if (read_obs)
    test_zero_data();
}  /* enter_q_list */


Static Void read_q_table_data(fil)
FILE *fil;
{
  t_vertex_list *p;
  t_vertex_set a;

  p = NULL;
  read_vertex_list(fil, false, false, true, &p);
  list_of_vertices_to_set(p, a);
  revers_vertex_list(&p);
  enter_q_table(a, p, NULL, 0L, false, fil);
  dispose_vertex_list(&p);
}  /* read_q_table_data */


Static Void proc_enter_q_table(command_file, as_argument, ifail, sub_code,
			       arg_pos_char, arg_pos_int, nargs, arg_char,
			       arg_int)
FILE *command_file;
boolean as_argument;
long *ifail, *sub_code, arg_pos_char, arg_pos_int;
long **nargs;
Char **arg_char;
long **arg_int;
{
  Char sep;
  boolean tmp;
  t_vertex_set a;
  t_vertex_list *p;
  t_long_integer i;

  P_setcpy(a, empty_set);
  i = PCH_START;
  p = NULL;
  sep = ' ';
  if (!get_vertex_list_sep(command_file, true, true, true, as_argument, &sep,
			   &i, ifail, sub_code, arg_pos_char, nargs, arg_char,
			   " Set->", 6L, &p, &p))
    return;
  list_of_vertices_to_set(p, a);
  revers_vertex_list(&p);
  if (as_argument && *sub_code != 0)
    enter_q_table(a, p, *arg_int, (*nargs)[arg_pos_int], true, command_file);
  else {
    if (as_argument)
      read_line_data(command_file);
    note_command_end_line(stdout);
    tmp = terminal;
    terminal = true;
    term = true;
    if (as_argument)
      read_line_data(command_file);
    enter_q_table(a, p, NULL, 0L, false, command_file);
    terminal = tmp;
  }
  dispose_vertex_list(&p);
}  /* proc_enter_q_table */


Static Void read_q_list_data(fil)
FILE *fil;
{
  t_vertex_list *p;
  t_vertex_set a;

  p = NULL;
  read_vertex_list(fil, false, false, true, &p);
  list_of_vertices_to_set(p, a);
  revers_vertex_list(&p);
  enter_q_list(a, &p, NULL, 0L, false, fil);
  dispose_vertex_list(&p);
}  /* read_q_list_data */


Static Void proc_enter_q_list(command_file, as_argument, ifail, sub_code,
			      arg_pos_char, arg_pos_int, nargs, arg_char,
			      arg_int)
FILE *command_file;
boolean as_argument;
long *ifail, *sub_code, arg_pos_char, arg_pos_int;
long **nargs;
Char **arg_char;
long **arg_int;
{
  Char sep;
  boolean tmp;
  t_vertex_set a;
  t_vertex_list *p;
  t_long_integer i;

  P_setcpy(a, empty_set);
  i = PCH_START;
  p = NULL;
  sep = ' ';
  if (!get_vertex_list_sep(command_file, true, true, true, as_argument, &sep,
			   &i, ifail, sub_code, arg_pos_char, nargs, arg_char,
			   " Set->", 6L, &p, &p))
    return;
  list_of_vertices_to_set(p, a);
  revers_vertex_list(&p);
  if (as_argument && *sub_code != 0)
    enter_q_list(a, &p, *arg_int, (*nargs)[arg_pos_int], true, command_file);
  else {
    note_command_end_line(stdout);
    tmp = terminal;
    terminal = true;
    term = true;
    if (as_argument)
      read_line_data(command_file);
    enter_q_list(a, &p, NULL, 0L, false, command_file);
    terminal = tmp;
  }
  dispose_vertex_list(&p);
}  /* proc_enter_q_list */


Static Void get_case(arg_int, max_index, j, i, ok_case, end_of_list)
long **arg_int;
long *max_index, *j;
t_level *i;
boolean *ok_case, *end_of_list;
{
  t_vertex v, FORLIM;

  if (cutpoints[first_vertex - MIN_VERTEX] == NULL) {
    if ((*arg_int)[*j] > MAX_LEVEL)
      i[first_vertex - MIN_VERTEX] = _INVALID_LEVEL;
    else if ((*arg_int)[*j] == -1)
      i[first_vertex - MIN_VERTEX] = MISSING_LEVEL;
    else
      i[first_vertex - MIN_VERTEX] = FIRST_LEVEL + (*arg_int)[*j] - 1;
  } else
    x_to_cutpoint_level((double)(*arg_int)[*j], &i[first_vertex - MIN_VERTEX],
			&first_vertex);
  (*j)++;
  if (i[first_vertex - MIN_VERTEX] == MISSING_LEVEL) {
    if (full_vertex_inf[first_vertex - MIN_VERTEX].levels_missing > 0)
      i[first_vertex - MIN_VERTEX] = FIRST_LEVEL +
	  full_vertex_inf[first_vertex - MIN_VERTEX].levels_total -
	  full_vertex_inf[first_vertex - MIN_VERTEX].levels_missing;
    else
      i[first_vertex - MIN_VERTEX] = MISSING_LEVEL;
  }
  if (i[first_vertex - MIN_VERTEX] == _UNDEF_LEVEL)
    *end_of_list = true;
  else {
    v = first_vertex;
    while (*j < *max_index && !*end_of_list && v < full_last_vertex) {
      v++;
      if (cutpoints[v - MIN_VERTEX] == NULL) {
	if ((*arg_int)[*j] > MAX_LEVEL)
	  i[v - MIN_VERTEX] = _INVALID_LEVEL;
	else if ((*arg_int)[*j] == -1)
	  i[v - MIN_VERTEX] = MISSING_LEVEL;
	else
	  i[v - MIN_VERTEX] = FIRST_LEVEL + (*arg_int)[*j] - 1;
      } else
	x_to_cutpoint_level((double)(*arg_int)[*j], &i[v - MIN_VERTEX], &v);
      (*j)++;
      if (i[v - MIN_VERTEX] == _UNDEF_LEVEL)
	*end_of_list = true;
      else if (i[v - MIN_VERTEX] == MISSING_LEVEL) {
	if (full_vertex_inf[v - MIN_VERTEX].levels_missing > 0)
	  i[v - MIN_VERTEX] = FIRST_LEVEL +
			      full_vertex_inf[v - MIN_VERTEX].levels_total -
			      full_vertex_inf[v - MIN_VERTEX].levels_missing;
	else
	  i[v - MIN_VERTEX] = MISSING_LEVEL;
      }
    }
  }
  *ok_case = (v == full_last_vertex);
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {   /* (i[v] < first_level) or */
    if (FIRST_LEVEL + full_vertex_inf[v - MIN_VERTEX].levels_total - 1 <
	i[v - MIN_VERTEX])
      *ok_case = false;
  }
}  /* get_case */


Static Void read_case(data_file, i, c, ok_case, end_of_file)
FILE *data_file;
t_level *i;
Char *c;
boolean *ok_case, *end_of_file;
{
  t_vertex v, FORLIM;

  v = first_vertex;
  if (cutpoints[v - MIN_VERTEX] == NULL)
    read_list_level(data_file,
		    full_vertex_inf[v - MIN_VERTEX].levels_total < 10,
		    &i[v - MIN_VERTEX], c);
  else
    read_cutpoint_level(data_file, &i[v - MIN_VERTEX], c, &v);
  if (i[v - MIN_VERTEX] == MISSING_LEVEL) {
    if (full_vertex_inf[v - MIN_VERTEX].levels_missing > 0)
      i[v - MIN_VERTEX] = FIRST_LEVEL +
			  full_vertex_inf[v - MIN_VERTEX].levels_total -
			  full_vertex_inf[v - MIN_VERTEX].levels_missing;
    else
      i[v - MIN_VERTEX] = MISSING_LEVEL;
  }
  if (i[v - MIN_VERTEX] == _UNDEF_LEVEL)
    *end_of_file = true;
  else {
    while (!eof_data(data_file) && !*end_of_file && v < full_last_vertex) {
      v++;
      if (cutpoints[v - MIN_VERTEX] == NULL)
	read_list_level(data_file,
			full_vertex_inf[v - MIN_VERTEX].levels_total < 10,
			&i[v - MIN_VERTEX], c);
      else
	read_cutpoint_level(data_file, &i[v - MIN_VERTEX], c, &v);
      if (i[v - MIN_VERTEX] == _UNDEF_LEVEL)
	*end_of_file = true;
      else if (i[v - MIN_VERTEX] == MISSING_LEVEL) {
	if (full_vertex_inf[v - MIN_VERTEX].levels_missing > 0)
	  i[v - MIN_VERTEX] = FIRST_LEVEL +
			      full_vertex_inf[v - MIN_VERTEX].levels_total -
			      full_vertex_inf[v - MIN_VERTEX].levels_missing;
	else
	  i[v - MIN_VERTEX] = MISSING_LEVEL;
      }
    }
  }
  *ok_case = (v == full_last_vertex);
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {   /* (i[v] < first_level) or */
    if (FIRST_LEVEL + full_vertex_inf[v - MIN_VERTEX].levels_total - 1 <
	i[v - MIN_VERTEX])
      *ok_case = false;
  }
}  /* read_case */


Static Void new_enter_list(accumulated, arg_pos_int, nargs, arg_int, ifail,
			   as_argument, data_file)
boolean accumulated;
long arg_pos_int;
long **nargs, **arg_int;
long *ifail;
boolean as_argument;
FILE *data_file;
{
  boolean ok_case, local_end_of_data;
  t_cell i;
  Char c;
  t_long_integer case_number, n_of_cases, j, max_index;
  boolean dummy_ok;

  if (as_argument) {
    if (ok_int_arg(ifail, arg_pos_int, 0L, nargs, arg_int))
      max_index = (*nargs)[arg_pos_int];
  }
  dispose_all_expressions();
  dispose_tests();
  dispose_marginals();
  read_obs = true;
  term = (terminal || !strncmp(command_name, data_name, sizeof(pch_long)));
  j = 0;
  init_datastructure();
  local_end_of_data = false;
  case_number = 1;
  n_of_cases = 1;
  if (as_argument) {
    if (accumulated) {
      n_of_cases = (*arg_int)[j];
      j++;
    }
    get_case(arg_int, &max_index, &j, i, &ok_case, &local_end_of_data);
  } else {
    if (accumulated)
      read_integer_data(data_file, false, false, &n_of_cases);
    read_case(data_file, i, &c, &ok_case, &local_end_of_data);
  }
  while (!local_end_of_data && n[0] < MAX_COUNT_NUMBER) {
    if (ok_case)
      insert_cases_(i, n_of_cases);
    else
      note_skip_case(i, &term, as_argument, &case_number, data_file);
    if (as_argument) {
      if (c == ';' || j >= max_index) {
	local_end_of_data = true;
	break;
      }
      case_number++;
      if (accumulated) {
	n_of_cases = (*arg_int)[j];
	j++;
      }
      get_case(arg_int, &max_index, &j, i, &ok_case, &local_end_of_data);
      continue;
    }
    if ((c == ';') | eof_data(data_file)) {
      local_end_of_data = true;
      break;
    }
    case_number++;
    if (accumulated)
      read_integer_data(data_file, false, false, &n_of_cases);
    read_case(data_file, i, &c, &ok_case, &local_end_of_data);
  }
  if (term && diary && !as_argument)
    write_line_diary();
  if (datastructure == all) {
    if (TURBO_PC)
      write_pch(stdout, " WAIT !! -", 10L);
    write_pch(stdout, " Finding all marginals.", 23L);
    write_line(stdout);
    find_all_marginals(&dummy_ok);
  }
  if (local_end_of_data | end_of_data(as_argument, &j, &max_index, data_file)) {
    write_integer(stdout, n[0], 5L);
    write_pch(stdout, " cases read.", 12L);
    write_line(stdout);
  } else {
    write_pch(stdout, " Too many observations.", 23L);
    write_line(stdout);
    write_integer(stdout, n[0], 5L);
    write_pch(stdout, " cases read.", 12L);
    note_last_read_data_line(data_file);
  }
  close_datastructure();
  if (incomplete_table) {
    write_line(stdout);
    test_zero_data();
  }
}  /* new_enter_list */


Static Void read_list(data_file, accumulated)
FILE *data_file;
boolean accumulated;
{
  t_long_integer ifail;
  long *nargs, *arg_int;

  ifail = 0;
  nargs = NULL;
  arg_int = NULL;
  new_enter_list(accumulated, 0L, &nargs, &arg_int, &ifail, false, data_file);
}  /* read_list */


Local Void read_specifikations(spec_file)
FILE *spec_file;
{
  Char c;
  t_long_integer skip_count;
  boolean ok, noted;

  noted = false;
  skip_count = 0;
  term = (terminal || !strncmp(command_name, spec_name, sizeof(pch_long)));
  c = ' ';
  do {
    do {
      if (eolnnotf_data(spec_file))
	read_line_data(spec_file);
      else if (eof_data(spec_file))
	c = ';';
      else
	read_char_data(spec_file, &c);
    } while (c == ' ' || c == '\t');
    if (c == '#' || c == '%') {
      c = '@';
      while (!(eolnnotf_data(spec_file) || c == ';'))
	read_char_data(spec_file, &c);
      c = ' ';
    } else if (c == 'F' || c == 'f')
      ok = seek_word(spec_file, false, false, "Factors", 2L, 7L,
		     skip_count, true);
    else if (c == 'N' || c == 'n')
      ok = seek_word(spec_file, false, false, "Names", 2L, 5L,
		     skip_count, true);
    else if (c == ';')
      skip_word(spec_file, c, &skip_count, true);
    else {
      if (!noted) {
	write_pch(stdout, " Keyword `Names' or `Factors' expected", 38L);
	write_line(stdout);
	noted = true;
      }
      skip_word(spec_file, c, &skip_count, true);
      c = ' ';
    }
  } while (c != 'F' && c != 'f' && c != 'N' && c != 'n' && c != '@' &&
	   c != ';' && c != '/' && skip_count <= 10);
  if (skip_count > 10) {
    write_pch(stdout, " Given up skipping unrecognized keywords", 40L);
    write_line(stdout);
  }
  if (c == 'F' || c == 'f') {
    read_factors(spec_file);
    return;
  }
  if (c == 'N' || c == 'n') {
    read_names(spec_file);
    return;
  }
  write_pch(stdout, " NO FACTORS OR NAMES FOUND.", 27L);
  if (term && diary)
    write_line_diary();
}  /* read_specifikations */

Local Void read_data_file(data_file)
FILE *data_file;
{
  Char c, q_type;
  t_long_integer skip_count;
  boolean spec_end, noted, ok;

  noted = false;
  skip_count = 0;
  term = (terminal || !strncmp(command_name, data_name, sizeof(pch_long)));
  c = ' ';
  spec_end = true;
  do {
    do {
      if (spec_end && (c == ';' || c == '/')) {
	c = ' ';
	spec_end = false;
      }
      if (eolnnotf_data(data_file))
	read_line_data(data_file);
      else if (eof_data(data_file))
	c = '@';
      else
	read_char_data(data_file, &c);
    } while (spec_end && (c == ';' || c == '/') || c == ' ' || c == '\t');
    spec_end = false;
    if (c == 'C' || c == 'c') {
      do {
	ok = seek_word(data_file, false, false, "Cutpoint", 2L,
		       8L, skip_count, true);
	read_cutpoint(data_file, &c, &ok);
      } while (c == 'C' || c == 'c');
      if (c != 'T' && c != 't' && c != 'L' && c != 'l' && c != 'A' &&
	  c != 'a' && c != 'Q' && c != 'q' && c != '#' && c != '%' &&
	  c != '@')
	c = ':';
    }
    if (c != ';' && c != '/' && c != '@' && c != ':') {
      if (c == '#' || c == '%') {
	c = '@';
	while (!(eolnnotf_data(data_file) || c == ';'))
	  read_char_data(data_file, &c);
	c = ' ';
      } else if (c == 'Q' || c == 'q') {
	q_type = ' ';
	do {
	  do {
	    if (eolnnotf_data(data_file))
	      read_line_data(data_file);
	    else if (eof_data(data_file))
	      q_type = '@';
	    else
	      read_char_data(data_file, &q_type);
	  } while (q_type == ' ' || q_type == '\t');
	  if (q_type != '-' && q_type != '_') {
	    if (q_type == 'T' || q_type == 't')
	      ok = seek_word(data_file, false, false, "Q-Table",
			     4L, 7L, skip_count, true);
	    else if (q_type == 'L' || q_type == 'l')
	      ok = seek_word(data_file, false, false, "Q-List",
			     4L, 6L, skip_count, true);
	    else if (q_type == '@')
	      skip_word(data_file, q_type, &skip_count, true);
	    else {
	      if (!noted) {
		write_pch(stdout,
			    " Keyword `Q-Table' or `Q-List' expected", 39L);
		write_line(stdout);
		noted = true;
	      }
	      skip_word(data_file, q_type, &skip_count, true);
	      q_type = ' ';
	    }
	  }
	} while (q_type != 'L' && q_type != 'l' && q_type != 'T' &&
		 q_type != 't' && q_type != '@' && q_type != ';');
	if (q_type == 'L' || q_type == 'l')
	  read_q_list_data(data_file);
	else
	  read_q_table_data(data_file);
	spec_end = true;
	c = ' ';
	noted = false;
      } else if (c == 'T' || c == 't')
	ok = seek_word(data_file, false, false, "Table", 2L,
		       5L, skip_count, true);
      else if (c == 'L' || c == 'l')
	ok = seek_word(data_file, false, false, "List", 2L,
		       4L, skip_count, true);
      else if (c == 'A' || c == 'a')
	ok = seek_word(data_file, false, false, "Accumulated-list", 2L,
		       16L, skip_count, true);
      else {
	if (!noted) {
	  write_pch(stdout,
		      " Keyword `Table', `List', `Accumulated-list',",
		      45L);
	  write_line(stdout);
	  write_pch(stdout,
		      " `Q-Table', `Q-List' or `Cutpoints' expected",
		      44L);
	  write_line(stdout);
	  noted = true;
	}
	skip_word(data_file, c, &skip_count, true);
	c = ' ';
      }
    }
  } while (c != 'T' && c != 't' && c != 'L' && c != 'l' && c != 'A' &&
	   c != 'a' && c != '@' && c != ';' && c != '/' && skip_count <= 10);
  if (skip_count > 10) {
    write_pch(stdout, " Given up skipping unrecognized keywords", 40L);
    write_line(stdout);
  }
  if (c == 'T' || c == 't') {
    read_table(data_file);
    return;
  }
  if (c == 'L' || c == 'l') {
    read_list(data_file, false);
    return;
  }
  if (c == 'A' || c == 'a')
    read_list(data_file, true);
  else
    write_pch(stdout, " NO DATA FOUND.", 15L);
}  /* read_data_file */


/*@+"read.p"*/


Static Void read_data(command_file, choice)
FILE *command_file;
long *choice;
{
  observation_line_number = data_line_number;
  if (diary &&
      (terminal || !strncmp(command_name, spec_name, sizeof(pch_long))))
    write_char_text(diary_file, ' ');
  if (!terminal &&
      (strncmp(command_name, spec_name, sizeof(pch_long)) ||
       *choice != 2 && *choice != 3 && *choice != 4 && *choice != 1) &&
      (strncmp(command_name, data_name, sizeof(pch_long)) ||
       *choice != 5 && *choice != 6 && *choice != 7) && log_on &&
      log_data_on) {
    write_line_text(log_file);
    write_pch_10_text(log_file, "#Data: ", 7L);
  }
  switch (*choice) {

  case 2:
    if (!strncmp(command_name, spec_name, sizeof(pch_long)) || terminal)
      read_specifikations(command_file);
    else
      read_specifikations(spec_file);
    break;

  case 3:
    if (!strncmp(command_name, spec_name, sizeof(pch_long)) || terminal)
      read_factors(command_file);
    else
      read_factors(spec_file);
    break;

  case 4:
    if (!strncmp(command_name, spec_name, sizeof(pch_long)) || terminal)
      read_names(command_file);
    else
      read_names(spec_file);
    break;

  case 5:
    if (!strncmp(command_name, data_name, sizeof(pch_long)) || terminal)
      read_data_file(command_file);
    else if (!strncmp(data_name, spec_name, sizeof(pch_long)))
      read_data_file(spec_file);
    else
      read_data_file(data_file);
    break;

  case 6:
    if (!strncmp(command_name, data_name, sizeof(pch_long)) || terminal)
      read_table(command_file);
    else if (!strncmp(data_name, spec_name, sizeof(pch_long)))
      read_table(spec_file);
    else
      read_table(data_file);
    break;

  case 7:
    if (!strncmp(command_name, data_name, sizeof(pch_long)) || terminal)
      read_list(command_file, false);
    else if (!strncmp(data_name, spec_name, sizeof(pch_long)))
      read_list(spec_file, false);
    else
      read_list(data_file, false);
    break;

  case 1:
    if (!strncmp(command_name, spec_name, sizeof(pch_long)) || terminal)
      read_specifikations(command_file);
    else
      read_specifikations(spec_file);
    if (!terminal && strncmp(command_name, data_name, sizeof(pch_long)) &&
	log_on && log_data_on) {
      write_line_text(log_file);
      write_pch_10_text(log_file, "#Data: ", 7L);
    }
    observation_line_number = data_line_number;
    if (read_spec) {
      if (!strncmp(command_name, data_name, sizeof(pch_long)) || terminal)
	read_data_file(command_file);
      else if (!strncmp(data_name, spec_name, sizeof(pch_long)))
	read_data_file(spec_file);
      else
	read_data_file(data_file);
    }
    break;
  }
}  /* read_data */


Static Void proc_enter_data(command_file, code, as_argument, ifail, sub_code,
			    arg_pos_char, arg_pos_int, nargs, arg_char,
			    arg_int)
FILE *command_file;
long code;
boolean as_argument;
long *ifail, *sub_code, arg_pos_char, arg_pos_int;
long **nargs;
Char **arg_char;
long **arg_int;
{
  boolean ok;

  if (as_argument && *sub_code != 0) {
    switch (code) {

    case 1:
      set_ifail(ifail, 73L);
      break;

    case 2:
      set_ifail(ifail, 73L);
      break;

    case 3:
      set_ifail(ifail, 73L);
      break;

    case 4:
      new_enter_names(arg_pos_char, arg_pos_int, nargs, arg_char, arg_int,
		      ifail);
      break;

    case 5:
      set_ifail(ifail, 73L);
      break;

    case 6:
      new_enter_table(arg_pos_int, nargs, arg_int, ifail, *sub_code != 0,
		      *sub_code == 1, command_file);
      break;

    case 7:
      new_enter_list(*sub_code == 2, arg_pos_int, nargs, arg_int, ifail,
		     *sub_code != 0, command_file);
      break;
    }
    return;
  }
  if (as_argument) {
    term = true;
    if (terminal || !strncmp(command_name, spec_name, sizeof(pch_long)))
      read_line_data(command_file);
  }
  if (!terminal && code <= 4 && !spec_file_set) {
    default_to_file_name(DEFAULT_SPECIFICATION, spec_name);
    assign_read_cocolib(&spec_file, spec_name, &ok);
    if (code == 1)
      memcpy(data_name, spec_name, sizeof(pch_long));
    if (!ok)
      write_file_not_found(stdout, spec_name);
    else
      spec_file_set = true;
  } else if (!terminal && code >= 5 &&
	     strncmp(data_name, spec_name, sizeof(pch_long)) &&
	     !data_file_set) {
    default_to_file_name(DEFAULT_OBSERVATION, data_name);
    assign_read_cocolib(&data_file, data_name, &ok);
    if (!ok)
      write_file_not_found(stdout, data_name);
    else
      data_file_set = true;
  }
  read_data(command_file, &code);
}  /* proc_enter_data */


Static Void return_model_set(ifail, sub_code, arg_pos_char, nargs, arg_char)
long *ifail, *sub_code, arg_pos_char;
long **nargs;
Char **arg_char;
{
  boolean dummy;
  t_vertex_set a;
  t_long_integer i;
  t_model_list *p;

  sub_code_to_model(ifail, sub_code, &p);
  if (p == NULL) {
    set_ifail(ifail, 20L);
    return;
  }
  i = PCH_START;
  *sub_code = -1;
  P_setcpy(a, empty_set);
  dummy = get_vertex_set(stdin, true, true, true, true, &i, ifail, sub_code,
			 arg_pos_char, nargs, arg_char, "", 10L,
			 p->model.model_set, a);
}  /* return_model_set */


Static Void return_model_set_integer(ifail, sub_code, arg_pos_int, nargs,
				     arg_int)
long *ifail, *sub_code, arg_pos_int;
long **nargs, **arg_int;
{
  t_vertex v;
  t_long_integer i, x;
  t_model_list *p;
  t_vertex FORLIM;

  sub_code_to_model(ifail, sub_code, &p);
  if (p == NULL) {
    set_ifail(ifail, 20L);
    return;
  }
  i = 0;
  *sub_code = -1;
  FORLIM = last_vertex;
  for (v = first_vertex; v <= FORLIM; v++) {
    if (P_inset(v, p->model.model_set))
      x = 1;
    else
      x = 0;
    get_next_integer(stdin, true, &i, ifail, sub_code, arg_pos_int, nargs,
		     arg_int, "", 0L, &x);
  }
  (*nargs)[arg_pos_int] = i;
}  /* return_model_set_integer */


Static Void return_names(ifail, sub_code, arg_pos_char, nargs, arg_char)
long *ifail, *sub_code, arg_pos_char;
long **nargs;
Char **arg_char;
{
  boolean full, dummy;
  t_vertex_set a;
  t_long_integer i;

  i = PCH_START;
  full = (*sub_code == 2);
  if (full)
    P_setcpy(a, full_delta);
  else
    P_setcpy(a, delta);
  *sub_code = -1;
  dummy = get_vertex_set(stdin, true, true, full, true, &i, ifail, sub_code,
			 arg_pos_char, nargs, arg_char, "", 10L, a,
			 a);
}  /* return_names */


Static Void return_levels(ifail, sub_code, arg_pos_int, nargs, arg_int)
long *ifail, *sub_code, arg_pos_int;
long **n