% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.clustvar.R
\name{predict.clustvar}
\alias{predict.clustvar}
\title{Scores of new objects on the synthetic variables of a given partition}
\usage{
\method{predict}{clustvar}(object, X.quanti = NULL, X.quali = NULL, ...)
}
\arguments{
\item{object}{an object of class clustvar}

\item{X.quanti}{numeric matrix of data for the new objects}

\item{X.quali}{a categorical matrix of data for the new objects}

\item{\dots}{Further arguments to be passed to or from other methods. They are ignored in this function.}
}
\value{
Returns the matrix of the scores of the new objects on the k syntetic variables of the k-clusters partition given in input.
}
\description{
A partition of variables obtained with kmeansvar or with cutreevar is given in input.
Each cluster of this partition is associated with a synthetic variable which is a linear combination of the variables of the cluster.
The coefficients of these k linear combinations (one for each cluster) are used here to calculate new scores of a objects described in a new dataset (with the same variables).
The output is the matrix of the scores of these new objects on the k synthetic variables.
}
\examples{
data(wine)
n <- nrow(wine)
sub <- 10:20
data.sub <- wine[sub,] #learning sample
X.quanti <- wine[sub,c(3:29)] #learning sample
X.quali <- wine[sub,c(1,2)]
part <-kmeansvar(X.quanti, X.quali, init=5)
X.quanti.t <- wine[-sub,c(3:29)]
X.quali.t <- wine[-sub,c(1,2)]
new <- predict(part,X.quanti.t,X.quali.t)
}
