% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.clustab.R
\name{plot.clustab}
\alias{plot.clustab}
\title{Plot of an index of stability of partitions of variables}
\usage{
\method{plot}{clustab}(x, nmin = NULL, nmax = NULL, ...)
}
\arguments{
\item{x}{an object of class \code{clustab}.}

\item{nmin}{the minimum number of clusters in the plot.}

\item{nmax}{the maximum number of clusters in the plot.}

\item{\dots}{further arguments passed to or from other methods.}
}
\description{
Plot of the index of stability of the partitions against the number of
clusters.
}
\examples{
data(decathlon)
tree <- hclustvar(X.quanti=decathlon[,1:10])
stab<-stability(tree,B=20)
plot(stab,nmax=7)

}
\seealso{
\code{\link{stability}}
}
