% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ClustMMDD.R
\name{selectK.R}
\alias{selectK.R}
\title{
  Selection of the number \eqn{K} of clusters.
}
\usage{
selectK.R(xdata, S, Kmax, ploidy = 1, Kmin = 1,
  emOptions = list(epsi = 1e-05, nberSmallEM = 20, nberIterations = 15,
  nberMaxIterations = 5000, typeSmallEM = 0, typeEM = 0, putThreshold = FALSE),
  cte = 1, project = deparse(substitute(xdata)))
}
\arguments{
\item{xdata}{A dataset in which data of each variable are in \eqn{ploidy} column(s).}

\item{S}{A subset of clustering variables on the form of logical vector of the same length P as the number of variables in \code{xdata}.}

\item{Kmax}{The maximum number of clusters to be explored.}

\item{ploidy}{The number of occurrences for each variable in the data. For example, \eqn{ploidy = 2} for genotype}

\item{Kmin}{The minimum number of clusters to be explored. The default value is set to 1.}

\item{emOptions}{A list of EM options (see \code{\link{EmOptions}} and \code{\link{setEmOptions}}).}

\item{cte}{A double used for the selection criterion named \code{CteDim} in which the penalty function is
    \eqn{pen(K,S)=cte*dim}, where \code{dim} is the number of free parameters.}
    
\item{project}{The name of the project. The default value is the name of the dataset.}
}
\value{
A list of estimated paramaters for each selection criteria.
}
\description{
Perform a selection of the number \eqn{K} of clusters for a given subset \eqn{S} of clustering variables.
}
\examples{
data(genotype1)
head(genotype1)
genotype2 = cutEachCol(genotype1[, -11], ploidy = 2)
head(genotype2)
S = c(rep(TRUE, 8), rep(FALSE, 2))
\dontrun{
outPut = selectK.R(genotype2, S, Kmax = 6, ploidy = 2, Kmin=1)
outPut[["BIC"]]

file.remove("genotype2_ExploredModels.txt")
}}
\author{
Wilson Toussile
}
\references{
\itemize{
		\item  \href{http://projecteuclid.org/euclid.ejs/1379596773}{Dominique Bontemps and Wilson Toussile (2013)} : Clustering and variable selection for categorical multivariate data. Electronic Journal of Statistics, Volume 7, 2344-2371, ISSN.
		
		\item 	\href{http://link.springer.com/article/10.1007\%2Fs11634-009-0043-x}{Wilson Toussile and Elisabeth Gassiat (2009)} : Variable	selection in model-based clustering using multilocus genotype data. Adv Data Anal Classif, Vol 3, number 2, 109-134.
	}
}
\seealso{
\code{\link{backward.explorer}} for more exploration of the competing models space, \code{\link{dimJump.R}}
	for data driven calibration of the penality function, and \code{\link{model.selection.R}} for model selection.
}
\keyword{Unsupervized classification}
\keyword{Clustering}
\keyword{EM}
\keyword{SEM}
\keyword{CEM}

