% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability-based-parameter-assessment.R
\name{plot_k_resolution_corresp}
\alias{plot_k_resolution_corresp}
\title{Correspondence Between Resolution and the Number of Clusters}
\usage{
plot_k_resolution_corresp(
  res_object_list,
  res_object_names = NULL,
  given_height = 0.7
)
}
\arguments{
\item{res_object_list}{An object returned by the
`get_resolution_importance` method.}

\item{res_object_names}{Custom names that the user could assing to each
configuration; if not specified, the plot will use the generated configuration
names.}

\item{given_height}{Used for adjusting the vertical position of the boxplot; the value
will be passed in the `width` argument of the `ggplot::position_dodge` method.}
}
\value{
A ggplot2 object. Different shapes of points indicate different
parameter configuration, while the color
illustrates the frequency of the most common partition. The frequency is calculated
as the fraction between the number of total appearances and the number of
runs.
}
\description{
For each configuration provided in the res_object_list, display what
number of clusters appear for different values of the resolution parameters.
}
\examples{
set.seed(2021)
# create an artificial expression matrix
expr_matrix = matrix(runif(500*10), nrow = 500)

# get the PCA embedding of the data
pca_embedding = irlba::irlba(expr_matrix, nv = 2)
pca_embedding = pca_embedding$u \%*\% diag(pca_embedding$d)
rownames(pca_embedding) = as.character(1:500)

# run the function on the pca embedding
resolution_result = get_resolution_importance(embedding = pca_embedding,
   resolution = c(0.8, 1),
   n_neigh = c(5, 7),
   n_repetitions = 5,
   clustering_method = 1,
   graph_type = 2,
   object_name = "name_example")

plot_k_resolution_corresp(resolution_result)
}
