% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability-based-parameter-assessment.R
\name{get_clustering_difference}
\alias{get_clustering_difference}
\title{Graph Clustering Method Stability}
\usage{
get_clustering_difference(
  graph_adjacency_matrix,
  resolution,
  n_repetitions = 100,
  seed_sequence = NULL,
  ecs_thresh = 1,
  ncores = 1,
  algorithm = 1:4,
  verbose = TRUE
)
}
\arguments{
\item{graph_adjacency_matrix}{A square adjacency matrix based on which an igraph
object will be built.}

\item{resolution}{A sequence of resolution values.}

\item{n_repetitions}{The number of repetitions of applying the pipeline with
different seeds; ignored if seed_sequence is provided by the user.}

\item{seed_sequence}{A custom seed sequence; if the value is NULL, the
sequence will be built starting from 1 with a step of 100.}

\item{ecs_thresh}{The ECS threshold used for merging similar clusterings.}

\item{ncores}{The number of parallel R instances that will run the code.
If the value is set to 1, the code will be run sequentially.}

\item{algorithm}{An index or a list of indexes indicating which community detection
algorithm will be used: Louvain (1), Louvain refined (2), SLM (3) or Leiden (4).
More details can be found in the Seurat's \code{FindClusters} function.}

\item{verbose}{Boolean value used for displaying the progress bar.}
}
\value{
A list having two fields:
\itemize{
\item all - a list that contains, for each clustering method and each resolution
value, the EC consistency between the partitions obtained by changing the seed
\item filtered - similar to \code{all}, but for each configuration, we determine the
number of clusters that appears the most and use only the partitions with this
size
}
}
\description{
Evaluates the stability of different graph clustering methods
in the clustering pipeline. The method will iterate through different values of
the resolution parameter and compare, using the EC Consistency score, the
partitions obtained at different seeds.
}
\examples{
set.seed(2021)
# create an artificial expression matrix
expr_matrix = matrix(runif(100*10), nrow = 100)
rownames(expr_matrix) = as.character(1:100)

adj_matrix = Seurat::FindNeighbors(expr_matrix,
    k.param = 10,
    nn.method = "rann",
    verbose = FALSE,
    compute.SNN = FALSE)$nn
clust_diff_obj = get_clustering_difference(graph_adjacency_matrix = adj_matrix,
    resolution = c(0.5, 1),
    n_repetitions = 10,
    algorithm = 1:2,
    verbose = FALSE)
plot_clustering_difference_boxplot(clust_diff_obj)
}
