% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icp.torus.R, R/methods.R
\name{icp.torus}
\alias{icp.torus}
\alias{logLik.icp.torus}
\alias{predict.icp.torus}
\alias{plot.icp.torus}
\title{Conformity score for inductive prediction sets}
\usage{
icp.torus(
  data,
  split.id = NULL,
  model = c("kmeans", "kde", "mixture"),
  mixturefitmethod = c("axis-aligned", "circular", "general"),
  kmeansfitmethod = c("general", "homogeneous-circular", "heterogeneous-circular",
    "ellipsoids"),
  init = c("kmeans", "hierarchical"),
  additional.condition = TRUE,
  J = 4,
  concentration = 25,
  kmax = 500,
  THRESHOLD = 1e-10,
  maxiter = 200,
  verbose = TRUE,
  ...
)

\method{logLik}{icp.torus}(object, ...)

\method{predict}{icp.torus}(object, newdata, ...)

\method{plot}{icp.torus}(
  x,
  data = NULL,
  level = 0.1,
  ellipse = TRUE,
  out = FALSE,
  type = NULL,
  ...
)
}
\arguments{
\item{data}{n x d matrix of toroidal data on \eqn{[0, 2\pi)^d}
or \eqn{[-\pi, \pi)^d}. Default is \code{NULL}.}

\item{split.id}{a n-dimensional vector consisting of values 1 (estimation)
and 2(evaluation)}

\item{model}{A string. One of "kde", "mixture", and "kmeans" which
determines the model or estimation methods. If "kde", the model is based
on the kernel density estimates. It supports the kde-based conformity score
only. If "mixture", the model is based on the von Mises mixture, fitted
with an EM algorithm. It supports the von Mises mixture and its variants
based conformity scores. If "kmeans", the model is also based on the von
Mises mixture, but the parameter estimation is implemented with the
elliptical k-means algorithm illustrated in Appendix. It supports the
log-max-mixture based conformity score only. If the
dimension of data space is greater than 2, only "kmeans" is supported.
Default is \code{method = "kmeans"}.}

\item{mixturefitmethod}{A string. One of "circular", "axis-aligned", and
"general" which determines the constraint of the EM fitting. Default is
"axis-aligned". This argument only works for \code{method = "mixture"}.}

\item{kmeansfitmethod}{A string. One of "general", ellipsoids",
"heterogeneous-circular" or "homogeneous-circular". If "general", the
elliptical k-means algorithm with no constraint is used. If "ellipsoids",
only the one iteration of the algorithm is used. If"heterogeneous-circular",
the same as above, but with the constraint that ellipsoids must be spheres.
If "homogeneous-circular", the same as above but the radii of the spheres are
identical. Default is "general". This argument only works for method = "kmeans".}

\item{init}{determine the initial parameter of "kmeans" method,
for option "general". Must be "kmeans" or "hierarchical".
If "kmeans", the initial parameters are obtained with extrinsic kmeans
method.
If "hierarchical", the initial parameters are obtained with hierarchical
clustering method.
Default is "kmeans".}

\item{additional.condition}{boolean index.
If \code{TRUE}, a singular matrix will be altered to the scaled identity.}

\item{J}{the number of components for \code{method = c("mixture", "kmeans")}.
Default is \code{J = 4}.}

\item{concentration}{the concentration parameter for \code{method = "kde"}.
Default is \code{concentration = 25}.}

\item{kmax}{the maximal number of kappa. If estimated kappa is
larger than \code{kmax}, then put kappa as \code{kmax}.}

\item{THRESHOLD}{number for difference between updating and
updated parameters. Default is 1e-10.}

\item{maxiter}{the maximal number of iteration. Default is 200.}

\item{verbose}{boolean index, which indicates whether display
additional details as to what the algorithm is doing or
how many loops are done. Moreover, if \code{additional.condition} is
\code{TRUE}, the warning message will be reported.}

\item{...}{additional parameters. For plotting icp.torus, these parameters are for ggplot2::ggplot().}

\item{object}{\code{icp.torus} object}

\item{newdata}{\code{data}}

\item{x}{\code{icp.torus} object}

\item{level}{either a scalar or a vector, or even \code{NULL}. Default value
is 0.1.}

\item{ellipse}{A boolean index which determines whether plotting ellipse-intersections. Default is \code{TRUE}.}

\item{out}{An option for returning the ggplot object. Default is \code{FALSE}.}

\item{type}{A string. One of "mix", "max" or "e". This argument is only available if \code{icp.torus}
object is fitted with method = "mixture". Default is \code{NULL}. If \code{type != NULL}, argument
\code{ellipse} automatically becomes \code{FALSE}. If "mix", it plots based on von Mises mixture.
If "max", it plots based on von Mises max-mixture. If "e", it plots based on ellipse-approximation.}
}
\value{
\code{icp.torus} returns an \code{icp.torus} object, containing all values
  to compute the conformity score (if \code{J} or \code{concentration} is a
  single value). if \code{J} or \code{concentration} is a vector containing
  multiple values, then \code{icp.torus} returns a list of \code{icp.torus} objects
}
\description{
\code{icp.torus} prepares all values
  for computing the conformity score for specified methods.

\code{plot.icp.torus} plots \code{icp.torus} object with some options.
}
\examples{
\donttest{
data <- toydata1[, 1:2]

icp.torus <- icp.torus(data, model = "kmeans",
                       kmeansfitmethod = "general",
                       J = 4, concentration = 25)
}
}
\references{
S. Jung, K. Park, and B. Kim (2021),
  "Clustering on the torus by conformal prediction"
}
