% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyperparam.J.R, R/methods.R
\name{hyperparam.J}
\alias{hyperparam.J}
\alias{plot.hyperparam.J}
\title{Selecting optimal number of mixture components based on various criteria}
\usage{
hyperparam.J(icp.torus.objects, option = c("risk", "AIC", "BIC"))

\method{plot}{hyperparam.J}(x, ...)
}
\arguments{
\item{icp.torus.objects}{a list whose elements are icp.torus objects, generated by
\code{icp.torus}.}

\item{option}{a string one of "risk", "AIC", or "BIC", which determines the criterion
for the model selection. "risk" is based on the negative log-likelihood, "AIC" for the
Akaike Information Criterion, and "BIC" for the Bayesian Information Criterion.}

\item{x}{\code{hyperparam.J} object}

\item{...}{additional parameter for ggplot2::ggplot()}
}
\value{
returns a list object which contains a \code{data.frame} for
  the evaluated criterion corresponding to each number of components, the optimal
  number of components, and the corresponding \code{icp.torus} object.
}
\description{
\code{hyperparam.J} evaluates criterion for each \code{icp.torus} objects, and select
  the optimal number of mixture components based on the evaluated criterion.
}
\examples{
\donttest{
data <- toydata1[,1:2]
n <- nrow(data)
split.id <- rep(2,n)
split.id[ sample(n,floor(n/2)) ] <- 1

Jvec = 4:20
icp.torus.objects <- icp.torus(data, split.id = split.id, model = "kmeans", J = Jvec)

hyperparam.J(icp.torus.objects, option = "AIC")}
}
\references{
Akaike (1974), "A new look at the statistical model identification",
  Schwarz, Gideon E. (1978), "Estimating the dimension of a model"
}
\seealso{
\code{\link[ClusTorus]{icp.torus}}, \code{\link[ClusTorus]{hyperparam.torus}},
  \code{\link[ClusTorus]{hyperparam.alpha}}
}
