% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clus_vus.R
\name{ci_clus_vus}
\alias{ci_clus_vus}
\title{Confidence Intervals for Covariate-specific VUS}
\usage{
ci_clus_vus(x, ci_level = 0.95)
}
\arguments{
\item{x}{an object of class "VUS", a result of \code{\link{clus_vus}} call.}

\item{ci_level}{a confidence level to be used for constructing the confidence interval; default is 0.95.}
}
\value{
\code{ci_clus_vus} returns an object of class inheriting from "ci_VUS" class. An object of class "ci_VUS" is a list, containing at least the following components:

\item{ci_vus_norm}{the normal approximation-based confidence interval for covariate-specific VUS.}
\item{ci_vus_log}{the confidence interval for covariate-specific VUS, after using logit-transformation.}
\item{ci_vus_prob}{the confidence interval for covariate-specific VUS, after using probit-transformation.}
\item{ci_level}{fixed confidence level.}
\item{newdata}{value(s) of covariate(s).}
\item{n_p}{total numbers of the regressors in the model.}
}
\description{
Computes confidence intervals for covariate-specific VUS.
}
\details{
A confidence interval for covariate-specific VUS is given based on normal approximation. If the lower bound (or the upper bound) of the confidence interval is smaller than 0 (or greater than 1), it will be set as 0 (or 1). Also, logit and probit transformations are available if one wants guarantees that confidence limits are inside (0, 1).
}
\seealso{
\code{\link{clus_vus}}
}
