% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.quanti.R
\name{report.quanti}
\alias{report.quanti}
\title{Creates a desc object for "quantitative" statistics reporting}
\usage{
report.quanti(data, y, x1 = NULL, x2 = NULL, y.label = y,
  round = 2, total = F, scientific = F, digits = NULL,
  at.row = NULL, subjid = NULL, geomean = F, add.mad = F)
}
\arguments{
\item{data}{Data.frame object}

\item{y}{Character indicating a numerical vector in the data frame passed to \code{data} argument}

\item{x1}{Character indicating a factor in the data (levels will be displayed in columns)}

\item{x2}{Character indicating a factor in the data (levels will be displayed in lines)}

\item{y.label}{Character Indicates the label for y parameter}

\item{round}{Numeric to indicate how to round statistics}

\item{total}{Logical to indicate if a "Total" column should be added}

\item{scientific}{Logical Indicates if statistics should be displayed in scientific notations or not}

\item{digits}{Numeric (used if scientifc=TRUE) to indicate how many digits to use in scientific notation}

\item{at.row}{Character Used to space the results (see examples)}

\item{subjid}{Character Indicates the column in which there is the subject Id to add the number of subjects in the column header if x1 and x2 are not null.}

\item{geomean}{Logical If yes geometric mean is calculated  instead of arithmetic mean: \code{exp(mean(log(x),na.rm=T))} fpr x>0}

\item{add.mad}{Logical If yes the Median Absolute Deviance is added to the median statistics (see function \code{\link{mad}})}
}
\value{
A desc object.
}
\description{
\code{report.quanti} 
Returns quantitative descriptive statistics such as mean, median, standard deviation etc...
}
\details{
This function computes and reports quantitative statistics on \code{y}. And can gives the statistics by level of two factors (\code{x1}
in columns and/or \code{x2} in rows). 
See the example to show the results. If \code{total=TRUE}, the last column is the statistics
performed overall levels of \code{x1} for each levels of \code{x2}. 
Quantiles are calculated using type 3 (SAS) algorithms.

"geomean" compute the geometric mean defined as exp(mean(log(y))). The values below or equal 0 are removed and
a message is printed  to indicate how many values were deleted to calculate the geometric mean.

\code{N} returns the number of observations (including NA values)
}
\examples{
 
data(data)

# Quantitative statistics with no factor

report.quanti(data=data,y="y_numeric",total=TRUE,y.label="Awesome results")

#' # Quantitative statistics with no factor with geometric mean (option geomean=TRUE)

report.quanti(data=data,y="y_numeric",y.label="Awesome results",geomean=TRUE)

# Quantitative statistics with one factor

report.quanti(data=data,y="y_numeric",x1="GROUP")

# One factor with total column

report.quanti(data=data,y="y_numeric",x1="GROUP",total=TRUE)

# Quantitative statistics with two factors

report.quanti(data=data,y="y_numeric",x1="GROUP",x2="TIMEPOINT")

# Quantitative statistics with two factors and a total column

report.quanti(data=data,y="y_numeric",x1="GROUP",x2="TIMEPOINT",total=TRUE)

# Add median absolute deviance to the median statistics

report.quanti(data=data,y="y_numeric",x1="GROUP",x2="TIMEPOINT",total=TRUE,add.mad=TRUE)

# Quantitative statistics with spacing rows (option at.row)

report.quanti(data=data,y="y_numeric",x1="GROUP",
x2="TIMEPOINT",total=TRUE,at.row="TIMEPOINT")

# Add number of subjects in headers (option subjid)

tab=report.quanti(data=data,y="y_numeric",x1="GROUP",
x2="TIMEPOINT",total=TRUE,at.row="TIMEPOINT",subjid="SUBJID")

# Print tab output
tab

#Getting raw output
tab$raw.output

}
\seealso{
\code{\link{report.quali}} \code{\link{report.doc}} \code{\link{desc}}
}
