% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wishart.R
\name{dWishart}
\alias{dWishart}
\alias{dInvWishart}
\title{Density for Random Wishart Distributed Matrices}
\usage{
dWishart(x, df, Sigma, log = TRUE)

dInvWishart(x, df, Sigma, log = TRUE)
}
\arguments{
\item{x}{positive definite \eqn{p * p} observation for density estimation}

\item{df}{numeric parameter, "degrees of freedom".}

\item{Sigma}{positive definite \eqn{(p * p} "scale" matrix, the matrix parameter of the distribution.}

\item{log}{logical, whether to return value on the log scale.}
}
\value{
Density or log of density
}
\description{
Compute the density of an observation of a random Wishart distributed matrix (\code{dWishart})
or an observation
from the inverse Wishart distribution (\code{dInvWishart}).
}
\details{
If \eqn{X} is distributed as a \eqn{p * p} Wishart random variable with \eqn{n > p} degrees of
freedom and a covariance matrix \eqn{Sigma}, then \eqn{X^{-1} = Y} is distributed as an
inverse Wishart with \eqn{n} degrees of freedom and a covariance matrix \eqn{Sigma^{-1}}. Note there are different ways of parameterizing the
   inverse Wishart distribution, check which one you need.
}
\section{Functions}{
\itemize{
\item \code{dInvWishart}: density for the inverse Wishart distribution.
}}

\examples{
set.seed(20180222)
A <- rWishart(1,10,diag(4))[,,1]
A
dWishart(x = A, df = 10,Sigma = diag(4), log=TRUE)
dInvWishart(x = solve(A), df = 10,Sigma = diag(4), log=TRUE)
}
