% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irlba_pcaSpectra.R
\name{irlba_pcaSpectra}
\alias{irlba_pcaSpectra}
\title{IRLBA PCA of Spectra Objects}
\usage{
irlba_pcaSpectra(spectra, choice = "noscale", n = 3, center = TRUE, ...)
}
\arguments{
\item{spectra}{An object of S3 class \code{\link{Spectra}}.}

\item{choice}{A character string indicating the choice of scaling.  One of
\code{c("noscale"}, \code{"autoscale"}, \code{"Pareto")}. \code{"autoscale"}
is called "standard normal variate" or "correlation matrix PCA" in some literature.}

\item{n}{Integer. The number of components desired.}

\item{center}{Logical.  Should the data be centered?  Data must be centered
for PCA, either before arriving here or via this argument.}

\item{...}{Other parameters to be passed to \code{\link[irlba]{irlba}}.}
}
\value{
A modified object of class \code{prcomp} and \code{computed_via_irlba},
which includes a list element called \code{$method}, a character string describing the
pre-processing carried out and the type of PCA performed (used to annotate
plots).
}
\description{
A wrapper which carries out IRLBA PCA analysis on a
\code{\link{Spectra}} object.  The user can select various options for
scaling.  There is no normalization by rows - do this manually using
\code{\link{normSpectra}}. The data can be supplied already centered
if desired.
}
\details{
The scale choice \code{autoscale} scales the columns by their standard
deviation.  \code{Pareto} scales by the square root of the standard
deviation.
}
\examples{
\dontrun{
# This example assumes the graphics output is set to ggplot2 (see ?GraphicsOptions).
library("ggplot2")
data(SrE.NMR)
pca <- irlba_pcaSpectra(SrE.NMR)

p1 <- plotScree(pca)
p1

p2 <- plotScores(SrE.NMR, pca, pcs = c(1, 2), ellipse = "cls", tol = 0.05)
p2 <- p2 + ggtitle("Scores: SrE NMR Data")
p2

p3 <- plotLoadings(SrE.NMR, pca, loads = 1:2, ref = 1)
p3 <- p3 + ggtitle("Loadings: SrE NMR Data")
p4
}

}
\references{
J. Baglama and L. Reichel, "Augmented Implicitly Restarted Lanczos
Bidiagonalization Methods"  \emph{SIAM J. Sci. Comput.} (2005).
}
\seealso{
\code{\link[irlba]{prcomp_irlba}} for the underlying function,
\code{\link{c_pcaSpectra}} for classical PCA calculations,
\code{\link{r_pcaSpectra}} for robust PCA calculations,
\code{\link{s_pcaSpectra}} for sparse PCA calculations.
Additional documentation at \url{https://bryanhanson.github.io/ChemoSpec/}

For displaying the results, \code{\link{plotScree}},
\code{\link{plotScores}}, \code{\link{plotLoadings}},
\code{\link{plot2Loadings}}, \code{\link{sPlotSpectra}},
\code{\link{plotScores3D}}, \code{\link{plotScoresRGL}}.
}
\author{
Bryan A. Hanson (DePauw University)
}
\keyword{multivariate}
