% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c_pcaSpectra.R
\name{c_pcaSpectra}
\alias{c_pcaSpectra}
\title{Classical PCA of Spectra Objects}
\usage{
c_pcaSpectra(spectra, choice = "noscale", cent = TRUE)
}
\arguments{
\item{spectra}{An object of S3 class \code{\link{Spectra}}.}

\item{choice}{A character string indicating the choice of scaling.  One of
\code{c("noscale"}, \code{"autoscale"}, \code{"Pareto")}. \code{"autoscale"}
is called "standard normal variate" in some literature.}

\item{cent}{Logical: whether or not to center the data.  Always center the
data unless you know it to be already centered.}
}
\value{
An object of class \code{\link{prcomp}}, modified to include a list
element called \code{$method}, a character string describing the
pre-processing carried out and the type of PCA performed (it appears on
plots which you might make).
}
\description{
A wrapper which carries out classical PCA analysis on a
\code{\link{Spectra}} object.  The user can select various options for
scaling.  There is no normalization by rows - do this manually using
\code{\link{normSpectra}}.  There is an option to control centering, but
this is mainly for compatibility with the \code{\link{aov_pcaSpectra}}
series of functions.  Centering the data should always be done in PCA and it
is the default here.
}
\details{
The scale choice \code{autoscale} scales the columns by their standard
deviation.  \code{Pareto} scales by the square root of the standard
deviation.
}
\examples{

data(metMUD1)
pca <- c_pcaSpectra(metMUD1)
plotScores(metMUD1, pca, main = "metMUD1 NMR Data",
	 pcs = c(1,2), ellipse = "cls", tol = 0.05)

}
\references{
K. Varmuza and P. Filzmoser \emph{Introduction to Multivariate
Statistical Analysis in Chemometrics}, CRC Press, 2009.

\url{https://github.com/bryanhanson/ChemoSpec}\cr
}
\seealso{
\code{\link{prcomp}} for the underlying function,
\code{\link{r_pcaSpectra}} for analogous robust PCA calculations.

For displaying the results, \code{\link{plotScree}},
\code{\link{plotScores}}, \code{\link{plotLoadings}},
\code{\link{plot2Loadings}}, \code{\link{sPlotSpectra}},
\code{\link{plotScores3D}}, \code{\link{plotScoresRGL}}.
}
\author{
Bryan A. Hanson, DePauw University.
}
\keyword{multivariate}
