% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chaos01_plot.R
\name{plot.chaos01.res}
\alias{plot.chaos01.res}
\title{Plot Kc based on c}
\usage{
\method{plot}{chaos01.res}(x, ...)
}
\arguments{
\item{x}{the object of "chaos01.res" class, produced by test.chaos01 function when parameter Val = "TRUE".}

\item{...}{arguments to be passed as graphical parameters.}
}
\description{
This function plot results Kc dependent on the value of parameter c as described in Gottwald and Melbourne (2004).
}
\examples{
vec.x <- gen.logistic(mu = 3.55, iter = 2000)

#Output for each value of c
res2 <- testChaos01(vec.x, out = TRUE)

plot(res2)
}
\references{
Gottwald G.A. and Melbourne I. (2004) On the implementation of the 0-1 Test for Chaos, SIAM J. Appl. Dyn. Syst., 8(1), 129–145.
}
\seealso{
\code{\link{testChaos01}}, \code{\link{plot.chaos01}}
}
\keyword{chaos}
\keyword{plot}
\keyword{test}

