% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engine_params.r
\docType{class}
\name{NlmeEngineExtraParams-class}
\alias{NlmeEngineExtraParams-class}
\alias{NlmeEngineExtraParams}
\title{NlmeEngineExtraParams : Defines all extra engine parameters}
\description{
NlmeEngineExtraParams : Defines all extra engine parameters
}
\section{Slots}{

\describe{
\item{\code{isPopulation}}{is this a population model}

\item{\code{method}}{what engine to use
QRPEM = 1|IT2S-EM = 2|FOCE-LB = 3|FO = 4|
       LAPLACIAN = 5|NAIVE-POOLED = 6
The only difference between FOCE-ELS and Laplacian is the setup for the other parameter "PARAMS_FOCEHESE".
If FOCE-ELS is chosen, PARAMS_FOCEHESE = 1. If Laplacian is chosen, PARAMS_FOCEHESE = 0. PARAMS_FOCEHESE arg
should not be provided, and is controlled by the method.}

\item{\code{numIterations}}{maximum number of iterations}

\item{\code{odeToUse}}{What ODE to use
common : ODE_STIFF=2|ODE_NON_STIFF=3|ODE_AUTO_DETECT=5|MATRIX_EXP=6
others : ODE_LSODE=1|ODE_LSODE_ANA_JAC=2|ODE_RK=3|ODE_LSODA=4|
         ODE_LSODA_ANA_JAC=5|MATRIX_EXP=6}

\item{\code{anagrad}}{n  0, or 1 to allow analytic gradients (default 0)}

\item{\code{xnp}}{n  number of nonparametric generations (or 0)}

\item{\code{xrestart}}{n     0, or 1 to restart}

\item{\code{xnorderagq}}{n   number of AGQ points per axis (or 0)}

\item{\code{xfocehess}}{n    0 for numerical hessian, 1 for foce}

\item{\code{xstderr}}{n    0=none, 1=central, 2=forward}

\item{\code{xlameth}}{n    LAGL Method 1, 2, or 3}

\item{\code{xlandig}}{n      LAGL nDigit}

\item{\code{xlatol}}{n       LAGL tolerance}

\item{\code{xblndig}}{n      BLUP Method 1, 2, or 3}

\item{\code{xblndig}}{n      BLUP nDigit}

\item{\code{xbltol}}{n       BLUP tolerance}

\item{\code{xpcwresnrep}}{n  number of reps for PCWRES simulation}

\item{\code{xisample}}{n     number of samples for QRPEM}

\item{\code{xmapassist}}{n   0 (default) or >0, to enable map assist and specify periodicity}

\item{\code{xmapnp}}{n       map naive-pool control}

\item{\code{ximpsampdof}}{n  importance sampling control (-3 to 30)
NORMAL=0
DBL_EXP=1
DIRECT=2
MIXTURE_2=-2
MIXTURE_3=-3}

\item{\code{xmcpem}}{n       0 for QRPEM, 1 for MCPEM}

\item{\code{xsirsamp}}{n     number of SIR samples}

\item{\code{xburnin}}{n      number of burn-in samples}

\item{\code{xnonomegaburn}}{n   0 (default) or 1, to use non-omega burn-in}

\item{\code{xnoburn}}{n   0 (default) or 1, to suppress burn-in}

\item{\code{xstartfromsavedposteriors}}{n   0 (default) or 1, to start from saved posteriors}

\item{\code{xaccratio}}{n    acceptance ratio}

\item{\code{xscramble}}{n    0 for None, 1 for Owen, 2 for Faure-Tezuka}

\item{\code{pardern}}{n      partial derivative # steps}

\item{\code{parderd}}{n      partial derivative delta}

\item{\code{logtran}}{n      0, or 1(default) to enable log-translate of data}
}}

\examples{
param <- NlmeEngineExtraParams(
  method = 3,
  numIterations = 1000
)
param <- NlmeEngineExtraParams(
  method = 1,
  numIterations = 300
)
param <- NlmeEngineExtraParams(
  method = 1,
  numIterations = 300,
  isPopulation = TRUE,
  odeToUse = 2
)
}
\keyword{internal}
