% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_parameter_matrix.R
\name{causal_type_names}
\alias{causal_type_names}
\title{Names for causal types}
\usage{
causal_type_names(causal_types)
}
\arguments{
\item{causal_types}{A \code{data.frame} whose rows containing the 0-1 digits
that conform the causal types.}
}
\value{
A \code{data.frame} whose rows contain the character values that
  conform each causal type in a model.
}
\description{
Names for causal types
}
\examples{
\donttest{
model <- make_model('X -> Y')
possible_types <- grab(model, "nodal_types")
df <- data.frame(expand.grid(possible_types, stringsAsFactors = FALSE))
CausalQueries:::causal_type_names(df)
}
}
\keyword{internal}
