% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_nodal_types.R
\name{get_nodal_types}
\alias{get_nodal_types}
\title{Get list of types for nodes in a DAG}
\usage{
get_nodal_types(model, collapse = TRUE)
}
\arguments{
\item{model}{A \code{causal_model}. A model object generated by
\code{\link{make_model}}.}

\item{collapse}{Logical. If `TRUE`, shows unique nodal types for each node.
If `FALSE`, shows for each node a matrix with nodal types as rows and
parent types as columns, if applicable. Defaults to `TRUE`.}
}
\value{
A named \code{list} of nodal types for each parent in a DAG
}
\description{
As type labels are hard to interpret for large models, the type list
includes an attribute to help interpret them.
See  \code{attr(types, interpret)}
}
\examples{
\donttest{
model <- make_model('X -> K -> Y')
get_nodal_types(model)

model <- make_model('X -> K -> Y') \%>\%
   set_restrictions(statement = 'K[X=1]>K[X=0]') \%>\%
   set_confound(list(K = 'Y[K=1]>Y[K=0]'))
get_nodal_types(model)
}

}
