% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atoms.R
\name{.decomp_quad}
\alias{.decomp_quad}
\title{Compute a Matrix Decomposition.}
\usage{
.decomp_quad(P, cond = NA, rcond = NA)
}
\arguments{
\item{P}{A real symmetric positive or negative (semi)definite input matrix}

\item{cond}{Cutoff for small eigenvalues. Singular values smaller than rcond * largest_eigenvalue are considered negligible.}

\item{rcond}{Cutoff for small eigenvalues. Singular values smaller than rcond * largest_eigenvalue are considered negligible.}
}
\value{
A list consisting of induced matrix 2-norm of P and a rectangular matrix such that P = scale * (dot(M1, t(M1)) - dot(M2, t(M2)))
}
\description{
Compute sgn, scale, M such that \eqn{P = sgn * scale * dot(M, t(M))}.
}
