% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\docType{methods}
\name{grad}
\alias{grad}
\title{Sub/Super-Gradient}
\usage{
grad(object)
}
\arguments{
\item{object}{An \linkS4class{Expression} object.}
}
\value{
A list mapping each variable to a sparse matrix.
}
\description{
The (sub/super)-gradient of the expression with respect to each variable.
Matrix expressions are vectorized, so the gradient is a matrix. \code{NA} indicates variable values are unknown or outside the domain.
}
\examples{
x <- Variable(2, name = "x")
A <- Variable(2, 2, name = "A")

value(x) <- c(-3,4)
expr <- p_norm(x, 2)
grad(expr)

value(A) <- rbind(c(3,-4), c(4,3))
expr <- p_norm(A, 0.5)
grad(expr)

value(A) <- cbind(c(1,2), c(-1,0))
expr <- abs(A)
grad(expr)
}
