% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/problem.R
\docType{methods}
\name{psolve}
\alias{psolve}
\alias{solve}
\alias{psolve,Problem-method}
\alias{solve,Problem,ANY-method}
\title{Solve a DCP Problem}
\usage{
psolve(
  object,
  solver = NA,
  ignore_dcp = FALSE,
  warm_start = FALSE,
  verbose = FALSE,
  parallel = FALSE,
  gp = FALSE,
  feastol = NULL,
  reltol = NULL,
  abstol = NULL,
  num_iter = NULL,
  ...
)

\S4method{psolve}{Problem}(
  object,
  solver = NA,
  ignore_dcp = FALSE,
  warm_start = FALSE,
  verbose = FALSE,
  parallel = FALSE,
  gp = FALSE,
  feastol = NULL,
  reltol = NULL,
  abstol = NULL,
  num_iter = NULL,
  ...
)

\S4method{solve}{Problem,ANY}(a, b = NA, ...)
}
\arguments{
\item{object, a}{A \linkS4class{Problem} object.}

\item{solver, b}{(Optional) A string indicating the solver to use. Defaults to "ECOS".}

\item{ignore_dcp}{(Optional) A logical value indicating whether to override the DCP check for a problem.}

\item{warm_start}{(Optional) A logical value indicating whether the previous solver result should be used to warm start.}

\item{verbose}{(Optional) A logical value indicating whether to print additional solver output.}

\item{parallel}{(Optional) A logical value indicating whether to solve in parallel if the problem is separable.}

\item{gp}{(Optional) A logical value indicating whether the problem is a geometric program. Defaults to \code{FALSE}.}

\item{feastol}{The feasible tolerance on the primal and dual residual.}

\item{reltol}{The relative tolerance on the duality gap.}

\item{abstol}{The absolute tolerance on the duality gap.}

\item{num_iter}{The maximum number of iterations.}

\item{...}{Additional options that will be passed to the specific solver. In general, these options will override any default settings imposed by CVXR.}
}
\value{
A list containing the solution to the problem:
\describe{
   \item{\code{status}}{The status of the solution. Can be "optimal", "optimal_inaccurate", "infeasible", "infeasible_inaccurate", "unbounded", "unbounded_inaccurate", or "solver_error".}
   \item{\code{value}}{The optimal value of the objective function.}
   \item{\code{solver}}{The name of the solver.}
   \item{\code{solve_time}}{The time (in seconds) it took for the solver to solve the problem.}
   \item{\code{setup_time}}{The time (in seconds) it took for the solver to set up the problem.}
   \item{\code{num_iters}}{The number of iterations the solver had to go through to find a solution.}
   \item{\code{getValue}}{A function that takes a \linkS4class{Variable} object and retrieves its primal value.}
   \item{\code{getDualValue}}{A function that takes a \linkS4class{Constraint} object and retrieves its dual value(s).}
}
}
\description{
Solve a DCP compliant optimization problem.
}
\examples{
a <- Variable(name = "a")
prob <- Problem(Minimize(norm_inf(a)), list(a >= 2))
result <- psolve(prob, solver = "ECOS", verbose = TRUE)
result$status
result$value
result$getValue(a)
result$getDualValue(constraints(prob)[[1]])
}
